<?php
/** @var $senderInfo User */

$this->breadcrumbs = array(
    Yii::t('common', 'Mailing messages'),
);


$this->menu = array(
    AdminLteHelper::getMenuLink($senderInfo->email, 'mailto:'.$senderInfo->email, 'fa fa-envelope'),
);

if($senderInfo->phone){
    $this->menu[] = AdminLteHelper::getMenuLink($senderInfo->phone, 'tel:'.str_replace(' ', '', $senderInfo->phone), 'fa fa-phone');
}

$this->menu[] = AdminLteHelper::getMenuLink(tt('all_member_listings', 'apartments') . ' (' . $senderInfo->countAd . ')', $senderInfo->getUrl(), 'fa fa-list');

$this->adminTitle = tt('History messages with user', 'messages') . ' "' . $senderInfo->username . '"';

$avaUrl = $senderInfo->ava ? $senderInfo->getAvaSrcThumb() : Yii::app()->theme->baseUrl . '/images/ava-default.jpg';

$additionalInfo = $senderInfo->getStrByLang('additional_info');
?>

<div class="form">

    <div class="row">
        <div style="width: 150px;" class="col-sm-2">
            <a href="<?= $senderInfo->getUrl() ?>" class="thumbnail">
                <?= CHtml::image($avaUrl, $senderInfo->username, array('class' => 'message_ava ')); ?>
            </a>
        </div>
        <div class="col-sm-2">
            <strong><?= $senderInfo->getTypeName() ?></strong>
            <?php
            if($additionalInfo){
                echo "<p>$additionalInfo</p>";
            }
            ?>
        </div>
    </div>

    <div class="clearfix"></div>

    <?php $this->renderPartial('//../modules/messages/views/backend/__form_message', array('model' => $model, 'uid' => $uid)); ?>
</div>

<div class="box_message">
    <?php if ($allMessages) : ?>
        <?php foreach ($allMessages as $item) : ?>
            <?php
            $addClass = '';
            if ($item->id_userFrom == Yii::app()->user->id)
                $addClass .= 'i-message';
            else
                $addClass .= 'other-message';

            if ($item->is_deleted == Messages::MESSAGE_DELETED) {
                $addClass .= ' message-deleted';
            }

            ?>
            <div class="message_contact_read <?php echo $addClass; ?>">
                <?php if ($item->is_deleted == Messages::MESSAGE_DELETED): ?>
                    <div class="is-message-deleted-desr">
                        <?php echo tc('Message deleted by user'); ?>
                    </div>
                <?php endif; ?>

                <?php
                echo CHtml::link(
                    '', array('/messages/main/deleteMessage', 'id' => $item->id, 'idFrom' => $uid), array(
                        'confirm' => tc('Are you sure you want to delete this item?'),
                        'csrf' => true,
                        'class' => 'delete_message',
                    )
                );

                ?>

                <div class="message_contact_message">
                    <h3 class="author">
                        <?php if ($item->id_userFrom == Yii::app()->user->id): ?>
                            <?php echo tt('I am', 'messages'); ?>
                            <?php if ($item->is_read == Messages::STATUS_READ_USER): ?>
                                <span class="badge bg-green"><?php echo tt('Read by user', 'messages'); ?></span>
                            <?php else: ?>
                                <span class="badge bg-red"><?php echo tt('Unread', 'messages'); ?></span>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php echo CHtml::encode($item->userInfoFrom->username); ?>
                        <?php endif; ?>
                    </h3>
                    <span class="message_contact_date">
                        <?php echo $item->date_send; ?>
                    </span>
                    <?php $fromListingPage = Messages::getFromListingHtml($item); ?>
                    <?php if (!empty($fromListingPage)): ?>
                        <div class="message_contact_from_listing">
                            <?php echo tc('From listing page'); ?>:&nbsp;<?php echo $fromListingPage; ?>
                        </div>
                    <?php endif; ?>

                    <blockquote><?php echo Messages::messageFormat($item); ?></blockquote>
                </div>

                <?php if (isset($item->messagesFiles) && $item->messagesFiles) : ?>
                    <div class="message_contact_message">
                        <p class="files"><strong><?php echo tt('Files', 'messages'); ?></strong>:</p>
                        <p><?php echo Messages::getFiles($item); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<?php if (isset($pages) && $pages->pageCount > 1) : ?>
    <div class="clear"></div>
    <div class="pagination">
        <?php $this->widget('bootstrap.widgets.TbPager', array('pages' => $pages, 'header' => '')); ?>
    </div>
    <div class="clear"></div>
<?php endif; ?>
