<?php
$this->breadcrumbs = array(
    Yii::t('common', 'Mailing messages'),
);

$this->adminTitle = Yii::t('common', 'Mailing messages');

?>

<?php
$this->renderPartial('_search', array(
        'messageModel' => $messageModel,
        'model' => $model,
    )
);

?>

<div class="form">
    <?php
    $form = $this->beginWidget('CustomForm', array(
        'action' => Yii::app()->createUrl('/messages/backend/mailing/sendmessages'),
        'htmlOptions' => array('enctype' => 'multipart/form-data', 'class' => 'well form-disable-button-after-submit'),
        'enableAjaxValidation' => false,
        'id' => 'message-form',
        'method' => 'POST'
    ));

    ?>

    <?php echo $form->errorSummary($messageModel); ?>

    <?php
    if (!$messageModel->message) {
        $messageModel->message = '<p>' . tt('Hello {username}', 'messages') . '</p>';
    }

    ?>

    <div class="form-group">
        <div class='flash-notice'><?php echo Yii::t('module_messages', 'max_newsletter_limit', array('{n}' => Mailing::MAILING_USERS_LIMIT)); ?></div>

        <?php
        $columns = array(
            array(
                'class' => 'CCheckBoxColumn',
                'id' => 'itemsSelected',
                'value' => '$data->id',
                'checked' => 'true',
                'selectableRows' => '2',
                'htmlOptions' => array(
                    'class' => 'center',
                    'data-title' => tc('Actions'),
                ),
            ),
            array(
                'name' => 'username',
                'htmlOptions' => array(
                    'data-title' => tt('User name', 'users'),
                ),
            ),
            array(
                'name' => 'type',
                'value' => '$data->getTypeName()',
                'filter' => User::getTypeList(),
                'htmlOptions' => array(
                    'data-title' => tc('Type'),
                ),
            ),
            array(
                'name' => 'phone',
                'htmlOptions' => array(
                    'data-title' => Yii::t('common', 'Phone number'),
                ),
            ),
            array(
                'name' => 'email',
                'htmlOptions' => array(
                    'data-title' => tt('E-mail', 'users'),
                ),
            ),
        );

        $this->widget('CustomGridView', array(
            'allowNoMoreTables' => true,
            'id' => 'message-mailing-grid',
            'afterAjaxUpdate' => 'function(){attachStickyTableHeader();}',
            'dataProvider' => $model->search(),
            'filter' => $model,
            'afterAjaxUpdate' => 'function(){$("a[rel=\'tooltip\']").tooltip(); $("div.tooltip-arrow").remove(); $("div.tooltip-inner").remove();}',
            'columns' => $columns
        ));

        ?>
        <div class="clear">&nbsp;</div>
    </div>
    <hr/>

    <div class="form-group">
        <?php echo $form->labelEx($messageModel, 'message'); ?>
        <?php //echo $form->textArea($messageModel, 'message', array('class' => 'textarea-message')); ?>
        <?php
        $this->widget('CustomEditor', array(
            'model' => $messageModel,
            'attribute' => 'message',
            'htmlOptions' => array('id' => 'message')
        ));

        ?>
        <?php echo $form->error($messageModel, 'message'); ?>
    </div>
    <div class="padding-bottom10">
        <span class="label label-info">
            <?php echo tt('message_macros_help', 'messages'); ?>
        </span>
    </div>
    <div class="clear">&nbsp;</div>

    <div class="form-group">
        <?php echo $form->labelEx($messageModel, 'file'); ?>

        <div class="padding-bottom10">
            <span class="label label-info">
                <?php echo Yii::t('module_messages', 'Supported file: {supportExt}.', array('{supportExt}' => $messageModel->supportExt)) . ''; ?>
            </span>
            <br/>
            <span class="label label-info">
                <?php echo Yii::t('module_messages', 'Max file size: {fileMaxSize}.', array('{fileMaxSize}' => formatBytes($messageModel->fileMaxSize))) . ''; ?>
            </span>
        </div>

        <?php
        $this->widget('CMultiFileUpload', array(
            'name' => 'files',
            'accept' => "{$messageModel->supportExtForUploader}",
            'duplicate' => '' . tt("The selected file has already been added!", "messages") . '',
            'denied' => '' . tt("Unsupported file type!", "messages") . '',
        ));

        ?>
        <?php echo $form->error($messageModel, 'file'); ?>
    </div>
    <div class="clear">&nbsp;</div>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton(tt('Send', 'messages'));

        ?>
    </div>
    <div class="clear">&nbsp;</div>
    <?php $this->endWidget(); ?>
</div>
