<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

class MainController extends ModuleUserController
{

    public $modelName = 'Menu';

    public function actions()
    {
        $return = array();
        if (param('useJQuerySimpleCaptcha', 0)) {
            $return['captcha'] = array(
                'class' => 'jQuerySimpleCCaptchaAction',
                'backColor' => 0xFFFFFF,
            );
        } else {
            $return['captcha'] = array(
                'class' => 'MathCCaptchaAction',
                'backColor' => 0xFFFFFF,
            );
        }

        return $return;
    }

    public function actionIndex()
    {
        if (Yii::app()->user->checkAccess('backend_access')) {
            $this->redirect(array('/menumanager/backend/main/admin'));
            return;
        }
        $this->redirect(array('/site/index'));
    }

    public function actionView($id = 0, $url = '')
    {
        if ($url && issetModule('seo')) {
            $seo = SeoFriendlyUrl::getForView($url, $this->modelName);

            if (!$seo) {
                throw404();
            }

            $this->setSeo($seo);

            $id = $seo->model_id;
        }
        $model = $this->loadModel($id);

        if ($model) {
            if (Yii::app()->request->getParam('is_ajax')) {
                $this->renderPartial('view', array('model' => $model), false, true);
            } else {
                $this->render('view', array('model' => $model));
            }
        } else {
            Yii::app()->user->setFlash('error', tc('Page not found.'));
            $this->redirect(array('/site/index'));
        }
    }
}
