<div class="form">

    <?php
    $form = $this->beginWidget('CustomForm', array(
        'id' => $this->modelName . '-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('class' => 'well form-disable-button-after-submit'),
    ));
    echo CHtml::hiddenField('addValues', 0, array('id' => 'addValues'));

    ?>
    <p class="note"><?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?></p>

    <?php echo $form->errorSummary($model); ?>

    <div class="form-group">
        <?php echo $form->labelEx($model, 'country_id'); ?>
        <?php echo $form->dropDownList($model, 'country_id', Country::getCountriesArray(0, 1)); ?>
        <?php echo $form->error($model, 'country_id'); ?>
    </div>

    <?php
    $this->widget('application.modules.lang.components.langFieldWidget', array(
        'model' => $model,
        'field' => 'name',
        'type' => 'string'
    ));

    ?>
    <div class="clear"></div>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton(tc('Save'));

        ?>

        <?php
        echo AdminLteHelper::getSubmitButton(tt('Save and add cities'), array(
            'onclick' => '$("#addValues").val(1)',
        ));

        ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->