<div class="form">

    <?php
    $form = $this->beginWidget('CustomForm', array(
        'id' => $this->modelName . '-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data', 'class' => 'well form-disable-button-after-submit'),
    ));
    echo CHtml::hiddenField('addMore', 0, array('id' => 'addMore'));

    ?>

    <p class="note"><?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?></p>

    <?php echo $form->errorSummary($model); ?>

    <div class="form-group">
        <?php echo $form->labelEx($model, 'country_id'); ?>
        <?php
        echo $form->dropDownList($model, 'country_id', Country::getCountriesArray(0, 1), array('id' => 'ap_country',
                'ajax' => array(
                    'type' => 'GET', //request type
                    'url' => $this->createUrl('/location/main/getRegions'), //url to call.
                    //Style: CController::createUrl('currentController/methodToCall')
                    'update' => '#ap_region', //selector to update
                    'data' => 'js:"country="+$("#ap_country").val()+"&all=1"'
                    //leave out the data key to pass all form values through
                )
            )
        );

        ?>
        <?php echo $form->error($model, 'country_id'); ?>
    </div>

    <?php
    //при создании города узнаём id первой в дропдауне страны
    if ($model->country_id) {
        $country = $model->country_id;
    } else {
        $country_keys = array_keys(Country::getCountriesArray(0, 1));
        $country = isset($country_keys[0]) ? $country_keys[0] : 0;
    }

    ?>
    <div class="form-group">
        <?php echo $form->labelEx($model, 'region_id'); ?>
        <?php echo $form->dropDownList($model, 'region_id', Region::getRegionsArray($country, 0, 1), array('id' => 'ap_region')); ?>
        <?php echo $form->error($model, 'region_id'); ?>
    </div>

    <?php
    $this->widget('application.modules.lang.components.langFieldWidget', array(
        'model' => $model,
        'field' => 'name',
        'type' => 'string'
    ));

    ?>
    <div class="clear"></div>

    <div class="well">
        <?php
        if (isset($model->image) && $model->image) {
            $src = $model->image->getSmallThumbLink();
            if ($src) {
                echo CHtml::link(CHtml::image($src, $model->getStrByLang('name')), $model->image->fullHref(), array('class' => 'fancy'));

                if (issetModule('seo') && !$model->isNewRecord) {
                    $this->widget('application.modules.seo.components.SeoImageWidget', array(
                        'model' => $model->image,
                        'showLink' => true,
                        'showForm' => false,
                        'showJS' => false,
                    ));
                }

                echo '<div style="padding-top: 3px;">' . CHtml::button(tc('Delete'), array(
                        'onclick' => 'document.location.href="' . $this->createUrl('/images/backend/main/deleteImg', array(
                                'id' => $model->image->id,
                                'mid' => $model->id,
                                'rUrl' => Yii::app()->createUrl('/location/backend/city/update', array('id' => $model->id)),
                            )) . '";'
                    )) . '</div>';
            }

            echo '
					<div class="clear"></div>
					<br />
				';
        }

        ?>
        <?php echo $form->fileFieldControlGroup($model, 'cityImage', array()); ?>
        <div class="padding-bottom10">
            <span class="label label-info">
                <?php echo Yii::t('module_apartments', 'Supported file: {supportExt}.', array('{supportExt}' => ObjectImage::getSupportExt())); ?>
            </span>
        </div>
    </div>
    <br/>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton($model->isNewRecord ? tc('Add') : tc('Save'));

        ?>

        <?php
        if ($model->isNewRecord) {
            echo AdminLteHelper::getSubmitButton(tc('Add and continue'), array(
                'onclick' => '$("#addMore").val(1)',
            ));
        }

        ?>
    </div>

    <?php $this->endWidget(); ?>

    <?php
    if (issetModule('seo') && !$model->isNewRecord) {

        $this->widget('application.modules.seo.components.SeoImageWidget', array(
            'model' => $model->image,
            'showLink' => false,
            'showForm' => true,
            'showJS' => true,
        ));

        $this->widget('application.modules.seo.components.SeoWidget', array(
            'model' => $model,
            'showBodyTextField' => true,
        ));
    }

    ?>
</div><!-- form -->