

DROP TABLE IF EXISTS `{dbPrefix}advertising`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}advertising` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `views` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `clicks` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `type` enum('file','html','js') NOT NULL DEFAULT 'file',
  `position` enum('pos1','pos2','pos3','pos4','pos5','pos6') NOT NULL DEFAULT 'pos1',
  `file_path` varchar(255) NOT NULL DEFAULT '',
  `html_ru` text NULL,
  `html_en` text NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `alt_text` text NULL,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `html_de` text NULL,
  `js_ru` text NULL,
  `js_en` text NULL,
  `js_de` text NULL,
  `html_es` text NULL,
  `js_es` text NULL,
  `html_ar` text NULL,
  `js_ar` text NULL,
  `html_tr` text NULL,
  `js_tr` text NULL,
  PRIMARY KEY (`id`),
  KEY `position` (`position`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}advertising_area`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}advertising_area` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `id_advertising` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `page` varchar(255) NOT NULL DEFAULT '',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_advertising` (`id_advertising`),
  KEY `page` (`page`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}apartment`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `parse_from` varchar(20) NOT NULL DEFAULT '' COMMENT 'С какого сайта спарсено',
  `parse_internal_id` varchar(50) NOT NULL DEFAULT '0' COMMENT 'Внутренний ID с сайта-донора',
  `parse_internal_url` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Ссылка на объект на сайте-доноре',
  `parse_owner_info_name` varchar(100) NOT NULL DEFAULT '',
  `parse_owner_info_phone` varchar(20) NOT NULL DEFAULT '',
  `parse_owner_info_user_type` varchar(40) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `obj_type_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `loc_country` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `loc_region` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `loc_city` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `city_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `visits` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_manual_updated` timestamp NULL DEFAULT NULL,
  `date_end_activity` timestamp NULL DEFAULT NULL,
  `activity_always` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `is_price_poa` tinyint(4) UNSIGNED NOT NULL DEFAULT '0',
  `price` BIGINT(11) UNSIGNED NOT NULL DEFAULT '0',
  `price_to` BIGINT(11) UNSIGNED NOT NULL DEFAULT '0',
  `num_of_rooms` tinyint(4) NOT NULL DEFAULT '0',
  `floor` tinyint(4) NOT NULL DEFAULT '0',
  `floor_total` tinyint(4) NOT NULL DEFAULT '0',
  `square` float NOT NULL DEFAULT '0',
  `land_square` float NOT NULL DEFAULT '0',
  `window_to` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `title_ru` text NULL,
  `description_ru` text NULL,
  `description_near_ru` text NULL,
  `address_ru` varchar(255) NOT NULL DEFAULT '',
  `berths` varchar(100) NOT NULL DEFAULT '',
  `active` tinyint(4) NOT NULL DEFAULT '0',
  `lat` varchar(25) NOT NULL DEFAULT '0',
  `lng` varchar(25) NOT NULL DEFAULT '0',
  `rating` tinyint(4) NOT NULL DEFAULT '0',
  `date_up_search` timestamp NULL DEFAULT NULL,
  `is_special_offer` tinyint(4) NOT NULL DEFAULT '0',
  `is_free_to` timestamp NULL DEFAULT NULL,
  `price_type` tinyint(1) UNSIGNED NOT NULL DEFAULT '5',
  `sorter` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `owner_active` tinyint(4) NOT NULL DEFAULT '0',
  `owner_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `description_near_en` text NULL,
  `address_en` varchar(255) NOT NULL DEFAULT '',
  `title_en` text NULL,
  `description_en` text NULL,
  `exchange_to_ru` text NULL,
  `exchange_to_en` text NULL,
  `exchange_to_de` text NULL,
  `title_de` text NULL,
  `address_de` varchar(255) NOT NULL DEFAULT '',
  `description_de` text NULL,
  `description_near_de` text NULL,
  `note` text NULL,
  `phone` varchar(20) NOT NULL DEFAULT '',
  `autoVKPostId` varchar(50) NOT NULL DEFAULT '',
  `autoFBPostId` varchar(50) NOT NULL DEFAULT '',
  `autoTwitterPostId` varchar(50) NOT NULL DEFAULT '',
  `count_img` tinyint(3) NOT NULL DEFAULT '0',
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  `parent_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `title_es` text NULL,
  `address_es` varchar(255) NOT NULL DEFAULT '',
  `description_es` text NULL,
  `description_near_es` text NULL,
  `exchange_to_es` text NULL,
  `title_ar` text NULL,
  `address_ar` varchar(255) NOT NULL DEFAULT '',
  `description_ar` text NULL,
  `description_near_ar` text NULL,
  `exchange_to_ar` text NULL,
  `open_plan` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `room_type` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `balcony_type` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `wc_type` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `floor_coat` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `garage_type` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `build_year` varchar(50) NOT NULL DEFAULT '',
  `repair` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `object_state` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `building_type` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `plot_type` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `title_tr` text NULL,
  `address_tr` varchar(255) NOT NULL DEFAULT '',
  `description_tr` text NULL,
  `description_near_tr` text NULL,
  `exchange_to_tr` text NULL,
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`),
  KEY `obj_type_id` (`obj_type_id`),
  KEY `loc_country` (`loc_country`),
  KEY `loc_region` (`loc_region`),
  KEY `loc_city` (`loc_city`),
  KEY `city_id` (`city_id`),
  KEY `sorter` (`sorter`),
  KEY `fullActive` (`active`,`owner_active`),
  KEY `priceType_fullActive` (`price_type`,`active`,`owner_active`),
  KEY `type_fullActive` (`type`,`active`,`owner_active`),
  KEY `type_priceType_fullActive` (`type`,`price_type`,`active`,`owner_active`),
  KEY `country_type_priceType_fullActive` (`loc_country`,`type`,`price_type`,`active`,`owner_active`),
  KEY `halfActive` (`active`),
  KEY `priceType_halfActive` (`price_type`,`active`),
  KEY `type_halfActive` (`type`,`active`),
  KEY `type_priceType_halfActive` (`type`,`price_type`,`active`),
  KEY `country_type_priceType_halfActive` (`loc_country`,`type`,`price_type`,`active`),
  KEY `specialActiveDeleted` (`is_special_offer`,`active`,`deleted`),
  KEY `halfActiveLocCity` (`loc_city`,`active`),
  KEY `halfActiveCity` (`city_id`,`active`),
  KEY `fullActiveLocCity` (`loc_city`,`active`,`owner_active`),
  KEY `fullActiveCity` (`city_id`,`active`,`owner_active`),
  KEY `halfActiveObjTypeLocCity` (`obj_type_id`, `loc_city`,`active`),
  KEY `halfActiveObjTypeCity` (`obj_type_id`, `city_id`,`active`),
  KEY `fullActiveObjTypeLocCity` (`obj_type_id`, `loc_city`,`active`,`owner_active`),
  KEY `fullActiveObjTypeCity` (`obj_type_id`, `city_id`,`active`,`owner_active`),
  KEY `sorterActive` (`sorter`,`active`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment` (`id`, `parse_from`, `parse_internal_id`, `parse_internal_url`, `parse_owner_info_name`, `parse_owner_info_phone`, `parse_owner_info_user_type`, `type`, `obj_type_id`, `loc_country`, `loc_region`, `loc_city`, `city_id`, `visits`, `date_updated`, `date_created`, `date_manual_updated`, `date_end_activity`, `activity_always`, `is_price_poa`, `price`, `price_to`, `num_of_rooms`, `floor`, `floor_total`, `square`, `land_square`, `window_to`, `title_ru`, `description_ru`, `description_near_ru`, `address_ru`, `berths`, `active`, `lat`, `lng`, `rating`, `date_up_search`, `is_special_offer`, `is_free_to`, `price_type`, `sorter`, `owner_active`, `owner_id`, `description_near_en`, `address_en`, `title_en`, `description_en`, `exchange_to_ru`, `exchange_to_en`, `exchange_to_de`, `title_de`, `address_de`, `description_de`, `description_near_de`, `note`, `phone`, `autoVKPostId`, `autoFBPostId`, `autoTwitterPostId`, `count_img`, `deleted`, `parent_id`, `title_es`, `address_es`, `description_es`, `description_near_es`, `exchange_to_es`, `title_ar`, `address_ar`, `description_ar`, `description_near_ar`, `exchange_to_ar`, `open_plan`, `room_type`, `balcony_type`, `wc_type`, `floor_coat`, `garage_type`, `build_year`, `repair`, `object_state`, `building_type`, `plot_type`, `title_tr`, `address_tr`, `description_tr`, `description_near_tr`, `exchange_to_tr`) VALUES
(18, '', '0', '0', '', '', '', 1, 1, 225, 5128638, 5128581, 8, 0, '2020-03-16 11:14:58', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 400, 0, 3, 4, 9, 60, 0, 2, 'квартира на ул. Авиамоторная', '<p>2 комнатная квартира на улице Авиамоторная 22/12</p>', 'В двух шагах до метро', 'Авиамоторная 22/12', '', 1, '55.748873', '37.7184591', 0, NULL, 0, NULL, 4, 3, 1, 2, 'Near metro station', 'Aviamotornay St., 22/12', '2-Bedroom Apartment, Aviamotornaya St.', '<p>2-Bedroom Apartment on Aviamotornaya St.</p>', '', '', '', 'Wohnung in der Aviamotornaja Straße', 'Aviamotornaja Str., 22/12', '<p>3-Zimmer-Wohnung in der Aviamotornaja Straße, 22/12</p>', 'der U-Bahn-Haltestelle', '', '', '', '', '', 4, 0, 0, 'Apartamento 2 dormitorios, Aviamotornaya St.', 'Aviamotornay St., 22/12', '<p>2-Bedroom Apartment on Aviamotornaya St.</p>', 'Near metro station', '', 'شقة 2 نوم، Aviamotornaya شارع.', 'Aviamotornaya شارع، 22/12', '<p>شقة 2 نوم على Aviamotornaya شارع.</p>', 'بالقرب من محطة المترو', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, '2 Yatak Odalı Daire, St. Aviamotornaya', 'Aviamotornay St., Güncelleme 22 / 12', '<p>Aviamotornaya St 2 yatak Odalı Daire </p>', 'Metro istasyonuna yakın ', ''),
(19, '', '0', '0', '', '', '', 1, 2, 225, 5128638, 5128581, 8, 0, '2020-03-16 11:14:54', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 1300, 0, 6, 0, 2, 120, 0, 1, 'дом на ул. Трубецкая ', '<p>Уютный дом на улице Трубецкая</p>', '', 'ул. Трубецкая', '3', 1, '55.72885', '37.5741798', 0, NULL, 0, NULL, 5, 4, 1, 2, '', 'Trubetskaya St.', 'House on Trubetskaya St.', '<p>A cosy house on Trubetskaya St.</p>', '', '', '', 'Haus in der Trubetskaja Straße', 'Trubetskaja Str.', '<p>Ein bequemes Haus in der Trubetskaja Straße</p>', '', '', '', '', '', '', 3, 0, 0, 'Casa en San Trubetskaya', 'Trubetskaya St.', '<p>A cosy house on Trubetskaya St.</p>', '', '', 'منزل في سانت Trubetskaya', 'منزل في سانت Trubetskaya', '<p>بيت دافئ في سانت Trubetskaya</p>', '', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Trubetskaya St. evi ', 'Trubetskaya St.', '<p>Trubetskaya St şirin bir ev </p>', '', ''),
(20, '', '0', '0', '', '', '', 1, 2, 185, 524894, 524901, 7, 0, '2020-03-16 11:14:54', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 250, 0, 5, 2, 2, 170, 0, 2, 'Челобитьевское шоссе', '<p>Дом на Челобитьевском шоссе</p>', 'ТЦ \"Ашан\"', 'Челобитьевское шоссе', '2', 1, '55.9162225', '37.5509652', 0, NULL, 0, NULL, 3, 5, 1, 2, 'Moll \"Ashan\"', 'Chelobitevskoe Highway', 'Chelobitevskoe highway', '<p>House on Chelobitevskoe Highway</p>', '', '', '', 'Tschelobitjevskoe Schosse', 'Tschelobitjevskoe Fahrstraße', '<p>Haus in Tschelobitjevskoe Fahrstraße</p>', 'Einkaufszentrum \"Aschan\"', '', '', '', '', '', 3, 0, 0, 'Carretera Chelobitevskoe', 'Chelobitevskoe Highway', '<p>House on Chelobitevskoe Highway</p>', 'Moll \"Ashan\"', '', 'الطريق السريع Chelobitevskoe', 'الطريق السريع Chelobitevskoe', '<p>منزل على الطريق السريع Chelobitevskoe</p>', 'مول \"عشان\"', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Chelobitevskoe karayolu', 'Chelobitevskoe Karayolu', '<p>Chelobitevskoe Karayolu üzerinde ev </p>', 'Moll \"Ashan\"', ''),
(21, '', '0', '0', '', '', '', 1, 1, 185, 524894, 524901, 7, 0, '2020-03-16 11:14:55', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 40, 0, 1, 2, 10, 40, 0, 1, 'Однокомнатная квартира Псковская улица', '<p>Однокомнатная квартира на улице Псковская</p>', '', 'улица Псковская, 10К1', '1', 1, '55.9034239', '37.5502048', 0, NULL, 0, NULL, 3, 6, 1, 2, '', 'Pskovskaya St., 10К1', 'Apartment, Pskovskaya St.', '<p>Apartment on Pskovskaya St.</p>', '', '', '', '1-Zimmer-Wohnung in der Pskovskaja Straße', 'Pskovskaja Str., 10К1', '<p>1-Zimmer-Wohnung in der Pskovskaja Straße</p>', '', '', '', '', '', '', 3, 0, 0, 'Apartamento, Pskovskaya St.', 'Pskovskaya St., 10К1', '<p>Apartment on Pskovskaya St.</p>', '', '', 'شقة، وسانت بسكوف', 'سانت بسكوف، 10К1', '<p>شقة في سانت بسكوف</p>', '', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Daire, Pskovskaya St.', 'Pskovskaya St., 10К1', '<p>Pskovskaya St. Daire </p>', '', ''),
(22, '', '0', '0', '', '', '', 1, 2, 185, 524894, 524901, 7, 0, '2020-03-16 11:14:58', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 500, 0, 8, 2, 2, 330, 0, 2, 'дом на Рублёвском шоссе', '<p>Сдаётся дом на Рублёвском шоссе, рядом с метро Крылатское</p>', 'метро', 'на Рублёвском шоссе', '4', 1, '55.7469425', '37.4174575', 0, NULL, 0, NULL, 3, 7, 1, 2, 'Underground', 'on Rublevskoe highway', 'House on Rublevskoe highway', '<p>House for rent on Rublevskoe highway, near Krylatskoe metro station</p>', '', '', '', 'Haus in der Rublevskoe Fahrstraße', 'Rublevskoe Fahrstraße', '<p>Haus in der Rublevskoe Fahrstraße, in der Nähe der U-Bahn-Haltestelle  Krylatskoe</p>', 'U-Bahn', '', '', '', '', '', 4, 0, 0, 'Casa en la carretera Rublevskoe', 'on Rublevskoe highway', '<p>House for rent on Rublevskoe highway, near Krylatskoe metro station</p>', 'Underground', '', 'House on Rublevskoe highway', 'على الطريق السريع Rublevskoe', '<p>منزل للايجار على الطريق السريع Rublevskoe، بالقرب من محطة المترو Krylatskoye</p>', 'تحت الارض', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Rublevskoe karayolu üzerinde ev ', 'Rublevskoe karayolu üzerinde ', '<p>Rublevskoe karayolu üzerinde Kiralık Ev, Krylatskoe metro istasyonu yakınında </p>', 'Metro', ''),
(23, '', '0', '0', '', '', '', 1, 2, 185, 524894, 524901, 7, 0, '2020-03-16 11:14:55', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 180, 0, 4, 1, 2, 350, 0, 2, 'дача в пос. Столбовая', '<p>дача в пос. Столбовая Чеховского района</p>', '', 'Россия, Московская область, Чеховский район, поселок городского типа Столбовая', '2', 1, '55.248646837009005', '37.49985183773765', 5, NULL, 1, '2018-09-27 06:00:00', 3, 8, 1, 1, '', 'Urban-type settlement Stolbovaya, Chekhovsky Region, Moscow Oblast, Russia', 'Сountry house in Stolbovaya settlement', '<p>Сountry house in Stolbovaya settlement, Chekhovsky Region</p>', '', '', '', 'Landhaus in der Siedlung Stolbovaja', 'städtische Siedlung Stolbovaja, Tchekhowskji Region, Moskau Oblast, Russland', '<p>Landhaus in der städtische Siedlung Stolbovaja, Tchekhowskji Region</p>', '', '', '', '', '', '', 3, 0, 0, 'Casa de Campo en el asentamiento Stolbovaya', 'Urban-type settlement Stolbovaya, Chekhovsky Region, Moscow Oblast, Russia', '<p>Сountry house in Stolbovaya settlement, Chekhovsky Region</p>', '', '', 'منزل ريفي في تسوية Stolbovaya', 'نوع الحضري تسوية Stolbovaya، Chekhovsky منطقة، موسكو أوبلاست، روسيا', '<p>نوع الحضري تسوية Stolbovaya، Chekhovsky منطقة، موسكو أوبلاست، روسيا</p>', '', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Stolbovaya yerleşim kır evi ', 'Kentsel tipi yerleşim Stolbovaya, Chekhovsky Bölgesi, Moskova Oblast, Rusya', '<p>Stolbovaya yerleşim, Chekhovsky Bölgede kır evi </p>', '', ''),
(24, '', '0', '0', '', '', '', 1, 2, 185, 524894, 524901, 7, 1, '2020-03-16 11:14:55', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 1500, 0, 4, 0, 2, 150, 0, 2, 'Дача посуточно в Бадеево', '<p>Дача посуточно в Бадеево</p>', '', 'Россия, Московская область, Чеховский район, Бадеево', '', 1, '55.1514764778026', '37.46829500000001', 4, NULL, 1, '2018-11-25 06:00:00', 5, 9, 1, 1, '', 'Badeevo, Chekhov, Chekhovsky Region, Moscow Oblast, Russia', 'Сountry house for monthly rent in Badeevo, Chekhov, Moscow Oblast', '<p>Сountry house for monthly rent in Badeevo, Chekhov, Moscow Oblast</p>', '', '', '', 'Landhaus pro Tag in Badeevo', 'Badeevo, Tschekhow, Tchekhowskji Region, Moskau Oblast, Russland', '<p>Landhaus pro Tag in Badeevo</p>', '', '', '', '', '', '', 2, 0, 0, 'Casa de Campo en renta mensual en Badeevo, Chejov, Moscow Oblast', 'Badeevo, Chekhov, Chekhovsky Region, Moscow Oblast, Russia', '<p>Сountry house for monthly rent in Badeevo, Chekhov, Moscow Oblast</p>', '', '', 'منزل ريفي للإيجار الشهري في موسكو أوبلاست باد ايفو، تشيخوف،', 'Россия, Московская область, Чеховский район, Бадеево', '<p>منزل ريفي للإيجار الشهري في موسكو أوبلاست باد ايفو، تشيخوف،</p>', '', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Badeevo aylık kiralık kır evi, Çehov, Moskova Oblast', 'Badeevo, Çehov, Chekhovsky Bölgesi, Moskova Oblast, Rusya', '<p>Badeevo aylık kiralık kır evi, Çehov, Moskova Oblast</p>', '', ''),
(25, '', '0', '0', '', '', '', 1, 1, 185, 524894, 524901, 7, 0, '2020-03-16 11:14:59', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 50, 0, 1, 12, 24, 40, 0, 1, 'Однокомнатная квартира на Новом Арбате', '<p>Уютная однокомнатная квартира в центре Москвы. Насладитесь прекрасным видом из окон высотки на улицы столицы нашей страны</p>', '5 минут до метро Смоленская', 'Ул. Новый Арбат, д. 26', '', 1, '55.7530745', '37.5858817', 0, NULL, 1, '2018-12-29 06:00:00', 2, 10, 1, 2, 'Within 5 minutes to Smolenskaya metro station', 'Novy Arbat St., 26', 'Apartment on Novy Arbat St.', '<p>A cosy apartment in the center of Moscow. Enjoy beautiful view of Russian capital.</p>', '', '', '', '1-Zimmer-Wohnung in der Novy Arbat Straße', 'Novji Arbat Str., 26', '<p>Eine gemütliche Wohnung im Zentrum von Moskau. Genießen Sie die schöne Aussicht auf russische Hauptstadt.</p>', 'Die U-Bahn-Haltestelle Smolenskaja ist 5 Minuten entfernt', '', '', '', '', '', 4, 0, 0, 'Apartamento en Novy Arbat St.', 'Novy Arbat St., 26', '<p>A cosy apartment in the center of Moscow. Enjoy beautiful view of Russian capital.</p>', 'Within 5 minutes to Smolenskaya metro station', '', 'شقة في شارع نوفي أربات', 'نوفي أربات القديس، 26', '<p>شقة مريحة في وسط موسكو. تتمتع بإطلالة جميلة من العاصمة الروسية.</p>', 'في غضون 5 دقائق إلى محطة المترو سمولنسكايا', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Novy Arbat St Daire ', 'Novy Arbat Aziz, 26', '<p>Moskova\'nın merkezinde rahat bir daire. Rusya\'nın başkenti güzel manzaranın tadını çıkar.</p>', 'Smolenskaya metro İstasyonu 5 dakika içinde ', ''),
(26, '', '0', '0', '', '', '', 1, 1, 185, 524894, 524901, 7, 0, '2020-03-16 11:14:59', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 1200, 0, 1, 7, 14, 35, 0, 1, 'Квартира, ул. Большая Полянка, д. 28', '<p>Комната с приятными оттенками синего и красивая ванная комната помогут Вам расслабиться после трудового дня</p>', 'Метро \"Полянка\" в пятиминутной доступности', 'ул. Большая Полянка, д. 28', '1', 1, '55.735955', '37.6186773', 0, NULL, 0, NULL, 5, 11, 1, 1, 'Metro \"Polyanka\" is within 5 minutes walk.', 'Bolshaya Polyanka St., 28', 'Apartment, Bolshaya Polyanka St., 28', '<p>This apartment with nice shades of blue and a beautiful bathroom will help you to relax after work.</p>', '', '', '', 'Wohnung, Bolschaja Poljanka Str., 28', 'Bolschaja Poljanka Str., 28', '<p>Ein Zimmer mit feinen Schattierungen von Blau und ein schönes Badezimmer wird Ihnen helfen, sich nach der Arbeit zu entspannen.</p>', 'Die U-Bahn-Haltestelle Polyanka ist 5 Minuten entfernt', '', '', '', '', '', 3, 0, 0, 'Apartamento, Bolshaya Polyanka St., 28', 'Bolshaya Polyanka St., 28', '<p>This apartment with nice shades of blue and a beautiful bathroom will help you to relax after work.</p>', 'Metro \"Polyanka\" is within 5 minutes walk.', '', 'شقة، بولشايا Polyanka شارع، 28', 'ул. Большая Полянка, д. 28', '<p>وهذه الشقة مع ظلال جميلة من الحمام الأزرق وجميلة تساعدك على الاسترخاء بعد العمل.</p>', 'مترو \"Polyanka\" هو على بعد 5 دقائق مشيا على الأقدام.', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Daire, 4, Red Square: St. 28', 'Bolshaya Red Square: St. 28', '<p>Mavi ve güzel bir banyo güzel tonları ile bu daire, işten sonra dinlenmek için yardımcı olacaktır.</p>', 'Metro \"Red Square:\" 5 dakika yürüme mesafesindedir.', ''),
(27, '', '0', '0', '', '', '', 1, 1, 185, 524894, 524901, 7, 0, '2020-03-16 11:14:59', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 40, 0, 2, 6, 14, 58, 0, 1, '2 комн. кв. рядом с м. Проспект Мира', '<p>Эта квартира вдохновит Вас на новые достижения. Здесь есть отдельная гостиная, в которой можно с комфортом встречать коллег или отдыхать с друзьями</p>', 'метро Проспект Мира в 3 минутной доступности', 'Ул. Гиляровского, д. 20', '2+1', 1, '55.7789065', '37.6310073', 0, NULL, 0, NULL, 2, 12, 1, 2, 'Within 3 minutes walk form Prospekt Mira metro station', 'Gilyarovsky St., 20', '1-Bedroom Apartment near Prospekt Mira metro station', '<p>This apartment will inspire you for new achievements. There is a separate living room, where you can comfortably meet colleagues or relax with friends.</p>', '', '', '', '2-Zimmer-Wohnung in der Nähe von der U-Bahn-Haltestelle Prospekt Mira', 'Gilyarovskogo Str., 20', '<p>Diese Wohnung wird Sie für neue Erfolge inspirieren. Es gibt ein separates Wohnzimmer, wo Sie bequem mit Ihren Kollegen treffen und mit Freunden sich ausruhen können.</p>', 'Die U-Bahn-Haltestelle Prospekt Mira ist 3 Minuten entfernt', '', '', '', '', '', 7, 0, 0, 'Apartamento de 1 dormitorio cerca de la estación de metro Prospekt Mira', 'Gilyarovsky St., 20', '<p>This apartment will inspire you for new achievements. There is a separate living room, where you can comfortably meet colleagues or relax with friends.</p>', 'Within 3 minutes walk form Prospekt Mira metro station', '', 'شقة من غرفة نوم و1 بالقرب من محطة المترو بروسبكت ميرا', 'Ул. Гиляровского, д. 20', '<p>وهذه الشقة تلهمك لتحقيق انجازات جديدة. هناك غرفة معيشة منفصلة، حيث يمكنك أن يجتمع الزملاء مريح أو الاسترخاء مع الأصدقاء.</p>', 'في غضون 3 دقائق سيرا على الأقدام من محطة المترو بروسبكت ميرا', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Prospect Mira metro istasyonuna yakın 1 yatak Odalı Daire ', 'Gilyarovsky St., 20', '<p>Bu daire, yeni başarılar için ilham kaynağı olacak. Rahatça karşılayacak iş arkadaşları ya da arkadaşlarınızla dinlenmek için ayrı bir oturma odası vardır.</p>', 'Form Prospect Mira metro İstasyonu 3 dakikalık yürüme mesafesindedir ', ''),
(28, '', '0', '0', '', '', '', 1, 1, 185, 524894, 524901, 7, 0, '2020-03-16 11:14:59', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 25, 0, 1, 9, 14, 36, 0, 2, '1 комн. кв. метро Арбатская, Большой Афанасьевский переулок 10', '<p>В 7 минутной доступности от метро Арбатская</p>', 'метро', 'Большой Афанасьевский переулок 10', '1+1', 1, '55.7506831', '37.5968604', 0, NULL, 0, NULL, 2, 13, 1, 2, 'Underground', 'Bolshoy Afanasyevsky Lane, 10', 'Apartment near Arbatskaya metro station, Bolshoy Afanasyevsky Lane, 10', '<p>Within 7 minutes walk from Arbatskaya metro station</p>', '', '', '', '1-Zimmer-Wohnung, U-Bahn-Haltestelle Arbatskaya, Bolschoi Afanasjevskij Pereulok, 10', 'Bolschoi Afanasjevskij Pereulok, 10', '<p>Die U-Bahn-Haltestelle Arbatskaja ist 7 Minuten entfernt</p>', 'U-Bahn', '', '', '', '', '', 5, 0, 0, 'Apartamento cerca de la estación de metro Arbatskaya, Bolshoy Afanasyevsky Lane, 10', 'Bolshoy Afanasyevsky Lane, 10', '<p>Within 7 minutes walk from Arbatskaya metro station</p>', 'Underground', '', 'شقة بالقرب من محطة مترو Arbatskaya، البولشوي افاناسييف سكاي لاين، 10', 'Большой Афанасьевский переулок 10', '<p>في غضون 7 دقائق سيرا على الأقدام من محطة مترو Arbatskaya</p>', 'تحت الارض', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Arbatskaya metro istasyonu yakınındaki Daire, Bolşoy Afanasyevsky Lane, 10', 'Bolşoy Afanasyevsky Lane, 10', '<p>İçinde 7 dakika, Arbatskaya metro İstasyonu\'na </p>', 'Metro', ''),
(29, '', '0', '0', '', '', '', 2, 1, 185, 524894, 524901, 7, 1, '2020-03-16 11:14:57', '2019-01-05 03:43:46', NULL, NULL, 1, 0, 185000, 0, 3, 11, 12, 80, 0, 1, '3 комн. кв. в минутной доступности до м.Павелецкая', '<p>В этой просторной и комфортабельной квартире Вы сможете насладиться видом на столицу нашей Родины и после удачного дня расслабиться в большой ванне </p>', '', 'Ул. Зацепа, д. 22', '2+2+1', 1, '55.7300745', '37.6336848', 0, NULL, 1, '2019-01-30 06:00:00', 1, 16, 1, 2, '', 'Zatsepa St., 22', '2-Bedroom Apartment within a minute walk from Paveletskaya metro station', '<p>In this spacious and comfortable apartment you can enjoy the views of the capital of our country, and relax after a good day in a large bath.</p>', '', '', '', '3-Zimmer-Wohnung in einer Minute zu Fuß von der U-Bahn-Haltestelle Paveletskaya', 'Zacepa Str., 22', '<p>In dieser geräumigen und komfortablen Wohnung können Sie den Ausblick auf die Hauptstadt unseres Landes genießen, und sich nach einem guten Tag in einer großen Badewanne entspannen.</p>', '', '', '', '', '', '', 4, 0, 0, 'Apartamento 2 dormitorios dentro de un minuto a pie de la estación de metro de Paveletskaya', 'Zatsepa St., 22', '<p>In this spacious and comfortable apartment you can enjoy the views of the capital of our country, and relax after a good day in a large bath.</p>', '', '', 'شقة 2 نوم في غضون دقيقة سيرا على الأقدام من محطة مترو بافيليتسكايا', 'Zatsepa St., 22', '<p>في هذه الشقة واسعة ومريحة يمكنك الاستمتاع بالمناظر من عاصمة بلادنا، والاسترخاء بعد يوم جيد في حمام كبير.</p>', '', '', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Rahatlıkla ulaşabileceğiniz metro istasyonuna kısa bir yürüme mesafesinde 2 yatak Odalı Daire ', 'Zatsepa St., 22', '<p>Bu ferah ve konforlu Daire ülkemizin başkentinin manzarası ve büyük bir banyo güzel bir gün rahat edebilirsiniz.</p>', '', ''),
(30, '', '0', '0', '', '', '', 1, 6, 225, 5332921, 5368361, 0, 15, '2020-03-16 11:14:57', '2019-01-05 03:43:46', '2019-01-05 04:43:46', NULL, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 'Sunset Hotel', '<p>Отель Sunset Los Angeles расположен в самом сердце Западного Голливуда. Этот отель находится в глухом переулке, усаженном деревьями, всего в нескольких шагах от известного бульвара Сансет-Стрип в Западном Голливуде. К услугам гостей 2 открытых бассейна и ресторан.</p>\r\n\r\n<p>В числе удобств номеров обеденная зона и телевизор с плоским экраном. В некоторых номерах есть полностью оборудованная кухня, из некоторых номеров открывается вид.</p>\r\n\r\n<p>На территории работает бар. К услугам гостей фитнес-центр и спа-центр. В числе удобств сад и круглосуточная стойка регистрации.</p>\r\n', '', 'North Alta Loma Road', '', 1, '34.0935396', '-118.381941', 0, NULL, 0, NULL, 0, 17, 1, 1, '', 'North Alta Loma Road', 'Sunset Hotel', '<p>The Sunset Los Angeles is located in the heart of West Hollywood. This hotel is located in a leafy alley lined with trees, just a few steps from the famous Sunset Strip in West Hollywood. It features 2 outdoor pools and a restaurant.<br />\r\n<br />\r\nRooms include a dining area and a flat-screen TV. Some rooms have a fully equipped kitchen, some rooms offer views.</p>\r\n', NULL, NULL, NULL, 'Sunset Hotel', 'North Alta Loma Road', '<p>The Sunset Los Angeles is located in the heart of West Hollywood. This hotel is located in a leafy alley lined with trees, just a few steps from the famous Sunset Strip in West Hollywood. It features 2 outdoor pools and a restaurant.<br />\r\n<br />\r\nRooms include a dining area and a flat-screen TV. Some rooms have a fully equipped kitchen, some rooms offer views.</p>\r\n', '', '', '', '', '', '', 2, 0, 0, 'Sunset Hotel', 'North Alta Loma Road', '<p>The Sunset Los Angeles is located in the heart of West Hollywood. This hotel is located in a leafy alley lined with trees, just a few steps from the famous Sunset Strip in West Hollywood. It features 2 outdoor pools and a restaurant.<br />\r\n<br />\r\nRooms include a dining area and a flat-screen TV. Some rooms have a fully equipped kitchen, some rooms offer views.</p>\r\n', '', NULL, 'Sunset Hotel', 'North Alta Loma Road', '<p>The Sunset Los Angeles is located in the heart of West Hollywood. This hotel is located in a leafy alley lined with trees, just a few steps from the famous Sunset Strip in West Hollywood. It features 2 outdoor pools and a restaurant.<br />\r\n<br />\r\nRooms include a dining area and a flat-screen TV. Some rooms have a fully equipped kitchen, some rooms offer views.</p>\r\n', '', NULL, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Sunset Hotel', 'Kuzey Alta Loma Road', '<p>Sunset Los Angeles West Hollywood merkezinde yer almaktadır. Bu otel, ağaçlar, Batı Hollywood\'daki ünlü Sunset Strip sadece birkaç adım ile kaplı yapraklı bir sokakta yer almaktadır. 2 açık yüzme havuzu ve bir restoran bulunmaktadır.<br />\r\n<br />\nOdalar, oturma alanı ve düz ekran TV vardır. Bazı odalarda tam donanımlı bir mutfak var, bazı odalar manzaralıdır.</p>\r\n', '', NULL),
(31, '', '0', '0', '', '', '', 1, 7, 225, 5332921, 5368361, 0, 1, '2020-03-16 06:59:48', '2019-01-05 03:43:46', '2019-01-05 04:43:46', NULL, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'люкс', '', '', '', '', 1, '34.0935396', '-118.381941', 0, NULL, 0, NULL, 5, 14, 1, 1, '', '', 'lux', '', NULL, NULL, NULL, 'Lux', '', '', '', '', '', '', '', '', 1, 0, 30, 'De Lujo', '', '', '', NULL, 'جناح', '', '', '', NULL, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'lux', '', '', '', NULL),
(32, '', '0', '0', '', '', '', 1, 7, 225, 5332921, 5368361, 0, 1, '2020-03-16 11:13:51', '2019-01-05 03:43:46', '2019-01-05 04:43:46', NULL, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 'полулюкс', '', '', '', '', 1, '34.0935396', '-118.381941', 0, NULL, 0, NULL, 5, 15, 1, 1, '', '', 'Junior Suite', '', NULL, NULL, NULL, 'Junior Suite', '', '', '', '', '', '', '', '', 1, 0, 30, 'Junior Suite', '', '', '', NULL, 'جناح صغير: 85 دولاراً أمريكياً', '', '', '', NULL, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'Junior Süit', '', '', '', NULL),
(33, '', '0', '0', '', '', '', 2, 5, 185, 529352, 466806, 0, 5, '2020-03-16 11:14:58', '2019-01-05 03:43:46', '2019-01-05 04:43:46', NULL, 1, 1, 0, 0, 0, 0, 10, 0, 0, 0, 'Жилой комплекс мкр. Спортивный ', '<p>Микрорайон «Спортивный» представляет собой современную комплексную застройку, в рамках которой осуществляется возведение разносекционных кирпичных зданий переменной этажности.</p>\r\n\r\n<p>Застройщиком спроектированы одно-, двух- и трехкомнатные квартиры. Отделочные работы не осуществляются.</p>\r\n\r\n<p>Благоустройство прилегающей территории включает в себя организацию детских и спортивных площадок, зоны отдыха и озеленение. Предусмотрены открытые гостевые автомобильные стоянки. Первые этажи зданий отведены под размещение помещений общественного назначения, магазинов и офисов. В шаговой доступности расположены детские сады, школы, медицинские учреждения, магазины.</p>\r\n', '', 'Спортивный мкр', '', 1, '56.637722', '47.919306', 0, NULL, 0, NULL, 1, 18, 1, 1, '', 'Sports MCR', 'Residential complex of MCR. Sports', '<p>The neighborhood \"Sportivny\" is a modern complex building, within the framework of which the construction of various brick buildings of variable number of floors is carried out.<br />\r\n<br />\r\nThe developer designed one-, two- and three-bedroom apartments. Finishing works are not carried out.<br />\r\n<br />\r\nLandscaping of the adjacent territory includes the organization of children\'s and sports grounds, recreation areas and landscaping. There are open guest parking spaces. The first floors of the buildings are allocated for the placement of public facilities, shops and offices. Within walking distance are kindergartens, schools, medical institutions, shops.</p>\r\n', NULL, NULL, NULL, 'DER WOHKOMPLEX «NURLY TUA» ALMATY', 'Sport MCR', '<p>The neighborhood \"Sportivny\" is a modern complex building, within the framework of which the construction of various brick buildings of variable number of floors is carried out.<br />\r\n<br />\r\nThe developer designed one-, two- and three-bedroom apartments. Finishing works are not carried out.<br />\r\n<br />\r\nLandscaping of the adjacent territory includes the organization of children\'s and sports grounds, recreation areas and landscaping. There are open guest parking spaces. The first floors of the buildings are allocated for the placement of public facilities, shops and offices. Within walking distance are kindergartens, schools, medical institutions, shops.</p>\r\n', '', '', '', '', '', '', 1, 0, 0, 'Complejo residencial de MCR. Deportes', 'Deportes MCR', '<p>The neighborhood \"Sportivny\" is a modern complex building, within the framework of which the construction of various brick buildings of variable number of floors is carried out.<br />\r\n<br />\r\nThe developer designed one-, two- and three-bedroom apartments. Finishing works are not carried out.<br />\r\n<br />\r\nLandscaping of the adjacent territory includes the organization of children\'s and sports grounds, recreation areas and landscaping. There are open guest parking spaces. The first floors of the buildings are allocated for the placement of public facilities, shops and offices. Within walking distance are kindergartens, schools, medical institutions, shops.</p>\r\n', '', NULL, 'مجمع سكني من MCR. الألعاب الرياضية', 'الرياضة MCR', '<p>The neighborhood \"Sportivny\" is a modern complex building, within the framework of which the construction of various brick buildings of variable number of floors is carried out.<br />\r\n<br />\r\nThe developer designed one-, two- and three-bedroom apartments. Finishing works are not carried out.<br />\r\n<br />\r\nLandscaping of the adjacent territory includes the organization of children\'s and sports grounds, recreation areas and landscaping. There are open guest parking spaces. The first floors of the buildings are allocated for the placement of public facilities, shops and offices. Within walking distance are kindergartens, schools, medical institutions, shops.</p>\r\n', '', NULL, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 'MCR konut kompleksi. Spor', 'Spor MCR', '<p>Komşu \"Sportivny\" modern karmaşık bir yapıdır, zemin değişken sayıda çeşitli tuğla bina inşaatı yapılmaktadır çerçevesinde.<br />\r\n<br />\nGeliştirici bir, iki ve üç yatak odalı daireler tasarlanmıştır. Kaplama işleri yapılmaktadır.<br />\r\n<br />\nBitişik bölgenin çevre düzenlemesi, çocuk ve spor alanları, dinlenme alanları ve peyzaj organizasyonu içerir. Açık misafir otopark alanları vardır. Binaların ilk katları kamu tesisleri, mağazalar ve ofisler yerleştirilmesi için ayrılmıştır. Anaokulları, okullar, sağlık kurumları, dükkanlar yürüme mesafesindedir.</p>\r\n', '', NULL),
(34, '', '0', '0', '', '', '', 2, 1, 185, 529352, 466806, 0, 0, '2020-03-16 11:13:51', '2019-01-05 03:43:46', '2019-01-05 04:43:46', NULL, 1, 0, 44122, 0, 2, 2, 10, 66.2, 0, 1, '2-комнатная', '', '', '', '', 1, '56.637722', '47.919306', 0, NULL, 0, NULL, 1, 1, 1, 1, '', '', '2-room apartment', '', NULL, NULL, NULL, 'Stubenfliege', '', '', '', '', '', '', '', '', 1, 0, 33, 'Apartamento de 2 habitaciones', '', '', '', NULL, 'ملحق:2', '', '', '', NULL, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, '2 odalı daire', '', '', '', NULL),
(35, '', '0', '0', '', '', '', 2, 1, 185, 529352, 466806, 0, 1, '2020-03-16 11:13:51', '2019-01-05 03:43:46', '2019-01-05 04:43:46', NULL, 1, 0, 63436, 0, 3, 7, 10, 95, 0, 2, '3-комнатная', '', '', '', '', 1, '56.637722', '47.919306', 0, NULL, 0, NULL, 1, 2, 1, 1, '', '', '3-room apartment', '', NULL, NULL, NULL, '3 Schlafzimmer', '', '', '', '', '', '', '', '', 1, 0, 33, '3 dormitorios', '', '', '', NULL, '3 غرف نوم', '', '', '', NULL, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, '3 odalı daire', '', '', '', NULL);


DROP TABLE IF EXISTS `{dbPrefix}apartment_city`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_city` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `name_ru` varchar(100) NOT NULL DEFAULT '',
  `sorter` smallint(6) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name_en` varchar(100) NOT NULL DEFAULT '',
  `name_de` varchar(100) NOT NULL DEFAULT '',
  `name_es` varchar(100) NOT NULL DEFAULT '',
  `name_ar` varchar(100) NOT NULL DEFAULT '',
  `name_tr` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_city` (`id`, `name_ru`, `sorter`, `active`, `date_updated`, `name_en`, `name_de`, `name_es`, `name_ar`, `name_tr`) VALUES
(7, 'Москва', 1, 1, '2020-03-16 06:59:49', 'Moscow', 'Moskau', 'Moscú', 'موسكو', 'Moscow'),
(8, 'Нью-Йорк', 2, 1, '2020-03-16 06:59:49', 'New-York', 'New York', 'Nueva York', 'نيويورك', 'New-York');


DROP TABLE IF EXISTS `{dbPrefix}apartment_complain`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_complain` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_ip` varchar(60) NOT NULL DEFAULT '',
  `user_ip_ip2_long` varchar(60) NOT NULL DEFAULT '',
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `complain_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `session_id` char(32) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `body` text NULL,
  `date_created` timestamp NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `{dbPrefix}apartment_complain_reason`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_complain_reason` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `name_ru` varchar(255) NOT NULL DEFAULT '',
  `sorter` smallint(6) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name_en` varchar(255) NOT NULL DEFAULT '',
  `name_de` varchar(255) NOT NULL DEFAULT '',
  `name_es` varchar(255) NOT NULL DEFAULT '',
  `name_ar` varchar(255) NOT NULL DEFAULT '',
  `name_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_complain_reason` (`id`, `name_ru`, `sorter`, `active`, `date_updated`, `name_en`, `name_de`, `name_es`, `name_ar`, `name_tr`) VALUES
(1, 'Спам, повторяющееся объявление или реклама', 1, 0, '2020-03-16 11:33:53', 'Spam, a repeated listing or advertisement', 'Spam, ein wiederholtes Inserat oder Werbung', 'Correo no deseado, un listado o anuncio repetido', 'البريد المزعج، وقائمة المتكررة أو الإعلان', 'Spam, tek liste veya bir reklam'),
(2, 'Описание или цена не соответствуют действительности', 2, 0, '2020-03-16 11:33:55', 'Description or price is not true', 'Beschreibung oder Preis ist nicht wahr', 'Descripción o el precio no es cierto', 'وصف أو السعر ليس صحيحا', 'Açıklama veya fiyat doğru değil '),
(3, 'Компания, маскирующаяся под частное лицо', 3, 0, '2020-03-16 11:33:56', 'The company that pretends to be as a private person', 'Das Unternehmen, das sich für Privatperson ausgibt', 'La compañía que pretende ser como una persona privada', 'الشركة التي تدعي أن تكون كشخص الخاص', 'Şirket bunun için özel bir kişi gibi davranıyor '),
(4, 'Другое', 4, 0, '2020-03-16 11:33:57', 'Other', 'Anderes', 'Otro', 'آخر', 'Diğer');


DROP TABLE IF EXISTS `{dbPrefix}apartment_document`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_document` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `original_name` varchar(255) NOT NULL DEFAULT '',
  `modified_name` varchar(255) NOT NULL DEFAULT '',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}apartment_metro_stations`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_metro_stations` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `metro_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `time_on_transport` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `time_on_foot` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `metro_id` (`metro_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_metro_stations` (`id`, `apartment_id`, `metro_id`, `date_updated`) VALUES
(2, 25, 2, '2020-03-16 09:31:56'),
(3, 25, 4, '2020-03-16 09:31:56'),
(4, 25, 144, '2020-03-16 09:31:56'),
(5, 29, 43, '2020-03-16 09:32:57'),
(6, 29, 112, '2020-03-16 09:32:57'),
(7, 29, 149, '2020-03-16 09:32:57'),
(8, 27, 119, '2020-03-16 09:33:59'),
(9, 27, 140, '2020-03-16 09:33:59'),
(10, 27, 147, '2020-03-16 09:33:59'),
(11, 21, 3, '2020-03-16 09:34:45'),
(17, 19, 198, '2020-03-16 06:30:10'),
(18, 18, 199, '2020-03-16 06:30:26');


DROP TABLE IF EXISTS `{dbPrefix}apartment_obj_type`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_obj_type` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `name_ru` varchar(255) NOT NULL DEFAULT '',
  `icon_file` varchar(255) NOT NULL DEFAULT '',
  `sorter` smallint(6) NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name_en` varchar(255) NOT NULL DEFAULT '',
  `name_de` varchar(255) NOT NULL DEFAULT '',
  `parent_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `name_es` varchar(255) NOT NULL DEFAULT '',
  `name_ar` varchar(255) NOT NULL DEFAULT '',
  `ya_type` tinyint(1) NOT NULL DEFAULT '0',
  `ya_subtype` varchar(255) NOT NULL DEFAULT '',
  `with_obj` tinyint(1) NOT NULL DEFAULT '0',
  `show_in_search` tinyint(1) NOT NULL DEFAULT '1',
  `show_in_grid` tinyint(1) NOT NULL DEFAULT '1',
  `name_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_obj_type` (`id`, `name_ru`, `icon_file`, `sorter`, `date_updated`, `name_en`, `name_de`, `parent_id`, `name_es`, `name_ar`, `ya_type`, `ya_subtype`, `with_obj`, `show_in_search`, `show_in_grid`, `name_tr`) VALUES
(1, 'квартира', 'apartment.png', 1, '2020-03-16 11:49:23', 'apartment', 'Wohnung', 5, 'apartamento', 'شقة', 1, 'квартира,flat', 0, 1, 1, 'daire'),
(2, 'дом', 'house.png', 3, '2020-03-16 11:33:37', 'house', 'Haus', 0, 'villa', 'منزل', 1, 'дом,house,дом с участком,house with lot', 0, 1, 1, 'ev'),
(3, 'офис', 'commercial.png', 2, '2020-03-16 11:49:58', 'commercial real estate', 'Gewerbeimmobilien', 0, 'comercial', 'العقارات التجارية', 2, 'office', 0, 1, 1, 'ofis'),
(4, 'земельный участок', '', 4, '2020-03-16 11:49:48', 'land plot', 'Grundstück', 0, 'parcela', 'قطعة أرض', 1, 'участок,lot', 0, 1, 1, 'arazi'),
(5, 'новостройка', '', 5, '2020-03-16 11:49:39', 'apartment house', 'Mietshaus', 0, 'edificio de apartamentos', 'شقة', 0, '', 1, 1, 1, 'yapı'),
(6, 'гостиница', '', 6, '2020-03-16 11:33:48', 'hotel', 'Hotel', 0, 'hotel', 'الفندق', 2, 'hotel', 1, 1, 1, 'otel'),
(7, 'номер гостиницы', '', 7, '2020-03-16 11:50:09', 'hotel room', 'Hotelzimmer', 6, 'habitación de hotel', 'غرفة الفندق', 0, '', 0, 0, 0, 'oda otel'),
(8, 'гараж', '', 8, '2020-03-16 11:33:51', 'garage', 'garage', 0, 'cochera', 'مرآب', 1, 'гараж,garage', 0, 1, 1, 'garaj');


DROP TABLE IF EXISTS `{dbPrefix}apartment_paid`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_paid` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `paid_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `date_start` timestamp NULL,
  `date_end` timestamp NULL,
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}apartment_panorama`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_panorama` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `width` int(11) unsigned NOT NULL DEFAULT '0',
  `height` int(11) unsigned NOT NULL DEFAULT '0',
  `date_created` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;



DROP TABLE IF EXISTS `{dbPrefix}apartment_reference`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_reference` (
  `reference_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `reference_value_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  KEY `apartment_id` (`apartment_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_value_id` (`reference_value_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_reference` (`reference_id`, `reference_value_id`, `apartment_id`) VALUES
(2, 12, 21),
(2, 14, 21),
(1, 6, 21),
(1, 7, 21),
(3, 24, 21),
(3, 26, 21),
(3, 27, 21),
(4, 29, 21),
(7, 36, 21),
(7, 39, 21),
(2, 10, 28),
(2, 11, 28),
(2, 12, 28),
(2, 13, 28),
(2, 14, 28),
(5, 32, 28),
(5, 34, 28),
(1, 1, 28),
(1, 2, 28),
(1, 3, 28),
(1, 4, 28),
(1, 6, 28),
(1, 7, 28),
(3, 18, 28),
(3, 19, 28),
(3, 20, 28),
(3, 21, 28),
(3, 24, 28),
(3, 25, 28),
(3, 26, 28),
(3, 27, 28),
(4, 29, 28),
(4, 30, 28),
(4, 31, 28),
(7, 36, 28),
(7, 37, 28),
(7, 38, 28),
(7, 39, 28),
(2, 10, 27),
(2, 11, 27),
(2, 12, 27),
(2, 13, 27),
(2, 14, 27),
(2, 15, 27),
(2, 16, 27),
(2, 17, 27),
(5, 32, 27),
(5, 33, 27),
(5, 34, 27),
(1, 1, 27),
(1, 2, 27),
(1, 3, 27),
(1, 4, 27),
(1, 5, 27),
(1, 6, 27),
(1, 7, 27),
(1, 35, 27),
(3, 19, 27),
(3, 20, 27),
(3, 21, 27),
(3, 22, 27),
(3, 23, 27),
(3, 24, 27),
(3, 25, 27),
(3, 26, 27),
(3, 27, 27),
(4, 29, 27),
(4, 30, 27),
(4, 31, 27),
(7, 37, 27),
(7, 38, 27),
(7, 39, 27),
(10, 43, 27),
(10, 44, 27),
(10, 45, 27),
(9, 40, 27),
(9, 41, 27),
(9, 42, 27),
(2, 11, 25),
(2, 12, 25),
(5, 34, 25),
(1, 2, 25),
(1, 4, 25),
(1, 35, 25),
(3, 25, 25),
(3, 26, 25),
(3, 27, 25),
(10, 45, 25),
(2, 10, 26),
(2, 11, 26),
(2, 12, 26),
(2, 13, 26),
(2, 14, 26),
(2, 15, 26),
(2, 16, 26),
(2, 17, 26),
(5, 32, 26),
(5, 33, 26),
(5, 34, 26),
(1, 1, 26),
(1, 2, 26),
(1, 3, 26),
(1, 4, 26),
(1, 5, 26),
(1, 6, 26),
(1, 7, 26),
(1, 35, 26),
(3, 19, 26),
(3, 20, 26),
(3, 21, 26),
(3, 22, 26),
(3, 23, 26),
(3, 24, 26),
(3, 25, 26),
(3, 26, 26),
(3, 27, 26),
(4, 28, 26),
(4, 29, 26),
(4, 30, 26),
(4, 31, 26),
(7, 36, 26),
(7, 37, 26),
(7, 38, 26),
(7, 39, 26),
(10, 43, 26),
(10, 44, 26),
(10, 45, 26),
(9, 40, 26),
(9, 41, 26),
(9, 42, 26),
(2, 10, 18),
(2, 11, 18),
(2, 12, 18),
(2, 14, 18),
(2, 15, 18),
(5, 32, 18),
(1, 1, 18),
(1, 2, 18),
(1, 3, 18),
(1, 4, 18),
(1, 6, 18),
(1, 7, 18),
(3, 21, 18),
(3, 22, 18),
(3, 24, 18),
(3, 26, 18),
(3, 27, 18),
(4, 29, 18),
(4, 30, 18),
(4, 31, 18),
(7, 36, 18),
(7, 39, 18),
(2, 11, 20),
(2, 12, 20),
(2, 13, 20),
(2, 14, 20),
(5, 32, 20),
(5, 33, 20),
(5, 34, 20),
(1, 2, 20),
(1, 3, 20),
(1, 4, 20),
(1, 5, 20),
(1, 6, 20),
(1, 7, 20),
(1, 35, 20),
(3, 19, 20),
(3, 20, 20),
(3, 24, 20),
(3, 25, 20),
(3, 26, 20),
(3, 27, 20),
(4, 29, 20),
(4, 30, 20),
(7, 36, 20),
(7, 39, 20),
(2, 10, 19),
(2, 11, 19),
(2, 12, 19),
(2, 13, 19),
(2, 14, 19),
(5, 32, 19),
(5, 33, 19),
(1, 1, 19),
(1, 2, 19),
(1, 3, 19),
(1, 4, 19),
(1, 6, 19),
(3, 19, 19),
(3, 20, 19),
(3, 23, 19),
(3, 24, 19),
(3, 25, 19),
(3, 26, 19),
(3, 27, 19),
(4, 30, 19),
(4, 31, 19),
(7, 38, 19),
(7, 39, 19),
(2, 12, 24),
(2, 13, 24),
(2, 14, 24),
(2, 16, 24),
(2, 17, 24),
(5, 33, 24),
(1, 2, 24),
(1, 3, 24),
(1, 4, 24),
(1, 6, 24),
(1, 7, 24),
(3, 20, 24),
(3, 23, 24),
(3, 24, 24),
(3, 25, 24),
(3, 26, 24),
(3, 27, 24),
(4, 29, 24),
(4, 30, 24),
(4, 31, 24),
(7, 37, 24),
(7, 38, 24),
(7, 39, 24),
(2, 10, 29),
(2, 11, 29),
(2, 12, 29),
(2, 13, 29),
(5, 32, 29),
(5, 33, 29),
(5, 34, 29),
(1, 2, 29),
(1, 4, 29),
(1, 5, 29),
(1, 35, 29),
(3, 25, 29),
(3, 26, 29),
(3, 27, 29),
(2, 10, 23),
(2, 11, 23),
(2, 12, 23),
(2, 13, 23),
(5, 32, 23),
(5, 33, 23),
(1, 1, 23),
(1, 2, 23),
(1, 3, 23),
(1, 4, 23),
(1, 5, 23),
(1, 6, 23),
(1, 7, 23),
(3, 19, 23),
(3, 20, 23),
(3, 21, 23),
(3, 23, 23),
(3, 24, 23),
(3, 25, 23),
(3, 26, 23),
(3, 27, 23),
(4, 29, 23),
(7, 37, 23),
(7, 38, 23),
(7, 39, 23),
(2, 10, 22),
(2, 11, 22),
(2, 12, 22),
(2, 13, 22),
(5, 32, 22),
(5, 33, 22),
(5, 34, 22),
(1, 2, 22),
(1, 4, 22),
(1, 5, 22),
(1, 35, 22),
(3, 25, 22),
(3, 26, 22),
(3, 27, 22);


DROP TABLE IF EXISTS `{dbPrefix}apartment_reference_categories`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_reference_categories` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `title_ru` varchar(255) NOT NULL DEFAULT '',
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `sorter` smallint(6) NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `style` enum('column1','column2','column3') NOT NULL DEFAULT 'column1',
  `title_de` varchar(255) NOT NULL DEFAULT '',
  `title_es` varchar(255) NOT NULL DEFAULT '',
  `title_ar` varchar(255) NOT NULL DEFAULT '',
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_reference_categories` (`id`, `type`, `title_ru`, `title_en`, `sorter`, `date_updated`, `style`, `title_de`, `title_es`, `title_ar`, `title_tr`) VALUES
(1, 1, 'Комфорт', 'Comfort', 2, '2019-03-16 11:14:59', 'column3', 'Komfort', 'Comodidad', 'راحة', 'Konfor'),
(2, 1, 'Ванная', 'Bathroom', 4, '2019-03-16 11:15:00', 'column3', 'Badezimmer', 'Cuarto de Baño', 'حمام', 'Banyo'),
(3, 1, 'Кухня', 'Kitchen', 3, '2019-03-16 11:15:00', 'column3', 'Küche', 'Cocina', 'مطبخ', 'Mutfak'),
(4, 1, 'Работа', 'Work', 5, '2019-03-16 11:15:00', 'column3', 'Arbeit', 'Trabajo', 'عمل', 'İş'),
(5, 1, 'Безопасность', 'Security', 1, '2019-03-16 11:15:00', 'column3', 'Sicherheit', 'Seguridad', 'أمن', 'Güvenlik'),
(7, 1, 'Развлечения', 'Entertainment', 6, '2019-03-16 11:15:00', 'column3', 'Unterhaltung', 'Entretenimiento', 'تسلية', 'Eğlence'),
(9, 1, 'Условия', 'On conditions', 8, '2019-03-16 11:15:00', 'column1', 'Bedingungen', 'Condiciones', 'على الظروف', 'Şartları '),
(10, 1, 'Услуги', 'Services', 7, '2019-03-16 11:15:01', 'column1', 'Service', 'Servicios', 'خدمات', 'Hizmetleri'),
(11, 2, 'Свободная планировка', 'Open plan', 9, '2019-03-16 11:15:01', 'column1', 'Offen angegliedert  ', 'Abierto', 'مفتوح', 'Açık plan'),
(12, 2, 'Тип комнат', 'Room type', 10, '2019-03-16 11:15:01', 'column1', 'Art des Zimmers', 'Tipo de habitaciones', 'نوع الغرف', 'Oda tipi'),
(13, 2, 'Тип балкона', 'Type of balcony', 11, '2019-03-16 11:15:01', 'column1', 'Balkon Art', 'tipo de balcón', 'نوع شرفة', 'Balkon tipi '),
(14, 2, 'Тип санузла', 'Type of WC', 12, '2019-03-16 11:15:01', 'column1', 'Art der Bäder', 'tipo de baños', 'نوع من الحمامات', 'WC tipi '),
(15, 2, 'Покрытие пола', 'Floor coating', 13, '2019-03-16 11:15:02', 'column1', 'Beschichtung', 'piso', 'أرضية', 'Zemin kaplama'),
(16, 2, 'Тип гаража', 'Garage type', 14, '2019-03-16 11:15:02', 'column1', 'Garage Typ', 'Tipo de garaje', 'نوع المرأب', 'Garaj türü'),
(17, 2, 'Ремонт', 'Repair', 15, '2019-03-16 11:15:02', 'column1', 'Reparatur', 'Reparar', 'إصلاح', 'Onarım'),
(18, 2, 'Состояние объекта', 'State of the object', 16, '2019-03-16 11:15:02', 'column1', 'Zustand des Objekts', 'Estado del objeto', 'حالة الكائن', 'Nesnenin durumu '),
(19, 2, 'Тип здания', 'Building-type', 17, '2019-03-16 11:15:03', 'column1', 'Gebäudeart', 'Tipo de construcción', 'نوع البناية', 'Bina tipi'),
(20, 2, 'Тип участка', 'Plot type', 18, '2019-03-16 11:15:03', 'column1', 'Plot-Typ', 'Trama', 'نوع الرسم', 'Arsa tipi'),
(21, 2, 'Коммуникации', 'Utilities', 19, '2019-03-16 11:15:03', 'column1', 'Versorgungswirtschaft', 'Servicios públicos', 'المرافق', 'Yardımcı Programlar');


DROP TABLE IF EXISTS `{dbPrefix}apartment_reference_values`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_reference_values` (
`id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `reference_category_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `title_ru` varchar(255) NOT NULL DEFAULT '',
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `sorter` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `for_rent` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `for_sale` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `buy` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `rent` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `exchange` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `title_de` varchar(255) NOT NULL DEFAULT '',
  `title_es` varchar(255) NOT NULL DEFAULT '',
  `title_ar` varchar(255) NOT NULL DEFAULT '',
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `reference_category_id` (`reference_category_id`),
  KEY `for_rent` (`for_rent`),
  KEY `for_sale` (`for_sale`),
  KEY `buy` (`buy`),
  KEY `rent` (`rent`),
  KEY `exchange` (`exchange`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_reference_values` (`id`, `reference_category_id`, `title_ru`, `title_en`, `sorter`, `for_rent`, `for_sale`, `buy`, `rent`, `exchange`, `date_updated`, `title_de`, `title_es`, `title_ar`, `title_tr`) VALUES
(1, 1, 'сушилка для белья', 'dryer for linen', 1, 1, 0, 0, 1, 1, '2019-03-16 11:15:03', 'Wäschetrockner', 'secadora de ropa', 'مجفف للمفروشات', 'keten için kurutma makinesi '),
(2, 1, 'пластиковые окна', 'plastic windows', 2, 1, 1, 1, 1, 1, '2019-03-16 11:15:03', 'Kunststofffenster', 'ventanas de pvc', 'نوافذ من البلاستيك', 'plastik pencere'),
(3, 1, 'плотные шторы для комфортного сна', 'dense curtains for a comfortable dream', 3, 1, 0, 0, 1, 1, '2019-03-16 11:15:04', 'Verdunklungsvorhänge für angenehmen Schlaf', 'cortinas densas para un sueño confortable', 'الستائر الكثيفة من أجل حلم مريح', 'rahat bir rüya için yoğun perde '),
(4, 1, 'красивый вид', 'splendid view', 4, 1, 1, 1, 1, 1, '2019-03-16 11:15:04', 'eine schöne Aussicht', 'espléndida vista', 'عرض رائع', 'muhteşem manzarası'),
(5, 1, 'тихая квартира', 'quiet area', 5, 1, 1, 1, 1, 1, '2019-03-16 11:15:04', 'ruhige Wohnung', 'tranquilidad', 'منطقة هادئة', 'Sessiz Alanı'),
(6, 1, 'утюг', 'iron', 6, 1, 0, 0, 1, 1, '2019-03-16 11:15:04', 'Bügeleisen', 'plancha', 'حديد', 'demir'),
(7, 1, 'гладильная доска', 'ironing table', 7, 1, 0, 0, 1, 1, '2019-03-16 11:15:04', 'Bügelbrett', 'tabla de planchar', 'طاولة الكي', 'ütü masa'),
(8, 1, 'тапочки', 'slippers', 8, 1, 0, 0, 1, 1, '2019-03-16 11:15:05', 'Hausschuhe', 'zapatillas', 'شباشب', 'terlik'),
(9, 1, 'snack Pack при заезде (бутылка воды, круассаны, крекеры и пр.)', 'snack Pack at arrival (a water bottle, croissants, crackers etc.)', 9, 1, 0, 0, 1, 1, '2019-03-16 11:15:05', 'Snack-Pack bei der Ankunft (eine Flasche Wasser, Croissants, Kekse, etc.)', 'merienda a la llegada (una botella de agua, croissants, galletas, etc)', 'وجبة خفيفة حزمة في وصول (زجاجة مياه والكرواسون والبسكويت وغيرها)', 'varış (su şişesi, kruvasan, bisküvi vb)snack Pack.'),
(11, 2, 'стиральная машина', 'washing machine', 2, 1, 1, 1, 1, 1, '2019-03-16 11:15:05', 'Waschmaschine', 'lavadora', 'غسالة', 'çamaşır makinesi'),
(12, 2, 'ванна', 'bath', 3, 1, 1, 1, 1, 1, '2019-03-16 11:15:05', 'Badewanne', 'baño', 'حمام', 'banyo'),
(13, 2, 'водонагреватель', 'water heater', 4, 1, 1, 1, 1, 1, '2019-03-16 11:15:05', 'Boiler', 'calentador de agua', 'سخان الماء', 'su ısıtıcı'),
(14, 2, 'фен', 'hairdryer', 5, 1, 0, 0, 1, 1, '2019-03-16 11:15:06', 'Föhn', 'secadora de pelo', 'مجفف الشعر', 'saç kurutma makinesi'),
(15, 2, 'мыло', 'soap', 6, 1, 0, 0, 1, 1, '2019-03-16 11:15:06', 'Seife', 'jabón', 'صابون', 'sabun'),
(16, 2, 'шампунь', 'shampoo', 7, 1, 0, 0, 1, 1, '2019-03-16 11:15:06', 'Shampoo', 'champú', 'شامبو', 'şampuan'),
(17, 2, 'гель для душа', 'shower gel', 8, 1, 0, 0, 1, 1, '2019-03-16 11:15:06', 'Duschgel', 'gel de ducha', 'جيل الإستحمام', 'duş jeli'),
(18, 3, 'все для приготовления пищи', 'everything for cooking', 1, 1, 0, 0, 1, 1, '2019-03-16 11:15:07', 'Alles zum Kochen', 'todo lo necesario para cocinar', 'كل شيء عن الطبخ', 'her şeyi yemek'),
(19, 3, 'фильтр для воды', 'water filter', 2, 1, 0, 0, 1, 1, '2019-03-16 11:15:07', 'Wasser-Filter', 'filtro de agua', 'مصفي مياه', 'su filtresi'),
(20, 3, 'электрочайник', 'electric kettle', 3, 1, 0, 0, 1, 1, '2019-03-16 11:15:07', 'elektrischer Wasserkocher', 'hervidor eléctrico', 'غلاية كهربائية', 'elektrikli su ısıtıcısı'),
(21, 3, 'все для приема пищи', 'everything for food intake', 4, 1, 0, 0, 1, 1, '2019-03-16 11:15:07', 'Alles für die Nahrungsaufnahme', 'para toda la preparación de alimentos', 'كل شيء من أجل تناول الطعام', 'gıda alımı için her şey '),
(22, 3, 'чай, кофе, сахар', 'tea, coffee, sugar', 5, 1, 0, 0, 1, 1, '2019-03-16 11:15:07', 'Tee, Kaffee, Zucker', 'té, café, azúcar', 'الشاي والقهوة والسكر', 'çay, kahve, şeker'),
(23, 3, 'обеденный стол на 3 персоны', '3-person dining table', 6, 1, 0, 0, 1, 1, '2019-03-16 11:15:08', '3-Personen-Esstisch', 'mesa de comedor para 3 personas', 'طاولة طعام 3-شخص', '3 kişilik Yemek Masası'),
(24, 3, 'микроволновая печь', 'microwave oven', 7, 1, 0, 0, 1, 1, '2019-03-16 11:15:08', 'Mikrowelle', 'microondas', 'المايكرويف', 'mikrodalga fırın'),
(25, 3, 'вытяжка', 'extract', 8, 1, 1, 1, 1, 1, '2019-03-16 11:15:08', 'Dunstabsauger', 'exaustor', 'استخراج', 'özü'),
(26, 3, 'плита', 'plate', 9, 1, 1, 1, 1, 1, '2019-03-16 11:15:08', 'Küchenherd', 'platos', 'طبق', 'plaka'),
(27, 3, 'холодильник', 'refrigerator', 10, 1, 1, 1, 1, 1, '2019-03-16 11:15:08', 'Kühlschrank', 'heladera', 'ثلاجة', 'buzdolabı'),
(28, 4, 'междугородние и международные звонки (до $2 в день) включены в стоимость', 'long distance and international calls (up to $2 per day) are included in price', 1, 1, 0, 0, 1, 1, '2019-03-16 11:15:09', 'Fern- und Auslandsgespräche (bis zu $ ​​2 pro Tag) im Preis inbegriffen', 'llamadas de larga distancia e internacionales (hasta $ 2 por día) están incluidos en el precio', 'يتم تضمين مسافات طويلة والمكالمات الدولية (تصل إلى 2 $ في اليوم الواحد) في السعر', 'uzun mesafe ve uluslararası aramalar 2 günde ($) fiyata dahildir '),
(29, 4, 'телефон', 'phone', 2, 1, 0, 0, 1, 1, '2019-03-16 11:15:09', 'Telefon', 'teléfono', 'هاتف', 'telefon'),
(30, 4, 'безлимитный скоростной интернет включен в стоимость', 'unlimited high-speed Internet is included in price', 3, 1, 0, 0, 1, 1, '2019-03-16 11:15:09', 'unbegrenztes Highspeed ​​Internet ist im Preis inbegriffen', 'Ilimitado a Internet de alta velocidad está incluido en el precio', 'يتم تضمين غير محدود الإنترنت عالية السرعة في السعر', 'sınırsız yüksek hızlı İnternet fiyata dahildir '),
(31, 4, 'рабочий стол', 'working table', 4, 1, 0, 0, 1, 1, '2019-03-16 11:15:09', 'Arbeitstisch', 'escritorio', 'جدول العمل', 'çalışma masası'),
(32, 5, 'кодовый замок', 'coded lock', 1, 1, 1, 1, 1, 1, '2019-03-16 11:15:10', 'Zahlenschloss', 'cerradura codificada', 'قفل مشفرة', 'şifreli kilit'),
(33, 5, 'металлическая дверь в тамбур', 'metal door to the vestibule', 2, 1, 1, 1, 1, 1, '2019-03-16 11:15:10', 'Metalltür in den Flur', 'puerta de metal al portal', 'باب حديدي إلى الدهليز', 'metal kapı antre için '),
(34, 5, 'металлическая дверь в подъезд', 'metal front door', 3, 1, 1, 1, 1, 1, '2019-03-16 11:15:10', 'Metalltür in den Hauseingang ', 'puerta de metal', 'الباب المعادن الأمامي', 'metal ön kapı'),
(35, 1, 'домофон', 'intercom', 10, 1, 1, 1, 1, 1, '2019-03-16 11:15:10', 'Gegensprechanlage', 'intercomunicador', 'الاتصال الداخلي', 'ıntercom'),
(36, 7, 'кабельное ТВ', 'cable TV', 1, 1, 0, 0, 1, 1, '2019-03-16 11:15:10', 'Kabelfernsehen', 'Televisión por cable', 'الكيبل التلفزيوني', 'kablo TV'),
(37, 7, 'DVD-проигрыватель', 'DVD player', 2, 1, 0, 0, 1, 1, '2019-03-16 06:59:49', 'DVD-Player', 'DVD', 'جهاز دي في دي', 'DVD player'),
(38, 7, 'спутниковое ТВ', 'satellite TV', 3, 1, 0, 0, 1, 1, '2019-03-16 11:15:11', 'Satelliten-TV', 'TV vía satélite', 'الفضائيات', 'uydu TV'),
(39, 7, 'телевизор', 'TV', 4, 1, 0, 0, 1, 1, '2019-03-16 06:59:49', 'Fernseher', 'TV', 'تلفزيون', 'TV'),
(40, 9, 'Ранний въезд (до 14:00) и поздний выезд (после 12:00) оплачиваются как 50% суточного проживания.', 'Early checking in (till 2.00 p.m.) and late checking out (after 12.00 noon) are charged 50 % of daily rate.', 1, 1, 0, 0, 1, 1, '2019-03-16 11:15:11', 'Früh. Anreise (vor 14:00 Uhr) und spät. Abreise (nach 12:00 Uhr) werden mit 50% 50% des Tagessatzes berechnet.', 'A principios de check-in (hasta 02:00) y late check-out (después de las 12:00) pagan el 50% de la tarifa diaria.', 'فحص المبكر في (حتى 14:00) وأواخر التحقق من أصل (بعد الساعة 12.00 ظهرا) ويتم تحميل 50٪ من المعدل اليومي.', '(2.00 saat geç (12.00 öğleden sonra) kontrol kadar) ve erken kontrol günlük ücretin %50\'si tahsil edilir.'),
(41, 9, 'Минимальный срок проживания - двое суток.', 'The minimum period of accommodation is two days.', 2, 1, 0, 0, 1, 1, '2019-03-16 11:15:11', 'Mindestaufenthalt - zwei Tage.', 'El alojamiento mínimo es de dos días.', 'لمدة لا تقل عن الإقامة يومين.', 'Konaklama minimum süre iki gündür.'),
(42, 9, 'НЕ допускается проживание домашних животных.', 'Accommodation for pets isn\'t allowed.', 3, 1, 0, 0, 1, 1, '2019-03-16 11:19:42', 'Haustiere NICHT erlaubt', 'No se permite el alojamiento de mascotas.', 'لا يسمح الإقامة للحيوانات الاليفة.', 'Evcil Hayvanlar için konaklama izin verilmez.'),
(43, 10, 'Уборка включена в стоимость: Каждый рабочий день в соответствии со списком работ, размещенным в квартире.', 'Cleaning is included in price: Each working day, according to the timetable placed in the apartment.', 1, 1, 0, 0, 1, 1, '2019-03-16 11:20:22', 'Reinigung ist im Preis inbegriffen: Jeder Arbeitstag, nach dem Zeitplan in der Wohnung platziert.', 'La limpieza está incluida en el precio: Todos los días de trabajo, de acuerdo con el calendario establecido en el apartamento.', 'يتم تضمين التنظيف في السعر: كل يوم عمل، وفقا لجدول زمني وضعت في الشقة.', 'Temizlik fiyata dahildir: her iş günü, daireye verilen tarife göre.'),
(44, 10, 'Смена белья и полотенец включена в стоимость: Раз в четыре дня.', 'Change of linen and towels is included in price: Once in four days.', 2, 1, 0, 0, 1, 1, '2019-03-16 11:20:37', 'Wechsel der Bettwäsche und Handtücher ist im Preis inbegriffen: Einmal in vier Tagen.', 'Cambio de sábanas y toallas está incluido en el precio: una vez en cuatro días.', 'يتم تضمين تغيير الكتان والمناشف في سعر له مرة واحدة في أربعة أيام.', 'Nevresim ve havlu değişimi fiyata dahildir: dört günde bir.'),
(45, 10, 'Цены указаны в рублях РФ. Текущий курс обмена валют вы можете посмотреть на сайте ЦБ РФ.', 'The prices are specified in USD. You can find the current rate of a currency exchange on the site of the Central Bank of the Russian Federation.', 3, 1, 1, 1, 1, 1, '2019-03-16 11:20:53', 'Die Preise werden in USD angegeben. Aktuelle Wechselkurse für Währungen können Sie auf der Website der Zentralbank der Russischen Föderation finden.', 'Los precios están expresados ​​en dólares estadounidenses. Usted puede encontrar el tipo de cambio vigente en el sitio del Banco de España.', 'يتم تحديد الأسعار بالدولار الأمريكي. يمكنك العثور على المعدل الحالي لصرف العملات على موقع البنك المركزي للاتحاد الروسي.', 'Fiyatlar USD cinsinden belirtilmiştir. Rusya Federasyonu Merkez Bankası sitesinde bir döviz kurunun mevcut oranını bulabilirsiniz.'),
(46, 1, 'кондиционер', 'air conditioner', 12, 1, 1, 1, 1, 1, '2019-03-16 11:21:13', 'klimaanlage', 'A/C', 'مكيفات الهواء', 'klima'),
(47, 7, 'интернет', 'internet', 5, 1, 1, 1, 1, 1, '2019-03-16 06:59:49', 'das Internet', 'internet', 'الإنترنت', 'internet'),
(48, 1, 'с мебелью', 'furnished', 13, 1, 1, 1, 1, 1, '2019-03-16 11:21:21', 'möbliert', 'amueblado', 'مفروش', 'döşeli'),
(49, 3, 'мебель на кухне', 'furnished kitchen', 11, 1, 1, 1, 1, 1, '2019-03-16 11:21:31', 'offene, ausgestattete Küche', 'cocina amueblada', 'مطبخ مفروش', 'mobilyalı mutfak'),
(51, 3, 'встроенная техника', 'built-in appliances', 12, 1, 1, 1, 1, 1, '2019-03-16 11:21:39', 'einbaugeräte', 'integrado en los aparatos', 'الأجهزة المدمجة في', 'dahili aletleri'),
(52, 11, 'Да', 'Yes', 1, 1, 1, 1, 1, 1, '2019-03-16 11:21:48', 'Ja', 'Sí', 'نعم', 'Evet'),
(53, 11, 'Нет', 'No', 2, 1, 1, 1, 1, 1, '2019-03-16 11:22:03', 'Nein', 'No', 'لا', 'Hayır'),
(54, 12, 'Раздельные', 'Separate', 1, 1, 1, 1, 1, 1, '2019-03-16 11:28:45', 'getrennt', 'separado', 'فصل', 'Ayrı'),
(55, 12, 'Смежные', 'Walkthrough', 2, 1, 1, 1, 1, 1, '2019-03-16 11:28:52', 'Nebenräume', 'habitaciones contiguas', 'الغرف المجاورة', 'Yönerge'),
(56, 13, 'Балкон', 'Balcony', 1, 1, 1, 1, 1, 1, '2019-03-16 11:28:58', 'Balkon', 'Balcón', 'شرفة', 'Balkon'),
(57, 13, 'Лоджия', 'Loggia', 2, 1, 1, 1, 1, 1, '2019-03-16 11:29:17', 'Loggien', 'logia', 'لوجيا', 'Sundurma'),
(58, 13, '2 балкона', '2 balconies', 3, 1, 1, 1, 1, 1, '2019-03-16 11:32:26', '2 Balkone', '2 balcones', '2 الشرفات', '2 balkon'),
(59, 13, '2 лоджии', '2 loggias', 4, 1, 1, 1, 1, 1, '2019-03-16 06:59:49', '2 Loggien', '2 logias', '2 والمقطع', '2 loggias'),
(60, 14, 'Совмещённый', 'Combined', 1, 1, 1, 1, 1, 1, '2019-03-16 11:32:38', 'kombiniert', 'conjunto', 'مشترك', 'Karma'),
(61, 14, 'Раздельный', 'Separate', 2, 1, 1, 1, 1, 1, '2019-03-16 11:32:48', 'getrennt', 'apartado', 'منفصل', 'Ayrı'),
(62, 14, '2 санузла', '2 WC', 3, 1, 1, 1, 1, 1, '2019-03-16 06:59:49', '2 WC', '2 WC', '2 مرحاض', '2 WC'),
(63, 15, 'Ковролин', 'Fitted carpet', 1, 1, 1, 1, 0, 1, '2019-03-16 11:33:16', 'Teppichboden', 'alfombras', 'سجاد', 'Donatılmış halı'),
(64, 15, 'Ламинат', 'Laminat', 2, 1, 1, 1, 0, 1, '2019-03-16 11:34:28', 'Laminat', 'Laminat', 'Laminat', 'Kat kat yapmak'),
(65, 15, 'Паркет', 'Parquet', 3, 1, 1, 1, 0, 1, '2019-03-16 11:34:34', 'Parkett', 'Tarima', 'النيابة العامة', 'Parke'),
(66, 15, 'Линолеум', 'Linoleum', 4, 1, 1, 1, 0, 1, '2019-03-16 11:34:40', 'Linol', 'Linóleo', 'مشمع', 'Linolyum'),
(67, 16, 'Гараж', 'Garage', 1, 1, 1, 1, 1, 1, '2019-03-16 11:34:48', 'Garage', 'Garaje', 'جراج', 'Garaj'),
(68, 16, 'Машиноместо', 'Parking place', 2, 1, 1, 1, 1, 1, '2019-03-16 11:34:18', 'Parkplatz', 'estacionamiento', 'موقف انتظار', 'Park yeri'),
(69, 16, 'Бокс', 'Box', 3, 1, 1, 1, 1, 1, '2019-03-16 11:34:56', 'Box', 'Caja', 'أخفاء مربع المعلومات', 'Kutucuk'),
(70, 17, 'Дизайнерский', 'Design', 1, 1, 1, 1, 1, 1, '2019-03-16 11:35:02', 'Design', 'Diseño', 'المفتاح', 'Tasarım'),
(71, 17, 'Евро', 'Euro', 2, 1, 1, 1, 1, 1, '2019-03-16 11:35:12', 'Euro', 'Euros', 'اليورو', 'Avro'),
(72, 17, 'С отделкой', 'Finished exterior', 3, 1, 1, 1, 1, 1, '2019-03-16 11:35:18', 'Fertige Fassade', 'Acabado exterior', 'الانتهاء من الخارج', 'Bitmiş dış'),
(73, 17, 'Требует ремонта', 'Need repair', 4, 1, 1, 1, 1, 1, '2019-03-16 11:35:23', 'Repariert werden muss', 'Necesita reparación', 'يحتاج إصلاح', 'Onarım ihtiyacı'),
(74, 17, 'Хороший ремонт', 'Good renovation', 5, 1, 1, 1, 1, 1, '2019-03-16 11:35:31', 'Sanierung', 'Reforma', 'رؤية هوست', 'İyi yenileme'),
(75, 17, 'Частичный ремонт', 'Partial repaired', 6, 1, 1, 1, 1, 1, '2019-03-16 11:35:40', 'Teilweise repariert', 'Parcial reparado', 'إصلاح جزئي', 'Kısmi tamir'),
(76, 17, 'Черновая отделка', 'Shell', 7, 1, 1, 1, 1, 1, '2019-03-16 11:35:47', 'Shell', 'Shell', 'غلاف', 'Kabuk'),
(77, 18, 'Отличное', 'Excellent', 1, 1, 1, 1, 1, 1, '2019-03-16 11:35:55', 'Sehr gut', 'Excelente', 'ممتاز', 'Mükemmel'),
(78, 18, 'Хорошее', 'Good', 2, 1, 1, 1, 1, 1, '2019-03-16 11:36:02', 'Gut', 'Bueno', 'جيد', 'İyi'),
(79, 18, 'Нормальное', 'Normal', 3, 1, 1, 1, 1, 1, '2019-03-16 06:59:49', 'Normal', 'Normal', 'عادي', 'Normal'),
(80, 18, 'Плохое', 'Bad', 4, 1, 1, 1, 1, 1, '2019-03-16 11:37:45', 'Schlecht', 'Malos', 'سيئة', 'Kötü'),
(81, 19, 'Блочный', 'Block-building', 1, 1, 1, 1, 1, 1, '2019-03-16 11:37:52', 'Block-Gebäude', 'Edificio del bloque', 'بناء كتلة', 'Blok bina'),
(82, 19, 'Деревянный', 'Wooden', 2, 1, 1, 1, 1, 1, '2019-03-16 11:37:59', 'Hölzern', 'De madera', 'خشبية', 'Ahşap'),
(83, 19, 'Кирпичный', 'Brick', 3, 1, 1, 1, 1, 1, '2019-03-16 11:38:06', 'Mauerziegel', 'Ladrillo', 'الطوب', 'Tuğla'),
(84, 19, 'Монолит', 'Solid', 4, 1, 1, 1, 1, 1, '2019-03-16 11:38:12', 'Durchgezogen', 'Sólido', 'صلب', 'Katı'),
(85, 19, 'Панельный', 'Pre-fab', 5, 1, 1, 1, 1, 1, '2019-03-16 11:38:18', 'Pre-fab', 'Pre-fab', 'قبل القوات المسلحة البوروندية', 'Prefabrik'),
(86, 20, 'ИЖС', 'Private housing construction', 1, 1, 1, 1, 1, 1, '2019-03-16 11:38:25', 'Gehäusekonstruktion', 'Viviendas particulares', 'إسكان خاص', 'Özel konut inşaatı'),
(87, 20, 'Садоводство', 'Garden plot', 2, 1, 1, 1, 1, 1, '2019-03-16 11:38:31', 'Grundstück', 'Jardín', 'حديقة', 'Bahçe arsa'),
(88, 21, 'Электричество', 'Electricity', 1, 1, 1, 1, 1, 1, '2019-03-16 11:38:39', 'Strom', 'Electricidad', 'كهرباء', 'Elektrik'),
(89, 21, 'Газ', 'Gas', 2, 1, 1, 1, 1, 1, '2019-03-16 11:38:46', 'Gas', 'Gas', 'الغاز', 'Gaz'),
(90, 21, 'Водопровод', 'Running water', 3, 1, 1, 1, 1, 1, '2019-03-16 11:38:53', 'Fliessgewaesser', 'Agua corriente', 'المياه الجارية', 'Akan su'),
(91, 21, 'Канализация', 'Sewerage', 4, 1, 1, 1, 1, 1, '2019-03-16 11:39:00', 'Kanalisation', 'Saneamiento', 'الصرف الصحي', 'Kanalizasyon');


DROP TABLE IF EXISTS `{dbPrefix}apartment_statistics`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_statistics` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip_address` varchar(30) NOT NULL DEFAULT '',
  `browser` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `date_created` (`date_created`),
  KEY `apId_date` (`apartment_id`, `date_created`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}apartment_times_in`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_times_in` (
  `id` smallint(6)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `title_ru` varchar(255) NOT NULL DEFAULT '',
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `title_de` varchar(255) NOT NULL DEFAULT '',
  `title_es` varchar(255) NOT NULL DEFAULT '',
  `title_ar` varchar(255) NOT NULL DEFAULT '',
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_times_in` (`id`, `title_ru`, `title_en`, `title_de`, `title_es`, `title_ar`, `title_tr`) VALUES
(1, 'До полудня', 'In the forenoon', 'vormittags', 'Durante la mañana', 'في الضحى', 'Öğleden '),
(2, 'После полудня', 'In the afternoon', 'nachmittags', 'Durante la tarde', 'في الظهيرة', 'Öğleden sonra ');


DROP TABLE IF EXISTS `{dbPrefix}apartment_times_out`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_times_out` (
  `id` smallint(6)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `title_ru` varchar(255) NOT NULL DEFAULT '',
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `title_de` varchar(255) NOT NULL DEFAULT '',
  `title_es` varchar(255) NOT NULL DEFAULT '',
  `title_ar` varchar(255) NOT NULL DEFAULT '',
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_times_out` (`id`, `title_ru`, `title_en`, `title_de`, `title_es`, `title_ar`, `title_tr`) VALUES
(1, 'До полудня', 'In the forenoon', 'vormittags', 'Durante la mañana', 'في الضحى', 'Öğleden '),
(2, 'После полудня', 'In the afternoon', 'nachmittags', 'Durante la tarde', 'في الظهيرة', 'Öğleden sonra ');


DROP TABLE IF EXISTS `{dbPrefix}apartment_video`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_video` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `video_file` varchar(255) NOT NULL DEFAULT '',
  `video_html` text NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pid` (`apartment_id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `{dbPrefix}apartment_window_to`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}apartment_window_to` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `title_ru` varchar(255) NOT NULL DEFAULT '',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `title_de` varchar(255) NOT NULL DEFAULT '',
  `title_es` varchar(255) NOT NULL DEFAULT '',
  `title_ar` varchar(255) NOT NULL DEFAULT '',
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}apartment_window_to` (`id`, `title_ru`, `date_updated`, `title_en`, `title_de`, `title_es`, `title_ar`, `title_tr`) VALUES
(1, 'на улицу', '2019-03-16 11:33:13', 'Street view', 'die Straße', 'Vista de la calle', 'منظر الشارع', 'Sokak görünümü'),
(2, 'во двор', '2019-03-16 11:33:16', 'Courtyard view', 'den Innenhof', 'Vista al patio', 'فناء الرأي', 'Avlu görünümü'),
(3, 'на море', '2019-03-16 11:33:17', 'Sea view', 'das Meer', 'Vista al mar', 'اطلالة البحر', 'Deniz manzarası'),
(4, 'на озеро', '2019-03-16 11:33:18', 'Lake view', 'den See', 'Vista al lago', 'عرض البحيرة', 'Göl manzaralı');


DROP TABLE IF EXISTS `{dbPrefix}articles`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}articles` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `page_title_ru` varchar(255) NOT NULL DEFAULT '',
  `page_body_ru` text NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `sorter` tinyint(4) NOT NULL DEFAULT '0',
  `page_title_en` varchar(255) NOT NULL DEFAULT '',
  `page_body_en` text NULL,
  `page_title_de` varchar(255) NOT NULL DEFAULT '',
  `page_body_de` text NULL,
  `page_title_es` varchar(255) NOT NULL DEFAULT '',
  `page_body_es` text NULL,
  `page_title_ar` varchar(255) NOT NULL DEFAULT '',
  `page_body_ar` text NULL,
  `page_title_tr` varchar(255) NOT NULL DEFAULT '',
  `page_body_tr` text NULL,
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}articles` (`id`, `page_title_ru`, `page_body_ru`, `date_updated`, `active`, `sorter`, `page_title_en`, `page_body_en`, `page_title_de`, `page_body_de`, `page_title_es`, `page_body_es`, `page_title_ar`, `page_body_ar`, `page_title_tr`, `page_body_tr`) VALUES
(5, 'Лучшие города для холостяков', '<p>\r\n	Итак, Вы устали знакомиться на улицах и в барах своего города в попытках найти того или ту единственную, или может быть, у Вас было достаточно неудач на первых свиданиях, и поэтому Вас не заставишь выйти из дома в субботу вечером. Не отчаивайтесь. &quot;Форбс&quot; составил список лучших городов для холостяков и незамужних девушек, изучив такие факторы как &quot;потрясность&quot;, число холостяков и незамужних девушек, ночная жизнь и рост числа рабочих мест, и они полностью подходят следующим&nbsp; топ-5 городов для знакомств:</p>\r\n<p>\r\n	1.Нью-Йорк<br />\r\n	2.Бостон<br />\r\n	3.Чикаго<br />\r\n	4.Сиэтл<br />\r\n	5.Вашингтон, округ Колумбия</p>\r\n', '2020-03-16 11:37:37', 1, 1, 'Best Places for Singles', '<p>\n	So you&#39;re tired of combing the streets and bars of your city in an attempt to find that special someone, or maybe you&#39;ve had enough bad first dates to keep you in on a Saturday night. Don&#39;t despair. The folks at Forbes&#39;s have compiled stats, looking at factors like &quot;coolness&quot;, number of singles, nightlife and job growth to come up with these top five dating cities.</p>\n<p>\n	1. New York<br />\n	2. Boston<br />\n	3. Chicago<br />\n	4. Seattle<br />\n	5. Washington D.C.</p>\n', 'Die besten Städte für die Ledigen', '<p>\r\n	<style type=\"text/css\">\r\n<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in; direction: ltr; color: #00000a; widows: 0; orphans: 0 }\r\n		P.western { font-family: \"Times New Roman\", serif; font-size: 12pt; so-language: en-US }\r\n		P.cjk { font-family: \"Droid Sans Fallback\"; font-size: 12pt; so-language: zh-CN }\r\n		P.ctl { font-family: \"Lohit Hindi\"; font-size: 12pt; so-language: hi-IN }\r\n		A:visited { so-language: en-US }\r\n		A:link { so-language: en-US }\r\n	-->	</style>\r\n</p>\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\">\r\n	<style type=\"text/css\">\r\n<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in; direction: ltr; color: #00000a; widows: 0; orphans: 0 }\r\n		P.western { font-family: \"Times New Roman\", serif; font-size: 12pt; so-language: en-US }\r\n		P.cjk { font-family: \"Droid Sans Fallback\"; font-size: 12pt; so-language: zh-CN }\r\n		P.ctl { font-family: \"Lohit Hindi\"; font-size: 12pt; so-language: hi-IN }\r\n		A:visited { so-language: en-US }\r\n		A:link { so-language: en-US }\r\n	-->	</style>\r\n</p>\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\">\r\n	<span lang=\"de-DE\">Also sind Sie m&uuml;de, die Stra&szlig;en und Bars Ihrer Stadt zu wechseln, um den einzigen oder die einzige zu finden, oder vielleicht haben Sie schon genug schlechte ersten Treffe, und also gehen Sie auf die Stra&szlig;e am Samstagabend niсht hinaus. Verzweifeln Sie nicht. </span><span lang=\"de-DE\"><span style=\"font-weight: normal\">&#39;Forbes&#39; hat die Liste von </span></span><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">besten </span></span></span><em><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">St&auml;dten </span></span></span></em><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">f&uuml;r die Ledigen</span></span></span><span lang=\"de-DE\"><span style=\"font-weight: normal\"> zus</span></span><span lang=\"de-DE\">ammengestellt, man hat solche Faktoren wie &#39;Coolness&#39;, die Zahl der </span><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">Ledigen</span></span></span><span lang=\"de-DE\">, Nachtleben und Besch&auml;ftigungswachstum gepr&uuml;ft, das Resultat ist diese f&uuml;nf Dating-St&auml;dte.</span></p>\r\n<p>\r\n	<style type=\"text/css\">\r\n<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in; direction: ltr; color: #00000a; widows: 0; orphans: 0 }\r\n		P.western { font-family: \"Times New Roman\", serif; font-size: 12pt; so-language: en-US }\r\n		P.cjk { font-family: \"Droid Sans Fallback\"; font-size: 12pt; so-language: zh-CN }\r\n		P.ctl { font-family: \"Lohit Hindi\"; font-size: 12pt; so-language: hi-IN }\r\n		A:visited { so-language: en-US }\r\n		A:link { so-language: en-US }\r\n	-->	</style>\r\n</p>\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\">\r\n	<span lang=\"de-DE\">1. New York<br />\r\n	2. Boston<br />\r\n	3. Chicago<br />\r\n	4. Seattle<br />\r\n	5. Washington D.C.</span></p>\r\n', 'Los mejores lugares para solteros', '<p> Así que&#39;re cansado de peinar las calles y bares de su ciudad en un intento de encontrar a alguien especial, o tal vez&#39;he tenido bastante mala primeras fechas para mantenerlo en un sábado por la noche. Don&#39;t desesperación. La gente de Forbes&#39;s se han compilado estadísticas, atendiendo a factores como &quot;frío&quot;, número de singles, la vida nocturna y el crecimiento del empleo a venir para arriba con estos cinco mejores citas de las ciudades.</p> <p> 1. Nueva York<br /> 2. Boston<br /> 3. Chicago<br /> 4. Seattle<br /> 5. Washington DC</p>', 'أفضل الأماكن لفردي', '<p>\r\nإذا كنت تعبت من تمشيط الشوارع والبارات في المدينة في محاولة للعثور على شخص مميز ، أو ربما كنت قد يكفي سيئة تواريخ الأولى لإبقاء لكم في ليلة السبت. لا اليأس. الناس في فوربس&#39;s جمعت احصائيات النظر في عوامل مثل \"البرودة\", عدد فردي والحياة الليلية نمو فرص العمل من أجل التوصل إلى هذه الخمسة التي يرجع تاريخها المدن.</p>\r\n<p>\r\n1. نيويورك<br />\r\n2. بوسطن<br />\r\n3. شيكاغو<br />\r\n4. سياتل<br />\r\n5. واشنطن</p>', 'Bekarlar için en iyi Yerler ', '<p>\n Yani o özel birini bulmak için bir girişim, şehrin sokakları ve barlar penye yorgunsun, ya da belki Cumartesi günü de devam edecek kadar kötü ilk kez buluştunuz. Umutsuzluğa kapılma. Forbes geldi de Millet istatistikler derlenmiş, \"single serinlik\", numara, gece hayatı ve iş büyüme gibi faktörler de bu ilk beş çıkmaya şehirler ile gelip bakıyor.</p>\n<p>\n 1. New York<br />\n 2. Boston<br />\n 3. Chicago<br />\n 4. Seattle<br />\n 5. Washington D. C.</p>\n'),
(6, 'Наилучшие города для семьи', '<p>\r\n	Детский журнал провел обширное исследование среди 100 городов США в поисках лучших из них для того, чтобы растить детей. Учитывались такие факторы как, детское здравоохранение, школы, плата за жилье, качество воздуха.</p>\r\n<p>\r\n	1.Денвер, штат Колорадо<br />\r\n	2.Норфолк/Вирджиния-Бич/Ньюпорт-Ньюс, штат Виргиния<br />\r\n	3.Миннеаполис/Сент-Пол, штат Миннесота<br />\r\n	4.Майами, штат Флорида<br />\r\n	5.Орландо, штат Флорида</p>\r\n', '2020-03-16 11:37:39', 1, 2, 'Best Places for Families', '<p>\n	Child magazine conducted an extensive search of 100 cities throughout the US to find the best place to raise a family. Factors ranged from pediatric healthcare, schools, housing costs and air quality.</p>\n<p>\n	1. Denver, Colorado<br />\n	2. Norfolk/Virginia Beach/Newport News, Virginia<br />\n	3. Minneapolis/St.Paul, Minnesota<br />\n	4. Miami, Florida<br />\n	5. Orlando, Florida</p>\n', 'Die besten Städte für Familien', '<style type=\"text/css\">\r\n<!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in; direction: ltr; color: #00000a; widows: 0; orphans: 0 }\r\n		P.western { font-family: \"Times New Roman\", serif; font-size: 12pt; so-language: en-US }\r\n		P.cjk { font-family: \"Droid Sans Fallback\"; font-size: 12pt; so-language: zh-CN }\r\n		P.ctl { font-family: \"Lohit Hindi\"; font-size: 12pt; so-language: hi-IN }\r\n		A:visited { so-language: en-US }\r\n		A:link { so-language: en-US }\r\n	--></style>\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\">\r\n	<span lang=\"de-DE\">Eine Kinder-</span>Zeitschrift<span lang=\"de-DE\"> f&uuml;hrte eine umfassende Suche nach 100 St&auml;dten in den USA durch, um die beste Stadt zur eine Familie-Gr&uuml;ndung zu finden. Es reichten solche Faktoren, wie p&auml;diatrische Gesundheitsversorgung, Schulen, Wohnkosten und Luftqualit&auml;t.</span></p>\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\">\r\n	<br />\r\n	<span lang=\"de-DE\">1. Denver, Colorado<br />\r\n	2. Norfolk / Virginia Beach / Newport News, Virginia<br />\r\n	3. Minneapolis / St.Paul, Minnesota<br />\r\n	4. Miami, Florida<br />\r\n	5. Orlando, Florida</span></p>\r\n', 'Los mejores lugares para las familias', ' <p> Hijo de la revista realizó una búsqueda exhaustiva de 100 ciudades de todo el NOSOTROS para encontrar el mejor lugar para criar una familia. Factores varió de salud pediátrica, las escuelas, los costos de la vivienda y de la calidad del aire.</p> <p> 1. Denver, Colorado<br /> 2. Norfolk/Virginia Beach/Newport News, Virginia<br /> 3. Minneapolis/st. Paul, Minnesota<br /> 4. Miami, Florida<br /> 5. Orlando, Florida</p>', 'أفضل الأماكن للعائلات', '<p>\r\nمجلة الطفل أجرى عملية بحث واسعة النطاق من 100 مدينة في جميع أنحاء الولايات المتحدة للعثور على أفضل مكان لتربية الأسرة. العوامل تتراوح بين الرعاية الصحية للأطفال والمدارس تكاليف السكن ونوعية الهواء.</p>\r\n<p>\r\n1. دنفر ، كولورادو<br />\r\n2. نورفولك/فرجينيا بيتش/Newport News, فرجينيا<br />\r\n3. مينيابوليس/سانت بول بولاية مينيسوتا<br />\r\n4. ميامي, فلوريدا<br />\r\n5. Orlando, Florida</p>', 'Aileler için en iyi Yerler ', '<p>\n Çocuk Dergisi bir aile kurmak için en iyi yer bulmak için ABD genelinde 100 şehirler geniş bir arama yaptı. Faktörler pediatrik sağlık, eğitim, barınma masrafları ve hava kalitesi arasında değişiyordu.</p>\n<p>\n 1. Denver, Colorado<br />\n 2. Norfolk/Virginia Beach/Newport News, Virginia<br />\n 3. Minneapolis/St. Paul, Minnesota<br />\n 4. Miami, Florida<br />\n 5. Orlando, Florida</p>\n');


DROP TABLE IF EXISTS `{dbPrefix}badwords`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}badwords` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}badwords` (`id`, `name`) VALUES
(1,	'Трус'),
(2,	'Балбес'),
(3,	'Fuck');

DROP TABLE IF EXISTS `{dbPrefix}block_ip`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}block_ip` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ip` varchar(60) NOT NULL DEFAULT '',
  `ip_long` varchar(60) NOT NULL DEFAULT '',
  `date_created` timestamp NULL COMMENT 'Дата создания',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Дата обновления',
  PRIMARY KEY (`id`),
  KEY `ip_long` (`ip_long`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}booking_calendar`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}booking_calendar` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `booking_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `date_start` timestamp NULL,
  `date_end` timestamp NULL,
  `time_in` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `time_out` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `status` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `date_created` timestamp NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `booking_id` (`booking_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}booking_table`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}booking_table` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `sender_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_ip` varchar(60) NOT NULL DEFAULT '',
  `user_ip_ip2_long` varchar(60) NOT NULL DEFAULT '',
  `active` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `username` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `phone` varchar(20) NOT NULL DEFAULT '',
  `date_start` timestamp NULL,
  `date_end` timestamp NULL,
  `time_in` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `time_out` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `comment` text NULL,
  `comment_admin` text NULL,
  `details` text NULL,
  `amount` float NOT NULL DEFAULT '0',
  `num_guest` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `type` smallint(6) UNSIGNED NOT NULL DEFAULT  '0',
  `date_created` timestamp NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `apartment_id` (`apartment_id`),
  KEY `time_in` (`time_in`),
  KEY `time_out` (`time_out`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}carousel`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}carousel` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

DROP TABLE IF EXISTS `{dbPrefix}carousel_images`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}carousel_images` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `carousel_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `sorter` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `image` varchar(255) NOT NULL DEFAULT '',
  `title_ru` varchar(255) NOT NULL DEFAULT '',
  `text_ru` text NULL,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `title_de` varchar(255) NOT NULL DEFAULT '',
  `title_es` varchar(255) NOT NULL DEFAULT '',
  `title_ar` varchar(255) NOT NULL DEFAULT '',
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  `text_en` text NULL,
  `text_de` text NULL,
  `text_es` text NULL,
  `text_ar` text NULL,
  `text_tr` text NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}clients`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}clients` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `state` tinyint(4) NOT NULL DEFAULT '0',
  `contract_number` varchar(255) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `second_name` varchar(255) NOT NULL DEFAULT '',
  `middle_name` varchar(255) NOT NULL DEFAULT '',
  `birthdate` varchar(255) NOT NULL DEFAULT '',
  `phone` varchar(255) NOT NULL DEFAULT '',
  `additional_phone` varchar(255) NOT NULL DEFAULT '',
  `acts` text NULL,
  `additional_info` text NULL,
  `date_created` timestamp NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}comments`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}comments` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_ip` varchar(60) NOT NULL DEFAULT '',
  `user_ip_ip2_long` varchar(60) NOT NULL DEFAULT '',
  `parent_id` int(11) unsigned NULL DEFAULT '0',
  `owner_id` int(11) unsigned NOT NULL DEFAULT '0',
  `model_name` varchar(64) NOT NULL DEFAULT '',
  `model_id` int(11) unsigned NOT NULL DEFAULT '0',
  `user_name` varchar(64) NOT NULL DEFAULT '',
  `user_email` varchar(64) NOT NULL DEFAULT '',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `body` text NULL,
  `rating` tinyint(4) NOT NULL DEFAULT '0',
  `date_created` timestamp NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}comments` (`id`, `user_ip`, `user_ip_ip2_long`, `parent_id`, `owner_id`, `model_name`, `model_id`, `user_name`, `user_email`, `status`, `body`, `rating`, `date_created`, `date_updated`) VALUES
(1, '127.0.0.1', '2130706433', 0, 0, 'Apartment', 23, 'test', 'test@test.com', 1, 'Test', 5, '2020-03-16 12:55:00', '2020-03-16 12:56:14'),
(2, '127.0.0.1', '2130706433', 0, 0, 'Apartment', 24, 'test', 'test@test.com', 1, 'test', 4, '2020-03-16 12:55:25', '2020-03-16 12:56:11');


DROP TABLE IF EXISTS `{dbPrefix}comparison_list`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}comparison_list` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `apartment_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `session_id` varchar(32) NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `apartment_id` (`apartment_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}configuration`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}configuration` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` enum('bool','text','enum','hidden') NOT NULL DEFAULT 'text',
  `section` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `allowEmpty` tinyint(1) NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}configuration` (`id`, `type`, `section`, `name`, `value`, `allowEmpty`, `date_updated`) VALUES
(NULL,	'text',	'cache',	'cachingTime',	'600',	0,	'2011-11-26 17:01:21'),
(NULL,	'text',	'main',	'module_articles_itemsPerPage',	'10',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'main',	'module_articles_truncateAfterWords',	'50',	1,	'2016-08-15 10:30:25'),
(NULL,	'text',	'main',	'module_usercpanel_bookingsPerPage',	'6',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'mail',	'adminEmail',	'{adminEmail}',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'main',	'adminPhone',	'',	1,	'2016-08-15 10:30:25'),
(NULL,	'text',	'main',	'adminSkype',	'monoray.studio',	1,	'2016-08-15 10:30:25'),
(NULL,	'text',	'main',	'adminICQ',	'616147066',	1,	'2016-08-15 10:30:25'),
(NULL,	'text',	'main',	'adminAddress',	'',	1,	'2016-08-15 10:30:25'),
(NULL,	'text',	'main',	'moduleEntries_entriesPerPage',	'10',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'apartment',	'moduleApartments_maxRooms',	'8',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'apartment',	'moduleApartments_maxFloor',	'30',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'gmap',	'module_apartments_gmapsCenterX',	'37.620717508911184',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'gmap',	'module_apartments_gmapsCenterY',	'55.75411314653655',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'gmap',	'module_apartments_gmapsZoomApartment',	'15',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'gmap',	'useGoogleMap',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'main',	'adminPaginationPageSize',	'20',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'notifier',	'module_notifier_adminNewBooking',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'notifier',	'module_notifier_userPaymentSuccess',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'notifier',	'module_notifier_userNewUser',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'notifier',	'module_notifier_adminNewUser',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'notifier',	'module_notifier_adminNewContactform',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'ymap',	'useYandexMap',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'ymap',	'module_apartments_ymapsCenterX',	'37.620717508911184',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'ymap',	'module_apartments_ymapsCenterY',	'55.75411314653655',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'ymap',	'module_apartments_ymapsZoomApartment',	'15',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'ymap',	'module_apartments_ymapsSpanX',	'0.552069',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'ymap',	'module_apartments_ymapsSpanY',	'0.400552',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'ymap',	'module_apartments_ymapApiKey',	'',	1,	'2019-04-01 16:17:32'),
(NULL,	'bool',	'search',	'usePriceSlider',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'search',	'useSquareSlider',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'search',	'useFloorSlider',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'search',	'useRoomSlider',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'usePrettyPrice',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'useUserads',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'useUseradsModeration',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'notifier',	'module_notifier_ownerNewBooking',	'1',	0,	'2012-05-26 09:00:00'),
(NULL,	'bool',	'apartment',	'useReferenceLinkInView',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'main',	'defaultCity',	'New-York',	0,	'2012-06-14 11:05:05'),
(NULL,	'bool',	'apartment',	'useShowUserInfo',	'1',	0,	'2012-04-27 19:01:21'),
(NULL,	'bool',	'apartment',	'useSliderSimilarAds',	'1',	0,	'2012-04-27 19:01:21'),
(NULL,	'text',	'main',	'round_price',	'0',	0,	'2012-08-31 14:11:36'),
(NULL,	'bool',	'mail',	'mailUseSMTP',	'0',	0,	'2012-07-08 16:27:22'),
(NULL,	'text',	'mail',	'mailSMTPHost',	'localhost',	0,	'2012-07-08 16:27:22'),
(NULL,	'text',	'mail',	'mailSMTPPort',	'25',	0,	'2012-07-08 16:27:22'),
(NULL,	'text',	'mail',	'mailSMTPLogin',	'login',	1,	'2012-07-08 16:27:22'),
(NULL,	'text',	'mail',	'mailSMTPPass',	'pass',	1,	'2012-07-08 16:27:22'),
(NULL,	'hidden',	'main',	'version_name',	'Open Real Estate ULTIMATE',	0,	'2012-08-31 14:13:25'),
(NULL,	'enum',	'apartment',	'mode_list_show',	'block',	0,	'2013-12-17 13:55:16'),
(NULL,	'bool',	'apartment',	'use_module_request_property',	'1',	0,	'2013-02-27 04:31:48'),
(NULL,	'hidden',	'images',	'useWatermark',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'hidden',	'images',	'watermarkType',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'hidden',	'images',	'watermarkContent',	'',	0,	'2016-08-15 10:30:25'),
(NULL,	'hidden',	'images',	'maxImageWidth',	'1024',	0,	'2016-08-15 10:30:25'),
(NULL,	'hidden',	'images',	'maxImageHeight',	'768',	0,	'2016-08-15 10:30:25'),
(NULL,	'hidden',	'images',	'watermarkTextColor',	'#367fa9',	0,	'2016-08-15 10:30:25'),
(NULL,	'hidden',	'images',	'watermarkTextOpacity',	'50',	0,	'2016-08-15 10:30:25'),
(NULL,	'hidden',	'images',	'watermarkPosition',	'5',	0,	'2013-02-27 08:34:48'),
(NULL,	'hidden',	'images',	'watermarkTextSize',	'20',	0,	'2013-02-27 08:34:48'),
(NULL,	'hidden',	'images',	'watermarkFile',	'',	0,	'2013-02-27 08:34:48'),
(NULL,	'bool',	'notifier',	'module_notifier_adminNewApartment',	'1',	0,	'2013-02-27 08:35:11'),
(NULL,	'bool',	'notifier',	'module_notifier_adminApartmentNeedModerate',	'1',	0,	'2013-02-27 08:35:11'),
(NULL,	'bool',	'notifier',	'module_notifier_adminNewComplain',	'1',	0,	'2013-02-27 08:35:28'),
(NULL,	'bool',	'seo',	'urlExtension',	'',	0,	'2013-02-12 11:03:08'),
(NULL,	'text',	'apartment',	'countListitngmap',	'12',	0,	'2013-05-27 15:13:20'),
(NULL,	'text',	'apartment',	'countListitngtable',	'20',	0,	'2013-05-27 15:13:30'),
(NULL,	'text',	'apartment',	'countListitngblock',	'12',	0,	'2013-05-27 15:13:30'),
(NULL,	'bool',	'search',	'change_search_ajax',	'1',	0,	'2013-05-27 15:13:30'),
(NULL,	'text',	'mail',	'mail_fromName',	'',	1,	'2013-08-23 13:15:16'),
(NULL,	'bool',	'search',	'useCompactInnerSearchForm',	'0',	1,	'2013-08-23 13:15:16'),
(NULL,	'bool',	'share',	'useYandexShare',	'0',	0,	'2013-12-06 11:01:35'),
(NULL,	'bool',	'share',	'useInternalShare',	'1',	0,	'2013-12-06 11:01:35'),
(NULL,	'text',	'share',	'intenalServices',	'vk,odnoklassniki,facebook,twitter,mix,linkedin,reddit',	0,	'2013-12-06 11:05:12'),
(NULL,	'text',	'share',	'yaShareServices',	'yazakladki,moikrug,linkedin,vkontakte,facebook,twitter,odnoklassniki',	0,	'2013-12-06 11:05:12'),
(NULL,	'enum',	'apartment',	'apartment_periodActivityDefault',	'always',	0,	'2013-12-17 13:46:42'),
(NULL,	'bool',	'main',	'commentNeedApproval',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'main',	'commentAllowForGuests',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'main',	'useCaptchaCommentsForRegistered',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'main',	'enableCommentsForApartments',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'main',	'enableCommentsForEntries',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'main',	'enableCommentsForPages',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'main',	'enableCommentsForFaq',	'1',	0,	NOW()),
(NULL,	'bool',	'osmap',	'useOSMMap',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'osmap',	'module_apartments_osmapsCenterX',	'37.620717508911184',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'osmap',	'module_apartments_osmapsCenterY',	'55.75411314653655',	0,	'2016-08-15 10:30:25'),
(NULL,	'text',	'osmap',	'module_apartments_osmapsZoomApartment',	'15',	0,	'2016-08-15 10:30:25'),
(NULL, 'hidden', 'main', 'module_enabled_apartmentsComplain', '1', 0, '2014-04-07 16:52:08'),
(NULL, 'hidden', 'main', 'module_enabled_similarads', '1', 0, '2014-04-07 16:52:09'),
(NULL, 'hidden', 'main', 'module_enabled_socialauth', '1', 0, '2014-04-07 16:52:10'),
(NULL, 'hidden', 'main', 'module_enabled_comparisonList', '1', 0, '2014-04-07 16:52:12'),
(NULL, 'hidden', 'main', 'module_enabled_rss', '1', 0, '2014-04-07 16:52:14'),
(NULL, 'hidden', 'main', 'module_enabled_seo', '1', 0, '2014-04-07 16:52:15'),
(NULL, 'hidden', 'main', 'module_enabled_sitemap', '1', 0, '2014-04-07 16:52:17'),
(NULL, 'hidden', 'main', 'module_enabled_socialposting', '1', 0, '2014-04-07 16:52:20'),
(NULL, 'hidden', 'main', 'module_enabled_iecsv', '1', 0, '2014-04-07 16:52:26'),
(NULL, 'hidden', 'main', 'module_enabled_location', '1', 0, '2014-04-07 16:52:33'),
(NULL, 'hidden', 'main', 'module_enabled_yandexRealty', '1', 0, '2014-04-07 16:52:30'),
(NULL, 'hidden', 'main', 'module_enabled_slider', '1', 0, '2014-04-07 16:52:36'),
(NULL, 'hidden', 'main', 'module_enabled_advertising', '1', 0, '2014-04-07 16:52:39'),
(NULL, 'hidden', 'main', 'module_enabled_bookingcalendar', '1', 0, '2014-04-07 16:52:42'),
(NULL, 'hidden', 'main', 'module_enabled_formeditor', '1', 0, '2014-04-07 16:52:23'),
(NULL, 'hidden', 'main', 'module_enabled_messages', '1', 0, '2014-04-07 16:52:23'),
(NULL, 'bool', 'main', 'useUserRegistration', '1', 0, '2014-09-04 10:30:25'),
(NULL, 'hidden', 'main', 'module_enabled_rbac', '1', 0, '2015-03-09 10:30:25'),
(NULL,	'bool',	'apartment',	'useTypeRentHour',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'useTypeRentDay',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'useTypeRentWeek',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'useTypeRentMonth',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'useTypeSale',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'useTypeRenting',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'useTypeBuy',	'0',	0,	'2016-08-15 10:30:25'),
(NULL,	'bool',	'apartment',	'useTypeChange',	'1',	0,	'2016-08-15 10:30:25'),
(NULL,  'enum', 'mail', 'mailSMTPSecure', '', 1, '2016-08-15 10:30:25'),
(NULL, 'hidden', 'blockip', 'delete_ip_after_days', '5', 0, '2014-04-07 16:52:23'),
(NULL, 'hidden', 'main', 'module_enabled_tariffPlans', '1', 0, '2014-04-07 16:52:23'),
(NULL, 'enum', 'main', 'user_registrationMode', 'without_confirm', 0, '2015-05-13 15:30:52'),
(NULL, 'bool', 'apartment', 'enableUserAdsCopy', '1', 0, '2016-08-15 10:30:25'),
(NULL, 'bool', 'apartment', 'notDeleteListings', '0', 0, '2016-08-15 10:30:25'),
(NULL, 'bool',  'seo',  'allowUserSeo',  '1',  0,  '2016-08-15 10:30:25'),
(NULL, 'hidden', 'main', 'module_enabled_seasonalprices', '1', 0, '2015-09-10 18:02:03'),
(NULL, 'enum', 'apartment', 'defaultApartmentType', '2', 0, '2015-09-10 18:02:03'),
(NULL, 'hidden', 'main', 'module_enabled_metroStations', '1', 0, '2015-10-30 16:52:23'),
(NULL, 'hidden', 'main', 'module_enabled_historyChanges', '1', 0, '2015-11-09 16:52:23'),
(NULL, 'hidden', 'currency', 'currencySource', '1', 0, '2015-11-09 16:52:23'),
(NULL, 'bool', 'apartment', 'allowCustomCities', '1', 0, '2016-08-15 10:30:25'),
(NULL, 'bool', 'seo', 'useSchemaOrgMarkup', '1', 0, '2015-11-09 16:52:23'),
(NULL,	'text',	'geo',	'geo_time_cache',	'604800',	0,	'2016-08-15 10:30:25'),
(NULL,	'enum',	'geo',	'geo_in_search',	'1',	0,	'2016-01-28 10:00:03'),
(NULL,	'enum',	'geo',	'geo_in_index',	'1',	0,	'2016-01-28 09:59:54'),
(NULL,	'bool',	'geo',	'geo_in_index_flag',	'1',	0,	'2016-01-28 09:59:54'),
(NULL,	'enum',	'geo',	'geo_in_ad',	'3',	0,	'2016-01-28 10:00:19'),
(NULL,	'hidden',	'main',	'module_enabled_geo',	'1',	0,	'2016-01-27 17:00:04'),
(NULL,	'bool',	'main',	'useShowInfoUseCookie',	'1',	0,	'2016-01-27 17:00:04'),
(NULL, 'text', 'osmap', 'module_apartments_osmapsZoomManyApartments', '11', 0, '2016-04-15 10:30:25'),
(NULL, 'text', 'ymap', 'module_apartments_ymapsZoomManyApartments', '11', 0, '2016-04-15 10:30:25'),
(NULL, 'text', 'gmap', 'module_apartments_gmapsZoomManyApartments', '11', 0, '2016-04-15 10:30:25'),
(NULL, 'text', 'gmap', 'googleMapApiKey', '', 0, '2016-04-15 10:30:25'),
(NULL, 'bool', 'apartment', 'booking_half_day', '1', 1, '2016-04-15 10:30:25'),
(NULL, 'hidden', 'blockip', 'delete_history_changes_after_days', '90', 0, '2016-11-20 16:52:23');
INSERT INTO `{dbPrefix}configuration` (`id`, `type`, `section`, `name`, `value`, `allowEmpty`, `date_updated`) VALUES 
(NULL, 'bool',	'main',	'useReCaptcha',	'0',	0,	'2017-05-01 10:30:25'),
(NULL, 'text', 'main', 'reCaptchaKey', 'key', 0, '2017-05-01 10:30:25'),
(NULL, 'text', 'main', 'reCaptchaSecret', 'secret', 0, '2017-05-01 10:30:25'),
(NULL, 'bool', 'apartment', 'stepByStepAd', '1', 0, '2017-05-01 10:30:25'),
(NULL, 'bool', 'notifier', 'module_notifier_allow_replyToEmail', '1', 0, '2017-11-24 09:18:45'),
(NULL, 'bool', 'apartment', 'show_loan_calculator', '1', 0, '2018-10-10 10:30:25'),
(NULL, 'hidden', 'main', 'module_enabled_api', '1', 0, '2019-01-04 16:52:23'),
(NULL, 'hidden',	'main',	'module_enabled_articles',	'1',	0,	'2019-11-30 10:18:41'),
(NULL, 'hidden',	'main',	'module_enabled_reviews',	'1',	0,	'2019-11-30 10:18:46'),
(NULL, 'hidden',	'main',	'module_enabled_favorite',	'1',	0,	'2019-11-30 10:18:46'),
(NULL, 'hidden',	'images',	'thumbQuality',	'75',	0,	'2013-02-27 08:34:48'),
(NULL, 'bool',	'apartment',	'useTitleWithID',	'0',	0,	'2020-03-28 13:31:29'),
(NULL, 'bool',	'apartment',	'parentIdAll',	'0',	0,	'2020-03-28 14:30:56'),
(NULL, 'bool',	'main',	'shuffleSlider',	'0',	0,	'2020-03-29 14:50:19'),
(NULL, 'bool',	'apartment',	'descriptionUseEditor',	'1',	0,	'2020-03-29 14:50:19'),
(NULL, 'bool',	'main',	'convertYoutubeLink',	'1',	0,	'2020-05-30 15:46:22'),
(NULL, 'hidden', 'currency', 'currencySourceApiKey', '', 0, '2020-06-28 16:52:23'),
(NULL, 'bool',	'main',	'useLoginAdminSendEmailCode',	'0',	0,	'2021-01-09 18:25:23'),
(NULL, 'bool',	'seo',	'useSeoSearchConfigByLink',	'0',	0,	'2021-01-09 18:25:23'),
(NULL, 'bool',	'seo',	'useSeoSearchConfigBySearch',	'0',	0,	'2021-01-09 18:25:23'),
(NULL, 'bool',	'apartment',	'autoSaveEnableAdmin',	'1',	0,	'2021-01-09 18:25:23'),
(NULL, 'bool',	'apartment',	'autoSaveEnableUser',	'1',	0,	'2021-01-09 18:25:23'),
(NULL, 'text',	'apartment',	'autoSaveInterval',	'15',	0,	'2021-01-09 18:25:23');


DROP TABLE IF EXISTS `{dbPrefix}currency`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}currency` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `char_code` varchar(3) NOT NULL DEFAULT '',
  `value` float NOT NULL DEFAULT '0',
  `is_default` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `not_parse` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `sorter` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `char_code` (`char_code`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}currency` (`id`, `char_code`, `value`, `is_default`, `not_parse`, `active`, `sorter`, `date_updated`) VALUES
(1, 'RUB', 0.0152245, 0, 0, 1, 1, '2015-11-27 12:34:26'),
(2, 'AUD', 0.7222, 0, 0, 0, 1, '2015-11-27 12:34:26'),
(3, 'AZN', 0.955566, 0, 0, 0, 2, '2015-11-27 12:34:26'),
(4, 'GBP', 1.5099, 0, 0, 0, 3, '2015-11-27 12:34:26'),
(5, 'AMD', 0.00207857, 0, 0, 0, 4, '2015-11-27 12:34:26'),
(6, 'BYR', 0.0000547315, 0, 0, 0, 5, '2015-11-27 12:34:26'),
(7, 'BGN', 0.542329, 0, 0, 0, 6, '2015-11-27 12:34:26'),
(8, 'BRL', 0.267129, 0, 0, 0, 7, '2015-11-27 12:34:26'),
(9, 'HUF', 0.00339703, 0, 0, 0, 8, '2015-11-27 12:34:26'),
(10, 'DKK', 0.142207, 0, 0, 0, 9, '2015-11-27 12:34:26'),
(11, 'USD', 1, 1, 0, 1, 10, '2015-11-27 12:34:26'),
(12, 'EUR', 1.0612, 0, 0, 1, 11, '2015-11-27 12:34:26'),
(13, 'INR', 0.0150116, 0, 0, 0, 12, '2015-11-27 12:34:26'),
(14, 'KZT', 0.003255, 0, 0, 0, 13, '2015-11-27 12:34:26'),
(15, 'CAD', 0.751201, 0, 0, 0, 14, '2015-11-27 12:34:26'),
(16, 'KGS', 0.0136892, 0, 0, 0, 15, '2015-11-27 12:34:26'),
(17, 'CNY', 0.156506, 0, 0, 0, 16, '2015-11-27 12:34:26'),
(18, 'LVL', 56.899, 0, 0, 0, 17, '2013-02-27 11:39:18'),
(19, 'LTL', 11.5382, 0, 0, 0, 18, '2013-02-27 11:39:18'),
(20, 'MDL', 0.0497389, 0, 0, 0, 19, '2015-11-27 12:34:26'),
(21, 'NOK', 0.115407, 0, 0, 0, 20, '2015-11-27 12:34:26'),
(22, 'PLN', 0.248372, 0, 0, 0, 21, '2015-11-27 12:34:26'),
(23, 'RON', 0.23888, 0, 0, 0, 22, '2015-11-27 12:34:26'),
(24, 'XDR', 1.37356, 0, 0, 0, 23, '2015-11-27 12:34:26'),
(25, 'SGD', 0.710328, 0, 0, 0, 24, '2015-11-27 12:34:26'),
(26, 'TJS', 0.151263, 0, 0, 0, 25, '2015-11-27 12:34:26'),
(27, 'TRY', 0.345292, 0, 0, 1, 26, '2015-11-27 12:34:26'),
(28, 'TMT', 0.285714, 0, 0, 0, 27, '2015-11-27 12:34:26'),
(29, 'UZS', 0.00036563, 0, 0, 0, 28, '2015-11-27 12:34:26'),
(30, 'UAH', 0.0421053, 0, 0, 0, 29, '2015-11-27 12:34:26'),
(31, 'CZK', 0.0392434, 0, 0, 0, 30, '2015-11-27 12:34:26'),
(32, 'SEK', 0.114355, 0, 0, 0, 31, '2015-11-27 12:34:26'),
(33, 'CHF', 0.977422, 0, 0, 0, 32, '2015-11-27 12:34:26'),
(34, 'ZAR', 0.0704499, 0, 0, 0, 33, '2015-11-27 12:34:26'),
(35, 'KRW', 0.000870307, 0, 0, 0, 34, '2015-11-27 12:34:26'),
(36, 'JPY', 0.00815727, 0, 0, 0, 35, '2015-11-27 12:34:26'),
(37, 'SAR', 0.27, 0, 1, 1, 0, '2016-09-17 07:53:57');


DROP TABLE IF EXISTS `{dbPrefix}custom_html`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}custom_html` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `body_ru` text NULL,
  `body_en` text NULL,
  `body_de` text NULL,
  `body_es` text NULL,
  `body_ar` text NULL,
  `body_tr` text NULL,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}entries`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}entries` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `category_id` int(11) unsigned NOT NULL DEFAULT '0',
  `tags` text NULL,
  `image_id` int(11) unsigned NOT NULL DEFAULT '0',
  `title_ru` varchar(255) NOT NULL DEFAULT '',
  `body_ru` LONGTEXT NULL,
  `date_created` timestamp NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `body_en` LONGTEXT NULL,
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `title_de` varchar(255) NOT NULL DEFAULT '',
  `body_de` LONGTEXT NULL,
  `announce_ru` text NULL,
  `announce_en` text NULL,
  `announce_de` text NULL,
  `title_es` varchar(255) NOT NULL DEFAULT '',
  `body_es` LONGTEXT NULL,
  `announce_es` text NULL,
  `title_ar` varchar(255) NOT NULL DEFAULT '',
  `body_ar` LONGTEXT NULL,
  `announce_ar` text NULL,
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  `body_tr` longtext NULL,
  `announce_tr` text NULL,
  PRIMARY KEY (`id`),
  KEY `date_updated` (`date_updated`),
  KEY `category_id` (`category_id`),
  KEY `image_id` (`image_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}entries` (`id`, `active`, `category_id`, `tags`, `image_id`, `title_ru`, `body_ru`, `date_created`, `date_updated`, `body_en`, `title_en`, `title_de`, `body_de`, `announce_ru`, `announce_en`, `announce_de`, `title_es`, `body_es`, `announce_es`, `title_ar`, `body_ar`, `announce_ar`, `title_tr`, `body_tr`, `announce_tr`) VALUES
(1, 1, 2, 'статьи, articles', 0, 'Какие вещи во время переезда ломаются чаще всего?', '<p>При переезде в новый дом или квартиру, имейте ввиду: некоторые вещи сделаны, чтобы сломаться. Когда дело доходит до переезда, нужно быть осторожным.</p>\r\n\r\n<p><br />\r\nКакие вещи чаще всего могут сломаться или разбиться при переезде?<br />\r\n<br />\r\n<strong>#1 &ndash; Электронная техника</strong><br />\r\nКомпьютеры, телевизоры, а также домашние кинотеатры зачастую становятся жертвами поломки, когда наступает время переезда. Если уронить электронику, то ее чувствительные и хрупкие компоненты могут получить серьезные повреждения<br />\r\nВозможное решение? Сохраняйте коробки и упаковочные материалы, которые изначально шли вместе с вещами. Когда придет время перевезти их в новый дом, уложите гаджеты в упаковки и коробки так, как было при покупке.<br />\r\n<br />\r\n<strong>#2 &ndash; Cпина</strong><br />\r\nБоль в спине, растянутые мышцы, переломы костей -&nbsp; физические травмы, получаемые при попытке передвинуть тот же холодильник или фортепиано, не имея специального оборудования или силы нескольких человек.<br />\r\nИспользуйте прицеп для более крупной мебели, и заранее детально изучить маршрут передвижения.<br />\r\n<br />\r\n<strong>#3 &mdash; Зеркала</strong><br />\r\nСемь лет неудач грозит тому, кто попытается перевозить зеркала самостоятельно. Это хрупкая вещь.<br />\r\nЗеркала подвержены битью еще и потому, что их рамки не могут выдержать силы удара при падении или надавливании. Поэтому не спите на подушках, когда переезжаете &mdash; обкладывайте ими зеркала и другие хрупкие вещи! В любом случае их нужно упаковывать.<br />\r\n<br />\r\n<strong>#4 &mdash; Дом</strong><br />\r\nДверные косяки, стены и полы подвержены ударам и царапинам при перемещении крупных предметов мебели.<br />\r\nЕсли вы не хотите оставить царапины в старом или новом жилище, есть один надежный способ - нанять опытных грузчиков.<br />\r\n<br />\r\n<strong>#5 - Изделия из стекла /фарфора</strong><br />\r\nИзделия из стекла, фарфора, а также посуда являются одними из самых легко бьющихся во время переезда. Эти штучные изделия чрезвычайно хрупки и могут расколоться, если их упаковывать, как селедку в бочке.<br />\r\nПоэтому используйте бумагу и пузырчатую пленку и оставляйте пространство между ними и коробкой.<br />\r\n<br />\r\n<strong>#6 &mdash; Рамочные картины</strong><br />\r\nВо время переезда картины и другие произведения искусства подвержены самым разным повреждениям, если рядом с ними положить или упаковать предметы с острыми краями.<br />\r\nВо многих случаях рамки богато украшенные, дорогие, и легко трескаются. Пытаясь плотно упаковать в машину вещи, люди ставят на картины ящики. Если так делать, то можно легко их продырявить.</p>\r\n', '2019-01-05 05:02:21', '2020-03-16 11:34:24', '<p>If you&#39;re moving to a new house or apartment, be advised: Some things are made to be broken.<br />\nWhen it comes to moving, you&#39;ve got to be careful.<br />\n<br />\nWhich items are among the most likely to get smashed and dashed at moving time?<br />\n<br />\n<strong>#1 - Electronics</strong><br />\nComputers, TVs, and home entertainment systems are among the most likely victims of breakage when it comes time to move. If you drop electronics, the sensitive and delicate components can suffer major damage.<br />\nA possible solution? Save the boxes and packing materials that originally came with the items. When the time comes to transport the gear to your next home, re-pack your gadgets in the boxes and materials the way you purchased them.<br />\n<br />\n<strong>#2 - Your Back</strong><br />\nBack pain, pulled muscles, and broken bones are among the physical injuries you can suffer by trying to move that refrigerator or piano without the right equipment or people power.<br />\nUse a cart for larger pieces and go over the moving route in advance.<br />\n<br />\n<strong>#3 - Mirrors</strong><br />\nSeven years of bad luck might be in your future if you try to move mirrors yourself. It is a fragile item.<br />\nMirrors also can be prone to breakage because the frames holding them can&#39;t withstand the force of being dropped or jostled. So don&#39;t sleep on your pillows when you&#39;re moving - use them as cushions for mirrors and other fragile times! You&#39;ve got to pack them anyway.<br />\n<br />\n<strong>#4 - The House</strong><br />\nDoor jambs, walls, and floors are prone to getting hit and scraped when moving larger items.<br />\nIf you&#39;re worried about leaving any scratches on your old or new abode, one smart option might be to hire some experienced movers.<br />\n<br />\n<strong>#5 - Glassware/China</strong><br />\nGlassware, China, and dishes are among the most easily broken items during a move. These pieces are extremely fragile and can shatter when they&#39;re packed together like sardines.<br />\nSo use paper and bubble wrap and leave space between them and the box.<br />\n<br />\n<strong>#6 - Framed Artwork</strong><br />\nPaintings and artwork are subject to various kinds of damage during moves if you drop them or pack them next to objects with sharp edges.<br />\nVery many times, frames are very ornate, expensive, and easy to crack. People try to pack things tight in a truck and they put boxes on top of paintings. If you do that, it&#39;s easy to put holes in them.</p>\n', 'Which items often get broken during a move?', 'Welche Gegenstände oft bei einem Umzug kaputt gehen?', '<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\"><span lang=\"de-DE\">Wenn Sie in ein neues Haus oder eine Wohnung </span>umziehen<span lang=\"de-DE\">, wissen Sie: manche Dinge sind da, um gebrochen zu werden.<br />\nWenn es um eine</span><span lang=\"de-DE\"><span style=\"font-weight: normal\">n Umzug </span></span><span lang=\"de-DE\">geht, m&uuml;ssen Sie vorsichtig sein.</span></p>\n\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\"><br />\n<span lang=\"de-DE\">Welche</span><span lang=\"de-DE\"><span style=\"font-weight: normal\"> Gegenst&auml;nde </span></span><span lang=\"de-DE\">geh&ouml;ren zu den</span><span lang=\"de-DE\">en, die</span><span lang=\"de-DE\"><span style=\"font-weight: normal\"> oft bei </span></span><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">Um</span></span></span><em><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">z&uuml;ge </span></span></span></em><span lang=\"de-DE\"><span style=\"font-weight: normal\">kaputt gehen </span></span><span lang=\"de-DE\">oder gebrochen werden</span><span lang=\"de-DE\"><span style=\"font-style: normal\">?</span></span></p>\n\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\"><span lang=\"de-DE\"><span style=\"font-style: normal\"><b># 1 - </b></span></span><em><span style=\"font-style: normal\"><b>Elektronikger&auml;te</b></span></em><br />\n<span lang=\"de-DE\">Computer, Fernseher und Home Entertainment Systeme geh&ouml;ren zu den m&ouml;glichen Opfern vom Bruch, wenn die Zeit vom Umzug kommt. Wenn Sie Elektr</span><span lang=\"de-DE\"><span style=\"font-weight: normal\">onik</span></span><em><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">ger&auml;te</span></span></span></em><span lang=\"de-DE\"><span style=\"font-weight: normal\"> fallen l</span></span><span lang=\"de-DE\">assen, k&ouml;nnen die sensible und empfindliche Bauteile gro&szlig;en Sch&auml;den leiden.<br />\nEine m&ouml;gliche L&ouml;sung? Bewahren Sie die Kartons und Materialien, in denen die G</span><em><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">er&auml;te</span></span></span></em><span lang=\"de-DE\"> urspr&uuml;nglich verpackt sind. Wenn die Zeit kommt, sie zu Ihrem neuen Haus zu transportieren, verpacken Sie Ihre Gadgets in den Materialien und Kartons auf solche Weise, wie Sie sie gekauft haben.</span></p>\n\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\">&nbsp;<span lang=\"de-DE\"><b># 2 &ndash; Ihr </b></span><b>R&uuml;cken</b><br />\n<span lang=\"de-DE\">R&uuml;ckenschmerzen, Zerrungen und Knochenbr&uuml;che geh&ouml;ren zu den k&ouml;rperlichen Verletzungen, die Sie bekomme</span><span lang=\"de-DE\"><span style=\"font-style: normal\">n </span></span><em><span lang=\"de-DE\"><span style=\"font-style: normal\">k&ouml;nnen</span></span></em><span lang=\"de-DE\"><span style=\"font-style: normal\">,</span></span><span lang=\"de-DE\"> indem Sie versuchen, diesen K&uuml;hlschrank oder Klavier ohne die richtige Ausr&uuml;stung oder die Macht zu bewegen.<br />\nVerwenden Sie einen Wagen f&uuml;r gr&ouml;&szlig;ere St&uuml;cke und gehen &uuml;ber die bewegende Route im Voraus.</span><br />\n<br />\n<span lang=\"de-DE\"><b># 3 - Spiegel</b></span><br />\n<span lang=\"de-DE\"><span style=\"font-style: normal\">7 </span></span><em><span lang=\"de-DE\"><span style=\"font-style: normal\">Jahre Pech</span></span></em><span lang=\"de-DE\"><span style=\"font-style: normal\"> haben Sie, wenn ein Spiegel zerbrochen wird</span></span><span lang=\"de-DE\">, als Sie versuchen, ihn selbst zu transportieren. Er ist eine fragile Sache</span><span lang=\"de-DE\"><span style=\"font-weight: normal\">.</span></span><br />\n<span lang=\"de-DE\">Spiegel sind besonders </span><span lang=\"de-DE\">f&uuml;r Bruch </span><span lang=\"de-DE\">anf&auml;llig, weil seine Rahmen die Schlagkraft durch Fallenlassen oder Dr&uuml;cken nicht halte</span><span lang=\"de-DE\"><span style=\"font-style: normal\">n </span></span><em><span lang=\"de-DE\"><span style=\"font-style: normal\">k&ouml;nnen</span></span></em><span lang=\"de-DE\"><span style=\"font-style: normal\">. </span></span><span lang=\"de-DE\">Also schlafen Sie nicht auf Kopfkissen, wenn Sie umziehen - nutzen Sie sie f&uuml;r Zudecken von Spiegeln und andere fragile Sachen! In jedem Fall m&uuml;ssen sie verpackt werden.</span><br />\n<br />\n<span lang=\"de-DE\"><b># 4 &ndash; Das Haus</b></span><br />\n<span lang=\"de-DE\">T&uuml;rpfosten, W&auml;nde und B&ouml;den sind immer beim Bewegen von gr&ouml;&szlig;eren Gegenst&auml;nden geschlagen und gekratzt .<br />\nWenn Sie keine Kratzer in Ihrer alten oder neuen Wohnung hinterlasen wollen, gibt es eine zuverl&auml;ssige L&ouml;sung: stellen Sie erfahrene </span><font color=\"#000000\"><span lang=\"de-DE\">M&ouml;belr&auml;umer an</span></font><span lang=\"de-DE\">.</span><br />\n<br />\n<span lang=\"de-DE\"><b># 5 - Glaswaren / Porzellan</b></span><br />\n<span lang=\"de-DE\">Glasware</span><span lang=\"de-DE\"><span style=\"font-weight: normal\">n, Porzellan un</span></span><span lang=\"de-DE\">d Geschirr geh&ouml;ren zu den leicht gebrochen w&auml;hrend des Umzugs Gegenst&auml;nden. Diese St&uuml;cke sind &auml;u&szlig;erst fragil und </span><em><span lang=\"de-DE\"><span style=\"font-style: normal\">k&ouml;nnen</span></span></em><span lang=\"de-DE\"> zerbrechen, wenn sie wie Hering in einem Fass verpackt sind.<br />\nSo benutzen Sie Papier und Luftpolsterfolie und lassen Raum zwischen ihnen und dem Karton.</span><br />\n<br />\n<span lang=\"de-DE\"><b># 6 &ndash; Gem&auml;lde</b></span><br />\n<span lang=\"de-DE\">Gem&auml;lde und andere Kunstwerke sind</span><span lang=\"de-DE\"> </span><span lang=\"de-DE\">f&uuml;r </span><span lang=\"de-DE\">verschiedene Arten von Sch&auml;den bei Umz&uuml;gen </span><span lang=\"de-DE\">anf&auml;llig</span><span lang=\"de-DE\">, wenn man sie fallen l&auml;sst oder sie neben den Objekten mit scharfen Kanten packt.</span><br />\n<span lang=\"de-DE\">Oft sind die Rahmen sehr reich verzierten, teuer und leicht zu knacken. Man versucht, die Dinge fest in einem LKW zu packen und setzt K&auml;stchen auf die </span><span lang=\"de-DE\">Gem&auml;lde. </span><span lang=\"de-DE\">Wenn Sie es tun, ist es einfach, L&ouml;cher in ihnen zu setzen.</span></p>\n\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\">&nbsp;</p>\n', '<p>При переезде в новый дом или квартиру, имейте ввиду: некоторые вещи сделаны, чтобы сломаться. Когда дело доходит до переезда, нужно быть осторожным.</p>\r\n', '<p>If you&#39;re moving to a new house or apartment, be advised: Some things are made to be broken.</p>\n', '<p><span lang=\"de-DE\">Wenn Sie in ein neues Haus oder eine Wohnung&nbsp;</span>umziehen<span lang=\"de-DE\">, wissen Sie: manche Dinge sind da, um gebrochen zu werden.<br />\r\nWenn es um eine</span><span lang=\"de-DE\">n Umzug&nbsp;</span><span lang=\"de-DE\">geht, m&uuml;ssen Sie vorsichtig sein.</span></p>\r\n', 'Quales los elementos que a menudo se rompen durante una mudanza?', '<p> 	Si se est&aacute; mudando a una nueva casa o apartamento, tenga en cuenta: Algunas cosas est&aacute;n hechas para romperse.<br /> 	Cuando se trata de mover, tienes que tener cuidado.<br /> 	&iquest;Qu&eacute; art&iacute;culos son los m&aacute;s propensos a roto y discontinuas en el tiempo de movimiento?</p> <p> 	<strong># 1 - Electr&oacute;nica</strong><br /> 	Computadoras, televisores, y sistemas de entretenimiento en el hogar se encuentran entre las v&iacute;ctimas m&aacute;s probables de rotura cuando llega el momento de moverse. Si se le cae la electr&oacute;nica, los componentes sensibles y delicadas pueden sufrir da&ntilde;os importantes.</span><br /> 	Una posible soluci&oacute;n? Guarde las cajas y materiales de embalaje que vinieron originalmente con los art&iacute;culos. Cuando llegue la hora de transportar el equipo para su pr&oacute;xima casa, re-empacar sus regalos en las cajas y materiales de la forma en que los compr&oacute;.</p> <p> 	<strong># 2 - Su espalda</strong><br /> 	El dolor de espalda, tirones musculares y huesos rotos son algunas de las lesiones f&iacute;sicas que pueden sufrir al tratar de mover ese refrigerador o el piano sin el equipo adecuado o el poder del pueblo.<br /> 	Use un carrito para las piezas m&aacute;s grandes e ir por la ruta que se mueve en avance.</p> <p> 	<strong># 3 - Espejos</strong><br /> 	Siete a&ntilde;os de mala suerte podr&iacute;a estar en tu futuro si intenta mover espejos ti mismo. Se trata de un art&iacute;culo fr&aacute;gil.<br /> 	Los espejos tambi&eacute;n pueden ser propensos a la rotura ya los marcos de la celebraci&oacute;n que no pueden resistir la fuerza de haberse ca&iacute;do o se empujaban.As&iacute; que no dormir en las almohadas cuando est&aacute;s en movimiento - usarlas como protecci&oacute;n para espejos y otras veces fr&aacute;giles! Hay que hacer las maletas de todos modos.</p> <p> 	<strong># 4 - La Casa</strong><br /> 	Jambas de puertas, paredes y suelos son propensos a ser golpeado y raspado al mover objetos grandes.<br /> 	Si usted est&aacute; preocupado acerca de dejar ara&ntilde;azos en su morada vieja o nueva, una opci&oacute;n inteligente podr&iacute;a ser la de contratar a algunos promotores experimentados.</p> <p> 	<strong># 5 - Cristaler&iacute;a / China:</strong><br /> 	Cristaler&iacute;a, China, y los platos est&aacute;n entre los art&iacute;culos m&aacute;s f&aacute;cilmente roto durante un movimiento. Estas piezas son muy fr&aacute;giles y pueden romperse cuando son empacados como sardinas.<br /> 	A fin de utilizar papel y pl&aacute;stico de burbujas y dejar espacio entre ellos y la caja.</p> <p> 	<strong># 6 - Obra enmarcada</strong><br /> 	Pinturas y obras de arte est&aacute;n sujetos a diversos tipos de da&ntilde;o durante movimientos si dejas caer o embalarlos junto a objetos con bordes afilados.<br /> 	Muy muchas veces, los marcos son muy adornado, costoso y f&aacute;cil de descifrar. La gente trata de llevar las cosas apretadas en un cami&oacute;n y que pusieron las cajas en la parte superior de la pintura. Si lo haces, es f&aacute;cil de poner agujeros en ellos. </p>', 'Si se est&aacute; mudando a una nueva casa o apartamento, tenga en cuenta: Algunas cosas est&aacute;n hechas para romperse.', 'البنود التي غالبا ما تحصل على كسر أثناء تحرك؟', '<p>لو كنت&#39;re الانتقال إلى منزل جديد أو شقة ، العلم: بعض الأشياء قد تكون مكسورة.<br />\r\nعندما يتعلق الأمر بالتحرك ، &#39;ve يجب أن يكون حذرا.<br />\r\n<br />\r\nالبنود التي هي من بين الأكثر احتمالا للحصول على تحطيم وانطلق في الانتقال الوقت ؟ <br />\r\n<br />\r\n<قوية>#1 - إلكترونيات</strong><br />\r\nأجهزة الكمبيوتر أو أجهزة التلفاز وأنظمة الترفيه المنزلية هي من بين الأكثر احتمالا ضحايا الكسر عندما يحين الوقت للتحرك. إذا قمت بإسقاط الالكترونيات الحساسة المكونات الحساسة يمكن أن تعاني من ضرر كبير.<br />\r\nممكن حل ؟ حفظ صناديق التعبئة المواد التي جاءت في الأصل مع العناصر. عندما يحين الوقت لنقل العتاد إلى المنزل الخاص بك المقبل ، إعادة حزمة الأدوات الخاصة بك في صناديق المواد الطريقة التي يمكنك شراؤها.<br />\r\n<br />\r\n<قوية>#2 - بك مرة أخرى</strong><br />\r\nآلام الظهر ، سحبت العضلات و العظام المكسورة هي من بين الإصابات الجسدية يمكن أن تعاني من يحاول نقل تلك الثلاجة أو البيانو دون الحق في المعدات أو سلطة الشعب.<br />\r\nاستخدام عربة أكبر قطعة ويذهب أكثر تتحرك الطريق في وقت مبكر.<br />\r\n<br />\r\n<قوية>#3 - المرايا</strong><br />\r\nسبع سنوات من سوء الحظ قد يكون في المستقبل إذا حاولت تحريك المرايا نفسك. وهو الهشة البند.<br />\r\nالمرايا يمكن أيضا أن تكون عرضة للكسر لأن إطارات عقد لهم أن&#39;t تصمد أمام قوة يتم إسقاط أو تزاحم. لذلك لا&#39;t النوم على الوسائد عند&#39;re تتحرك استخدامها كما وسائد المرايا وغيرها الهشة مرات! كنت&#39;ve أن حزمة لهم على أي حال.<br />\r\n<br />\r\n<قوية>#4 - البيت</strong><br />\r\nعضادات الباب والجدران والأرضيات عرضة الحصول على ضرب وكشط عندما تتحرك الأشياء الكبيرة.<br />\r\nإذا كنت&#39;re قلق ترك أي خدوش على القديم أو الجديد مسكن واحد ذكي قد يكون الخيار إلى استئجار بعض ذوي الخبرة المحرك.<br />\r\n<br />\r\n<قوية>#5 - الأواني الزجاجية/الصين</strong><br />\r\nالأواني الزجاجية, الصين, والأطباق هي من بين الأكثر كسر بسهولة البنود خلال هذه الخطوة. هذه القطع هي هشة للغاية ويمكن أن تتحطم عندما&#39;re معبأة معا مثل السردين.<br />\r\nوذلك باستخدام ورقة التفاف فقاعة وترك مساحة بينهم وبين الصندوق.<br />\r\n<br />\r\n<قوية>#6 - تأطير العمل الفني</strong><br />\r\nاللوحات والأعمال الفنية تخضع لأنواع مختلفة من الضرر خلال التحركات إذا كنت قطرة منها أو حزمة لهم بجوار الكائنات مع حواف حادة.<br />\r\nجدا عدة مرات, الإطارات المزخرفة جدا و مكلف و سهل للقضاء. الناس في محاولة حزمة الأشياء ضيق في شاحنة و وضعوا صناديق على أعلى من اللوحات. إذا كنت تفعل ذلك ، &#39;s من السهل وضع ثقوب في نفوسهم.</p>', '<p>لو كنت&#39;re الانتقال إلى منزل جديد أو شقة ، العلم: بعض الأشياء قد تكون مكسورة.</p>', 'Öğeler genellikle hareket sırasında kırıldı?', '<p>Eğer yeni bir ev veya apartman için hareket eden, tedbirli olmak istiyorsan: Bazı şeyler kırılmak için vardır.<br />\nHareket gelince, dikkatli olmalısın.<br />\n<br />\nÖğeleri zaman hareket de ezildi ve kesik almak için büyük olasılıkla arasında olan?<br />\n<br />\n<strong>#1 - Elektronik</strong><br />\nGitme zamanı geldiğinde bilgisayar, Televizyon ve ev eğlence sistemleri kırılması en muhtemel kurbanları arasında yer alıyor. Eğer elektronik bırakın, duyarlı ve hassas bileşenleri büyük zarar verebilir.<br />\nOlası bir çözüm? Aslında öğeleri ile birlikte gelen kutuları ve ambalaj malzemelerini saklayın. Zaman bir sonraki ev için dişli taşımak için geldiğinde, yeniden kutular ve malzeme olarak satın aldığınız yolu araçları paketi.<br />\n<br />\n<strong>#2 - </strong><br />\nSırt ağrısı, kas çekti ve kırık kemikler doğru ekipman veya insan gücü olmadan, buzdolabında ya da piyano taşımaya çalışıyor acı çekeceksin fiziksel yaralanmalar arasında yer alıyor.<br />\nDaha büyük parçalar için el arabası kullanın ve önceden taşıma güzergahı üzerinde.<br />\n<br />\n<strong>#3 - Aynalar</strong><br />\nKötü şans yedi yıl kendinizi aynası taşımak için çalışırsanız geleceğiniz olabilir. Kırılgan bir madde.<br />\nAynalar da onları tutan çerçeveleri düştü ya da en küçük birimidir olmanın gücü dayanabilir çünkü kırılmaya eğilimli olabilir. Bu yüzden aynalar ve diğer kırılgan zamanlar için yastık olarak kullanmak hareketli olunca yastık üzerinde uyku yok! Zaten onlara verirsiniz.<br />\n<br />\n<strong>#4 - Ev</strong><br />\nKapı çerçeveler, duvarlar ve zemin kazaya eğilimli ve büyük eşyalar taşırken kazınmış.<br />\nEğer eski ya da yeni evinizin üzerinde herhangi bir çizik bırakarak hakkında endişeli iseniz, bir akıllı seçenek bazı deneyimli movers işe olabilir.<br />\n<br />\n<strong>5 - Cam/Çin #</strong><br />\nCam, Çin, ve tabaklar kırık en kolay öğeleri arasında bir hareket sırasında. Bu parçalar son derece kırılgan ve sardalye gibi paketlenmiş olduklarında paramparça olabilir.<br />\nKağıt ve kabarcık şal kullanın ve onları ve kutu arasında boşluk bırakın.<br />\n<br />\n<strong>#6 - Çerçeveli Resimler</strong><br />\nEğer onları bırakırsan veya keskin kenarlı nesnelerin yanında paketi ve resim hareket sırasında hasar çeşitli tabidir.<br />\nÇok kez, çerçeve çok süslü, pahalı ve kolay çatlak. İnsanlar sıkı bir kamyonda eşya çalışın ve resimler üstünde kutuları koydular. Bunu yaparsanız, onları delik açmak çok kolay.</p>\n', '<p>Eğer yeni bir ev veya apartman için hareket eden, tedbirli olmak istiyorsan: Bazı şeyler kırılmak için vardır.</p>\n'),
(2, 1, 2, 'articles, статьи', 1, 'Наилучшие для проживания города', '<p>Чтобы найти наилучшие для проживания города, требуется провести небольшое исследование. Cобрав все данные и проведя опросы c этой целью, многие компании и организации проделали за вас большую работу.<br />\r\n<br />\r\n<strong>Наилучшие для проживания города мира</strong><br />\r\nНаходящаяся в Лондоне Консалтинговая группа Economist Intelligence Unit (EIU) составила список городов мира, наилучших для проживания и посещения.<br />\r\n<br />\r\nИзучив 40 различных показатеоей, разделенных по 5 отдельным категориям, включая стабильность, здравоохранение, культуру и окружающую среду, образование и инфраструктуру, консалтинговая группа опубликовала несколько интересных фактов.<br />\r\nВновь возглавляют список города Канады, а три канадских города вошли в первую пятерку. Бывший №1, Ванкувер, сохранил первое место, усилив свою позицию благодаря Олимпийским играм-2010, проведение которых укрепило позицию города по категориям: культура, окружающая среда и инфраструктура. Фактически весь топ-5 городов сохранился неизменным. Из городов США лучший &ndash; Питтсбург, стоящий на 29 месте в списке всех городов мира.<br />\r\n1.Ванкувер, Канада<br />\r\n2.Мельбурн, Австралия<br />\r\n3.Вена, Австрия<br />\r\n4.Торонто, Канада<br />\r\n5.Калгари, Канада</p>\r\n', '2019-01-05 05:02:49', '2020-03-16 11:34:26', '<p>Finding the best places to live takes a little research. Many companies and organizations have done a lot of the legwork for you, having compiled data and conducted surveys for that purpose.<br />\n<br />\n<strong>World&#39;s Best Places to Live</strong><br />\nThe London-based Economist Intelligence Unit&#39;s (EIU) Liveability Ranking, conducted a worldwide search for the best places to live and visit.<br />\n<br />\nLooking at 40 different indicators arranged in five separate categories, including stability, healthcare, culture and environment, education and infrastructure, EIU published some interesting findings. Once more, Canadian cities ranked high, with three cities in the top five. Former #1, Vancouver, retains its top spot, stregthening its position with the success of the 2010 Olympics, which bolstered the city&#39;s cultural, environmental and infrastructure areas. In fact, the top 5 cities remain unchanged. The best ranked US city is Pittsburgh, coming in at 29th in the World.<br />\n1. Vancouver, Canada<br />\n2. Melbourne, Australia<br />\n3. Vienna, Austria<br />\n4. Toronto, Canada<br />\n5. Calgary, Canada</p>\n', 'Best Places to Live', 'Die besten Städte zum Leben', '<style type=\"text/css\"><!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in; direction: ltr; color: #00000a; widows: 0; orphans: 0 }\r\n		P.western { font-family: \"Times New Roman\", serif; font-size: 12pt; so-language: en-US }\r\n		P.cjk { font-family: \"Droid Sans Fallback\"; font-size: 12pt; so-language: zh-CN }\r\n		P.ctl { font-family: \"Lohit Hindi\"; font-size: 12pt; so-language: hi-IN }\r\n		A:visited { so-language: en-US }\r\n		A:link { so-language: en-US }\r\n	-->\r\n</style>\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\"><span lang=\"de-DE\">Um d</span><span lang=\"de-DE\"><span style=\"font-style: normal\">ie besten </span></span><em><span lang=\"de-DE\"><span style=\"font-style: normal\">St&auml;dte</span></span></em><span lang=\"de-DE\"><span style=\"font-style: normal\"> zum L</span></span><span lang=\"de-DE\">eben zu finden, muss man eine kleine Forschung durchf&uuml;hren. Viele Unternehmen und Organisationen haben eine Menge von der Zuarbeit f&uuml;r Sie gemacht, als sie Daten zusammengestellt haben und Umfragen f&uuml;r diesen Zweck durchf&uuml;hrt haben.</span><br />\r\n<br />\r\n<span lang=\"de-DE\"><b>D</b></span><span lang=\"de-DE\"><span style=\"font-style: normal\"><b>ie besten </b></span></span><em><span lang=\"de-DE\"><span style=\"font-style: normal\"><b>St&auml;dte der Welt</b></span></span></em><span lang=\"de-DE\"><span style=\"font-style: normal\"><b> zum L</b></span></span><span lang=\"de-DE\"><b>eben</b></span><br />\r\n<span lang=\"de-DE\">Die Londoner Economist Intelligence Unit (EIU) hat eine weltweite Suche nach den besten Pl&auml;tzen zum Leben und zum Besuchen durchf&uuml;hrt.</span><br />\r\n<style type=\"text/css\"><!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in; direction: ltr; color: #00000a; widows: 0; orphans: 0 }\r\n		P.western { font-family: \"Times New Roman\", serif; font-size: 12pt; so-language: en-US }\r\n		P.cjk { font-family: \"Droid Sans Fallback\"; font-size: 12pt; so-language: zh-CN }\r\n		P.ctl { font-family: \"Lohit Hindi\"; font-size: 12pt; so-language: hi-IN }\r\n		A:visited { so-language: en-US }\r\n		A:link { so-language: en-US }\r\n	-->\r\n</style>\r\n</p>\r\n\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\"><span lang=\"de-DE\">Nach der Betrachtung von 40 verschiedenen Indikatoren</span><span lang=\"de-DE\">, die in f&uuml;nf verschiedenen Kategorien angeordnet sind, einschlie&szlig;lich der Stabilit&auml;t, Gesundheitswesen, Kultur und Umwelt, Bildung und Infrastruktur, hat EIU einige interessante Erkenntnisse ver&ouml;ffentlicht. Noch einmal sind kanadische St&auml;dte auf der Liste oben, und drei St&auml;dte </span>geh&ouml;ren zur <span lang=\"de-DE\"> Top-F&uuml;nf. Ehemalige Nr. 1, Vancouver, beh&auml;lt seinen Spitzenplatz, die Stadt hat ihre Position mit dem Erfolg der Olympischen Spiele-2010 verst&auml;rkt, die ihre Stelle in Kultur-, Umwelt- und Infrastruktur-Bereichen st&uuml;tzte. In der Tat bleiben die Top-5-St&auml;dte unver&auml;ndert. Die bestplatzierte Stadt von den USA ist Pittsburgh, sie kam am 29. Platz auf der Weltliste.</span></p>\r\n\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\">\r\n<style type=\"text/css\"><!--\r\n		@page { margin: 0.79in }\r\n		P { margin-bottom: 0.08in; direction: ltr; color: #00000a; widows: 0; orphans: 0 }\r\n		P.western { font-family: \"Times New Roman\", serif; font-size: 12pt; so-language: en-US }\r\n		P.cjk { font-family: \"Droid Sans Fallback\"; font-size: 12pt; so-language: zh-CN }\r\n		P.ctl { font-family: \"Lohit Hindi\"; font-size: 12pt; so-language: hi-IN }\r\n		A:visited { so-language: en-US }\r\n		A:link { so-language: en-US }\r\n	-->\r\n</style>\r\n</p>\r\n\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\"><span lang=\"de-DE\">1. Vancouver, Kanada<br />\r\n2. Melbourne, Australien<br />\r\n3. Wien, &Ouml;sterreich<br />\r\n4. Toronto, Kanada<br />\r\n5. Calgary, Kanada</span></p>\r\n\r\n<p class=\"western\" lang=\"en-US\" style=\"margin-bottom: 0in\">&nbsp;</p>\r\n', '<p>Чтобы найти наилучшие для проживания города, требуется провести небольшое исследование. Cобрав все данные и проведя опросы c этой целью, многие компании и организации проделали за вас большую работу.</p>\r\n', '<p>Finding the best places to live takes a little research. Many companies and organizations have done a lot of the legwork for you, having compiled data and conducted surveys for that purpose.</p>\n', '<p><span lang=\"de-DE\">Um d</span><span lang=\"de-DE\">ie besten&nbsp;</span><em><span lang=\"de-DE\"><span style=\"font-style: normal;\">St&auml;dte</span></span></em><span lang=\"de-DE\">&nbsp;zum L</span><span lang=\"de-DE\">eben zu finden, muss man eine kleine Forschung durchf&uuml;hren. Viele Unternehmen und Organisationen haben eine Menge von der Zuarbeit f&uuml;r Sie gemacht, als sie Daten zusammengestellt haben und Umfragen f&uuml;r diesen Zweck durchf&uuml;hrt haben.</span></p>\r\n', 'Los mejores lugares para vivir', '<p> 	<span id=\"result_box\" lang=\"es\"><span class=\"hps\">Encontrar los mejores</span> <span class=\"hps\">lugares para vivir</span> <span class=\"hps\">se necesita un poco</span> <span class=\"hps\">de investigaci&oacute;n.</span> <span class=\"hps\">Muchas empresas</span> <span class=\"hps\">y organizaciones que</span> <span class=\"hps\">han hecho</span> <span class=\"hps\">una gran parte del</span> <span class=\"hps\">trabajo por usted</span><span>, despu&eacute;s de haber</span> <span class=\"hps\">recopilado datos</span> <span class=\"hps\">y encuestas realizadas</span> <span class=\"hps\">a tal efecto</span><span>.</span><br /> 	<br /> 	<strong><span class=\"hps\">Los mejores lugares</span> <span class=\"hps\">del</span> <span class=\"hps\">mundo para vivir</span></strong><br /> 	<span class=\"hps\">Clasificaci&oacute;n</span> <span class=\"hps\">Viabilidad</span> <span class=\"hps\">La</span> <span class=\"hps\">Economist Intelligence</span> <span class=\"hps\">con sede en Londres</span> <span class=\"hps\">de la Unidad</span> <span class=\"hps atn\">(</span><span>EIU</span><span>)</span><span>,</span> <span class=\"hps\">llev&oacute; a cabo</span> <span class=\"hps\">una b&uacute;squeda mundial de</span> <span class=\"hps\">los mejores</span> <span class=\"hps\">lugares para vivir</span> <span class=\"hps\">y visitar.</span><br /> 	<br /> 	<span class=\"hps\">En cuanto a</span> <span class=\"hps\">40</span> <span class=\"hps\">indicadores</span> <span class=\"hps\">diferentes</span> <span class=\"hps\">dispuestas en</span> <span class=\"hps\">cinco</span> <span class=\"hps\">categor&iacute;as diferentes</span><span>, incluyendo la estabilidad</span><span>, salud,</span> <span class=\"hps\">cultura y medio ambiente</span><span>, educaci&oacute;n e infraestructura</span><span>,</span> <span class=\"hps\">EIU</span> <span class=\"hps\">publica</span> <span class=\"hps\">algunas conclusiones interesantes</span><span>.</span> <span class=\"hps\">Una vez</span> <span class=\"hps\">m&aacute;s</span><span>, las ciudades canadienses</span> <span class=\"hps\">puestos altos</span><span>, con tres</span> <span class=\"hps\">ciudades de</span> <span class=\"hps\">los cinco primeros.</span> <span class=\"hps\">El ex</span> <span class=\"hps\">No. 1</span><span>, Vancouver,</span> <span class=\"hps\">mantiene su</span> <span class=\"hps\">primer puesto</span><span>,</span> <span class=\"hps\">stregthening</span> <span class=\"hps\">su posici&oacute;n</span> <span class=\"hps\">con el &eacute;xito de</span> <span class=\"hps\">los Juegos Ol&iacute;mpicos de</span> <span class=\"hps\">2010</span><span>, que</span> <span class=\"hps\">reforz&oacute;</span> <span class=\"hps\">las &aacute;reas</span> <span class=\"hps\">culturales</span><span>, ambientales</span> <span class=\"hps\">y de infraestructura</span> <span class=\"hps\">de la ciudad.</span> <span class=\"hps\">De hecho</span><span>,</span> <span class=\"hps\">las</span> <span class=\"hps\">5</span> <span class=\"hps\">mejores</span> <span class=\"hps\">ciudades</span> <span class=\"hps\">permanecen sin cambios.</span> <span class=\"hps\">La ciudad</span> <span class=\"hps\">mejor</span> <span class=\"hps\">clasificada</span> <span class=\"hps\">EE.UU.</span> <span class=\"hps\">es</span> <span class=\"hps\">Pittsburgh</span><span>, llegando a</span> <span class=\"hps\">29</span> <span class=\"hps\">en el mundo</span><span>.</span></span></p> <p> 	<br /> 	<span lang=\"es\"><span class=\"hps\">1</span><span>.</span> <span class=\"hps\">Vancouver</span><span>, Canad&aacute;</span><br /> 	<span class=\"hps\">2</span><span>.</span> <span class=\"hps\">Melbourne,</span> <span class=\"hps\">Australia</span><br /> 	<span class=\"hps\">3</span><span>.</span> <span class=\"hps\">Viena</span><span>, Austria</span><br /> 	<span class=\"hps\">4</span><span>.</span> <span class=\"hps\">Toronto,</span> <span class=\"hps\">Canada</span><br /> 	<span class=\"hps\">5</span><span>.</span> <span class=\"hps\">Calgary</span><span>, Canad&aacute;</span></span></p>', '<p> Encontrar los mejores lugares para vivir se necesita un poco de investigaci&oacute;n. Muchas empresas y organizaciones que han hecho una gran parte del trabajo por usted, despu&eacute;s de haber recopilado datos y encuestas realizadas a tal efecto. </p>', 'أفضل الأماكن للعيش', '<p>العثور على أفضل الأماكن للعيش يأخذ القليل من البحث. العديد من الشركات و المنظمات قد فعلت الكثير من يغوورك لك ، وبعد جمع البيانات وإجراء الدراسات الاستقصائية لهذا الغرض.<br />\r\n<br />\r\n<قوية>العالم&#39;s أفضل الأماكن للعيش</strong><br />\r\nومقرها لندن وحدة الاستخبارات الاقتصادية&#39;s (EIU) حضريا الترتيب ، التي أجريت في جميع أنحاء العالم في البحث عن أفضل الأماكن للعيش والزيارة.<br />\r\n<br />\r\nتبحث في 40 المؤشرات المختلفة مرتبة في خمس فئات منفصلة ، بما في ذلك الاستقرار والرعاية الصحية والثقافة والبيئة والتعليم والبنية التحتية ، EIU نشرت بعض النتائج المثيرة للاهتمام. مرة واحدة أكثر المدن الكندية المرتبة العالية ، مع ثلاث مدن في المراكز الخمسة الأولى. السابق #1, فانكوفر ، يحتفظ صدارة stregthening موقفها مع نجاح دورة الالعاب الاولمبية عام 2010 ، التي عززت المدينة&#39;s والثقافية والبيئية والبنية التحتية. في الواقع ، فإن أفضل 5 مدن لا تزال دون تغيير. أفضل الأمريكية في المرتبة مدينة بيتسبرغ ، تأتي في 29 في العالم.<br />\r\n1. فانكوفر ، كندا<br />\r\n2. ملبورن, استراليا<br />\r\n3. فيينا, النمسا<br />\r\n4. تورونتو ، كندا<br />\r\n5. كالجاري, كندا</p>', '<p>العثور على أفضل الأماكن للعيش يأخذ القليل من البحث. العديد من الشركات و المنظمات قد فعلت الكثير من يغوورك لك ، وبعد جمع البيانات وإجراء الدراسات الاستقصائية لهذا الغرض.</p>', 'En iyi Yerlerde Yaşamak ', '<p>Yaşamak için en iyi yerler bulmak biraz araştırma alır. Birçok şirket ve kuruluşlar için ayak işi çok yaptım, bu amaç için veri ve yapılan anketler derlenmiş olması.<br />\n<br />\n<strong>Dünyanın en İyi Yerlerde Yaşamak</strong><br />\nLondra merkezli Economist İstihbarat Birimi (EIU) Yaşanabilirlik Sıralamasında, yaşamak ve ziyaret etmek için en iyi yerler için dünya çapında bir arama yaptı.<br />\n<br />\nBeş ayrı kategori, istikrar, Sağlık, Kültür ve çevre, eğitim ve altyapı olmak üzere düzenlenen 40 farklı göstergelere bakmak, EIU bazı ilginç bulgularını yayınladı. Bir kez daha, Kanada şehirleri yüksek rütbeli, ilk beşte üç şehir. #1 Eski, Vancouver, üst noktaya korur, şehrin kültürel, çevre ve altyapı alanlarında takviye olan 2010 Olimpiyatları başarı ile konumunu stregthening. Aslında, ilk 5 şehirler değişmeden kalır. En iyi şehir Pittsburgh BİZİ sıralamada, 29 ve Dünyaya geliyor.<br />\n1. Vancouver, Kanada<br />\n2. Melbourne, Avustralya<br />\n3. Viyana, Avusturya<br />\n4. Toronto, Kanada<br />\n5. Calgary, Kanada</p>\n', '<p>Yaşamak için en iyi yerler bulmak biraz araştırma alır. Birçok şirket ve kuruluşlar için ayak işi çok yaptım, bu amaç için veri ve yapılan anketler derlenmiş olması.</p>\n'),
(3, 1, 1, 'lego, news, новости', 3, 'В качестве отделки для лестницы в одной из квартир Манхэттена использовали 20000 блоков Lego', '<p>Обычно при поиске нового дома нужно учитывать такие вещи, как наличие встроенной посудомоечной машины или центрального кондиционирования. Однако одна из квартир на Манхэттене выделяется среди прочих своей необычностью &mdash; и это никак не связано с системами жизнеобеспечения. Лестницу в этом доме украшают красочные перила, полностью построенные из блоков Lego.</p>\r\n\r\n<div align=\"center\"><img src=\"http://architector.ua/images/articles/AlexA/pic_big/pic_1340266348.jpg\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n\r\n<p>Их дизайн разработан одним из официальных художников Lego в Нью-Йорке - да, такая профессия действительно существует - перила поднимаются на второй уровень квартиры. Их построили в основном из белых блоков, но&nbsp; выделяются они красочной отделкой на концах, включая большие открытые участки, придающие им очень абстрактный вид.<br />\r\nКонечно, блоками Lego можно отделать дом по-своему, если достаточно времени и терпения. Тем не менее, мы бы не советовали полагаться на пластмассовые игрушечные блоки при создании вещей, на которые планируете ставить что-то тяжелое. Более того, неудачно споткнувшись на лестнице из Lego, вы можете превратить ее в огромную кучу разъединенных блоков и разбитые мечты.</p>\r\n', '2019-01-05 05:03:16', '2020-03-16 11:34:29', '<p>Usually when you&#39;re looking for a new home, you need to consider things like whether or not it has a built-in dishwasher or central air conditioning. But one apartment in Manhattan has a rather unique feature that helps it stand out from the rest &mdash; and it has nothing to do with creature comforts. The main staircase in the home is adorned with a colorful railing constructed entirely of Lego blocks.</p>\r\n\r\n<div align=\"center\"><img src=\"http://architector.ua/images/articles/AlexA/pic_big/pic_1340266348.jpg\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n\r\n<p>Designed by one of New York&#39;s officially licensed Lego artists &mdash; yes, thats a real, actual profession &mdash; the railing extends from the main floor all the way to the second floor. It&#39;s been crafted using primarily white bricks, but features more colorful accents at both ends, including large open squares which give it a very abstract appearance.<br />\r\n<br />\r\nYou can, of course, build your own Lego home accents, given enough time and patience. However, we&#39;d advise against relying on plastic toy blocks for anything you plan on putting a good amount of weight on. In fact, it would take just one unfortunate trip to turn the Lego staircase above into a massive pile of crushed blocks and broken dreams.</p>\r\n', 'Manhattan apartment features staircase lined with 20,000 Lego bricks', 'In Manhattan verfügt eine Wohnung über Treppe, deren Geländer aus 20.000 Legosteinen besteht.', '<p>Wenn Sie nach einem neuen Zuhause suchen, m&uuml;ssen Sie normalerweise einige Dinge beachten, ob es eine eingebaute Sp&uuml;lmaschine oder eine zentrale Klimaanlage gibt. Aber eine Wohnung hat in Manhattan eine ziemlich einzigartige Besonderheit, die sie von allen anderen unterscheidet - und sie hat keine Verbindung mit leibliches Wohl. Die Haupttreppe des Zuhauses wird mit einem bunten Gel&auml;nder geschm&uuml;ckt, das komplett aus Legosteinen gebaut ist.</p>\r\n\r\n<div align=\"center\"><img src=\"http://architector.ua/images/articles/AlexA/pic_big/pic_1340266348.jpg\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n\r\n<p>Das ist von einem offiziell lizenzierten in New York Lego-K&uuml;nstler entworfen - ja, der Beruf mit solchen Namen exisriert wirklich - das Gel&auml;nder erstreckt sich von der Hauptebene zu den zweiten Stock. H<font color=\"#000000\">aupts&auml;chlich</font><span lang=\"de-DE\"> ist es mit wei&szlig;en Steinen gebaut, sondern fallen mehr farbige Akzente an beiden Enden </span><font color=\"#000000\"><span lang=\"de-DE\">heraus</span></font><span lang=\"de-DE\">, die gro&szlig;e offene Pl&auml;tze haben, die ihm ein sehr abstraktes Aussehen geben.<br />\r\nNat&uuml;rlich k&ouml;nnen Sie Ihre eigene Lego Akzente im Zuhause bilden, wenn Sie genug Zeit und Geduld haben. Allerdings w&uuml;rden wir nicht empfehlen, Kunststoff-Spielzeug-Bl&ouml;cke zu benutzen, wenn Sie Dinge erstellen, auf dennen etwas vom gro</span><span lang=\"de-DE\">&szlig;</span><span lang=\"de-DE\">en Gewicht gesetzt wird. In der Tat, es w&uuml;rde nur eine ungl&uuml;ckliche Reise um die Lego Treppe nach oben, und das </span><span lang=\"de-DE\">Gel&auml;nder</span><span lang=\"de-DE\"> zu einem massiven Haufen von getrennten Bl&ouml;cken und den zerbrochenen Tr&auml;umen wird.</span></p>\r\n', '<p>Обычно при поиске нового дома нужно учитывать такие вещи, как наличие встроенной посудомоечной машины или центрального кондиционирования. Однако одна из квартир на Манхэттене выделяется среди прочих своей необычностью &mdash; и это никак не связано с системами жизнеобеспечения.</p>\r\n', '<p>Usually when you&#39;re looking for a new home, you need to consider things like whether or not it has a built-in dishwasher or central air conditioning. But one apartment in Manhattan has a rather unique feature that helps it stand out from the rest &mdash; and it has nothing to do with creature comforts.</p>\n', '<p><span lang=\"de-DE\">Wenn Sie nach einem neuen Zuhause suchen, m&uuml;ssen Sie normalerweise einige Dinge beachten, ob es eine eingebaute Sp&uuml;lmaschine oder eine zentrale Klimaanlage gibt. Aber eine Wohnung hat&nbsp;</span><span lang=\"de-DE\">in Manhattan&nbsp;</span><span lang=\"de-DE\">eine ziemlich einzigartige Besonderheit, die sie von allen anderen unterscheidet - und sie hat keine Verbindung mit leibliches Wohl.</span></p>\r\n', 'Apartamento en Manhattan con escalera bordeada de 20.000 piezas de Lego', '<p> 	<img src=\"http://architector.ua/images/articles/AlexA/pic_big/pic_1340266348.jpg\" /></p> <p> 	<span id=\"result_box\" lang=\"es\"><span class=\"hps\">Por lo general,</span> <span class=\"hps\">cuando usted</span> <span class=\"hps\">est&aacute; buscando un</span> <span class=\"hps\">nuevo hogar</span><span>,</span> <span class=\"hps\">debe tener en cuenta</span> <span class=\"hps\">cosas como</span> <span class=\"hps\">si</span> <span class=\"hps\">tiene un</span> <span class=\"hps\">lavaplatos incorporado</span> <span class=\"hps\">o el aire acondicionado</span> <span class=\"hps\">central.</span> <span class=\"hps\">Pero un</span> <span class=\"hps\">apartamento en</span> <span class=\"hps\">Manhattan</span> <span class=\"hps\">tiene una caracter&iacute;stica</span> <span class=\"hps\">bastante singular</span> <span class=\"hps\">que ayuda a</span> <span class=\"hps\">destacar entre</span> <span class=\"hps\">el resto</span> <span class=\"hps\">-</span> <span class=\"hps\">y no tiene nada</span> <span class=\"hps\">que ver con la</span> <span class=\"hps\">comodidad.</span> <span class=\"hps\">La</span> <span class=\"hps\">escalera principal</span> <span class=\"hps\">de la</span> <span class=\"hps\">casa</span> <span class=\"hps\">est&aacute; adornada con</span> <span class=\"hps\">una barandilla</span> <span class=\"hps\">colorida</span> <span class=\"hps\">construida enteramente</span> <span class=\"hps\">de bloques</span> <span class=\"hps\">de Lego.</span><br /> 	<span class=\"hps\">Dise&ntilde;ado por</span> <span class=\"hps\">uno de</span> <span class=\"hps\">los artistas</span> <span class=\"hps\">de Lego</span> <span class=\"hps\">con licencia oficial</span> <span class=\"hps\">de Nueva</span> <span class=\"hps\">York</span> <span class=\"hps\">- s&iacute;</span><span>, eso es</span> <span class=\"hps\">una verdadera</span> <span class=\"hps\">profesi&oacute;n</span><span>, actual</span> <span class=\"hps\">-</span> <span class=\"hps\">la barandilla</span> <span class=\"hps\">se extiende desde</span> <span class=\"hps\">la planta principal</span> <span class=\"hps\">hasta llegar a</span> <span class=\"hps\">la segunda planta.</span> <span class=\"hps\">Se ha</span> <span class=\"hps\">elaborado con</span> <span class=\"hps\">ladrillos</span> <span class=\"hps\">principalmente</span> <span class=\"hps\">blancos, pero</span> <span class=\"hps\">cuenta con acentos</span> <span class=\"hps\">m&aacute;s colorido</span> <span class=\"hps\">en ambos extremos</span><span>, como</span> <span class=\"hps\">grandes plazas</span> <span class=\"hps\">abiertas</span> <span class=\"hps\">que le dan</span> <span class=\"hps\">un aspecto</span> <span class=\"hps\">muy abstracto.</span><br /> 	<br /> 	<span class=\"hps\">Puede</span><span>, por supuesto</span><span>,</span> <span class=\"hps\">crear sus</span> <span class=\"hps\">propios</span> <span class=\"hps\">accesorios para el hogar</span> <span class=\"hps\">de Lego</span><span>,</span> <span class=\"hps\">dado suficiente</span> <span class=\"hps\">tiempo y paciencia.</span> <span class=\"hps\">Sin embargo</span><span>, nos</span> <span class=\"hps\">aconseja no</span> <span class=\"hps\">confiar en</span> <span class=\"hps\">bloques de juguete</span> <span class=\"hps\">de pl&aacute;stico para</span> <span class=\"hps\">cualquier cosa que usted</span> <span class=\"hps\">piensa</span> <span class=\"hps\">en poner</span> <span class=\"hps\">una buena cantidad de</span> <span class=\"hps\">peso</span><span>.</span> <span class=\"hps\">De hecho</span><span>, se necesitar&iacute;an</span> <span class=\"hps\">s&oacute;lo un</span> <span class=\"hps\">desafortunado</span> <span class=\"hps\">viaje a</span> <span class=\"hps\">su vez</span> <span class=\"hps\">la escalera</span> <span class=\"hps\">Lego</span> <span class=\"hps\">anterior en una</span> <span class=\"hps\">enorme pila</span> <span class=\"hps\">de bloques</span> <span class=\"hps\">triturado</span> <span class=\"hps\">y sue&ntilde;os</span> <span class=\"hps\">rotos.</span></span></p> <p> 	&nbsp;</p>', '<p> 	Por lo general,cuando ustedest&aacute; buscando unnuevo hogar,debe tener en cuentacosas comositiene unlavaplatos incorporadoo el aire acondicionadocentral.Pero unapartamento enManhattantiene una caracter&iacute;sticabastante singularque ayuda adestacar entreel resto-y no tiene nadaque ver con lacomodidad.Laescalera principalde lacasaest&aacute; adornada conuna barandillacoloridaconstruida enteramentede bloquesde Lego. </p>', 'مانهاتن ميزات شقة الدرج اصطف مع 20،000 الطوب ليغو', '<p>عادة عند&#39;re تبحث عن منزل جديد ، تحتاج إلى النظر في أشياء مثل ما إذا كان أو لم يكن لديه المدمج في غسالة الصحون أو تكييف الهواء المركزية. ولكن واحدة شقة في مانهاتن لديه ميزة فريدة من نوعها بدلا من أن يساعد ذلك تبرز من بقية &nbsp; وأنه لا علاقة له مع وسائل الراحة. الدرج الرئيسي في المنزل مزينة ملونة حديدي بناؤها بالكامل من كتل ليغو.</p>\r\n\r\n<div align=\"center\"><img src=\"http://architector.ua/images/articles/AlexA/pic_big/pic_1340266348.jpg\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n\r\n<p>صممه واحد من نيويورك&#39;s مرخصة رسميا ليغو الفنانين &nbsp; نعم إنها حقيقية المهنة &nbsp; حديدي يمتد من الطابق الرئيسي وصولا إلى الطابق الثاني. أنها&#39;s وضعت في المقام الأول باستخدام الطوب الأبيض ، ولكن ميزات أكثر لهجات الملونة في كلا الطرفين ، بما في ذلك كبيرة مفتوحة الساحات التي تعطيه مجردة جدا المظهر.<br />\r\n<br />\r\nيمكنك بالطبع بناء ليغو الخاصة بك المنزل لهجات إعطاء ما يكفي من الوقت والصبر. إلا أننا&#39;d ننصح بعدم الاعتماد على البلاستيك كتل لعبة عن أي شيء كنت تخطط لوضع كمية جيدة من الوزن. في الواقع, أنها سوف تأخذ فقط واحدة من المؤسف رحلة لتحويل ليغو درج أعلاه في كومة ضخمة من سحق كتل الأحلام المكسورة.</p>', '<p>عادة عند&#39;re تبحث عن منزل جديد ، تحتاج إلى النظر في أشياء مثل ما إذا كان أو لم يكن لديه المدمج في غسالة الصحون أو تكييف الهواء المركزية. ولكن واحدة شقة في مانهاتن لديه ميزة فريدة من نوعها بدلا من أن يساعد ذلك تبرز من بقية &nbsp; وأنه لا علاقة له مع وسائل الراحة.</p>', 'Manhattan Daire özellikleri merdiven 20.000 Lego tuğla ile kaplı ', '<p>Genellikle yeni bir ev ararken, bulaşık makinesi ya da klima yerleşik olup olmaması gibi şeyler dikkate almak gerekir. Ama Manhattan\'da bir daire diğerlerinden öne yardımcı olur bu oldukça benzersiz bir özelliği vardır ve yaratık konfor ile bir ilgisi yok. Evde ana merdiven Lego blokları tamamen inşa renkli bir korkuluk ile süslenmiş.</p>\r\n\r\n<div align=\"center\"><img src=\"http://architector.ua/images/articles/AlexA/pic_big/pic_1340266348.jpg\" />\r\n<p> </p>\r\n</div>\r\n\r\n<p>Gerçek, gerçek bir meslek New York\'un resmi lisanslı Lego sanatçı tarafından tasarlanmış — Evet, korkulukların ana katta tüm yolu ikinci kata uzatır değil mi? Öncelikle beyaz tuğla kullanılarak hazırlanmış, ama iki ucu da, bu çok soyut bir görünüm vermek büyük açık kareler de dahil olmak üzere daha renkli aksan vardır.<br />\r\n<br />\nTabii ki, kendi Lego ev aksan oluşturmak, yeterli zaman ve sabır vermiş. Ancak, plastik oyuncak bloklar üzerinde ağırlık iyi bir miktar koymak planladığınız bir şey için güvenerek karşı tavsiye ederiz. Aslında, ezilmiş blok ve kırık hayaller büyük bir yığın halinde yukarıdaki Lego merdiven açmak için sadece talihsiz bir yolculuğa çıkalım.</p>\r\n', '<p>Genellikle yeni bir ev ararken, bulaşık makinesi ya da klima yerleşik olup olmaması gibi şeyler dikkate almak gerekir. Ama Manhattan\'da bir daire diğerlerinden öne yardımcı olur bu oldukça benzersiz bir özelliği vardır ve yaratık konfor ile bir ilgisi yok.</p>\n');
INSERT INTO `{dbPrefix}entries` (`id`, `active`, `category_id`, `tags`, `image_id`, `title_ru`, `body_ru`, `date_created`, `date_updated`, `body_en`, `title_en`, `title_de`, `body_de`, `announce_ru`, `announce_en`, `announce_de`, `title_es`, `body_es`, `announce_es`, `title_ar`, `body_ar`, `announce_ar`, `title_tr`, `body_tr`, `announce_tr`) VALUES
(5, 1, 1, 'Lorem ipsum', 0, 'Lorem ipsum', '<p>Lorem Ipsum - это текст-&quot;рыба&quot;, часто используемый в печати и вэб-дизайне. Lorem Ipsum является стандартной &quot;рыбой&quot; для текстов на латинице с начала XVI века. В то время некий безымянный печатник создал большую коллекцию размеров и форм шрифтов, используя Lorem Ipsum для распечатки образцов. Lorem Ipsum не только успешно пережил без заметных изменений пять веков, но и перешагнул в электронный дизайн. Его популяризации в новое время послужили публикация листов Letraset с образцами Lorem Ipsum в 60-х годах и, в более недавнее время, программы электронной вёрстки типа Aldus PageMaker, в шаблонах которых используется Lorem Ipsum.</p>\r\n', '2019-01-05 02:00:22', '2020-03-16 11:34:31', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n', 'Lorem ipsum', 'Lorem ipsum', '<p>Lorem Ipsum ist ein einfacher Demo-Text f&uuml;r die Print- und Schriftindustrie. Lorem Ipsum ist in der Industrie bereits der Standard Demo-Text seit 1500, als ein unbekannter Schriftsteller eine Hand voll W&ouml;rter nahm und diese durcheinander warf um ein Musterbuch zu erstellen. Es hat nicht nur 5 Jahrhunderte &uuml;berlebt, sondern auch in Spruch in die elektronische Schriftbearbeitung geschafft (bemerke, nahezu unver&auml;ndert). Bekannt wurde es 1960, mit dem erscheinen von &quot;Letraset&quot;, welches Passagen von Lorem Ipsum enhielt, so wie Desktop Software wie &quot;Aldus PageMaker&quot; - ebenfalls mit Lorem Ipsum.</p>\r\n', '<p>Lorem Ipsum - это текст-&quot;рыба&quot;, часто используемый в печати и вэб-дизайне. Lorem Ipsum является стандартной &quot;рыбой&quot; для текстов на латинице с начала XVI века.</p>\r\n', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n', '<p>Lorem Ipsum ist ein einfacher Demo-Text f&uuml;r die Print- und Schriftindustrie.</p>\r\n', 'Lorem ipsum', '<p>Lorem Ipsum es simplemente el texto de relleno de las imprentas y archivos de texto. Lorem Ipsum ha sido el texto de relleno est&aacute;ndar de las industrias desde el a&ntilde;o 1500, cuando un impresor (N. del T. persona que se dedica a la imprenta) desconocido us&oacute; una galer&iacute;a de textos y los mezcl&oacute; de tal manera que logr&oacute; hacer un libro de textos especimen. No s&oacute;lo sobrevivi&oacute; 500 a&ntilde;os, sino que tambien ingres&oacute; como texto de relleno en documentos electr&oacute;nicos, quedando esencialmente igual al original. Fue popularizado en los 60s con la creaci&oacute;n de las hojas &quot;Letraset&quot;, las cuales contenian pasajes de Lorem Ipsum, y m&aacute;s recientemente con software de autoedici&oacute;n, como por ejemplo Aldus PageMaker, el cual incluye versiones de Lorem Ipsum.</p>\r\n', '<p>Lorem Ipsum es simplemente el texto de relleno de las imprentas y archivos de texto.</p>\r\n', 'Lorem ipsum', '<p>هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى المقروء لصفحة ما سيلهي القارئ عن التركيز على الشكل الخارجي للنص أو شكل توضع الفقرات في الصفحة التي يقرأها. ولذلك يتم استخدام طريقة لوريم إيبسوم لأنها تعطي توزيعاَ طبيعياَ -إلى حد ما- للأحرف عوضاً عن استخدام &quot;هنا يوجد محتوى نصي، هنا يوجد محتوى نصي&quot; فتجعلها تبدو (أي الأحرف) وكأنها نص مقروء. العديد من برامح النشر المكتبي وبرامح تحرير صفحات الويب تستخدم لوريم إيبسوم بشكل إفتراضي كنموذج عن النص، وإذا قمت بإدخال &quot;lorem ipsum&quot; في أي محرك بحث ستظهر العديد من المواقع الحديثة العهد في نتائج البحث. على مدى السنين ظهرت نسخ جديدة ومختلفة من نص لوريم إيبسوم، أحياناً عن طريق الصدفة، وأحياناً عن عمد كإدخال بعض العبارات الفكاهية إليها.</p>\r\n', '<p>هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى المقروء لصفحة</p>\r\n', 'Ipsum', '<p>Ipsum dolor sit amet, consectetur müşteri elit, do eiusmod tempor incididunt ut labore et dolore magna aynı sed. Ut için reklam damla veniam, doğru nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Voluptate velit esse cillum dolore eu fugiat nulla pariatur in reprehenderit in sarhoş araba kullanımı aute irure dolor. Culpa qui officia deserunt mollit anim id est laborum içinde Excepteur sint occaecat cupidatat non proident, sağlıklı.</p>\r\n', '<p>Ipsum dolor sit amet, consectetur müşteri elit, do eiusmod tempor incididunt ut labore et dolore magna aynı sed. Ut için reklam damla veniam, doğru nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Voluptate velit esse cillum dolore eu fugiat nulla pariatur in reprehenderit in sarhoş araba kullanımı aute irure dolor. Culpa qui officia deserunt mollit anim id est laborum içinde Excepteur sint occaecat cupidatat non proident, sağlıklı.</p>\r\n'),
(6, 1, 1, 'Sed ut, perspiciatis', 4, 'Где его взять?', '<p>Есть много вариантов Lorem Ipsum, но большинство из них имеет не всегда приемлемые модификации, например, юмористические вставки или слова, которые даже отдалённо не напоминают латынь. Если вам нужен Lorem Ipsum для серьёзного проекта, вы наверняка не хотите какой-нибудь шутки, скрытой в середине абзаца. Также все другие известные генераторы Lorem Ipsum используют один и тот же текст, который они просто повторяют, пока не достигнут нужный объём. Это делает предлагаемый здесь генератор единственным настоящим Lorem Ipsum генератором. Он использует словарь из более чем 200 латинских слов, а также набор моделей предложений. В результате сгенерированный Lorem Ipsum выглядит правдоподобно, не имеет повторяющихся абзацей или &quot;невозможных&quot; слов.</p>\r\n', '2019-01-05 02:01:42', '2020-03-16 11:34:34', '<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don&#39;t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn&#39;t anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.</p>\r\n', 'Where can I get some?', 'Wo kann ich es kriegen?', '<p>Es gibt viele Variationen der Passages des Lorem Ipsum, aber der Hauptteil erlitt &Auml;nderungen in irgendeiner Form, durch Humor oder zuf&auml;llige W&ouml;rter welche nicht einmal ansatzweise glaubw&uuml;rdig aussehen. Wenn du eine Passage des Lorem Ipsum nutzt, solltest du aufpassen dass in der Mitte des Textes keine ungewollten W&ouml;rter stehen. Viele der Generatoren im Internet neigen dazu, vorgefertigte St&uuml;cke zu wiederholen - was es n&ouml;tig machte einen richtigen Generator zu entwickeln. Wir nutzen ein W&ouml;rterbuch aus &uuml;ber 200 Lateinischen W&ouml;rter, kombiniert mit einer Handvoll Kunsts&auml;tzen, welche das Lorem Ipsum glaubw&uuml;rdig macht. Das generierte Lorem Ipsum ist au&szlig;erdem frei von Wiederholungen, Humor oder unqualitativen W&ouml;rter etc, ...</p>\r\n', '<p>Есть много вариантов Lorem Ipsum, но большинство из них имеет не всегда приемлемые модификации, например, юмористические вставки или слова, которые даже отдалённо не напоминают латынь.</p>\r\n', '<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don&#39;t look even slightly believable.</p>\r\n', '<p>Es gibt viele Variationen der Passages des Lorem Ipsum, aber der Hauptteil erlitt &Auml;nderungen in irgendeiner Form, durch Humor oder zuf&auml;llige W&ouml;rter welche nicht einmal ansatzweise glaubw&uuml;rdig aussehen.</p>\r\n', 'Dónde puedo conseguirlo?', '<p>Hay muchas variaciones de los pasajes de Lorem Ipsum disponibles, pero la mayor&iacute;a sufri&oacute; alteraciones en alguna manera, ya sea porque se le agreg&oacute; humor, o palabras aleatorias que no parecen ni un poco cre&iacute;bles. Si vas a utilizar un pasaje de Lorem Ipsum, necesit&aacute;s estar seguro de que no hay nada avergonzante escondido en el medio del texto. Todos los generadores de Lorem Ipsum que se encuentran en Internet tienden a repetir trozos predefinidos cuando sea necesario, haciendo a este el &uacute;nico generador verdadero (v&aacute;lido) en la Internet. Usa un diccionario de mas de 200 palabras provenientes del lat&iacute;n, combinadas con estructuras muy &uacute;tiles de sentencias, para generar texto de Lorem Ipsum que parezca razonable. Este Lorem Ipsum generado siempre estar&aacute; libre de repeticiones, humor agregado o palabras no caracter&iacute;sticas del lenguaje, etc.</p>\r\n', '<p>Hay muchas variaciones de los pasajes de Lorem Ipsum disponibles, pero la mayor&iacute;a sufri&oacute; alteraciones en alguna manera, ya sea porque se le agreg&oacute; humor, o palabras aleatorias que no parecen ni un poco cre&iacute;bles.</p>\r\n', 'ما أصله', '<p>خلافاَ للإعتقاد السائد فإن لوريم إيبسوم ليس نصاَ عشوائياً، بل إن له جذور في الأدب اللاتيني الكلاسيكي منذ العام 45 قبل الميلاد، مما يجعله أكثر من 2000 عام في القدم. قام البروفيسور &quot;ريتشارد ماك لينتوك&quot; (Richard McClintock) وهو بروفيسور اللغة اللاتينية في جامعة هامبدن-سيدني في فيرجينيا بالبحث عن أصول كلمة لاتينية غامضة في نص لوريم إيبسوم وهي &quot;consectetur&quot;، وخلال تتبعه لهذه الكلمة في الأدب اللاتيني اكتشف المصدر الغير قابل للشك. فلقد اتضح أن كلمات نص لوريم إيبسوم تأتي من الأقسام 1.10.32 و 1.10.33 من كتاب &quot;حول أقاصي الخير والشر&quot; (de Finibus Bonorum et Malorum) للمفكر شيشيرون (Cicero) والذي كتبه في عام 45 قبل الميلاد. هذا الكتاب هو بمثابة مقالة علمية مطولة في نظرية الأخلاق، وكان له شعبية كبيرة في عصر النهضة. السطر الأول من لوريم إيبسوم &quot;Lorem ipsum dolor sit amet..&quot; يأتي من سطر في القسم 1.20.32 من هذا الكتاب.</p>\r\n\r\n<p>للمهتمين قمنا بوضع نص لوريم إبسوم القياسي والمُستخدم منذ القرن الخامس عشر في الأسفل. وتم أيضاً توفير الأقسام 1.10.32 و 1.10.33 من &quot;حول أقاصي الخير والشر&quot; (de Finibus Bonorum et Malorum) لمؤلفه شيشيرون (Cicero) بصيغها الأصلية، مرفقة بالنسخ الإنكليزية لها والتي قام بترجمتها هـ.راكهام (H. Rackham) في عام 1914.</p>\r\n', '<p>خلافاَ للإعتقاد السائد فإن لوريم إيبسوم ليس نصاَ عشوائياً، بل إن له جذور في الأدب اللاتيني الكلاسيكي منذ العام 45 قبل الميلاد، مما يجعله أكثر من 2000 عام في القدم. قام البروفيسور &quot;ريتشارد ماك لينتوك&quot; (Richard McClintock) وهو بروفيسور اللغة اللاتينية في جامعة</p>\r\n', 'Nereden alabilirim?', '<p>Mevcut Ipsum pasajlar birçok varyasyonu vardır, ama çoğunluk bir çeşit değişiklik uğramış, enjekte mizah, hatta biraz inandırıcı görünmüyor rastgele kelime. Eğer Ipsum bir geçiş kullanmak için gidiyoruz eğer, metnin ortasında gizli utanç verici bir şey olmadığından emin olmak gerekir. İnternet üzerindeki tüm Ipsum üreteçleri gerekli olarak önceden tanımlanmış parçaları tekrarlamak eğilimindedir, bu Internet üzerinde ilk gerçek jeneratör yapmak. Makul görünüyor Ipsum oluşturmak için 200\'den fazla Latince kelimeler, model cümle yapılarının bir avuç ile birlikte, bir sözlük kullanır. Oluşturulan Şüphesiz, bu kadar Yaşayabildi bu nedenle her zaman tekrar, enjekte mizah, veya özelliği olmayan kelimeler vb ücretsiz.</p>\r\n', '<p>Mevcut Ipsum pasajlar birçok varyasyonu vardır, ama çoğunluk bir çeşit değişiklik uğramış, enjekte mizah, hatta biraz inandırıcı görünmüyor rastgele kelime.</p>\r\n');


DROP TABLE IF EXISTS `{dbPrefix}entries_all_tags`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}entries_all_tags` (
    `id` INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `name` VARCHAR(100) NOT NULL DEFAULT '',
    `frequency` INTEGER DEFAULT 1
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}entries_all_tags` (`id`, `name`, `frequency`) VALUES 
(1, 'lego', 1),
(2, 'news', 1),
(3, 'новости', 1),
(4, 'articles', 2),
(5, 'статьи', 2),
(6,	'Lorem ipsum',	1),
(7,	'Sed ut',	1),
(8,	'perspiciatis',	1);


DROP TABLE IF EXISTS `{dbPrefix}entries_category`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}entries_category` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `name_ru` varchar(255) NOT NULL DEFAULT '',
  `sorter` smallint(6) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name_en` varchar(255) NOT NULL DEFAULT '',
  `name_de` varchar(255) NOT NULL DEFAULT '',
  `name_es` varchar(255) NOT NULL DEFAULT '',
  `name_ar` varchar(255) NOT NULL DEFAULT '',
  `name_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}entries_category` (`id`, `name_ru`, `sorter`, `active`, `date_updated`, `name_en`, `name_de`, `name_es`, `name_ar`, `name_tr`) VALUES
(1, 'Новости', 1, 0, '2020-03-16 11:55:50', 'News', 'Nachrichten', 'Noticias', 'أخبار', 'Haber'),
(2, 'Статьи', 2, 0, '2020-03-16 11:55:53', 'Articles', 'Articles', 'Artículos', 'مقالات', 'Makale');


DROP TABLE IF EXISTS `{dbPrefix}entries_image`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}entries_image` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `date_created` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}entries_image` (`id`, `name`, `date_created`) VALUES
(1, 'sunset-17665_640.jpg', '2020-03-16 09:08:57'),
(3, 'Lego_Color_Bricks.jpg', '2020-03-16 10:00:00'),
(4,	'aerial-view-architecture-bridges-681335.jpg',	'2020-03-16 11:03:05');


DROP TABLE IF EXISTS `{dbPrefix}favorite`;
CREATE TABLE `{dbPrefix}favorite` (
  `user_id` int(11) NOT NULL,
  `model_name` varchar(255) NOT NULL DEFAULT '',
  `model_id` int(11) NOT NULL,
  `date_created` datetime NOT NULL,
  KEY `user_id` (`user_id`),
  KEY `model_id` (`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `{dbPrefix}formdesigner`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}formdesigner` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `sorter` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `field` varchar(100) NOT NULL DEFAULT '',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT '2',
  `standard_type` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `compare_type` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `is_i18n` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `visible` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `tip_ru` varchar(255) NOT NULL DEFAULT '',
  `tip_en` varchar(255) NOT NULL DEFAULT '',
  `tip_de` varchar(255) NOT NULL DEFAULT '',
  `label_ru` varchar(255) NOT NULL DEFAULT '',
  `label_en` varchar(255) NOT NULL DEFAULT '',
  `label_de` varchar(255) NOT NULL DEFAULT '',
  `reference_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `rules` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `measure_unit` varchar(30) NOT NULL DEFAULT '',
  `view_in` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `not_hide` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `json_data` text NULL,
  `date_created` timestamp NULL DEFAULT NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `tip_es` varchar(255) NOT NULL DEFAULT '',
  `label_es` varchar(255) NOT NULL DEFAULT '',
  `tip_ar` varchar(255) NOT NULL DEFAULT '',
  `label_ar` varchar(255) NOT NULL DEFAULT '',
  `tip_tr` varchar(255) NOT NULL DEFAULT '',
  `label_tr` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `reference_id` (`reference_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}formdesigner` (`id`, `sorter`, `field`, `type`, `standard_type`, `compare_type`, `is_i18n`, `visible`, `tip_ru`, `tip_en`, `tip_de`, `label_ru`, `label_en`, `label_de`, `reference_id`, `rules`, `measure_unit`, `view_in`, `not_hide`, `json_data`, `date_created`, `date_updated`, `tip_es`, `label_es`, `tip_ar`, `label_ar`, `tip_tr`, `label_tr`) VALUES
(1, 12, 'num_of_rooms', 2, 2, 0, 0, 0, '', '', '', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\"]}', '2020-03-16 00:13:48', '2020-03-16 00:13:48', '', '', '', '', '', ''),
(2, 13, 'floor_all', 2, 2, 0, 0, 0, '', '', '', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 21:52:52', '', '', '', '', '', ''),
(4, 14, 'square', 2, 1, 0, 0, 0, 'Разделителем является \".\" (точка).', 'Separators are \".\".', 'Trennen Sie die Elemente mit einem Der Punkt \".\"', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 11:52:27', 'Los separadores son \".\".', '', 'فواصل هي \".\".', '', 'Ayırıcı \".\" (nokta).', ''),
(5, 15, 'window_to', 2, 2, 0, 0, 0, '', '', '', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 21:52:52', '', '', '', '', '', ''),
(6, 17, 'berths', 2, 2, 0, 0, 0, '', '', '', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 21:52:52', '', '', '', '', '', ''),
(7, 6, 'address', 2, 2, 0, 1, 0, '', '', '', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2018-02-26 11:35:07', '', '', '', '', '', ''),
(8, 16, 'description_near', 3, 2, 0, 1, 0, '', '', '', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 21:33:35', '', '', '', '', '', ''),
(9, 11, 'description', 4, 2, 0, 1, 0, '', '', '', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 21:52:51', '', '', '', '', '', ''),
(10, 10, 'references', 2, 2, 0, 0, 0, '', '', '', '', '', '', 0, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 02:15:46', '', '', '', '', '', ''),
(11, 18, 'note', 3, 1, 0, 0, 2, 'Заметка будет видна только Вам и администратору', 'The note will be shown only to you and to the administrator', 'Die Notiz wird nur Ihnen und dem Administrator angezeigt', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 11:52:29', 'La nota se muestra solo a usted y al administrador', '', 'وسيتم عرض هذه المذكرة لك فقط وإلى المسؤول', '', 'Not görünür olacak sadece Sen ve yönetici', ''),
(12, 19, 'phone', 2, 1, 0, 0, 0, 'Если вы не укажете здесь телефон, то будет показан телефон из профиля', 'If you do not specify your phone number here, the phone number from the profile will be shown on the listings page', 'Wenn Sie Ihre Telefonnummer hier nicht angeben, die Telefonnummer aus dem Profil wird auf der Seite des Inserates angezeigt werden', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 11:52:33', 'Si no se especifica su número de teléfono aquí, el número de teléfono del perfil se mostrará en la página de anuncios', '', 'إذا لم تقم بتحديد رقم الهاتف الخاص بك هنا، وسوف يتم عرض رقم هاتف من التشكيل الجانبي على الصفحة المعروضة', '', 'Belirtmezseniz, burada telefon, özellikli telefon profili', ''),
(13, 20, 'land_square', 2, 1, 0, 0, 0, 'Разделителем является \".\" (точка).', 'Separators are \".\".', 'Trennen Sie die Elemente mit einem Der Punkt \".\"', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 11:52:35', 'Los separadores son \".\".', '', 'فواصل هي \".\".', '', 'Ayırıcı \".\" (nokta).', ''),
(14, 1, 'type', 0, 2, 0, 0, 0, '', '', '', 'Тип сделки', 'Type', 'Typ', 0, 0, '', 1, 1, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 03:35:06', '2020-03-16 11:52:37', '', 'Tipo', '', 'اكتب', '', 'İşlem türü'),
(15, 8, 'price', 0, 2, 0, 0, 0, '', '', '', 'Цена', 'Price', 'Preis', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\"]}', '2020-03-16 03:36:17', '2020-03-16 11:52:39', '', 'Precio', '', 'السعر', '', 'Fiyat'),
(16, 4, 'location', 0, 2, 0, 0, 0, '', '', '', 'Местоположение', 'Location', 'Ort', 0, 0, '', 1, 1, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 00:13:48', '2020-03-16 11:52:41', '', 'Ubicación', '', 'موقع', '', 'Konumu'),
(17, 9, 'title', 2, 1, 0, 1, 0, '', '', '', '', '', '', 0, 0, '', 1, 1, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 04:01:55', '2020-03-16 21:52:51', '', '', '', '', '', ''),
(18, 2, 'obj_type_id', 0, 2, 0, 0, 0, '', '', '', 'Тип недвижимости', 'Property type', 'Objekttyp', 0, 0, '', 1, 1, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 21:27:27', '2020-03-16 11:52:43', '', 'Tipo de propiedad', '', 'نوع الملكية', '', 'Emlak tipi'),
(19, 3, 'parent_id', 0, 2, 0, 0, 0, '', '', '', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 21:49:27', '2018-03-11 12:55:45', '', '', '', '', '', ''),
(20, 5, 'metroStations', 2, 2, 0, 0, 0, '', '', '', '', '', '', 0, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', '2020-03-16 12:00:00', '2015-11-01 02:00:01', '', '', '', '', '', ''),
(21, 21, 'open_plan', 1, 0, 0, 0, 0, '', '', '', 'Свободная планировка', 'Open plan', 'Offen angegliedert  ', 11, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:52:46', '', 'Abierto', '', 'مفتوح', '', 'Özgür düzen'),
(22, 22, 'room_type', 1, 0, 0, 0, 0, '', '', '', 'Тип комнат', 'Room type', 'Art des Zimmers', 12, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:52:49', '', 'Tipo de habitaciones', '', 'نوع الغرف', '', 'Oda tipi'),
(23, 23, 'balcony_type', 1, 0, 0, 0, 0, '', '', '', 'Тип балкона', 'Type of balcony', 'Balkon Art', 13, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:52:51', '', 'tipo de balcón', '', 'نوع شرفة', '', 'Tipi balkon'),
(24, 24, 'wc_type', 1, 0, 0, 0, 0, '', '', '', 'Тип санузла', 'Type of WC', 'Art der Bäder', 14, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:52:53', '', 'tipo de baños', '', 'نوع من الحمامات', '', 'Tipi banyo'),
(25, 25, 'floor_coat', 1, 0, 0, 0, 0, '', '', '', 'Покрытие пола', 'Floor coating', 'Beschichtung', 15, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"4\",\"5\"]}', NULL, '2020-03-16 11:52:54', '', 'piso', '', 'أرضية', '', 'Zemin kaplama'),
(26, 7, 'garage_type', 1, 0, 0, 0, 0, '', '', '', 'Тип гаража', 'Garage type', 'Garage Typ', 16, 0, '', 1, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:52:56', '', 'Tipo de garaje', '', 'نوع المرأب', '', 'Tipi garaj'),
(27, 26, 'build_year', 2, 0, 2, 0, 0, '', '', '', 'Год постройки', 'Construction Year', 'Baujahr', 0, 3, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:52:57', '', 'Construcciones', '', 'سنة التشييد', '', 'Yapım yılı'),
(28, 27, 'repair', 1, 0, 0, 0, 0, '', '', '', 'Ремонт', 'Repair', 'Reparatur', 17, 0, '', 2, 0, '{\"type\":\"\"}', NULL, '2020-03-16 11:53:00', '', 'Reparar', '', 'إصلاح', '', 'Onarım'),
(29, 28, 'object_state', 1, 0, 0, 0, 0, '', '', '', 'Состояние объекта', 'State of the object', 'Zustand des Objekts', 18, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:53:02', '', 'Estado del objeto', '', 'حالة الكائن', '', 'Bir nesnenin durumunu'),
(30, 29, 'building_type', 1, 0, 0, 0, 0, '', '', '', 'Тип здания', 'Building-type', 'Gebäudeart', 19, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:53:05', '', 'Tipo de construcción', '', 'نوع البناية', '', 'Bina tipi'),
(31, 30, 'plot_type', 1, 0, 0, 0, 0, '', '', '', 'Тип участка', 'Plot type', 'Plot-Typ', 20, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:53:07', '', 'Trama', '', 'نوع الرسم', '', 'Tipi arsa'),
(32, 31, 'utilities', 7, 0, 0, 0, 0, '', '', '', 'Коммуникации', 'Utilities', 'Versorgungswirtschaft', 21, 0, '', 2, 0, '{\"type\":[\"1\",\"2\",\"3\",\"4\",\"5\"]}', NULL, '2020-03-16 11:53:08', '', 'Servicios públicos', '', 'المرافق', '', 'İletişim');


DROP TABLE IF EXISTS `{dbPrefix}formdesigner_obj_type`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}formdesigner_obj_type` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `formdesigner_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `obj_type_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `formdesigner_id` (`formdesigner_id`),
  KEY `obj_type_id` (`obj_type_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}formdesigner_obj_type` (`id`, `formdesigner_id`, `obj_type_id`) VALUES
(52, 3, 1),
(53, 3, 2),
(54, 3, 3),
(329, 9, 8),
(328, 9, 7),
(327, 9, 6),
(326, 9, 5),
(341, 8, 8),
(340, 8, 7),
(339, 8, 6),
(338, 8, 5),
(356, 12, 7),
(355, 12, 6),
(354, 12, 5),
(337, 8, 4),
(325, 9, 4),
(353, 12, 4),
(111, 2, 1),
(112, 2, 2),
(113, 2, 3),
(132, 2, 5),
(336, 8, 3),
(324, 9, 3),
(352, 12, 3),
(144, 2, 6),
(335, 8, 2),
(323, 9, 2),
(351, 12, 2),
(156, 2, 7),
(334, 8, 1),
(322, 9, 1),
(350, 12, 1),
(167, 1, 1),
(168, 1, 2),
(169, 1, 7),
(332, 4, 3),
(331, 4, 2),
(330, 4, 1),
(173, 5, 1),
(174, 5, 2),
(175, 5, 7),
(176, 6, 1),
(177, 6, 2),
(178, 6, 7),
(179, 10, 1),
(180, 10, 2),
(181, 10, 3),
(182, 10, 7),
(183, 13, 2),
(184, 13, 4),
(225, 17, 1),
(226, 17, 2),
(227, 17, 3),
(228, 17, 4),
(229, 17, 5),
(230, 17, 6),
(231, 17, 7),
(233, 14, 1),
(234, 14, 2),
(235, 14, 3),
(236, 14, 4),
(237, 14, 5),
(238, 14, 6),
(239, 14, 7),
(348, 11, 7),
(347, 11, 6),
(346, 11, 5),
(345, 11, 4),
(344, 11, 3),
(343, 11, 2),
(342, 11, 1),
(311, 7, 6),
(310, 7, 5),
(309, 7, 4),
(308, 7, 3),
(307, 7, 2),
(306, 7, 1),
(255, 16, 1),
(256, 16, 2),
(257, 16, 3),
(258, 16, 4),
(259, 16, 5),
(260, 16, 6),
(261, 16, 7),
(319, 15, 7),
(318, 15, 6),
(317, 15, 5),
(316, 15, 4),
(315, 15, 3),
(314, 15, 2),
(313, 15, 1),
(270, 18, 1),
(271, 18, 2),
(272, 18, 3),
(273, 18, 4),
(274, 18, 5),
(275, 18, 6),
(276, 18, 7),
(304, 20, 7),
(303, 20, 6),
(302, 20, 5),
(301, 20, 4),
(300, 20, 3),
(299, 20, 2),
(298, 20, 1),
(292, 19, 1),
(293, 19, 7),
(294, 14, 8),
(295, 18, 8),
(296, 16, 8),
(297, 26, 8),
(305, 20, 8),
(312, 7, 8),
(320, 15, 8),
(321, 17, 8),
(333, 4, 8),
(349, 11, 8),
(357, 12, 8);

DROP TABLE IF EXISTS `{dbPrefix}history_changes`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}history_changes` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL DEFAULT '',
  `action` enum('create', 'update', 'delete') DEFAULT NULL,
  `model_name` varchar(45) NOT NULL DEFAULT '',
  `model_id` int(11) unsigned NOT NULL DEFAULT '0',
  `field` varchar(155) NOT NULL DEFAULT '',
  `date_created` timestamp NULL,
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `old_value` text NULL,
  `new_value` text NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `model_name` (`model_name`),
  KEY `model_id` (`model_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}images`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}images` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `id_object` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `id_owner` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `file_name` varchar(255) NOT NULL DEFAULT '',
  `file_name_modified` varchar(255) NOT NULL DEFAULT '',
  `sorter` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `is_main` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_created` timestamp NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_object` (`id_object`),
  KEY `id_owner` (`id_owner`),
  KEY `date_updated` (`date_updated`),
  KEY `sorter` (`sorter`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}images` (`id`, `id_object`, `id_owner`, `file_name`, `file_name_modified`, `sorter`, `is_main`, `date_created`, `date_updated`) VALUES
(1,	20,	2,	'4642183425303f90b58a426431faffc8.jpg',	'492cf403cf4ad5bcbaf00de080f4b258.jpg',	1,	1,	'2020-03-16 22:35:08',	'2016-08-14 22:35:08'),
(2,	20,	2,	'98978650a82789fea10647facc9ccb31.jpg',	'15c38a272f21f58acdeb19181f7b23f3.jpg',	2,	0,	'2020-03-16 22:35:08',	'2016-08-14 22:35:08'),
(3,	20,	2,	'37666ee0212634e5440b3b10bbb03405.jpg',	'730288a4362c804ae5c06b224a468b2e.jpg',	3,	0,	'2020-03-16 22:35:08',	'2016-08-14 22:35:08'),
(4,	21,	2,	'07f5903ea83f2b6dcafaa938d78f31b2.jpg',	'1ddadde47c843b49864bc3b9e65c9fc1.jpg',	1,	1,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(5,	21,	2,	'b30ecde6703af338cf78351c31c244b6.jpg',	'f487cbc3c94b06192c73b98ab6adc8d0.jpg',	2,	0,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(6,	21,	2,	'2799799413c546f8cec31f4dace1bd4c.jpg',	'aeeb83cdfe8b0058481de9155dccb155.jpg',	3,	0,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(7,	22,	2,	'e0c4b12b29821bc21629e4c38ea9328e.jpg',	'dd021e21a832481dbbe475989db020e2.jpg',	1,	1,	'2020-03-16 22:35:09',	'2018-05-15 12:04:27'),
(8,	22,	2,	'33fb6904072bda6867e983bbe6a4cca2.jpg',	'fb0f8f66b180aa5047d6208b1b9cf460.jpg',	2,	0,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(9,	22,	2,	'2669632aee4e4f25ff4939965abc6df1.jpg',	'095592da7fd664a685d041b9721c8641.jpg',	3,	0,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(10,	22,	2,	'76edb1c5af69ebb89c5451b638379194.jpg',	'1d1aaf1e5470b969a19dc0d3d6eb44b8.jpg',	4,	0,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(11,	23,	1,	'72f897efe9967830aec0423a452bac26.jpg',	'ebf4e49795ffdf6890238e7891a139fa.jpg',	1,	1,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(12,	23,	1,	'1062105f6f7775759509d6837ed6b71b.jpg',	'3eeb283f3ccca96b1840ab3fd2407c0c.jpg',	2,	0,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(13,	23,	1,	'4802bffadc1c3a300deec201d641c275.jpg',	'6f8e1ff0ba19f57e4d052060763cf1a4.jpg',	3,	0,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(14,	24,	1,	'434e6f58798e9d4a76b73f6d3f42bcdd.jpg',	'35771d6769806d963faa2709df768ab3.jpg',	1,	1,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(15,	24,	1,	'939f629f4d329396f431c3324630acda.jpg',	'51b1229bb01aa0f49d75d3b9728ad5dc.jpg',	2,	0,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(16,	25,	2,	'aa3b58ff0e2fc028e8d923c5e4913240.jpg',	'70afc13f2289863769e3c79fbd6af609.jpg',	1,	1,	'2020-03-16 22:35:09',	'2016-08-14 22:35:08'),
(17,	25,	2,	'fbba2b5638379b56f07901cf811dec84.jpg',	'eea81eea19ea2e732d4f46e5db2cb692.jpg',	2,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(18,	25,	2,	'5995731714c8418f6b543a0a19d9b542.jpg',	'2c48c40aa5ed23c5e226078bcc6a651c.jpg',	3,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(19,	25,	2,	'4b32745ab9af98359d93f140df38b8d5.jpg',	'e0ebbf92a63ba4475a108a8430ebfd53.jpg',	4,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(20,	26,	1,	'532a06605273c3a78764aef82cc2898d.jpg',	'cc48b9a67c1e05e242f556105b8fe842.jpg',	1,	1,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(21,	26,	1,	'56862e86309b7f453288fe2dedd65bee.jpg',	'925abcaf701ddf5e858de3d1029d9ea6.jpg',	2,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(22,	26,	1,	'22a6e736f74a03564c817e0c1fb6de4f.jpg',	'64d96740d5027df5c3647b43af88eeed.jpg',	3,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(23,	27,	2,	'a97f838a5870da7a2d43c75f1de90106.jpg',	'05381a9df5ad620559deb9cc79a04247.jpg',	1,	1,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(24,	27,	2,	'680c7d6b0899714428e5a1da0bc30fec.jpg',	'986c8a7a3573aa17b428f1a6ab1a9731.jpg',	2,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(25,	27,	2,	'f95ee897b6b445cad179115eb087286d.jpg',	'a9ae1d8f4c72826350a73426e68b07aa.jpg',	3,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(26,	27,	2,	'7bfbb4d132ff8aa79d8bf01100dfcb0b.jpg',	'37a66e8ef865567d3a60b31b9b761eee.jpg',	4,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(27,	27,	2,	'902d83f68e6e9ec372df826018575f60.jpg',	'30e3c95ae319f9823f35ae838475e669.jpg',	5,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(28,	27,	2,	'97671ea692dd5e2c7dbd0390bb0c14a9.jpg',	'd14491c46e0e14f2e2b20309982a9d47.jpg',	6,	0,	'2020-03-16 22:35:10',	'2016-08-14 22:35:08'),
(29,	27,	2,	'ab7d6d8cd9b9cc88c6c2f886ecfb0fe1.jpg',	'c8bc7b3f2970dd195e338602f0874ebf.jpg',	7,	0,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(30,	28,	2,	'a82782685e0124929fc283d46f6401d2.jpg',	'5372cfe2f6db3f4c7de4fa2f54030223.jpg',	1,	1,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(31,	28,	2,	'6f4efbcbc0092841792a0832a9f837f7.jpg',	'e3e068e1ef368a8c60666ac7708a5472.jpg',	2,	0,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(32,	28,	2,	'a904431e0b549eb6ff5674e11fc3bb51.jpg',	'fca9b505abf952af7f2a052da7c27d84.jpg',	3,	0,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(33,	28,	2,	'ff0465c930b907a1902b84a59fad9908.jpg',	'dcf2bf49b9466dc400a12b4d3855a3ea.jpg',	4,	0,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(34,	28,	2,	'e14408748c45e0a3b99e86560994259b.jpg',	'a18e663a61f5d6930bb851b60c62e51d.jpg',	5,	0,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(35,	29,	2,	'53629d7d842247d6809ae4656dcd485e.jpg',	'722e4e0d81b315fb1c63b55aab347e2e.jpg',	1,	1,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(36,	29,	2,	'dd2ac23e94ec6135361688bb07717d53.jpg',	'08e1e3ce179f44fbfcecbf0d8837ba37.jpg',	2,	0,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(37,	29,	2,	'169ff7438eb11fc8d550be79883c6ea8.jpg',	'ec4c29900bb7bc394359dab585d883fc.jpg',	3,	0,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(38,	29,	2,	'd97fe2a7fcc6f6055c0238f054691856.jpg',	'7ce287f416affc4bbc2d768247079b9c.jpg',	4,	0,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(39,	19,	2,	'109a589ef2fbedcf57ec6b1bb980c27f.jpg',	'05df26fd26854d78d365495dca2fd288.jpg',	1,	1,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(40,	19,	2,	'0aaabd861398394fca7f6a2d88a441da.jpg',	'719584d4b4a236a3d07b28b7b0b65483.jpg',	2,	0,	'2020-03-16 22:35:11',	'2016-08-14 22:35:08'),
(41,	19,	2,	'8f6f149af17438055fd873647ddb4b52.jpg',	'abb08d7926551bdcacef6e112d7c68e7.jpg',	3,	0,	'2020-03-16 22:35:12',	'2016-08-14 22:35:08'),
(42,	18,	2,	'b00b91cbee4893b9efda6a83db24ed82.jpg',	'c5d10612afa120b285ccfb817e0a2303.jpg',	1,	1,	'2020-03-16 22:35:12',	'2016-08-14 22:35:08'),
(43,	18,	2,	'7239026d4d0355a577047c699f4988a8.jpg',	'2eec995ba4a4a51736f9c8b70c4bb206.jpg',	2,	0,	'2020-03-16 22:35:12',	'2016-08-14 22:35:08'),
(44,	18,	2,	'808ee1b66405fd7e2d376c0cfc4768d2.jpg',	'32edbdf4361baa92fbe8f9c6ca97f4ef.jpg',	3,	0,	'2020-03-16 22:35:12',	'2016-08-14 22:35:08'),
(45,	18,	2,	'b5b4e28e37325ef9b4b20029aed4967a.jpg',	'3e903137e68b8c6a68c24f204febb899.jpg',	4,	0,	'2020-03-16 22:35:12',	'2016-08-14 22:35:08'),
(48,	30,	1,	'5a9d8ca2e8677.jpeg',	'257c3796dbf0fbe331798de0dde6d694.jpeg',	3,	0,	'2018-03-05 18:29:57',	'2018-03-05 18:30:28'),
(49,	30,	1,	'5a9d8ca3ba075.jpeg',	'bbc11d22d5a0525281e1e4a91bccef6c.jpeg',	2,	0,	'2018-03-05 18:29:57',	'2018-03-05 18:30:28'),
(50,	30,	1,	'5a9d8cb539dad.jpeg',	'3d8dca2844651bc5d954bb3d338963fb.jpeg',	0,	1,	'2018-03-05 18:30:13',	'2018-03-05 18:30:19'),
(51,	32,	1,	'5a9d8eb8685b0.jpeg',	'2971f4a618ffd704974dd1a17e773145.jpeg',	1,	1,	'2018-03-05 18:38:50',	'2018-03-05 18:38:50'),
(52,	31,	1,	'5a9d8ef3d6ce0.jpeg',	'22031dc03968bc4df0a51a2ac3c3b3fe.jpeg',	1,	1,	'2018-03-05 18:39:49',	'2018-03-05 18:39:49'),
(55,	33,	1,	'5aa4f830e2c4e.jpeg',	'c3b68fe7135120225902b07e30348aea.jpeg',	0,	1,	'2018-03-11 09:34:41',	'2018-03-11 09:48:23'),
(56,	34,	1,	'5aa4fa469448b.jpg',	'b65be393742d08d6c7bd0b4a6a1aaa1f.jpg',	1,	1,	'2018-03-11 09:43:34',	'2018-03-11 09:43:34'),
(57,	35,	1,	'5aa4fadc8355a.jpg',	'2fd9eaef4e6c59e51803816070707dff.jpg',	1,	1,	'2018-03-11 09:46:04',	'2018-03-11 09:46:04');


DROP TABLE IF EXISTS `{dbPrefix}infopages`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}infopages` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `widget` varchar(20) NOT NULL DEFAULT '',
  `widget_position` tinyint(1) NOT NULL DEFAULT '0',
  `widget_data` text NULL,
  `widget_titles` text NULL,
  `special` tinyint(4) NOT NULL DEFAULT '0',
  `title_ru` varchar(255) NOT NULL DEFAULT '',
  `title_en` varchar(255) NOT NULL DEFAULT '',
  `title_de` varchar(255) NOT NULL DEFAULT '',
  `date_created` timestamp NULL,
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `body_ru` LONGTEXT NULL,
  `body_en` LONGTEXT NULL,
  `body_de` LONGTEXT NULL,
  `title_es` varchar(255) NOT NULL DEFAULT '',
  `body_es` LONGTEXT NULL,
  `title_ar` varchar(255) NOT NULL DEFAULT '',
  `body_ar` LONGTEXT NULL,
  `title_tr` varchar(255) NOT NULL DEFAULT '',
  `body_tr` longtext NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}infopages` (`id`, `active`, `widget`, `widget_position`, `widget_data`, `widget_titles`, `special`, `title_ru`, `title_en`, `title_de`, `date_created`, `date_updated`, `body_ru`, `body_en`, `body_de`, `title_es`, `body_es`, `title_ar`, `body_ar`, `title_tr`, `body_tr`) VALUES
(1, 1, 'apartments', 1, '{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"0\",\"obj_type_id\":\"0\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\",\"garage_type\":\"\",\"open_plan\":\"\",\"room_type\":\"\",\"balcony_type\":\"\",\"wc_type\":\"\",\"floor_coat\":\"\",\"build_year\":\"\",\"repair\":\"\",\"object_state\":\"\",\"building_type\":\"\",\"plot_type\":\"\"}', '{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}', 1, 'Добро пожаловать!', 'Welcome!', 'Herzlich Willkommen!', '2020-03-16 15:00:00', '2020-03-16 11:53:29', '<p><strong>Open Real Estate</strong> предоставляет возможность агентствам недвижимости и риэлторам успешно взаимодействовать как с владельцами недвижимости, так и с потенциальными покупателями и интернет-пользователями.<br />\r\n<br />\r\nСогласно Вашим запросам, мы можем добавить или удалить отдельные функции продукта и развивать их таким образом, чтобы Ваш web-сайт максимально соответствовал запросам и идеям Вашего бизнеса.<br />\r\n<br />\r\nМы, <a href=\"http://monoray.ru\">студия Monoray</a>, стремимся делать сайты, которые максимально просты в использовании как для администраторов, так и для обычных пользователей интернета. Это касается не только Open Real Estate, но и любых сайтов. Мы можем создавать web-сайты различной сложности с &quot;нуля&quot;.<br />\r\n<br />\r\n<strong>С нами Ваши бизнес-идеи станут реальностью!</strong></p>\r\n', '<p><strong>Open Real Estate</strong> offers real estate agencies and realtors the technology they need to connect with today&rsquo;s real estate owners, prospective buyers and tenants and Internet surfers.<br />\r\n<br />\r\nAccording to your wish we can add, remove product&#39;s features and develop them in such a way that your web site captures the essence of Your Business.<br />\r\n<br />\r\nAt <a href=\"http://monoray.net\">MonoRay Studio</a> our goal is to produce websites that are search-engine friendly and refreshingly easy-to-use for admin and for users. It concerns not only а website for real estate agencies or for realtors, but any website. We build websites from the ground as well. Project managers work with you until you are satisfied with a site that meets your expectations the best way.<br />\r\n<br />\r\n<strong>Let Your Business Ideas Come True!</strong></p>\r\n', '<style type=\"text/css\"><!--\r\n@page { margin: 0.79in }\r\nP { margin-bottom: 0.08in }\r\nA:link { so-language: zxx }\r\n-->\r\n</style>\r\n<p style=\"margin-bottom: 0in\"><strong><span lang=\"de-DE\">Open Real Estate</span></strong><span lang=\"de-DE\"> b</span><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">ietet Immobilienagenturen und Agenten die M&ouml;glichkeit, erfolgreich </span></span></span><strong><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">sowohl mit</span></span></span></strong><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\"> Eigent&uuml;mern als auch mit potenziellen K&auml;ufern und Internetnutzern </span></span></span><span style=\"font-style: normal\"><span style=\"font-weight: normal\">zusammenzuarbeiten</span></span><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">.<br />\r\nWir k&ouml;nnen nach Ihren W&uuml;nschen einzelne Funktionen des Produkts hinzuf&uuml;gen oder entfernen und sie so entwickeln, dass Ihre Websi</span></span></span><span lang=\"de-DE\">te Ihren Bed&uuml;rfnissen und Ideen von Ihrem </span>Business <span lang=\"de-DE\">am besten</span> <span lang=\"de-DE\">entsprechen wird.</span><br />\r\n<span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">Wir, das <a href=\"http://monoray.net\">Monoray Studio</a>, sind bestrebt, solche Websites zu entwickeln, deren Verwaltung</span></span></span><strong><span style=\"font-style: normal\"><span style=\"font-weight: normal\"> </span></span></strong><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">f&uuml;r Administratoren und</span></span></span><strong><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\"> </span></span></span></strong><span lang=\"de-DE\"><span style=\"font-style: normal\"><span style=\"font-weight: normal\">Benutzer einfach ist. </span></span></span><span lang=\"de-DE\">Dies betrifft nicht nur Open Real Estate, sondern auch andere Websites. Wir k&ouml;nnen Websites vom unterschiedlichen </span>Schwierigkeitsgrad<span lang=\"de-DE\"> von Grund auf erstellen.</span></p>\r\n\r\n<p style=\"margin-bottom: 0in\"><strong><span lang=\"de-DE\">Lassen Sie uns Ihre Business-Ideen r</span>ealisieren<span lang=\"de-DE\">!</span></strong></p>\r\n', 'Início', '<p><strong>Open Real Estate</strong> ofrece a las agencias inmobiliarios y inmobiliarias de tecnolog&iacute;a que necesitan para conectarse con los propietarios de hoy, inmobiliarios, los compradores potenciales, inquilinos e usuarios de Internet.<br />\r\n<br />\r\nDe acuerdo a su deseo, podemos agregar, quitar las caracter&iacute;sticas del producto y el desarrollo de ellos para que su sitio web captura la esencia de su negocio.<br />\r\n<br />\r\nEn la <a href=\"http://monoray.net\">MonoRay Studio</a> nuestro objetivo es la producci&oacute;n de sitios web que est&aacute;n optimizados para los motores de b&uacute;squeda, agradable y f&aacute;cil de usar para la administraci&oacute;n y los usuarios. Este sitio web no es s&oacute;lo para agencias de las propiedades inmobiliarios o inmobiliarias, pero ning&uacute;n sitio. Construimos sitios web desde cero tambi&eacute;n. Los gerentes de proyecto trabajan con usted hasta que est&eacute; satisfecho con un sitio que cumpla con sus expectativas de la mejor manera.<br />\r\n<br />\r\n<strong>Deje que sus ideas de negocio se hacen realidad!</strong></p>\r\n', 'أهلا بك!', '<p>فتح العروض العقارية وكالات العقارات و السماسرة التكنولوجيا يحتاجون للتواصل مع هيئة مالكي العقارات المحتملين المشترين و المستأجرين و متصفحي الإنترنت.</p>\r\n', 'Hoş geldiniz!', '<p><strong>Open Real Estate</strong> bir fırsat sağlar emlakçılar ve emlakçılar başarılı bir şekilde etkileşim gibi sahipleri ile gayrimenkul ve potansiyel alıcılar ile ve internet kullanıcıları tarafından.<br />\r\n<br />\nTalepleriniz doğrultusunda, biz eklemek veya silmek için tek tek ürün özellikleri ve bunları geliştirmek için böylece, bir web sitesi iyi bir maç istekleri ve fikirleri iş.<br />\r\n<br />\nBiz, <a href=\"http://monoray.ru\">stüdyo Monoray</a>, yapmak için çalışıyoruz web siteleri imkanlar kullanımı kolay hem yöneticiler için, hem sıradan internet kullanıcıları. Bu durum sadece Open Real Estate, aynı zamanda herhangi bir web sitesi. Biz oluşturmak için web-siteleri ile farklı zorluk seviyesi \"sıfır\".<br />\r\n<br />\r\n<strong>Bizimle Senin iş fikri gerçek olacak!</strong></p>\r\n'),
(2, 1, 'viewallonmap', 1, '', '{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}', 0, 'Поиск на карте', 'Search on map', 'Suche auf der Karte', '2020-03-16 15:00:00', '2020-03-16 11:53:11', '', '', '', 'Buscar en el mapa', '', 'البحث على الخريطة', '', 'Harita', ''),
(3, 1, 'apartments', 2, '{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"2\",\"obj_type_id\":\"0\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\"}', '{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}', 0, 'Продажа', 'Sale', 'Verkauf', '2014-04-14 03:58:58', '2020-03-16 11:53:14', '', '', '', 'Venta', '', 'تخفيض السعر', '', 'Satış', ''),
(4, 1, '', 1, '', NULL, 1, 'Пользовательское соглашение', 'User Agreement', 'Benutzervereinbarung', '2020-03-16 03:09:52', '2020-03-16 11:53:33', '<p>Настоящее Соглашение определяет условия использования Пользователями материалов и сервисов сайта <a href=\"{site_domain}\">{site_title}</a>(далее&nbsp;— «Сайт»).</p>\r\n<p><strong>1.Общие условия</strong></p>\r\n<p>1.1. Использование материалов и сервисов Сайта регулируется нормами действующего законодательства Российской Федерации.</p>\r\n<p>1.2. Настоящее Соглашение является публичной офертой. Получая доступ к материалам Сайта Пользователь считается присоединившимся к настоящему Соглашению.</p>\r\n<p>1.3. Администрация Сайта вправе в любое время в одностороннем порядке изменять условия настоящего Соглашения. Такие изменения вступают в силу по истечении 3 (Трех) дней с момента размещения новой версии Соглашения на сайте. При несогласии Пользователя с внесенными изменениями он обязан отказаться от доступа к Сайту, прекратить использование материалов и сервисов Сайта.</p>\r\n<p><strong>2. Обязательства Пользователя</strong></p>\r\n<p>2.1. Пользователь соглашается не предпринимать действий, которые могут рассматриваться как нарушающие российское законодательство или нормы международного права, в том числе в сфере интеллектуальной собственности, авторских и/или смежных правах, а также любых действий, которые приводят или могут привести к нарушению нормальной работы Сайта и сервисов Сайта.</p>\r\n<p>2.2. Использование материалов Сайта без согласия правообладателей не допускается (статья 1270&nbsp;Г.К РФ). Для правомерного использования материалов Сайта необходимо заключение лицензионных договоров(получение лицензий) от Правообладателей.</p>\r\n<p>2.3. При цитировании материалов Сайта, включая охраняемые авторские произведения, ссылка на Сайт обязательна (подпункт 1 пункта 1 статьи 1274&nbsp;Г.К РФ).</p>\r\n<p>2.4. Комментарии и иные записи Пользователя на Сайте не должны вступать в противоречие с требованиями законодательства Российской Федерации и общепринятых норм морали и нравственности.</p>\r\n<p>2.5. Пользователь предупрежден о том, что Администрация Сайта не несет ответственности за посещение и использование им внешних ресурсов, ссылки на которые могут содержаться на сайте.</p>\r\n<p>2.6. Пользователь согласен с тем, что Администрация Сайта не несет ответственности и не имеет прямых или косвенных обязательств перед Пользователем в связи с любыми возможными или возникшими потерями или убытками, связанными с любым содержанием Сайта, регистрацией авторских прав и сведениями о такой регистрации, товарами или услугами, доступными на или полученными через внешние сайты или ресурсы либо иные контакты Пользователя, в которые он вступил, используя размещенную на Сайте информацию или ссылки на внешние ресурсы.</p>\r\n<p>2.7. Пользователь принимает положение о том, что все материалы и сервисы Сайта или любая их часть могут сопровождаться рекламой. Пользователь согласен с тем, что Администрация Сайта не несет какой-либо ответственности и не имеет каких-либо обязательств в связи с такой рекламой.</p>\r\n<p><strong>3. Прочие условия</strong></p>\r\n<p>3.1. Все возможные споры, вытекающие из настоящего Соглашения или связанные с ним, подлежат разрешению в соответствии с действующим законодательством Российской Федерации.</p>\r\n<p>3.2. Ничто в Соглашении не может пониматься как установление между Пользователем и Администрации Сайта агентских отношений, отношений товарищества, отношений по совместной деятельности, отношений личного найма, либо каких-то иных отношений, прямо не предусмотренных Соглашением.</p>\r\n<p>3.3. Признание судом какого-либо положения Соглашения недействительным или не подлежащим принудительному исполнению не влечет недействительности иных положений Соглашения.</p>\r\n<p>3.4. Бездействие со стороны Администрации Сайта в случае нарушения кем-либо из Пользователей положений Соглашения не лишает Администрацию Сайта права предпринять позднее соответствующие действия в защиту своих интересов и защиту авторских прав на охраняемые в соответствии с законодательством материалы Сайта.</p>\r\n<p><strong>Пользователь подтверждает, что ознакомлен со всеми пунктами настоящего Соглашения и безусловно принимает их.</strong></p>\r\n', '<p>This Agreement defines the terms of use of the Site <a href=\"{site_domain}\">{site_title}</a> (hereinafter referred to as — «The Site») and its materials and services by the Users.</p>\n<p><strong>1.General Terms</strong></p>\n<p>1.1. Use of materials and services of the Site is governed by the applicable laws of the Russian Federation.</p>\n<p>1.2. This Agreement is a Public Offer. By getting an access to the Site materials the User is considered to have accepted the terms of the Agreement. </p>\n<p>1.3. The Site administration has the right to change the terms of the Agreement unilaterally at any time. Any modifications shall take effect 3 days after posting a new version of the Agreement on the Site. If the User doesn\'t agree to the terms he is obliged to abandon the access to the Site and to cease the use of the Site materials and services.</p>\n<p><strong>2. Responsibilities of the parties</strong></p>\n<p>2.1. The User agrees not to take any actions, which may be considered as violation of the Russian law or the rules of the international law in the field of the intellectual property, copyrights and / or related rights, as well as any action that results or may result in malfunction of the Site and  website services.</p>\n<p>2.2. Use of the Site materials without explicit permission of the copyright holders is prohibited (article 1270 Civil code of the RF). For the lawful use of the Site materials it is necessary to conclude a licensed agreement (get a license) with the copyright holders.</p>\n<p>2.3. When citing the Site materials including copyright works use of the link to the site is obligatory. (point 1 of the article 1274 Civil Code of the RF).</p>\n<p>2.4. Comments and other User\'s posts on the Site shall not contradict the rules of the Russian Law and generally accepted norms of morality and ethics.</p>\n<p>2.5. The User is warned that the Site administration is not liable for any visit and use of external resources, on the links which may be present on the Site.</p>\n<p>2.6. The User agrees that the Site administration is not responsible and has no direct or indirect liabilities to the User for any loss or damage of the Site contents, registration of the copyrights and information of such registration, goods and services, available or derived from external websites or resources or any other contacts arising from the use of the information posted on the Site or links to external resources. </p>\n<p>2.7. The User accepts that all the Site materials and services or any other part of it may be accompanied by advertising. The User agrees that the Site administration is not liable and doesn\'t have any obligations for such advertising</p>\n<p><strong>3. Other terms</strong></p>\n<p>3.1. All possible disputes arising from this Agreement  or related to it shall be settled in accordance with the current law of the Russian Federation.</p>\n<p>3.2. Nothing in the Agreement shall be understood as establishment of Agents relations, partnership relations, relations on joint activities, personal recruiting relations or any other type of relations between the User and the Site administration which are not directly stipulated by this Agreement.</p>\n<p>3.3. In case the Court treats any point of this Agreement invalid or unenforceable shall not entail invalidation of other statements  of the Agreement. </p>\n<p>3.4. Inaction of the Site administration in case of any violation of the Agreement statements by the Users does not preclude the Site administration to take appropriate actions later in defense of its interests and copyrights on the Site materials protected by the law.</p>\n<p><strong> The user confirms that he/she is aware of the terms and conditions of this Agreement and assumes them.</strong></p>', '<p>This Agreement defines the terms of use of the Site <a href=\"{site_domain}\">{site_title}</a> (hereinafter referred to as — «The Site») and its materials and services by the Users.</p>\r\n<p><strong>1.General Terms</strong></p>\r\n<p>1.1. Use of materials and services of the Site is governed by the applicable laws of the Russian Federation.</p>\r\n<p>1.2. This Agreement is a Public Offer. By getting an access to the Site materials the User is considered to have accepted the terms of the Agreement. </p>\r\n<p>1.3. The Site administration has the right to change the terms of the Agreement unilaterally at any time. Any modifications shall take effect 3 days after posting a new version of the Agreement on the Site. If the User doesn\'t agree to the terms he is obliged to abandon the access to the Site and to cease the use of the Site materials and services.</p>\r\n<p><strong>2. Responsibilities of the parties</strong></p>\r\n<p>2.1. The User agrees not to take any actions, which may be considered as violation of the Russian law or the rules of the international law in the field of the intellectual property, copyrights and / or related rights, as well as any action that results or may result in malfunction of the Site and  website services.</p>\r\n<p>2.2. Use of the Site materials without explicit permission of the copyright holders is prohibited (article 1270 Civil code of the RF). For the lawful use of the Site materials it is necessary to conclude a licensed agreement (get a license) with the copyright holders.</p>\r\n<p>2.3. When citing the Site materials including copyright works use of the link to the site is obligatory. (point 1 of the article 1274 Civil Code of the RF).</p>\r\n<p>2.4. Comments and other User\'s posts on the Site shall not contradict the rules of the Russian Law and generally accepted norms of morality and ethics.</p>\r\n<p>2.5. The User is warned that the Site administration is not liable for any visit and use of external resources, on the links which may be present on the Site.</p>\r\n<p>2.6. The User agrees that the Site administration is not responsible and has no direct or indirect liabilities to the User for any loss or damage of the Site contents, registration of the copyrights and information of such registration, goods and services, available or derived from external websites or resources or any other contacts arising from the use of the information posted on the Site or links to external resources. </p>\r\n<p>2.7. The User accepts that all the Site materials and services or any other part of it may be accompanied by advertising. The User agrees that the Site administration is not liable and doesn\'t have any obligations for such advertising</p>\r\n<p><strong>3. Other terms</strong></p>\r\n<p>3.1. All possible disputes arising from this Agreement  or related to it shall be settled in accordance with the current law of the Russian Federation.</p>\r\n<p>3.2. Nothing in the Agreement shall be understood as establishment of Agents relations, partnership relations, relations on joint activities, personal recruiting relations or any other type of relations between the User and the Site administration which are not directly stipulated by this Agreement.</p>\r\n<p>3.3. In case the Court treats any point of this Agreement invalid or unenforceable shall not entail invalidation of other statements  of the Agreement. </p>\r\n<p>3.4. Inaction of the Site administration in case of any violation of the Agreement statements by the Users does not preclude the Site administration to take appropriate actions later in defense of its interests and copyrights on the Site materials protected by the law.</p>\r\n<p><strong> The user confirms that he/she is aware of the terms and conditions of this Agreement and assumes them.</strong></p>', 'Acuerdo del Usuario', '<p>This Agreement defines the terms of use of the Site <a href=\"{site_domain}\">{site_title}</a> (hereinafter referred to as — «The Site») and its materials and services by the Users.</p> <p><strong>1.General Terms</strong></p> <p>1.1. Use of materials and services of the Site is governed by the applicable laws of the Russian Federation.</p> <p>1.2. This Agreement is a Public Offer. By getting an access to the Site materials the User is considered to have accepted the terms of the Agreement. </p> <p>1.3. The Site administration has the right to change the terms of the Agreement unilaterally at any time. Any modifications shall take effect 3 days after posting a new version of the Agreement on the Site. If the User doesn\'t agree to the terms he is obliged to abandon the access to the Site and to cease the use of the Site materials and services.</p> <p><strong>2. Responsibilities of the parties</strong></p> <p>2.1. The User agrees not to take any actions, which may be considered as violation of the Russian law or the rules of the international law in the field of the intellectual property, copyrights and / or related rights, as well as any action that results or may result in malfunction of the Site and  website services.</p> <p>2.2. Use of the Site materials without explicit permission of the copyright holders is prohibited (article 1270 Civil code of the RF). For the lawful use of the Site materials it is necessary to conclude a licensed agreement (get a license) with the copyright holders.</p> <p>2.3. When citing the Site materials including copyright works use of the link to the site is obligatory. (point 1 of the article 1274 Civil Code of the RF).</p> <p>2.4. Comments and other User\'s posts on the Site shall not contradict the rules of the Russian Law and generally accepted norms of morality and ethics.</p> <p>2.5. The User is warned that the Site administration is not liable for any visit and use of external resources, on the links which may be present on the Site.</p> <p>2.6. The User agrees that the Site administration is not responsible and has no direct or indirect liabilities to the User for any loss or damage of the Site contents, registration of the copyrights and information of such registration, goods and services, available or derived from external websites or resources or any other contacts arising from the use of the information posted on the Site or links to external resources. </p> <p>2.7. The User accepts that all the Site materials and services or any other part of it may be accompanied by advertising. The User agrees that the Site administration is not liable and doesn\'t have any obligations for such advertising</p> <p><strong>3. Other terms</strong></p> <p>3.1. All possible disputes arising from this Agreement  or related to it shall be settled in accordance with the current law of the Russian Federation.</p> <p>3.2. Nothing in the Agreement shall be understood as establishment of Agents relations, partnership relations, relations on joint activities, personal recruiting relations or any other type of relations between the User and the Site administration which are not directly stipulated by this Agreement.</p> <p>3.3. In case the Court treats any point of this Agreement invalid or unenforceable shall not entail invalidation of other statements  of the Agreement. </p> <p>3.4. Inaction of the Site administration in case of any violation of the Agreement statements by the Users does not preclude the Site administration to take appropriate actions later in defense of its interests and copyrights on the Site materials protected by the law.</p> <p><strong> The user confirms that he/she is aware of the terms and conditions of this Agreement and assumes them.</strong></p>', 'اتفاقية المستخدم', '<p>This Agreement defines the terms of use of the Site <a href=\"{site_domain}\">{site_title}</a> (hereinafter referred to as — «The Site») and its materials and services by the Users.</p>\n<p><strong>1.General Terms</strong></p>\n<p>1.1. Use of materials and services of the Site is governed by the applicable laws of the Russian Federation.</p>\n<p>1.2. This Agreement is a Public Offer. By getting an access to the Site materials the User is considered to have accepted the terms of the Agreement. </p>\n<p>1.3. The Site administration has the right to change the terms of the Agreement unilaterally at any time. Any modifications shall take effect 3 days after posting a new version of the Agreement on the Site. If the User doesn\'t agree to the terms he is obliged to abandon the access to the Site and to cease the use of the Site materials and services.</p>\n<p><strong>2. Responsibilities of the parties</strong></p>\n<p>2.1. The User agrees not to take any actions, which may be considered as violation of the Russian law or the rules of the international law in the field of the intellectual property, copyrights and / or related rights, as well as any action that results or may result in malfunction of the Site and  website services.</p>\n<p>2.2. Use of the Site materials without explicit permission of the copyright holders is prohibited (article 1270 Civil code of the RF). For the lawful use of the Site materials it is necessary to conclude a licensed agreement (get a license) with the copyright holders.</p>\n<p>2.3. When citing the Site materials including copyright works use of the link to the site is obligatory. (point 1 of the article 1274 Civil Code of the RF).</p>\n<p>2.4. Comments and other User\'s posts on the Site shall not contradict the rules of the Russian Law and generally accepted norms of morality and ethics.</p>\n<p>2.5. The User is warned that the Site administration is not liable for any visit and use of external resources, on the links which may be present on the Site.</p>\n<p>2.6. The User agrees that the Site administration is not responsible and has no direct or indirect liabilities to the User for any loss or damage of the Site contents, registration of the copyrights and information of such registration, goods and services, available or derived from external websites or resources or any other contacts arising from the use of the information posted on the Site or links to external resources. </p>\n<p>2.7. The User accepts that all the Site materials and services or any other part of it may be accompanied by advertising. The User agrees that the Site administration is not liable and doesn\'t have any obligations for such advertising</p>\n<p><strong>3. Other terms</strong></p>\n<p>3.1. All possible disputes arising from this Agreement  or related to it shall be settled in accordance with the current law of the Russian Federation.</p>\n<p>3.2. Nothing in the Agreement shall be understood as establishment of Agents relations, partnership relations, relations on joint activities, personal recruiting relations or any other type of relations between the User and the Site administration which are not directly stipulated by this Agreement.</p>\n<p>3.3. In case the Court treats any point of this Agreement invalid or unenforceable shall not entail invalidation of other statements  of the Agreement. </p>\n<p>3.4. Inaction of the Site administration in case of any violation of the Agreement statements by the Users does not preclude the Site administration to take appropriate actions later in defense of its interests and copyrights on the Site materials protected by the law.</p>\n<p><strong> The user confirms that he/she is aware of the terms and conditions of this Agreement and assumes them.</strong></p>', 'İşbu üyelik sözleşmesi', '<p>İşbu kullanım koşulları ve şartlarını tanımlar Kullanıcılar tarafından malzeme ve hizmetleri sitesi <a href=\"{site_domain}\">{site_title}</a>(bundan sonra «web Sitesi»).</p>\r\n<p><strong>1.Genel şartlar</strong></p>\r\n<p>1.1. Malzeme ve hizmetleri, Site kurallarına tabidir mevzuat Rusya Federasyonu.</p>\r\n<p>1.2. İşbu Sözleşme, halka arz. Erişerek malzemeleri web Sitesi bir Kullanıcı olarak kabul edilir, katılan kişiler ile konuşmak için bu Anlaşma.</p>\r\n<p>1.3. Site yönetimi hakkı her zaman tek taraflı olarak Sözleşmenin koşullarını değiştirme. Bu değişiklikler sonra 3 (Üç) gün içerisinde değerlendirmeleri, yeni sürüm Anlaşmanın sitede. Bir anlaşmazlık Kullanıcı değişiklikleri zorundadır vazgeçmek Sitesine erişmek kullanarak durdurmak malzemeleri ve hizmetleri Sitesi.</p>\r\n<p><strong>2. Kullanıcının Yükümlülükleri</strong></p>\r\n<p>2.1. Kullanıcı kabul eder ve kendini bir eylem olarak görülebilir ihlal eden rus hukuku ya da uluslararası hukuk normları da dahil olmak üzere fikri mülkiyet alanında telif ve/veya ilgili haklar, yanı sıra herhangi bir işlem sonucu veya bozabilir, normal çalışma Site ve hizmetleri Sitesi.</p>\r\n<p>2.2. Malzeme kullanımı, Site sahiplerinin izni olmadan izin verilmez (madde 1270 Yılında RUSYA federasyonu). İçin yasal malzemelerin kullanımı gereken bir web Sitesi sonuç olarak, lisans sözleşmeleri(lisans alma) hak Sahiplerinin.</p>\r\n<p>2.3. Alıntı yaparken Site malzemeleri de dahil olmak üzere korunan telif eserler, Web sitenize bir bağlantı gereklidir (madde 1, paragraf 1, madde 1274 RF).</p>\r\n<p>2.4. Yorumlar ve diğer kayıtları Kullanıcı Sitede etmemelidir çelişki gereksinimleri ile Rusya Federasyonu mevzuatı ve genel kabul görmüş normları ve ahlak.</p>\r\n<p>2.5. Kullanıcı uyarılır hakkında Site Yönetimi sorumlu değildir ziyareti ve kullanımı onlara dış kaynaklar, referans içerebilir ve web sitesi.</p>\r\n<p>2.6. Kullanıcı kabul eder ki, Site Yönetimi sorumlu değildir ve doğrudan veya dolaylı bir yükümlülük Kullanıcı ile ilgili herhangi bir olası ya da çalışırken kayıp veya hasar ile ilgili herhangi bir içerik Sitesi, tescili, telif hakkı bilgileri ve böyle bir kayıt, mal veya hizmetlerin mevcut veya elde edilen harici siteler ya da kaynakların ya da kişiler, bir Kullanıcı, girdi kullanarak barındırılan bir web Sitesinde bilgi veya dış kaynaklara bağlantılar.</p>\r\n<p>2.7. Kullanıcı pozisyonu alır bildiren tüm içerik ve Site hizmetleri veya bunların herhangi bir bölümünü eşlik edebilir bir reklam. Kullanıcı kabul eder ki, Site Yönetimi sorumlu değildir ve herhangi bir sorumluluk ve yükümlülük nedeniyle böyle bir reklam.</p>\r\n<p><strong>3. Diğer şartlar</strong></p>\r\n<p>3.1. Tüm olası anlaşmazlıkları, bu sözleşmeden doğan veya onunla ilişkili değildir, tabi çözünürlüğü yürürlükteki mevzuat uyarınca, Rusya Federasyonu.</p>\r\n<p>3.2. Bu sözleşme\'deki hiçbir anlaşılabilir olarak kurulması ve Kullanıcı arasındaki Yönetim web Sitesi ajans ilişkileri, ilişkilerin dostluk ilişkileri ve işbirliği faaliyetleri, ilişkiler, kişisel bir işe veya herhangi bir diğer ilişki doğrudan değil, öngörülen bir Anlaşma.</p>\r\n<p>3.3. Tanıma, mahkemece, herhangi bir Sözleşmenin geçersiz veya uygulanamaz olduğu şekilde yürütülmesi söz konusu değildir geçersizliği, diğer hükümlerin Anlaşmanın.</p>\r\n<p>3.4. Hareketsizlik Yönetimi tarafından Site ihlali durumunda herhangi biri Kullanıcı Anlaşmasının mahrum Site Yönetimine haklarını almak, daha sonra uygun adımları kendi çıkarlarını korumak ve haklarını koruma kanunlarına göre malzemeleri web Sitesi.</p>\r\n<p><strong>Kullanıcı onaylar görevlendirilmiş olan tüm noktaları, bu Anlaşmanın ve kesinlikle onları alır.</strong></p>\r\n');
INSERT INTO `{dbPrefix}infopages` (`id`, `active`, `widget`, `widget_position`, `widget_data`, `widget_titles`, `special`, `title_ru`, `title_en`, `title_de`, `date_created`, `date_updated`, `body_ru`, `body_en`, `body_de`, `title_es`, `body_es`, `title_ar`, `body_ar`, `title_tr`, `body_tr`) VALUES
(5, 1, '', 1, '', NULL, 0, 'Политика конфиденциальности', 'Privacy Policy', 'Datenschutzrichtlinien', '2020-03-16 01:07:16', '2020-03-16 11:53:37', '<p>This privacy policy has been compiled to better serve those who are concerned with how their \'Personally identifiable information\' (PII) is being used online. PII, as used in US privacy law and information security, is information that can be used on its own or with other information to identify, contact, or locate a single person, or to identify an individual in context. Please read our privacy policy carefully to get a clear understanding of how we collect, use, protect or otherwise handle your Personally Identifiable Information in accordance with our website.</p>\r\n<p><strong>What personal information do we collect from the people that visit our blog, website or app?</strong></p>\r\n<p>When ordering or registering on our site, as appropriate, you may be asked to enter your name, email address, mailing address, phone number, social security number or other details to help you with your experience.</p>\r\n<p><strong>When do we collect information?</strong></p>\r\n<p>We collect information from you when you register on our site, place an order, subscribe to a newsletter, respond to a survey, fill out a form or enter information on our site.</p>\r\n<p><strong>How do we use your information? </strong></p>\r\n<p>We may use the information we collect from you when you register, make a purchase, sign up for our newsletter, respond to a survey or marketing communication, surf the website, or use certain other site features in the following ways:</p>\r\n<ol>\r\n    <li>To personalize user\'s experience and to allow us to deliver the type of content and product offerings in which you are most interested.</li>\r\n    <li>To improve our website in order to better serve you.</li>\r\n	<li>To allow us to better service you in responding to your customer service requests.</li>\r\n	<li>To administer a contest, promotion, survey or other site feature.</li>\r\n	<li>Identify persons who may be viliating the law, the YOUR COMPANY SITE/NETWORK legal notice and Web site User Agreement, the rights of third parties, or otherwise misusing the YOUR COMPANY SITE/NETWORK or its related properties;</li>\r\n	<li>To send periodic emails regarding your order or other products and services.</li>\r\n</ol>\r\n<p><strong>How do we protect visitor information?</strong></p>\r\n<p>We do not use vulnerability scanning and/or scanning to PCI standards.</p>\r\n<p>We do not use Malware Scanning.</p>\r\n<p>We do not use an SSL certificate.</p>\r\n<p><strong>Do we use \'cookies\'?</strong></p>\r\n<p>Yes. Cookies are small files that a site or its service provider transfers to your computer\'s hard drive through your Web browser (if you allow) that enables the site\'s or service provider\'s systems to recognize your browser and capture and remember certain information. For instance, we use cookies to help us remember and process the items in your shopping cart. They are also used to help us understand your preferences based on previous or current site activity, which enables us to provide you with improved services. We also use cookies to help us compile aggregate data about site traffic and site interaction so that we can offer better site experiences and tools in the future.</p>\r\n<p><strong>We use cookies to:</strong></p>\r\n<ol>\r\n    <li>Understand and save user\'s preferences for future visits.</li>\r\n    <li>Keep track of advertisements.</li>\r\n	<li>Compile aggregate data about site traffic and site interactions in order to offer better site experiences and tools in the future. We may also use trusted third-party services that track this information on our behalf.</li>\r\n</ol>\r\n<p>You can choose to have your computer warn you each time a cookie is being sent, or you can choose to turn off all cookies. You do this through your browser (like Internet Explorer) settings. Each browser is a little different, so look at your browser\'s Help menu to learn the correct way to modify your cookies.</p>\r\n<p><strong>If users disable cookies in their browser:</strong></p>\r\n<p>If you disable cookies off, some features will be disabled It will turn off some of the features that make your site experience more efficient and some of our services will not function properly.</p>\r\n<p><strong>Third-Party Disclosure</strong></p>\r\n<p>We do not sell, trade, or otherwise transfer to outside parties your personally identifiable information unless we provide users with advance notice. This does not include website hosting partners and other parties who assist us in operating our website, conducting our business, or servicing our users, so long as those parties agree to keep this information confidential. We may also release information when it\'s release is appropriate to comply with the law, enforce our site policies, or protect ours or others\' rights, property, or safety. </p>\r\n<p>However, non-personally identifiable visitor information may be provided to other parties for marketing, advertising, or other uses. </p>\r\n<p><strong>Third-party links</strong></p>\r\n<p>We do not include or offer third-party products or services on our website.</p>\r\n<p><strong>Google</strong></p>\r\n<p>Google\'s advertising requirements can be summed up by Google\'s Advertising Principles. They are put in place to provide a positive experience for users. https://support.google.com/adwordspolicy/answer/1316548?hl=en </p>\r\n<p>We use Google AdSense Advertising on our website.</p>\r\n<p>Google, as a third-party vendor, uses cookies to serve ads on our site. Google\'s use of the DART cookie enables it to serve ads to our users based on previous visits to our site and other sites on the Internet. Users may opt-out of the use of the DART cookie by visiting the Google Ad and Content Network privacy policy.</p>\r\n<p><strong>We have implemented the following:</strong></p>\r\n<ol>\r\n    <li>Remarketing with Google AdSense</li>\r\n    <li>Google Display Network Impression Reporting</li>\r\n	<li>Demographics and Interests Reporting</li>\r\n	<li>DoubleClick Platform Integration</li>\r\n</ol>\r\n<p>We along with third-party vendors, such as Google use first-party cookies (such as the Google Analytics cookies) and third-party cookies (such as the DoubleClick cookie) or other third-party identifiers together to compile data regarding user interactions with ad impressions and other ad service functions as they relate to our website. </p>\r\n<p>Opting out: Users can set preferences for how Google advertises to you using the Google Ad Settings page. Alternatively, you can opt out by visiting the Network Advertising initiative opt out page or permanently using the Google Analytics Opt Out Browser add on.</p>\r\n<p><strong>California Online Privacy Protection Act</strong></p>\r\n<p>CalOPPA is the first state law in the nation to require commercial websites and online services to post a privacy policy. The law\'s reach stretches well beyond California to require a person or company in the United States (and conceivably the world) that operates websites collecting personally identifiable information from California consumers to post a conspicuous privacy policy on its website stating exactly the information being collected and those individuals with whom it is being shared, and to comply with this policy. - See more at: http://consumercal.org/california-online-privacy-protection-act-caloppa/#sthash.0FdRbT51.dpuf</p>\r\n<p><strong>According to CalOPPA we agree to the following:</strong></p>\r\n<p>Users can visit our site anonymously. Once this privacy policy is created, we will add a link to it on our home page or as a minimum on the first significant page after entering our website. Our Privacy Policy link includes the word \'Privacy\' and can be easily be found on the page specified above.</p>\r\n<p><strong>How does our site handle do not track signals?</strong></p>\r\n<p>We honor do not track signals and do not track, plant cookies, or use advertising when a Do Not Track (DNT) browser mechanism is in place. </p>\r\n<p><strong>Does our site allow third-party behavioral tracking?</strong></p>\r\n<p>It\'s also important to note that we allow third-party behavioral tracking</p>\r\n<p><strong>COPPA (Children Online Privacy Protection Act)</strong></p>\r\n<p>When it comes to the collection of personal information from children under 13, the Children\'s Online Privacy Protection Act (COPPA) puts parents in control. The Federal Trade Commission, the nation\'s consumer protection agency, enforces the COPPA Rule, which spells out what operators of websites and online services must do to protect children\'s privacy and safety online. We do not specifically market to children under 13.</p>\r\n<p><strong>Fair Information Practices</strong></p>\r\n<p>The Fair Information Practices Principles form the backbone of privacy law in the United States and the concepts they include have played a significant role in the development of data protection laws around the globe. Understanding the Fair Information Practice Principles and how they should be implemented is critical to comply with the various privacy laws that protect personal information.</p>\r\n<p><strong>CAN SPAM Act</strong></p>\r\n<p>The CAN-SPAM Act is a law that sets the rules for commercial email, establishes requirements for commercial messages, gives recipients the right to have emails stopped from being sent to them, and spells out tough penalties for violations.</p>\r\n<p><strong>Contacting Us</strong></p>\r\n<p>If there are any questions regarding this privacy policy you may contact us using the information below.</p>\r\n<br /><br />\r\n<p>YOUSITEDOMAIN</p>\r\n<p>Last Edited on 2016-02-05</p>\r\n', '<p>This privacy policy has been compiled to better serve those who are concerned with how their \'Personally identifiable information\' (PII) is being used online. PII, as used in US privacy law and information security, is information that can be used on its own or with other information to identify, contact, or locate a single person, or to identify an individual in context. Please read our privacy policy carefully to get a clear understanding of how we collect, use, protect or otherwise handle your Personally Identifiable Information in accordance with our website.</p>\n<p><strong>What personal information do we collect from the people that visit our blog, website or app?</strong></p>\n<p>When ordering or registering on our site, as appropriate, you may be asked to enter your name, email address, mailing address, phone number, social security number or other details to help you with your experience.</p>\n<p><strong>When do we collect information?</strong></p>\n<p>We collect information from you when you register on our site, place an order, subscribe to a newsletter, respond to a survey, fill out a form or enter information on our site.</p>\n<p><strong>How do we use your information? </strong></p>\n<p>We may use the information we collect from you when you register, make a purchase, sign up for our newsletter, respond to a survey or marketing communication, surf the website, or use certain other site features in the following ways:</p>\n<ol>\n    <li>To personalize user\'s experience and to allow us to deliver the type of content and product offerings in which you are most interested.</li>\n    <li>To improve our website in order to better serve you.</li>\n	<li>To allow us to better service you in responding to your customer service requests.</li>\n	<li>To administer a contest, promotion, survey or other site feature.</li>\n	<li>Identify persons who may be viliating the law, the YOUR COMPANY SITE/NETWORK legal notice and Web site User Agreement, the rights of third parties, or otherwise misusing the YOUR COMPANY SITE/NETWORK or its related properties;</li>\n	<li>To send periodic emails regarding your order or other products and services.</li>\n</ol>\n<p><strong>How do we protect visitor information?</strong></p>\n<p>We do not use vulnerability scanning and/or scanning to PCI standards.</p>\n<p>We do not use Malware Scanning.</p>\n<p>We do not use an SSL certificate.</p>\n<p><strong>Do we use \'cookies\'?</strong></p>\n<p>Yes. Cookies are small files that a site or its service provider transfers to your computer\'s hard drive through your Web browser (if you allow) that enables the site\'s or service provider\'s systems to recognize your browser and capture and remember certain information. For instance, we use cookies to help us remember and process the items in your shopping cart. They are also used to help us understand your preferences based on previous or current site activity, which enables us to provide you with improved services. We also use cookies to help us compile aggregate data about site traffic and site interaction so that we can offer better site experiences and tools in the future.</p>\n<p><strong>We use cookies to:</strong></p>\n<ol>\n    <li>Understand and save user\'s preferences for future visits.</li>\n    <li>Keep track of advertisements.</li>\n	<li>Compile aggregate data about site traffic and site interactions in order to offer better site experiences and tools in the future. We may also use trusted third-party services that track this information on our behalf.</li>\n</ol>\n<p>You can choose to have your computer warn you each time a cookie is being sent, or you can choose to turn off all cookies. You do this through your browser (like Internet Explorer) settings. Each browser is a little different, so look at your browser\'s Help menu to learn the correct way to modify your cookies.</p>\n<p><strong>If users disable cookies in their browser:</strong></p>\n<p>If you disable cookies off, some features will be disabled It will turn off some of the features that make your site experience more efficient and some of our services will not function properly.</p>\n<p><strong>Third-Party Disclosure</strong></p>\n<p>We do not sell, trade, or otherwise transfer to outside parties your personally identifiable information unless we provide users with advance notice. This does not include website hosting partners and other parties who assist us in operating our website, conducting our business, or servicing our users, so long as those parties agree to keep this information confidential. We may also release information when it\'s release is appropriate to comply with the law, enforce our site policies, or protect ours or others\' rights, property, or safety. </p>\n<p>However, non-personally identifiable visitor information may be provided to other parties for marketing, advertising, or other uses. </p>\n<p><strong>Third-party links</strong></p>\n<p>We do not include or offer third-party products or services on our website.</p>\n<p><strong>Google</strong></p>\n<p>Google\'s advertising requirements can be summed up by Google\'s Advertising Principles. They are put in place to provide a positive experience for users. https://support.google.com/adwordspolicy/answer/1316548?hl=en </p>\n<p>We use Google AdSense Advertising on our website.</p>\n<p>Google, as a third-party vendor, uses cookies to serve ads on our site. Google\'s use of the DART cookie enables it to serve ads to our users based on previous visits to our site and other sites on the Internet. Users may opt-out of the use of the DART cookie by visiting the Google Ad and Content Network privacy policy.</p>\n<p><strong>We have implemented the following:</strong></p>\n<ol>\n    <li>Remarketing with Google AdSense</li>\n    <li>Google Display Network Impression Reporting</li>\n	<li>Demographics and Interests Reporting</li>\n	<li>DoubleClick Platform Integration</li>\n</ol>\n<p>We along with third-party vendors, such as Google use first-party cookies (such as the Google Analytics cookies) and third-party cookies (such as the DoubleClick cookie) or other third-party identifiers together to compile data regarding user interactions with ad impressions and other ad service functions as they relate to our website. </p>\n<p>Opting out: Users can set preferences for how Google advertises to you using the Google Ad Settings page. Alternatively, you can opt out by visiting the Network Advertising initiative opt out page or permanently using the Google Analytics Opt Out Browser add on.</p>\n<p><strong>California Online Privacy Protection Act</strong></p>\n<p>CalOPPA is the first state law in the nation to require commercial websites and online services to post a privacy policy. The law\'s reach stretches well beyond California to require a person or company in the United States (and conceivably the world) that operates websites collecting personally identifiable information from California consumers to post a conspicuous privacy policy on its website stating exactly the information being collected and those individuals with whom it is being shared, and to comply with this policy. - See more at: http://consumercal.org/california-online-privacy-protection-act-caloppa/#sthash.0FdRbT51.dpuf</p>\n<p><strong>According to CalOPPA we agree to the following:</strong></p>\n<p>Users can visit our site anonymously. Once this privacy policy is created, we will add a link to it on our home page or as a minimum on the first significant page after entering our website. Our Privacy Policy link includes the word \'Privacy\' and can be easily be found on the page specified above.</p>\n<p><strong>How does our site handle do not track signals?</strong></p>\n<p>We honor do not track signals and do not track, plant cookies, or use advertising when a Do Not Track (DNT) browser mechanism is in place. </p>\n<p><strong>Does our site allow third-party behavioral tracking?</strong></p>\n<p>It\'s also important to note that we allow third-party behavioral tracking</p>\n<p><strong>COPPA (Children Online Privacy Protection Act)</strong></p>\n<p>When it comes to the collection of personal information from children under 13, the Children\'s Online Privacy Protection Act (COPPA) puts parents in control. The Federal Trade Commission, the nation\'s consumer protection agency, enforces the COPPA Rule, which spells out what operators of websites and online services must do to protect children\'s privacy and safety online. We do not specifically market to children under 13.</p>\n<p><strong>Fair Information Practices</strong></p>\n<p>The Fair Information Practices Principles form the backbone of privacy law in the United States and the concepts they include have played a significant role in the development of data protection laws around the globe. Understanding the Fair Information Practice Principles and how they should be implemented is critical to comply with the various privacy laws that protect personal information.</p>\n<p><strong>CAN SPAM Act</strong></p>\n<p>The CAN-SPAM Act is a law that sets the rules for commercial email, establishes requirements for commercial messages, gives recipients the right to have emails stopped from being sent to them, and spells out tough penalties for violations.</p>\n<p><strong>Contacting Us</strong></p>\n<p>If there are any questions regarding this privacy policy you may contact us using the information below.</p>\n<br /><br />\n<p>YOUSITEDOMAIN</p>\n<p>Last Edited on 2016-02-05</p>\n', '<p>This privacy policy has been compiled to better serve those who are concerned with how their \'Personally identifiable information\' (PII) is being used online. PII, as used in US privacy law and information security, is information that can be used on its own or with other information to identify, contact, or locate a single person, or to identify an individual in context. Please read our privacy policy carefully to get a clear understanding of how we collect, use, protect or otherwise handle your Personally Identifiable Information in accordance with our website.</p>\r\n<p><strong>What personal information do we collect from the people that visit our blog, website or app?</strong></p>\r\n<p>When ordering or registering on our site, as appropriate, you may be asked to enter your name, email address, mailing address, phone number, social security number or other details to help you with your experience.</p>\r\n<p><strong>When do we collect information?</strong></p>\r\n<p>We collect information from you when you register on our site, place an order, subscribe to a newsletter, respond to a survey, fill out a form or enter information on our site.</p>\r\n<p><strong>How do we use your information? </strong></p>\r\n<p>We may use the information we collect from you when you register, make a purchase, sign up for our newsletter, respond to a survey or marketing communication, surf the website, or use certain other site features in the following ways:</p>\r\n<ol>\r\n    <li>To personalize user\'s experience and to allow us to deliver the type of content and product offerings in which you are most interested.</li>\r\n    <li>To improve our website in order to better serve you.</li>\r\n	<li>To allow us to better service you in responding to your customer service requests.</li>\r\n	<li>To administer a contest, promotion, survey or other site feature.</li>\r\n	<li>Identify persons who may be viliating the law, the YOUR COMPANY SITE/NETWORK legal notice and Web site User Agreement, the rights of third parties, or otherwise misusing the YOUR COMPANY SITE/NETWORK or its related properties;</li>\r\n	<li>To send periodic emails regarding your order or other products and services.</li>\r\n</ol>\r\n<p><strong>How do we protect visitor information?</strong></p>\r\n<p>We do not use vulnerability scanning and/or scanning to PCI standards.</p>\r\n<p>We do not use Malware Scanning.</p>\r\n<p>We do not use an SSL certificate.</p>\r\n<p><strong>Do we use \'cookies\'?</strong></p>\r\n<p>Yes. Cookies are small files that a site or its service provider transfers to your computer\'s hard drive through your Web browser (if you allow) that enables the site\'s or service provider\'s systems to recognize your browser and capture and remember certain information. For instance, we use cookies to help us remember and process the items in your shopping cart. They are also used to help us understand your preferences based on previous or current site activity, which enables us to provide you with improved services. We also use cookies to help us compile aggregate data about site traffic and site interaction so that we can offer better site experiences and tools in the future.</p>\r\n<p><strong>We use cookies to:</strong></p>\r\n<ol>\r\n    <li>Understand and save user\'s preferences for future visits.</li>\r\n    <li>Keep track of advertisements.</li>\r\n	<li>Compile aggregate data about site traffic and site interactions in order to offer better site experiences and tools in the future. We may also use trusted third-party services that track this information on our behalf.</li>\r\n</ol>\r\n<p>You can choose to have your computer warn you each time a cookie is being sent, or you can choose to turn off all cookies. You do this through your browser (like Internet Explorer) settings. Each browser is a little different, so look at your browser\'s Help menu to learn the correct way to modify your cookies.</p>\r\n<p><strong>If users disable cookies in their browser:</strong></p>\r\n<p>If you disable cookies off, some features will be disabled It will turn off some of the features that make your site experience more efficient and some of our services will not function properly.</p>\r\n<p><strong>Third-Party Disclosure</strong></p>\r\n<p>We do not sell, trade, or otherwise transfer to outside parties your personally identifiable information unless we provide users with advance notice. This does not include website hosting partners and other parties who assist us in operating our website, conducting our business, or servicing our users, so long as those parties agree to keep this information confidential. We may also release information when it\'s release is appropriate to comply with the law, enforce our site policies, or protect ours or others\' rights, property, or safety. </p>\r\n<p>However, non-personally identifiable visitor information may be provided to other parties for marketing, advertising, or other uses. </p>\r\n<p><strong>Third-party links</strong></p>\r\n<p>We do not include or offer third-party products or services on our website.</p>\r\n<p><strong>Google</strong></p>\r\n<p>Google\'s advertising requirements can be summed up by Google\'s Advertising Principles. They are put in place to provide a positive experience for users. https://support.google.com/adwordspolicy/answer/1316548?hl=en </p>\r\n<p>We use Google AdSense Advertising on our website.</p>\r\n<p>Google, as a third-party vendor, uses cookies to serve ads on our site. Google\'s use of the DART cookie enables it to serve ads to our users based on previous visits to our site and other sites on the Internet. Users may opt-out of the use of the DART cookie by visiting the Google Ad and Content Network privacy policy.</p>\r\n<p><strong>We have implemented the following:</strong></p>\r\n<ol>\r\n    <li>Remarketing with Google AdSense</li>\r\n    <li>Google Display Network Impression Reporting</li>\r\n	<li>Demographics and Interests Reporting</li>\r\n	<li>DoubleClick Platform Integration</li>\r\n</ol>\r\n<p>We along with third-party vendors, such as Google use first-party cookies (such as the Google Analytics cookies) and third-party cookies (such as the DoubleClick cookie) or other third-party identifiers together to compile data regarding user interactions with ad impressions and other ad service functions as they relate to our website. </p>\r\n<p>Opting out: Users can set preferences for how Google advertises to you using the Google Ad Settings page. Alternatively, you can opt out by visiting the Network Advertising initiative opt out page or permanently using the Google Analytics Opt Out Browser add on.</p>\r\n<p><strong>California Online Privacy Protection Act</strong></p>\r\n<p>CalOPPA is the first state law in the nation to require commercial websites and online services to post a privacy policy. The law\'s reach stretches well beyond California to require a person or company in the United States (and conceivably the world) that operates websites collecting personally identifiable information from California consumers to post a conspicuous privacy policy on its website stating exactly the information being collected and those individuals with whom it is being shared, and to comply with this policy. - See more at: http://consumercal.org/california-online-privacy-protection-act-caloppa/#sthash.0FdRbT51.dpuf</p>\r\n<p><strong>According to CalOPPA we agree to the following:</strong></p>\r\n<p>Users can visit our site anonymously. Once this privacy policy is created, we will add a link to it on our home page or as a minimum on the first significant page after entering our website. Our Privacy Policy link includes the word \'Privacy\' and can be easily be found on the page specified above.</p>\r\n<p><strong>How does our site handle do not track signals?</strong></p>\r\n<p>We honor do not track signals and do not track, plant cookies, or use advertising when a Do Not Track (DNT) browser mechanism is in place. </p>\r\n<p><strong>Does our site allow third-party behavioral tracking?</strong></p>\r\n<p>It\'s also important to note that we allow third-party behavioral tracking</p>\r\n<p><strong>COPPA (Children Online Privacy Protection Act)</strong></p>\r\n<p>When it comes to the collection of personal information from children under 13, the Children\'s Online Privacy Protection Act (COPPA) puts parents in control. The Federal Trade Commission, the nation\'s consumer protection agency, enforces the COPPA Rule, which spells out what operators of websites and online services must do to protect children\'s privacy and safety online. We do not specifically market to children under 13.</p>\r\n<p><strong>Fair Information Practices</strong></p>\r\n<p>The Fair Information Practices Principles form the backbone of privacy law in the United States and the concepts they include have played a significant role in the development of data protection laws around the globe. Understanding the Fair Information Practice Principles and how they should be implemented is critical to comply with the various privacy laws that protect personal information.</p>\r\n<p><strong>CAN SPAM Act</strong></p>\r\n<p>The CAN-SPAM Act is a law that sets the rules for commercial email, establishes requirements for commercial messages, gives recipients the right to have emails stopped from being sent to them, and spells out tough penalties for violations.</p>\r\n<p><strong>Contacting Us</strong></p>\r\n<p>If there are any questions regarding this privacy policy you may contact us using the information below.</p>\r\n<br /><br />\r\n<p>YOUSITEDOMAIN</p>\r\n<p>Last Edited on 2016-02-05</p>\r\n', 'Política de privacidad', '<p>This privacy policy has been compiled to better serve those who are concerned with how their \'Personally identifiable information\' (PII) is being used online. PII, as used in US privacy law and information security, is information that can be used on its own or with other information to identify, contact, or locate a single person, or to identify an individual in context. Please read our privacy policy carefully to get a clear understanding of how we collect, use, protect or otherwise handle your Personally Identifiable Information in accordance with our website.</p> <p><strong>What personal information do we collect from the people that visit our blog, website or app?</strong></p> <p>When ordering or registering on our site, as appropriate, you may be asked to enter your name, email address, mailing address, phone number, social security number or other details to help you with your experience.</p> <p><strong>When do we collect information?</strong></p> <p>We collect information from you when you register on our site, place an order, subscribe to a newsletter, respond to a survey, fill out a form or enter information on our site.</p> <p><strong>How do we use your information? </strong></p> <p>We may use the information we collect from you when you register, make a purchase, sign up for our newsletter, respond to a survey or marketing communication, surf the website, or use certain other site features in the following ways:</p> <ol>     <li>To personalize user\'s experience and to allow us to deliver the type of content and product offerings in which you are most interested.</li>     <li>To improve our website in order to better serve you.</li> 	<li>To allow us to better service you in responding to your customer service requests.</li> 	<li>To administer a contest, promotion, survey or other site feature.</li> 	<li>Identify persons who may be viliating the law, the YOUR COMPANY SITE/NETWORK legal notice and Web site User Agreement, the rights of third parties, or otherwise misusing the YOUR COMPANY SITE/NETWORK or its related properties;</li> 	<li>To send periodic emails regarding your order or other products and services.</li> </ol> <p><strong>How do we protect visitor information?</strong></p> <p>We do not use vulnerability scanning and/or scanning to PCI standards.</p> <p>We do not use Malware Scanning.</p> <p>We do not use an SSL certificate.</p> <p><strong>Do we use \'cookies\'?</strong></p> <p>Yes. Cookies are small files that a site or its service provider transfers to your computer\'s hard drive through your Web browser (if you allow) that enables the site\'s or service provider\'s systems to recognize your browser and capture and remember certain information. For instance, we use cookies to help us remember and process the items in your shopping cart. They are also used to help us understand your preferences based on previous or current site activity, which enables us to provide you with improved services. We also use cookies to help us compile aggregate data about site traffic and site interaction so that we can offer better site experiences and tools in the future.</p> <p><strong>We use cookies to:</strong></p> <ol>     <li>Understand and save user\'s preferences for future visits.</li>     <li>Keep track of advertisements.</li> 	<li>Compile aggregate data about site traffic and site interactions in order to offer better site experiences and tools in the future. We may also use trusted third-party services that track this information on our behalf.</li> </ol> <p>You can choose to have your computer warn you each time a cookie is being sent, or you can choose to turn off all cookies. You do this through your browser (like Internet Explorer) settings. Each browser is a little different, so look at your browser\'s Help menu to learn the correct way to modify your cookies.</p> <p><strong>If users disable cookies in their browser:</strong></p> <p>If you disable cookies off, some features will be disabled It will turn off some of the features that make your site experience more efficient and some of our services will not function properly.</p> <p><strong>Third-Party Disclosure</strong></p> <p>We do not sell, trade, or otherwise transfer to outside parties your personally identifiable information unless we provide users with advance notice. This does not include website hosting partners and other parties who assist us in operating our website, conducting our business, or servicing our users, so long as those parties agree to keep this information confidential. We may also release information when it\'s release is appropriate to comply with the law, enforce our site policies, or protect ours or others\' rights, property, or safety. </p> <p>However, non-personally identifiable visitor information may be provided to other parties for marketing, advertising, or other uses. </p> <p><strong>Third-party links</strong></p> <p>We do not include or offer third-party products or services on our website.</p> <p><strong>Google</strong></p> <p>Google\'s advertising requirements can be summed up by Google\'s Advertising Principles. They are put in place to provide a positive experience for users. https://support.google.com/adwordspolicy/answer/1316548?hl=en </p> <p>We use Google AdSense Advertising on our website.</p> <p>Google, as a third-party vendor, uses cookies to serve ads on our site. Google\'s use of the DART cookie enables it to serve ads to our users based on previous visits to our site and other sites on the Internet. Users may opt-out of the use of the DART cookie by visiting the Google Ad and Content Network privacy policy.</p> <p><strong>We have implemented the following:</strong></p> <ol>     <li>Remarketing with Google AdSense</li>     <li>Google Display Network Impression Reporting</li> 	<li>Demographics and Interests Reporting</li> 	<li>DoubleClick Platform Integration</li> </ol> <p>We along with third-party vendors, such as Google use first-party cookies (such as the Google Analytics cookies) and third-party cookies (such as the DoubleClick cookie) or other third-party identifiers together to compile data regarding user interactions with ad impressions and other ad service functions as they relate to our website. </p> <p>Opting out: Users can set preferences for how Google advertises to you using the Google Ad Settings page. Alternatively, you can opt out by visiting the Network Advertising initiative opt out page or permanently using the Google Analytics Opt Out Browser add on.</p> <p><strong>California Online Privacy Protection Act</strong></p> <p>CalOPPA is the first state law in the nation to require commercial websites and online services to post a privacy policy. The law\'s reach stretches well beyond California to require a person or company in the United States (and conceivably the world) that operates websites collecting personally identifiable information from California consumers to post a conspicuous privacy policy on its website stating exactly the information being collected and those individuals with whom it is being shared, and to comply with this policy. - See more at: http://consumercal.org/california-online-privacy-protection-act-caloppa/#sthash.0FdRbT51.dpuf</p> <p><strong>According to CalOPPA we agree to the following:</strong></p> <p>Users can visit our site anonymously. Once this privacy policy is created, we will add a link to it on our home page or as a minimum on the first significant page after entering our website. Our Privacy Policy link includes the word \'Privacy\' and can be easily be found on the page specified above.</p> <p><strong>How does our site handle do not track signals?</strong></p> <p>We honor do not track signals and do not track, plant cookies, or use advertising when a Do Not Track (DNT) browser mechanism is in place. </p> <p><strong>Does our site allow third-party behavioral tracking?</strong></p> <p>It\'s also important to note that we allow third-party behavioral tracking</p> <p><strong>COPPA (Children Online Privacy Protection Act)</strong></p> <p>When it comes to the collection of personal information from children under 13, the Children\'s Online Privacy Protection Act (COPPA) puts parents in control. The Federal Trade Commission, the nation\'s consumer protection agency, enforces the COPPA Rule, which spells out what operators of websites and online services must do to protect children\'s privacy and safety online. We do not specifically market to children under 13.</p> <p><strong>Fair Information Practices</strong></p> <p>The Fair Information Practices Principles form the backbone of privacy law in the United States and the concepts they include have played a significant role in the development of data protection laws around the globe. Understanding the Fair Information Practice Principles and how they should be implemented is critical to comply with the various privacy laws that protect personal information.</p> <p><strong>CAN SPAM Act</strong></p> <p>The CAN-SPAM Act is a law that sets the rules for commercial email, establishes requirements for commercial messages, gives recipients the right to have emails stopped from being sent to them, and spells out tough penalties for violations.</p> <p><strong>Contacting Us</strong></p> <p>If there are any questions regarding this privacy policy you may contact us using the information below.</p> <br /><br /> <p>YOUSITEDOMAIN</p> <p>Last Edited on 2016-02-05</p>', 'سياسة الخصوصية', '<p>This privacy policy has been compiled to better serve those who are concerned with how their \'Personally identifiable information\' (PII) is being used online. PII, as used in US privacy law and information security, is information that can be used on its own or with other information to identify, contact, or locate a single person, or to identify an individual in context. Please read our privacy policy carefully to get a clear understanding of how we collect, use, protect or otherwise handle your Personally Identifiable Information in accordance with our website.</p>\n<p><strong>What personal information do we collect from the people that visit our blog, website or app?</strong></p>\n<p>When ordering or registering on our site, as appropriate, you may be asked to enter your name, email address, mailing address, phone number, social security number or other details to help you with your experience.</p>\n<p><strong>When do we collect information?</strong></p>\n<p>We collect information from you when you register on our site, place an order, subscribe to a newsletter, respond to a survey, fill out a form or enter information on our site.</p>\n<p><strong>How do we use your information? </strong></p>\n<p>We may use the information we collect from you when you register, make a purchase, sign up for our newsletter, respond to a survey or marketing communication, surf the website, or use certain other site features in the following ways:</p>\n<ol>\n    <li>To personalize user\'s experience and to allow us to deliver the type of content and product offerings in which you are most interested.</li>\n    <li>To improve our website in order to better serve you.</li>\n	<li>To allow us to better service you in responding to your customer service requests.</li>\n	<li>To administer a contest, promotion, survey or other site feature.</li>\n	<li>Identify persons who may be viliating the law, the YOUR COMPANY SITE/NETWORK legal notice and Web site User Agreement, the rights of third parties, or otherwise misusing the YOUR COMPANY SITE/NETWORK or its related properties;</li>\n	<li>To send periodic emails regarding your order or other products and services.</li>\n</ol>\n<p><strong>How do we protect visitor information?</strong></p>\n<p>We do not use vulnerability scanning and/or scanning to PCI standards.</p>\n<p>We do not use Malware Scanning.</p>\n<p>We do not use an SSL certificate.</p>\n<p><strong>Do we use \'cookies\'?</strong></p>\n<p>Yes. Cookies are small files that a site or its service provider transfers to your computer\'s hard drive through your Web browser (if you allow) that enables the site\'s or service provider\'s systems to recognize your browser and capture and remember certain information. For instance, we use cookies to help us remember and process the items in your shopping cart. They are also used to help us understand your preferences based on previous or current site activity, which enables us to provide you with improved services. We also use cookies to help us compile aggregate data about site traffic and site interaction so that we can offer better site experiences and tools in the future.</p>\n<p><strong>We use cookies to:</strong></p>\n<ol>\n    <li>Understand and save user\'s preferences for future visits.</li>\n    <li>Keep track of advertisements.</li>\n	<li>Compile aggregate data about site traffic and site interactions in order to offer better site experiences and tools in the future. We may also use trusted third-party services that track this information on our behalf.</li>\n</ol>\n<p>You can choose to have your computer warn you each time a cookie is being sent, or you can choose to turn off all cookies. You do this through your browser (like Internet Explorer) settings. Each browser is a little different, so look at your browser\'s Help menu to learn the correct way to modify your cookies.</p>\n<p><strong>If users disable cookies in their browser:</strong></p>\n<p>If you disable cookies off, some features will be disabled It will turn off some of the features that make your site experience more efficient and some of our services will not function properly.</p>\n<p><strong>Third-Party Disclosure</strong></p>\n<p>We do not sell, trade, or otherwise transfer to outside parties your personally identifiable information unless we provide users with advance notice. This does not include website hosting partners and other parties who assist us in operating our website, conducting our business, or servicing our users, so long as those parties agree to keep this information confidential. We may also release information when it\'s release is appropriate to comply with the law, enforce our site policies, or protect ours or others\' rights, property, or safety. </p>\n<p>However, non-personally identifiable visitor information may be provided to other parties for marketing, advertising, or other uses. </p>\n<p><strong>Third-party links</strong></p>\n<p>We do not include or offer third-party products or services on our website.</p>\n<p><strong>Google</strong></p>\n<p>Google\'s advertising requirements can be summed up by Google\'s Advertising Principles. They are put in place to provide a positive experience for users. https://support.google.com/adwordspolicy/answer/1316548?hl=en </p>\n<p>We use Google AdSense Advertising on our website.</p>\n<p>Google, as a third-party vendor, uses cookies to serve ads on our site. Google\'s use of the DART cookie enables it to serve ads to our users based on previous visits to our site and other sites on the Internet. Users may opt-out of the use of the DART cookie by visiting the Google Ad and Content Network privacy policy.</p>\n<p><strong>We have implemented the following:</strong></p>\n<ol>\n    <li>Remarketing with Google AdSense</li>\n    <li>Google Display Network Impression Reporting</li>\n	<li>Demographics and Interests Reporting</li>\n	<li>DoubleClick Platform Integration</li>\n</ol>\n<p>We along with third-party vendors, such as Google use first-party cookies (such as the Google Analytics cookies) and third-party cookies (such as the DoubleClick cookie) or other third-party identifiers together to compile data regarding user interactions with ad impressions and other ad service functions as they relate to our website. </p>\n<p>Opting out: Users can set preferences for how Google advertises to you using the Google Ad Settings page. Alternatively, you can opt out by visiting the Network Advertising initiative opt out page or permanently using the Google Analytics Opt Out Browser add on.</p>\n<p><strong>California Online Privacy Protection Act</strong></p>\n<p>CalOPPA is the first state law in the nation to require commercial websites and online services to post a privacy policy. The law\'s reach stretches well beyond California to require a person or company in the United States (and conceivably the world) that operates websites collecting personally identifiable information from California consumers to post a conspicuous privacy policy on its website stating exactly the information being collected and those individuals with whom it is being shared, and to comply with this policy. - See more at: http://consumercal.org/california-online-privacy-protection-act-caloppa/#sthash.0FdRbT51.dpuf</p>\n<p><strong>According to CalOPPA we agree to the following:</strong></p>\n<p>Users can visit our site anonymously. Once this privacy policy is created, we will add a link to it on our home page or as a minimum on the first significant page after entering our website. Our Privacy Policy link includes the word \'Privacy\' and can be easily be found on the page specified above.</p>\n<p><strong>How does our site handle do not track signals?</strong></p>\n<p>We honor do not track signals and do not track, plant cookies, or use advertising when a Do Not Track (DNT) browser mechanism is in place. </p>\n<p><strong>Does our site allow third-party behavioral tracking?</strong></p>\n<p>It\'s also important to note that we allow third-party behavioral tracking</p>\n<p><strong>COPPA (Children Online Privacy Protection Act)</strong></p>\n<p>When it comes to the collection of personal information from children under 13, the Children\'s Online Privacy Protection Act (COPPA) puts parents in control. The Federal Trade Commission, the nation\'s consumer protection agency, enforces the COPPA Rule, which spells out what operators of websites and online services must do to protect children\'s privacy and safety online. We do not specifically market to children under 13.</p>\n<p><strong>Fair Information Practices</strong></p>\n<p>The Fair Information Practices Principles form the backbone of privacy law in the United States and the concepts they include have played a significant role in the development of data protection laws around the globe. Understanding the Fair Information Practice Principles and how they should be implemented is critical to comply with the various privacy laws that protect personal information.</p>\n<p><strong>CAN SPAM Act</strong></p>\n<p>The CAN-SPAM Act is a law that sets the rules for commercial email, establishes requirements for commercial messages, gives recipients the right to have emails stopped from being sent to them, and spells out tough penalties for violations.</p>\n<p><strong>Contacting Us</strong></p>\n<p>If there are any questions regarding this privacy policy you may contact us using the information below.</p>\n<br /><br />\n<p>YOUSITEDOMAIN</p>\n<p>Last Edited on 2016-02-05</p>\n', 'Gizlilik politikası', '<p>This privacy policy has been compiled to better serve those who are concerned with how their \'Personally identifiable information\' (PII) is being used online. PII, as used in US privacy law and ınformation security, information is that can be used on its own or with other ınformation to identify, iletişim, or locate a single person or to ıdentify an individual in context. Please read our privacy policy carefully to get a clear understanding of how we collect, use, protect or otherwise handle your Personally İdentifiable İnformation in accordance with our website.</p>\r\n<p><strong>What personal ınformation do we collect from the people that visit our blog, website or app?</strong></p>\r\n<p>When ordering or registering on our site, as appropriate, you may be asked to enter your name, email address, mailing address, phone number, social security number or other details to help you with your experience.</p>\r\n<p><strong>When do we collect information mi?</strong></p>\r\n<p>We collect information from you when you register on our site, place an order, subscribe to a newsletter, respond to a survey, fill out a form or enter information on our site.</p>\r\n<p><strong>How do we use your ınformation? </strong></p>\r\n<p>We may use the information we collect from you when you register, make a purchase, sign up for our newsletter, respond to a survey or marketing communication, surf the website, or use certain other site features in the following ways:</p>\r\n<ol>\r\n    <li>To personalize user\'s experience and to allow us to deliver the type of content and product offerings in which you are most interested.</li>\r\n    <li>To improve our website in order to better serve you.</li>\r\n	<li>To allow us to better service you ın vermiyor to your customer service requests.</li>\r\n	<li>To administer a contest, promosyon, anket veya diğer site özelliği.</li>\r\n	<li>Identify persons who may be viliating the law, the YOUR COMPANY SİTE/NETWORK legal notice and Web site User Agreement, the rights of third parties, or otherwise misusing the YOUR COMPANY SİTE/NETWORK or its related properties;</li>\r\n	<li>To send periodic emails regarding your order or other products and services.</li>\r\n</ol>\r\n<p><strong>How do we protect visitor ınformation?</strong></p>\r\n<p>We do not use vulnerability scanning and/or scanning to PCI standards.</p>\r\n<p>We do not use Malware Scanning.</p>\r\n<p>We do not use an SSL certificate.</p>\r\n<p><strong>Do we use \'cookies\'?</strong></p>\r\n<p>Yes. Cookies are small files that a site or its service provider transfers to your computer\'s hard drive through your Web browser (if you allow) that enables the site\'s or service provider\'s systems to recognize your browser and capture and remember certain information. For instance, we use cookies to help us remember and process the items in your shopping cart. They are also used to help us understand your preferences based on previous or current site activity, which enables us to provide you with improved services. We also use cookies to help us compile aggregate data about site traffic and interaction site so that we can offer better site experiences and tools in the future.</p>\r\n<p><strong>We use cookies to:</strong></p>\r\n<ol>\r\n    <li>Understand and save user\'s preferences for future visits.</li>\r\n    <li>Keep track of advertisements.</li>\r\n	<li>Compile aggregate data about site traffic and site interactions in order to offer better site experiences and tools in the future. We may also use trusted third-party services that track this information on our adına ödeme.</li>\r\n</ol>\r\n<p>You can choose to have your computer warn you each time a cookie is being sent, or you can choose to turn off all cookies. You do this through your browser (Internet Explorer gibi) ayarlar. Each browser is a little different, so look at your browser\'s Help menu to learn the correct way to modify your cookies.</p>\r\n<p><strong>İf users disable cookies in their browser:</strong></p>\r\n<p>If you disable cookies off some features will be disabled, İt will turn off some of the features that make your site experience more efficient and some of our services will not function properly.</p>\r\n<p><strong>Third-Party Disclosure</strong></p>\r\n<p>We do not sell, trade, or otherwise transfer to outside parties your personally identifiable information unless we provide users with advance notice. This does not include website hosting partners and other parties who assist us operating in our website, conducting our business, or servicing our users, so long as those parties agree to keep this information confidential. We may also release ınformation when ıt\'s release is appropriate to comply with the law enforce our site policies, or protect ours or others\' rights, property, or safety. </p>\r\n<p>However, non-personally identifiable visitor information may be provided to other parties for marketing, advertising, or other uses. </p>\r\n<p><strong>Third-party links</strong></p>\r\n<p>We do not include or offer third-party products or services on our website.</p>\r\n<p><strong>Google</strong></p>\r\n<p>Google s advertising requirements can be summed up by Google s Advertising Principles. They are put in place to provide a positive experience for users. https://support.google.com/adwordspolicy/answer/1316548?hl=en </p>\r\n<p>We use Google AdSense Advertising on our website.</p>\r\n<p>Google, as a third-party vendor, uses cookies to serve ads on our site. Google s use of the DART çerezi enables ıt to serve ads to our users, based on previous visits to our site and other sites on the Internet. Users may opt-out of the use of the DART çerezi by visiting the Google Ad and Content Network privacy policy.</p>\r\n<p><strong>We have implemented the following:</strong></p>\r\n<ol>\r\n    <li>Pazarlamayı with Google AdSense</li>\r\n    <li>Google Display Network Impression Raporlama</li>\r\n	<li>Demographics and Interests Raporlama</li>\r\n	<li>DoubleClick Platform Integration</li>\r\n</ol>\r\n<p>We along with third-party vendors, such as Google use first-party cookies (such as the Google Analytics \"çerezler\") and third-party cookies (such as the DoubleClick cookie) or other third-party tanımlayıcıları together to compile data regarding user interactions with ad ımpressions and other ad service functions as they relate to our website. </p>\r\n<p>Opting out: Users can set preferences for how Google advertises to you using the Google Ad Settings page. Alternatively, you can opt out by visiting the Network Advertising ınitiative opt out page or permanently using the Google Analytics Opt-Out Browser add-on.</p>\r\n<p><strong>California Çevrimiçi Gizlilik Koruma Yasası</strong></p>\r\n<p>CalOPPA is the first state law in the nation to require commercial websites and online services to post a privacy policy. The law\'s reach stretches well beyond California to require a person or company in the United States (and conceivably the world) websites that operates collecting personally identifiable information from California consumers to post a conspicuous privacy policy on its website stating exactly the ınformation being collected and those individuals with whom it is being shared, and to comply with this policy. - See more at: http://consumercal.org/california-online-privacy-protection-act-caloppa/#sthash.0FdRbT51.dpuf</p>\r\n<p><strong>According to CalOPPA we agree to the following:</strong></p>\r\n<p>Users can visit our site anonymously. Once this privacy policy is created, we will add a link to it on our home page or as a minimum on the first significant page after entering our website. Our Privacy Policy link includes the word \'Privacy\' and can be easily be found on the page specified above.</p>\r\n<p><strong>How does our site handle do not track signals?</strong></p>\r\n<p>We honor do not track signals and do not track plant çerezler, or use advertising when a Do-Not-Track (DNT) browser mechanism is in place. </p>\r\n<p><strong>Does our site allow third-party behavioral takip?</strong></p>\r\n<p>It\'s also important to note that we allow third-party behavioral takip</p>\r\n<p><strong>COPPA (Children\'s Online Privacy Protection Act)</strong></p>\r\n<p>When it comes to the collection of personal information from children under 13, the children\'s Online Privacy Protection Act (COPPA) puts parents in control. The Federal Trade Commission, the nation\'s consumer protection agency, enforces the COPPA Rule, which spells out what operators of websites and online services must do to protect children\'s privacy and safety online. We do not specifically market to children under 13.</p>\r\n<p><strong>Fair Information Practices</strong></p>\r\n<p>The Fair Information Practices Principles form the backbone of privacy law in the United States and the concepts they include have played a significant role in the development of data protection laws around the globe. Understanding the Fair Information Practice Principles and how they should be implemented is critical to comply with the various privacy laws that protect personal information.</p>\r\n<p><strong>CAN SPAM Act</strong></p>\r\n<p>The CAN-SPAM Act is a law that sets the rules for commercial e-posta, establishes requirements for commercial messages, gives recipients the right to emails have stopped from being sent to them, and spells out tough penalties for violations.</p>\r\n<p><strong>Contacting Us</strong></p>\r\n<p>If there are any questions regarding this privacy policy you may contact us using the information below.</p>\r\n<br /><br />\r\n<p>YOUSİTEDOMAİN</p>\r\n<p>Last Edited on 2016-02-05</p>\r\n');
INSERT INTO `{dbPrefix}infopages` (`id`, `active`, `widget`, `widget_position`, `widget_data`, `widget_titles`, `special`, `title_ru`, `title_en`, `title_de`, `date_created`, `date_updated`, `body_ru`, `body_en`, `body_de`, `title_es`, `body_es`, `title_ar`, `body_ar`, `title_tr`, `body_tr`) VALUES
(6, 1, 'apartments', 1, '{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"1\",\"obj_type_id\":\"0\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\"}', '{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}', 0, 'Аренда', 'Rent', 'Miete', '2017-10-02 11:57:14', '2020-03-16 11:53:21', '', '', '', 'Alquileres', '', 'تورالي (مستأجرة)', '', 'Kiralama', ''),
(7, 1, 'apartments', 2, '{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"0\",\"obj_type_id\":\"6\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\",\"garage_type\":\"\",\"open_plan\":\"\",\"room_type\":\"\",\"balcony_type\":\"\",\"wc_type\":\"\",\"floor_coat\":\"\",\"build_year\":\"\",\"repair\":\"\",\"object_state\":\"\",\"building_type\":\"\",\"plot_type\":\"\"}', '{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}', 0, 'Гостиницы', 'Hotels', 'Hotels', '2020-03-16 12:08:43', '2020-03-16 11:53:39', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n', 'Hotel(es)', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n', 'فنادق', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n', 'Otel', '<p>Lorem ipsum dolor sit amet, ex vis ıntegre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. İisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia prı, ın eam vero atomorum intellegebat.</p>\r\n'),
(8, 1, 'apartments', 1, '{\"country_id\":\"0\",\"region_id\":\"0\",\"city_id\":\"0\",\"metro\":\"\",\"parent_id\":\"\",\"type\":\"0\",\"obj_type_id\":\"5\",\"rooms\":\"0\",\"ot\":\"0\",\"square_min\":\"\",\"square_max\":\"\",\"floor_min\":\"\",\"floor_max\":\"\",\"garage_type\":\"\",\"open_plan\":\"\",\"room_type\":\"\",\"balcony_type\":\"\",\"wc_type\":\"\",\"floor_coat\":\"\",\"build_year\":\"\",\"repair\":\"\",\"object_state\":\"\",\"building_type\":\"\",\"plot_type\":\"\"}', '{\"apartmentsSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"summaryCitiesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"entriesSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"},\"contactformSubTitle\":{\"en\":\"\",\"ru\":\"\",\"de\":\"\",\"es\":\"\",\"ar\":\"\"}}', 0, 'Новостройки', 'New Buildings', 'NEUBAUTEN', '2020-03-16 12:15:44', '2020-03-16 11:53:40', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n\r\n<p>Pro sint saepe ut, sed alterum sensibus instructior cu. Eum at mazim accumsan, ne cum tota clita assueverit. Mea veri mazim in, ex signiferumque vituperatoribus pri. Sea ad exerci graeco suavitate, omnis argumentum ea est, usu te dicit contentiones necessitatibus. Eos imperdiet scripserit ex, tale tantas volutpat eu mei.</p>\r\n\r\n<p>Accusamus constituto cu vix, pro molestie patrioque ex, his et ferri melius. Veri docendi has ut, eu nec sumo atqui omittam, id vel consul invenire. Ius omnesque rationibus ut, tempor detracto at pro, te sed solet euripidis. Aeterno senserit periculis est te, velit scriptorem at vel. Nisl graeco has ut, nec cu probatus suavitate. Nec te hinc etiam. Ex vidit quando gloriatur vis, est ad labores corpora intellegat.</p>\r\n\r\n<p>Audiam gloriatur vituperata mel ex, an quot epicuri est. Velit praesent evertitur ne sea, ad vide minimum ius, equidem fabellas luptatum at sit. Ferri assum oporteat quo ne, vix decore corpora detracto at. Velit nusquam in qui. Eu eum tibique deserunt facilisis, ne vim denique aliquando.</p>\r\n\r\n<p>Cibo erat quaeque est id, etiam bonorum te sit. In vim saepe quodsi, nec novum alienum menandri te. Erat nominati molestiae usu an, eu vel civibus tincidunt, admodum suavitate at pri. Ut paulo possim deleniti per, ei has augue semper electram, eu assum menandri contentiones vix.</p>\r\n', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n\r\n<p>Pro sint saepe ut, sed alterum sensibus instructior cu. Eum at mazim accumsan, ne cum tota clita assueverit. Mea veri mazim in, ex signiferumque vituperatoribus pri. Sea ad exerci graeco suavitate, omnis argumentum ea est, usu te dicit contentiones necessitatibus. Eos imperdiet scripserit ex, tale tantas volutpat eu mei.</p>\r\n\r\n<p>Accusamus constituto cu vix, pro molestie patrioque ex, his et ferri melius. Veri docendi has ut, eu nec sumo atqui omittam, id vel consul invenire. Ius omnesque rationibus ut, tempor detracto at pro, te sed solet euripidis. Aeterno senserit periculis est te, velit scriptorem at vel. Nisl graeco has ut, nec cu probatus suavitate. Nec te hinc etiam. Ex vidit quando gloriatur vis, est ad labores corpora intellegat.</p>\r\n\r\n<p>Audiam gloriatur vituperata mel ex, an quot epicuri est. Velit praesent evertitur ne sea, ad vide minimum ius, equidem fabellas luptatum at sit. Ferri assum oporteat quo ne, vix decore corpora detracto at. Velit nusquam in qui. Eu eum tibique deserunt facilisis, ne vim denique aliquando.</p>\r\n\r\n<p>Cibo erat quaeque est id, etiam bonorum te sit. In vim saepe quodsi, nec novum alienum menandri te. Erat nominati molestiae usu an, eu vel civibus tincidunt, admodum suavitate at pri. Ut paulo possim deleniti per, ei has augue semper electram, eu assum menandri contentiones vix.</p>\r\n', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n\r\n<p>Pro sint saepe ut, sed alterum sensibus instructior cu. Eum at mazim accumsan, ne cum tota clita assueverit. Mea veri mazim in, ex signiferumque vituperatoribus pri. Sea ad exerci graeco suavitate, omnis argumentum ea est, usu te dicit contentiones necessitatibus. Eos imperdiet scripserit ex, tale tantas volutpat eu mei.</p>\r\n\r\n<p>Accusamus constituto cu vix, pro molestie patrioque ex, his et ferri melius. Veri docendi has ut, eu nec sumo atqui omittam, id vel consul invenire. Ius omnesque rationibus ut, tempor detracto at pro, te sed solet euripidis. Aeterno senserit periculis est te, velit scriptorem at vel. Nisl graeco has ut, nec cu probatus suavitate. Nec te hinc etiam. Ex vidit quando gloriatur vis, est ad labores corpora intellegat.</p>\r\n\r\n<p>Audiam gloriatur vituperata mel ex, an quot epicuri est. Velit praesent evertitur ne sea, ad vide minimum ius, equidem fabellas luptatum at sit. Ferri assum oporteat quo ne, vix decore corpora detracto at. Velit nusquam in qui. Eu eum tibique deserunt facilisis, ne vim denique aliquando.</p>\r\n\r\n<p>Cibo erat quaeque est id, etiam bonorum te sit. In vim saepe quodsi, nec novum alienum menandri te. Erat nominati molestiae usu an, eu vel civibus tincidunt, admodum suavitate at pri. Ut paulo possim deleniti per, ei has augue semper electram, eu assum menandri contentiones vix.</p>\r\n', 'Nuevos edificios', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n\r\n<p>Pro sint saepe ut, sed alterum sensibus instructior cu. Eum at mazim accumsan, ne cum tota clita assueverit. Mea veri mazim in, ex signiferumque vituperatoribus pri. Sea ad exerci graeco suavitate, omnis argumentum ea est, usu te dicit contentiones necessitatibus. Eos imperdiet scripserit ex, tale tantas volutpat eu mei.</p>\r\n\r\n<p>Accusamus constituto cu vix, pro molestie patrioque ex, his et ferri melius. Veri docendi has ut, eu nec sumo atqui omittam, id vel consul invenire. Ius omnesque rationibus ut, tempor detracto at pro, te sed solet euripidis. Aeterno senserit periculis est te, velit scriptorem at vel. Nisl graeco has ut, nec cu probatus suavitate. Nec te hinc etiam. Ex vidit quando gloriatur vis, est ad labores corpora intellegat.</p>\r\n\r\n<p>Audiam gloriatur vituperata mel ex, an quot epicuri est. Velit praesent evertitur ne sea, ad vide minimum ius, equidem fabellas luptatum at sit. Ferri assum oporteat quo ne, vix decore corpora detracto at. Velit nusquam in qui. Eu eum tibique deserunt facilisis, ne vim denique aliquando.</p>\r\n\r\n<p>Cibo erat quaeque est id, etiam bonorum te sit. In vim saepe quodsi, nec novum alienum menandri te. Erat nominati molestiae usu an, eu vel civibus tincidunt, admodum suavitate at pri. Ut paulo possim deleniti per, ei has augue semper electram, eu assum menandri contentiones vix.</p>\r\n', 'المباني الجديدة', '<p>Lorem ipsum dolor sit amet, ex vis integre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. Iisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia pri, in eam vero atomorum intellegebat.</p>\r\n\r\n<p>Pro sint saepe ut, sed alterum sensibus instructior cu. Eum at mazim accumsan, ne cum tota clita assueverit. Mea veri mazim in, ex signiferumque vituperatoribus pri. Sea ad exerci graeco suavitate, omnis argumentum ea est, usu te dicit contentiones necessitatibus. Eos imperdiet scripserit ex, tale tantas volutpat eu mei.</p>\r\n\r\n<p>Accusamus constituto cu vix, pro molestie patrioque ex, his et ferri melius. Veri docendi has ut, eu nec sumo atqui omittam, id vel consul invenire. Ius omnesque rationibus ut, tempor detracto at pro, te sed solet euripidis. Aeterno senserit periculis est te, velit scriptorem at vel. Nisl graeco has ut, nec cu probatus suavitate. Nec te hinc etiam. Ex vidit quando gloriatur vis, est ad labores corpora intellegat.</p>\r\n\r\n<p>Audiam gloriatur vituperata mel ex, an quot epicuri est. Velit praesent evertitur ne sea, ad vide minimum ius, equidem fabellas luptatum at sit. Ferri assum oporteat quo ne, vix decore corpora detracto at. Velit nusquam in qui. Eu eum tibique deserunt facilisis, ne vim denique aliquando.</p>\r\n\r\n<p>Cibo erat quaeque est id, etiam bonorum te sit. In vim saepe quodsi, nec novum alienum menandri te. Erat nominati molestiae usu an, eu vel civibus tincidunt, admodum suavitate at pri. Ut paulo possim deleniti per, ei has augue semper electram, eu assum menandri contentiones vix.</p>\r\n', 'Yeni binalar', '<p>Lorem ipsum dolor sit amet, ex vis ıntegre conceptam, vivendum adolescens cum eu, ex tota accusamus has. Perpetua disputando in quo, sea choro voluptaria honestatis no, homero scriptorem sit no. İisque appellantur at mea, modus regione vel ex. Ut copiosae pertinacia prı, ın eam vero atomorum intellegebat.</p>\r\n\r\n<p>Pro sint saepe ut, sed apartment alterum sensibus instructior cu. Eum at mazim accumsan, ne cum tota clita assueverit. Mea veri mazim in, ex signiferumque vituperatoribus pri. Sea ad exerci graeco suavitate, omnis argumentum ea est, usu te dicit contentiones necessitatibus. Eos imperdiet scripserit ex, tale tantas volutpat eu mei.</p>\r\n\r\n<p>Accusamus constituto cu vıx, pro molestie patrioque ex, his et ferri melius. Veri docendi has ut, eu nec sumo atqui omittam, id vel consul invenire. Ius omnesque rationibus ut, tempor detracto at pro, te sed solet euripidis. Aeterno senserit periculis est te, velit scriptorem at vel. Nisl graeco has ut, nec cu probatus suavitate. Nec te hinc etiam. Ex vidit quando gloriatur vis est ad labores corpora intellegat.</p>\r\n\r\n<p>Audiam gloriatur vituperata mel ex, an quot epicuri est. Velit praesent evertitur ne sea, ad vide minimum ıus, equidem fabellas luptatum at sit. Ferri assum oporteat quo ne, vıx decore corpora detracto at. Velit nusquam in qui. Eu-eum tibique deserunt facilisis, ne vım denique aliquando.</p>\r\n\r\n<p>Cibo erat quaeque id est, etiam bonorum te sit. In vım saepe quodsi, nec novum alienum menandri te. Erat nominati molestiae usu an, eu vel civibus tincidunt, admodum suavitate at pri. Ut paulo possim deleniti per, eı has augue semper electram, eu assum menandri contentiones vıx.</p>\r\n');


DROP TABLE IF EXISTS `{dbPrefix}lang`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}lang` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `isRTL` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `currency_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `main` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `name_iso` varchar(20) NOT NULL DEFAULT '',
  `name_rfc3066` varchar(10) NOT NULL DEFAULT '',
  `name_ru` varchar(100) NOT NULL DEFAULT '',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `sorter` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name_en` varchar(100) NOT NULL DEFAULT '',
  `admin_mail` tinyint(4) UNSIGNED NOT NULL DEFAULT '0',
  `flag_img` varchar(50) NOT NULL DEFAULT '',
  `name_de` varchar(100) NOT NULL DEFAULT '',
  `price_tpl_default` varchar(255) NOT NULL DEFAULT '',
  `price_tpl_from` varchar(255) NOT NULL DEFAULT '',
  `price_tpl_to` varchar(255) NOT NULL DEFAULT '',
  `dateFormat` varchar(30) NOT NULL DEFAULT 'd.m.Y H:i:s',
  `priceDecimalsPoint` varchar(1) NOT NULL DEFAULT ',',
  `priceThousandsSeparator` varchar(1) NOT NULL DEFAULT '',
  `name_es` varchar(100) NOT NULL DEFAULT '',
  `name_ar` varchar(100) NOT NULL DEFAULT '',
  `name_tr` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `active` (`active`),
  KEY `currency_id` (`currency_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}lang` (`id`, `isRTL`, `currency_id`, `main`, `name_iso`, `name_rfc3066`, `name_ru`, `active`, `sorter`, `date_updated`, `name_en`, `admin_mail`, `flag_img`, `name_de`, `price_tpl_default`, `price_tpl_from`, `price_tpl_to`, `dateFormat`, `priceDecimalsPoint`, `priceThousandsSeparator`, `name_es`, `name_ar`, `name_tr`) VALUES
(1, 0, 1, 0, 'ru', 'ru-RU', 'Русский', 1, 2, '2019-03-16 06:59:49', 'Русский', 0, 'ru.png', 'Русский', '<span>{PRICE}</span> <span class=\"currency\">{CURRENCY}</span> {TYPE}', '{TEXT_FROM} {PRICE} <span class=\"currency\">{CURRENCY}</span>', ' {TEXT_TO} {PRICE} <span class=\"currency\">{CURRENCY}</span>', 'Y-m-d H:i', ',', ' ', 'Русский', 'Русский', 'Русский'),
(2, 0, 11, 1, 'en', 'en-US', 'English', 1, 1, '2019-03-16 06:59:49', 'English', 1, 'us.png', 'English', '<span class=\"currency\">{CURRENCY}</span> <span>{PRICE}</span> {TYPE}', '<span>{TEXT_FROM}</span> <span class=\"currency\">{CURRENCY}</span> <span>{PRICE}</span> ', ' <span>{TEXT_TO}</span> <span class=\"currency\">{CURRENCY}</span> <span>{PRICE}</span> ', 'm d Y, H:i', ',', ' ', 'English', 'English', 'English'),
(3, 0, 12, 0, 'de', 'de-DE', 'Deutsch', 1, 3, '2019-03-16 06:59:49', 'Deutsch', 0, 'de.png', 'Deutsch', '<span>{PRICE}</span> <span class=\"currency\">{CURRENCY}</span> {TYPE}', '{TEXT_FROM} {PRICE} <span class=\"currency\">{CURRENCY}</span>', ' {TEXT_TO} {PRICE} <span class=\"currency\">{CURRENCY}</span>', 'd.m.Y, H:i', ',', ' ', 'Deutsch', 'Deutsch', 'Deutsch'),
(5, 0, 12, 0, 'es', 'en-US', 'Español', 1, 4, '2019-03-16 06:59:49', 'Español', 0, 'es.png', 'Español', '<span>{PRICE}</span> <span class=\"currency\">{CURRENCY}</span> {TYPE}', '{TEXT_FROM} {PRICE} <span class=\"currency\">{CURRENCY}</span>', ' {TEXT_TO} {PRICE} <span class=\"currency\">{CURRENCY}</span>', 'd/m/Y H:i', ',', ' ', 'Español', 'Español', 'Español'),
(6, 1, 37, 0, 'ar', 'en-US', 'العربية', 1, 5, '2019-03-16 06:59:49', 'العربية', 0, 'sa.png', 'العربية', '<span class=\"currency\">{CURRENCY}</span> <span>{PRICE}</span> {TYPE}', '<span>{TEXT_FROM}</span> <span class=\"currency\">{CURRENCY}</span> <span>{PRICE}</span> ', ' <span>{TEXT_TO}</span> <span class=\"currency\">{CURRENCY}</span> <span>{PRICE}</span> ', 'd/m/Y H:i', '.', ',', 'العربية', 'العربية', 'العربية'),
(7, 0, 27, 0, 'tr', 'tr-TR', 'Türkçe', 1, 6, '2019-03-16 06:59:49', 'Türkçe', 0, 'tr.png', 'Türkçe', '<span>{PRICE}</span> <span class=\"currency\">{CURRENCY}</span> {TYPE}', '{TEXT_FROM} {PRICE} <span class=\"currency\">{CURRENCY}</span>', ' {TEXT_TO} {PRICE} <span class=\"currency\">{CURRENCY}</span>', 'd/m/Y, H:i', ',', '', 'Türkçe', 'Türkçe', 'Türkçe');


DROP TABLE IF EXISTS `{dbPrefix}lang_widget_opt`;
CREATE TABLE `{dbPrefix}lang_widget_opt` (
  `id` int(11)  UNSIGNED NOT NULL AUTO_INCREMENT,
  `model_name` char(100) NOT NULL DEFAULT '',
  `model_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `model_id` (`model_id`),
  KEY `model_name` (`model_name`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;


DROP TABLE IF EXISTS `{dbPrefix}location_city`;
CREATE TABLE IF NOT EXISTS `{dbPrefix}location_city` (
  `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `country_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `region_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name_ru` varchar(100) NOT NULL DEFAULT '',
  `name_en` varchar(100) NOT NULL DEFAULT '',
  `name_de` varchar(100) NOT NULL DEFAULT '',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `sorter` mediumint(8) NOT NULL DEFAULT '0',
  `date_updated` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name_es` varchar(100) NOT NULL DEFAULT '',
  `name_ar` varchar(100) NOT NULL DEFAULT '',
  `name_tr` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB ROW_FORMAT=DYNAMIC DEFAULT CHARSET=utf8 DEFAULT COLLATE utf8_general_ci;

INSERT INTO `{dbPrefix}location_city` (`id`, `country_id`, `region_id`, `name_ru`, `name_en`, `name_de`, `active`, `sorter`, `date_updated`, `name_es`, `name_ar`, `name_tr`) VALUES
(101628,	187,	101627,	'Табук',	'Tabuk',	'Tabuk',	1,	48398,	'2019-03-16 03:59:51',	'Tabuk',	'Tabuk',	'Tabuk'),
(102318,	187,	108241,	'Sayhat',	'Sayhat',	'Sayhat',	1,	44942,	'2019-03-16 03:59:51',	'Sayhat',	'Sayhat',	'Sayhat'),
(102585,	187,	108241,	'Safwa',	'Safwa',	'Safwa',	1,	42224,	'2019-03-16 03:59:51',	'Safwa',	'Safwa',	'Safwa'),
(102891,	187,	108241,	'Ras Tanura',	'Ras Tanura',	'Ras Tanura',	1,	40055,	'2019-03-16 03:59:51',	'Ras Tanura',	'Ras Tanura',	'Ras Tanura'),
(102912,	187,	108241,	'Ra\'s al Khafji',	'Ra\'s al Khafji',	'Ra\'s al Khafji',	1,	39811,	'2019-03-16 03:59:51',	'Ra\'s al Khafji',	'Ra\'s al Khafji',	'Ra\'s al Khafji'),
(103035,	187,	104514,	'Rabigh',	'Rabigh',	'Rabigh',	1,	39817,	'2019-03-16 03:59:51',	'Rabigh',	'Rabigh',	'Rabigh'),
(103915,	187,	104514,	'Mina',	'Mina',	'Mina',	1,	31525,	'2019-03-16 03:59:51',	'Mina',	'Mina',	'Mina'),
(104515,	187,	104514,	'Мекка',	'Mecca',	'Mecca',	1,	30553,	'2019-03-16 03:59:51',	'Mecca',	'Mecca',	'Mecca'),
(104699,	187,	109579,	'Linah',	'Linah',	'Linah',	1,	27790,	'2019-03-16 03:59:51',	'Linah',	'Linah',	'Linah'),
(105072,	187,	108179,	'Хамис-Мушаит',	'Khamis Mushait',	'Khamis Mushait',	1,	24226,	'2019-03-16 03:59:51',	'Khamis Mushait',	'Khamis Mushait',	'Khamis Mushait'),
(105299,	187,	105298,	'Джизан',	'Jizan',	'Jizan',	1,	23527,	'2019-03-16 03:59:51',	'Jizan',	'Jizan',	'Jizan'),
(105343,	187,	104514,	'Джидда',	'Jeddah',	'Jeddah',	1,	23409,	'2019-03-16 03:59:51',	'Jeddah',	'Jeddah',	'Jeddah'),
(105358,	187,	108179,	'Jazirah',	'Jazirah',	'Jazirah',	1,	23403,	'2019-03-16 03:59:51',	'Jazirah',	'Jazirah',	'Jazirah'),
(107304,	187,	108933,	'Buraydah',	'Buraydah',	'Buraydah',	1,	7342,	'2019-03-16 03:59:51',	'Buraydah',	'Buraydah',	'Buraydah'),
(107312,	187,	108241,	'Abqaiq',	'Abqaiq',	'Abqaiq',	1,	101,	'2019-03-16 03:59:51',	'Abqaiq',	'Abqaiq',	'Abqaiq'),
(107744,	187,	109224,	'Badr Hunayn',	'Badr Hunayn',	'Badr Hunayn',	1,	3035,	'2019-03-16 03:59:51',	'Badr Hunayn',	'Badr Hunayn',	'Badr Hunayn'),
(107797,	187,	108241,	'Дахран',	'Dhahran',	'Dhahran',	1,	13365,	'2019-03-16 03:59:51',	'Dhahran',	'Dhahran',	'Dhahran'),
(107968,	187,	104514,	'Ta\'if',	'Ta\'if',	'Ta\'if',	1,	48386,	'2019-03-16 03:59:51',	'Ta\'if',	'Ta\'if',	'Ta\'if'),
(108410,	187,	108411,	'Эр-Рияд',	'Riyadh',	'Riyadh',	1,	41082,	'2019-03-16 03:59:51',	'Riyadh',	'Riyadh',	'Riyadh'),
(108738,	187,	108411,	'Al Yamamah',	'Al Yamamah',	'Al Yamamah',	1,	481,	'2019-03-16 03:59:51',	'Al Yamamah',	'Al Yamamah',	'Al Yamamah'),
(108927,	187,	108241,	'Эль-Катиф',	'Al Qatif',	'Al Qatif',	1,	480,	'2019-03-16 03:59:51',	'Al Qatif',	'Al Qatif',	'Al Qatif'),
(109223,	187,	109224,	'Медина',	'Medina',	'Medina',	1,	30607,	'2019-03-16 03:59:51',	'Medina',	'Medina',	'Medina'),
(109323,	187,	108241,	'Khobar',	'Khobar',	'Khobar',	1,	24245,	'2019-03-16 03:59:51',	'Khobar',	'Khobar',	'Khobar'),
(109435,	187,	108241,	'Аль-Джубайль',	'Al Jubayl',	'Al Jubayl',	1,	479,	'2019-03-16 03:59:51',	'Al Jubayl',	'Al Jubayl',	'Al Jubayl'),
(109571,	187,	108241,	'Al Hufuf',	'Al Hufuf',	'Al Hufuf',	1,	478,	'2019-03-16 03:59:51',	'Al Hufuf',	'Al Hufuf',	'Al Hufuf'),
(110336,	187,	108241,	'Даммам',	'Dammam',	'Dammam',	1,	12757,	'2019-03-16 03:59:51',	'Dammam',	'Dammam',	'Dammam'),
(110690,	187,	108179,	'Абха',	'Abha',	'Abha',	1,	78,	'2019-03-16 03:59:51',	'Abha',	'Abha',	'Abha'),
(290594,	4,	290595,	'Умм-эль-Кайвайн',	'Umm al Qaywayn',	'Umm al Qaywayn',	1,	50331,	'2019-03-16 03:59:51',	'Umm al Qaywayn',	'Umm al Qaywayn',	'Umm al Qaywayn'),
(291074,	4,	291075,	'Рас-эль-Хайма',	'Ras al-Khaimah',	'Ras al-Khaimah',	1,	40054,	'2019-03-16 03:59:51',	'Ras al-Khaimah',	'Ras al-Khaimah',	'Ras al-Khaimah'),
(291696,	4,	292673,	'Хор-Факкан',	'Khawr Fakkan',	'Khawr Fakkan',	1,	24237,	'2019-03-16 03:59:51',	'Khawr Fakkan',	'Khawr Fakkan',	'Khawr Fakkan'),
(292223,	4,	292224,	'Дубай',	'Dubai',	'Dubai',	1,	14060,	'2019-03-16 03:59:51',	'Dubai',	'Dubai',	'Dubai'),
(292261,	4,	292224,	'Dayrah',	'Dayrah',	'Dayrah',	1,	12950,	'2019-03-16 03:59:51',	'Dayrah',	'Dayrah',	'Dayrah'),
(292672,	4,	292673,	'Шарджа',	'Sharjah',	'Sharjah',	1,	45966,	'2019-03-16 03:59:51',	'Sharjah',	'Sharjah',	'Sharjah'),
(292878,	4,	292879,	'Фуджейра',	'Al Fujayrah',	'Al Fujayrah',	1,	477,	'2019-03-16 03:59:51',	'Al Fujayrah',	'Al Fujayrah',	'Al Fujayrah'),
(292913,	4,	292969,	'Аль-Айн',	'Al Ain',	'Al Ain',	1,	475,	'2019-03-16 03:59:51',	'Al Ain',	'Al Ain',	'Al Ain'),
(292968,	4,	292969,	'Абу-Даби',	'Abu Dhabi',	'Abu Dhabi',	1,	113,	'2019-03-16 03:59:51',	'Abu Dhabi',	'Abu Dhabi',	'Abu Dhabi'),
(295801,	217,	298332,	'Yildiz',	'Yildiz',	'Yildiz',	1,	54937,	'2019-03-16 03:59:51',	'Yildiz',	'Yildiz',	'Yildiz'),
(296562,	217,	296560,	'Yozgat',	'Yozgat',	'Yozgat',	1,	54978,	'2019-03-16 03:59:51',	'Yozgat',	'Yozgat',	'Yozgat'),
(297208,	217,	317106,	'Yeni',	'Yeni',	'Yeni',	1,	54920,	'2019-03-16 03:59:51',	'Yeni',	'Yeni',	'Yeni'),
(297284,	217,	312394,	'Yeditepe',	'Yeditepe',	'Yeditepe',	1,	54901,	'2019-03-16 03:59:51',	'Yeditepe',	'Yeditepe',	'Yeditepe'),
(297615,	217,	304794,	'Yasarkoy',	'Yasarkoy',	'Yasarkoy',	1,	54885,	'2019-03-16 03:59:51',	'Yasarkoy',	'Yasarkoy',	'Yasarkoy'),
(297906,	217,	311044,	'Yakakoy',	'Yakakoy',	'Yakakoy',	1,	54856,	'2019-03-16 03:59:51',	'Yakakoy',	'Yakakoy',	'Yakakoy'),
(298117,	217,	298113,	'Ван',	'Van',	'Van',	1,	50859,	'2019-03-16 03:59:51',	'Van',	'Van',	'Van'),
(298299,	217,	298298,	'Ушак',	'Usak',	'Usak',	1,	50548,	'2019-03-16 03:59:51',	'Usak',	'Usak',	'Usak'),
(298316,	217,	311044,	'Урла',	'Urla',	'Urla',	1,	50527,	'2019-03-16 03:59:51',	'Urla',	'Urla',	'Urla'),
(298333,	217,	298332,	'Эдесса',	'Sanliurfa',	'Sanliurfa',	1,	44412,	'2019-03-16 03:59:51',	'Sanliurfa',	'Sanliurfa',	'Sanliurfa'),
(298507,	217,	443189,	'Ugur',	'Ugur',	'Ugur',	1,	50286,	'2019-03-16 03:59:51',	'Ugur',	'Ugur',	'Ugur'),
(298806,	217,	304825,	'Turgutlu',	'Turgutlu',	'Turgutlu',	1,	50128,	'2019-03-16 03:59:51',	'Turgutlu',	'Turgutlu',	'Turgutlu'),
(298817,	217,	304794,	'Turgut',	'Turgut',	'Turgut',	1,	50127,	'2019-03-16 03:59:51',	'Turgut',	'Turgut',	'Turgut'),
(298846,	217,	298845,	'Тунджели',	'Tunceli',	'Tunceli',	1,	50108,	'2019-03-16 03:59:51',	'Tunceli',	'Tunceli',	'Tunceli'),
(299582,	217,	321022,	'Татван',	'Tatvan',	'Tatvan',	1,	48613,	'2019-03-16 03:59:51',	'Tatvan',	'Tatvan',	'Tatvan'),
(299786,	217,	443189,	'Tasdelen',	'Tasdelen',	'Tasdelen',	1,	48601,	'2019-03-16 03:59:51',	'Tasdelen',	'Tasdelen',	'Tasdelen'),
(299817,	217,	311728,	'Тарсус',	'Tarsus',	'Tarsus',	1,	48593,	'2019-03-16 03:59:51',	'Tarsus',	'Tarsus',	'Tarsus'),
(300182,	217,	303826,	'Sultanpinar',	'Sultanpinar',	'Sultanpinar',	1,	48082,	'2019-03-16 03:59:51',	'Sultanpinar',	'Sultanpinar',	'Sultanpinar'),
(300195,	217,	322819,	'Sultanhisar',	'Sultanhisar',	'Sultanhisar',	1,	48081,	'2019-03-16 03:59:51',	'Sultanhisar',	'Sultanhisar',	'Sultanhisar'),
(300371,	217,	304825,	'Сомы',	'Soma',	'Soma',	1,	46720,	'2019-03-16 03:59:51',	'Soma',	'Soma',	'Soma'),
(300399,	217,	322819,	'Сок',	'Soeke',	'Soeke',	1,	46623,	'2019-03-16 03:59:51',	'Soeke',	'Soeke',	'Soeke'),
(300619,	217,	300617,	'Сивас',	'Sivas',	'Sivas',	1,	46451,	'2019-03-16 03:59:51',	'Sivas',	'Sivas',	'Sivas'),
(300624,	217,	304919,	'Sisman',	'Sisman',	'Sisman',	1,	46434,	'2019-03-16 03:59:51',	'Sisman',	'Sisman',	'Sisman'),
(300640,	217,	443189,	'Ширнак',	'Sirnak',	'Sirnak',	1,	46427,	'2019-03-16 03:59:51',	'Sirnak',	'Sirnak',	'Sirnak'),
(300748,	217,	323784,	'Sincan',	'Sincan',	'Sincan',	1,	46390,	'2019-03-16 03:59:51',	'Sincan',	'Sincan',	'Sincan'),
(300767,	217,	316540,	'Sinankoy',	'Sinankoy',	'Sinankoy',	1,	46388,	'2019-03-16 03:59:51',	'Sinankoy',	'Sinankoy',	'Sinankoy'),
(300797,	217,	443189,	'Силопи',	'Silopi',	'Silopi',	1,	46313,	'2019-03-16 03:59:51',	'Silopi',	'Silopi',	'Silopi'),
(300808,	217,	311728,	'Силифке',	'Silifke',	'Silifke',	1,	46297,	'2019-03-16 03:59:51',	'Silifke',	'Silifke',	'Silifke'),
(300822,	217,	300821,	'Сиирт',	'Siirt',	'Siirt',	1,	46283,	'2019-03-16 03:59:51',	'Siirt',	'Siirt',	'Siirt'),
(300997,	217,	325361,	'Сейхан',	'Seyhan',	'Seyhan',	1,	45900,	'2019-03-16 03:59:51',	'Seyhan',	'Seyhan',	'Seyhan'),
(301010,	217,	306569,	'Seydisehir',	'Seydisehir',	'Seydisehir',	1,	45899,	'2019-03-16 03:59:51',	'Seydisehir',	'Seydisehir',	'Seydisehir'),
(301101,	217,	323776,	'Серик',	'Serik',	'Serik',	1,	45768,	'2019-03-16 03:59:51',	'Serik',	'Serik',	'Serik'),
(301256,	217,	311044,	'Сельчук',	'Selcuk',	'Selcuk',	1,	45603,	'2019-03-16 03:59:51',	'Selcuk',	'Selcuk',	'Selcuk'),
(301453,	217,	322164,	'Savastepe',	'Savastepe',	'Savastepe',	1,	44876,	'2019-03-16 03:59:51',	'Savastepe',	'Savastepe',	'Savastepe'),
(301975,	217,	312394,	'Samandagi',	'Samandagi',	'Samandagi',	1,	43905,	'2019-03-16 03:59:51',	'Samandagi',	'Samandagi',	'Samandagi'),
(302043,	217,	304825,	'Salihli',	'Salihli',	'Salihli',	1,	43792,	'2019-03-16 03:59:51',	'Salihli',	'Salihli',	'Salihli'),
(302317,	217,	298332,	'Sabanci',	'Sabanci',	'Sabanci',	1,	42159,	'2019-03-16 03:59:51',	'Sabanci',	'Sabanci',	'Sabanci'),
(302903,	217,	317106,	'Памуккале',	'Pamukkale',	'Pamukkale',	1,	36800,	'2019-03-16 03:59:51',	'Pamukkale',	'Pamukkale',	'Pamukkale'),
(303195,	217,	443183,	'Османие',	'Osmaniye',	'Osmaniye',	1,	36257,	'2019-03-16 03:59:51',	'Osmaniye',	'Osmaniye',	'Osmaniye'),
(303827,	217,	303826,	'Нигде',	'Nigde',	'Nigde',	1,	34623,	'2019-03-16 03:59:51',	'Nigde',	'Nigde',	'Nigde'),
(303831,	217,	303830,	'Невшехир',	'Nevsehir',	'Nevsehir',	1,	34093,	'2019-03-16 03:59:51',	'Nevsehir',	'Nevsehir',	'Nevsehir'),
(303873,	217,	322819,	'Nazilli',	'Nazilli',	'Nazilli',	1,	33695,	'2019-03-16 03:59:51',	'Nazilli',	'Nazilli',	'Nazilli'),
(304081,	217,	304041,	'Муш',	'Mus',	'Mus',	1,	33393,	'2019-03-16 03:59:51',	'Mus',	'Mus',	'Mus'),
(304184,	217,	304183,	'Мугла',	'Mugla',	'Mugla',	1,	33222,	'2019-03-16 03:59:51',	'Mugla',	'Mugla',	'Mugla'),
(304355,	217,	304183,	'Милас',	'Milas',	'Milas',	1,	31344,	'2019-03-16 03:59:51',	'Milas',	'Milas',	'Milas'),
(304418,	217,	311728,	'Mezitli',	'Mezitli',	'Mezitli',	1,	31167,	'2019-03-16 03:59:51',	'Mezitli',	'Mezitli',	'Mezitli'),
(304531,	217,	311728,	'Мерсин',	'Mercin',	'Mercin',	1,	30895,	'2019-03-16 03:59:51',	'Mercin',	'Mercin',	'Mercin'),
(304612,	217,	311044,	'Менемен',	'Menemen',	'Menemen',	1,	30811,	'2019-03-16 03:59:51',	'Menemen',	'Menemen',	'Menemen'),
(304642,	217,	308463,	'Melikgazi',	'Melikgazi',	'Melikgazi',	1,	30720,	'2019-03-16 03:59:51',	'Melikgazi',	'Melikgazi',	'Melikgazi'),
(304782,	217,	304183,	'Мармарис',	'Marmaris',	'Marmaris',	1,	29955,	'2019-03-16 03:59:51',	'Marmaris',	'Marmaris',	'Marmaris'),
(304797,	217,	304794,	'Мардин',	'Mardin',	'Mardin',	1,	29708,	'2019-03-16 03:59:51',	'Mardin',	'Mardin',	'Mardin'),
(304827,	217,	304825,	'Маниса',	'Manisa',	'Manisa',	1,	29477,	'2019-03-16 03:59:51',	'Manisa',	'Manisa',	'Manisa'),
(304854,	217,	323776,	'Манавгат',	'Manavgat',	'Manavgat',	1,	29408,	'2019-03-16 03:59:51',	'Manavgat',	'Manavgat',	'Manavgat'),
(304922,	217,	304919,	'Малатья',	'Malatya',	'Malatya',	1,	29291,	'2019-03-16 03:59:51',	'Malatya',	'Malatya',	'Malatya'),
(305268,	217,	305267,	'Кютахья',	'Kutahya',	'Kutahya',	1,	25053,	'2019-03-16 03:59:51',	'Kutahya',	'Kutahya',	'Kutahya'),
(305359,	217,	322819,	'Кушадасы',	'Kusadasi',	'Kusadasi',	1,	25049,	'2019-03-16 03:59:51',	'Kusadasi',	'Kusadasi',	'Kusadasi'),
(305969,	217,	311044,	'Cigli',	'Cigli',	'Cigli',	1,	10513,	'2019-03-16 03:59:51',	'Cigli',	'Cigli',	'Cigli'),
(306112,	217,	325361,	'Kozan',	'Kozan',	'Kozan',	1,	24864,	'2019-03-16 03:59:51',	'Kozan',	'Kozan',	'Kozan'),
(306571,	217,	306569,	'Конья',	'Konya',	'Konya',	1,	24789,	'2019-03-16 03:59:51',	'Konya',	'Konya',	'Konya'),
(306641,	217,	311044,	'Konak',	'Konak',	'Konak',	1,	24752,	'2019-03-16 03:59:51',	'Konak',	'Konak',	'Konak'),
(307480,	217,	322819,	'Kisir',	'Kisir',	'Kisir',	1,	24550,	'2019-03-16 03:59:51',	'Kisir',	'Kisir',	'Kisir'),
(307515,	217,	307513,	'Кыршехир',	'Kirsehir',	'Kirsehir',	1,	24541,	'2019-03-16 03:59:51',	'Kirsehir',	'Kirsehir',	'Kirsehir'),
(307654,	217,	443188,	'Кырыккале',	'Kirikkale',	'Kirikkale',	1,	24496,	'2019-03-16 03:59:51',	'Kirikkale',	'Kirikkale',	'Kirikkale'),
(307864,	217,	443213,	'Килис',	'Kilis',	'Kilis',	1,	24285,	'2019-03-16 03:59:51',	'Kilis',	'Kilis',	'Kilis'),
(307966,	217,	323784,	'Kibriskoy',	'Kibriskoy',	'Kibriskoy',	1,	24256,	'2019-03-16 03:59:51',	'Kibriskoy',	'Kibriskoy',	'Kibriskoy'),
(308335,	217,	323784,	'Kecioeren',	'Kecioeren',	'Kecioeren',	1,	23988,	'2019-03-16 03:59:51',	'Kecioeren',	'Kecioeren',	'Kecioeren'),
(308464,	217,	308463,	'Кайсери',	'Kayseri',	'Kayseri',	1,	23970,	'2019-03-16 03:59:51',	'Kayseri',	'Kayseri',	'Kayseri'),
(309527,	217,	443187,	'Караман',	'Karaman',	'Karaman',	1,	23875,	'2019-03-16 03:59:51',	'Karaman',	'Karaman',	'Karaman'),
(309647,	217,	325163,	'Agri',	'Agri',	'Agri',	1,	319,	'2019-03-16 03:59:51',	'Agri',	'Agri',	'Agri'),
(310399,	217,	298332,	'Karakëy',	'Karakoy',	'Karakoy',	1,	23874,	'2019-03-16 03:59:51',	'Karakoy',	'Karakoy',	'Karakoy'),
(310859,	217,	310858,	'Кахраманмараш',	'Kahramanmaras',	'Kahramanmaras',	1,	23738,	'2019-03-16 03:59:51',	'Kahramanmaras',	'Kahramanmaras',	'Kahramanmaras'),
(310892,	217,	325361,	'Kadirli',	'Kadirli',	'Kadirli',	1,	23729,	'2019-03-16 03:59:51',	'Kadirli',	'Kadirli',	'Kadirli'),
(310900,	217,	443186,	'Kadir',	'Kadir',	'Kadir',	1,	23728,	'2019-03-16 03:59:51',	'Kadir',	'Kadir',	'Kadir'),
(311046,	217,	311044,	'Измир',	'Izmir',	'Izmir',	1,	23223,	'2019-03-16 03:59:51',	'Izmir',	'Izmir',	'Izmir'),
(311073,	217,	311071,	'Испарта',	'Isparta',	'Isparta',	1,	23136,	'2019-03-16 03:59:51',	'Isparta',	'Isparta',	'Isparta'),
(311104,	217,	314829,	'Islahiye',	'Islahiye',	'Islahiye',	1,	23087,	'2019-03-16 03:59:51',	'Islahiye',	'Islahiye',	'Islahiye'),
(311111,	217,	312394,	'Искендерун',	'Iskenderun',	'Iskenderun',	1,	23082,	'2019-03-16 03:59:51',	'Iskenderun',	'Iskenderun',	'Iskenderun'),
(311665,	217,	443184,	'Игдир',	'Igdir',	'Igdir',	1,	22738,	'2019-03-16 03:59:51',	'Igdir',	'Igdir',	'Igdir'),
(312001,	217,	306569,	'Selcuklu',	'Selcuklu',	'Selcuklu',	1,	45604,	'2019-03-16 03:59:51',	'Selcuklu',	'Selcuklu',	'Selcuklu'),
(312322,	217,	316540,	'Atakoy',	'Atakoy',	'Atakoy',	1,	2301,	'2019-03-16 03:59:51',	'Atakoy',	'Atakoy',	'Atakoy'),
(312531,	217,	298332,	'Harran',	'Harran',	'Harran',	1,	20733,	'2019-03-16 03:59:51',	'Harran',	'Harran',	'Harran'),
(313549,	217,	325163,	'Gunbuldu',	'Gunbuldu',	'Gunbuldu',	1,	20183,	'2019-03-16 03:59:51',	'Gunbuldu',	'Gunbuldu',	'Gunbuldu'),
(314038,	217,	304825,	'Golmarmara',	'Golmarmara',	'Golmarmara',	1,	19021,	'2019-03-16 03:59:51',	'Golmarmara',	'Golmarmara',	'Golmarmara'),
(314566,	217,	298332,	'Guzelyurt',	'Guzelyurt',	'Guzelyurt',	1,	20262,	'2019-03-16 03:59:51',	'Guzelyurt',	'Guzelyurt',	'Guzelyurt'),
(314716,	217,	305267,	'Гедиз',	'Gediz',	'Gediz',	1,	18260,	'2019-03-16 03:59:51',	'Gediz',	'Gediz',	'Gediz'),
(314830,	217,	314829,	'Газиантеп',	'Gaziantep',	'Gaziantep',	1,	18243,	'2019-03-16 03:59:51',	'Gaziantep',	'Gaziantep',	'Gaziantep'),
(314967,	217,	304183,	'Фетхие',	'Fethiye',	'Fethiye',	1,	16558,	'2019-03-16 03:59:51',	'Fethiye',	'Fethiye',	'Fethiye'),
(315107,	217,	304041,	'Yagcilar',	'Yagcilar',	'Yagcilar',	1,	54852,	'2019-03-16 03:59:51',	'Yagcilar',	'Yagcilar',	'Yagcilar'),
(315202,	217,	315201,	'Эскишехир',	'Eskisehir',	'Eskisehir',	1,	15691,	'2019-03-16 03:59:51',	'Eskisehir',	'Eskisehir',	'Eskisehir'),
(315302,	217,	298332,	'Eser',	'Eser',	'Eser',	1,	15686,	'2019-03-16 03:59:51',	'Eser',	'Eser',	'Eser'),
(315368,	217,	315367,	'Эрзурум',	'Erzurum',	'Erzurum',	1,	15632,	'2019-03-16 03:59:51',	'Erzurum',	'Erzurum',	'Erzurum'),
(315373,	217,	315372,	'Эрзинджан',	'Erzincan',	'Erzincan',	1,	15631,	'2019-03-16 03:59:51',	'Erzincan',	'Erzincan',	'Erzincan'),
(315468,	217,	316540,	'Эграни',	'Ergani',	'Ergani',	1,	15548,	'2019-03-16 03:59:51',	'Ergani',	'Ergani',	'Ergani'),
(315515,	217,	311728,	'Erdemli',	'Erdemli',	'Erdemli',	1,	15533,	'2019-03-16 03:59:51',	'Erdemli',	'Erdemli',	'Erdemli'),
(315529,	217,	308463,	'Erciyes',	'Erciyes',	'Erciyes',	1,	15527,	'2019-03-16 03:59:51',	'Erciyes',	'Erciyes',	'Erciyes'),
(315769,	217,	304825,	'Elek',	'Elek',	'Elek',	1,	15005,	'2019-03-16 03:59:51',	'Elek',	'Elek',	'Elek'),
(315808,	217,	315807,	'Элязыг',	'Elazig',	'Elazig',	1,	14969,	'2019-03-16 03:59:51',	'Elazig',	'Elazig',	'Elazig'),
(315985,	217,	322164,	'Эдремит',	'Edremit',	'Edremit',	1,	14744,	'2019-03-16 03:59:51',	'Edremit',	'Edremit',	'Edremit'),
(315991,	217,	298332,	'Edebey',	'Edebey',	'Edebey',	1,	14659,	'2019-03-16 03:59:51',	'Edebey',	'Edebey',	'Edebey'),
(316271,	217,	308463,	'Doruklu',	'Doruklu',	'Doruklu',	1,	13831,	'2019-03-16 03:59:51',	'Doruklu',	'Doruklu',	'Doruklu'),
(316275,	217,	316540,	'Arpatepekëy',	'Doruk',	'Doruk',	1,	13830,	'2019-03-16 03:59:51',	'Doruk',	'Doruk',	'Doruk'),
(316284,	217,	312394,	'Dortyol',	'Dortyol',	'Dortyol',	1,	13829,	'2019-03-16 03:59:51',	'Dortyol',	'Dortyol',	'Dortyol'),
(316396,	217,	311044,	'Dokuz',	'Dokuz',	'Dokuz',	1,	13642,	'2019-03-16 03:59:51',	'Dokuz',	'Dokuz',	'Dokuz'),
(316407,	217,	304794,	'Dogus',	'Dogus',	'Dogus',	1,	13631,	'2019-03-16 03:59:51',	'Dogus',	'Dogus',	'Dogus'),
(316466,	217,	300821,	'Dogankoy',	'Dogankoy',	'Dogankoy',	1,	13626,	'2019-03-16 03:59:51',	'Dogankoy',	'Dogankoy',	'Dogankoy'),
(316523,	217,	305267,	'Doga',	'Doga',	'Doga',	1,	13624,	'2019-03-16 03:59:51',	'Doga',	'Doga',	'Doga'),
(316541,	217,	316540,	'Диярбакыр',	'Diyarbakir',	'Diyarbakir',	1,	13589,	'2019-03-16 03:59:51',	'Diyarbakir',	'Diyarbakir',	'Diyarbakir'),
(317109,	217,	317106,	'Денизли',	'Denizli',	'Denizli',	1,	13194,	'2019-03-16 03:59:51',	'Denizli',	'Denizli',	'Denizli'),
(317892,	217,	304825,	'Cukurova',	'Cukurova',	'Cukurova',	1,	12496,	'2019-03-16 03:59:51',	'Cukurova',	'Cukurova',	'Cukurova'),
(318006,	217,	298332,	'Saglik',	'Saglik',	'Saglik',	1,	42235,	'2019-03-16 03:59:51',	'Saglik',	'Saglik',	'Saglik'),
(318137,	217,	312888,	'Хаккари',	'Hakkari',	'Hakkari',	1,	20386,	'2019-03-16 03:59:51',	'Hakkari',	'Hakkari',	'Hakkari'),
(318372,	217,	322819,	'Cine',	'Cine',	'Cine',	1,	10529,	'2019-03-16 03:59:51',	'Cine',	'Cine',	'Cine'),
(318675,	217,	325361,	'Джейхан',	'Ceyhan',	'Ceyhan',	1,	9488,	'2019-03-16 03:59:51',	'Ceyhan',	'Ceyhan',	'Ceyhan'),
(318766,	217,	316540,	'Cermik',	'Cermik',	'Cermik',	1,	9423,	'2019-03-16 03:59:51',	'Cermik',	'Cermik',	'Cermik'),
(319778,	217,	323776,	'Calkaya',	'Calkaya',	'Calkaya',	1,	7866,	'2019-03-16 03:59:51',	'Calkaya',	'Calkaya',	'Calkaya'),
(320211,	217,	311044,	'Bogazici',	'Bogazici',	'Bogazici',	1,	5595,	'2019-03-16 03:59:51',	'Bogazici',	'Bogazici',	'Bogazici'),
(320374,	217,	322819,	'Buharkent',	'Buharkent',	'Buharkent',	1,	7259,	'2019-03-16 03:59:51',	'Buharkent',	'Buharkent',	'Buharkent'),
(320387,	217,	311044,	'Burgaz',	'Burgaz',	'Burgaz',	1,	7374,	'2019-03-16 03:59:51',	'Burgaz',	'Burgaz',	'Burgaz'),
(320392,	217,	320390,	'Бурдур',	'Burdur',	'Burdur',	1,	7357,	'2019-03-16 03:59:51',	'Burdur',	'Burdur',	'Burdur'),
(320495,	217,	443189,	'Tak’yan',	'Bugdayli',	'Bugdayli',	1,	7254,	'2019-03-16 03:59:51',	'Bugdayli',	'Bugdayli',	'Bugdayli'),
(320540,	217,	311044,	'Buca',	'Buca',	'Buca',	1,	7132,	'2019-03-16 03:59:51',	'Buca',	'Buca',	'Buca'),
(320557,	217,	321122,	'Bozuyuk',	'Bozuyuk',	'Bozuyuk',	1,	6279,	'2019-03-16 03:59:51',	'Bozuyuk',	'Bozuyuk',	'Bozuyuk'),
(320857,	217,	311044,	'Bornova',	'Bornova',	'Bornova',	1,	5955,	'2019-03-16 03:59:51',	'Bornova',	'Bornova',	'Bornova'),
(320995,	217,	304183,	'Бодрум',	'Bodrum',	'Bodrum',	1,	5577,	'2019-03-16 03:59:51',	'Bodrum',	'Bodrum',	'Bodrum'),
(321025,	217,	321022,	'Битлис',	'Bitlis',	'Bitlis',	1,	5203,	'2019-03-16 03:59:51',	'Bitlis',	'Bitlis',	'Bitlis'),
(321082,	217,	321079,	'Бингол',	'Bingol',	'Bingol',	1,	5062,	'2019-03-16 03:59:51',	'Bingol',	'Bingol',	'Bingol'),
(321109,	217,	298113,	'Bilgi',	'Bilgi',	'Bilgi',	1,	5006,	'2019-03-16 03:59:51',	'Bilgi',	'Bilgi',	'Bilgi'),
(321253,	217,	300821,	'Beykent',	'Beykent',	'Beykent',	1,	4834,	'2019-03-16 03:59:51',	'Beykent',	'Beykent',	'Beykent'),
(321426,	217,	311044,	'Пергам',	'Bergama',	'Bergama',	1,	4500,	'2019-03-16 03:59:51',	'Bergama',	'Bergama',	'Bergama'),
(321580,	217,	323776,	'Белек',	'Belek',	'Belek',	1,	4105,	'2019-03-16 03:59:51',	'Belek',	'Belek',	'Belek'),
(321836,	217,	443186,	'Батман',	'Batman',	'Batman',	1,	3663,	'2019-03-16 03:59:51',	'Batman',	'Batman',	'Batman'),
(321929,	217,	315807,	'Baskil',	'Baskil',	'Baskil',	1,	3598,	'2019-03-16 03:59:51',	'Baskil',	'Baskil',	'Baskil'),
(321979,	217,	443186,	'Basari',	'Basari',	'Basari',	1,	3577,	'2019-03-16 03:59:51',	'Basari',	'Basari',	'Basari'),
(322165,	217,	322164,	'Балыкесир',	'Balikesir',	'Balikesir',	1,	3203,	'2019-03-16 03:59:51',	'Balikesir',	'Balikesir',	'Balikesir'),
(322758,	217,	316540,	'Aygun',	'Aygun',	'Aygun',	1,	2796,	'2019-03-16 03:59:51',	'Aygun',	'Aygun',	'Aygun'),
(322830,	217,	322819,	'Айдын',	'Aydin',	'Aydin',	1,	2790,	'2019-03-16 03:59:51',	'Aydin',	'Aydin',	'Aydin'),
(322965,	217,	303830,	'Avanos',	'Avanos',	'Avanos',	1,	2681,	'2019-03-16 03:59:51',	'Avanos',	'Avanos',	'Avanos'),
(322999,	217,	315201,	'Atlas',	'Atlas',	'Atlas',	1,	2367,	'2019-03-16 03:59:51',	'Atlas',	'Atlas',	'Atlas'),
(323777,	217,	323776,	'Анталия',	'Antalya',	'Antalya',	1,	1570,	'2019-03-16 03:59:51',	'Antalya',	'Antalya',	'Antalya'),
(323779,	217,	312394,	'Антиохия',	'Hatay',	'Hatay',	1,	20920,	'2019-03-16 03:59:51',	'Hatay',	'Hatay',	'Hatay'),
(323786,	217,	323784,	'Анкара',	'Ankara',	'Ankara',	1,	1490,	'2019-03-16 03:59:51',	'Ankara',	'Ankara',	'Ankara'),
(323805,	217,	298113,	'Andac',	'Andac',	'Andac',	1,	1359,	'2019-03-16 03:59:51',	'Andac',	'Andac',	'Andac'),
(323969,	217,	325302,	'Alpaslan',	'Alpaslan',	'Alpaslan',	1,	951,	'2019-03-16 03:59:51',	'Alpaslan',	'Alpaslan',	'Alpaslan'),
(324190,	217,	323776,	'Аланья',	'Alanya',	'Alanya',	1,	508,	'2019-03-16 03:59:51',	'Alanya',	'Alanya',	'Alanya'),
(324496,	217,	443185,	'Аксарай',	'Aksaray',	'Aksaray',	1,	469,	'2019-03-16 03:59:51',	'Aksaray',	'Aksaray',	'Aksaray'),
(324698,	217,	304825,	'Акхисар',	'Akhisar',	'Akhisar',	1,	457,	'2019-03-16 03:59:51',	'Akhisar',	'Akhisar',	'Akhisar'),
(325303,	217,	325302,	'Афьонкарахисар',	'Afyonkarahisar',	'Afyonkarahisar',	1,	286,	'2019-03-16 03:59:51',	'Afyonkarahisar',	'Afyonkarahisar',	'Afyonkarahisar'),
(325330,	217,	325329,	'Адыяман',	'Adiyaman',	'Adiyaman',	1,	248,	'2019-03-16 03:59:51',	'Adiyaman',	'Adiyaman',	'Adiyaman'),
(325363,	217,	325361,	'Адана',	'Adana',	'Adana',	1,	203,	'2019-03-16 03:59:51',	'Adana',	'Adana',	'Adana'),
(325403,	217,	311044,	'Ada',	'Ada',	'Ada',	1,	181,	'2019-03-16 03:59:51',	'Ada',	'Ada',	'Ada'),
(325467,	217,	315807,	'Acibadem',	'Acibadem',	'Acibadem',	1,	146,	'2019-03-16 03:59:51',	'Acibadem',	'Acibadem',	'Acibadem'),
(325488,	217,	304041,	'Suleyman',	'Suleyman',	'Suleyman',	1,	48061,	'2019-03-16 03:59:51',	'Suleyman',	'Suleyman',	'Suleyman'),
(385024,	4,	292224,	'As Satwah',	'As Satwah',	'As Satwah',	1,	2120,	'2019-03-16 03:59:51',	'As Satwah',	'As Satwah',	'As Satwah'),
(436408,	217,	298332,	'Dayanikli',	'Dayanikli',	'Dayanikli',	1,	12949,	'2019-03-16 03:59:51',	'Dayanikli',	'Dayanikli',	'Dayanikli'),
(437332,	217,	314829,	'Sahinbey',	'Sahinbey',	'Sahinbey',	1,	42244,	'2019-03-16 03:59:51',	'Sahinbey',	'Sahinbey',	'Sahinbey'),
(440831,	217,	443186,	'Bitam',	'Bitam',	'Bitam',	1,	5198,	'2019-03-16 03:59:51',	'Bitam',	'Bitam',	'Bitam'),
(448596,	187,	108411,	'Al Faruq',	'Al Faruq',	'Al Faruq',	1,	476,	'2019-03-16 03:59:51',	'Al Faruq',	'Al Faruq',	'Al Faruq'),
(452949,	185,	480041,	'Удомля',	'Udomlya',	'Udomlya',	1,	50259,	'2019-03-16 03:59:51',	'Udomlya',	'Udomlya',	'Udomlya'),
(461720,	185,	826294,	'Костерёво',	'Kosterevo',	'Kosterevo',	1,	24827,	'2019-03-16 03:59:51',	'Kosterevo',	'Kosterevo',	'Kosterevo'),
(461920,	185,	524925,	'Звенигород',	'Zvenigorod',	'Zvenigorod',	1,	55236,	'2019-03-16 03:59:51',	'Zvenigorod',	'Zvenigorod',	'Zvenigorod'),
(462444,	185,	1508290,	'Златоуст',	'Zlatoust',	'Zlatoust',	1,	55195,	'2019-03-16 03:59:51',	'Zlatoust',	'Zlatoust',	'Zlatoust'),
(462522,	185,	501165,	'Зимовники',	'Zimovniki',	'Zimovniki',	1,	55184,	'2019-03-16 03:59:51',	'Zimovniki',	'Zimovniki',	'Zimovniki'),
(462755,	185,	524925,	'Жуковский',	'Zhukovskiy',	'Zhukovskiy',	1,	55151,	'2019-03-16 03:59:51',	'Zhukovskiy',	'Zhukovskiy',	'Zhukovskiy'),
(462822,	185,	571473,	'Жуковка',	'Zhukovka',	'Zhukovka',	1,	55150,	'2019-03-16 03:59:51',	'Zhukovka',	'Zhukovka',	'Zhukovka'),
(462984,	185,	472755,	'Жирновск',	'Zhirnovsk',	'Zhirnovsk',	1,	55145,	'2019-03-16 03:59:51',	'Zhirnovsk',	'Zhirnovsk',	'Zhirnovsk'),
(463082,	185,	499068,	'Жигулевск',	'Zhigulevsk',	'Zhigulevsk',	1,	55144,	'2019-03-16 03:59:51',	'Zhigulevsk',	'Zhigulevsk',	'Zhigulevsk'),
(463340,	185,	487839,	'Железноводск',	'Zheleznovodsk',	'Zheleznovodsk',	1,	55141,	'2019-03-16 03:59:51',	'Zheleznovodsk',	'Zheleznovodsk',	'Zheleznovodsk'),
(463343,	185,	538555,	'Железногорск',	'Zheleznogorsk',	'Zheleznogorsk',	1,	55139,	'2019-03-16 03:59:51',	'Zheleznogorsk',	'Zheleznogorsk',	'Zheleznogorsk'),
(463355,	185,	524925,	'Железнодорожный',	'Zheleznodorozhnyy',	'Zheleznodorozhnyy',	1,	55137,	'2019-03-16 03:59:51',	'Zheleznodorozhnyy',	'Zheleznodorozhnyy',	'Zheleznodorozhnyy'),
(463637,	185,	501165,	'Зерноград',	'Zernograd',	'Zernograd',	1,	55119,	'2019-03-16 03:59:51',	'Zernograd',	'Zernograd',	'Zernograd'),
(463829,	185,	524894,	'Зеленоград',	'Zelenograd',	'Zelenograd',	1,	55088,	'2019-03-16 03:59:51',	'Zelenograd',	'Zelenograd',	'Zelenograd'),
(464101,	185,	559838,	'Заволжье',	'Zavolzh\'ye',	'Zavolzh\'ye',	1,	55065,	'2019-03-16 03:59:51',	'Zavolzh\'ye',	'Zavolzh\'ye',	'Zavolzh\'ye'),
(464625,	185,	511555,	'Заречный',	'Zarechnyy',	'Zarechnyy',	1,	55055,	'2019-03-16 03:59:51',	'Zarechnyy',	'Zarechnyy',	'Zarechnyy'),
(464687,	185,	524925,	'Зарайск',	'Zaraysk',	'Zaraysk',	1,	55054,	'2019-03-16 03:59:51',	'Zaraysk',	'Zaraysk',	'Zaraysk'),
(464790,	185,	524304,	'Заполярный',	'Zapolyarnyy',	'Zapolyarnyy',	1,	55045,	'2019-03-16 03:59:51',	'Zapolyarnyy',	'Zapolyarnyy',	'Zapolyarnyy'),
(465726,	185,	535120,	'Задонск',	'Zadonsk',	'Zadonsk',	1,	55023,	'2019-03-16 03:59:51',	'Zadonsk',	'Zadonsk',	'Zadonsk'),
(466200,	185,	1508290,	'Юрюзань',	'Yuryuzan\'',	'Yuryuzan\'',	1,	55000,	'2019-03-16 03:59:51',	'Yuryuzan\'',	'Yuryuzan\'',	'Yuryuzan\''),
(466806,	185,	529352,	'Йошкар-Ола',	'Yoshkar-Ola',	'Yoshkar-Ola',	1,	54965,	'2019-03-16 03:59:51',	'Yoshkar-Ola',	'Yoshkar-Ola',	'Yoshkar-Ola'),
(466885,	185,	542415,	'Ейск',	'Yeysk',	'Yeysk',	1,	54933,	'2019-03-16 03:59:51',	'Yeysk',	'Yeysk',	'Yeysk'),
(466990,	185,	487839,	'Ессентуки',	'Yessentuki',	'Yessentuki',	1,	54929,	'2019-03-16 03:59:51',	'Yessentuki',	'Yessentuki',	'Yessentuki'),
(467753,	185,	491684,	'Ельня',	'Yel\'nya',	'Yel\'nya',	1,	54907,	'2019-03-16 03:59:51',	'Yel\'nya',	'Yel\'nya',	'Yel\'nya'),
(467978,	185,	535120,	'Елец',	'Yelets',	'Yelets',	1,	54911,	'2019-03-16 03:59:51',	'Yelets',	'Yelets',	'Yelets'),
(468063,	185,	472755,	'Елань',	'Yelan\'',	'Yelan\'',	1,	54910,	'2019-03-16 03:59:51',	'Yelan\'',	'Yelan\'',	'Yelan\''),
(468082,	185,	484048,	'Елабуга',	'Yelabuga',	'Yelabuga',	1,	54908,	'2019-03-16 03:59:51',	'Yelabuga',	'Yelabuga',	'Yelabuga'),
(468250,	185,	524925,	'Егорьевск',	'Yegor\'yevsk',	'Yegor\'yevsk',	1,	54904,	'2019-03-16 03:59:51',	'Yegor\'yevsk',	'Yegor\'yevsk',	'Yegor\'yevsk'),
(468307,	185,	501165,	'Егорлыкская',	'Yegorlykskaya',	'Yegorlykskaya',	1,	54905,	'2019-03-16 03:59:51',	'Yegorlykskaya',	'Yegorlykskaya',	'Yegorlykskaya'),
(468390,	185,	480508,	'Ефремов',	'Yefremov',	'Yefremov',	1,	54902,	'2019-03-16 03:59:51',	'Yefremov',	'Yefremov',	'Yefremov'),
(468657,	185,	515001,	'Ясный',	'Yasnyy',	'Yasnyy',	1,	54887,	'2019-03-16 03:59:51',	'Yasnyy',	'Yasnyy',	'Yasnyy'),
(468866,	185,	491684,	'Ярцево',	'Yartsevo',	'Yartsevo',	1,	54884,	'2019-03-16 03:59:51',	'Yartsevo',	'Yartsevo',	'Yartsevo'),
(468902,	185,	468898,	'Ярославль',	'Yaroslavl',	'Yaroslavl',	1,	54883,	'2019-03-16 03:59:51',	'Yaroslavl',	'Yaroslavl',	'Yaroslavl'),
(469178,	185,	578853,	'Янаул',	'Yanaul',	'Yanaul',	1,	54874,	'2019-03-16 03:59:51',	'Yanaul',	'Yanaul',	'Yanaul'),
(469507,	185,	543871,	'Якшанга',	'Yakshanga',	'Yakshanga',	1,	54860,	'2019-03-16 03:59:51',	'Yakshanga',	'Yakshanga',	'Yakshanga'),
(469655,	185,	524925,	'Яхрома',	'Yakhroma',	'Yakhroma',	1,	54857,	'2019-03-16 03:59:51',	'Yakhroma',	'Yakhroma',	'Yakhroma'),
(469809,	185,	567395,	'Ядрин',	'Yadrin',	'Yadrin',	1,	54851,	'2019-03-16 03:59:51',	'Yadrin',	'Yadrin',	'Yadrin'),
(469844,	185,	584222,	'Яблоновский',	'Yablonovskiy',	'Yablonovskiy',	1,	54847,	'2019-03-16 03:59:51',	'Yablonovskiy',	'Yablonovskiy',	'Yablonovskiy'),
(469911,	185,	554230,	'Взморье',	'Vzmor\'ye',	'Vzmor\'ye',	1,	52378,	'2019-03-16 03:59:51',	'Vzmor\'ye',	'Vzmor\'ye',	'Vzmor\'ye'),
(470252,	185,	480041,	'Вышний Волочек',	'Vyshniy Volochek',	'Vyshniy Volochek',	1,	52375,	'2019-03-16 03:59:51',	'Vyshniy Volochek',	'Vyshniy Volochek',	'Vyshniy Volochek'),
(470338,	185,	542415,	'Выселки',	'Vyselki',	'Vyselki',	1,	52372,	'2019-03-16 03:59:51',	'Vyselki',	'Vyselki',	'Vyselki'),
(470368,	185,	536199,	'Вырица',	'Vyritsa',	'Vyritsa',	1,	52371,	'2019-03-16 03:59:51',	'Vyritsa',	'Vyritsa',	'Vyritsa'),
(470444,	185,	559838,	'Выкса',	'Vyksa',	'Vyksa',	1,	52368,	'2019-03-16 03:59:51',	'Vyksa',	'Vyksa',	'Vyksa'),
(470546,	185,	536199,	'Выборг',	'Vyborg',	'Vyborg',	1,	52367,	'2019-03-16 03:59:51',	'Vyborg',	'Vyborg',	'Vyborg'),
(470676,	185,	491684,	'Вязьма',	'Vyaz\'ma',	'Vyaz\'ma',	1,	52366,	'2019-03-16 03:59:51',	'Vyaz\'ma',	'Vyaz\'ma',	'Vyaz\'ma'),
(470845,	185,	567395,	'Вурнары',	'Vurnary',	'Vurnary',	1,	52363,	'2019-03-16 03:59:51',	'Vurnary',	'Vurnary',	'Vurnary'),
(471101,	185,	536199,	'Всеволожск',	'Vsevolozhsk',	'Vsevolozhsk',	1,	52359,	'2019-03-16 03:59:51',	'Vsevolozhsk',	'Vsevolozhsk',	'Vsevolozhsk'),
(471430,	185,	479613,	'Воткинск',	'Votkinsk',	'Votkinsk',	1,	52322,	'2019-03-16 03:59:51',	'Votkinsk',	'Votkinsk',	'Votkinsk'),
(471622,	185,	524925,	'Воскресенское',	'Voskresenskoye',	'Voskresenskoye',	1,	52320,	'2019-03-16 03:59:51',	'Voskresenskoye',	'Voskresenskoye',	'Voskresenskoye'),
(471656,	185,	524925,	'Воскресенск',	'Voskresensk',	'Voskresensk',	1,	52319,	'2019-03-16 03:59:51',	'Voskresensk',	'Voskresensk',	'Voskresensk'),
(472045,	185,	472039,	'Воронеж',	'Voronezh',	'Voronezh',	1,	52315,	'2019-03-16 03:59:51',	'Voronezh',	'Voronezh',	'Voronezh'),
(472231,	185,	472755,	'Волжский',	'Volzhskiy',	'Volzhskiy',	1,	52302,	'2019-03-16 03:59:51',	'Volzhskiy',	'Volzhskiy',	'Volzhskiy'),
(472234,	185,	529352,	'Волжск',	'Volzhsk',	'Volzhsk',	1,	52301,	'2019-03-16 03:59:51',	'Volzhsk',	'Volzhsk',	'Volzhsk'),
(472278,	185,	498671,	'Вольск',	'Vol\'sk',	'Vol\'sk',	1,	52251,	'2019-03-16 03:59:51',	'Vol\'sk',	'Vol\'sk',	'Vol\'sk'),
(472357,	185,	536199,	'Волосово',	'Volosovo',	'Volosovo',	1,	52285,	'2019-03-16 03:59:51',	'Volosovo',	'Volosovo',	'Volosovo'),
(472428,	185,	578071,	'Волоконовка',	'Volokonovka',	'Volokonovka',	1,	52282,	'2019-03-16 03:59:51',	'Volokonovka',	'Volokonovka',	'Volokonovka'),
(472433,	185,	524925,	'Волоколамск',	'Volokolamsk',	'Volokolamsk',	1,	52281,	'2019-03-16 03:59:51',	'Volokolamsk',	'Volokolamsk',	'Volokolamsk'),
(472459,	185,	472454,	'Вологда',	'Vologda',	'Vologda',	1,	52280,	'2019-03-16 03:59:51',	'Vologda',	'Vologda',	'Vologda'),
(472722,	185,	536199,	'Волхов',	'Volkhov',	'Volkhov',	1,	52267,	'2019-03-16 03:59:51',	'Volkhov',	'Volkhov',	'Volkhov'),
(472757,	185,	472755,	'Волгоград',	'Volgograd',	'Volgograd',	1,	52259,	'2019-03-16 03:59:51',	'Volgograd',	'Volgograd',	'Volgograd'),
(472761,	185,	501165,	'Волгодонск',	'Volgodonsk',	'Volgodonsk',	1,	52258,	'2019-03-16 03:59:51',	'Volgodonsk',	'Volgodonsk',	'Volgodonsk'),
(472766,	185,	826294,	'Вольгинский',	'Vol\'ginskiy',	'Vol\'ginskiy',	1,	52249,	'2019-03-16 03:59:51',	'Vol\'ginskiy',	'Vol\'ginskiy',	'Vol\'ginskiy'),
(473247,	185,	826294,	'Владимир',	'Vladimir',	'Vladimir',	1,	52211,	'2019-03-16 03:59:51',	'Vladimir',	'Vladimir',	'Vladimir'),
(473249,	185,	519969,	'Владикавказ',	'Vladikavkaz',	'Vladikavkaz',	1,	52210,	'2019-03-16 03:59:51',	'Vladikavkaz',	'Vladikavkaz',	'Vladikavkaz'),
(473778,	185,	524925,	'Видное',	'Vidnoye',	'Vidnoye',	1,	51504,	'2019-03-16 03:59:51',	'Vidnoye',	'Vidnoye',	'Vidnoye'),
(473984,	185,	524925,	'Вешки',	'Veshki',	'Veshki',	1,	51391,	'2019-03-16 03:59:51',	'Veshki',	'Veshki',	'Veshki'),
(473998,	185,	501165,	'Вешенская',	'Veshenskaya',	'Veshenskaya',	1,	51390,	'2019-03-16 03:59:51',	'Veshenskaya',	'Veshenskaya',	'Veshenskaya'),
(474059,	185,	501165,	'Веселый',	'Veselyy',	'Veselyy',	1,	51389,	'2019-03-16 03:59:51',	'Veselyy',	'Veselyy',	'Veselyy'),
(475938,	185,	581043,	'Вельск',	'Vel\'sk',	'Vel\'sk',	1,	51081,	'2019-03-16 03:59:51',	'Vel\'sk',	'Vel\'sk',	'Vel\'sk'),
(476077,	185,	504338,	'Великие Луки',	'Velikiye Luki',	'Velikiye Luki',	1,	51096,	'2019-03-16 03:59:51',	'Velikiye Luki',	'Velikiye Luki',	'Velikiye Luki'),
(477192,	185,	578071,	'Валуйки',	'Valuyki',	'Valuyki',	1,	50855,	'2019-03-16 03:59:51',	'Valuyki',	'Valuyki',	'Valuyki'),
(477494,	185,	480508,	'Узловая',	'Uzlovaya',	'Uzlovaya',	1,	50612,	'2019-03-16 03:59:51',	'Uzlovaya',	'Uzlovaya',	'Uzlovaya'),
(478544,	185,	472755,	'Урюпинск',	'Uryupinsk',	'Uryupinsk',	1,	50546,	'2019-03-16 03:59:51',	'Uryupinsk',	'Uryupinsk',	'Uryupinsk'),
(478757,	185,	559838,	'Урень',	'Uren\'',	'Uren\'',	1,	50520,	'2019-03-16 03:59:51',	'Uren\'',	'Uren\'',	'Uren\''),
(479028,	185,	571473,	'Унеча',	'Unecha',	'Unecha',	1,	50348,	'2019-03-16 03:59:51',	'Unecha',	'Unecha',	'Unecha'),
(479123,	185,	479119,	'Ульяновск',	'Ulyanovsk',	'Ulyanovsk',	1,	50322,	'2019-03-16 03:59:51',	'Ulyanovsk',	'Ulyanovsk',	'Ulyanovsk'),
(479411,	185,	545854,	'Ухта',	'Ukhta',	'Ukhta',	1,	50294,	'2019-03-16 03:59:51',	'Ukhta',	'Ukhta',	'Ukhta'),
(479532,	185,	468898,	'Углич',	'Uglich',	'Uglich',	1,	50284,	'2019-03-16 03:59:51',	'Uglich',	'Uglich',	'Uglich'),
(479561,	185,	578853,	'Уфа',	'Ufa',	'Ufa',	1,	50273,	'2019-03-16 03:59:51',	'Ufa',	'Ufa',	'Ufa'),
(479703,	185,	578853,	'Учалы',	'Uchaly',	'Uchaly',	1,	50239,	'2019-03-16 03:59:51',	'Uchaly',	'Uchaly',	'Uchaly'),
(480060,	185,	480041,	'Тверь',	'Tver',	'Tver',	1,	50180,	'2019-03-16 03:59:51',	'Tver',	'Tver',	'Tver'),
(480089,	185,	578853,	'Туймазы',	'Tuymazy',	'Tuymazy',	1,	50178,	'2019-03-16 03:59:51',	'Tuymazy',	'Tuymazy',	'Tuymazy'),
(480122,	185,	468898,	'Тутаев',	'Tutayev',	'Tutayev',	1,	50169,	'2019-03-16 03:59:51',	'Tutayev',	'Tutayev',	'Tutayev'),
(480562,	185,	480508,	'Тула',	'Tula',	'Tula',	1,	50089,	'2019-03-16 03:59:51',	'Tula',	'Tula',	'Tula'),
(480716,	185,	542415,	'Туапсе',	'Tuapse',	'Tuapse',	1,	50062,	'2019-03-16 03:59:51',	'Tuapse',	'Tuapse',	'Tuapse'),
(480876,	185,	501165,	'Цимлянск',	'Tsimlyansk',	'Tsimlyansk',	1,	50058,	'2019-03-16 03:59:51',	'Tsimlyansk',	'Tsimlyansk',	'Tsimlyansk'),
(481036,	185,	501165,	'Целина',	'Tselina',	'Tselina',	1,	50057,	'2019-03-16 03:59:51',	'Tselina',	'Tselina',	'Tselina'),
(481608,	185,	524894,	'Троицк',	'Troitsk',	'Troitsk',	1,	49976,	'2019-03-16 03:59:51',	'Troitsk',	'Troitsk',	'Troitsk'),
(482260,	185,	524925,	'Томилино',	'Tomilino',	'Tomilino',	1,	49382,	'2019-03-16 03:59:51',	'Tomilino',	'Tomilino',	'Tomilino'),
(482283,	185,	499068,	'Тольятти',	'Togliatti',	'Togliatti',	1,	49339,	'2019-03-16 03:59:51',	'Togliatti',	'Togliatti',	'Togliatti'),
(482965,	185,	542415,	'Тимашевск',	'Timashevsk',	'Timashevsk',	1,	49231,	'2019-03-16 03:59:51',	'Timashevsk',	'Timashevsk',	'Timashevsk'),
(483019,	185,	536199,	'Тихвин',	'Tikhvin',	'Tikhvin',	1,	49207,	'2019-03-16 03:59:51',	'Tikhvin',	'Tikhvin',	'Tikhvin'),
(483029,	185,	542415,	'Тихорецк',	'Tikhoretsk',	'Tikhoretsk',	1,	49206,	'2019-03-16 03:59:51',	'Tikhoretsk',	'Tikhoretsk',	'Tikhoretsk'),
(483137,	185,	555235,	'Тейково',	'Teykovo',	'Teykovo',	1,	48894,	'2019-03-16 03:59:51',	'Teykovo',	'Teykovo',	'Teykovo'),
(483661,	185,	542415,	'Темрюк',	'Temryuk',	'Temryuk',	1,	48768,	'2019-03-16 03:59:51',	'Temryuk',	'Temryuk',	'Temryuk'),
(484034,	185,	498671,	'Татищево',	'Tatishchevo',	'Tatishchevo',	1,	48608,	'2019-03-16 03:59:51',	'Tatishchevo',	'Tatishchevo',	'Tatishchevo'),
(484287,	185,	553899,	'Таруса',	'Tarusa',	'Tarusa',	1,	48597,	'2019-03-16 03:59:51',	'Tarusa',	'Tarusa',	'Tarusa'),
(484396,	185,	501165,	'Тарасовский',	'Tarasovskiy',	'Tarasovskiy',	1,	48559,	'2019-03-16 03:59:51',	'Tarasovskiy',	'Tarasovskiy',	'Tarasovskiy'),
(484646,	185,	484638,	'Тамбов',	'Tambov',	'Tambov',	1,	48509,	'2019-03-16 03:59:51',	'Tambov',	'Tambov',	'Tambov'),
(484907,	185,	501165,	'Таганрог',	'Taganrog',	'Taganrog',	1,	48420,	'2019-03-16 03:59:51',	'Taganrog',	'Taganrog',	'Taganrog'),
(484910,	185,	524925,	'Таганьково',	'Tagan\'kovo',	'Tagan\'kovo',	1,	48419,	'2019-03-16 03:59:51',	'Tagan\'kovo',	'Tagan\'kovo',	'Tagan\'kovo'),
(484972,	185,	499068,	'Сызрань',	'Syzran\'',	'Syzran\'',	1,	48385,	'2019-03-16 03:59:51',	'Syzran\'',	'Syzran\'',	'Syzran\''),
(485239,	185,	545854,	'Сыктывкар',	'Syktyvkar',	'Syktyvkar',	1,	48361,	'2019-03-16 03:59:51',	'Syktyvkar',	'Syktyvkar',	'Syktyvkar'),
(485351,	185,	472454,	'Сямжа',	'Syamzha',	'Syamzha',	1,	48349,	'2019-03-16 03:59:51',	'Syamzha',	'Syamzha',	'Syamzha'),
(485643,	185,	472755,	'Светлый Яр',	'Svetlyy Yar',	'Svetlyy Yar',	1,	48294,	'2019-03-16 03:59:51',	'Svetlyy Yar',	'Svetlyy Yar',	'Svetlyy Yar'),
(485660,	185,	554230,	'Светлый',	'Svetlyy',	'Svetlyy',	1,	48293,	'2019-03-16 03:59:51',	'Svetlyy',	'Svetlyy',	'Svetlyy'),
(485698,	185,	487839,	'Светлоград',	'Svetlograd',	'Svetlograd',	1,	48292,	'2019-03-16 03:59:51',	'Svetlograd',	'Svetlograd',	'Svetlograd'),
(485699,	185,	554230,	'Светлогорск',	'Svetlogorsk',	'Svetlogorsk',	1,	48291,	'2019-03-16 03:59:51',	'Svetlogorsk',	'Svetlogorsk',	'Svetlogorsk'),
(485888,	185,	480508,	'Суворов',	'Suvorov',	'Suvorov',	1,	48280,	'2019-03-16 03:59:51',	'Suvorov',	'Suvorov',	'Suvorov'),
(486968,	185,	524925,	'Ступино',	'Stupino',	'Stupino',	1,	47980,	'2019-03-16 03:59:51',	'Stupino',	'Stupino',	'Stupino'),
(487495,	185,	578853,	'Стерлитамак',	'Sterlitamak',	'Sterlitamak',	1,	47654,	'2019-03-16 03:59:51',	'Sterlitamak',	'Sterlitamak',	'Sterlitamak'),
(487846,	185,	487839,	'Ставрополь',	'Stavropol\'',	'Stavropol\'',	1,	47532,	'2019-03-16 03:59:51',	'Stavropol\'',	'Stavropol\'',	'Stavropol\''),
(487928,	185,	578071,	'Старый Оскол',	'Staryy Oskol',	'Staryy Oskol',	1,	47507,	'2019-03-16 03:59:51',	'Staryy Oskol',	'Staryy Oskol',	'Staryy Oskol'),
(488505,	185,	472454,	'Бабаево',	'Babayevo',	'Babayevo',	1,	2846,	'2019-03-16 03:59:51',	'Babayevo',	'Babayevo',	'Babayevo'),
(489088,	185,	519324,	'Старая Русса',	'Staraya Russa',	'Staraya Russa',	1,	47492,	'2019-03-16 03:59:51',	'Staraya Russa',	'Staraya Russa',	'Staraya Russa'),
(489102,	185,	472755,	'Старая Полтавка',	'Staraya Poltavka',	'Staraya Poltavka',	1,	47491,	'2019-03-16 03:59:51',	'Staraya Poltavka',	'Staraya Poltavka',	'Staraya Poltavka'),
(489162,	185,	524925,	'Старая Купавна',	'Staraya Kupavna',	'Staraya Kupavna',	1,	47490,	'2019-03-16 03:59:51',	'Staraya Kupavna',	'Staraya Kupavna',	'Staraya Kupavna'),
(489446,	185,	472755,	'Средняя Ахтуба',	'Srednyaya Akhtuba',	'Srednyaya Akhtuba',	1,	47348,	'2019-03-16 03:59:51',	'Srednyaya Akhtuba',	'Srednyaya Akhtuba',	'Srednyaya Akhtuba'),
(489989,	185,	498671,	'Советский',	'Sovetskiy',	'Sovetskiy',	1,	47097,	'2019-03-16 03:59:51',	'Sovetskiy',	'Sovetskiy',	'Sovetskiy'),
(490172,	185,	536199,	'Сосновый Бор',	'Sosnovyy Bor',	'Sosnovyy Bor',	1,	46851,	'2019-03-16 03:59:51',	'Sosnovyy Bor',	'Sosnovyy Bor',	'Sosnovyy Bor'),
(490211,	185,	511555,	'Сосновоборск',	'Sosnovoborsk',	'Sosnovoborsk',	1,	46850,	'2019-03-16 03:59:51',	'Sosnovoborsk',	'Sosnovoborsk',	'Sosnovoborsk'),
(490466,	185,	552548,	'Сортавала',	'Sortavala',	'Sortavala',	1,	46845,	'2019-03-16 03:59:51',	'Sortavala',	'Sortavala',	'Sortavala'),
(490996,	185,	524925,	'Солнечногорск',	'Solnechnogorsk',	'Solnechnogorsk',	1,	46696,	'2019-03-16 03:59:51',	'Solnechnogorsk',	'Solnechnogorsk',	'Solnechnogorsk'),
(491023,	185,	511180,	'Соликамск',	'Solikamsk',	'Solikamsk',	1,	46682,	'2019-03-16 03:59:51',	'Solikamsk',	'Solikamsk',	'Solikamsk'),
(491422,	185,	542415,	'Сочи',	'Sochi',	'Sochi',	1,	46609,	'2019-03-16 03:59:51',	'Sochi',	'Sochi',	'Sochi'),
(491480,	185,	826294,	'Собинка',	'Sobinka',	'Sobinka',	1,	46606,	'2019-03-16 03:59:51',	'Sobinka',	'Sobinka',	'Sobinka'),
(491687,	185,	491684,	'Смоленск',	'Smolensk',	'Smolensk',	1,	46566,	'2019-03-16 03:59:51',	'Smolensk',	'Smolensk',	'Smolensk'),
(492094,	185,	542415,	'Славянск-на-Кубани',	'Slavyansk-na-Kubani',	'Slavyansk-na-Kubani',	1,	46498,	'2019-03-16 03:59:51',	'Slavyansk-na-Kubani',	'Slavyansk-na-Kubani',	'Slavyansk-na-Kubani'),
(492448,	185,	524925,	'Сходня',	'Skhodnya',	'Skhodnya',	1,	46471,	'2019-03-16 03:59:51',	'Skhodnya',	'Skhodnya',	'Skhodnya'),
(493160,	185,	578853,	'Сибай',	'Sibay',	'Sibay',	1,	46204,	'2019-03-16 03:59:51',	'Sibay',	'Sibay',	'Sibay'),
(493231,	185,	555235,	'Шуя',	'Shuya',	'Shuya',	1,	46197,	'2019-03-16 03:59:51',	'Shuya',	'Shuya',	'Shuya'),
(493463,	185,	567395,	'Шумерля',	'Shumerlya',	'Shumerlya',	1,	46191,	'2019-03-16 03:59:51',	'Shumerlya',	'Shumerlya',	'Shumerlya'),
(495065,	185,	543871,	'Шекшема',	'Shekshema',	'Shekshema',	1,	46022,	'2019-03-16 03:59:51',	'Shekshema',	'Shekshema',	'Shekshema'),
(495112,	185,	578071,	'Шебекино',	'Shebekino',	'Shebekino',	1,	46008,	'2019-03-16 03:59:51',	'Shebekino',	'Shebekino',	'Shebekino'),
(495260,	185,	524894,	'Щербинка',	'Shcherbinka',	'Shcherbinka',	1,	46006,	'2019-03-16 03:59:51',	'Shcherbinka',	'Shcherbinka',	'Shcherbinka'),
(495344,	185,	524925,	'Щелково',	'Shchelkovo',	'Shchelkovo',	1,	46005,	'2019-03-16 03:59:51',	'Shchelkovo',	'Shchelkovo',	'Shchelkovo'),
(495518,	185,	524925,	'Шатура',	'Shatura',	'Shatura',	1,	45991,	'2019-03-16 03:59:51',	'Shatura',	'Shatura',	'Shatura'),
(495619,	185,	543871,	'Шарья',	'Shar\'ya',	'Shar\'ya',	1,	45962,	'2019-03-16 03:59:51',	'Shar\'ya',	'Shar\'ya',	'Shar\'ya'),
(496012,	185,	559838,	'Шахунья',	'Shakhun\'ya',	'Shakhun\'ya',	1,	45943,	'2019-03-16 03:59:51',	'Shakhun\'ya',	'Shakhun\'ya',	'Shakhun\'ya'),
(496015,	185,	501165,	'Шахты',	'Shakhty',	'Shakhty',	1,	45942,	'2019-03-16 03:59:51',	'Shakhty',	'Shakhty',	'Shakhty'),
(496285,	185,	581043,	'Северодвинск',	'Severodvinsk',	'Severodvinsk',	1,	45872,	'2019-03-16 03:59:51',	'Severodvinsk',	'Severodvinsk',	'Severodvinsk'),
(496478,	185,	536203,	'Сестрорецк',	'Sestroretsk',	'Sestroretsk',	1,	45845,	'2019-03-16 03:59:51',	'Sestroretsk',	'Sestroretsk',	'Sestroretsk'),
(496519,	185,	536199,	'Сертолово',	'Sertolovo',	'Sertolovo',	1,	45818,	'2019-03-16 03:59:51',	'Sertolovo',	'Sertolovo',	'Sertolovo'),
(496527,	185,	524925,	'Серпухов',	'Serpukhov',	'Serpukhov',	1,	45786,	'2019-03-16 03:59:51',	'Serpukhov',	'Serpukhov',	'Serpukhov'),
(496638,	185,	524925,	'Сергиев Посад',	'Sergiyev Posad',	'Sergiyev Posad',	1,	45759,	'2019-03-16 03:59:51',	'Sergiyev Posad',	'Sergiyev Posad',	'Sergiyev Posad'),
(496802,	185,	559838,	'Сергач',	'Sergach',	'Sergach',	1,	45757,	'2019-03-16 03:59:51',	'Sergach',	'Sergach',	'Sergach'),
(496879,	185,	524925,	'Серебряные Пруды',	'Serebryanyye Prudy',	'Serebryanyye Prudy',	1,	45746,	'2019-03-16 03:59:51',	'Serebryanyye Prudy',	'Serebryanyye Prudy',	'Serebryanyye Prudy'),
(497218,	185,	501165,	'Семикаракорск',	'Semikarakorsk',	'Semikarakorsk',	1,	45660,	'2019-03-16 03:59:51',	'Semikarakorsk',	'Semikarakorsk',	'Semikarakorsk'),
(497450,	185,	559838,	'Семенов',	'Semenov',	'Semenov',	1,	45657,	'2019-03-16 03:59:51',	'Semenov',	'Semenov',	'Semenov'),
(497534,	185,	524925,	'Селятино',	'Selyatino',	'Selyatino',	1,	45651,	'2019-03-16 03:59:51',	'Selyatino',	'Selyatino',	'Selyatino'),
(497927,	185,	552548,	'Сегежа',	'Segezha',	'Segezha',	1,	45554,	'2019-03-16 03:59:51',	'Segezha',	'Segezha',	'Segezha'),
(498418,	185,	1508290,	'Сатка',	'Satka',	'Satka',	1,	44771,	'2019-03-16 03:59:51',	'Satka',	'Satka',	'Satka'),
(498525,	185,	559838,	'Саров',	'Sarov',	'Sarov',	1,	44714,	'2019-03-16 03:59:51',	'Sarov',	'Sarov',	'Sarov'),
(498677,	185,	498671,	'Саратов',	'Saratov',	'Saratov',	1,	44672,	'2019-03-16 03:59:51',	'Saratov',	'Saratov',	'Saratov'),
(498687,	185,	479613,	'Сарапул',	'Sarapul',	'Sarapul',	1,	44666,	'2019-03-16 03:59:51',	'Sarapul',	'Sarapul',	'Sarapul'),
(498698,	185,	525369,	'Саранск',	'Saransk',	'Saransk',	1,	44665,	'2019-03-16 03:59:51',	'Saransk',	'Saransk',	'Saransk'),
(498708,	185,	515001,	'Саракташ',	'Saraktash',	'Saraktash',	1,	44656,	'2019-03-16 03:59:51',	'Saraktash',	'Saraktash',	'Saraktash'),
(498817,	185,	536203,	'Санкт-Петербург',	'Saint Petersburg',	'Saint Petersburg',	1,	42391,	'2019-03-16 03:59:51',	'Saint Petersburg',	'Saint Petersburg',	'Saint Petersburg'),
(499099,	185,	499068,	'Самара',	'Samara',	'Samara',	1,	43907,	'2019-03-16 03:59:51',	'Samara',	'Samara',	'Samara'),
(499161,	185,	501165,	'Сальск',	'Sal\'sk',	'Sal\'sk',	1,	43713,	'2019-03-16 03:59:51',	'Sal\'sk',	'Sal\'sk',	'Sal\'sk'),
(499292,	185,	578853,	'Салават',	'Salavat',	'Salavat',	1,	43732,	'2019-03-16 03:59:51',	'Salavat',	'Salavat',	'Salavat'),
(499452,	185,	491684,	'Сафоново',	'Safonovo',	'Safonovo',	1,	42223,	'2019-03-16 03:59:51',	'Safonovo',	'Safonovo',	'Safonovo'),
(500004,	185,	468898,	'Рыбинск',	'Rybinsk',	'Rybinsk',	1,	42134,	'2019-03-16 03:59:51',	'Rybinsk',	'Rybinsk',	'Rybinsk'),
(500047,	185,	500059,	'Ряжск',	'Ryazhsk',	'Ryazhsk',	1,	42133,	'2019-03-16 03:59:51',	'Ryazhsk',	'Ryazhsk',	'Ryazhsk'),
(500096,	185,	500059,	'Рязань',	'Ryazan\'',	'Ryazan\'',	1,	42132,	'2019-03-16 03:59:51',	'Ryazan\'',	'Ryazan\'',	'Ryazan\''),
(500303,	185,	524925,	'Руза',	'Ruza',	'Ruza',	1,	42129,	'2019-03-16 03:59:51',	'Ruza',	'Ruza',	'Ruza'),
(500591,	185,	524894,	'Румянцево',	'Rumyantsevo',	'Rumyantsevo',	1,	42016,	'2019-03-16 03:59:51',	'Rumyantsevo',	'Rumyantsevo',	'Rumyantsevo'),
(500678,	185,	472755,	'Рудня',	'Rudnya',	'Rudnya',	1,	41954,	'2019-03-16 03:59:51',	'Rudnya',	'Rudnya',	'Rudnya'),
(501175,	185,	501165,	'Ростов-на-Дону',	'Rostov-na-Donu',	'Rostov-na-Donu',	1,	41698,	'2019-03-16 03:59:51',	'Rostov-na-Donu',	'Rostov-na-Donu',	'Rostov-na-Donu'),
(501183,	185,	468898,	'Ростов',	'Rostov',	'Rostov',	1,	41697,	'2019-03-16 03:59:51',	'Rostov',	'Rostov',	'Rostov'),
(501231,	185,	472039,	'Россошь',	'Rossosh\'',	'Rossosh\'',	1,	41687,	'2019-03-16 03:59:51',	'Rossosh\'',	'Rossosh\'',	'Rossosh\''),
(501283,	185,	491684,	'Рославль',	'Roslavl\'',	'Roslavl\'',	1,	41657,	'2019-03-16 03:59:51',	'Roslavl\'',	'Roslavl\'',	'Roslavl\''),
(501405,	185,	501165,	'Романовская',	'Romanovskaya',	'Romanovskaya',	1,	41450,	'2019-03-16 03:59:51',	'Romanovskaya',	'Romanovskaya',	'Romanovskaya'),
(501730,	185,	555235,	'Родники',	'Rodniki',	'Rodniki',	1,	41343,	'2019-03-16 03:59:51',	'Rodniki',	'Rodniki',	'Rodniki'),
(501774,	185,	501165,	'Родионово-Несветайская',	'Rodionovo-Nesvetayskaya',	'Rodionovo-Nesvetayskaya',	1,	41339,	'2019-03-16 03:59:51',	'Rodionovo-Nesvetayskaya',	'Rodionovo-Nesvetayskaya',	'Rodionovo-Nesvetayskaya'),
(502011,	185,	1490542,	'Ревда',	'Revda',	'Revda',	1,	40547,	'2019-03-16 03:59:51',	'Revda',	'Revda',	'Revda'),
(502018,	185,	524925,	'Реутов',	'Reutov',	'Reutov',	1,	40542,	'2019-03-16 03:59:51',	'Reutov',	'Reutov',	'Reutov'),
(502185,	185,	501165,	'Ремонтное',	'Remontnoye',	'Remontnoye',	1,	40433,	'2019-03-16 03:59:51',	'Remontnoye',	'Remontnoye',	'Remontnoye'),
(502793,	185,	484638,	'Рассказово',	'Rasskazovo',	'Rasskazovo',	1,	40061,	'2019-03-16 03:59:51',	'Rasskazovo',	'Rasskazovo',	'Rasskazovo'),
(502965,	185,	524925,	'Раменское',	'Ramenskoye',	'Ramenskoye',	1,	39933,	'2019-03-16 03:59:51',	'Ramenskoye',	'Ramenskoye',	'Ramenskoye'),
(503550,	185,	487839,	'Пятигорск',	'Pyatigorsk',	'Pyatigorsk',	1,	39633,	'2019-03-16 03:59:51',	'Pyatigorsk',	'Pyatigorsk',	'Pyatigorsk'),
(503761,	185,	524925,	'Путилково',	'Putilkovo',	'Putilkovo',	1,	39601,	'2019-03-16 03:59:51',	'Putilkovo',	'Putilkovo',	'Putilkovo'),
(503977,	185,	524925,	'Пушкино',	'Pushkino',	'Pushkino',	1,	39591,	'2019-03-16 03:59:51',	'Pushkino',	'Pushkino',	'Pushkino'),
(504003,	185,	536203,	'Пушкин',	'Pushkin',	'Pushkin',	1,	39590,	'2019-03-16 03:59:51',	'Pushkin',	'Pushkin',	'Pushkin'),
(504042,	185,	524925,	'Пущино',	'Pushchino',	'Pushchino',	1,	39589,	'2019-03-16 03:59:51',	'Pushchino',	'Pushchino',	'Pushchino'),
(504341,	185,	504338,	'Псков',	'Pskov',	'Pskov',	1,	39470,	'2019-03-16 03:59:51',	'Pskov',	'Pskov',	'Pskov'),
(504576,	185,	524925,	'Протвино',	'Protvino',	'Protvino',	1,	39432,	'2019-03-16 03:59:51',	'Protvino',	'Protvino',	'Protvino'),
(504915,	185,	578071,	'Прохоровка',	'Prokhorovka',	'Prokhorovka',	1,	39407,	'2019-03-16 03:59:51',	'Prokhorovka',	'Prokhorovka',	'Prokhorovka'),
(505259,	185,	542415,	'Приморско-Ахтарск',	'Primorsko-Akhtarsk',	'Primorsko-Akhtarsk',	1,	39343,	'2019-03-16 03:59:51',	'Primorsko-Akhtarsk',	'Primorsko-Akhtarsk',	'Primorsko-Akhtarsk'),
(505269,	185,	536199,	'Приморск',	'Primorsk',	'Primorsk',	1,	39342,	'2019-03-16 03:59:51',	'Primorsk',	'Primorsk',	'Primorsk'),
(506278,	185,	504338,	'Порхов',	'Porkhov',	'Porkhov',	1,	38821,	'2019-03-16 03:59:51',	'Porkhov',	'Porkhov',	'Porkhov'),
(506696,	185,	543871,	'Поназырево',	'Ponazyrevo',	'Ponazyrevo',	1,	38636,	'2019-03-16 03:59:51',	'Ponazyrevo',	'Ponazyrevo',	'Ponazyrevo'),
(507599,	185,	826294,	'Покров',	'Pokrov',	'Pokrov',	1,	38516,	'2019-03-16 03:59:51',	'Pokrov',	'Pokrov',	'Pokrov'),
(507977,	185,	499068,	'Подстёпки',	'Podstepki',	'Podstepki',	1,	38453,	'2019-03-16 03:59:51',	'Podstepki',	'Podstepki',	'Podstepki'),
(508034,	185,	536199,	'Подпорожье',	'Podporozh\'ye',	'Podporozh\'ye',	1,	38452,	'2019-03-16 03:59:51',	'Podporozh\'ye',	'Podporozh\'ye',	'Podporozh\'ye'),
(508050,	185,	555235,	'Подозёрский',	'Podozerskiy',	'Podozerskiy',	1,	38451,	'2019-03-16 03:59:51',	'Podozerskiy',	'Podozerskiy',	'Podozerskiy'),
(508101,	185,	524925,	'Подольск',	'Podol\'sk',	'Podol\'sk',	1,	38450,	'2019-03-16 03:59:51',	'Podol\'sk',	'Podol\'sk',	'Podol\'sk'),
(509029,	185,	555235,	'Плёс',	'Ples',	'Ples',	1,	38286,	'2019-03-16 03:59:51',	'Ples',	'Ples',	'Ples'),
(509234,	185,	552548,	'Питкяранта',	'Pitkyaranta',	'Pitkyaranta',	1,	38083,	'2019-03-16 03:59:51',	'Pitkyaranta',	'Pitkyaranta',	'Pitkyaranta'),
(509597,	185,	536199,	'Пикалево',	'Pikalevo',	'Pikalevo',	1,	37888,	'2019-03-16 03:59:51',	'Pikalevo',	'Pikalevo',	'Pikalevo'),
(509820,	185,	552548,	'Петрозаводск',	'Petrozavodsk',	'Petrozavodsk',	1,	37621,	'2019-03-16 03:59:51',	'Petrozavodsk',	'Petrozavodsk',	'Petrozavodsk'),
(510491,	185,	472755,	'Песковатка',	'Peskovatka',	'Peskovatka',	1,	37551,	'2019-03-16 03:59:51',	'Peskovatka',	'Peskovatka',	'Peskovatka'),
(510808,	185,	1490542,	'Первоуральск',	'Pervoural\'sk',	'Pervoural\'sk',	1,	37534,	'2019-03-16 03:59:51',	'Pervoural\'sk',	'Pervoural\'sk',	'Pervoural\'sk'),
(511002,	185,	559838,	'Первомайск',	'Pervomaysk',	'Pervomaysk',	1,	37533,	'2019-03-16 03:59:51',	'Pervomaysk',	'Pervomaysk',	'Pervomaysk'),
(511196,	185,	511180,	'Пермь',	'Perm',	'Perm',	1,	37449,	'2019-03-16 03:59:51',	'Perm',	'Perm',	'Perm'),
(511359,	185,	468898,	'Переславль-Залесский',	'Pereslavl\'-Zalesskiy',	'Pereslavl\'-Zalesskiy',	1,	37415,	'2019-03-16 03:59:51',	'Pereslavl\'-Zalesskiy',	'Pereslavl\'-Zalesskiy',	'Pereslavl\'-Zalesskiy'),
(511565,	185,	511555,	'Пенза',	'Penza',	'Penza',	1,	37379,	'2019-03-16 03:59:51',	'Penza',	'Penza',	'Penza'),
(511794,	185,	545854,	'Печора',	'Pechora',	'Pechora',	1,	37196,	'2019-03-16 03:59:51',	'Pechora',	'Pechora',	'Pechora'),
(512023,	185,	524925,	'Павловский Посад',	'Pavlovskiy Posad',	'Pavlovskiy Posad',	1,	37123,	'2019-03-16 03:59:51',	'Pavlovskiy Posad',	'Pavlovskiy Posad',	'Pavlovskiy Posad'),
(513042,	185,	472755,	'Палласовка',	'Pallasovka',	'Pallasovka',	1,	36719,	'2019-03-16 03:59:51',	'Pallasovka',	'Pallasovka',	'Pallasovka'),
(513095,	185,	555235,	'Палех',	'Palekh',	'Palekh',	1,	36697,	'2019-03-16 03:59:51',	'Palekh',	'Palekh',	'Palekh'),
(513898,	185,	536199,	'Отрадное',	'Otradnoye',	'Otradnoye',	1,	36374,	'2019-03-16 03:59:51',	'Otradnoye',	'Otradnoye',	'Otradnoye'),
(514706,	185,	511180,	'Оса',	'Osa',	'Osa',	1,	36219,	'2019-03-16 03:59:51',	'Osa',	'Osa',	'Osa'),
(514734,	185,	515001,	'Орск',	'Orsk',	'Orsk',	1,	36186,	'2019-03-16 03:59:51',	'Orsk',	'Orsk',	'Orsk'),
(514796,	185,	501165,	'Орловский',	'Orlovskiy',	'Orlovskiy',	1,	36135,	'2019-03-16 03:59:51',	'Orlovskiy',	'Orlovskiy',	'Orlovskiy'),
(515003,	185,	515001,	'Оренбург',	'Orenburg',	'Orenburg',	1,	36076,	'2019-03-16 03:59:51',	'Orenburg',	'Orenburg',	'Orenburg'),
(515012,	185,	514801,	'Орел',	'Orel',	'Orel',	1,	36072,	'2019-03-16 03:59:51',	'Orel',	'Orel',	'Orel'),
(515024,	185,	524925,	'Орехово-Зуево',	'Orekhovo-Zuyevo',	'Orekhovo-Zuyevo',	1,	36071,	'2019-03-16 03:59:51',	'Orekhovo-Zuyevo',	'Orekhovo-Zuyevo',	'Orekhovo-Zuyevo'),
(515098,	185,	511180,	'Орда',	'Orda',	'Orda',	1,	36050,	'2019-03-16 03:59:51',	'Orda',	'Orda',	'Orda'),
(515662,	185,	472755,	'Оленье',	'Olen\'ye',	'Olen\'ye',	1,	35814,	'2019-03-16 03:59:51',	'Olen\'ye',	'Olen\'ye',	'Olen\'ye'),
(515698,	185,	524304,	'Оленегорск',	'Olenegorsk',	'Olenegorsk',	1,	35815,	'2019-03-16 03:59:51',	'Olenegorsk',	'Olenegorsk',	'Olenegorsk'),
(515873,	185,	524925,	'Октябрьский',	'Oktyabr\'skiy',	'Oktyabr\'skiy',	1,	35741,	'2019-03-16 03:59:51',	'Oktyabr\'skiy',	'Oktyabr\'skiy',	'Oktyabr\'skiy'),
(515879,	185,	578853,	'Октябрьский',	'Oktyabr\'skiy',	'Oktyabr\'skiy',	1,	35740,	'2019-03-16 03:59:51',	'Oktyabr\'skiy',	'Oktyabr\'skiy',	'Oktyabr\'skiy'),
(515909,	185,	472755,	'Октябрьский',	'Oktyabr\'skiy',	'Oktyabr\'skiy',	1,	35739,	'2019-03-16 03:59:51',	'Oktyabr\'skiy',	'Oktyabr\'skiy',	'Oktyabr\'skiy'),
(516215,	185,	524925,	'Одинцово',	'Odintsovo',	'Odintsovo',	1,	35603,	'2019-03-16 03:59:51',	'Odintsovo',	'Odintsovo',	'Odintsovo'),
(516256,	185,	511180,	'Очер',	'Ocher',	'Ocher',	1,	35555,	'2019-03-16 03:59:51',	'Ocher',	'Ocher',	'Ocher'),
(516436,	185,	553899,	'Обнинск',	'Obninsk',	'Obninsk',	1,	35524,	'2019-03-16 03:59:51',	'Obninsk',	'Obninsk',	'Obninsk'),
(516576,	185,	511180,	'Нытва',	'Nytva',	'Nytva',	1,	35278,	'2019-03-16 03:59:51',	'Nytva',	'Nytva',	'Nytva'),
(516875,	185,	472755,	'Новый Рогачик',	'Novyy Rogachik',	'Novyy Rogachik',	1,	35195,	'2019-03-16 03:59:51',	'Novyy Rogachik',	'Novyy Rogachik',	'Novyy Rogachik'),
(516931,	185,	578071,	'Новый Оскол',	'Novyy Oskol',	'Novyy Oskol',	1,	35194,	'2019-03-16 03:59:51',	'Novyy Oskol',	'Novyy Oskol',	'Novyy Oskol'),
(517716,	185,	472039,	'Нововоронеж',	'Novovoronezh',	'Novovoronezh',	1,	35192,	'2019-03-16 03:59:51',	'Novovoronezh',	'Novovoronezh',	'Novovoronezh'),
(517761,	185,	554230,	'Новоуральск',	'Novoural\'sk',	'Novoural\'sk',	1,	35189,	'2019-03-16 03:59:51',	'Novoural\'sk',	'Novoural\'sk',	'Novoural\'sk'),
(517836,	185,	515001,	'Новотроицк',	'Novotroitsk',	'Novotroitsk',	1,	35187,	'2019-03-16 03:59:51',	'Novotroitsk',	'Novotroitsk',	'Novotroitsk'),
(517963,	185,	501165,	'Новошахтинск',	'Novoshakhtinsk',	'Novoshakhtinsk',	1,	35184,	'2019-03-16 03:59:51',	'Novoshakhtinsk',	'Novoshakhtinsk',	'Novoshakhtinsk'),
(518255,	185,	542415,	'Новороссийск',	'Novorossiysk',	'Novorossiysk',	1,	35183,	'2019-03-16 03:59:51',	'Novorossiysk',	'Novorossiysk',	'Novorossiysk'),
(518488,	185,	472755,	'Новониколаевский',	'Novonikolayevskiy',	'Novonikolayevskiy',	1,	35182,	'2019-03-16 03:59:51',	'Novonikolayevskiy',	'Novonikolayevskiy',	'Novonikolayevskiy'),
(518557,	185,	480508,	'Новомосковск',	'Novomoskovsk',	'Novomoskovsk',	1,	35181,	'2019-03-16 03:59:51',	'Novomoskovsk',	'Novomoskovsk',	'Novomoskovsk'),
(518602,	185,	500059,	'Новомичуринск',	'Novomichurinsk',	'Novomichurinsk',	1,	35179,	'2019-03-16 03:59:51',	'Novomichurinsk',	'Novomichurinsk',	'Novomichurinsk'),
(518659,	185,	499068,	'Новокуйбышевск',	'Novokuybyshevsk',	'Novokuybyshevsk',	1,	35175,	'2019-03-16 03:59:51',	'Novokuybyshevsk',	'Novokuybyshevsk',	'Novokuybyshevsk'),
(518682,	185,	542415,	'Новокубанск',	'Novokubansk',	'Novokubansk',	1,	35174,	'2019-03-16 03:59:51',	'Novokubansk',	'Novokubansk',	'Novokubansk'),
(518970,	185,	501165,	'Новочеркасск',	'Novocherkassk',	'Novocherkassk',	1,	35170,	'2019-03-16 03:59:51',	'Novocherkassk',	'Novocherkassk',	'Novocherkassk'),
(518976,	185,	567395,	'Новочебоксарск',	'Novocheboksarsk',	'Novocheboksarsk',	1,	35169,	'2019-03-16 03:59:51',	'Novocheboksarsk',	'Novocheboksarsk',	'Novocheboksarsk'),
(519062,	185,	472755,	'Новоаннинский',	'Novoanninskiy',	'Novoanninskiy',	1,	35168,	'2019-03-16 03:59:51',	'Novoanninskiy',	'Novoanninskiy',	'Novoanninskiy'),
(519336,	185,	519324,	'Великий Новгород',	'Velikiy Novgorod',	'Velikiy Novgorod',	1,	51095,	'2019-03-16 03:59:51',	'Velikiy Novgorod',	'Velikiy Novgorod',	'Velikiy Novgorod'),
(520068,	185,	524925,	'Ногинск',	'Noginsk',	'Noginsk',	1,	34728,	'2019-03-16 03:59:51',	'Noginsk',	'Noginsk',	'Noginsk'),
(520204,	185,	1490542,	'Нижняя Тура',	'Nizhnyaya Tura',	'Nizhnyaya Tura',	1,	34681,	'2019-03-16 03:59:51',	'Nizhnyaya Tura',	'Nizhnyaya Tura',	'Nizhnyaya Tura'),
(520494,	185,	1490542,	'Нижний Тагил',	'Nizhniy Tagil',	'Nizhniy Tagil',	1,	34679,	'2019-03-16 03:59:51',	'Nizhniy Tagil',	'Nizhniy Tagil',	'Nizhniy Tagil'),
(520555,	185,	559838,	'Нижний Новгород',	'Nizhniy Novgorod',	'Nizhniy Novgorod',	1,	34678,	'2019-03-16 03:59:51',	'Nizhniy Novgorod',	'Nizhniy Novgorod',	'Nizhniy Novgorod'),
(520806,	185,	552927,	'Нижний Архыз',	'Nizhniy Arkhyz',	'Nizhniy Arkhyz',	1,	34677,	'2019-03-16 03:59:51',	'Nizhniy Arkhyz',	'Nizhniy Arkhyz',	'Nizhniy Arkhyz'),
(521118,	185,	484048,	'Нижнекамск',	'Nizhnekamsk',	'Nizhnekamsk',	1,	34674,	'2019-03-16 03:59:51',	'Nizhnekamsk',	'Nizhnekamsk',	'Nizhnekamsk'),
(521509,	185,	536199,	'Никольское',	'Nikol\'skoye',	'Nikol\'skoye',	1,	34627,	'2019-03-16 03:59:51',	'Nikol\'skoye',	'Nikol\'skoye',	'Nikol\'skoye'),
(521821,	185,	524925,	'Николина Гора',	'Nikolina Gora',	'Nikolina Gora',	1,	34630,	'2019-03-16 03:59:51',	'Nikolina Gora',	'Nikolina Gora',	'Nikolina Gora'),
(521874,	185,	472755,	'Николаевск',	'Nikolayevsk',	'Nikolayevsk',	1,	34628,	'2019-03-16 03:59:51',	'Nikolayevsk',	'Nikolayevsk',	'Nikolayevsk'),
(522353,	185,	543871,	'Нея',	'Neya',	'Neya',	1,	34475,	'2019-03-16 03:59:51',	'Neya',	'Neya',	'Neya'),
(522377,	185,	487839,	'Невинномысск',	'Nevinnomyssk',	'Nevinnomyssk',	1,	34090,	'2019-03-16 03:59:51',	'Nevinnomyssk',	'Nevinnomyssk',	'Nevinnomyssk'),
(522594,	185,	543871,	'Нерехта',	'Nerekhta',	'Nerekhta',	1,	33816,	'2019-03-16 03:59:51',	'Nerekhta',	'Nerekhta',	'Nerekhta'),
(522902,	185,	472755,	'Нехаевский',	'Nekhayevskiy',	'Nekhayevskiy',	1,	33778,	'2019-03-16 03:59:51',	'Nekhayevskiy',	'Nekhayevskiy',	'Nekhayevskiy'),
(522911,	185,	480041,	'Неготино',	'Negotino',	'Negotino',	1,	33757,	'2019-03-16 03:59:51',	'Negotino',	'Negotino',	'Negotino'),
(522942,	185,	578853,	'Нефтекамск',	'Neftekamsk',	'Neftekamsk',	1,	33752,	'2019-03-16 03:59:51',	'Neftekamsk',	'Neftekamsk',	'Neftekamsk'),
(522945,	185,	499068,	'Нефтегорск',	'Neftegorsk',	'Neftegorsk',	1,	33751,	'2019-03-16 03:59:51',	'Neftegorsk',	'Neftegorsk',	'Neftegorsk'),
(523064,	185,	556349,	'Назрань',	'Nazran\'',	'Nazran\'',	1,	33697,	'2019-03-16 03:59:51',	'Nazran\'',	'Nazran\'',	'Nazran\''),
(523136,	185,	552548,	'Найстенъярви',	'Naysten\"yarvi',	'Naysten\"yarvi',	1,	33691,	'2019-03-16 03:59:51',	'Naysten\"yarvi',	'Naysten\"yarvi',	'Naysten\"yarvi'),
(523186,	185,	571473,	'Навля',	'Navlya',	'Navlya',	1,	33685,	'2019-03-16 03:59:51',	'Navlya',	'Navlya',	'Navlya'),
(523198,	185,	559838,	'Навашино',	'Navashino',	'Navashino',	1,	33675,	'2019-03-16 03:59:51',	'Navashino',	'Navashino',	'Navashino'),
(523392,	185,	522652,	'Нарьян-Мар',	'Nar\'yan-Mar',	'Nar\'yan-Mar',	1,	33564,	'2019-03-16 03:59:51',	'Nar\'yan-Mar',	'Nar\'yan-Mar',	'Nar\'yan-Mar'),
(523426,	185,	524925,	'Наро-Фоминск',	'Naro-Fominsk',	'Naro-Fominsk',	1,	33577,	'2019-03-16 03:59:51',	'Naro-Fominsk',	'Naro-Fominsk',	'Naro-Fominsk'),
(523523,	185,	554667,	'Нальчик',	'Nal\'chik',	'Nal\'chik',	1,	33500,	'2019-03-16 03:59:51',	'Nal\'chik',	'Nal\'chik',	'Nal\'chik'),
(523553,	185,	524925,	'Нахабино',	'Nakhabino',	'Nakhabino',	1,	33496,	'2019-03-16 03:59:51',	'Nakhabino',	'Nakhabino',	'Nakhabino'),
(523734,	185,	580491,	'Началово',	'Nachalovo',	'Nachalovo',	1,	33457,	'2019-03-16 03:59:51',	'Nachalovo',	'Nachalovo',	'Nachalovo'),
(523750,	185,	484048,	'Набережные Челны',	'Naberezhnyye Chelny',	'Naberezhnyye Chelny',	1,	33454,	'2019-03-16 03:59:51',	'Naberezhnyye Chelny',	'Naberezhnyye Chelny',	'Naberezhnyye Chelny'),
(523811,	185,	524925,	'Мытищи',	'Mytishchi',	'Mytishchi',	1,	33449,	'2019-03-16 03:59:51',	'Mytishchi',	'Mytishchi',	'Mytishchi'),
(523859,	185,	468898,	'Мышкин',	'Myshkin',	'Myshkin',	1,	33443,	'2019-03-16 03:59:51',	'Myshkin',	'Myshkin',	'Myshkin'),
(524100,	185,	552548,	'Муезерский',	'Muyezerskiy',	'Muyezerskiy',	1,	33423,	'2019-03-16 03:59:51',	'Muyezerskiy',	'Muyezerskiy',	'Muyezerskiy'),
(524113,	185,	567293,	'Муцалаул',	'Mutsalaul',	'Mutsalaul',	1,	33418,	'2019-03-16 03:59:51',	'Mutsalaul',	'Mutsalaul',	'Mutsalaul'),
(524294,	185,	826294,	'Муром',	'Murom',	'Murom',	1,	33370,	'2019-03-16 03:59:51',	'Murom',	'Murom',	'Murom'),
(524299,	185,	524304,	'Мурмаши',	'Murmashi',	'Murmashi',	1,	33364,	'2019-03-16 03:59:51',	'Murmashi',	'Murmashi',	'Murmashi'),
(524305,	185,	524304,	'Мурманск',	'Murmansk',	'Murmansk',	1,	33363,	'2019-03-16 03:59:51',	'Murmansk',	'Murmansk',	'Murmansk'),
(524712,	185,	524925,	'Можайск',	'Mozhaysk',	'Mozhaysk',	1,	33196,	'2019-03-16 03:59:51',	'Mozhaysk',	'Mozhaysk',	'Mozhaysk'),
(524901,	185,	524894,	'Москва',	'Moscow',	'Moscow',	1,	32909,	'2019-03-16 03:59:51',	'Moscú',	'موسكو',	'Moscow'),
(525162,	185,	501165,	'Морозовск',	'Morozovsk',	'Morozovsk',	1,	32817,	'2019-03-16 03:59:51',	'Morozovsk',	'Morozovsk',	'Morozovsk'),
(525404,	185,	524304,	'Мончегорск',	'Monchegorsk',	'Monchegorsk',	1,	31923,	'2019-03-16 03:59:51',	'Monchegorsk',	'Monchegorsk',	'Monchegorsk'),
(526480,	185,	487839,	'Минеральные Воды',	'Mineralnye Vody',	'Mineralnye Vody',	1,	31556,	'2019-03-16 03:59:51',	'Mineralnye Vody',	'Mineralnye Vody',	'Mineralnye Vody'),
(526558,	185,	501165,	'Миллерово',	'Millerovo',	'Millerovo',	1,	31417,	'2019-03-16 03:59:51',	'Millerovo',	'Millerovo',	'Millerovo'),
(526565,	185,	524925,	'Мильково',	'Mil\'kovo',	'Mil\'kovo',	1,	31325,	'2019-03-16 03:59:51',	'Mil\'kovo',	'Mil\'kovo',	'Mil\'kovo'),
(526600,	185,	545854,	'Микунь',	'Mikun\'',	'Mikun\'',	1,	31324,	'2019-03-16 03:59:51',	'Mikun\'',	'Mikun\'',	'Mikun\''),
(526651,	185,	524925,	'Михнево',	'Mikhnevo',	'Mikhnevo',	1,	31323,	'2019-03-16 03:59:51',	'Mikhnevo',	'Mikhnevo',	'Mikhnevo'),
(527012,	185,	472755,	'Михайловка',	'Mikhaylovka',	'Mikhaylovka',	1,	31321,	'2019-03-16 03:59:51',	'Mikhaylovka',	'Mikhaylovka',	'Mikhaylovka'),
(527191,	185,	484638,	'Мичуринск',	'Michurinsk',	'Michurinsk',	1,	31204,	'2019-03-16 03:59:51',	'Michurinsk',	'Michurinsk',	'Michurinsk'),
(527579,	185,	484048,	'Менделеевск',	'Mendeleyevsk',	'Mendeleyevsk',	1,	30792,	'2019-03-16 03:59:51',	'Mendeleyevsk',	'Mendeleyevsk',	'Mendeleyevsk'),
(527888,	185,	552548,	'Медвежьегорск',	'Medvezh\'yegorsk',	'Medvezh\'yegorsk',	1,	30631,	'2019-03-16 03:59:51',	'Medvezh\'yegorsk',	'Medvezh\'yegorsk',	'Medvezh\'yegorsk'),
(527955,	185,	524925,	'Медвежьи Озёра',	'Medvezh\'i Ozera',	'Medvezh\'i Ozera',	1,	30630,	'2019-03-16 03:59:51',	'Medvezh\'i Ozera',	'Medvezh\'i Ozera',	'Medvezh\'i Ozera'),
(528109,	185,	515001,	'Медногорск',	'Mednogorsk',	'Mednogorsk',	1,	30621,	'2019-03-16 03:59:51',	'Mednogorsk',	'Mednogorsk',	'Mednogorsk'),
(528293,	185,	584222,	'Майкоп',	'Maykop',	'Maykop',	1,	30394,	'2019-03-16 03:59:51',	'Maykop',	'Maykop',	'Maykop'),
(528495,	185,	501165,	'Матвеев Курган',	'Matveyev Kurgan',	'Matveyev Kurgan',	1,	30291,	'2019-03-16 03:59:51',	'Matveyev Kurgan',	'Matveyev Kurgan',	'Matveyev Kurgan'),
(529073,	185,	498671,	'Маркс',	'Marks',	'Marks',	1,	29892,	'2019-03-16 03:59:51',	'Marks',	'Marks',	'Marks'),
(530849,	185,	553899,	'Малоярославец',	'Maloyaroslavets',	'Maloyaroslavets',	1,	29357,	'2019-03-16 03:59:51',	'Maloyaroslavets',	'Maloyaroslavets',	'Maloyaroslavets'),
(531660,	185,	504338,	'Малая Губа',	'Malaya Guba',	'Malaya Guba',	1,	29298,	'2019-03-16 03:59:51',	'Malaya Guba',	'Malaya Guba',	'Malaya Guba'),
(531820,	185,	524925,	'Малаховка',	'Malakhovka',	'Malakhovka',	1,	29282,	'2019-03-16 03:59:51',	'Malakhovka',	'Malakhovka',	'Malakhovka'),
(532096,	185,	567293,	'Махачкала',	'Makhachkala',	'Makhachkala',	1,	29267,	'2019-03-16 03:59:51',	'Makhachkala',	'Makhachkala',	'Makhachkala'),
(532138,	185,	543871,	'Макарьев',	'Makar\'yev',	'Makar\'yev',	1,	29265,	'2019-03-16 03:59:51',	'Makar\'yev',	'Makar\'yev',	'Makar\'yev'),
(532288,	185,	1508290,	'Магнитогорск',	'Magnitogorsk',	'Magnitogorsk',	1,	29148,	'2019-03-16 03:59:51',	'Magnitogorsk',	'Magnitogorsk',	'Magnitogorsk'),
(532615,	185,	524925,	'Люберцы',	'Lyubertsy',	'Lyubertsy',	1,	28998,	'2019-03-16 03:59:51',	'Lyubertsy',	'Lyubertsy',	'Lyubertsy'),
(532657,	185,	524925,	'Лыткарино',	'Lytkarino',	'Lytkarino',	1,	28995,	'2019-03-16 03:59:51',	'Lytkarino',	'Lytkarino',	'Lytkarino'),
(532675,	185,	511180,	'Лысьва',	'Lys\'va',	'Lys\'va',	1,	28991,	'2019-03-16 03:59:51',	'Lys\'va',	'Lys\'va',	'Lys\'va'),
(532715,	185,	559838,	'Лысково',	'Lyskovo',	'Lyskovo',	1,	28992,	'2019-03-16 03:59:51',	'Lyskovo',	'Lyskovo',	'Lyskovo'),
(533543,	185,	524925,	'Луховицы',	'Lukhovitsy',	'Lukhovitsy',	1,	28791,	'2019-03-16 03:59:51',	'Lukhovitsy',	'Lukhovitsy',	'Lukhovitsy'),
(533690,	185,	536199,	'Луга',	'Luga',	'Luga',	1,	28767,	'2019-03-16 03:59:51',	'Luga',	'Luga',	'Luga'),
(534015,	185,	524925,	'Лосино-Петровский',	'Losino-Petrovskiy',	'Losino-Petrovskiy',	1,	28519,	'2019-03-16 03:59:51',	'Losino-Petrovskiy',	'Losino-Petrovskiy',	'Losino-Petrovskiy'),
(534127,	185,	536199,	'Лопухинка',	'Lopukhinka',	'Lopukhinka',	1,	28427,	'2019-03-16 03:59:51',	'Lopukhinka',	'Lopukhinka',	'Lopukhinka'),
(534595,	185,	524925,	'Лобня',	'Lobnya',	'Lobnya',	1,	28137,	'2019-03-16 03:59:51',	'Lobnya',	'Lobnya',	'Lobnya'),
(534701,	185,	514801,	'Ливны',	'Livny',	'Livny',	1,	28050,	'2019-03-16 03:59:51',	'Livny',	'Livny',	'Livny'),
(535121,	185,	535120,	'Липецк',	'Lipetsk',	'Lipetsk',	1,	27915,	'2019-03-16 03:59:51',	'Lipetsk',	'Lipetsk',	'Lipetsk'),
(535695,	185,	524925,	'Лесной Городок',	'Lesnoy Gorodok',	'Lesnoy Gorodok',	1,	27459,	'2019-03-16 03:59:51',	'Lesnoy Gorodok',	'Lesnoy Gorodok',	'Lesnoy Gorodok'),
(535741,	185,	524925,	'Лесной',	'Lesnoy',	'Lesnoy',	1,	27457,	'2019-03-16 03:59:51',	'Lesnoy',	'Lesnoy',	'Lesnoy'),
(535886,	185,	487839,	'Лермонтов',	'Lermontov',	'Lermontov',	1,	27290,	'2019-03-16 03:59:51',	'Lermontov',	'Lermontov',	'Lermontov'),
(536156,	185,	472755,	'Ленинск',	'Leninsk',	'Leninsk',	1,	27209,	'2019-03-16 03:59:51',	'Leninsk',	'Leninsk',	'Leninsk'),
(536162,	185,	484048,	'Лениногорск',	'Leninogorsk',	'Leninogorsk',	1,	27208,	'2019-03-16 03:59:51',	'Leninogorsk',	'Leninogorsk',	'Leninogorsk'),
(536206,	185,	524925,	'Юбилейный',	'Yubileyny',	'Yubileyny',	1,	54985,	'2019-03-16 03:59:51',	'Yubileyny',	'Yubileyny',	'Yubileyny'),
(536518,	185,	535120,	'Лебедянь',	'Lebedyan\'',	'Lebedyan\'',	1,	27002,	'2019-03-16 03:59:51',	'Lebedyan\'',	'Lebedyan\'',	'Lebedyan\''),
(537737,	185,	511555,	'Кузнецк',	'Kuznetsk',	'Kuznetsk',	1,	25063,	'2019-03-16 03:59:51',	'Kuznetsk',	'Kuznetsk',	'Kuznetsk'),
(538104,	185,	480041,	'Кувшиново',	'Kuvshinovo',	'Kuvshinovo',	1,	25060,	'2019-03-16 03:59:51',	'Kuvshinovo',	'Kuvshinovo',	'Kuvshinovo'),
(538340,	185,	1490542,	'Кушва',	'Kushva',	'Kushva',	1,	25051,	'2019-03-16 03:59:51',	'Kushva',	'Kushva',	'Kushva'),
(538560,	185,	538555,	'Курск',	'Kursk',	'Kursk',	1,	25044,	'2019-03-16 03:59:51',	'Kursk',	'Kursk',	'Kursk'),
(538601,	185,	524925,	'Куровское',	'Kurovskoye',	'Kurovskoye',	1,	25043,	'2019-03-16 03:59:51',	'Kurovskoye',	'Kurovskoye',	'Kurovskoye'),
(538908,	185,	538555,	'Курчатов',	'Kurchatov',	'Kurchatov',	1,	25033,	'2019-03-16 03:59:51',	'Kurchatov',	'Kurchatov',	'Kurchatov'),
(539147,	185,	511180,	'Кунгур',	'Kungur',	'Kungur',	1,	25020,	'2019-03-16 03:59:51',	'Kungur',	'Kungur',	'Kungur'),
(539283,	185,	578853,	'Кумертау',	'Kumertau',	'Kumertau',	1,	25012,	'2019-03-16 03:59:51',	'Kumertau',	'Kumertau',	'Kumertau'),
(539369,	185,	511180,	'Култаево',	'Kultayevo',	'Kultayevo',	1,	25006,	'2019-03-16 03:59:51',	'Kultayevo',	'Kultayevo',	'Kultayevo'),
(539555,	185,	559838,	'Кулебаки',	'Kulebaki',	'Kulebaki',	1,	25000,	'2019-03-16 03:59:51',	'Kulebaki',	'Kulebaki',	'Kulebaki'),
(539817,	185,	511180,	'Кудымкар',	'Kudymkar',	'Kudymkar',	1,	24985,	'2019-03-16 03:59:51',	'Kudymkar',	'Kudymkar',	'Kudymkar'),
(539839,	185,	536199,	'Кудрово',	'Kudrovo',	'Kudrovo',	1,	24984,	'2019-03-16 03:59:51',	'Kudrovo',	'Kudrovo',	'Kudrovo'),
(540030,	185,	524925,	'Кубинка',	'Kubinka',	'Kubinka',	1,	24979,	'2019-03-16 03:59:51',	'Kubinka',	'Kubinka',	'Kubinka'),
(540103,	185,	559838,	'Кстово',	'Kstovo',	'Kstovo',	1,	24976,	'2019-03-16 03:59:51',	'Kstovo',	'Kstovo',	'Kstovo'),
(540251,	185,	542415,	'Крымск',	'Krymsk',	'Krymsk',	1,	24974,	'2019-03-16 03:59:51',	'Krymsk',	'Krymsk',	'Krymsk'),
(541245,	185,	524925,	'Крёкшино',	'Krekshino',	'Krekshino',	1,	24917,	'2019-03-16 03:59:51',	'Krekshino',	'Krekshino',	'Krekshino'),
(541337,	185,	499068,	'Красный Яр',	'Krasnyy Yar',	'Krasnyy Yar',	1,	24905,	'2019-03-16 03:59:51',	'Krasnyy Yar',	'Krasnyy Yar',	'Krasnyy Yar'),
(541404,	185,	501165,	'Красный Сулин',	'Krasnyy Sulin',	'Krasnyy Sulin',	1,	24904,	'2019-03-16 03:59:51',	'Krasnyy Sulin',	'Krasnyy Sulin',	'Krasnyy Sulin'),
(541582,	185,	472755,	'Красный Октябрь',	'Krasnyy Oktyabr\'',	'Krasnyy Oktyabr\'',	1,	24903,	'2019-03-16 03:59:51',	'Krasnyy Oktyabr\'',	'Krasnyy Oktyabr\'',	'Krasnyy Oktyabr\''),
(542024,	185,	543871,	'Красное-на-Волге',	'Krasnoye-na-Volge',	'Krasnoye-na-Volge',	1,	24899,	'2019-03-16 03:59:51',	'Krasnoye-na-Volge',	'Krasnoye-na-Volge',	'Krasnoye-na-Volge'),
(542184,	185,	511180,	'Красновишерск',	'Krasnovishersk',	'Krasnovishersk',	1,	24897,	'2019-03-16 03:59:51',	'Krasnovishersk',	'Krasnovishersk',	'Krasnovishersk'),
(542199,	185,	1490542,	'Красноуфимск',	'Krasnoufimsk',	'Krasnoufimsk',	1,	24895,	'2019-03-16 03:59:51',	'Krasnoufimsk',	'Krasnoufimsk',	'Krasnoufimsk'),
(542213,	185,	472755,	'Краснослободск',	'Krasnoslobodsk',	'Krasnoslobodsk',	1,	24893,	'2019-03-16 03:59:51',	'Krasnoslobodsk',	'Krasnoslobodsk',	'Krasnoslobodsk'),
(542327,	185,	511180,	'Краснокамск',	'Krasnokamsk',	'Krasnokamsk',	1,	24891,	'2019-03-16 03:59:51',	'Krasnokamsk',	'Krasnokamsk',	'Krasnokamsk'),
(542374,	185,	524925,	'Красногорск',	'Krasnogorsk',	'Krasnogorsk',	1,	24887,	'2019-03-16 03:59:51',	'Krasnogorsk',	'Krasnogorsk',	'Krasnogorsk'),
(542420,	185,	542415,	'Краснодар',	'Krasnodar',	'Krasnodar',	1,	24885,	'2019-03-16 03:59:51',	'Krasnodar',	'Krasnodar',	'Krasnodar'),
(542463,	185,	524925,	'Красноармейск',	'Krasnoarmeysk',	'Krasnoarmeysk',	1,	24883,	'2019-03-16 03:59:51',	'Krasnoarmeysk',	'Krasnoarmeysk',	'Krasnoarmeysk'),
(542464,	185,	498671,	'Красноармейск',	'Krasnoarmeysk',	'Krasnoarmeysk',	1,	24882,	'2019-03-16 03:59:51',	'Krasnoarmeysk',	'Krasnoarmeysk',	'Krasnoarmeysk'),
(543460,	185,	826294,	'Ковров',	'Kovrov',	'Kovrov',	1,	24860,	'2019-03-16 03:59:51',	'Kovrov',	'Kovrov',	'Kovrov'),
(543508,	185,	524304,	'Kovdor',	'Kovdor',	'Kovdor',	1,	24857,	'2019-03-16 03:59:51',	'Kovdor',	'Kovdor',	'Kovdor'),
(543605,	185,	484638,	'Котовск',	'Kotovsk',	'Kotovsk',	1,	24845,	'2019-03-16 03:59:51',	'Kotovsk',	'Kotovsk',	'Kotovsk'),
(543633,	185,	472755,	'Котово',	'Kotovo',	'Kotovo',	1,	24844,	'2019-03-16 03:59:51',	'Kotovo',	'Kotovo',	'Kotovo'),
(543681,	185,	472755,	'Котлубань',	'Kotluban\'',	'Kotluban\'',	1,	24843,	'2019-03-16 03:59:51',	'Kotluban\'',	'Kotluban\'',	'Kotluban\''),
(543704,	185,	581043,	'Котлас',	'Kotlas',	'Kotlas',	1,	24841,	'2019-03-16 03:59:51',	'Kotlas',	'Kotlas',	'Kotlas'),
(543728,	185,	472755,	'Котельниково',	'Kotel\'nikovo',	'Kotel\'nikovo',	1,	24838,	'2019-03-16 03:59:51',	'Kotel\'nikovo',	'Kotel\'nikovo',	'Kotel\'nikovo'),
(543731,	185,	524925,	'Котельники',	'Kotel\'niki',	'Kotel\'niki',	1,	24837,	'2019-03-16 03:59:51',	'Kotel\'niki',	'Kotel\'niki',	'Kotel\'niki'),
(543878,	185,	543871,	'Кострома',	'Kostroma',	'Kostroma',	1,	24831,	'2019-03-16 03:59:51',	'Kostroma',	'Kostroma',	'Kostroma'),
(544370,	185,	581043,	'Коряжма',	'Koryazhma',	'Koryazhma',	1,	24818,	'2019-03-16 03:59:51',	'Koryazhma',	'Koryazhma',	'Koryazhma'),
(545277,	185,	501165,	'Константиновск',	'Konstantinovsk',	'Konstantinovsk',	1,	24787,	'2019-03-16 03:59:51',	'Konstantinovsk',	'Konstantinovsk',	'Konstantinovsk'),
(545284,	185,	524925,	'Константиново',	'Konstantinovo',	'Konstantinovo',	1,	24786,	'2019-03-16 03:59:51',	'Konstantinovo',	'Konstantinovo',	'Konstantinovo'),
(545626,	185,	552548,	'Кондопога',	'Kondopoga',	'Kondopoga',	1,	24754,	'2019-03-16 03:59:51',	'Kondopoga',	'Kondopoga',	'Kondopoga'),
(545673,	185,	480041,	'Конаково',	'Konakovo',	'Konakovo',	1,	24753,	'2019-03-16 03:59:51',	'Konakovo',	'Konakovo',	'Konakovo'),
(546105,	185,	536203,	'Колпино',	'Kolpino',	'Kolpino',	1,	24747,	'2019-03-16 03:59:51',	'Kolpino',	'Kolpino',	'Kolpino'),
(546230,	185,	524925,	'Коломна',	'Kolomna',	'Kolomna',	1,	24745,	'2019-03-16 03:59:51',	'Kolomna',	'Kolomna',	'Kolomna'),
(546374,	185,	555235,	'Колобово',	'Kolobovo',	'Kolobovo',	1,	24744,	'2019-03-16 03:59:51',	'Kolobovo',	'Kolobovo',	'Kolobovo'),
(546521,	185,	826294,	'Кольчугино',	'Kol\'chugino',	'Kol\'chugino',	1,	24729,	'2019-03-16 03:59:51',	'Kol\'chugino',	'Kol\'chugino',	'Kol\'chugino'),
(547523,	185,	524925,	'Клин',	'Klin',	'Klin',	1,	24635,	'2019-03-16 03:59:51',	'Klin',	'Klin',	'Klin'),
(547560,	185,	524925,	'Климовск',	'Klimovsk',	'Klimovsk',	1,	24634,	'2019-03-16 03:59:51',	'Klimovsk',	'Klimovsk',	'Klimovsk'),
(547840,	185,	567293,	'Кизляр',	'Kizlyar',	'Kizlyar',	1,	24575,	'2019-03-16 03:59:51',	'Kizlyar',	'Kizlyar',	'Kizlyar'),
(547849,	185,	567293,	'Кизилюрт',	'Kizilyurt',	'Kizilyurt',	1,	24574,	'2019-03-16 03:59:51',	'Kizilyurt',	'Kizilyurt',	'Kizilyurt'),
(547875,	185,	511180,	'Кизел',	'Kizel',	'Kizel',	1,	24573,	'2019-03-16 03:59:51',	'Kizel',	'Kizel',	'Kizel'),
(548114,	185,	487839,	'Кисловодск',	'Kislovodsk',	'Kislovodsk',	1,	24552,	'2019-03-16 03:59:51',	'Kislovodsk',	'Kislovodsk',	'Kislovodsk'),
(548278,	185,	826294,	'Киржач',	'Kirzhach',	'Kirzhach',	1,	24546,	'2019-03-16 03:59:51',	'Kirzhach',	'Kirzhach',	'Kirzhach'),
(548391,	185,	524304,	'Кировск',	'Kirovsk',	'Kirovsk',	1,	24532,	'2019-03-16 03:59:51',	'Kirovsk',	'Kirovsk',	'Kirovsk'),
(548392,	185,	536199,	'Кировск',	'Kirovsk',	'Kirovsk',	1,	24533,	'2019-03-16 03:59:51',	'Kirovsk',	'Kirovsk',	'Kirovsk'),
(548395,	185,	548389,	'Кирово-Чепецк',	'Kirovo-Chepetsk',	'Kirovo-Chepetsk',	1,	24530,	'2019-03-16 03:59:51',	'Kirovo-Chepetsk',	'Kirovo-Chepetsk',	'Kirovo-Chepetsk'),
(548408,	185,	548389,	'Киров',	'Kirov',	'Kirov',	1,	24528,	'2019-03-16 03:59:51',	'Kirov',	'Kirov',	'Kirov'),
(548442,	185,	536199,	'Кириши',	'Kirishi',	'Kirishi',	1,	24498,	'2019-03-16 03:59:51',	'Kirishi',	'Kirishi',	'Kirishi'),
(548478,	185,	472454,	'Кириллов',	'Kirillov',	'Kirillov',	1,	24497,	'2019-03-16 03:59:51',	'Kirillov',	'Kirillov',	'Kirillov'),
(548602,	185,	536199,	'Кингисепп',	'Kingisepp',	'Kingisepp',	1,	24357,	'2019-03-16 03:59:51',	'Kingisepp',	'Kingisepp',	'Kingisepp'),
(548605,	185,	555235,	'Кинешма',	'Kineshma',	'Kineshma',	1,	24339,	'2019-03-16 03:59:51',	'Kineshma',	'Kineshma',	'Kineshma'),
(548652,	185,	480041,	'Кимры',	'Kimry',	'Kimry',	1,	24324,	'2019-03-16 03:59:51',	'Kimry',	'Kimry',	'Kimry'),
(549531,	185,	524925,	'Хорлово',	'Khorlovo',	'Khorlovo',	1,	24249,	'2019-03-16 03:59:51',	'Khorlovo',	'Khorlovo',	'Khorlovo'),
(550280,	185,	524894,	'Химки',	'Khimki',	'Khimki',	1,	24242,	'2019-03-16 03:59:51',	'Khimki',	'Khimki',	'Khimki'),
(550478,	185,	567293,	'Хасавюрт',	'Khasavyurt',	'Khasavyurt',	1,	24235,	'2019-03-16 03:59:51',	'Khasavyurt',	'Khasavyurt',	'Khasavyurt'),
(551487,	185,	484048,	'Казань',	'Kazan',	'Kazan',	1,	23973,	'2019-03-16 03:59:51',	'Kazan',	'Kazan',	'Kazan'),
(551847,	185,	567293,	'Каспийск',	'Kaspiysk',	'Kaspiysk',	1,	23932,	'2019-03-16 03:59:51',	'Kaspiysk',	'Kaspiysk',	'Kaspiysk'),
(551891,	185,	500059,	'Касимов',	'Kasimov',	'Kasimov',	1,	23929,	'2019-03-16 03:59:51',	'Kasimov',	'Kasimov',	'Kasimov'),
(551964,	185,	524925,	'Кашира',	'Kashira',	'Kashira',	1,	23925,	'2019-03-16 03:59:51',	'Kashira',	'Kashira',	'Kashira'),
(552006,	185,	501165,	'Кашары',	'Kashary',	'Kashary',	1,	23924,	'2019-03-16 03:59:51',	'Kashary',	'Kashary',	'Kashary'),
(552244,	185,	472755,	'Карповка',	'Karpovka',	'Karpovka',	1,	23908,	'2019-03-16 03:59:51',	'Karpovka',	'Karpovka',	'Karpovka'),
(552887,	185,	511180,	'Карагай',	'Karagay',	'Karagay',	1,	23871,	'2019-03-16 03:59:51',	'Karagay',	'Karagay',	'Karagay'),
(553099,	185,	472039,	'Кантемировка',	'Kantemirovka',	'Kantemirovka',	1,	23851,	'2019-03-16 03:59:51',	'Kantemirovka',	'Kantemirovka',	'Kantemirovka'),
(553152,	185,	542415,	'Каневская',	'Kanevskaya',	'Kanevskaya',	1,	23832,	'2019-03-16 03:59:51',	'Kanevskaya',	'Kanevskaya',	'Kanevskaya'),
(553190,	185,	524304,	'Кандалакша',	'Kandalaksha',	'Kandalaksha',	1,	23825,	'2019-03-16 03:59:51',	'Kandalaksha',	'Kandalaksha',	'Kandalaksha'),
(553216,	185,	567395,	'Канаш',	'Kanash',	'Kanash',	1,	23821,	'2019-03-16 03:59:51',	'Kanash',	'Kanash',	'Kanash'),
(553287,	185,	472755,	'Камышин',	'Kamyshin',	'Kamyshin',	1,	23819,	'2019-03-16 03:59:51',	'Kamyshin',	'Kamyshin',	'Kamyshin'),
(553399,	185,	501165,	'Каменск-Шахтинский',	'Kamensk-Shakhtinskiy',	'Kamensk-Shakhtinskiy',	1,	23801,	'2019-03-16 03:59:51',	'Kamensk-Shakhtinskiy',	'Kamensk-Shakhtinskiy',	'Kamensk-Shakhtinskiy'),
(553427,	185,	501165,	'Каменоломни',	'Kamenolomni',	'Kamenolomni',	1,	23800,	'2019-03-16 03:59:51',	'Kamenolomni',	'Kamenolomni',	'Kamenolomni'),
(553884,	185,	480041,	'Калязин',	'Kalyazin',	'Kalyazin',	1,	23792,	'2019-03-16 03:59:51',	'Kalyazin',	'Kalyazin',	'Kalyazin'),
(553915,	185,	553899,	'Калуга',	'Kaluga',	'Kaluga',	1,	23788,	'2019-03-16 03:59:51',	'Kaluga',	'Kaluga',	'Kaluga'),
(554233,	185,	524925,	'Королёв',	'Korolev',	'Korolev',	1,	24811,	'2019-03-16 03:59:51',	'Korolev',	'Korolev',	'Korolev'),
(554234,	185,	554230,	'Калининград',	'Kaliningrad',	'Kaliningrad',	1,	23767,	'2019-03-16 03:59:51',	'Kaliningrad',	'Kaliningrad',	'Kaliningrad'),
(554397,	185,	472755,	'Калач-на-дону',	'Kalach-na-Donu',	'Kalach-na-Donu',	1,	23755,	'2019-03-16 03:59:51',	'Kalach-na-Donu',	'Kalach-na-Donu',	'Kalach-na-Donu'),
(554410,	185,	472039,	'Калач',	'Kalach',	'Kalach',	1,	23754,	'2019-03-16 03:59:51',	'Kalach',	'Kalach',	'Kalach'),
(554482,	185,	501165,	'Кагальницкая',	'Kagal\'nitskaya',	'Kagal\'nitskaya',	1,	23732,	'2019-03-16 03:59:51',	'Kagal\'nitskaya',	'Kagal\'nitskaya',	'Kagal\'nitskaya'),
(554599,	185,	1490542,	'Качканар',	'Kachkanar',	'Kachkanar',	1,	23720,	'2019-03-16 03:59:51',	'Kachkanar',	'Kachkanar',	'Kachkanar'),
(554840,	185,	479613,	'Ижевск',	'Izhevsk',	'Izhevsk',	1,	23220,	'2019-03-16 03:59:51',	'Izhevsk',	'Izhevsk',	'Izhevsk'),
(555111,	185,	524925,	'Ивантеевка',	'Ivanteyevka',	'Ivanteyevka',	1,	23194,	'2019-03-16 03:59:51',	'Ivanteyevka',	'Ivanteyevka',	'Ivanteyevka'),
(555312,	185,	555235,	'Иваново',	'Ivanovo',	'Ivanovo',	1,	23193,	'2019-03-16 03:59:51',	'Ivanovo',	'Ivanovo',	'Ivanovo'),
(555746,	185,	524925,	'Истра',	'Istra',	'Istra',	1,	23156,	'2019-03-16 03:59:51',	'Istra',	'Istra',	'Istra'),
(555980,	185,	578853,	'Ишимбай',	'Ishimbay',	'Ishimbay',	1,	23076,	'2019-03-16 03:59:51',	'Ishimbay',	'Ishimbay',	'Ishimbay'),
(556961,	185,	472755,	'Иловля',	'Ilovlya',	'Ilovlya',	1,	22801,	'2019-03-16 03:59:51',	'Ilovlya',	'Ilovlya',	'Ilovlya'),
(557775,	185,	826294,	'Гусь Хрустальный',	'Gus\'-Khrustal\'nyy',	'Gus\'-Khrustal\'nyy',	1,	20222,	'2019-03-16 03:59:51',	'Gus\'-Khrustal\'nyy',	'Gus\'-Khrustal\'nyy',	'Gus\'-Khrustal\'nyy'),
(557882,	185,	554230,	'Гусев',	'Gusev',	'Gusev',	1,	20224,	'2019-03-16 03:59:51',	'Gusev',	'Gusev',	'Gusev'),
(557906,	185,	554230,	'Гурьевск',	'Gur\'yevsk',	'Gur\'yevsk',	1,	20211,	'2019-03-16 03:59:51',	'Gur\'yevsk',	'Gur\'yevsk',	'Gur\'yevsk'),
(558066,	185,	542415,	'Гулькевичи',	'Gul\'kevichi',	'Gul\'kevichi',	1,	20166,	'2019-03-16 03:59:51',	'Gul\'kevichi',	'Gul\'kevichi',	'Gul\'kevichi'),
(558082,	185,	501165,	'Гуково',	'Gukovo',	'Gukovo',	1,	20165,	'2019-03-16 03:59:51',	'Gukovo',	'Gukovo',	'Gukovo'),
(558118,	185,	569665,	'Гудермес',	'Gudermes',	'Gudermes',	1,	20054,	'2019-03-16 03:59:51',	'Gudermes',	'Gudermes',	'Gudermes'),
(558146,	185,	578071,	'Губкин',	'Gubkin',	'Gubkin',	1,	20050,	'2019-03-16 03:59:51',	'Gubkin',	'Gubkin',	'Gubkin'),
(558209,	185,	511180,	'Губаха',	'Gubakha',	'Gubakha',	1,	20047,	'2019-03-16 03:59:51',	'Gubakha',	'Gubakha',	'Gubakha'),
(558236,	185,	472454,	'Грязовец',	'Gryazovets',	'Gryazovets',	1,	20011,	'2019-03-16 03:59:51',	'Gryazovets',	'Gryazovets',	'Gryazovets'),
(558418,	185,	569665,	'Грозный',	'Groznyy',	'Groznyy',	1,	19971,	'2019-03-16 03:59:51',	'Groznyy',	'Groznyy',	'Groznyy'),
(558885,	185,	511180,	'Гремячинск',	'Gremyachinsk',	'Gremyachinsk',	1,	19733,	'2019-03-16 03:59:51',	'Gremyachinsk',	'Gremyachinsk',	'Gremyachinsk'),
(559654,	185,	472755,	'Городище',	'Gorodishche',	'Gorodishche',	1,	19150,	'2019-03-16 03:59:51',	'Gorodishche',	'Gorodishche',	'Gorodishche'),
(559678,	185,	559838,	'Городец',	'Gorodets',	'Gorodets',	1,	19149,	'2019-03-16 03:59:51',	'Gorodets',	'Gorodets',	'Gorodets'),
(559752,	185,	511180,	'Горнозаводск',	'Gornozavodsk',	'Gornozavodsk',	1,	19146,	'2019-03-16 03:59:51',	'Gornozavodsk',	'Gornozavodsk',	'Gornozavodsk'),
(559853,	185,	524925,	'Горки-2',	'Gorki-2',	'Gorki-2',	1,	19137,	'2019-03-16 03:59:51',	'Gorki-2',	'Gorki-2',	'Gorki-2'),
(560756,	185,	524925,	'Голицыно',	'Golitsyno',	'Golitsyno',	1,	19017,	'2019-03-16 03:59:51',	'Golitsyno',	'Golitsyno',	'Golitsyno'),
(561347,	185,	479613,	'Глазов',	'Glazov',	'Glazov',	1,	18790,	'2019-03-16 03:59:51',	'Glazov',	'Glazov',	'Glazov'),
(561627,	185,	487839,	'Георгиевск',	'Georgiyevsk',	'Georgiyevsk',	1,	18421,	'2019-03-16 03:59:51',	'Georgiyevsk',	'Georgiyevsk',	'Georgiyevsk'),
(561667,	185,	542415,	'Геленджик',	'Gelendzhik',	'Gelendzhik',	1,	18310,	'2019-03-16 03:59:51',	'Gelendzhik',	'Gelendzhik',	'Gelendzhik'),
(561731,	185,	515001,	'Гай',	'Gay',	'Gay',	1,	18232,	'2019-03-16 03:59:51',	'Gay',	'Gay',	'Gay'),
(561762,	185,	468898,	'Гаврилов-ям',	'Gavrilov-Yam',	'Gavrilov-Yam',	1,	18231,	'2019-03-16 03:59:51',	'Gavrilov-Yam',	'Gavrilov-Yam',	'Gavrilov-Yam'),
(561887,	185,	536199,	'Гатчина',	'Gatchina',	'Gatchina',	1,	18186,	'2019-03-16 03:59:51',	'Gatchina',	'Gatchina',	'Gatchina'),
(562237,	185,	491684,	'Гагарин',	'Gagarin',	'Gagarin',	1,	17881,	'2019-03-16 03:59:51',	'Gagarin',	'Gagarin',	'Gagarin'),
(562309,	185,	555235,	'Фурманов',	'Furmanov',	'Furmanov',	1,	17831,	'2019-03-16 03:59:51',	'Furmanov',	'Furmanov',	'Furmanov'),
(562319,	185,	524925,	'Фрязино',	'Fryazino',	'Fryazino',	1,	17753,	'2019-03-16 03:59:51',	'Fryazino',	'Fryazino',	'Fryazino'),
(562389,	185,	472755,	'Фролово',	'Frolovo',	'Frolovo',	1,	17709,	'2019-03-16 03:59:51',	'Frolovo',	'Frolovo',	'Frolovo'),
(562573,	185,	571473,	'Фокино',	'Fokino',	'Fokino',	1,	16898,	'2019-03-16 03:59:51',	'Fokino',	'Fokino',	'Fokino'),
(563464,	185,	498671,	'Энгельс',	'Engel\'s',	'Engel\'s',	1,	15355,	'2019-03-16 03:59:51',	'Engel\'s',	'Engel\'s',	'Engel\'s'),
(563472,	185,	584222,	'Энем',	'Enem',	'Enem',	1,	15344,	'2019-03-16 03:59:51',	'Enem',	'Enem',	'Enem'),
(563514,	185,	553972,	'Элиста',	'Elista',	'Elista',	1,	15035,	'2019-03-16 03:59:51',	'Elista',	'Elista',	'Elista'),
(563522,	185,	524925,	'Электроугли',	'Elektrougli',	'Elektrougli',	1,	15008,	'2019-03-16 03:59:51',	'Elektrougli',	'Elektrougli',	'Elektrougli'),
(563523,	185,	524925,	'Электросталь',	'Elektrostal\'',	'Elektrostal\'',	1,	15007,	'2019-03-16 03:59:51',	'Elektrostal\'',	'Elektrostal\'',	'Elektrostal\''),
(563524,	185,	524925,	'Электрогорск',	'Elektrogorsk',	'Elektrogorsk',	1,	15006,	'2019-03-16 03:59:51',	'Elektrogorsk',	'Elektrogorsk',	'Elektrogorsk'),
(563705,	185,	524925,	'Дзержинский',	'Dzerzhinskiy',	'Dzerzhinskiy',	1,	14288,	'2019-03-16 03:59:51',	'Dzerzhinskiy',	'Dzerzhinskiy',	'Dzerzhinskiy'),
(563708,	185,	559838,	'Дзержинск',	'Dzerzhinsk',	'Dzerzhinsk',	1,	14287,	'2019-03-16 03:59:51',	'Dzerzhinsk',	'Dzerzhinsk',	'Dzerzhinsk'),
(564622,	185,	472755,	'Дубовое',	'Dubovoye',	'Dubovoye',	1,	14076,	'2019-03-16 03:59:51',	'Dubovoye',	'Dubovoye',	'Dubovoye'),
(564654,	185,	472755,	'Дубовка',	'Dubovka',	'Dubovka',	1,	14075,	'2019-03-16 03:59:51',	'Dubovka',	'Dubovka',	'Dubovka'),
(564719,	185,	524925,	'Дубна',	'Dubna',	'Dubna',	1,	14070,	'2019-03-16 03:59:51',	'Dubna',	'Dubna',	'Dubna'),
(565348,	185,	501165,	'Донецк',	'Donetsk',	'Donetsk',	1,	13737,	'2019-03-16 03:59:51',	'Donetsk',	'Donetsk',	'Donetsk'),
(565380,	185,	524925,	'Домодедово',	'Domodedovo',	'Domodedovo',	1,	13704,	'2019-03-16 03:59:51',	'Domodedovo',	'Domodedovo',	'Domodedovo'),
(565614,	185,	524925,	'Долгопрудный',	'Dolgoprudnyy',	'Dolgoprudnyy',	1,	13655,	'2019-03-16 03:59:51',	'Dolgoprudnyy',	'Dolgoprudnyy',	'Dolgoprudnyy'),
(565778,	185,	511180,	'Добрянка',	'Dobryanka',	'Dobryanka',	1,	13606,	'2019-03-16 03:59:51',	'Dobryanka',	'Dobryanka',	'Dobryanka'),
(565955,	185,	524925,	'Дмитров',	'Dmitrov',	'Dmitrov',	1,	13591,	'2019-03-16 03:59:51',	'Dmitrov',	'Dmitrov',	'Dmitrov'),
(566199,	185,	479119,	'Димитровград',	'Dimitrovgrad',	'Dimitrovgrad',	1,	13502,	'2019-03-16 03:59:51',	'Dimitrovgrad',	'Dimitrovgrad',	'Dimitrovgrad'),
(566363,	185,	553899,	'Детчино',	'Detchino',	'Detchino',	1,	13303,	'2019-03-16 03:59:51',	'Detchino',	'Detchino',	'Detchino'),
(566384,	185,	491684,	'Десногорск',	'Desnogorsk',	'Desnogorsk',	1,	13296,	'2019-03-16 03:59:51',	'Desnogorsk',	'Desnogorsk',	'Desnogorsk'),
(566738,	185,	826294,	'Демидово',	'Demidovo',	'Demidovo',	1,	13166,	'2019-03-16 03:59:51',	'Demidovo',	'Demidovo',	'Demidovo'),
(566854,	185,	524925,	'Дедовск',	'Dedovsk',	'Dedovsk',	1,	13036,	'2019-03-16 03:59:51',	'Dedovsk',	'Dedovsk',	'Dedovsk'),
(567434,	185,	511180,	'Чусовой',	'Chusovoy',	'Chusovoy',	1,	10495,	'2019-03-16 03:59:51',	'Chusovoy',	'Chusovoy',	'Chusovoy'),
(567774,	185,	519324,	'Чудово',	'Chudovo',	'Chudovo',	1,	10464,	'2019-03-16 03:59:51',	'Chudovo',	'Chudovo',	'Chudovo'),
(568220,	185,	524925,	'Чигасово ',	'Chigasovo',	'Chigasovo',	1,	10313,	'2019-03-16 03:59:51',	'Chigasovo',	'Chigasovo',	'Chigasovo'),
(568429,	185,	501165,	'Чертково',	'Chertkovo',	'Chertkovo',	1,	10166,	'2019-03-16 03:59:51',	'Chertkovo',	'Chertkovo',	'Chertkovo'),
(568595,	185,	554230,	'Черняховск',	'Chernyakhovsk',	'Chernyakhovsk',	1,	10142,	'2019-03-16 03:59:51',	'Chernyakhovsk',	'Chernyakhovsk',	'Chernyakhovsk'),
(568608,	185,	511180,	'Чернушка',	'Chernushka',	'Chernushka',	1,	10141,	'2019-03-16 03:59:51',	'Chernushka',	'Chernushka',	'Chernushka'),
(568808,	185,	524925,	'Черноголовка',	'Chernogolovka',	'Chernogolovka',	1,	10139,	'2019-03-16 03:59:51',	'Chernogolovka',	'Chernogolovka',	'Chernogolovka'),
(569154,	185,	552927,	'Черкесск',	'Cherkessk',	'Cherkessk',	1,	10134,	'2019-03-16 03:59:51',	'Cherkessk',	'Cherkessk',	'Cherkessk'),
(569223,	185,	472454,	'Череповец',	'Cherepovets',	'Cherepovets',	1,	10128,	'2019-03-16 03:59:51',	'Cherepovets',	'Cherepovets',	'Cherepovets'),
(569591,	185,	524925,	'Чехов',	'Chekhov',	'Chekhov',	1,	10062,	'2019-03-16 03:59:51',	'Chekhov',	'Chekhov',	'Chekhov'),
(569696,	185,	567395,	'Чебоксары',	'Cheboksary',	'Cheboksary',	1,	10051,	'2019-03-16 03:59:51',	'Cheboksary',	'Cheboksary',	'Cheboksary'),
(569742,	185,	511180,	'Чайковский',	'Chaykovskiy',	'Chaykovskiy',	1,	10037,	'2019-03-16 03:59:51',	'Chaykovskiy',	'Chaykovskiy',	'Chaykovskiy'),
(569955,	185,	499068,	'Чапаевск',	'Chapayevsk',	'Chapayevsk',	1,	9722,	'2019-03-16 03:59:51',	'Chapayevsk',	'Chapayevsk',	'Chapayevsk'),
(570003,	185,	525369,	'Чамзинка',	'Chamzinka',	'Chamzinka',	1,	9665,	'2019-03-16 03:59:51',	'Chamzinka',	'Chamzinka',	'Chamzinka'),
(570021,	185,	501165,	'Чалтырь',	'Chaltyr',	'Chaltyr',	1,	9567,	'2019-03-16 03:59:51',	'Chaltyr',	'Chaltyr',	'Chaltyr'),
(570427,	185,	515001,	'Бузулук',	'Buzuluk',	'Buzuluk',	1,	7634,	'2019-03-16 03:59:51',	'Buzuluk',	'Buzuluk',	'Buzuluk'),
(570479,	185,	567293,	'Буйнакск',	'Buynaksk',	'Buynaksk',	1,	7629,	'2019-03-16 03:59:51',	'Buynaksk',	'Buynaksk',	'Buynaksk'),
(570563,	185,	472039,	'Бутурлиновка',	'Buturlinovka',	'Buturlinovka',	1,	7612,	'2019-03-16 03:59:51',	'Buturlinovka',	'Buturlinovka',	'Buturlinovka'),
(571476,	185,	571473,	'Брянск',	'Bryansk',	'Bryansk',	1,	7111,	'2019-03-16 03:59:51',	'Bryansk',	'Bryansk',	'Bryansk'),
(571557,	185,	524925,	'Бронницы',	'Bronnitsy',	'Bronnitsy',	1,	6878,	'2019-03-16 03:59:51',	'Bronnitsy',	'Bronnitsy',	'Bronnitsy'),
(572070,	185,	553899,	'Боровск',	'Borovsk',	'Borovsk',	1,	5962,	'2019-03-16 03:59:51',	'Borovsk',	'Borovsk',	'Borovsk'),
(572154,	185,	519324,	'Боровичи',	'Borovichi',	'Borovichi',	1,	5961,	'2019-03-16 03:59:51',	'Borovichi',	'Borovichi',	'Borovichi'),
(572525,	185,	472039,	'Борисоглебск',	'Borisoglebsk',	'Borisoglebsk',	1,	5935,	'2019-03-16 03:59:51',	'Borisoglebsk',	'Borisoglebsk',	'Borisoglebsk'),
(572665,	185,	559838,	'Бор',	'Bor',	'Bor',	1,	5871,	'2019-03-16 03:59:51',	'Bor',	'Bor',	'Bor'),
(575349,	185,	480041,	'Бологое',	'Bologoye',	'Bologoye',	1,	5726,	'2019-03-16 03:59:51',	'Bologoye',	'Bologoye',	'Bologoye'),
(575457,	185,	472039,	'Богучар',	'Boguchar',	'Boguchar',	1,	5604,	'2019-03-16 03:59:51',	'Boguchar',	'Boguchar',	'Boguchar'),
(575560,	185,	559838,	'Богородск',	'Bogorodsk',	'Bogorodsk',	1,	5602,	'2019-03-16 03:59:51',	'Bogorodsk',	'Bogorodsk',	'Bogorodsk'),
(575591,	185,	480508,	'Богородицк',	'Bogoroditsk',	'Bogoroditsk',	1,	5601,	'2019-03-16 03:59:51',	'Bogoroditsk',	'Bogoroditsk',	'Bogoroditsk'),
(575948,	185,	472039,	'Бобров',	'Bobrov',	'Bobrov',	1,	5536,	'2019-03-16 03:59:51',	'Bobrov',	'Bobrov',	'Bobrov'),
(576317,	185,	578853,	'Бирск',	'Birsk',	'Birsk',	1,	5128,	'2019-03-16 03:59:51',	'Birsk',	'Birsk',	'Birsk'),
(576566,	185,	480041,	'Бежецк',	'Bezhetsk',	'Bezhetsk',	1,	4844,	'2019-03-16 03:59:51',	'Bezhetsk',	'Bezhetsk',	'Bezhetsk'),
(576697,	185,	519969,	'Беслан',	'Beslan',	'Beslan',	1,	4689,	'2019-03-16 03:59:51',	'Beslan',	'Beslan',	'Beslan'),
(576980,	185,	511180,	'Березовка',	'Berezovka',	'Berezovka',	1,	4489,	'2019-03-16 03:59:51',	'Berezovka',	'Berezovka',	'Berezovka'),
(577206,	185,	511180,	'Березники',	'Berezniki',	'Berezniki',	1,	4488,	'2019-03-16 03:59:51',	'Berezniki',	'Berezniki',	'Berezniki'),
(577403,	185,	472755,	'Береславка',	'Bereslavka',	'Bereslavka',	1,	4486,	'2019-03-16 03:59:51',	'Bereslavka',	'Bereslavka',	'Bereslavka'),
(577881,	185,	578853,	'Белорецк',	'Beloretsk',	'Beloretsk',	1,	4288,	'2019-03-16 03:59:51',	'Beloretsk',	'Beloretsk',	'Beloretsk'),
(577893,	185,	542415,	'Белореченск',	'Belorechensk',	'Belorechensk',	1,	4287,	'2019-03-16 03:59:51',	'Belorechensk',	'Belorechensk',	'Belorechensk'),
(578072,	185,	578071,	'Белгород',	'Belgorod',	'Belgorod',	1,	4127,	'2019-03-16 03:59:51',	'Belgorod',	'Belgorod',	'Belgorod'),
(578155,	185,	501165,	'Белая Калитва',	'Belaya Kalitva',	'Belaya Kalitva',	1,	4096,	'2019-03-16 03:59:51',	'Belaya Kalitva',	'Belaya Kalitva',	'Belaya Kalitva'),
(578386,	185,	553899,	'Бебелево',	'Bebelevo',	'Bebelevo',	1,	3964,	'2019-03-16 03:59:51',	'Bebelevo',	'Bebelevo',	'Bebelevo'),
(578740,	185,	501165,	'Батайск',	'Bataysk',	'Bataysk',	1,	3640,	'2019-03-16 03:59:51',	'Bataysk',	'Bataysk',	'Bataysk'),
(579266,	185,	1490542,	'Baranchinskiy',	'Baranchinskiy',	'Baranchinskiy',	1,	3351,	'2019-03-16 03:59:51',	'Baranchinskiy',	'Baranchinskiy',	'Baranchinskiy'),
(579460,	185,	498671,	'Балашов',	'Balashov',	'Balashov',	1,	3169,	'2019-03-16 03:59:51',	'Balashov',	'Balashov',	'Balashov'),
(579464,	185,	524925,	'Балашиха',	'Balashikha',	'Balashikha',	1,	3168,	'2019-03-16 03:59:51',	'Balashikha',	'Balashikha',	'Balashikha'),
(579492,	185,	498671,	'Балаково',	'Balakovo',	'Balakovo',	1,	3162,	'2019-03-16 03:59:51',	'Balakovo',	'Balakovo',	'Balakovo'),
(579514,	185,	559838,	'Балахна',	'Balakhna',	'Balakhna',	1,	3160,	'2019-03-16 03:59:51',	'Balakhna',	'Balakhna',	'Balakhna'),
(579528,	185,	524925,	'Балабаново',	'Balabanovo',	'Balabanovo',	1,	3157,	'2019-03-16 03:59:51',	'Balabanovo',	'Balabanovo',	'Balabanovo'),
(579574,	185,	554667,	'Баксан',	'Baksan',	'Baksan',	1,	3153,	'2019-03-16 03:59:51',	'Baksan',	'Baksan',	'Baksan'),
(579771,	185,	501165,	'Багаевская',	'Bagayevskaya',	'Bagayevskaya',	1,	3045,	'2019-03-16 03:59:51',	'Bagayevskaya',	'Bagayevskaya',	'Bagayevskaya'),
(580054,	185,	501165,	'Азов',	'Azov',	'Azov',	1,	2831,	'2019-03-16 03:59:51',	'Azov',	'Azov',	'Azov'),
(580420,	185,	498671,	'Аткарск',	'Atkarsk',	'Atkarsk',	1,	2345,	'2019-03-16 03:59:51',	'Atkarsk',	'Atkarsk',	'Atkarsk'),
(580493,	185,	580491,	'Астрахань',	'Astrakhan\'',	'Astrakhan\'',	1,	2298,	'2019-03-16 03:59:51',	'Astrakhan\'',	'Astrakhan\'',	'Astrakhan\''),
(580660,	185,	1508290,	'Аша',	'Asha',	'Asha',	1,	2157,	'2019-03-16 03:59:51',	'Asha',	'Asha',	'Asha'),
(580724,	185,	559838,	'Арзамас',	'Arzamas',	'Arzamas',	1,	2107,	'2019-03-16 03:59:51',	'Arzamas',	'Arzamas',	'Arzamas'),
(580798,	185,	1490542,	'Артемовский',	'Artemovskiy',	'Artemovskiy',	1,	2059,	'2019-03-16 03:59:51',	'Artemovskiy',	'Artemovskiy',	'Artemovskiy'),
(580922,	185,	542415,	'Армавир',	'Armavir',	'Armavir',	1,	1940,	'2019-03-16 03:59:51',	'Armavir',	'Armavir',	'Armavir'),
(581049,	185,	581043,	'Архангельск',	'Arkhangel\'sk',	'Arkhangel\'sk',	1,	1904,	'2019-03-16 03:59:51',	'Arkhangel\'sk',	'Arkhangel\'sk',	'Arkhangel\'sk'),
(581321,	185,	524925,	'Апрелевка',	'Aprelevka',	'Aprelevka',	1,	1676,	'2019-03-16 03:59:51',	'Aprelevka',	'Aprelevka',	'Aprelevka'),
(581357,	185,	524304,	'Апатиты',	'Apatity',	'Apatity',	1,	1632,	'2019-03-16 03:59:51',	'Apatity',	'Apatity',	'Apatity'),
(581671,	185,	472039,	'Анна',	'Anna',	'Anna',	1,	1503,	'2019-03-16 03:59:51',	'Anna',	'Anna',	'Anna'),
(582182,	185,	542415,	'Анапа',	'Anapa',	'Anapa',	1,	1337,	'2019-03-16 03:59:51',	'Anapa',	'Anapa',	'Anapa'),
(582432,	185,	484048,	'Альметьевск',	'Al\'met\'yevsk',	'Al\'met\'yevsk',	1,	482,	'2019-03-16 03:59:51',	'Al\'met\'yevsk',	'Al\'met\'yevsk',	'Al\'met\'yevsk'),
(582750,	185,	480508,	'Алексин',	'Aleksin',	'Aleksin',	1,	695,	'2019-03-16 03:59:51',	'Aleksin',	'Aleksin',	'Aleksin'),
(582956,	185,	578071,	'Алексеевка',	'Alekseyevka',	'Alekseyevka',	1,	694,	'2019-03-16 03:59:51',	'Alekseyevka',	'Alekseyevka',	'Alekseyevka'),
(582978,	185,	826294,	'Александров',	'Aleksandrow',	'Aleksandrow',	1,	693,	'2019-03-16 03:59:51',	'Aleksandrow',	'Aleksandrow',	'Aleksandrow'),
(583041,	185,	511180,	'Александровск',	'Aleksandrovsk',	'Aleksandrovsk',	1,	691,	'2019-03-16 03:59:51',	'Aleksandrovsk',	'Aleksandrovsk',	'Aleksandrovsk'),
(583350,	185,	826294,	'Александров',	'Aleksandrov',	'Aleksandrov',	1,	689,	'2019-03-16 03:59:51',	'Aleksandrov',	'Aleksandrov',	'Aleksandrov'),
(583437,	185,	567395,	'Алатырь',	'Alatyr\'',	'Alatyr\'',	1,	514,	'2019-03-16 03:59:51',	'Alatyr\'',	'Alatyr\'',	'Alatyr\''),
(583673,	185,	501165,	'Аксай',	'Aksay',	'Aksay',	1,	470,	'2019-03-16 03:59:51',	'Aksay',	'Aksay',	'Aksay'),
(584243,	185,	542415,	'Адлер',	'Adler',	'Adler',	1,	251,	'2019-03-16 03:59:51',	'Adler',	'Adler',	'Adler'),
(584441,	185,	542415,	'Абинск',	'Abinsk',	'Abinsk',	1,	87,	'2019-03-16 03:59:51',	'Abinsk',	'Abinsk',	'Abinsk'),
(607610,	122,	608879,	'Жанаозен',	'Zhanaozen',	'Zhanaozen',	1,	55132,	'2019-03-16 03:59:51',	'Zhanaozen',	'Zhanaozen',	'Zhanaozen'),
(607747,	122,	607847,	'Yegindykol\'',	'Yegindykol\'',	'Yegindykol\'',	1,	54903,	'2019-03-16 03:59:51',	'Yegindykol\'',	'Yegindykol\'',	'Yegindykol\''),
(608668,	122,	607847,	'Уральск',	'Oral',	'Oral',	1,	36003,	'2019-03-16 03:59:51',	'Oral',	'Oral',	'Oral'),
(609655,	122,	1523401,	'Караганда',	'Karagandy',	'Karagandy',	1,	23870,	'2019-03-16 03:59:51',	'Karagandy',	'Karagandy',	'Karagandy'),
(610529,	122,	609862,	'Атырау',	'Atyrau',	'Atyrau',	1,	2405,	'2019-03-16 03:59:51',	'Atyrau',	'Atyrau',	'Atyrau'),
(610611,	122,	610688,	'Актобе',	'Aqtobe',	'Aqtobe',	1,	1687,	'2019-03-16 03:59:51',	'Aqtobe',	'Aqtobe',	'Aqtobe'),
(610612,	122,	608879,	'Актау',	'Aktau',	'Aktau',	1,	473,	'2019-03-16 03:59:51',	'Aktau',	'Aktau',	'Aktau'),
(610613,	122,	607847,	'Аксай',	'Aqsay',	'Aqsay',	1,	1686,	'2019-03-16 03:59:51',	'Aqsay',	'Aqsay',	'Aqsay'),
(613273,	222,	692196,	'Лебедин',	'Lebedyn',	'Lebedyn',	1,	27003,	'2019-03-16 03:59:51',	'Lebedyn',	'Lebedyn',	'Lebedyn'),
(616743,	222,	709716,	'Дружковка',	'Druzhkovka',	'Druzhkovka',	1,	14043,	'2019-03-16 03:59:51',	'Druzhkovka',	'Druzhkovka',	'Druzhkovka'),
(618800,	36,	625142,	'Жодино',	'Zhodzina',	'Zhodzina',	1,	55147,	'2019-03-16 03:59:51',	'Zhodzina',	'Zhodzina',	'Zhodzina'),
(618806,	36,	628281,	'Жлобин',	'Zhlobin',	'Zhlobin',	1,	55146,	'2019-03-16 03:59:51',	'Zhlobin',	'Zhlobin',	'Zhlobin'),
(618835,	222,	702549,	'Жидачов',	'Zhydachiv',	'Zhydachiv',	1,	55152,	'2019-03-16 03:59:51',	'Zhydachiv',	'Zhydachiv',	'Zhydachiv'),
(618913,	36,	629631,	'Жабинка',	'Zhabinka',	'Zhabinka',	1,	55130,	'2019-03-16 03:59:51',	'Zhabinka',	'Zhabinka',	'Zhabinka'),
(619066,	36,	625142,	'Заславль',	'Zaslawye',	'Zaslawye',	1,	55063,	'2019-03-16 03:59:51',	'Zaslawye',	'Zaslawye',	'Zaslawye'),
(619818,	36,	629631,	'Высокое',	'Vysokaye',	'Vysokaye',	1,	52376,	'2019-03-16 03:59:51',	'Vysokaye',	'Vysokaye',	'Vysokaye'),
(620127,	36,	620134,	'Витебск',	'Vitebsk',	'Vitebsk',	1,	52158,	'2019-03-16 03:59:51',	'Vitebsk',	'Vitebsk',	'Vitebsk'),
(620945,	36,	629631,	'Телеханы',	'Tsyelyakhany',	'Tsyelyakhany',	1,	50059,	'2019-03-16 03:59:51',	'Tsyelyakhany',	'Tsyelyakhany',	'Tsyelyakhany'),
(621986,	36,	620134,	'Шумилино',	'Shumilina',	'Shumilina',	1,	46193,	'2019-03-16 03:59:51',	'Shumilina',	'Shumilina',	'Shumilina'),
(622034,	36,	625073,	'Шклов',	'Shklow',	'Shklow',	1,	46154,	'2019-03-16 03:59:51',	'Shklow',	'Shklow',	'Shklow'),
(622428,	36,	625142,	'Солигорск',	'Salihorsk',	'Salihorsk',	1,	43793,	'2019-03-16 03:59:51',	'Salihorsk',	'Salihorsk',	'Salihorsk'),
(622690,	36,	620134,	'Россоны',	'Rasony',	'Rasony',	1,	40058,	'2019-03-16 03:59:51',	'Rasony',	'Rasony',	'Rasony'),
(622988,	36,	620134,	'Псуя',	'Psuya',	'Psuya',	1,	39471,	'2019-03-16 03:59:51',	'Psuya',	'Psuya',	'Psuya'),
(622997,	36,	629631,	'Пружаны',	'Pruzhany',	'Pruzhany',	1,	39465,	'2019-03-16 03:59:51',	'Pruzhany',	'Pruzhany',	'Pruzhany'),
(623180,	36,	620134,	'Толочин',	'Tolochin',	'Tolochin',	1,	49367,	'2019-03-16 03:59:51',	'Tolochin',	'Tolochin',	'Tolochin'),
(623317,	36,	620134,	'Полоцк',	'Polatsk',	'Polatsk',	1,	38526,	'2019-03-16 03:59:51',	'Polatsk',	'Polatsk',	'Polatsk'),
(623549,	36,	629631,	'Пинск',	'Pinsk',	'Pinsk',	1,	38015,	'2019-03-16 03:59:51',	'Pinsk',	'Pinsk',	'Pinsk'),
(623760,	36,	620134,	'Поставы',	'Pastavy',	'Pastavy',	1,	37034,	'2019-03-16 03:59:51',	'Pastavy',	'Pastavy',	'Pastavy'),
(623956,	36,	625142,	'Острошицкий Городок',	'Astrashytski Haradok',	'Astrashytski Haradok',	1,	2299,	'2019-03-16 03:59:51',	'Astrashytski Haradok',	'Astrashytski Haradok',	'Astrashytski Haradok'),
(624079,	36,	620134,	'Орша',	'Orsha',	'Orsha',	1,	36184,	'2019-03-16 03:59:51',	'Orsha',	'Orsha',	'Orsha'),
(624281,	36,	620134,	'Оболь',	'Obal\'',	'Obal\'',	1,	35378,	'2019-03-16 03:59:51',	'Obal\'',	'Obal\'',	'Obal\''),
(624494,	36,	620134,	'Новолукомль',	'Novolukoml\'',	'Novolukoml\'',	1,	35178,	'2019-03-16 03:59:51',	'Novolukoml\'',	'Novolukoml\'',	'Novolukoml\''),
(624784,	36,	620134,	'Новополоцк',	'Navapolatsk',	'Navapolatsk',	1,	33667,	'2019-03-16 03:59:51',	'Navapolatsk',	'Navapolatsk',	'Navapolatsk'),
(625130,	36,	620134,	'Миоры',	'Myory',	'Myory',	1,	33437,	'2019-03-16 03:59:51',	'Myory',	'Myory',	'Myory'),
(625144,	36,	625143,	'Минск',	'Minsk',	'Minsk',	1,	31596,	'2019-03-16 03:59:51',	'Minsk',	'Minsk',	'Minsk'),
(625324,	36,	628281,	'Мозырь',	'Mazyr',	'Mazyr',	1,	30448,	'2019-03-16 03:59:51',	'Mazyr',	'Mazyr',	'Mazyr'),
(625625,	36,	625142,	'Молодечно',	'Maladzyechna',	'Maladzyechna',	1,	29275,	'2019-03-16 03:59:51',	'Maladzyechna',	'Maladzyechna',	'Maladzyechna'),
(625665,	36,	625073,	'Могилёв',	'Mahilyow',	'Mahilyow',	1,	29176,	'2019-03-16 03:59:51',	'Mahilyow',	'Mahilyow',	'Mahilyow'),
(625768,	36,	620134,	'Ляховичи',	'Lyakhovichi',	'Lyakhovichi',	1,	28918,	'2019-03-16 03:59:51',	'Lyakhovichi',	'Lyakhovichi',	'Lyakhovichi'),
(625772,	36,	629631,	'Ляховичи',	'Lyakhavichy',	'Lyakhavichy',	1,	28917,	'2019-03-16 03:59:51',	'Lyakhavichy',	'Lyakhavichy',	'Lyakhavichy'),
(626081,	36,	628035,	'Лида',	'Lida',	'Lida',	1,	27669,	'2019-03-16 03:59:51',	'Lida',	'Lida',	'Lida'),
(627145,	36,	629631,	'Кобрин',	'Kobryn',	'Kobryn',	1,	24700,	'2019-03-16 03:59:51',	'Kobryn',	'Kobryn',	'Kobryn'),
(627711,	36,	629631,	'Каменец',	'Kamyanyets',	'Kamyanyets',	1,	23818,	'2019-03-16 03:59:51',	'Kamyanyets',	'Kamyanyets',	'Kamyanyets'),
(627800,	36,	629631,	'Ивацевичи',	'Ivatsevichy',	'Ivatsevichy',	1,	23195,	'2019-03-16 03:59:51',	'Ivatsevichy',	'Ivatsevichy',	'Ivatsevichy'),
(627904,	36,	628035,	'Гродно',	'Hrodna',	'Hrodna',	1,	22427,	'2019-03-16 03:59:51',	'Hrodna',	'Hrodna',	'Hrodna'),
(627907,	36,	628281,	'Гомель',	'Gomel',	'Gomel',	1,	19031,	'2019-03-16 03:59:51',	'Gomel',	'Gomel',	'Gomel'),
(627908,	36,	620134,	'Глубокое',	'Hlybokaye',	'Hlybokaye',	1,	21863,	'2019-03-16 03:59:51',	'Hlybokaye',	'Hlybokaye',	'Hlybokaye'),
(627909,	36,	629631,	'Ганцевичи',	'Hantsavichy',	'Hantsavichy',	1,	20622,	'2019-03-16 03:59:51',	'Hantsavichy',	'Hantsavichy',	'Hantsavichy'),
(628107,	36,	628035,	'Гожа',	'Gozha',	'Gozha',	1,	19248,	'2019-03-16 03:59:51',	'Gozha',	'Gozha',	'Gozha'),
(628155,	36,	620134,	'Городок',	'Haradok',	'Haradok',	1,	20636,	'2019-03-16 03:59:51',	'Haradok',	'Haradok',	'Haradok'),
(628634,	36,	625142,	'Дзержинск',	'Dzyarzhynsk',	'Dzyarzhynsk',	1,	14292,	'2019-03-16 03:59:51',	'Dzyarzhynsk',	'Dzyarzhynsk',	'Dzyarzhynsk'),
(628884,	36,	629631,	'Дрогичин',	'Drahichyn',	'Drahichyn',	1,	13951,	'2019-03-16 03:59:51',	'Drahichyn',	'Drahichyn',	'Drahichyn'),
(629002,	36,	620134,	'Докшицы',	'Dokshytsy',	'Dokshytsy',	1,	13640,	'2019-03-16 03:59:51',	'Dokshytsy',	'Dokshytsy',	'Dokshytsy'),
(629159,	36,	629631,	'Давид-Городок',	'Davyd-Haradok',	'Davyd-Haradok',	1,	12933,	'2019-03-16 03:59:51',	'Davyd-Haradok',	'Davyd-Haradok',	'Davyd-Haradok'),
(629400,	36,	620134,	'Чашники',	'Chashniki',	'Chashniki',	1,	9860,	'2019-03-16 03:59:51',	'Chashniki',	'Chashniki',	'Chashniki'),
(629454,	36,	629631,	'Берёза',	'Byaroza',	'Byaroza',	1,	7637,	'2019-03-16 03:59:51',	'Byaroza',	'Byaroza',	'Byaroza'),
(629634,	36,	629631,	'Брест',	'Brest',	'Brest',	1,	6580,	'2019-03-16 03:59:51',	'Brest',	'Brest',	'Brest'),
(630279,	36,	629631,	'Белоозерск',	'Byelaazyorsk',	'Byelaazyorsk',	1,	7639,	'2019-03-16 03:59:51',	'Byelaazyorsk',	'Byelaazyorsk',	'Byelaazyorsk'),
(630376,	36,	625142,	'Борисов',	'Barysaw',	'Barysaw',	1,	3568,	'2019-03-16 03:59:51',	'Barysaw',	'Barysaw',	'Barysaw'),
(630424,	36,	629631,	'Барановичи',	'Baranavichy',	'Baranavichy',	1,	3350,	'2019-03-16 03:59:51',	'Baranavichy',	'Baranavichy',	'Baranavichy'),
(630477,	36,	620134,	'Бабиничи',	'Babinichy',	'Babinichy',	1,	2851,	'2019-03-16 03:59:51',	'Babinichy',	'Babinichy',	'Babinichy'),
(686875,	222,	710802,	'Золотоноша',	'Zolotonosha',	'Zolotonosha',	1,	55208,	'2019-03-16 03:59:51',	'Zolotonosha',	'Zolotonosha',	'Zolotonosha'),
(686896,	222,	702549,	'Золочев',	'Zolochiv',	'Zolochiv',	1,	55207,	'2019-03-16 03:59:51',	'Zolochiv',	'Zolochiv',	'Zolochiv'),
(686919,	222,	705811,	'Знаменка',	'Znomenka',	'Znomenka',	1,	55197,	'2019-03-16 03:59:51',	'Znomenka',	'Znomenka',	'Znomenka'),
(686928,	222,	706482,	'Змиёв',	'Zmiyiv',	'Zmiyiv',	1,	55196,	'2019-03-16 03:59:51',	'Zmiyiv',	'Zmiyiv',	'Zmiyiv'),
(686961,	222,	702549,	'Зымна Вода',	'Zymna Voda',	'Zymna Voda',	1,	55251,	'2019-03-16 03:59:51',	'Zymna Voda',	'Zymna Voda',	'Zymna Voda'),
(686967,	222,	686966,	'Житомир',	'Zhytomyr',	'Zhytomyr',	1,	55153,	'2019-03-16 03:59:51',	'Zhytomyr',	'Zhytomyr',	'Zhytomyr'),
(687196,	222,	709929,	'Жёлтые Воды',	'Zhovti Vody',	'Zhovti Vody',	1,	55149,	'2019-03-16 03:59:51',	'Zhovti Vody',	'Zhovti Vody',	'Zhovti Vody'),
(687432,	222,	695592,	'Здолбунов',	'Zdolbuniv',	'Zdolbuniv',	1,	55069,	'2019-03-16 03:59:51',	'Zdolbuniv',	'Zdolbuniv',	'Zdolbuniv'),
(687455,	222,	691649,	'Збараж',	'Zbarazh',	'Zbarazh',	1,	55068,	'2019-03-16 03:59:51',	'Zbarazh',	'Zbarazh',	'Zbarazh'),
(687457,	222,	703446,	'Зазимье',	'Zazym\"ya',	'Zazym\"ya',	1,	55067,	'2019-03-16 03:59:51',	'Zazym\"ya',	'Zazym\"ya',	'Zazym\"ya'),
(687700,	222,	687699,	'Запорожье',	'Zaporizhzhya',	'Zaporizhzhya',	1,	55046,	'2019-03-16 03:59:51',	'Zaporizhzhya',	'Zaporizhzhya',	'Zaporizhzhya'),
(687997,	222,	698738,	'Южный',	'Yuzhne',	'Yuzhne',	1,	55002,	'2019-03-16 03:59:51',	'Yuzhne',	'Yuzhne',	'Yuzhne'),
(688105,	222,	703883,	'Евпатория',	'Yevpatoriya',	'Yevpatoriya',	1,	54931,	'2019-03-16 03:59:51',	'Yevpatoriya',	'Yevpatoriya',	'Yevpatoriya'),
(688148,	222,	709716,	'Енакиево',	'Yenakiyeve',	'Yenakiyeve',	1,	54919,	'2019-03-16 03:59:51',	'Yenakiyeve',	'Yenakiyeve',	'Yenakiyeve'),
(688288,	222,	702549,	'Яворов',	'Yavoriv',	'Yavoriv',	1,	54893,	'2019-03-16 03:59:51',	'Yavoriv',	'Yavoriv',	'Yavoriv'),
(688373,	222,	709716,	'Ясиноватая',	'Yasinovataya',	'Yasinovataya',	1,	54886,	'2019-03-16 03:59:51',	'Yasinovataya',	'Yasinovataya',	'Yasinovataya'),
(688455,	222,	707470,	'Яремче',	'Yaremche',	'Yaremche',	1,	54879,	'2019-03-16 03:59:51',	'Yaremche',	'Yaremche',	'Yaremche'),
(688533,	222,	703883,	'Ялта',	'Yalta',	'Yalta',	1,	54868,	'2019-03-16 03:59:51',	'Yalta',	'Yalta',	'Yalta'),
(688587,	222,	703446,	'Яготин',	'Yahotyn',	'Yahotyn',	1,	54853,	'2019-03-16 03:59:51',	'Yahotyn',	'Yahotyn',	'Yahotyn'),
(688723,	222,	703446,	'Вышгород',	'Vyshgorod',	'Vyshgorod',	1,	52373,	'2019-03-16 03:59:51',	'Vyshgorod',	'Vyshgorod',	'Vyshgorod'),
(688746,	222,	687869,	'Виноградов',	'Vynohradiv',	'Vynohradiv',	1,	52370,	'2019-03-16 03:59:51',	'Vynohradiv',	'Vynohradiv',	'Vynohradiv'),
(688750,	222,	698738,	'Вилково',	'Vylkove',	'Vylkove',	1,	52369,	'2019-03-16 03:59:51',	'Vylkove',	'Vylkove',	'Vylkove'),
(688860,	222,	700567,	'Вознесенск',	'Voznesensk',	'Voznesensk',	1,	52349,	'2019-03-16 03:59:51',	'Voznesensk',	'Voznesensk',	'Voznesensk'),
(689159,	222,	706370,	'Волочиск',	'Volochys\'k',	'Volochys\'k',	1,	52279,	'2019-03-16 03:59:51',	'Volochys\'k',	'Volochys\'k',	'Volochys\'k'),
(689200,	222,	709929,	'Вольногорск',	'Vil\'nohirs\'k',	'Vil\'nohirs\'k',	1,	51604,	'2019-03-16 03:59:51',	'Vil\'nohirs\'k',	'Vil\'nohirs\'k',	'Vil\'nohirs\'k'),
(689304,	222,	706482,	'Волчанск',	'Vovchans\'k',	'Vovchans\'k',	1,	52345,	'2019-03-16 03:59:51',	'Vovchans\'k',	'Vovchans\'k',	'Vovchans\'k'),
(689487,	222,	703446,	'Вишнёвое',	'Vyshneve',	'Vyshneve',	1,	52374,	'2019-03-16 03:59:51',	'Vyshneve',	'Vyshneve',	'Vyshneve'),
(689558,	222,	689559,	'Винница',	'Vinnytsya',	'Vinnytsya',	1,	52085,	'2019-03-16 03:59:51',	'Vinnytsya',	'Vinnytsya',	'Vinnytsya'),
(690266,	222,	703446,	'Великая Дымерка',	'Velyka Dymerka',	'Velyka Dymerka',	1,	51119,	'2019-03-16 03:59:51',	'Velyka Dymerka',	'Velyka Dymerka',	'Velyka Dymerka'),
(690412,	222,	703446,	'Васильков',	'Vasylkiv',	'Vasylkiv',	1,	50973,	'2019-03-16 03:59:51',	'Vasylkiv',	'Vasylkiv',	'Vasylkiv'),
(690469,	222,	710734,	'Варва',	'Varva',	'Varva',	1,	50951,	'2019-03-16 03:59:51',	'Varva',	'Varva',	'Varva'),
(690509,	222,	706482,	'Валки',	'Valky',	'Valky',	1,	50746,	'2019-03-16 03:59:51',	'Valky',	'Valky',	'Valky'),
(690545,	222,	703446,	'Узин',	'Uzyn',	'Uzyn',	1,	50614,	'2019-03-16 03:59:51',	'Uzyn',	'Uzyn',	'Uzyn'),
(690548,	222,	687869,	'Ужгород',	'Uzhhorod',	'Uzhhorod',	1,	50611,	'2019-03-16 03:59:51',	'Uzhhorod',	'Uzhhorod',	'Uzhhorod'),
(690688,	222,	710802,	'Умань',	'Uman\'',	'Uman\'',	1,	50326,	'2019-03-16 03:59:51',	'Uman\'',	'Uman\'',	'Uman\''),
(690773,	222,	703446,	'Украинка',	'Ukrainka',	'Ukrainka',	1,	50296,	'2019-03-16 03:59:51',	'Ukrainka',	'Ukrainka',	'Ukrainka'),
(690823,	222,	709716,	'Угледар',	'Ugledar',	'Ugledar',	1,	50283,	'2019-03-16 03:59:51',	'Ugledar',	'Ugledar',	'Ugledar'),
(690906,	222,	687869,	'Тячев',	'Tyachiv',	'Tyachiv',	1,	50204,	'2019-03-16 03:59:51',	'Tyachiv',	'Tyachiv',	'Tyachiv'),
(691037,	222,	706442,	'Цюрупинск',	'Tsyurupyns\'k',	'Tsyurupyns\'k',	1,	50060,	'2019-03-16 03:59:51',	'Tsyurupyns\'k',	'Tsyurupyns\'k',	'Tsyurupyns\'k'),
(691179,	222,	702549,	'Трускавец',	'Truskavets',	'Truskavets',	1,	50047,	'2019-03-16 03:59:51',	'Truskavets',	'Truskavets',	'Truskavets'),
(691374,	222,	709716,	'Торез',	'Torez',	'Torez',	1,	49451,	'2019-03-16 03:59:51',	'Torez',	'Torez',	'Torez'),
(691469,	222,	687699,	'Токмак',	'Tokmak',	'Tokmak',	1,	49345,	'2019-03-16 03:59:51',	'Tokmak',	'Tokmak',	'Tokmak'),
(691628,	222,	709929,	'Терновка',	'Ternivka',	'Ternivka',	1,	48822,	'2019-03-16 03:59:51',	'Ternivka',	'Ternivka',	'Ternivka'),
(691650,	222,	691649,	'Тернополь',	'Ternopil\'',	'Ternopil\'',	1,	48823,	'2019-03-16 03:59:51',	'Ternopil\'',	'Ternopil\'',	'Ternopil\''),
(691715,	222,	706370,	'Теофиполь',	'Teofipol\'',	'Teofipol\'',	1,	48799,	'2019-03-16 03:59:51',	'Teofipol\'',	'Teofipol\'',	'Teofipol\''),
(691856,	222,	703446,	'Тарасовка',	'Tarasivka',	'Tarasivka',	1,	48558,	'2019-03-16 03:59:51',	'Tarasivka',	'Tarasivka',	'Tarasivka'),
(691999,	222,	702657,	'Северодонецк',	'Syeverodonets\'k',	'Syeverodonets\'k',	1,	48356,	'2019-03-16 03:59:51',	'Syeverodonets\'k',	'Syeverodonets\'k',	'Syeverodonets\'k'),
(692087,	222,	705811,	'Светловодск',	'Svitlovods\'k',	'Svitlovods\'k',	1,	48295,	'2019-03-16 03:59:51',	'Svitlovods\'k',	'Svitlovods\'k',	'Svitlovods\'k'),
(692102,	222,	692196,	'Свесса',	'Svesa',	'Svesa',	1,	48290,	'2019-03-16 03:59:51',	'Svesa',	'Svesa',	'Svesa'),
(692118,	222,	702657,	'Сватово',	'Svatove',	'Svatove',	1,	48289,	'2019-03-16 03:59:51',	'Svatove',	'Svatove',	'Svatove'),
(692129,	222,	687869,	'Свалява',	'Svalyava',	'Svalyava',	1,	48288,	'2019-03-16 03:59:51',	'Svalyava',	'Svalyava',	'Svalyava'),
(692194,	222,	692196,	'Сумы',	'Sumy',	'Sumy',	1,	48151,	'2019-03-16 03:59:51',	'Sumy',	'Sumy',	'Sumy'),
(692315,	222,	703883,	'Судак',	'Sudak',	'Sudak',	1,	48020,	'2019-03-16 03:59:51',	'Sudak',	'Sudak',	'Sudak'),
(692372,	222,	702549,	'Стрый',	'Stryi',	'Stryi',	1,	47957,	'2019-03-16 03:59:51',	'Stryi',	'Stryi',	'Stryi'),
(692818,	222,	706370,	'Староконстантинов',	'Starokostyantyniv',	'Starokostyantyniv',	1,	47501,	'2019-03-16 03:59:51',	'Starokostyantyniv',	'Starokostyantyniv',	'Starokostyantyniv'),
(692832,	222,	702657,	'Старобельск',	'Starobil\'s\'k',	'Starobil\'s\'k',	1,	47500,	'2019-03-16 03:59:51',	'Starobil\'s\'k',	'Starobil\'s\'k',	'Starobil\'s\'k'),
(692975,	222,	702657,	'Стаханов',	'Stakhanov',	'Stakhanov',	1,	47401,	'2019-03-16 03:59:51',	'Stakhanov',	'Stakhanov',	'Stakhanov'),
(693194,	222,	706482,	'Солоницевка',	'Solonytsivka',	'Solonytsivka',	1,	46707,	'2019-03-16 03:59:51',	'Solonytsivka',	'Solonytsivka',	'Solonytsivka'),
(693284,	222,	710720,	'Сокиряны',	'Sokyryany',	'Sokyryany',	1,	46646,	'2019-03-16 03:59:51',	'Sokyryany',	'Sokyryany',	'Sokyryany'),
(693301,	222,	702549,	'Сокаль',	'Sokal\'',	'Sokal\'',	1,	46645,	'2019-03-16 03:59:51',	'Sokal\'',	'Sokal\'',	'Sokal\''),
(693365,	222,	707470,	'Снятын ',	'Snyatyn',	'Snyatyn',	1,	46598,	'2019-03-16 03:59:51',	'Snyatyn',	'Snyatyn',	'Snyatyn'),
(693381,	222,	709716,	'Снежное',	'Snizhne',	'Snizhne',	1,	46584,	'2019-03-16 03:59:51',	'Snizhne',	'Snizhne',	'Snizhne'),
(693457,	222,	710802,	'Смела',	'Smila',	'Smila',	1,	46529,	'2019-03-16 03:59:51',	'Smila',	'Smila',	'Smila'),
(693468,	222,	709716,	'Славянск',	'Sloviansk',	'Sloviansk',	1,	46519,	'2019-03-16 03:59:51',	'Sloviansk',	'Sloviansk',	'Sloviansk'),
(693581,	222,	706370,	'Славута',	'Slavuta',	'Slavuta',	1,	46495,	'2019-03-16 03:59:51',	'Slavuta',	'Slavuta',	'Slavuta'),
(693709,	222,	706442,	'Скадовск',	'Skadovsk',	'Skadovsk',	1,	46461,	'2019-03-16 03:59:51',	'Skadovsk',	'Skadovsk',	'Skadovsk'),
(693805,	222,	703883,	'Симферополь',	'Simferopol',	'Simferopol',	1,	46360,	'2019-03-16 03:59:51',	'Simferopol',	'Simferopol',	'Simferopol'),
(693942,	222,	692196,	'Шостка',	'Shostka',	'Shostka',	1,	46172,	'2019-03-16 03:59:51',	'Shostka',	'Shostka',	'Shostka'),
(694216,	222,	706370,	'Шепетовка',	'Shepetivka',	'Shepetivka',	1,	46065,	'2019-03-16 03:59:51',	'Shepetivka',	'Shepetivka',	'Shepetivka'),
(694350,	222,	689559,	'Шаргород',	'Sharhorod',	'Sharhorod',	1,	45965,	'2019-03-16 03:59:51',	'Sharhorod',	'Sharhorod',	'Sharhorod'),
(694423,	222,	694422,	'Севастополь',	'Sevastopol\'',	'Sevastopol\'',	1,	45860,	'2019-03-16 03:59:51',	'Sevastopol\'',	'Sevastopol\'',	'Sevastopol\''),
(694677,	222,	709716,	'Селидово',	'Selidovo',	'Selidovo',	1,	45611,	'2019-03-16 03:59:51',	'Selidovo',	'Selidovo',	'Selidovo'),
(694792,	222,	695592,	'Сарны',	'Sarny',	'Sarny',	1,	44708,	'2019-03-16 03:59:51',	'Sarny',	'Sarny',	'Sarny'),
(694910,	222,	703883,	'Саки',	'Saky',	'Saky',	1,	43712,	'2019-03-16 03:59:51',	'Saky',	'Saky',	'Saky'),
(695274,	222,	702657,	'Рубежное',	'Rubizhne',	'Rubizhne',	1,	41932,	'2019-03-16 03:59:51',	'Rubizhne',	'Rubizhne',	'Rubizhne'),
(695326,	222,	689064,	'Рожище',	'Rozhyshche',	'Rozhyshche',	1,	41915,	'2019-03-16 03:59:51',	'Rozhyshche',	'Rozhyshche',	'Rozhyshche'),
(695342,	222,	702549,	'Раздол',	'Rozdil',	'Rozdil',	1,	41910,	'2019-03-16 03:59:51',	'Rozdil',	'Rozdil',	'Rozdil'),
(695379,	222,	702657,	'Ровеньки',	'Roven\'ki',	'Roven\'ki',	1,	41839,	'2019-03-16 03:59:51',	'Roven\'ki',	'Roven\'ki',	'Roven\'ki'),
(695464,	222,	692196,	'Ромны',	'Romny',	'Romny',	1,	41475,	'2019-03-16 03:59:51',	'Romny',	'Romny',	'Romny'),
(695516,	222,	695592,	'Рокитное',	'Rokytne',	'Rokytne',	1,	41412,	'2019-03-16 03:59:51',	'Rokytne',	'Rokytne',	'Rokytne'),
(695559,	222,	707470,	'Рогатин',	'Rohatyn',	'Rohatyn',	1,	41385,	'2019-03-16 03:59:51',	'Rohatyn',	'Rohatyn',	'Rohatyn'),
(695594,	222,	695592,	'Ровно',	'Rivne',	'Rivne',	1,	41075,	'2019-03-16 03:59:51',	'Rivne',	'Rivne',	'Rivne'),
(695653,	222,	710734,	'Репки',	'Ripky',	'Ripky',	1,	40952,	'2019-03-16 03:59:51',	'Ripky',	'Ripky',	'Ripky'),
(695740,	222,	703883,	'Раздольное',	'Rozdol\'ne',	'Rozdol\'ne',	1,	41911,	'2019-03-16 03:59:51',	'Rozdol\'ne',	'Rozdol\'ne',	'Rozdol\'ne'),
(695859,	222,	687869,	'Рахов',	'Rakhiv',	'Rakhiv',	1,	39915,	'2019-03-16 03:59:51',	'Rakhiv',	'Rakhiv',	'Rakhiv'),
(696032,	222,	702549,	'Пустомыты',	'Pustomyty',	'Pustomyty',	1,	39595,	'2019-03-16 03:59:51',	'Pustomyty',	'Pustomyty',	'Pustomyty'),
(696108,	222,	710734,	'Прилуки',	'Pryluky',	'Pryluky',	1,	39467,	'2019-03-16 03:59:51',	'Pryluky',	'Pryluky',	'Pryluky'),
(696292,	222,	687699,	'Приморск',	'Prymors\'k',	'Prymors\'k',	1,	39468,	'2019-03-16 03:59:51',	'Prymors\'k',	'Prymors\'k',	'Prymors\'k'),
(696557,	222,	686966,	'Попельня',	'Popil\'nya',	'Popil\'nya',	1,	38795,	'2019-03-16 03:59:51',	'Popil\'nya',	'Popil\'nya',	'Popil\'nya'),
(696581,	222,	705811,	'Помошная',	'Pomichna',	'Pomichna',	1,	38599,	'2019-03-16 03:59:51',	'Pomichna',	'Pomichna',	'Pomichna'),
(696643,	222,	696634,	'Полтава',	'Poltava',	'Poltava',	1,	38577,	'2019-03-16 03:59:51',	'Poltava',	'Poltava',	'Poltava'),
(696660,	222,	706370,	'Полонное',	'Polonne',	'Polonne',	1,	38573,	'2019-03-16 03:59:51',	'Polonne',	'Polonne',	'Polonne'),
(697183,	222,	696634,	'Пирятин',	'Pyryatyn',	'Pyryatyn',	1,	39637,	'2019-03-16 03:59:51',	'Pyryatyn',	'Pyryatyn',	'Pyryatyn'),
(697488,	222,	706482,	'Песочин',	'Pesochin',	'Pesochin',	1,	37552,	'2019-03-16 03:59:51',	'Pesochin',	'Pesochin',	'Pesochin'),
(697576,	222,	706482,	'Первомайский',	'Pervomays\'kyy',	'Pervomays\'kyy',	1,	37531,	'2019-03-16 03:59:51',	'Pervomays\'kyy',	'Pervomays\'kyy',	'Pervomays\'kyy'),
(697592,	222,	702657,	'Первомайск',	'Pervomaysk',	'Pervomaysk',	1,	37532,	'2019-03-16 03:59:51',	'Pervomaysk',	'Pervomaysk',	'Pervomaysk'),
(697593,	222,	700567,	'Первомайск',	'Pervomays\'k',	'Pervomays\'k',	1,	37530,	'2019-03-16 03:59:51',	'Pervomays\'k',	'Pervomays\'k',	'Pervomays\'k'),
(697637,	222,	703446,	'Переяслав-Хмельницкий',	'Pereyaslav-Khmel\'nyts\'kyy',	'Pereyaslav-Khmel\'nyts\'kyy',	1,	37418,	'2019-03-16 03:59:51',	'Pereyaslav-Khmel\'nyts\'kyy',	'Pereyaslav-Khmel\'nyts\'kyy',	'Pereyaslav-Khmel\'nyts\'kyy'),
(697750,	222,	687869,	'Перечин',	'Perechyn',	'Perechyn',	1,	37412,	'2019-03-16 03:59:51',	'Perechyn',	'Perechyn',	'Perechyn'),
(697889,	222,	709929,	'Павлоград',	'Pavlohrad',	'Pavlohrad',	1,	37121,	'2019-03-16 03:59:51',	'Pavlohrad',	'Pavlohrad',	'Pavlohrad'),
(698131,	222,	686966,	'Овруч',	'Ovruch',	'Ovruch',	1,	36490,	'2019-03-16 03:59:51',	'Ovruch',	'Ovruch',	'Ovruch'),
(698138,	222,	698738,	'Овидиополь',	'Ovidiopol\'',	'Ovidiopol\'',	1,	36483,	'2019-03-16 03:59:51',	'Ovidiopol\'',	'Ovidiopol\'',	'Ovidiopol\''),
(698436,	222,	709929,	'Орджоникидзе',	'Ordzhonikidze',	'Ordzhonikidze',	1,	36060,	'2019-03-16 03:59:51',	'Ordzhonikidze',	'Ordzhonikidze',	'Ordzhonikidze'),
(698483,	222,	687869,	'Оноковцы',	'Onokivtsi',	'Onokivtsi',	1,	35950,	'2019-03-16 03:59:51',	'Onokivtsi',	'Onokivtsi',	'Onokivtsi'),
(698625,	222,	705811,	'Александрия',	'Oleksandriya',	'Oleksandriya',	1,	35812,	'2019-03-16 03:59:51',	'Oleksandriya',	'Oleksandriya',	'Oleksandriya'),
(698740,	222,	698738,	'Одесса',	'Odessa',	'Odessa',	1,	35597,	'2019-03-16 03:59:51',	'Odessa',	'Odessa',	'Odessa'),
(698782,	222,	703446,	'Обухов',	'Obukhiv',	'Obukhiv',	1,	35527,	'2019-03-16 03:59:51',	'Obukhiv',	'Obukhiv',	'Obukhiv'),
(698953,	222,	700567,	'Новый Буг',	'Novyy Buh',	'Novyy Buh',	1,	35193,	'2019-03-16 03:59:51',	'Novyy Buh',	'Novyy Buh',	'Novyy Buh'),
(699035,	222,	689064,	'Нововолынск',	'Novovolyns\'k',	'Novovolyns\'k',	1,	35191,	'2019-03-16 03:59:51',	'Novovolyns\'k',	'Novovolyns\'k',	'Novovolyns\'k'),
(699096,	222,	709716,	'Новотроицкое',	'Novotroitskoye',	'Novotroitskoye',	1,	35188,	'2019-03-16 03:59:51',	'Novotroitskoye',	'Novotroitskoye',	'Novotroitskoye'),
(699445,	222,	709929,	'Новомосковск',	'Novomoskovs\'k',	'Novomoskovs\'k',	1,	35180,	'2019-03-16 03:59:51',	'Novomoskovs\'k',	'Novomoskovs\'k',	'Novomoskovs\'k'),
(699553,	222,	686966,	'Новоград-Волынский',	'Novohrad-Volyns\'kyy',	'Novohrad-Volyns\'kyy',	1,	35173,	'2019-03-16 03:59:51',	'Novohrad-Volyns\'kyy',	'Novohrad-Volyns\'kyy',	'Novohrad-Volyns\'kyy'),
(699615,	222,	702657,	'Новодружеск',	'Novodruzhesk',	'Novodruzhesk',	1,	35172,	'2019-03-16 03:59:51',	'Novodruzhesk',	'Novodruzhesk',	'Novodruzhesk'),
(699620,	222,	710720,	'Новоднестровск',	'Novodnistrovs\'k',	'Novodnistrovs\'k',	1,	35171,	'2019-03-16 03:59:51',	'Novodnistrovs\'k',	'Novodnistrovs\'k',	'Novodnistrovs\'k'),
(699839,	222,	706442,	'Новая Каховка',	'Nova Kakhovka',	'Nova Kakhovka',	1,	35138,	'2019-03-16 03:59:51',	'Nova Kakhovka',	'Nova Kakhovka',	'Nova Kakhovka'),
(699917,	222,	710734,	'Носовка',	'Nosivka',	'Nosivka',	1,	35093,	'2019-03-16 03:59:51',	'Nosivka',	'Nosivka',	'Nosivka'),
(699942,	222,	710734,	'Нежин',	'Nizhyn',	'Nizhyn',	1,	34682,	'2019-03-16 03:59:51',	'Nizhyn',	'Nizhyn',	'Nizhyn'),
(700019,	222,	703883,	'Нижнегорский',	'Nyzhn\'ohirs\'kyy',	'Nyzhn\'ohirs\'kyy',	1,	35279,	'2019-03-16 03:59:51',	'Nyzhn\'ohirs\'kyy',	'Nyzhn\'ohirs\'kyy',	'Nyzhn\'ohirs\'kyy'),
(700051,	222,	709929,	'Никополь',	'Nikopol\'',	'Nikopol\'',	1,	34631,	'2019-03-16 03:59:51',	'Nikopol\'',	'Nikopol\'',	'Nikopol\''),
(700261,	222,	706370,	'Нетишин',	'Netishyn',	'Netishyn',	1,	33857,	'2019-03-16 03:59:51',	'Netishyn',	'Netishyn',	'Netishyn'),
(700416,	222,	703883,	'Научный',	'Nauchnyy',	'Nauchnyy',	1,	33635,	'2019-03-16 03:59:51',	'Nauchnyy',	'Nauchnyy',	'Nauchnyy'),
(700550,	222,	703883,	'Щёлкино',	'Mysove',	'Mysove',	1,	33445,	'2019-03-16 03:59:51',	'Mysove',	'Mysove',	'Mysove'),
(700568,	222,	702549,	'Николаев',	'Mykolayiv',	'Mykolayiv',	1,	33435,	'2019-03-16 03:59:51',	'Mykolayiv',	'Mykolayiv',	'Mykolayiv'),
(700569,	222,	700567,	'Николаев',	'Mykolayiv',	'Mykolayiv',	1,	33434,	'2019-03-16 03:59:51',	'Mykolayiv',	'Mykolayiv',	'Mykolayiv'),
(700646,	222,	687869,	'Мукачево',	'Mukacheve',	'Mukacheve',	1,	33245,	'2019-03-16 03:59:51',	'Mukacheve',	'Mukacheve',	'Mukacheve'),
(700696,	222,	702549,	'Мостиска',	'Mostys\'ka',	'Mostys\'ka',	1,	32941,	'2019-03-16 03:59:51',	'Mostys\'ka',	'Mostys\'ka',	'Mostys\'ka'),
(700829,	222,	702657,	'Молодогвардейск',	'Molodogvardeysk',	'Molodogvardeysk',	1,	31877,	'2019-03-16 03:59:51',	'Molodogvardeysk',	'Molodogvardeysk',	'Molodogvardeysk'),
(700918,	222,	689559,	'Могилёв-Подольский',	'Mohyliv-Podil\'s\'kyy',	'Mohyliv-Podil\'s\'kyy',	1,	31806,	'2019-03-16 03:59:51',	'Mohyliv-Podil\'s\'kyy',	'Mohyliv-Podil\'s\'kyy',	'Mohyliv-Podil\'s\'kyy'),
(701075,	222,	696634,	'Миргород',	'Myrhorod',	'Myrhorod',	1,	33438,	'2019-03-16 03:59:51',	'Myrhorod',	'Myrhorod',	'Myrhorod'),
(701347,	222,	706482,	'Мерефа',	'Merefa',	'Merefa',	1,	30905,	'2019-03-16 03:59:51',	'Merefa',	'Merefa',	'Merefa'),
(701404,	222,	687699,	'Мелитополь',	'Melitopol\'',	'Melitopol\'',	1,	30729,	'2019-03-16 03:59:51',	'Melitopol\'',	'Melitopol\'',	'Melitopol\''),
(701792,	222,	702657,	'Марковка',	'Markivka',	'Markivka',	1,	29881,	'2019-03-16 03:59:51',	'Markivka',	'Markivka',	'Markivka'),
(701822,	222,	709716,	'Мариуполь',	'Mariupol',	'Mariupol',	1,	29863,	'2019-03-16 03:59:51',	'Mariupol',	'Mariupol',	'Mariupol'),
(701855,	222,	709929,	'Марганец',	'Marhanets\'',	'Marhanets\'',	1,	29760,	'2019-03-16 03:59:51',	'Marhanets\'',	'Marhanets\'',	'Marhanets\''),
(702116,	222,	686966,	'Малин',	'Malyn',	'Malyn',	1,	29384,	'2019-03-16 03:59:51',	'Malyn',	'Malyn',	'Malyn'),
(702320,	222,	709716,	'Макеевка',	'Makiyivka',	'Makiyivka',	1,	29269,	'2019-03-16 03:59:51',	'Makiyivka',	'Makiyivka',	'Makiyivka'),
(702550,	222,	702549,	'Львов',	'L\'viv',	'L\'viv',	1,	25121,	'2019-03-16 03:59:51',	'L\'viv',	'L\'viv',	'L\'viv'),
(702563,	222,	702657,	'Лутугино',	'Lutugino',	'Lutugino',	1,	28885,	'2019-03-16 03:59:51',	'Lutugino',	'Lutugino',	'Lutugino'),
(702569,	222,	689064,	'Луцк',	'Luts\'k',	'Luts\'k',	1,	28875,	'2019-03-16 03:59:51',	'Luts\'k',	'Luts\'k',	'Luts\'k'),
(702658,	222,	702657,	'Луганск',	'Luhans\'k',	'Luhans\'k',	1,	28781,	'2019-03-16 03:59:51',	'Luhans\'k',	'Luhans\'k',	'Luhans\'k'),
(702723,	222,	696634,	'Лубны',	'Lubny',	'Lubny',	1,	28685,	'2019-03-16 03:59:51',	'Lubny',	'Lubny',	'Lubny'),
(702760,	222,	706482,	'Лозовая',	'Lozova',	'Lozova',	1,	28667,	'2019-03-16 03:59:51',	'Lozova',	'Lozova',	'Lozova'),
(702972,	222,	702657,	'Лисичанск',	'Lisichansk',	'Lisichansk',	1,	27933,	'2019-03-16 03:59:51',	'Lisichansk',	'Lisichansk',	'Lisichansk'),
(703061,	222,	698738,	'Лиманское',	'Lymanske',	'Lymanske',	1,	28937,	'2019-03-16 03:59:51',	'Lymanske',	'Lymanske',	'Lymanske'),
(703142,	222,	706370,	'Летичев',	'Letychiv',	'Letychiv',	1,	27484,	'2019-03-16 03:59:51',	'Letychiv',	'Letychiv',	'Letychiv'),
(703448,	222,	703447,	'Киев',	'Kiev',	'Kiev',	1,	24274,	'2019-03-16 03:59:51',	'Kiev',	'Kiev',	'Kiev'),
(703464,	222,	695592,	'Кузнецовск',	'Kuznetsovs\'k',	'Kuznetsovs\'k',	1,	25064,	'2019-03-16 03:59:51',	'Kuznetsovs\'k',	'Kuznetsovs\'k',	'Kuznetsovs\'k'),
(703646,	222,	709716,	'Курахово',	'Kurakhovo',	'Kurakhovo',	1,	25032,	'2019-03-16 03:59:51',	'Kurakhovo',	'Kurakhovo',	'Kurakhovo'),
(703656,	222,	706482,	'Купянск',	'Kupjansk',	'Kupjansk',	1,	25028,	'2019-03-16 03:59:51',	'Kupjansk',	'Kupjansk',	'Kupjansk'),
(703845,	222,	709929,	'Кривой Рог',	'Kryvyy Rih',	'Kryvyy Rih',	1,	24975,	'2019-03-16 03:59:51',	'Kryvyy Rih',	'Kryvyy Rih',	'Kryvyy Rih'),
(704000,	222,	692196,	'Кролевец',	'Krolevets\'',	'Krolevets\'',	1,	24944,	'2019-03-16 03:59:51',	'Krolevets\'',	'Krolevets\'',	'Krolevets\''),
(704138,	222,	702657,	'Кременная',	'Kreminna',	'Kreminna',	1,	24920,	'2019-03-16 03:59:51',	'Kreminna',	'Kreminna',	'Kreminna'),
(704143,	222,	691649,	'Кременец',	'Kremenets\'',	'Kremenets\'',	1,	24919,	'2019-03-16 03:59:51',	'Kremenets\'',	'Kremenets\'',	'Kremenets\''),
(704147,	222,	696634,	'Кременчуг',	'Kremenchuk',	'Kremenchuk',	1,	24918,	'2019-03-16 03:59:51',	'Kremenchuk',	'Kremenchuk',	'Kremenchuk'),
(704202,	222,	702657,	'Красный Луч',	'Krasnyy Luch',	'Krasnyy Luch',	1,	24902,	'2019-03-16 03:59:51',	'Krasnyy Luch',	'Krasnyy Luch',	'Krasnyy Luch'),
(704204,	222,	709716,	'Красный Лиман',	'Krasnyy Liman',	'Krasnyy Liman',	1,	24901,	'2019-03-16 03:59:51',	'Krasnyy Liman',	'Krasnyy Liman',	'Krasnyy Liman'),
(704362,	222,	703883,	'Красноперекопск',	'Krasnoperekops\'k',	'Krasnoperekops\'k',	1,	24892,	'2019-03-16 03:59:51',	'Krasnoperekops\'k',	'Krasnoperekops\'k',	'Krasnoperekops\'k'),
(704377,	222,	703883,	'Краснокаменка',	'Krasnokamenka',	'Krasnokamenka',	1,	24889,	'2019-03-16 03:59:51',	'Krasnokamenka',	'Krasnokamenka',	'Krasnokamenka'),
(704388,	222,	706482,	'Красноград',	'Krasnohrad',	'Krasnohrad',	1,	24888,	'2019-03-16 03:59:51',	'Krasnohrad',	'Krasnohrad',	'Krasnohrad'),
(704403,	222,	702657,	'Краснодон',	'Krasnodon',	'Krasnodon',	1,	24886,	'2019-03-16 03:59:51',	'Krasnodon',	'Krasnodon',	'Krasnodon'),
(704422,	222,	709716,	'Красноармейск',	'Krasnoarmiys\'k',	'Krasnoarmiys\'k',	1,	24884,	'2019-03-16 03:59:51',	'Krasnoarmiys\'k',	'Krasnoarmiys\'k',	'Krasnoarmiys\'k'),
(704492,	222,	706370,	'Красилов',	'Krasyliv',	'Krasyliv',	1,	24906,	'2019-03-16 03:59:51',	'Krasyliv',	'Krasyliv',	'Krasyliv'),
(704508,	222,	709716,	'Краматорск',	'Kramators\'k',	'Kramators\'k',	1,	24876,	'2019-03-16 03:59:51',	'Kramators\'k',	'Kramators\'k',	'Kramators\'k'),
(704525,	222,	691649,	'Козова',	'Kozova',	'Kozova',	1,	24866,	'2019-03-16 03:59:51',	'Kozova',	'Kozova',	'Kozova'),
(704617,	222,	689064,	'Ковель',	'Kovel\'',	'Kovel\'',	1,	24858,	'2019-03-16 03:59:51',	'Kovel\'',	'Kovel\'',	'Kovel\''),
(704670,	222,	703447,	'Коцюбинское',	'Kotsyubyns\'ke',	'Kotsyubyns\'ke',	1,	24846,	'2019-03-16 03:59:51',	'Kotsyubyns\'ke',	'Kotsyubyns\'ke',	'Kotsyubyns\'ke'),
(704737,	222,	695592,	'Костополь',	'Kostopil\'',	'Kostopil\'',	1,	24830,	'2019-03-16 03:59:51',	'Kostopil\'',	'Kostopil\'',	'Kostopil\''),
(704764,	222,	707470,	'Косов',	'Kosiv',	'Kosiv',	1,	24823,	'2019-03-16 03:59:51',	'Kosiv',	'Kosiv',	'Kosiv'),
(704858,	222,	710802,	'Корсунь-Шевченковский',	'Korsun\'-Shevchenkivs\'kyy',	'Korsun\'-Shevchenkivs\'kyy',	1,	24817,	'2019-03-16 03:59:51',	'Korsun\'-Shevchenkivs\'kyy',	'Korsun\'-Shevchenkivs\'kyy',	'Korsun\'-Shevchenkivs\'kyy'),
(704901,	222,	686966,	'Коростень',	'Korosten\'',	'Korosten\'',	1,	24813,	'2019-03-16 03:59:51',	'Korosten\'',	'Korosten\'',	'Korosten\''),
(704920,	222,	687869,	'Королёво',	'Korolevo',	'Korolevo',	1,	24812,	'2019-03-16 03:59:51',	'Korolevo',	'Korolevo',	'Korolevo'),
(705104,	222,	709716,	'Константиновка',	'Kostyantynivka',	'Kostyantynivka',	1,	24832,	'2019-03-16 03:59:51',	'Kostyantynivka',	'Kostyantynivka',	'Kostyantynivka'),
(705106,	222,	709716,	'Константиновка',	'Konstantinovka',	'Konstantinovka',	1,	24785,	'2019-03-16 03:59:51',	'Konstantinovka',	'Konstantinovka',	'Konstantinovka'),
(705135,	222,	692196,	'Конотоп',	'Konotop',	'Konotop',	1,	24784,	'2019-03-16 03:59:51',	'Konotop',	'Konotop',	'Konotop'),
(705183,	222,	706482,	'Комсомольское',	'Komsomol\'s\'ke',	'Komsomol\'s\'ke',	1,	24749,	'2019-03-16 03:59:51',	'Komsomol\'s\'ke',	'Komsomol\'s\'ke',	'Komsomol\'s\'ke'),
(705392,	222,	707470,	'Коломыя',	'Kolomyya',	'Kolomyya',	1,	24746,	'2019-03-16 03:59:51',	'Kolomyya',	'Kolomyya',	'Kolomyya'),
(705660,	222,	695592,	'Клевань',	'Klevan\'',	'Klevan\'',	1,	24632,	'2019-03-16 03:59:51',	'Klevan\'',	'Klevan\'',	'Klevan\''),
(705735,	222,	710720,	'Кицмань',	'Kitsman\'',	'Kitsman\'',	1,	24563,	'2019-03-16 03:59:51',	'Kitsman\'',	'Kitsman\'',	'Kitsman\''),
(705797,	222,	709716,	'Кировское',	'Kirovskoye',	'Kirovskoye',	1,	24535,	'2019-03-16 03:59:51',	'Kirovskoye',	'Kirovskoye',	'Kirovskoye'),
(705812,	222,	705811,	'Кировоград',	'Kirovohrad',	'Kirovohrad',	1,	24531,	'2019-03-16 03:59:51',	'Kirovohrad',	'Kirovohrad',	'Kirovohrad'),
(705883,	222,	698738,	'Килия',	'Kiliya',	'Kiliya',	1,	24286,	'2019-03-16 03:59:51',	'Kiliya',	'Kiliya',	'Kiliya'),
(706165,	222,	687869,	'Хуст',	'Khust',	'Khust',	1,	24253,	'2019-03-16 03:59:51',	'Khust',	'Khust',	'Khust'),
(706352,	222,	702549,	'Khodoriv',	'Khodoriv',	'Khodoriv',	1,	24246,	'2019-03-16 03:59:51',	'Khodoriv',	'Khodoriv',	'Khodoriv'),
(706369,	222,	706370,	'Хмельницкий',	'Khmel\'nyts\'kyy',	'Khmel\'nyts\'kyy',	1,	24243,	'2019-03-16 03:59:51',	'Khmel\'nyts\'kyy',	'Khmel\'nyts\'kyy',	'Khmel\'nyts\'kyy'),
(706380,	222,	689559,	'Хмельник',	'Khmil\'nyk',	'Khmil\'nyk',	1,	24244,	'2019-03-16 03:59:51',	'Khmil\'nyk',	'Khmil\'nyk',	'Khmil\'nyk'),
(706448,	222,	706442,	'Херсон',	'Kherson',	'Kherson',	1,	24240,	'2019-03-16 03:59:51',	'Kherson',	'Kherson',	'Kherson'),
(706466,	222,	709716,	'Харцызск',	'Khartsyzsk',	'Khartsyzsk',	1,	24234,	'2019-03-16 03:59:51',	'Khartsyzsk',	'Khartsyzsk',	'Khartsyzsk'),
(706483,	222,	706482,	'Харьков',	'Kharkiv',	'Kharkiv',	1,	24233,	'2019-03-16 03:59:51',	'Kharkiv',	'Kharkiv',	'Kharkiv'),
(706524,	222,	703883,	'Керчь',	'Kerch',	'Kerch',	1,	24143,	'2019-03-16 03:59:51',	'Kerch',	'Kerch',	'Kerch'),
(706536,	222,	710720,	'Кельменцы',	'Kel\'mentsi',	'Kel\'mentsi',	1,	24020,	'2019-03-16 03:59:51',	'Kel\'mentsi',	'Kel\'mentsi',	'Kel\'mentsi'),
(706571,	222,	689559,	'Казатин',	'Kozyatyn',	'Kozyatyn',	1,	24867,	'2019-03-16 03:59:51',	'Kozyatyn',	'Kozyatyn',	'Kozyatyn'),
(706634,	222,	710802,	'Катеринополь',	'Katerynopil\'',	'Katerynopil\'',	1,	23941,	'2019-03-16 03:59:51',	'Katerynopil\'',	'Katerynopil\'',	'Katerynopil\''),
(706749,	222,	696634,	'Карловка',	'Karlivka',	'Karlivka',	1,	23891,	'2019-03-16 03:59:51',	'Karlivka',	'Karlivka',	'Karlivka'),
(706900,	222,	710802,	'Канев',	'Kaniv',	'Kaniv',	1,	23835,	'2019-03-16 03:59:51',	'Kaniv',	'Kaniv',	'Kaniv'),
(706950,	222,	706370,	'Каменец-Подольский',	'Kamieniec Podolski',	'Kamieniec Podolski',	1,	23806,	'2019-03-16 03:59:51',	'Kamieniec Podolski',	'Kamieniec Podolski',	'Kamieniec Podolski'),
(707027,	222,	702549,	'Каменка Бугская',	'Kamionka Strumitowa',	'Kamionka Strumitowa',	1,	23808,	'2019-03-16 03:59:51',	'Kamionka Strumitowa',	'Kamionka Strumitowa',	'Kamionka Strumitowa'),
(707052,	222,	710802,	'Каменка',	'Kamianka',	'Kamianka',	1,	23805,	'2019-03-16 03:59:51',	'Kamianka',	'Kamianka',	'Kamianka'),
(707099,	222,	707470,	'Калуш',	'Kalush',	'Kalush',	1,	23789,	'2019-03-16 03:59:51',	'Kalush',	'Kalush',	'Kalush'),
(707155,	222,	689559,	'Калиновка',	'Kalynivka',	'Kalynivka',	1,	23793,	'2019-03-16 03:59:51',	'Kalynivka',	'Kalynivka',	'Kalynivka'),
(707244,	222,	706442,	'Каховка',	'Kakhovka',	'Kakhovka',	1,	23751,	'2019-03-16 03:59:51',	'Kakhovka',	'Kakhovka',	'Kakhovka'),
(707251,	222,	703446,	'Кагарлык',	'Kaharlyk',	'Kaharlyk',	1,	23734,	'2019-03-16 03:59:51',	'Kaharlyk',	'Kaharlyk',	'Kaharlyk'),
(707296,	222,	706370,	'Изяслав',	'Izyaslav',	'Izyaslav',	1,	23230,	'2019-03-16 03:59:51',	'Izyaslav',	'Izyaslav',	'Izyaslav'),
(707308,	222,	698738,	'Измаил',	'Izmayil',	'Izmayil',	1,	23222,	'2019-03-16 03:59:51',	'Izmayil',	'Izmayil',	'Izmayil'),
(707471,	222,	707470,	'Ивано-Франковск',	'Ivano-Frankivs\'k',	'Ivano-Frankivs\'k',	1,	23192,	'2019-03-16 03:59:51',	'Ivano-Frankivs\'k',	'Ivano-Frankivs\'k',	'Ivano-Frankivs\'k'),
(707503,	222,	707470,	'Иваниковка',	'Ivanikovka',	'Ivanikovka',	1,	23191,	'2019-03-16 03:59:51',	'Ivanikovka',	'Ivanikovka',	'Ivanikovka'),
(707559,	222,	687869,	'Иршава',	'Irshava',	'Irshava',	1,	23030,	'2019-03-16 03:59:51',	'Irshava',	'Irshava',	'Irshava'),
(707565,	222,	703446,	'Ирпень',	'Irpin',	'Irpin',	1,	23024,	'2019-03-16 03:59:51',	'Irpin',	'Irpin',	'Irpin'),
(707688,	222,	698738,	'Ильичёвск',	'Illichivs\'k',	'Illichivs\'k',	1,	22784,	'2019-03-16 03:59:51',	'Illichivs\'k',	'Illichivs\'k',	'Illichivs\'k'),
(707744,	222,	710734,	'Ичня',	'Ichnya',	'Ichnya',	1,	22706,	'2019-03-16 03:59:51',	'Ichnya',	'Ichnya',	'Ichnya'),
(707752,	222,	706370,	'Городок',	'Horodok',	'Horodok',	1,	22284,	'2019-03-16 03:59:51',	'Horodok',	'Horodok',	'Horodok'),
(707753,	222,	709716,	'Горловка',	'Horlivka',	'Horlivka',	1,	22255,	'2019-03-16 03:59:51',	'Horlivka',	'Horlivka',	'Horlivka'),
(707757,	222,	710720,	'Глыбокая',	'Hlyboka',	'Hlyboka',	1,	21862,	'2019-03-16 03:59:51',	'Hlyboka',	'Hlyboka',	'Hlyboka'),
(707898,	222,	687699,	'Гуляйполе',	'Hulyaypole',	'Hulyaypole',	1,	22525,	'2019-03-16 03:59:51',	'Hulyaypole',	'Hulyaypole',	'Hulyaypole'),
(708313,	222,	702549,	'Городок',	'Horodok',	'Horodok',	1,	22283,	'2019-03-16 03:59:51',	'Horodok',	'Horodok',	'Horodok'),
(708380,	222,	707470,	'Городенка',	'Horodenka',	'Horodenka',	1,	22282,	'2019-03-16 03:59:51',	'Horodenka',	'Horodenka',	'Horodenka'),
(708617,	222,	686966,	'Олиевка',	'Oliyivka',	'Oliyivka',	1,	35852,	'2019-03-16 03:59:51',	'Oliyivka',	'Oliyivka',	'Oliyivka'),
(708632,	222,	706442,	'Голая Пристань',	'Hola Prystan\'',	'Hola Prystan\'',	1,	21986,	'2019-03-16 03:59:51',	'Hola Prystan\'',	'Hola Prystan\'',	'Hola Prystan\''),
(708878,	222,	706442,	'Геническ',	'Heniches\'k',	'Heniches\'k',	1,	21351,	'2019-03-16 03:59:51',	'Heniches\'k',	'Heniches\'k',	'Heniches\'k'),
(709034,	222,	707470,	'Галич',	'Halych',	'Halych',	1,	20464,	'2019-03-16 03:59:51',	'Halych',	'Halych',	'Halych'),
(709054,	222,	696634,	'Гадяч',	'Hadyach',	'Hadyach',	1,	20323,	'2019-03-16 03:59:51',	'Hadyach',	'Hadyach',	'Hadyach'),
(709161,	222,	703883,	'Феодосия',	'Feodosiya',	'Feodosiya',	1,	16482,	'2019-03-16 03:59:51',	'Feodosiya',	'Feodosiya',	'Feodosiya'),
(709248,	222,	703446,	'Фастов',	'Fastiv',	'Fastiv',	1,	16326,	'2019-03-16 03:59:51',	'Fastiv',	'Fastiv',	'Fastiv'),
(709276,	222,	687699,	'Энергодар',	'Energodar',	'Energodar',	1,	15347,	'2019-03-16 03:59:51',	'Energodar',	'Energodar',	'Energodar'),
(709334,	222,	703883,	'Джанкой',	'Dzhankoy',	'Dzhankoy',	1,	14291,	'2019-03-16 03:59:51',	'Dzhankoy',	'Dzhankoy',	'Dzhankoy'),
(709354,	222,	709716,	'Дзержинск',	'Dzerzhyns\'k',	'Dzerzhyns\'k',	1,	14289,	'2019-03-16 03:59:51',	'Dzerzhyns\'k',	'Dzerzhyns\'k',	'Dzerzhyns\'k'),
(709429,	222,	706370,	'Дунаевцы',	'Dunaivtsi',	'Dunaivtsi',	1,	14142,	'2019-03-16 03:59:51',	'Dunaivtsi',	'Dunaivtsi',	'Dunaivtsi'),
(709493,	222,	695592,	'Дубровица',	'Dubrovytsya',	'Dubrovytsya',	1,	14078,	'2019-03-16 03:59:51',	'Dubrovytsya',	'Dubrovytsya',	'Dubrovytsya'),
(709611,	222,	702549,	'Дрогобыч',	'Drohobych',	'Drohobych',	1,	14017,	'2019-03-16 03:59:51',	'Drohobych',	'Drohobych',	'Drohobych'),
(709717,	222,	709716,	'Донецк',	'Donets\'k',	'Donets\'k',	1,	13736,	'2019-03-16 03:59:51',	'Donets\'k',	'Donets\'k',	'Donets\'k'),
(709835,	222,	709716,	'Докучаевск',	'Dokuchayevsk',	'Dokuchayevsk',	1,	13641,	'2019-03-16 03:59:51',	'Dokuchayevsk',	'Dokuchayevsk',	'Dokuchayevsk'),
(709900,	222,	709716,	'Доброполье',	'Dobropol\'ye',	'Dobropol\'ye',	1,	13605,	'2019-03-16 03:59:51',	'Dobropol\'ye',	'Dobropol\'ye',	'Dobropol\'ye'),
(709909,	222,	702549,	'Добромиль',	'Dobromil\'',	'Dobromil\'',	1,	13604,	'2019-03-16 03:59:51',	'Dobromil\'',	'Dobromil\'',	'Dobromil\''),
(709930,	222,	709929,	'Днепропетровск',	'Dnipropetrovsk',	'Dnipropetrovsk',	1,	13593,	'2019-03-16 03:59:51',	'Dnipropetrovsk',	'Dnipropetrovsk',	'Dnipropetrovsk'),
(709932,	222,	709929,	'Днепродзержинск',	'Dniprodzerzhyns\'k',	'Dniprodzerzhyns\'k',	1,	13592,	'2019-03-16 03:59:51',	'Dniprodzerzhyns\'k',	'Dniprodzerzhyns\'k',	'Dniprodzerzhyns\'k'),
(709960,	222,	687699,	'Днепрорудное',	'Dniprorudne',	'Dniprorudne',	1,	13594,	'2019-03-16 03:59:51',	'Dniprorudne',	'Dniprorudne',	'Dniprorudne'),
(710035,	222,	709716,	'Димитров',	'Dimitrov',	'Dimitrov',	1,	13501,	'2019-03-16 03:59:51',	'Dimitrov',	'Dimitrov',	'Dimitrov'),
(710071,	222,	710734,	'Десна',	'Desna',	'Desna',	1,	13295,	'2019-03-16 03:59:51',	'Desna',	'Desna',	'Desna'),
(710098,	222,	706482,	'Дергачи',	'Derhachi',	'Derhachi',	1,	13255,	'2019-03-16 03:59:51',	'Derhachi',	'Derhachi',	'Derhachi'),
(710129,	222,	706370,	'Деражня',	'Derazhnya',	'Derazhnya',	1,	13246,	'2019-03-16 03:59:51',	'Derazhnya',	'Derazhnya',	'Derazhnya'),
(710229,	222,	709716,	'Дебальцево',	'Debal\'tsevo',	'Debal\'tsevo',	1,	13007,	'2019-03-16 03:59:51',	'Debal\'tsevo',	'Debal\'tsevo',	'Debal\'tsevo'),
(710333,	222,	698738,	'Дачное',	'Dachnoye',	'Dachnoye',	1,	12647,	'2019-03-16 03:59:51',	'Dachnoye',	'Dachnoye',	'Dachnoye'),
(710374,	222,	706482,	'Чугуев',	'Chuhuyiv',	'Chuhuyiv',	1,	10468,	'2019-03-16 03:59:51',	'Chuhuyiv',	'Chuhuyiv',	'Chuhuyiv'),
(710403,	222,	703446,	'Чернобыль',	'Chornobyl\'',	'Chornobyl\'',	1,	10436,	'2019-03-16 03:59:51',	'Chornobyl\'',	'Chornobyl\'',	'Chornobyl\''),
(710554,	222,	702549,	'Червоноград',	'Chervonohrad',	'Chervonohrad',	1,	10170,	'2019-03-16 03:59:51',	'Chervonohrad',	'Chervonohrad',	'Chervonohrad'),
(710716,	222,	710802,	'Чернобай',	'Chornobay',	'Chornobay',	1,	10435,	'2019-03-16 03:59:51',	'Chornobay',	'Chornobay',	'Chornobay'),
(710719,	222,	710720,	'Черновцы',	'Chernivtsi',	'Chernivtsi',	1,	10138,	'2019-03-16 03:59:51',	'Chernivtsi',	'Chernivtsi',	'Chernivtsi'),
(710735,	222,	710734,	'Чернигов',	'Chernihiv',	'Chernihiv',	1,	10136,	'2019-03-16 03:59:51',	'Chernihiv',	'Chernihiv',	'Chernihiv'),
(710741,	222,	689559,	'Черневцы',	'Chernivtsi',	'Chernivtsi',	1,	10137,	'2019-03-16 03:59:51',	'Chernivtsi',	'Chernivtsi',	'Chernivtsi'),
(710791,	222,	710802,	'Черкассы',	'Cherkasy',	'Cherkasy',	1,	10133,	'2019-03-16 03:59:51',	'Cherkasy',	'Cherkasy',	'Cherkasy'),
(711103,	222,	702549,	'Буск',	'Bus\'k',	'Bus\'k',	1,	7533,	'2019-03-16 03:59:51',	'Bus\'k',	'Bus\'k',	'Bus\'k'),
(711116,	222,	692196,	'Бурынь',	'Buryn\'',	'Buryn\'',	1,	7532,	'2019-03-16 03:59:51',	'Buryn\'',	'Buryn\'',	'Buryn\''),
(711134,	222,	707470,	'Бурштын',	'Burshtyn',	'Burshtyn',	1,	7501,	'2019-03-16 03:59:51',	'Burshtyn',	'Burshtyn',	'Burshtyn'),
(711348,	222,	691649,	'Бучач',	'Buchach',	'Buchach',	1,	7141,	'2019-03-16 03:59:51',	'Buchach',	'Buchach',	'Buchach'),
(711350,	222,	703446,	'Буча',	'Bucha',	'Bucha',	1,	7139,	'2019-03-16 03:59:51',	'Bucha',	'Bucha',	'Bucha'),
(711390,	222,	703446,	'Бровары',	'Brovary',	'Brovary',	1,	6976,	'2019-03-16 03:59:51',	'Brovary',	'Brovary',	'Brovary'),
(711416,	222,	702549,	'Броды',	'Brody',	'Brody',	1,	6856,	'2019-03-16 03:59:51',	'Brody',	'Brody',	'Brody'),
(711515,	222,	703446,	'Боярка',	'Boyarka',	'Boyarka',	1,	6252,	'2019-03-16 03:59:51',	'Boyarka',	'Boyarka',	'Boyarka'),
(711635,	222,	703446,	'Бородянка',	'Borodyanka',	'Borodyanka',	1,	5958,	'2019-03-16 03:59:51',	'Borodyanka',	'Borodyanka',	'Borodyanka'),
(711660,	222,	703446,	'Борисполь',	'Boryspil\'',	'Boryspil\'',	1,	5979,	'2019-03-16 03:59:51',	'Boryspil\'',	'Boryspil\'',	'Boryspil\''),
(711669,	222,	702549,	'Борислав',	'Boryslav',	'Boryslav',	1,	5978,	'2019-03-16 03:59:51',	'Boryslav',	'Boryslav',	'Boryslav'),
(711841,	222,	698738,	'Болград',	'Bolhrad',	'Bolhrad',	1,	5701,	'2019-03-16 03:59:51',	'Bolhrad',	'Bolhrad',	'Bolhrad'),
(711867,	222,	703446,	'Богуслав',	'Bohuslav',	'Bohuslav',	1,	5620,	'2019-03-16 03:59:51',	'Bohuslav',	'Bohuslav',	'Bohuslav'),
(711894,	222,	706482,	'Богодухов',	'Bohodukhiv',	'Bohodukhiv',	1,	5618,	'2019-03-16 03:59:51',	'Bohodukhiv',	'Bohodukhiv',	'Bohodukhiv'),
(712041,	222,	706482,	'Blyznyuky',	'Blyznyuky',	'Blyznyuky',	1,	5517,	'2019-03-16 03:59:51',	'Blyznyuky',	'Blyznyuky',	'Blyznyuky'),
(712160,	222,	698738,	'Белгород-Днестровский',	'Bilhorod-Dnistrovs\'kyy',	'Bilhorod-Dnistrovs\'kyy',	1,	5007,	'2019-03-16 03:59:51',	'Bilhorod-Dnistrovs\'kyy',	'Bilhorod-Dnistrovs\'kyy',	'Bilhorod-Dnistrovs\'kyy'),
(712165,	222,	703446,	'Белая Церковь',	'Bila Tserkva',	'Bila Tserkva',	1,	5001,	'2019-03-16 03:59:51',	'Bila Tserkva',	'Bila Tserkva',	'Bila Tserkva'),
(712374,	222,	691649,	'Бережаны',	'Berezhani',	'Berezhani',	1,	4487,	'2019-03-16 03:59:51',	'Berezhani',	'Berezhani',	'Berezhani'),
(712423,	222,	687869,	'Берегово',	'Berehove',	'Berehove',	1,	4482,	'2019-03-16 03:59:51',	'Berehove',	'Berehove',	'Berehove'),
(712441,	222,	686966,	'Бердичев',	'Berdychiv',	'Berdychiv',	1,	4479,	'2019-03-16 03:59:51',	'Berdychiv',	'Berdychiv',	'Berdychiv'),
(712451,	222,	687699,	'Бердянск',	'Berdyans\'k',	'Berdyans\'k',	1,	4478,	'2019-03-16 03:59:51',	'Berdyans\'k',	'Berdyans\'k',	'Berdyans\'k'),
(712488,	222,	698738,	'Беляевка',	'Bilyayivka',	'Bilyayivka',	1,	5041,	'2019-03-16 03:59:51',	'Bilyayivka',	'Bilyayivka',	'Bilyayivka'),
(712569,	222,	702657,	'Белокуракино',	'Bilokurakyne',	'Bilokurakyne',	1,	5036,	'2019-03-16 03:59:51',	'Bilokurakyne',	'Bilokurakyne',	'Bilokurakyne'),
(712587,	222,	703883,	'Белогорск',	'Bilohirs\'k',	'Bilohirs\'k',	1,	5035,	'2019-03-16 03:59:51',	'Bilohirs\'k',	'Bilohirs\'k',	'Bilohirs\'k'),
(712775,	222,	700567,	'Баштанка',	'Bashtanka',	'Bashtanka',	1,	3588,	'2019-03-16 03:59:51',	'Bashtanka',	'Bashtanka',	'Bashtanka'),
(712787,	222,	703446,	'Барышевка',	'Baryshevka',	'Baryshevka',	1,	3569,	'2019-03-16 03:59:51',	'Baryshevka',	'Baryshevka',	'Baryshevka'),
(712926,	222,	706482,	'Балаклея',	'Balakliya',	'Balakliya',	1,	3161,	'2019-03-16 03:59:51',	'Balakliya',	'Balakliya',	'Balakliya'),
(712969,	222,	703883,	'Бахчисарай',	'Bakhchysaray',	'Bakhchysaray',	1,	3152,	'2019-03-16 03:59:51',	'Bakhchysaray',	'Bakhchysaray',	'Bakhchysaray'),
(713122,	222,	709716,	'Авдеевка',	'Avdeyevka',	'Avdeyevka',	1,	2685,	'2019-03-16 03:59:51',	'Avdeyevka',	'Avdeyevka',	'Avdeyevka'),
(713174,	222,	709716,	'Артёмовск',	'Artemivs\'k',	'Artemivs\'k',	1,	2058,	'2019-03-16 03:59:51',	'Artemivs\'k',	'Artemivs\'k',	'Artemivs\'k'),
(713203,	222,	703883,	'Армянск',	'Armyans\'k',	'Armyans\'k',	1,	1957,	'2019-03-16 03:59:51',	'Armyans\'k',	'Armyans\'k',	'Armyans\'k'),
(713259,	222,	702657,	'Антрацит',	'Antratsit',	'Antratsit',	1,	1601,	'2019-03-16 03:59:51',	'Antratsit',	'Antratsit',	'Antratsit'),
(713504,	222,	709716,	'Амвросиевка',	'Amvrosiyivka',	'Amvrosiyivka',	1,	1321,	'2019-03-16 03:59:51',	'Amvrosiyivka',	'Amvrosiyivka',	'Amvrosiyivka'),
(713513,	222,	703883,	'Алушта',	'Alushta',	'Alushta',	1,	1142,	'2019-03-16 03:59:51',	'Alushta',	'Alushta',	'Alushta'),
(713514,	222,	703883,	'Алупка',	'Alupka',	'Alupka',	1,	1141,	'2019-03-16 03:59:51',	'Alupka',	'Alupka',	'Alupka'),
(713610,	222,	703446,	'Александровка',	'Aleksandrovka',	'Aleksandrovka',	1,	690,	'2019-03-16 03:59:51',	'Aleksandrovka',	'Aleksandrovka',	'Aleksandrovka'),
(713716,	222,	702657,	'Алчевск',	'Alchevs\'k',	'Alchevs\'k',	1,	641,	'2019-03-16 03:59:51',	'Alchevs\'k',	'Alchevs\'k',	'Alchevs\'k'),
(713749,	222,	692196,	'Ахтырка',	'Okhtyrka',	'Okhtyrka',	1,	35731,	'2019-03-16 03:59:51',	'Okhtyrka',	'Okhtyrka',	'Okhtyrka'),
(737022,	217,	737021,	'Зонгулдак',	'Zonguldak',	'Zonguldak',	1,	55209,	'2019-03-16 03:59:51',	'Zonguldak',	'Zonguldak',	'Zonguldak'),
(737054,	217,	738742,	'Зил',	'Zile',	'Zile',	1,	55170,	'2019-03-16 03:59:51',	'Zile',	'Zile',	'Zile'),
(737071,	217,	745042,	'Zeytinburnu',	'Zeytinburnu',	'Zeytinburnu',	1,	55129,	'2019-03-16 03:59:51',	'Zeytinburnu',	'Zeytinburnu',	'Zeytinburnu'),
(737500,	217,	750268,	'Yildirim',	'Yildirim',	'Yildirim',	1,	54936,	'2019-03-16 03:59:51',	'Yildirim',	'Yildirim',	'Yildirim'),
(737757,	217,	745042,	'Yenibosna',	'Yenibosna',	'Yenibosna',	1,	54921,	'2019-03-16 03:59:51',	'Yenibosna',	'Yenibosna',	'Yenibosna'),
(737961,	217,	742865,	'Korfez',	'Korfez',	'Korfez',	1,	24804,	'2019-03-16 03:59:51',	'Korfez',	'Korfez',	'Korfez'),
(738014,	217,	750268,	'Yaman',	'Yaman',	'Yaman',	1,	54869,	'2019-03-16 03:59:51',	'Yaman',	'Yaman',	'Yaman'),
(738025,	217,	862469,	'Ялова',	'Yalova',	'Yalova',	1,	54867,	'2019-03-16 03:59:51',	'Yalova',	'Yalova',	'Yalova'),
(738154,	217,	743165,	'Vize',	'Vize',	'Vize',	1,	52204,	'2019-03-16 03:59:51',	'Vize',	'Vize',	'Vize'),
(738251,	217,	747711,	'Узункепрю',	'Uzun Keupru',	'Uzun Keupru',	1,	50613,	'2019-03-16 03:59:51',	'Uzun Keupru',	'Uzun Keupru',	'Uzun Keupru'),
(738329,	217,	745042,	'Ускюдар',	'UEskuedar',	'UEskuedar',	1,	50269,	'2019-03-16 03:59:51',	'UEskuedar',	'UEskuedar',	'UEskuedar'),
(738349,	217,	741098,	'Унье',	'Unieh',	'Unieh',	1,	50353,	'2019-03-16 03:59:51',	'Unieh',	'Unieh',	'Unieh'),
(738377,	217,	745042,	'Umraniye',	'Umraniye',	'Umraniye',	1,	50333,	'2019-03-16 03:59:51',	'Umraniye',	'Umraniye',	'Umraniye'),
(738549,	217,	745042,	'Tuzla',	'Tuzla',	'Tuzla',	1,	50179,	'2019-03-16 03:59:51',	'Tuzla',	'Tuzla',	'Tuzla'),
(738648,	217,	738647,	'Трабзон',	'Trabzon',	'Trabzon',	1,	49686,	'2019-03-16 03:59:51',	'Trabzon',	'Trabzon',	'Trabzon'),
(738743,	217,	738742,	'ТОКАТ',	'Tokat',	'Tokat',	1,	49344,	'2019-03-16 03:59:51',	'Tokat',	'Tokat',	'Tokat'),
(738753,	217,	746878,	'ТИРЕБОЛУ',	'Tirebolu',	'Tirebolu',	1,	49276,	'2019-03-16 03:59:51',	'Tirebolu',	'Tirebolu',	'Tirebolu'),
(738927,	217,	738926,	'Текирдаг',	'Tekirdag',	'Tekirdag',	1,	48729,	'2019-03-16 03:59:51',	'Tekirdag',	'Tekirdag',	'Tekirdag'),
(739251,	217,	752014,	'Suluova',	'Suluova',	'Suluova',	1,	48085,	'2019-03-16 03:59:51',	'Suluova',	'Suluova',	'Suluova'),
(739549,	217,	745042,	'Sisli',	'Sisli',	'Sisli',	1,	46433,	'2019-03-16 03:59:51',	'Sisli',	'Sisli',	'Sisli'),
(739600,	217,	739598,	'Синоп',	'Sinop',	'Sinop',	1,	46406,	'2019-03-16 03:59:51',	'Sinop',	'Sinop',	'Sinop'),
(739634,	217,	745042,	'Silivri',	'Silivri',	'Silivri',	1,	46299,	'2019-03-16 03:59:51',	'Silivri',	'Silivri',	'Silivri'),
(739788,	217,	740352,	'Serdivan',	'Serdivan',	'Serdivan',	1,	45745,	'2019-03-16 03:59:51',	'Serdivan',	'Serdivan',	'Serdivan'),
(740088,	217,	743942,	'САРЫКАМЫШ',	'Sarikamis',	'Sarikamis',	1,	44698,	'2019-03-16 03:59:51',	'Sarikamis',	'Sarikamis',	'Sarikamis'),
(740264,	217,	740263,	'Самсун',	'Samsun',	'Samsun',	1,	43935,	'2019-03-16 03:59:51',	'Samsun',	'Samsun',	'Samsun'),
(740483,	217,	740481,	'РИЗЕ',	'Rize',	'Rize',	1,	41083,	'2019-03-16 03:59:51',	'Rize',	'Rize',	'Rize'),
(740555,	217,	743881,	'Piri',	'Piri',	'Piri',	1,	38054,	'2019-03-16 03:59:51',	'Piri',	'Piri',	'Piri'),
(740616,	217,	745042,	'Pendik',	'Pendik',	'Pendik',	1,	37317,	'2019-03-16 03:59:51',	'Pendik',	'Pendik',	'Pendik'),
(740729,	217,	740352,	'Pamukova',	'Pamukova',	'Pamukova',	1,	36801,	'2019-03-16 03:59:51',	'Pamukova',	'Pamukova',	'Pamukova'),
(741100,	217,	741098,	'ОРДУ',	'Ordu',	'Ordu',	1,	36058,	'2019-03-16 03:59:51',	'Ordu',	'Ordu',	'Ordu'),
(741609,	217,	752014,	'Мерзифон',	'Merzifon',	'Merzifon',	1,	31012,	'2019-03-16 03:59:51',	'Merzifon',	'Merzifon',	'Merzifon'),
(741628,	217,	747711,	'Meric',	'Meric',	'Meric',	1,	30915,	'2019-03-16 03:59:51',	'Meric',	'Meric',	'Meric'),
(741662,	217,	738647,	'Meliksah',	'Meliksah',	'Meliksah',	1,	30721,	'2019-03-16 03:59:51',	'Meliksah',	'Meliksah',	'Meliksah'),
(741712,	217,	745042,	'Maslak',	'Maslak',	'Maslak',	1,	30179,	'2019-03-16 03:59:51',	'Maslak',	'Maslak',	'Maslak'),
(741763,	217,	745042,	'Maltepe',	'Maltepe',	'Maltepe',	1,	29372,	'2019-03-16 03:59:51',	'Maltepe',	'Maltepe',	'Maltepe'),
(741771,	217,	738926,	'Малкара',	'Malkara',	'Malkara',	1,	29339,	'2019-03-16 03:59:51',	'Malkara',	'Malkara',	'Malkara'),
(741855,	217,	743165,	'Luleburgaz',	'Luleburgaz',	'Luleburgaz',	1,	28794,	'2019-03-16 03:59:51',	'Luleburgaz',	'Luleburgaz',	'Luleburgaz'),
(742394,	217,	745042,	'Kucukcekmece',	'Kucukcekmece',	'Kucukcekmece',	1,	24982,	'2019-03-16 03:59:51',	'Kucukcekmece',	'Kucukcekmece',	'Kucukcekmece'),
(742822,	217,	740481,	'Kocatepe',	'Kocatepe',	'Kocatepe',	1,	24703,	'2019-03-16 03:59:51',	'Kocatepe',	'Kocatepe',	'Kocatepe'),
(742849,	217,	862467,	'Kocakoy',	'Kocakoy',	'Kocakoy',	1,	24702,	'2019-03-16 03:59:51',	'Kocakoy',	'Kocakoy',	'Kocakoy'),
(743166,	217,	743165,	'Кыркларели',	'Kirklareli',	'Kirklareli',	1,	24514,	'2019-03-16 03:59:51',	'Kirklareli',	'Kirklareli',	'Kirklareli'),
(743522,	217,	747711,	'Kemal',	'Kemal',	'Kemal',	1,	24047,	'2019-03-16 03:59:51',	'Kemal',	'Kemal',	'Kemal'),
(743882,	217,	743881,	'Кастамону',	'Kastamonu',	'Kastamonu',	1,	23936,	'2019-03-16 03:59:51',	'Kastamonu',	'Kastamonu',	'Kastamonu'),
(743932,	217,	745042,	'Kartal',	'Kartal',	'Kartal',	1,	23914,	'2019-03-16 03:59:51',	'Kartal',	'Kartal',	'Kartal'),
(743952,	217,	743942,	'Карс',	'Kars',	'Kars',	1,	23909,	'2019-03-16 03:59:51',	'Kars',	'Kars',	'Kars'),
(744073,	217,	749747,	'Karatekin',	'Karatekin',	'Karatekin',	1,	23880,	'2019-03-16 03:59:51',	'Karatekin',	'Karatekin',	'Karatekin'),
(744168,	217,	742865,	'Karamursel',	'Karamursel',	'Karamursel',	1,	23877,	'2019-03-16 03:59:51',	'Karamursel',	'Karamursel',	'Karamursel'),
(744537,	217,	750268,	'Караджабей',	'Karacabey',	'Karacabey',	1,	23868,	'2019-03-16 03:59:51',	'Karacabey',	'Karacabey',	'Karacabey'),
(744562,	217,	862468,	'Karabuk',	'Karabuk',	'Karabuk',	1,	23867,	'2019-03-16 03:59:51',	'Karabuk',	'Karabuk',	'Karabuk'),
(744876,	217,	745042,	'Kagithane',	'Kagithane',	'Kagithane',	1,	23733,	'2019-03-16 03:59:51',	'Kagithane',	'Kagithane',	'Kagithane'),
(744918,	217,	745042,	'Kadikoey',	'Kadikoey',	'Kadikoey',	1,	23726,	'2019-03-16 03:59:51',	'Kadikoey',	'Kadikoey',	'Kadikoey'),
(744926,	217,	862469,	'Kadikoy',	'Kadikoy',	'Kadikoy',	1,	23727,	'2019-03-16 03:59:51',	'Kadikoy',	'Kadikoy',	'Kadikoy'),
(745003,	217,	740481,	'Esentepe',	'Esentepe',	'Esentepe',	1,	15684,	'2019-03-16 03:59:51',	'Esentepe',	'Esentepe',	'Esentepe'),
(745028,	217,	742865,	'Измит',	'Izmit',	'Izmit',	1,	23224,	'2019-03-16 03:59:51',	'Izmit',	'Izmit',	'Izmit'),
(745044,	217,	745042,	'Стамбул',	'Istanbul',	'Istanbul',	1,	23155,	'2019-03-16 03:59:51',	'Istanbul',	'Istanbul',	'Istanbul'),
(745116,	217,	746423,	'Баяна',	'Bayana',	'Bayana',	1,	3737,	'2019-03-16 03:59:51',	'Bayana',	'Bayana',	'Bayana'),
(745169,	217,	750268,	'Inegol',	'Inegol',	'Inegol',	1,	22888,	'2019-03-16 03:59:51',	'Inegol',	'Inegol',	'Inegol'),
(745454,	217,	743942,	'Ибиш Ке',	'Ibiskoy',	'Ibiskoy',	1,	22697,	'2019-03-16 03:59:51',	'Ibiskoy',	'Ibiskoy',	'Ibiskoy'),
(745856,	217,	745042,	'Harbiye',	'Harbiye',	'Harbiye',	1,	20642,	'2019-03-16 03:59:51',	'Harbiye',	'Harbiye',	'Harbiye'),
(745999,	217,	738926,	'Halic',	'Halic',	'Halic',	1,	20413,	'2019-03-16 03:59:51',	'Halic',	'Halic',	'Halic'),
(746232,	217,	750268,	'Gursu',	'Gursu',	'Gursu',	1,	20220,	'2019-03-16 03:59:51',	'Gursu',	'Gursu',	'Gursu'),
(746425,	217,	746423,	'ГЮМЮШАНЕ',	'Gumushkhane',	'Gumushkhane',	1,	20181,	'2019-03-16 03:59:51',	'Gumushkhane',	'Gumushkhane',	'Gumushkhane'),
(746574,	217,	322164,	'Гонен',	'Gonen',	'Gonen',	1,	19050,	'2019-03-16 03:59:51',	'Gonen',	'Gonen',	'Gonen'),
(746666,	217,	742865,	'Geulzuk',	'Geulzuk',	'Geulzuk',	1,	18536,	'2019-03-16 03:59:51',	'Geulzuk',	'Geulzuk',	'Geulzuk'),
(746877,	217,	740263,	'Girne',	'Girne',	'Girne',	1,	18718,	'2019-03-16 03:59:51',	'Girne',	'Girne',	'Girne'),
(746881,	217,	746878,	'ГИРЕСУН',	'Giresun',	'Giresun',	1,	18715,	'2019-03-16 03:59:51',	'Giresun',	'Giresun',	'Giresun'),
(746958,	217,	750268,	'Гемлик',	'Gemlik',	'Gemlik',	1,	18326,	'2019-03-16 03:59:51',	'Gemlik',	'Gemlik',	'Gemlik'),
(746983,	217,	749778,	'Гелиболу',	'Gelibolu',	'Gelibolu',	1,	18311,	'2019-03-16 03:59:51',	'Gelibolu',	'Gelibolu',	'Gelibolu'),
(747014,	217,	742865,	'Гебзе',	'Gebze',	'Gebze',	1,	18256,	'2019-03-16 03:59:51',	'Gebze',	'Gebze',	'Gebze'),
(747092,	217,	738647,	'Findikli',	'Findikli',	'Findikli',	1,	16634,	'2019-03-16 03:59:51',	'Findikli',	'Findikli',	'Findikli'),
(747323,	217,	745042,	'Esenyurt',	'Esenyurt',	'Esenyurt',	1,	15685,	'2019-03-16 03:59:51',	'Esenyurt',	'Esenyurt',	'Esenyurt'),
(747462,	217,	745042,	'Erenkoy',	'Erenkoy',	'Erenkoy',	1,	15541,	'2019-03-16 03:59:51',	'Erenkoy',	'Erenkoy',	'Erenkoy'),
(747464,	217,	743942,	'Erenkoy',	'Erenkoy',	'Erenkoy',	1,	15540,	'2019-03-16 03:59:51',	'Erenkoy',	'Erenkoy',	'Erenkoy'),
(747712,	217,	747711,	'Эдирне',	'Edirne',	'Edirne',	1,	14722,	'2019-03-16 03:59:51',	'Edirne',	'Edirne',	'Edirne'),
(747764,	217,	865521,	'Duzce',	'Duzce',	'Duzce',	1,	14270,	'2019-03-16 03:59:51',	'Duzce',	'Duzce',	'Duzce'),
(747839,	217,	323784,	'Dumlupinar',	'Dumlupinar',	'Dumlupinar',	1,	14135,	'2019-03-16 03:59:51',	'Dumlupinar',	'Dumlupinar',	'Dumlupinar'),
(748636,	217,	742865,	'Darica',	'Darica',	'Darica',	1,	12852,	'2019-03-16 03:59:51',	'Darica',	'Darica',	'Darica'),
(748879,	217,	748877,	'Чорум',	'Corum',	'Corum',	1,	11807,	'2019-03-16 03:59:51',	'Corum',	'Corum',	'Corum'),
(748893,	217,	738926,	'Corlu',	'Corlu',	'Corlu',	1,	11690,	'2019-03-16 03:59:51',	'Corlu',	'Corlu',	'Corlu'),
(749274,	217,	738926,	'Cerkezkoey',	'Cerkezkoey',	'Cerkezkoey',	1,	9420,	'2019-03-16 03:59:51',	'Cerkezkoey',	'Cerkezkoey',	'Cerkezkoey'),
(749386,	217,	743942,	'Celal',	'Celal',	'Celal',	1,	9255,	'2019-03-16 03:59:51',	'Celal',	'Celal',	'Celal'),
(749387,	217,	745042,	'Cekme',	'Cekme',	'Cekme',	1,	9254,	'2019-03-16 03:59:51',	'Cekme',	'Cekme',	'Cekme'),
(749644,	217,	745042,	'Catalca',	'Catalca',	'Catalca',	1,	9056,	'2019-03-16 03:59:51',	'Catalca',	'Catalca',	'Catalca'),
(749748,	217,	749747,	'Чанкыры',	'Khanjarah',	'Khanjarah',	1,	24228,	'2019-03-16 03:59:51',	'Khanjarah',	'Khanjarah',	'Khanjarah'),
(749780,	217,	749778,	'Чанаккале',	'Canakkale',	'Canakkale',	1,	8152,	'2019-03-16 03:59:51',	'Canakkale',	'Canakkale',	'Canakkale'),
(750269,	217,	750268,	'Бурса',	'Bursa',	'Bursa',	1,	7498,	'2019-03-16 03:59:51',	'Bursa',	'Bursa',	'Bursa'),
(750516,	217,	750510,	'Болу',	'Bolu',	'Bolu',	1,	5740,	'2019-03-16 03:59:51',	'Bolu',	'Bolu',	'Bolu'),
(750598,	217,	321122,	'Биледжик',	'Bilecik',	'Bilecik',	1,	5005,	'2019-03-16 03:59:51',	'Bilecik',	'Bilecik',	'Bilecik'),
(750605,	217,	749778,	'Биг',	'Biga',	'Biga',	1,	4978,	'2019-03-16 03:59:51',	'Biga',	'Biga',	'Biga'),
(750640,	217,	745042,	'Бейоглу',	'Beyoglu',	'Beyoglu',	1,	4838,	'2019-03-16 03:59:51',	'Beyoglu',	'Beyoglu',	'Beyoglu'),
(750662,	217,	745042,	'Beykoz',	'Beykoz',	'Beykoz',	1,	4835,	'2019-03-16 03:59:51',	'Beykoz',	'Beykoz',	'Beykoz'),
(750733,	217,	745042,	'Ардаган',	'Besiktas',	'Besiktas',	1,	4687,	'2019-03-16 03:59:51',	'Besiktas',	'Besiktas',	'Besiktas'),
(750938,	217,	862471,	'БАЙБУРТ',	'Bayburt',	'Bayburt',	1,	3744,	'2019-03-16 03:59:51',	'Bayburt',	'Bayburt',	'Bayburt'),
(751057,	217,	862467,	'Бартин',	'Bartin',	'Bartin',	1,	3545,	'2019-03-16 03:59:51',	'Bartin',	'Bartin',	'Bartin'),
(751077,	217,	322164,	'Бандырма',	'Bandirma',	'Bandirma',	1,	3283,	'2019-03-16 03:59:51',	'Bandirma',	'Bandirma',	'Bandirma'),
(751371,	217,	743165,	'Babaeski',	'Babaeski',	'Babaeski',	1,	2845,	'2019-03-16 03:59:51',	'Babaeski',	'Babaeski',	'Babaeski'),
(751817,	217,	751816,	'АРТВИН',	'Artvin',	'Artvin',	1,	2088,	'2019-03-16 03:59:51',	'Artvin',	'Artvin',	'Artvin'),
(751949,	217,	740481,	'АРДЕШЕН',	'Ardesen',	'Ardesen',	1,	1807,	'2019-03-16 03:59:51',	'Ardesen',	'Ardesen',	'Ardesen'),
(751952,	217,	862470,	'АРДАГАН',	'Ardahan',	'Ardahan',	1,	1799,	'2019-03-16 03:59:51',	'Ardahan',	'Ardahan',	'Ardahan'),
(752015,	217,	752014,	'Амасья',	'Amasya',	'Amasya',	1,	1190,	'2019-03-16 03:59:51',	'Amasya',	'Amasya',	'Amasya'),
(752016,	217,	862467,	'Amasra',	'Amasra',	'Amasra',	1,	1189,	'2019-03-16 03:59:51',	'Amasra',	'Amasra',	'Amasra'),
(752850,	217,	740352,	'Сакарья',	'Adapazari',	'Adapazari',	1,	204,	'2019-03-16 03:59:51',	'Adapazari',	'Adapazari',	'Adapazari'),
(752904,	217,	748877,	'Abdullah',	'Abdullah',	'Abdullah',	1,	43,	'2019-03-16 03:59:51',	'Abdullah',	'Abdullah',	'Abdullah'),
(815272,	185,	491684,	'Рай',	'Ray',	'Ray',	1,	40134,	'2019-03-16 03:59:51',	'Ray',	'Ray',	'Ray'),
(825364,	185,	554230,	'Менделеево',	'Mendeleyevo',	'Mendeleyevo',	1,	30791,	'2019-03-16 03:59:51',	'Mendeleyevo',	'Mendeleyevo',	'Mendeleyevo'),
(827329,	185,	559838,	'Павлово',	'Pavlovo',	'Pavlovo',	1,	37122,	'2019-03-16 03:59:51',	'Pavlovo',	'Pavlovo',	'Pavlovo'),
(829005,	185,	1490542,	'Лесной',	'Lesnoy',	'Lesnoy',	1,	27458,	'2019-03-16 03:59:51',	'Lesnoy',	'Lesnoy',	'Lesnoy'),
(829056,	185,	545854,	'Казлук',	'Kazluk',	'Kazluk',	1,	23974,	'2019-03-16 03:59:51',	'Kazluk',	'Kazluk',	'Kazluk'),
(829684,	185,	472755,	'Качалино',	'Kachalino',	'Kachalino',	1,	23719,	'2019-03-16 03:59:51',	'Kachalino',	'Kachalino',	'Kachalino'),
(830844,	185,	1508290,	'Трехгорный',	'Trekhgornyy',	'Trekhgornyy',	1,	49796,	'2019-03-16 03:59:51',	'Trekhgornyy',	'Trekhgornyy',	'Trekhgornyy'),
(831129,	185,	581043,	'Мирный',	'Mirnyy',	'Mirnyy',	1,	31664,	'2019-03-16 03:59:51',	'Mirnyy',	'Mirnyy',	'Mirnyy'),
(857689,	185,	524925,	'Внуково',	'Vnukovo',	'Vnukovo',	1,	52214,	'2019-03-16 03:59:51',	'Vnukovo',	'Vnukovo',	'Vnukovo'),
(863061,	185,	545854,	'Усинск',	'Usinsk',	'Usinsk',	1,	50557,	'2019-03-16 03:59:51',	'Usinsk',	'Usinsk',	'Usinsk'),
(865087,	222,	698738,	'Теплодар',	'Teplodar',	'Teplodar',	1,	48801,	'2019-03-16 03:59:51',	'Teplodar',	'Teplodar',	'Teplodar'),
(866062,	185,	522652,	'Искателей',	'Iskateley',	'Iskateley',	1,	23081,	'2019-03-16 03:59:51',	'Iskateley',	'Iskateley',	'Iskateley'),
(875160,	185,	511180,	'Песьянка',	'Pes\'yanka',	'Pes\'yanka',	1,	37535,	'2019-03-16 03:59:51',	'Pes\'yanka',	'Pes\'yanka',	'Pes\'yanka'),
(1252758,	103,	1267701,	'Yelahanka',	'Yelahanka',	'Yelahanka',	1,	54909,	'2019-03-16 03:59:51',	'Yelahanka',	'Yelahanka',	'Yelahanka'),
(1252770,	103,	1264418,	'Yavatmal',	'Yavatmal',	'Yavatmal',	1,	54892,	'2019-03-16 03:59:51',	'Yavatmal',	'Yavatmal',	'Yavatmal'),
(1252795,	103,	1278629,	'Янам',	'Yanam',	'Yanam',	1,	54873,	'2019-03-16 03:59:51',	'Yanam',	'Yanam',	'Yanam'),
(1252797,	103,	1270260,	'Yamunanagar',	'Yamunanagar',	'Yamunanagar',	1,	54872,	'2019-03-16 03:59:51',	'Yamunanagar',	'Yamunanagar',	'Yamunanagar'),
(1252942,	103,	1264418,	'Вардха',	'Wardha',	'Wardha',	1,	52757,	'2019-03-16 03:59:51',	'Wardha',	'Wardha',	'Wardha'),
(1252948,	103,	1278629,	'Варангал',	'Warangal',	'Warangal',	1,	52747,	'2019-03-16 03:59:51',	'Warangal',	'Warangal',	'Warangal'),
(1252968,	103,	1267254,	'Wandur',	'Wandur',	'Wandur',	1,	52718,	'2019-03-16 03:59:51',	'Wandur',	'Wandur',	'Wandur'),
(1252997,	103,	1255053,	'Walajapet',	'Walajapet',	'Walajapet',	1,	52482,	'2019-03-16 03:59:51',	'Walajapet',	'Walajapet',	'Walajapet'),
(1253041,	103,	1267701,	'Вади',	'Wadi',	'Wadi',	1,	52417,	'2019-03-16 03:59:51',	'Wadi',	'Wadi',	'Wadi'),
(1253074,	103,	1270770,	'Vyara',	'Vyara',	'Vyara',	1,	52365,	'2019-03-16 03:59:51',	'Vyara',	'Vyara',	'Vyara'),
(1253084,	103,	1278629,	'Визианагарам',	'Vizianagaram',	'Vizianagaram',	1,	52205,	'2019-03-16 03:59:51',	'Vizianagaram',	'Vizianagaram',	'Vizianagaram'),
(1253091,	103,	1264418,	'Вита',	'Vite',	'Vite',	1,	52157,	'2019-03-16 03:59:51',	'Vite',	'Vite',	'Vite'),
(1253095,	103,	1270770,	'Visnagar',	'Visnagar',	'Visnagar',	1,	52152,	'2019-03-16 03:59:51',	'Visnagar',	'Visnagar',	'Visnagar'),
(1253102,	103,	1278629,	'Вишакхапатнам',	'Visakhapatnam',	'Visakhapatnam',	1,	52143,	'2019-03-16 03:59:51',	'Visakhapatnam',	'Visakhapatnam',	'Visakhapatnam'),
(1253133,	103,	1264418,	'Virar',	'Virar',	'Virar',	1,	52112,	'2019-03-16 03:59:51',	'Virar',	'Virar',	'Virar'),
(1253150,	103,	1278629,	'Vinukonda',	'Vinukonda',	'Vinukonda',	1,	52092,	'2019-03-16 03:59:51',	'Vinukonda',	'Vinukonda',	'Vinukonda'),
(1253166,	103,	1255053,	'Villupuram',	'Villupuram',	'Villupuram',	1,	52041,	'2019-03-16 03:59:51',	'Villupuram',	'Villupuram',	'Villupuram'),
(1253173,	103,	1264418,	'Vile Parle',	'Vile Parle',	'Vile Parle',	1,	51635,	'2019-03-16 03:59:51',	'Vile Parle',	'Vile Parle',	'Vile Parle'),
(1253181,	103,	1264418,	'Vikhroli',	'Vikhroli',	'Vikhroli',	1,	51602,	'2019-03-16 03:59:51',	'Vikhroli',	'Vikhroli',	'Vikhroli'),
(1253182,	103,	1278629,	'Vikarabad',	'Vikarabad',	'Vikarabad',	1,	51600,	'2019-03-16 03:59:51',	'Vikarabad',	'Vikarabad',	'Vikarabad'),
(1253184,	103,	1278629,	'Виджаявада',	'Vijayawada',	'Vijayawada',	1,	51599,	'2019-03-16 03:59:51',	'Vijayawada',	'Vijayawada',	'Vijayawada'),
(1253237,	103,	1270770,	'Veraval',	'Veraval',	'Veraval',	1,	51204,	'2019-03-16 03:59:51',	'Veraval',	'Veraval',	'Veraval'),
(1253286,	103,	1255053,	'Веллор',	'Vellore',	'Vellore',	1,	51112,	'2019-03-16 03:59:51',	'Vellore',	'Vellore',	'Vellore'),
(1253335,	103,	1267254,	'Vazhakulam',	'Vazhakulam',	'Vazhakulam',	1,	51042,	'2019-03-16 03:59:51',	'Vazhakulam',	'Vazhakulam',	'Vazhakulam'),
(1253366,	103,	1264418,	'Vashi',	'Vashi',	'Vashi',	1,	50961,	'2019-03-16 03:59:51',	'Vashi',	'Vashi',	'Vashi'),
(1253367,	103,	1271157,	'Васко-да-Гама',	'Vasco Da Gama',	'Vasco Da Gama',	1,	50959,	'2019-03-16 03:59:51',	'Vasco Da Gama',	'Vasco Da Gama',	'Vasco Da Gama'),
(1253372,	103,	1264418,	'Vasai',	'Vasai',	'Vasai',	1,	50957,	'2019-03-16 03:59:51',	'Vasai',	'Vasai',	'Vasai'),
(1253405,	103,	1253626,	'Варанаси',	'Varanasi',	'Varanasi',	1,	50915,	'2019-03-16 03:59:51',	'Varanasi',	'Varanasi',	'Varanasi'),
(1253437,	103,	1255053,	'Vaniyambadi',	'Vaniyambadi',	'Vaniyambadi',	1,	50891,	'2019-03-16 03:59:51',	'Vaniyambadi',	'Vaniyambadi',	'Vaniyambadi'),
(1253468,	103,	1270770,	'Valsad',	'Valsad',	'Valsad',	1,	50850,	'2019-03-16 03:59:51',	'Valsad',	'Valsad',	'Valsad'),
(1253482,	103,	1270770,	'Vallabh Vidyanagar',	'Vallabh Vidyanagar',	'Vallabh Vidyanagar',	1,	50748,	'2019-03-16 03:59:51',	'Vallabh Vidyanagar',	'Vallabh Vidyanagar',	'Vallabh Vidyanagar'),
(1253506,	103,	1267254,	'Valancheri',	'Valancheri',	'Valancheri',	1,	50669,	'2019-03-16 03:59:51',	'Valancheri',	'Valancheri',	'Valancheri'),
(1253573,	103,	1270770,	'Вадодара',	'Vadodara',	'Vadodara',	1,	50635,	'2019-03-16 03:59:51',	'Vadodara',	'Vadodara',	'Vadodara'),
(1253627,	103,	1252881,	'Uttarpara',	'Uttarpara',	'Uttarpara',	1,	50590,	'2019-03-16 03:59:51',	'Uttarpara',	'Uttarpara',	'Uttarpara'),
(1253702,	103,	1264418,	'Уран',	'Uran',	'Uran',	1,	50495,	'2019-03-16 03:59:51',	'Uran',	'Uran',	'Uran'),
(1253747,	103,	1253626,	'Unnao',	'Unnao',	'Unnao',	1,	50419,	'2019-03-16 03:59:51',	'Unnao',	'Unnao',	'Unnao'),
(1253880,	103,	1252881,	'Uluberiya',	'Uluberiya',	'Uluberiya',	1,	50318,	'2019-03-16 03:59:51',	'Uluberiya',	'Uluberiya',	'Uluberiya'),
(1253881,	103,	1278253,	'Ulubari',	'Ulubari',	'Ulubari',	1,	50317,	'2019-03-16 03:59:51',	'Ulubari',	'Ulubari',	'Ulubari'),
(1253894,	103,	1264418,	'Ulhasnagar',	'Ulhasnagar',	'Ulhasnagar',	1,	50302,	'2019-03-16 03:59:51',	'Ulhasnagar',	'Ulhasnagar',	'Ulhasnagar'),
(1253914,	103,	1264542,	'Удджайн',	'Ujjain',	'Ujjain',	1,	50293,	'2019-03-16 03:59:51',	'Ujjain',	'Ujjain',	'Ujjain'),
(1253952,	103,	1267701,	'Udipi',	'Udipi',	'Udipi',	1,	50258,	'2019-03-16 03:59:51',	'Udipi',	'Udipi',	'Udipi'),
(1253956,	103,	1269320,	'Udhampur',	'Udhampur',	'Udhampur',	1,	50256,	'2019-03-16 03:59:51',	'Udhampur',	'Udhampur',	'Udhampur'),
(1253958,	103,	1264418,	'Udgir',	'Udgir',	'Udgir',	1,	50255,	'2019-03-16 03:59:51',	'Udgir',	'Udgir',	'Udgir'),
(1253985,	103,	1258899,	'Udaipur',	'Udaipur',	'Udaipur',	1,	50249,	'2019-03-16 03:59:51',	'Udaipur',	'Udaipur',	'Udaipur'),
(1253993,	103,	1255053,	'Ooty',	'Ooty',	'Ooty',	1,	35968,	'2019-03-16 03:59:51',	'Ooty',	'Ooty',	'Ooty'),
(1254089,	103,	1267701,	'Tumkur',	'Tumkur',	'Tumkur',	1,	50105,	'2019-03-16 03:59:51',	'Tumkur',	'Tumkur',	'Tumkur'),
(1254111,	103,	1264418,	'Tuljapur',	'Tuljapur',	'Tuljapur',	1,	50097,	'2019-03-16 03:59:51',	'Tuljapur',	'Tuljapur',	'Tuljapur'),
(1254163,	103,	1267254,	'Тируванантапурам',	'Thiruvananthapuram',	'Thiruvananthapuram',	1,	49021,	'2019-03-16 03:59:51',	'Thiruvananthapuram',	'Thiruvananthapuram',	'Thiruvananthapuram'),
(1254187,	103,	1267254,	'Тричура',	'Trichur',	'Trichur',	1,	49908,	'2019-03-16 03:59:51',	'Trichur',	'Trichur',	'Trichur'),
(1254241,	103,	1258899,	'Tonk',	'Tonk',	'Tonk',	1,	49399,	'2019-03-16 03:59:51',	'Tonk',	'Tonk',	'Tonk'),
(1254327,	103,	1255053,	'Тируваннамалай',	'Tiruvannamalai',	'Tiruvannamalai',	1,	49290,	'2019-03-16 03:59:51',	'Tiruvannamalai',	'Tiruvannamalai',	'Tiruvannamalai'),
(1254331,	103,	1255053,	'Tiruvallur',	'Tiruvallur',	'Tiruvallur',	1,	49289,	'2019-03-16 03:59:51',	'Tiruvallur',	'Tiruvallur',	'Tiruvallur'),
(1254335,	103,	1267254,	'Tiruvalla',	'Tiruvalla',	'Tiruvalla',	1,	49288,	'2019-03-16 03:59:51',	'Tiruvalla',	'Tiruvalla',	'Tiruvalla'),
(1254346,	103,	1267254,	'Tirur',	'Tirur',	'Tirur',	1,	49287,	'2019-03-16 03:59:51',	'Tirur',	'Tirur',	'Tirur'),
(1254348,	103,	1255053,	'Тируппур',	'Tiruppur',	'Tiruppur',	1,	49286,	'2019-03-16 03:59:51',	'Tiruppur',	'Tiruppur',	'Tiruppur'),
(1254360,	103,	1278629,	'Тирупати',	'Tirupati',	'Tirupati',	1,	49285,	'2019-03-16 03:59:51',	'Tirupati',	'Tirupati',	'Tirupati'),
(1254361,	103,	1255053,	'Тирунелвели',	'Tirunelveli',	'Tirunelveli',	1,	49284,	'2019-03-16 03:59:51',	'Tirunelveli',	'Tirunelveli',	'Tirunelveli'),
(1254388,	103,	1255053,	'Тируччираппалли',	'Tiruchirappalli',	'Tiruchirappalli',	1,	49283,	'2019-03-16 03:59:51',	'Tiruchirappalli',	'Tiruchirappalli',	'Tiruchirappalli'),
(1254390,	103,	1255053,	'Tiruchchendur',	'Tiruchchendur',	'Tiruchchendur',	1,	49282,	'2019-03-16 03:59:51',	'Tiruchchendur',	'Tiruchchendur',	'Tiruchchendur'),
(1254432,	103,	1278253,	'Tinsukia',	'Tinsukia',	'Tinsukia',	1,	49254,	'2019-03-16 03:59:51',	'Tinsukia',	'Tinsukia',	'Tinsukia'),
(1254534,	103,	1253626,	'Tikamgarh',	'Tikamgarh',	'Tikamgarh',	1,	49205,	'2019-03-16 03:59:51',	'Tikamgarh',	'Tikamgarh',	'Tikamgarh'),
(1254589,	103,	1255053,	'Thiruvarur',	'Thiruvarur',	'Thiruvarur',	1,	49022,	'2019-03-16 03:59:51',	'Thiruvarur',	'Thiruvarur',	'Thiruvarur'),
(1254649,	103,	1255053,	'Тханджавур',	'Thanjavur',	'Thanjavur',	1,	48916,	'2019-03-16 03:59:51',	'Thanjavur',	'Thanjavur',	'Thanjavur'),
(1254661,	103,	1264418,	'Таня',	'Thane',	'Thane',	1,	48915,	'2019-03-16 03:59:51',	'Thane',	'Thane',	'Thane'),
(1254710,	103,	1278253,	'Tezpur',	'Tezpur',	'Tezpur',	1,	48896,	'2019-03-16 03:59:51',	'Tezpur',	'Tezpur',	'Tezpur'),
(1254745,	103,	1255053,	'Тхени',	'Teni',	'Teni',	1,	48784,	'2019-03-16 03:59:51',	'Teni',	'Teni',	'Teni'),
(1254751,	103,	1264542,	'Tendukheda',	'Tendukheda',	'Tendukheda',	1,	48782,	'2019-03-16 03:59:51',	'Tendukheda',	'Tendukheda',	'Tendukheda'),
(1254757,	103,	1278629,	'Tenali',	'Tenali',	'Tenali',	1,	48774,	'2019-03-16 03:59:51',	'Tenali',	'Tenali',	'Tenali'),
(1254780,	103,	1267254,	'Thalassery',	'Thalassery',	'Thalassery',	1,	48901,	'2019-03-16 03:59:51',	'Thalassery',	'Thalassery',	'Thalassery'),
(1254868,	103,	1259223,	'Tarn Taran',	'Tarn Taran',	'Tarn Taran',	1,	48579,	'2019-03-16 03:59:51',	'Tarn Taran',	'Tarn Taran',	'Tarn Taran'),
(1254912,	103,	1252881,	'Tarakeswar',	'Tarakeswar',	'Tarakeswar',	1,	48551,	'2019-03-16 03:59:51',	'Tarakeswar',	'Tarakeswar',	'Tarakeswar'),
(1254953,	103,	1278629,	'Tanuku',	'Tanuku',	'Tanuku',	1,	48540,	'2019-03-16 03:59:51',	'Tanuku',	'Tanuku',	'Tanuku'),
(1255062,	103,	1255053,	'Tambaram',	'Tambaram',	'Tambaram',	1,	48508,	'2019-03-16 03:59:51',	'Tambaram',	'Tambaram',	'Tambaram'),
(1255076,	103,	1259223,	'Talwara',	'Talwara',	'Talwara',	1,	48500,	'2019-03-16 03:59:51',	'Talwara',	'Talwara',	'Talwara'),
(1255078,	103,	1259223,	'Talwandi Sabo',	'Talwandi Sabo',	'Talwandi Sabo',	1,	48499,	'2019-03-16 03:59:51',	'Talwandi Sabo',	'Talwandi Sabo',	'Talwandi Sabo'),
(1255264,	103,	1278629,	'Tadepallegudem',	'Tadepallegudem',	'Tadepallegudem',	1,	48409,	'2019-03-16 03:59:51',	'Tadepallegudem',	'Tadepallegudem',	'Tadepallegudem'),
(1255283,	103,	1255053,	'Swamimalai',	'Swamimalai',	'Swamimalai',	1,	48303,	'2019-03-16 03:59:51',	'Swamimalai',	'Swamimalai',	'Swamimalai'),
(1255344,	103,	1278629,	'Suriapet',	'Suriapet',	'Suriapet',	1,	48229,	'2019-03-16 03:59:51',	'Suriapet',	'Suriapet',	'Suriapet'),
(1255372,	103,	1255053,	'Surandai',	'Surandai',	'Surandai',	1,	48215,	'2019-03-16 03:59:51',	'Surandai',	'Surandai',	'Surandai'),
(1255437,	103,	1261029,	'Sundargarh',	'Sundargarh',	'Sundargarh',	1,	48174,	'2019-03-16 03:59:51',	'Sundargarh',	'Sundargarh',	'Sundargarh'),
(1255449,	103,	1259223,	'Sunam',	'Sunam',	'Sunam',	1,	48162,	'2019-03-16 03:59:51',	'Sunam',	'Sunam',	'Sunam'),
(1255484,	103,	1255053,	'Sulur',	'Sulur',	'Sulur',	1,	48086,	'2019-03-16 03:59:51',	'Sulur',	'Sulur',	'Sulur'),
(1255486,	103,	1267254,	'Sultans Battery',	'Sultans Battery',	'Sultans Battery',	1,	48083,	'2019-03-16 03:59:51',	'Sultans Battery',	'Sultans Battery',	'Sultans Battery'),
(1255616,	103,	1255053,	'Srivilliputhur',	'Srivilliputhur',	'Srivilliputhur',	1,	47352,	'2019-03-16 03:59:51',	'Srivilliputhur',	'Srivilliputhur',	'Srivilliputhur'),
(1255624,	103,	1255053,	'Srirangam',	'Srirangam',	'Srirangam',	1,	47351,	'2019-03-16 03:59:51',	'Srirangam',	'Srirangam',	'Srirangam'),
(1255634,	103,	1269320,	'Шринагар',	'Srinagar',	'Srinagar',	1,	47350,	'2019-03-16 03:59:51',	'Srinagar',	'Srinagar',	'Srinagar'),
(1255647,	103,	1278629,	'Srikakulam',	'Srikakulam',	'Srikakulam',	1,	47349,	'2019-03-16 03:59:51',	'Srikakulam',	'Srikakulam',	'Srikakulam'),
(1255744,	103,	1270260,	'Sonipat',	'Sonipat',	'Sonipat',	1,	46786,	'2019-03-16 03:59:51',	'Sonipat',	'Sonipat',	'Sonipat'),
(1255844,	103,	1271157,	'Solim',	'Solim',	'Solim',	1,	46683,	'2019-03-16 03:59:51',	'Solim',	'Solim',	'Solim'),
(1255850,	103,	1270101,	'Солана',	'Solan',	'Solan',	1,	46649,	'2019-03-16 03:59:51',	'Solan',	'Solan',	'Solan'),
(1255947,	103,	1255053,	'Sivakasi',	'Sivakasi',	'Sivakasi',	1,	46450,	'2019-03-16 03:59:51',	'Sivakasi',	'Sivakasi',	'Sivakasi'),
(1255953,	103,	1255053,	'Шиваганга',	'Sivaganga',	'Sivaganga',	1,	46449,	'2019-03-16 03:59:51',	'Sivaganga',	'Sivaganga',	'Sivaganga'),
(1255955,	103,	1252881,	'Сери',	'Siuri',	'Siuri',	1,	46448,	'2019-03-16 03:59:51',	'Siuri',	'Siuri',	'Siuri'),
(1256029,	103,	1267701,	'Siruguppa',	'Siruguppa',	'Siruguppa',	1,	46430,	'2019-03-16 03:59:51',	'Siruguppa',	'Siruguppa',	'Siruguppa'),
(1256052,	103,	1270260,	'Sirsa',	'Sirsa',	'Sirsa',	1,	46429,	'2019-03-16 03:59:51',	'Sirsa',	'Sirsa',	'Sirsa'),
(1256087,	103,	1259223,	'Sirhind',	'Sirhind',	'Sirhind',	1,	46423,	'2019-03-16 03:59:51',	'Sirhind',	'Sirhind',	'Sirhind'),
(1256104,	103,	1267701,	'Sira',	'Sira',	'Sira',	1,	46420,	'2019-03-16 03:59:51',	'Sira',	'Sira',	'Sira'),
(1256113,	103,	1264418,	'Sion',	'Sion',	'Sion',	1,	46414,	'2019-03-16 03:59:51',	'Sion',	'Sion',	'Sion'),
(1256237,	103,	1270101,	'Шимла',	'Shimla',	'Shimla',	1,	46124,	'2019-03-16 03:59:51',	'Shimla',	'Shimla',	'Shimla'),
(1256259,	103,	1273726,	'Silvassa',	'Silvassa',	'Silvassa',	1,	46321,	'2019-03-16 03:59:51',	'Silvassa',	'Silvassa',	'Silvassa'),
(1256287,	103,	1278253,	'Силчар',	'Silchar',	'Silchar',	1,	46291,	'2019-03-16 03:59:51',	'Silchar',	'Silchar',	'Silchar'),
(1256320,	103,	1258899,	'Sikar',	'Sikar',	'Sikar',	1,	46284,	'2019-03-16 03:59:51',	'Sikar',	'Sikar',	'Sikar'),
(1256369,	103,	1264542,	'Сидхи',	'Sidhi',	'Sidhi',	1,	46223,	'2019-03-16 03:59:51',	'Sidhi',	'Sidhi',	'Sidhi'),
(1256388,	103,	1278253,	'Сибсагар',	'Sibsagar',	'Sibsagar',	1,	46210,	'2019-03-16 03:59:51',	'Sibsagar',	'Sibsagar',	'Sibsagar'),
(1256409,	103,	1252881,	'Shyamnagar',	'Shyamnagar',	'Shyamnagar',	1,	46198,	'2019-03-16 03:59:51',	'Shyamnagar',	'Shyamnagar',	'Shyamnagar'),
(1256422,	103,	1252881,	'Shrirampur',	'Shrirampur',	'Shrirampur',	1,	46185,	'2019-03-16 03:59:51',	'Shrirampur',	'Shrirampur',	'Shrirampur'),
(1256426,	103,	1264418,	'Shrigonda',	'Shrigonda',	'Shrigonda',	1,	46184,	'2019-03-16 03:59:51',	'Shrigonda',	'Shrigonda',	'Shrigonda'),
(1256432,	103,	1267254,	'Shoranur',	'Shoranur',	'Shoranur',	1,	46162,	'2019-03-16 03:59:51',	'Shoranur',	'Shoranur',	'Shoranur'),
(1256435,	103,	1255053,	'Sholinghur',	'Sholinghur',	'Sholinghur',	1,	46161,	'2019-03-16 03:59:51',	'Sholinghur',	'Sholinghur',	'Sholinghur'),
(1256436,	103,	1264418,	'Солапур',	'Solapur',	'Solapur',	1,	46651,	'2019-03-16 03:59:51',	'Solapur',	'Solapur',	'Solapur'),
(1256475,	103,	1264418,	'Ширпуре',	'Shirpur',	'Shirpur',	1,	46152,	'2019-03-16 03:59:51',	'Shirpur',	'Shirpur',	'Shirpur'),
(1256515,	103,	1267701,	'Shimoga',	'Shimoga',	'Shimoga',	1,	46125,	'2019-03-16 03:59:51',	'Shimoga',	'Shimoga',	'Shimoga'),
(1256523,	103,	1263207,	'Шиллонг',	'Shillong',	'Shillong',	1,	46119,	'2019-03-16 03:59:51',	'Shillong',	'Shillong',	'Shillong'),
(1256525,	103,	1252881,	'Силигури',	'Shiliguri',	'Shiliguri',	1,	46116,	'2019-03-16 03:59:51',	'Shiliguri',	'Shiliguri',	'Shiliguri'),
(1256620,	103,	1264418,	'Shegaon',	'Shegaon',	'Shegaon',	1,	46021,	'2019-03-16 03:59:51',	'Shegaon',	'Shegaon',	'Shegaon'),
(1256725,	103,	1259223,	'Shahkot',	'Shahkot',	'Shahkot',	1,	45941,	'2019-03-16 03:59:51',	'Shahkot',	'Shahkot',	'Shahkot'),
(1256728,	103,	1253626,	'Shahjahanpur',	'Shahjahanpur',	'Shahjahanpur',	1,	45940,	'2019-03-16 03:59:51',	'Shahjahanpur',	'Shahjahanpur',	'Shahjahanpur'),
(1256739,	103,	1264542,	'Shahdol',	'Shahdol',	'Shahdol',	1,	45939,	'2019-03-16 03:59:51',	'Shahdol',	'Shahdol',	'Shahdol'),
(1256748,	103,	1267701,	'Shahapur',	'Shahapur',	'Shahapur',	1,	45938,	'2019-03-16 03:59:51',	'Shahapur',	'Shahapur',	'Shahapur'),
(1256751,	103,	1264418,	'Shahada',	'Shahada',	'Shahada',	1,	45937,	'2019-03-16 03:59:51',	'Shahada',	'Shahada',	'Shahada'),
(1256752,	103,	1270260,	'Shahabad',	'Shahabad',	'Shahabad',	1,	45936,	'2019-03-16 03:59:51',	'Shahabad',	'Shahabad',	'Shahabad'),
(1256913,	103,	1264542,	'Sehore',	'Sehore',	'Sehore',	1,	45575,	'2019-03-16 03:59:51',	'Sehore',	'Sehore',	'Sehore'),
(1256922,	103,	1278629,	'Secunderabad',	'Secunderabad',	'Secunderabad',	1,	45491,	'2019-03-16 03:59:51',	'Secunderabad',	'Secunderabad',	'Secunderabad'),
(1256983,	103,	1267701,	'Saundatti',	'Saundatti',	'Saundatti',	1,	44827,	'2019-03-16 03:59:51',	'Saundatti',	'Saundatti',	'Saundatti'),
(1256995,	103,	1255053,	'Sattur',	'Sattur',	'Sattur',	1,	44780,	'2019-03-16 03:59:51',	'Sattur',	'Sattur',	'Sattur'),
(1257022,	103,	1264542,	'Satna',	'Satna',	'Satna',	1,	44772,	'2019-03-16 03:59:51',	'Satna',	'Satna',	'Satna'),
(1257055,	103,	1264418,	'Сатара',	'Satara',	'Satara',	1,	44765,	'2019-03-16 03:59:51',	'Satara',	'Satara',	'Satara'),
(1257191,	103,	1259223,	'Sardulgarh',	'Sardulgarh',	'Sardulgarh',	1,	44688,	'2019-03-16 03:59:51',	'Sardulgarh',	'Sardulgarh',	'Sardulgarh'),
(1257240,	103,	1264542,	'Sarangi',	'Sarangi',	'Sarangi',	1,	44664,	'2019-03-16 03:59:51',	'Sarangi',	'Sarangi',	'Sarangi'),
(1257347,	103,	1271157,	'Sanquelim',	'Sanquelim',	'Sanquelim',	1,	44420,	'2019-03-16 03:59:51',	'Sanquelim',	'Sanquelim',	'Sanquelim'),
(1257402,	103,	1259223,	'Sangrur',	'Sangrur',	'Sangrur',	1,	44390,	'2019-03-16 03:59:51',	'Sangrur',	'Sangrur',	'Sangrur'),
(1257416,	103,	1264418,	'Sangli',	'Sangli',	'Sangli',	1,	44388,	'2019-03-16 03:59:51',	'Sangli',	'Sangli',	'Sangli'),
(1257436,	103,	1264418,	'Sangamner',	'Sangamner',	'Sangamner',	1,	44381,	'2019-03-16 03:59:51',	'Sangamner',	'Sangamner',	'Sangamner'),
(1257476,	103,	1271157,	'Sancoale',	'Sancoale',	'Sancoale',	1,	44306,	'2019-03-16 03:59:51',	'Sancoale',	'Sancoale',	'Sancoale'),
(1257539,	103,	1258899,	'Самбхара',	'Sambhar',	'Sambhar',	1,	43914,	'2019-03-16 03:59:51',	'Sambhar',	'Sambhar',	'Sambhar'),
(1257540,	103,	1253626,	'Sambhal',	'Sambhal',	'Sambhal',	1,	43913,	'2019-03-16 03:59:51',	'Sambhal',	'Sambhal',	'Sambhal'),
(1257542,	103,	1261029,	'Самбалпур',	'Sambalpur',	'Sambalpur',	1,	43912,	'2019-03-16 03:59:51',	'Sambalpur',	'Sambalpur',	'Sambalpur'),
(1257629,	103,	1255053,	'Салем',	'Salem',	'Salem',	1,	43765,	'2019-03-16 03:59:51',	'Salem',	'Salem',	'Salem'),
(1257657,	103,	1444365,	'Салай',	'Salai',	'Salai',	1,	43724,	'2019-03-16 03:59:51',	'Salai',	'Salai',	'Salai'),
(1257771,	103,	1262963,	'Saiha',	'Saiha',	'Saiha',	1,	42249,	'2019-03-16 03:59:51',	'Saiha',	'Saiha',	'Saiha'),
(1257795,	103,	1253626,	'Sahibabad',	'Sahibabad',	'Sahibabad',	1,	42243,	'2019-03-16 03:59:51',	'Sahibabad',	'Sahibabad',	'Sahibabad'),
(1257806,	103,	1253626,	'Saharanpur',	'Saharanpur',	'Saharanpur',	1,	42242,	'2019-03-16 03:59:51',	'Saharanpur',	'Saharanpur',	'Saharanpur'),
(1257845,	103,	1264542,	'Сагар',	'Sagar',	'Sagar',	1,	42229,	'2019-03-16 03:59:51',	'Sagar',	'Sagar',	'Sagar'),
(1257896,	103,	1253626,	'Sadabad',	'Sadabad',	'Sadabad',	1,	42208,	'2019-03-16 03:59:51',	'Sadabad',	'Sadabad',	'Sadabad'),
(1257921,	103,	1270770,	'Sabarmati',	'Sabarmati',	'Sabarmati',	1,	42161,	'2019-03-16 03:59:51',	'Sabarmati',	'Sabarmati',	'Sabarmati'),
(1257951,	103,	1259223,	'Rupnagar',	'Rupnagar',	'Rupnagar',	1,	42030,	'2019-03-16 03:59:51',	'Rupnagar',	'Rupnagar',	'Rupnagar'),
(1258044,	103,	1444366,	'Roorkee',	'Roorkee',	'Roorkee',	1,	41523,	'2019-03-16 03:59:51',	'Roorkee',	'Roorkee',	'Roorkee'),
(1258076,	103,	1270260,	'Рохтак',	'Rohtak',	'Rohtak',	1,	41401,	'2019-03-16 03:59:51',	'Rohtak',	'Rohtak',	'Rohtak'),
(1258099,	103,	1264418,	'Roha',	'Roha',	'Roha',	1,	41383,	'2019-03-16 03:59:51',	'Roha',	'Roha',	'Roha'),
(1258126,	103,	1252881,	'Rishra',	'Rishra',	'Rishra',	1,	40978,	'2019-03-16 03:59:51',	'Rishra',	'Rishra',	'Rishra'),
(1258128,	103,	1444366,	'Ришикеш',	'Rishikesh',	'Rishikesh',	1,	40977,	'2019-03-16 03:59:51',	'Rishikesh',	'Rishikesh',	'Rishikesh'),
(1258178,	103,	1270260,	'Rewari',	'Rewari',	'Rewari',	1,	40563,	'2019-03-16 03:59:51',	'Rewari',	'Rewari',	'Rewari'),
(1258182,	103,	1264542,	'Рева',	'Rewa',	'Rewa',	1,	40562,	'2019-03-16 03:59:51',	'Rewa',	'Rewa',	'Rewa'),
(1258315,	103,	1261029,	'Raurkela',	'Raurkela',	'Raurkela',	1,	40097,	'2019-03-16 03:59:51',	'Raurkela',	'Raurkela',	'Raurkela'),
(1258338,	103,	1264418,	'Ратнагири',	'Ratnagiri',	'Ratnagiri',	1,	40079,	'2019-03-16 03:59:51',	'Ratnagiri',	'Ratnagiri',	'Ratnagiri'),
(1258342,	103,	1264542,	'Ratlam',	'Ratlam',	'Ratlam',	1,	40077,	'2019-03-16 03:59:51',	'Ratlam',	'Ratlam',	'Ratlam'),
(1258451,	103,	1255053,	'Ranippettai',	'Ranippettai',	'Ranippettai',	1,	40019,	'2019-03-16 03:59:51',	'Ranippettai',	'Ranippettai',	'Ranippettai'),
(1258455,	103,	1444366,	'Ranikhet',	'Ranikhet',	'Ranikhet',	1,	40018,	'2019-03-16 03:59:51',	'Ranikhet',	'Ranikhet',	'Ranikhet'),
(1258470,	103,	1252881,	'Ранигандже',	'Raniganj',	'Raniganj',	1,	40017,	'2019-03-16 03:59:51',	'Raniganj',	'Raniganj',	'Raniganj'),
(1258522,	103,	1270770,	'Rander',	'Rander',	'Rander',	1,	39988,	'2019-03-16 03:59:51',	'Rander',	'Rander',	'Rander'),
(1258526,	103,	1444365,	'Ранчи',	'Ranchi',	'Ranchi',	1,	39968,	'2019-03-16 03:59:51',	'Ranchi',	'Ranchi',	'Ranchi'),
(1258528,	103,	1269320,	'Ranbirsinghpura',	'Ranbirsinghpura',	'Ranbirsinghpura',	1,	39963,	'2019-03-16 03:59:51',	'Ranbirsinghpura',	'Ranbirsinghpura',	'Ranbirsinghpura'),
(1258546,	103,	1252881,	'Ranaghat',	'Ranaghat',	'Ranaghat',	1,	39962,	'2019-03-16 03:59:51',	'Ranaghat',	'Ranaghat',	'Ranaghat'),
(1258599,	103,	1253626,	'Rampur',	'Rampur',	'Rampur',	1,	39949,	'2019-03-16 03:59:51',	'Rampur',	'Rampur',	'Rampur'),
(1258637,	103,	1444366,	'Ramnagar',	'Ramnagar',	'Ramnagar',	1,	39942,	'2019-03-16 03:59:51',	'Ramnagar',	'Ramnagar',	'Ramnagar'),
(1258698,	103,	1255053,	'Рамешварам',	'Rameswaram',	'Rameswaram',	1,	39936,	'2019-03-16 03:59:51',	'Rameswaram',	'Rameswaram',	'Rameswaram'),
(1258740,	103,	1255053,	'Раманатхапурама',	'Ramanathapuram',	'Ramanathapuram',	1,	39925,	'2019-03-16 03:59:51',	'Ramanathapuram',	'Ramanathapuram',	'Ramanathapuram'),
(1258803,	103,	1259223,	'Rajpura',	'Rajpura',	'Rajpura',	1,	39913,	'2019-03-16 03:59:51',	'Rajpura',	'Rajpura',	'Rajpura'),
(1258847,	103,	1270770,	'Раджкот',	'Rajkot',	'Rajkot',	1,	39912,	'2019-03-16 03:59:51',	'Rajkot',	'Rajkot',	'Rajkot'),
(1258916,	103,	1255053,	'Rajapalaiyam',	'Rajapalaiyam',	'Rajapalaiyam',	1,	39911,	'2019-03-16 03:59:51',	'Rajapalaiyam',	'Rajapalaiyam',	'Rajapalaiyam'),
(1258922,	103,	1278629,	'Rajampet',	'Rajampet',	'Rajampet',	1,	39910,	'2019-03-16 03:59:51',	'Rajampet',	'Rajampet',	'Rajampet'),
(1258932,	103,	1278629,	'Раджамандри',	'Rajahmundry',	'Rajahmundry',	1,	39909,	'2019-03-16 03:59:51',	'Rajahmundry',	'Rajahmundry',	'Rajahmundry'),
(1258978,	103,	1264542,	'Raipur',	'Raipur',	'Raipur',	1,	39904,	'2019-03-16 03:59:51',	'Raipur',	'Raipur',	'Raipur'),
(1258980,	103,	1444364,	'Raipur',	'Raipur',	'Raipur',	1,	39903,	'2019-03-16 03:59:51',	'Raipur',	'Raipur',	'Raipur'),
(1259005,	103,	1444364,	'Райгарх',	'Raigarh',	'Raigarh',	1,	39887,	'2019-03-16 03:59:51',	'Raigarh',	'Raigarh',	'Raigarh'),
(1259022,	103,	1259223,	'Rahon',	'Rahon',	'Rahon',	1,	39881,	'2019-03-16 03:59:51',	'Rahon',	'Rahon',	'Rahon'),
(1259036,	103,	1264418,	'Rahata',	'Rahata',	'Rahata',	1,	39877,	'2019-03-16 03:59:51',	'Rahata',	'Rahata',	'Rahata'),
(1259091,	103,	1267254,	'Квилон',	'Kollam',	'Kollam',	1,	24738,	'2019-03-16 03:59:51',	'Kollam',	'Kollam',	'Kollam'),
(1259110,	103,	1259223,	'Qadian',	'Qadian',	'Qadian',	1,	39639,	'2019-03-16 03:59:51',	'Qadian',	'Qadian',	'Qadian'),
(1259124,	103,	1267701,	'Puttur',	'Puttur',	'Puttur',	1,	39611,	'2019-03-16 03:59:51',	'Puttur',	'Puttur',	'Puttur'),
(1259163,	103,	1252881,	'Puruliya',	'Puruliya',	'Puruliya',	1,	39585,	'2019-03-16 03:59:51',	'Puruliya',	'Puruliya',	'Puruliya'),
(1259184,	103,	1261029,	'Пури',	'Puri',	'Puri',	1,	39579,	'2019-03-16 03:59:51',	'Puri',	'Puri',	'Puri'),
(1259187,	103,	1255053,	'Purasawalkam',	'Purasawalkam',	'Purasawalkam',	1,	39568,	'2019-03-16 03:59:51',	'Purasawalkam',	'Purasawalkam',	'Purasawalkam'),
(1259229,	103,	1264418,	'Пуна',	'Pune',	'Pune',	1,	39560,	'2019-03-16 03:59:51',	'Pune',	'Pune',	'Pune'),
(1259312,	103,	1278629,	'Proddatur',	'Proddatur',	'Proddatur',	1,	39403,	'2019-03-16 03:59:51',	'Proddatur',	'Proddatur',	'Proddatur'),
(1259385,	103,	1278647,	'Порт-Блэр',	'Port Blair',	'Port Blair',	1,	38841,	'2019-03-16 03:59:51',	'Port Blair',	'Port Blair',	'Port Blair'),
(1259395,	103,	1270770,	'Порбандаром',	'Porbandar',	'Porbandar',	1,	38808,	'2019-03-16 03:59:51',	'Porbandar',	'Porbandar',	'Porbandar'),
(1259400,	103,	1255053,	'Poonamalle',	'Poonamalle',	'Poonamalle',	1,	38793,	'2019-03-16 03:59:51',	'Poonamalle',	'Poonamalle',	'Poonamalle'),
(1259425,	103,	1259424,	'Пондишери',	'Puducherry',	'Puducherry',	1,	39483,	'2019-03-16 03:59:51',	'Puducherry',	'Puducherry',	'Puducherry'),
(1259429,	103,	1271157,	'Ponda',	'Ponda',	'Ponda',	1,	38647,	'2019-03-16 03:59:51',	'Ponda',	'Ponda',	'Ponda'),
(1259434,	103,	1255053,	'Polur',	'Polur',	'Polur',	1,	38578,	'2019-03-16 03:59:51',	'Polur',	'Polur',	'Polur'),
(1259440,	103,	1255053,	'Pollachi',	'Pollachi',	'Pollachi',	1,	38551,	'2019-03-16 03:59:51',	'Pollachi',	'Pollachi',	'Pollachi'),
(1259541,	103,	1267254,	'Piravam',	'Piravam',	'Piravam',	1,	38050,	'2019-03-16 03:59:51',	'Piravam',	'Piravam',	'Piravam'),
(1259686,	103,	1253626,	'Пилибхит',	'Pilibhit',	'Pilibhit',	1,	37901,	'2019-03-16 03:59:51',	'Pilibhit',	'Pilibhit',	'Pilibhit'),
(1259693,	103,	1258899,	'Pilani',	'Pilani',	'Pilani',	1,	37896,	'2019-03-16 03:59:51',	'Pilani',	'Pilani',	'Pilani'),
(1259704,	103,	1278629,	'Piduguralla',	'Piduguralla',	'Piduguralla',	1,	37789,	'2019-03-16 03:59:51',	'Piduguralla',	'Piduguralla',	'Piduguralla'),
(1259827,	103,	1259223,	'Phagwara',	'Phagwara',	'Phagwara',	1,	37699,	'2019-03-16 03:59:51',	'Phagwara',	'Phagwara',	'Phagwara'),
(1259869,	103,	1271157,	'Pernem',	'Pernem',	'Pernem',	1,	37453,	'2019-03-16 03:59:51',	'Pernem',	'Pernem',	'Pernem'),
(1259931,	103,	1264418,	'Pen',	'Pen',	'Pen',	1,	37303,	'2019-03-16 03:59:51',	'Pen',	'Pen',	'Pen'),
(1259939,	103,	1270260,	'Pehowa',	'Pehowa',	'Pehowa',	1,	37245,	'2019-03-16 03:59:51',	'Pehowa',	'Pehowa',	'Pehowa'),
(1259986,	103,	1278629,	'Pedana',	'Pedana',	'Pedana',	1,	37210,	'2019-03-16 03:59:51',	'Pedana',	'Pedana',	'Pedana'),
(1259994,	103,	1267254,	'Payyannur',	'Payyannur',	'Payyannur',	1,	37152,	'2019-03-16 03:59:51',	'Payyannur',	'Payyannur',	'Payyannur'),
(1260052,	103,	1267254,	'Pattambi',	'Pattambi',	'Pattambi',	1,	37067,	'2019-03-16 03:59:51',	'Pattambi',	'Pattambi',	'Pattambi'),
(1260086,	103,	1275715,	'Патна',	'Patna',	'Patna',	1,	37059,	'2019-03-16 03:59:51',	'Patna',	'Patna',	'Patna'),
(1260107,	103,	1259223,	'Патьяла',	'Patiala',	'Patiala',	1,	37058,	'2019-03-16 03:59:51',	'Patiala',	'Patiala',	'Patiala'),
(1260137,	103,	1259223,	'Патханкот',	'Pathankot',	'Pathankot',	1,	37056,	'2019-03-16 03:59:51',	'Pathankot',	'Pathankot',	'Pathankot'),
(1260138,	103,	1267254,	'Pathanamthitta',	'Pathanamthitta',	'Pathanamthitta',	1,	37055,	'2019-03-16 03:59:51',	'Pathanamthitta',	'Pathanamthitta',	'Pathanamthitta'),
(1260168,	103,	1278629,	'Patancheru',	'Patancheru',	'Patancheru',	1,	37042,	'2019-03-16 03:59:51',	'Patancheru',	'Patancheru',	'Patancheru'),
(1260173,	103,	1270770,	'Патан',	'Patan',	'Patan',	1,	37041,	'2019-03-16 03:59:51',	'Patan',	'Patan',	'Patan'),
(1260333,	103,	1264418,	'Parel',	'Parel',	'Parel',	1,	36894,	'2019-03-16 03:59:51',	'Parel',	'Parel',	'Parel'),
(1260421,	103,	1270101,	'Paonta Sahib',	'Paonta Sahib',	'Paonta Sahib',	1,	36851,	'2019-03-16 03:59:51',	'Paonta Sahib',	'Paonta Sahib',	'Paonta Sahib'),
(1260434,	103,	1264418,	'Panvel',	'Panvel',	'Panvel',	1,	36844,	'2019-03-16 03:59:51',	'Panvel',	'Panvel',	'Panvel'),
(1260445,	103,	1252881,	'Panskura',	'Panskura',	'Panskura',	1,	36836,	'2019-03-16 03:59:51',	'Panskura',	'Panskura',	'Panskura'),
(1260448,	103,	1255053,	'Panruti',	'Panruti',	'Panruti',	1,	36834,	'2019-03-16 03:59:51',	'Panruti',	'Panruti',	'Panruti'),
(1260476,	103,	1270260,	'Панипата',	'Panipat',	'Panipat',	1,	36824,	'2019-03-16 03:59:51',	'Panipat',	'Panipat',	'Panipat'),
(1260546,	103,	1264418,	'Pandharpur',	'Pandharpur',	'Pandharpur',	1,	36814,	'2019-03-16 03:59:51',	'Pandharpur',	'Pandharpur',	'Pandharpur'),
(1260607,	103,	1271157,	'Панаджи',	'Panaji',	'Panaji',	1,	36805,	'2019-03-16 03:59:51',	'Panaji',	'Panaji',	'Panaji'),
(1260637,	103,	1270260,	'Palwal',	'Palwal',	'Palwal',	1,	36791,	'2019-03-16 03:59:51',	'Palwal',	'Palwal',	'Palwal'),
(1260639,	103,	1264418,	'Palus',	'Palus',	'Palus',	1,	36790,	'2019-03-16 03:59:51',	'Palus',	'Palus',	'Palus'),
(1260697,	103,	1255053,	'Palladam',	'Palladam',	'Palladam',	1,	36716,	'2019-03-16 03:59:51',	'Palladam',	'Palladam',	'Palladam'),
(1260716,	103,	1258899,	'Пали',	'Pali',	'Pali',	1,	36709,	'2019-03-16 03:59:51',	'Pali',	'Pali',	'Pali'),
(1260728,	103,	1267254,	'Палаккад',	'Palakkad',	'Palakkad',	1,	36672,	'2019-03-16 03:59:51',	'Palakkad',	'Palakkad',	'Palakkad'),
(1260730,	103,	1264418,	'Palghar',	'Palghar',	'Palghar',	1,	36708,	'2019-03-16 03:59:51',	'Palghar',	'Palghar',	'Palghar'),
(1260743,	103,	1255053,	'Palayankottai',	'Palayankottai',	'Palayankottai',	1,	36686,	'2019-03-16 03:59:51',	'Palayankottai',	'Palayankottai',	'Palayankottai'),
(1260745,	103,	1267254,	'Palayam',	'Palayam',	'Palayam',	1,	36685,	'2019-03-16 03:59:51',	'Palayam',	'Palayam',	'Palayam'),
(1260777,	103,	1270770,	'Palanpur',	'Palanpur',	'Palanpur',	1,	36676,	'2019-03-16 03:59:51',	'Palanpur',	'Palanpur',	'Palanpur'),
(1260784,	103,	1270101,	'Palampur',	'Palampur',	'Palampur',	1,	36675,	'2019-03-16 03:59:51',	'Palampur',	'Palampur',	'Palampur'),
(1260788,	103,	1273293,	'Palam',	'Palam',	'Palam',	1,	36673,	'2019-03-16 03:59:51',	'Palam',	'Palam',	'Palam'),
(1260830,	103,	1278629,	'Pakala',	'Pakala',	'Pakala',	1,	36661,	'2019-03-16 03:59:51',	'Pakala',	'Pakala',	'Pakala'),
(1261008,	103,	1267254,	'Ottappalam',	'Ottappalam',	'Ottappalam',	1,	36378,	'2019-03-16 03:59:51',	'Ottappalam',	'Ottappalam',	'Ottappalam'),
(1261039,	103,	1253626,	'Orai',	'Orai',	'Orai',	1,	36001,	'2019-03-16 03:59:51',	'Orai',	'Orai',	'Orai'),
(1261045,	103,	1278629,	'Онголе',	'Ongole',	'Ongole',	1,	35943,	'2019-03-16 03:59:51',	'Ongole',	'Ongole',	'Ongole'),
(1261121,	103,	1270101,	'Nurpur',	'Nurpur',	'Nurpur',	1,	35258,	'2019-03-16 03:59:51',	'Nurpur',	'Nurpur',	'Nurpur'),
(1261124,	103,	1259223,	'Nurmahal',	'Nurmahal',	'Nurmahal',	1,	35257,	'2019-03-16 03:59:51',	'Nurmahal',	'Nurmahal',	'Nurmahal'),
(1261181,	103,	1278253,	'North Lakhimpur',	'North Lakhimpur',	'North Lakhimpur',	1,	34937,	'2019-03-16 03:59:51',	'North Lakhimpur',	'North Lakhimpur',	'North Lakhimpur'),
(1261258,	103,	1278629,	'Nizamabad',	'Nizamabad',	'Nizamabad',	1,	34673,	'2019-03-16 03:59:51',	'Nizamabad',	'Nizamabad',	'Nizamabad'),
(1261398,	103,	1267254,	'Nilambur',	'Nilambur',	'Nilambur',	1,	34632,	'2019-03-16 03:59:51',	'Nilambur',	'Nilambur',	'Nilambur'),
(1261473,	103,	1255053,	'Neyveli',	'Neyveli',	'Neyveli',	1,	34477,	'2019-03-16 03:59:51',	'Neyveli',	'Neyveli',	'Neyveli'),
(1261529,	103,	1278629,	'Неллор',	'Nellore',	'Nellore',	1,	33784,	'2019-03-16 03:59:51',	'Nellore',	'Nellore',	'Nellore'),
(1261563,	103,	1278253,	'Nazira',	'Nazira',	'Nazira',	1,	33696,	'2019-03-16 03:59:51',	'Nazira',	'Nazira',	'Nazira'),
(1261653,	103,	1270770,	'Navsari',	'Navsari',	'Navsari',	1,	33686,	'2019-03-16 03:59:51',	'Navsari',	'Navsari',	'Navsari'),
(1261669,	103,	1252881,	'Навадвип',	'Navadwip',	'Navadwip',	1,	33653,	'2019-03-16 03:59:51',	'Navadwip',	'Navadwip',	'Navadwip'),
(1261731,	103,	1264418,	'Насик',	'Nashik',	'Nashik',	1,	33590,	'2019-03-16 03:59:51',	'Nashik',	'Nashik',	'Nashik'),
(1261772,	103,	1270260,	'Narnaul',	'Narnaul',	'Narnaul',	1,	33574,	'2019-03-16 03:59:51',	'Narnaul',	'Narnaul',	'Narnaul'),
(1261848,	103,	1278629,	'Narasaraopet',	'Narasaraopet',	'Narasaraopet',	1,	33566,	'2019-03-16 03:59:51',	'Narasaraopet',	'Narasaraopet',	'Narasaraopet'),
(1261872,	103,	1258899,	'Naraina',	'Naraina',	'Naraina',	1,	33565,	'2019-03-16 03:59:51',	'Naraina',	'Naraina',	'Naraina'),
(1261922,	103,	1259223,	'Нангал',	'Nangal Township',	'Nangal Township',	1,	33524,	'2019-03-16 03:59:51',	'Nangal Township',	'Nangal Township',	'Nangal Township'),
(1261927,	103,	1278629,	'Nandyal',	'Nandyal',	'Nandyal',	1,	33523,	'2019-03-16 03:59:51',	'Nandyal',	'Nandyal',	'Nandyal'),
(1261931,	103,	1264418,	'Nandurbar',	'Nandurbar',	'Nandurbar',	1,	33521,	'2019-03-16 03:59:51',	'Nandurbar',	'Nandurbar',	'Nandurbar'),
(1261977,	103,	1264418,	'Нандед',	'Nanded',	'Nanded',	1,	33519,	'2019-03-16 03:59:51',	'Nanded',	'Nanded',	'Nanded'),
(1262039,	103,	1255053,	'Namakkal',	'Namakkal',	'Namakkal',	1,	33507,	'2019-03-16 03:59:51',	'Namakkal',	'Namakkal',	'Namakkal'),
(1262067,	103,	1278629,	'Налгонда',	'Nalgonda',	'Nalgonda',	1,	33504,	'2019-03-16 03:59:51',	'Nalgonda',	'Nalgonda',	'Nalgonda'),
(1262083,	103,	1270101,	'Nalagarh',	'Nalagarh',	'Nalagarh',	1,	33501,	'2019-03-16 03:59:51',	'Nalagarh',	'Nalagarh',	'Nalagarh'),
(1262180,	103,	1264418,	'Нагпур',	'Nagpur',	'Nagpur',	1,	33480,	'2019-03-16 03:59:51',	'Nagpur',	'Nagpur',	'Nagpur'),
(1262204,	103,	1255053,	'Nagercoil',	'Nagercoil',	'Nagercoil',	1,	33476,	'2019-03-16 03:59:51',	'Nagercoil',	'Nagercoil',	'Nagercoil'),
(1262216,	103,	1258899,	'Nagaur',	'Nagaur',	'Nagaur',	1,	33473,	'2019-03-16 03:59:51',	'Nagaur',	'Nagaur',	'Nagaur'),
(1262253,	103,	1258899,	'Nagar',	'Nagar',	'Nagar',	1,	33472,	'2019-03-16 03:59:51',	'Nagar',	'Nagar',	'Nagar'),
(1262260,	103,	1255053,	'Nagappattinam',	'Nagappattinam',	'Nagappattinam',	1,	33471,	'2019-03-16 03:59:51',	'Nagappattinam',	'Nagappattinam',	'Nagappattinam'),
(1262292,	103,	1270770,	'Nadiad',	'Nadiad',	'Nadiad',	1,	33468,	'2019-03-16 03:59:51',	'Nadiad',	'Nadiad',	'Nadiad'),
(1262319,	103,	1259223,	'Nabha',	'Nabha',	'Nabha',	1,	33455,	'2019-03-16 03:59:51',	'Nabha',	'Nabha',	'Nabha'),
(1262321,	103,	1267701,	'Майсур',	'Mysore',	'Mysore',	1,	33444,	'2019-03-16 03:59:51',	'Mysore',	'Mysore',	'Mysore'),
(1262330,	103,	1275715,	'Muzaffarpur',	'Muzaffarpur',	'Muzaffarpur',	1,	33425,	'2019-03-16 03:59:51',	'Muzaffarpur',	'Muzaffarpur',	'Muzaffarpur'),
(1262332,	103,	1253626,	'Muzaffarnagar',	'Muzaffarnagar',	'Muzaffarnagar',	1,	33424,	'2019-03-16 03:59:51',	'Muzaffarnagar',	'Muzaffarnagar',	'Muzaffarnagar'),
(1262482,	103,	1275715,	'Мангер',	'Munger',	'Munger',	1,	33310,	'2019-03-16 03:59:51',	'Munger',	'Munger',	'Munger'),
(1262497,	103,	1270770,	'Mundra',	'Mundra',	'Mundra',	1,	33304,	'2019-03-16 03:59:51',	'Mundra',	'Mundra',	'Mundra'),
(1262775,	103,	1270770,	'Morbi',	'Morbi',	'Morbi',	1,	32716,	'2019-03-16 03:59:51',	'Morbi',	'Morbi',	'Morbi'),
(1262801,	103,	1253626,	'Морадабад',	'Moradabad',	'Moradabad',	1,	32693,	'2019-03-16 03:59:51',	'Moradabad',	'Moradabad',	'Moradabad'),
(1262926,	103,	1261029,	'Mohana',	'Mohana',	'Mohana',	1,	31790,	'2019-03-16 03:59:51',	'Mohana',	'Mohana',	'Mohana'),
(1262951,	103,	1259223,	'Могу',	'Moga',	'Moga',	1,	31773,	'2019-03-16 03:59:51',	'Moga',	'Moga',	'Moga'),
(1262995,	103,	1253626,	'Мирзапур',	'Mirzapur',	'Mirzapur',	1,	31669,	'2019-03-16 03:59:51',	'Mirzapur',	'Mirzapur',	'Mirzapur'),
(1263012,	103,	1278629,	'Mirialguda',	'Mirialguda',	'Mirialguda',	1,	31660,	'2019-03-16 03:59:51',	'Mirialguda',	'Mirialguda',	'Mirialguda'),
(1263027,	103,	1264418,	'Miraj',	'Miraj',	'Miraj',	1,	31627,	'2019-03-16 03:59:51',	'Miraj',	'Miraj',	'Miraj'),
(1263080,	103,	1264542,	'Mhow',	'Mhow',	'Mhow',	1,	31173,	'2019-03-16 03:59:51',	'Mhow',	'Mhow',	'Mhow'),
(1263166,	103,	1255053,	'Melapalayam',	'Melapalayam',	'Melapalayam',	1,	30692,	'2019-03-16 03:59:51',	'Melapalayam',	'Melapalayam',	'Melapalayam'),
(1263214,	103,	1253626,	'Меерут',	'Meerut',	'Meerut',	1,	30641,	'2019-03-16 03:59:51',	'Meerut',	'Meerut',	'Meerut'),
(1263220,	103,	1252881,	'Миднапор',	'Medinipur',	'Medinipur',	1,	30615,	'2019-03-16 03:59:51',	'Medinipur',	'Medinipur',	'Medinipur'),
(1263230,	103,	1278629,	'Медак',	'Medak',	'Medak',	1,	30577,	'2019-03-16 03:59:51',	'Medak',	'Medak',	'Medak'),
(1263285,	103,	1267254,	'Mavelikara',	'Mavelikara',	'Mavelikara',	1,	30354,	'2019-03-16 03:59:51',	'Mavelikara',	'Mavelikara',	'Mavelikara'),
(1263293,	103,	1259223,	'Maur',	'Maur',	'Maur',	1,	30323,	'2019-03-16 03:59:51',	'Maur',	'Maur',	'Maur'),
(1263364,	103,	1253626,	'Матхура',	'Mathura',	'Mathura',	1,	30262,	'2019-03-16 03:59:51',	'Mathura',	'Mathura',	'Mathura'),
(1263370,	103,	1264418,	'Matheran',	'Matheran',	'Matheran',	1,	30253,	'2019-03-16 03:59:51',	'Matheran',	'Matheran',	'Matheran'),
(1263494,	103,	1271157,	'Мармагао',	'Marmagao',	'Marmagao',	1,	29952,	'2019-03-16 03:59:51',	'Marmagao',	'Marmagao',	'Marmagao'),
(1263504,	103,	1278629,	'Markapur',	'Markapur',	'Markapur',	1,	29867,	'2019-03-16 03:59:51',	'Markapur',	'Markapur',	'Markapur'),
(1263622,	103,	1259223,	'Mansa',	'Mansa',	'Mansa',	1,	29517,	'2019-03-16 03:59:51',	'Mansa',	'Mansa',	'Mansa'),
(1263659,	103,	1255053,	'Mannargudi',	'Mannargudi',	'Mannargudi',	1,	29492,	'2019-03-16 03:59:51',	'Mannargudi',	'Mannargudi',	'Mannargudi'),
(1263669,	103,	1264418,	'Mankhurd',	'Mankhurd',	'Mankhurd',	1,	29488,	'2019-03-16 03:59:51',	'Mankhurd',	'Mankhurd',	'Mankhurd'),
(1263694,	103,	1267254,	'Manjeri',	'Manjeri',	'Manjeri',	1,	29485,	'2019-03-16 03:59:51',	'Manjeri',	'Manjeri',	'Manjeri'),
(1263707,	103,	1267701,	'Manipala',	'Manipala',	'Manipala',	1,	29475,	'2019-03-16 03:59:51',	'Manipala',	'Manipala',	'Manipala'),
(1263780,	103,	1267701,	'Мангалуру',	'Mangalore',	'Mangalore',	1,	29456,	'2019-03-16 03:59:51',	'Mangalore',	'Mangalore',	'Mangalore'),
(1263797,	103,	1278629,	'Mangalagiri',	'Mangalagiri',	'Mangalagiri',	1,	29455,	'2019-03-16 03:59:51',	'Mangalagiri',	'Mangalagiri',	'Mangalagiri'),
(1263814,	103,	1267701,	'Mandya',	'Mandya',	'Mandya',	1,	29450,	'2019-03-16 03:59:51',	'Mandya',	'Mandya',	'Mandya'),
(1263862,	103,	1270101,	'Манди',	'Mandi',	'Mandi',	1,	29446,	'2019-03-16 03:59:51',	'Mandi',	'Mandi',	'Mandi'),
(1263936,	103,	1278629,	'Mancheral',	'Mancheral',	'Mancheral',	1,	29416,	'2019-03-16 03:59:51',	'Mancheral',	'Mancheral',	'Mancheral'),
(1263997,	103,	1255053,	'Махабалипурам',	'Mamallapuram',	'Mamallapuram',	1,	29386,	'2019-03-16 03:59:51',	'Mamallapuram',	'Mamallapuram',	'Mamallapuram'),
(1264010,	103,	1267701,	'Malur',	'Malur',	'Malur',	1,	29376,	'2019-03-16 03:59:51',	'Malur',	'Malur',	'Malur'),
(1264121,	103,	1252881,	'Maldah',	'Maldah',	'Maldah',	1,	29309,	'2019-03-16 03:59:51',	'Maldah',	'Maldah',	'Maldah'),
(1264154,	103,	1267254,	'Малаппурам',	'Malappuram',	'Malappuram',	1,	29288,	'2019-03-16 03:59:51',	'Malappuram',	'Malappuram',	'Malappuram'),
(1264179,	103,	1264418,	'Malad',	'Malad',	'Malad',	1,	29273,	'2019-03-16 03:59:51',	'Malad',	'Malad',	'Malad'),
(1264326,	103,	1270770,	'Mahuva',	'Mahuva',	'Mahuva',	1,	29186,	'2019-03-16 03:59:51',	'Mahuva',	'Mahuva',	'Mahuva'),
(1264368,	103,	1252881,	'Mahishadal',	'Mahishadal',	'Mahishadal',	1,	29177,	'2019-03-16 03:59:51',	'Mahishadal',	'Mahishadal',	'Mahishadal'),
(1264389,	103,	1270770,	'Mahesana',	'Mahesana',	'Mahesana',	1,	29175,	'2019-03-16 03:59:51',	'Mahesana',	'Mahesana',	'Mahesana'),
(1264414,	103,	1444364,	'Mahasamund',	'Mahasamund',	'Mahasamund',	1,	29174,	'2019-03-16 03:59:51',	'Mahasamund',	'Mahasamund',	'Mahasamund'),
(1264489,	103,	1264418,	'Махад',	'Mahad',	'Mahad',	1,	29171,	'2019-03-16 03:59:51',	'Mahad',	'Mahad',	'Mahad'),
(1264491,	103,	1264418,	'Mahabaleshwar',	'Mahabaleshwar',	'Mahabaleshwar',	1,	29170,	'2019-03-16 03:59:51',	'Mahabaleshwar',	'Mahabaleshwar',	'Mahabaleshwar'),
(1264520,	103,	1255053,	'Madurantakam',	'Madurantakam',	'Madurantakam',	1,	29109,	'2019-03-16 03:59:51',	'Madurantakam',	'Madurantakam',	'Madurantakam'),
(1264521,	103,	1255053,	'Мадурай',	'Madurai',	'Madurai',	1,	29108,	'2019-03-16 03:59:51',	'Madurai',	'Madurai',	'Madurai'),
(1264527,	103,	1255053,	'Ченнаи',	'Chennai',	'Chennai',	1,	10111,	'2019-03-16 03:59:51',	'Chennai',	'Chennai',	'Chennai'),
(1264588,	103,	1271157,	'Маргао',	'Madgaon',	'Madgaon',	1,	29068,	'2019-03-16 03:59:51',	'Madgaon',	'Madgaon',	'Madgaon'),
(1264637,	103,	1278629,	'Machilipatnam',	'Machilipatnam',	'Machilipatnam',	1,	29036,	'2019-03-16 03:59:51',	'Machilipatnam',	'Machilipatnam',	'Machilipatnam'),
(1264728,	103,	1259223,	'Лудхияна',	'Ludhiana',	'Ludhiana',	1,	28738,	'2019-03-16 03:59:51',	'Ludhiana',	'Ludhiana',	'Ludhiana'),
(1264733,	103,	1253626,	'Лакхнау',	'Lucknow',	'Lucknow',	1,	28725,	'2019-03-16 03:59:51',	'Lucknow',	'Lucknow',	'Lucknow'),
(1264917,	103,	1252881,	'Liluah',	'Liluah',	'Liluah',	1,	27743,	'2019-03-16 03:59:51',	'Liluah',	'Liluah',	'Liluah'),
(1265014,	103,	1264418,	'Латур',	'Latur',	'Latur',	1,	26467,	'2019-03-16 03:59:51',	'Latur',	'Latur',	'Latur'),
(1265242,	103,	1253626,	'Lakhimpur',	'Lakhimpur',	'Lakhimpur',	1,	26019,	'2019-03-16 03:59:51',	'Lakhimpur',	'Lakhimpur',	'Lakhimpur'),
(1265246,	103,	1258899,	'Lakheri',	'Lakheri',	'Lakheri',	1,	26018,	'2019-03-16 03:59:51',	'Lakheri',	'Lakheri',	'Lakheri'),
(1265395,	103,	1267254,	'Kuttippuram',	'Kuttippuram',	'Kuttippuram',	1,	25056,	'2019-03-16 03:59:51',	'Kuttippuram',	'Kuttippuram',	'Kuttippuram'),
(1265400,	103,	1255053,	'Koothanallur',	'Koothanallur',	'Koothanallur',	1,	24793,	'2019-03-16 03:59:51',	'Koothanallur',	'Koothanallur',	'Koothanallur'),
(1265491,	103,	1278629,	'Карнул',	'Kurnool',	'Kurnool',	1,	25039,	'2019-03-16 03:59:51',	'Kurnool',	'Kurnool',	'Kurnool'),
(1265645,	103,	1267701,	'Kumta',	'Kumta',	'Kumta',	1,	25017,	'2019-03-16 03:59:51',	'Kumta',	'Kumta',	'Kumta'),
(1265683,	103,	1255053,	'Кумбаконам',	'Kumbakonam',	'Kumbakonam',	1,	25010,	'2019-03-16 03:59:51',	'Kumbakonam',	'Kumbakonam',	'Kumbakonam'),
(1265701,	103,	1270101,	'Кумар',	'Kumar',	'Kumar',	1,	25009,	'2019-03-16 03:59:51',	'Kumar',	'Kumar',	'Kumar'),
(1265711,	103,	1252881,	'Култи',	'Kulti',	'Kulti',	1,	25007,	'2019-03-16 03:59:51',	'Kulti',	'Kulti',	'Kulti'),
(1265859,	103,	1252881,	'Krishnanagar',	'Krishnanagar',	'Krishnanagar',	1,	24940,	'2019-03-16 03:59:51',	'Krishnanagar',	'Krishnanagar',	'Krishnanagar'),
(1265863,	103,	1255053,	'Кришнагири',	'Krishnagiri',	'Krishnagiri',	1,	24939,	'2019-03-16 03:59:51',	'Krishnagiri',	'Krishnagiri',	'Krishnagiri'),
(1265873,	103,	1267254,	'Калькутта',	'Kozhikode',	'Kozhikode',	1,	24865,	'2019-03-16 03:59:51',	'Kozhikode',	'Kozhikode',	'Kozhikode'),
(1265877,	103,	1278629,	'Koyyalagudem',	'Koyyalagudem',	'Koyyalagudem',	1,	24863,	'2019-03-16 03:59:51',	'Koyyalagudem',	'Koyyalagudem',	'Koyyalagudem'),
(1265891,	103,	1255053,	'Kovilpatti',	'Kovilpatti',	'Kovilpatti',	1,	24859,	'2019-03-16 03:59:51',	'Kovilpatti',	'Kovilpatti',	'Kovilpatti'),
(1265911,	103,	1267254,	'Коттаям',	'Kottayam',	'Kottayam',	1,	24848,	'2019-03-16 03:59:51',	'Kottayam',	'Kottayam',	'Kottayam'),
(1265916,	103,	1267254,	'Kottarakara',	'Kottarakara',	'Kottarakara',	1,	24847,	'2019-03-16 03:59:51',	'Kottarakara',	'Kottarakara',	'Kottarakara'),
(1265974,	103,	1259223,	'Kot Isa Khan',	'Kot Isa Khan',	'Kot Isa Khan',	1,	24833,	'2019-03-16 03:59:51',	'Kot Isa Khan',	'Kot Isa Khan',	'Kot Isa Khan'),
(1266014,	103,	1444366,	'Kotdwara',	'Kotdwara',	'Kotdwara',	1,	24836,	'2019-03-16 03:59:51',	'Kotdwara',	'Kotdwara',	'Kotdwara'),
(1266038,	103,	1255053,	'Kotagiri',	'Kotagiri',	'Kotagiri',	1,	24835,	'2019-03-16 03:59:51',	'Kotagiri',	'Kotagiri',	'Kotagiri'),
(1266049,	103,	1258899,	'Кота',	'Kota',	'Kota',	1,	24834,	'2019-03-16 03:59:51',	'Kota',	'Kota',	'Kota'),
(1266087,	103,	1270770,	'Kosamba',	'Kosamba',	'Kosamba',	1,	24819,	'2019-03-16 03:59:51',	'Kosamba',	'Kosamba',	'Kosamba'),
(1266122,	103,	1444364,	'Корба',	'Korba',	'Korba',	1,	24799,	'2019-03-16 03:59:51',	'Korba',	'Korba',	'Korba'),
(1266128,	103,	1261029,	'Корапут',	'Koraput',	'Koraput',	1,	24797,	'2019-03-16 03:59:51',	'Koraput',	'Koraput',	'Koraput'),
(1266267,	103,	1267701,	'Kollegal',	'Kollegal',	'Kollegal',	1,	24740,	'2019-03-16 03:59:51',	'Kollegal',	'Kollegal',	'Kollegal'),
(1266285,	103,	1264418,	'Kolhapur',	'Kolhapur',	'Kolhapur',	1,	24734,	'2019-03-16 03:59:51',	'Kolhapur',	'Kolhapur',	'Kolhapur'),
(1266305,	103,	1267701,	'Колар',	'Kolar',	'Kolar',	1,	24730,	'2019-03-16 03:59:51',	'Kolar',	'Kolar',	'Kolar'),
(1266366,	103,	1262271,	'Кохима',	'Kohima',	'Kohima',	1,	24719,	'2019-03-16 03:59:51',	'Kohima',	'Kohima',	'Kohima'),
(1266385,	103,	1267254,	'Kodungallur',	'Kodungallur',	'Kodungallur',	1,	24711,	'2019-03-16 03:59:51',	'Kodungallur',	'Kodungallur',	'Kodungallur'),
(1266484,	103,	1258899,	'Kishangarh',	'Kishangarh',	'Kishangarh',	1,	24549,	'2019-03-16 03:59:51',	'Kishangarh',	'Kishangarh',	'Kishangarh'),
(1266616,	103,	1261029,	'Khurda',	'Khurda',	'Khurda',	1,	24252,	'2019-03-16 03:59:51',	'Khurda',	'Khurda',	'Khurda'),
(1266666,	103,	1264418,	'Khopoli',	'Khopoli',	'Khopoli',	1,	24248,	'2019-03-16 03:59:51',	'Khopoli',	'Khopoli',	'Khopoli'),
(1266762,	103,	1253626,	'Kheri',	'Kheri',	'Kheri',	1,	24239,	'2019-03-16 03:59:51',	'Kheri',	'Kheri',	'Kheri'),
(1266809,	103,	1270770,	'Хеда',	'Kheda',	'Kheda',	1,	24238,	'2019-03-16 03:59:51',	'Kheda',	'Kheda',	'Kheda'),
(1266849,	103,	1253626,	'Khatauli',	'Khatauli',	'Khatauli',	1,	24236,	'2019-03-16 03:59:51',	'Khatauli',	'Khatauli',	'Khatauli'),
(1266960,	103,	1259223,	'Kharar',	'Kharar',	'Kharar',	1,	24232,	'2019-03-16 03:59:51',	'Kharar',	'Kharar',	'Kharar'),
(1266976,	103,	1252881,	'Харагпур',	'Kharagpur',	'Kharagpur',	1,	24231,	'2019-03-16 03:59:51',	'Kharagpur',	'Kharagpur',	'Kharagpur'),
(1267016,	103,	1259223,	'Ханна',	'Khanna',	'Khanna',	1,	24229,	'2019-03-16 03:59:51',	'Khanna',	'Khanna',	'Khanna'),
(1267076,	103,	1278629,	'Кхаммам',	'Khammam',	'Khammam',	1,	24227,	'2019-03-16 03:59:51',	'Khammam',	'Khammam',	'Khammam'),
(1267090,	103,	1270770,	'Khambhat',	'Khambhat',	'Khambhat',	1,	24225,	'2019-03-16 03:59:51',	'Khambhat',	'Khambhat',	'Khambhat'),
(1267227,	103,	1270770,	'Keshod',	'Keshod',	'Keshod',	1,	24168,	'2019-03-16 03:59:51',	'Keshod',	'Keshod',	'Keshod'),
(1267394,	103,	1278629,	'Kavali',	'Kavali',	'Kavali',	1,	23965,	'2019-03-16 03:59:51',	'Kavali',	'Kavali',	'Kavali'),
(1267414,	103,	1270260,	'Каул',	'Kaul',	'Kaul',	1,	23961,	'2019-03-16 03:59:51',	'Kaul',	'Kaul',	'Kaul'),
(1267461,	103,	1264418,	'Katol',	'Katol',	'Katol',	1,	23947,	'2019-03-16 03:59:51',	'Katol',	'Katol',	'Katol'),
(1267486,	103,	1269320,	'Kathua',	'Kathua',	'Kathua',	1,	23945,	'2019-03-16 03:59:51',	'Kathua',	'Kathua',	'Kathua'),
(1267575,	103,	1253626,	'Kasia',	'Kasia',	'Kasia',	1,	23926,	'2019-03-16 03:59:51',	'Kasia',	'Kasia',	'Kasia'),
(1267616,	103,	1267254,	'Kasaragod',	'Kasaragod',	'Kasaragod',	1,	23919,	'2019-03-16 03:59:51',	'Kasaragod',	'Kasaragod',	'Kasaragod'),
(1267635,	103,	1267701,	'Карвар',	'Karwar',	'Karwar',	1,	23917,	'2019-03-16 03:59:51',	'Karwar',	'Karwar',	'Karwar'),
(1267648,	103,	1255053,	'Карур',	'Karur',	'Karur',	1,	23916,	'2019-03-16 03:59:51',	'Karur',	'Karur',	'Karur'),
(1267708,	103,	1270260,	'Карнал',	'Karnal',	'Karnal',	1,	23905,	'2019-03-16 03:59:51',	'Karnal',	'Karnal',	'Karnal'),
(1267742,	103,	1264418,	'Karjat',	'Karjat',	'Karjat',	1,	23889,	'2019-03-16 03:59:51',	'Karjat',	'Karjat',	'Karjat'),
(1267745,	103,	1255053,	'Kariapatti',	'Kariapatti',	'Kariapatti',	1,	23886,	'2019-03-16 03:59:51',	'Kariapatti',	'Kariapatti',	'Kariapatti'),
(1267755,	103,	1278629,	'Karimnagar',	'Karimnagar',	'Karimnagar',	1,	23887,	'2019-03-16 03:59:51',	'Karimnagar',	'Karimnagar',	'Karimnagar'),
(1267776,	103,	1269320,	'Kargil',	'Kargil',	'Kargil',	1,	23884,	'2019-03-16 03:59:51',	'Kargil',	'Kargil',	'Kargil'),
(1267862,	103,	1270770,	'Karamsad',	'Karamsad',	'Karamsad',	1,	23876,	'2019-03-16 03:59:51',	'Karamsad',	'Karamsad',	'Karamsad'),
(1267885,	103,	1255053,	'Karaikkudi',	'Karaikkudi',	'Karaikkudi',	1,	23873,	'2019-03-16 03:59:51',	'Karaikkudi',	'Karaikkudi',	'Karaikkudi'),
(1267887,	103,	1259424,	'Karaikal',	'Karaikal',	'Karaikal',	1,	23872,	'2019-03-16 03:59:51',	'Karaikal',	'Karaikal',	'Karaikal'),
(1267904,	103,	1264418,	'Karad',	'Karad',	'Karad',	1,	23869,	'2019-03-16 03:59:51',	'Karad',	'Karad',	'Karad'),
(1267911,	103,	1259223,	'Kapurthala',	'Kapurthala',	'Kapurthala',	1,	23865,	'2019-03-16 03:59:51',	'Kapurthala',	'Kapurthala',	'Kapurthala'),
(1267978,	103,	1261029,	'Kantabanji',	'Kantabanji',	'Kantabanji',	1,	23850,	'2019-03-16 03:59:51',	'Kantabanji',	'Kantabanji',	'Kantabanji'),
(1267995,	103,	1253626,	'Канпур',	'Kanpur',	'Kanpur',	1,	23842,	'2019-03-16 03:59:51',	'Kanpur',	'Kanpur',	'Kanpur'),
(1268008,	103,	1255053,	'Каньякумари',	'Kanniyakumari',	'Kanniyakumari',	1,	23840,	'2019-03-16 03:59:51',	'Kanniyakumari',	'Kanniyakumari',	'Kanniyakumari'),
(1268015,	103,	1267254,	'Kannangad',	'Kannangad',	'Kannangad',	1,	23838,	'2019-03-16 03:59:51',	'Kannangad',	'Kannangad',	'Kannangad'),
(1268031,	103,	1444364,	'Kanker',	'Kanker',	'Kanker',	1,	23837,	'2019-03-16 03:59:51',	'Kanker',	'Kanker',	'Kanker'),
(1268084,	103,	1270101,	'Kangra',	'Kangra',	'Kangra',	1,	23834,	'2019-03-16 03:59:51',	'Kangra',	'Kangra',	'Kangra'),
(1268159,	103,	1255053,	'Канчипурам',	'Kanchipuram',	'Kanchipuram',	1,	23823,	'2019-03-16 03:59:51',	'Kanchipuram',	'Kanchipuram',	'Kanchipuram'),
(1268293,	103,	1252881,	'Kalyani',	'Kalyani',	'Kalyani',	1,	23791,	'2019-03-16 03:59:51',	'Kalyani',	'Kalyani',	'Kalyani'),
(1268295,	103,	1264418,	'Кальян',	'Kalyan',	'Kalyan',	1,	23790,	'2019-03-16 03:59:51',	'Kalyan',	'Kalyan',	'Kalyan'),
(1268328,	103,	1255053,	'Kalpakkam',	'Kalpakkam',	'Kalpakkam',	1,	23778,	'2019-03-16 03:59:51',	'Kalpakkam',	'Kalpakkam',	'Kalpakkam'),
(1268381,	103,	1270101,	'Калки',	'Kalka',	'Kalka',	1,	23770,	'2019-03-16 03:59:51',	'Kalka',	'Kalka',	'Kalka'),
(1268561,	103,	1278629,	'Какинада',	'Kakinada',	'Kakinada',	1,	23752,	'2019-03-16 03:59:51',	'Kakinada',	'Kakinada',	'Kakinada'),
(1268593,	103,	1270260,	'Kaithal',	'Kaithal',	'Kaithal',	1,	23747,	'2019-03-16 03:59:51',	'Kaithal',	'Kaithal',	'Kaithal'),
(1268651,	103,	1264418,	'Kagal',	'Kagal',	'Kagal',	1,	23731,	'2019-03-16 03:59:51',	'Kagal',	'Kagal',	'Kagal'),
(1268662,	103,	1267701,	'Kadur',	'Kadur',	'Kadur',	1,	23730,	'2019-03-16 03:59:51',	'Kadur',	'Kadur',	'Kadur'),
(1268680,	103,	1270770,	'Kadi',	'Kadi',	'Kadi',	1,	23725,	'2019-03-16 03:59:51',	'Kadi',	'Kadi',	'Kadi'),
(1268707,	103,	1255053,	'Kadayanallur',	'Kadayanallur',	'Kadayanallur',	1,	23721,	'2019-03-16 03:59:51',	'Kadayanallur',	'Kadayanallur',	'Kadayanallur'),
(1268715,	103,	1252881,	'Kanchrapara',	'Kanchrapara',	'Kanchrapara',	1,	23824,	'2019-03-16 03:59:51',	'Kanchrapara',	'Kanchrapara',	'Kanchrapara'),
(1268773,	103,	1270770,	'Junagadh',	'Junagadh',	'Junagadh',	1,	23678,	'2019-03-16 03:59:51',	'Junagadh',	'Junagadh',	'Junagadh'),
(1268782,	103,	1259223,	'Джаландхар',	'Jalandhar',	'Jalandhar',	1,	23300,	'2019-03-16 03:59:51',	'Jalandhar',	'Jalandhar',	'Jalandhar'),
(1268865,	103,	1258899,	'Джодхпур',	'Jodhpur',	'Jodhpur',	1,	23534,	'2019-03-16 03:59:51',	'Jodhpur',	'Jodhpur',	'Jodhpur'),
(1268907,	103,	1270260,	'Jind',	'Jind',	'Jind',	1,	23526,	'2019-03-16 03:59:51',	'Jind',	'Jind',	'Jind'),
(1268977,	103,	1261029,	'Jharsuguda',	'Jharsuguda',	'Jharsuguda',	1,	23520,	'2019-03-16 03:59:51',	'Jharsuguda',	'Jharsuguda',	'Jharsuguda'),
(1268990,	103,	1252881,	'Jhargram',	'Jhargram',	'Jhargram',	1,	23519,	'2019-03-16 03:59:51',	'Jhargram',	'Jhargram',	'Jhargram'),
(1269006,	103,	1253626,	'Jhansi',	'Jhansi',	'Jhansi',	1,	23518,	'2019-03-16 03:59:51',	'Jhansi',	'Jhansi',	'Jhansi'),
(1269027,	103,	1258899,	'Jhalawar',	'Jhalawar',	'Jhalawar',	1,	23517,	'2019-03-16 03:59:51',	'Jhalawar',	'Jhalawar',	'Jhalawar'),
(1269042,	103,	1270260,	'Jhajjar',	'Jhajjar',	'Jhajjar',	1,	23516,	'2019-03-16 03:59:51',	'Jhajjar',	'Jhajjar',	'Jhajjar'),
(1269065,	103,	1270770,	'Jetpur',	'Jetpur',	'Jetpur',	1,	23500,	'2019-03-16 03:59:51',	'Jetpur',	'Jetpur',	'Jetpur'),
(1269135,	103,	1253626,	'Jaunpur',	'Jaunpur',	'Jaunpur',	1,	23392,	'2019-03-16 03:59:51',	'Jaunpur',	'Jaunpur',	'Jaunpur'),
(1269154,	103,	1261029,	'Jatani',	'Jatani',	'Jatani',	1,	23386,	'2019-03-16 03:59:51',	'Jatani',	'Jatani',	'Jatani'),
(1269300,	103,	1444365,	'Джамшедпур',	'Jamshedpur',	'Jamshedpur',	1,	23334,	'2019-03-16 03:59:51',	'Jamshedpur',	'Jamshedpur',	'Jamshedpur'),
(1269317,	103,	1270770,	'Джамнагаром',	'Jamnagar',	'Jamnagar',	1,	23333,	'2019-03-16 03:59:51',	'Jamnagar',	'Jamnagar',	'Jamnagar'),
(1269321,	103,	1269320,	'Джамму',	'Jammu',	'Jammu',	1,	23332,	'2019-03-16 03:59:51',	'Jammu',	'Jammu',	'Jammu'),
(1269388,	103,	1252881,	'Jalpaiguri',	'Jalpaiguri',	'Jalpaiguri',	1,	23307,	'2019-03-16 03:59:51',	'Jalpaiguri',	'Jalpaiguri',	'Jalpaiguri'),
(1269406,	103,	1264418,	'Джалгаоне',	'Jalgaon Jamod',	'Jalgaon Jamod',	1,	23302,	'2019-03-16 03:59:51',	'Jalgaon Jamod',	'Jalgaon Jamod',	'Jalgaon Jamod'),
(1269439,	103,	1270770,	'Джалалпор',	'Jalalpur',	'Jalalpur',	1,	23299,	'2019-03-16 03:59:51',	'Jalalpur',	'Jalalpur',	'Jalalpur'),
(1269477,	103,	1261029,	'Jajpur',	'Jajpur',	'Jajpur',	1,	23298,	'2019-03-16 03:59:51',	'Jajpur',	'Jajpur',	'Jajpur'),
(1269502,	103,	1264418,	'Jaisingpur',	'Jaisingpur',	'Jaisingpur',	1,	23297,	'2019-03-16 03:59:51',	'Jaisingpur',	'Jaisingpur',	'Jaisingpur'),
(1269515,	103,	1258899,	'Джайпур',	'Jaipur',	'Jaipur',	1,	23296,	'2019-03-16 03:59:51',	'Jaipur',	'Jaipur',	'Jaipur'),
(1269562,	103,	1278629,	'Jagtial',	'Jagtial',	'Jagtial',	1,	23289,	'2019-03-16 03:59:51',	'Jagtial',	'Jagtial',	'Jagtial'),
(1269605,	103,	1270260,	'Jagadhri',	'Jagadhri',	'Jagadhri',	1,	23284,	'2019-03-16 03:59:51',	'Jagadhri',	'Jagadhri',	'Jagadhri'),
(1269633,	103,	1264542,	'Джабалпур',	'Jabalpur',	'Jabalpur',	1,	23232,	'2019-03-16 03:59:51',	'Jabalpur',	'Jabalpur',	'Jabalpur'),
(1269655,	103,	1278341,	'Итанагар',	'Itanagar',	'Itanagar',	1,	23164,	'2019-03-16 03:59:51',	'Itanagar',	'Itanagar',	'Itanagar'),
(1269668,	103,	1264418,	'Islampur',	'Islampur',	'Islampur',	1,	23089,	'2019-03-16 03:59:51',	'Islampur',	'Islampur',	'Islampur'),
(1269693,	103,	1267254,	'Irinjalakuda',	'Irinjalakuda',	'Irinjalakuda',	1,	23004,	'2019-03-16 03:59:51',	'Irinjalakuda',	'Irinjalakuda',	'Irinjalakuda'),
(1269743,	103,	1264542,	'Индор',	'Indore',	'Indore',	1,	22881,	'2019-03-16 03:59:51',	'Indore',	'Indore',	'Indore'),
(1269771,	103,	1263706,	'Импхал',	'Imphal',	'Imphal',	1,	22833,	'2019-03-16 03:59:51',	'Imphal',	'Imphal',	'Imphal'),
(1269834,	103,	1264418,	'Ichalkaranji',	'Ichalkaranji',	'Ichalkaranji',	1,	22703,	'2019-03-16 03:59:51',	'Ichalkaranji',	'Ichalkaranji',	'Ichalkaranji'),
(1269843,	103,	1278629,	'Хайдарабад',	'Hyderabad',	'Hyderabad',	1,	22677,	'2019-03-16 03:59:51',	'Hyderabad',	'Hyderabad',	'Hyderabad'),
(1269910,	103,	1252881,	'Хугли',	'Hugli',	'Hugli',	1,	22500,	'2019-03-16 03:59:51',	'Hugli',	'Hugli',	'Hugli'),
(1269920,	103,	1267701,	'Hubli',	'Hubli',	'Hubli',	1,	22444,	'2019-03-16 03:59:51',	'Hubli',	'Hubli',	'Hubli'),
(1269934,	103,	1255053,	'Hosur',	'Hosur',	'Hosur',	1,	22335,	'2019-03-16 03:59:51',	'Hosur',	'Hosur',	'Hosur'),
(1269937,	103,	1259223,	'Hoshiarpur',	'Hoshiarpur',	'Hoshiarpur',	1,	22320,	'2019-03-16 03:59:51',	'Hoshiarpur',	'Hoshiarpur',	'Hoshiarpur'),
(1269939,	103,	1264542,	'Hoshangabad',	'Hoshangabad',	'Hoshangabad',	1,	22319,	'2019-03-16 03:59:51',	'Hoshangabad',	'Hoshangabad',	'Hoshangabad'),
(1269976,	103,	1267701,	'Honavar',	'Honavar',	'Honavar',	1,	22155,	'2019-03-16 03:59:51',	'Honavar',	'Honavar',	'Honavar'),
(1270022,	103,	1270260,	'Хисар',	'Hisar',	'Hisar',	1,	21847,	'2019-03-16 03:59:51',	'Hisar',	'Hisar',	'Hisar'),
(1270032,	103,	1267701,	'Hiriyur',	'Hiriyur',	'Hiriyur',	1,	21831,	'2019-03-16 03:59:51',	'Hiriyur',	'Hiriyur',	'Hiriyur'),
(1270077,	103,	1264418,	'Hinganghat',	'Hinganghat',	'Hinganghat',	1,	21801,	'2019-03-16 03:59:51',	'Hinganghat',	'Hinganghat',	'Hinganghat'),
(1270099,	103,	1270770,	'Himatnagar',	'Himatnagar',	'Himatnagar',	1,	21776,	'2019-03-16 03:59:51',	'Himatnagar',	'Himatnagar',	'Himatnagar'),
(1270164,	103,	1444365,	'Хазарибаг',	'Hazaribag',	'Hazaribag',	1,	21096,	'2019-03-16 03:59:51',	'Hazaribag',	'Hazaribag',	'Hazaribag'),
(1270239,	103,	1267701,	'Хасан',	'Hassan',	'Hassan',	1,	20901,	'2019-03-16 03:59:51',	'Hassan',	'Hassan',	'Hassan'),
(1270349,	103,	1267701,	'Harihar',	'Harihar',	'Harihar',	1,	20687,	'2019-03-16 03:59:51',	'Harihar',	'Harihar',	'Harihar'),
(1270351,	103,	1444366,	'Харидвар',	'Haridwar',	'Haridwar',	1,	20686,	'2019-03-16 03:59:51',	'Haridwar',	'Haridwar',	'Haridwar'),
(1270393,	103,	1253626,	'Hapur',	'Hapur',	'Hapur',	1,	20635,	'2019-03-16 03:59:51',	'Hapur',	'Hapur',	'Hapur'),
(1270396,	103,	1252881,	'Haora',	'Haora',	'Haora',	1,	20628,	'2019-03-16 03:59:51',	'Haora',	'Haora',	'Haora'),
(1270407,	103,	1258899,	'Hanumangarh',	'Hanumangarh',	'Hanumangarh',	1,	20623,	'2019-03-16 03:59:51',	'Hanumangarh',	'Hanumangarh',	'Hanumangarh'),
(1270498,	103,	1444366,	'Haldwani',	'Haldwani',	'Haldwani',	1,	20396,	'2019-03-16 03:59:51',	'Haldwani',	'Haldwani',	'Haldwani'),
(1270543,	103,	1278253,	'Haflong',	'Haflong',	'Haflong',	1,	20324,	'2019-03-16 03:59:51',	'Haflong',	'Haflong',	'Haflong'),
(1270576,	103,	1253626,	'Gyanpur',	'Gyanpur',	'Gyanpur',	1,	20271,	'2019-03-16 03:59:51',	'Gyanpur',	'Gyanpur',	'Gyanpur'),
(1270583,	103,	1264542,	'Гвалиор',	'Gwalior',	'Gwalior',	1,	20264,	'2019-03-16 03:59:51',	'Gwalior',	'Gwalior',	'Gwalior'),
(1270603,	103,	1267254,	'Guruvayur',	'Guruvayur',	'Guruvayur',	1,	20221,	'2019-03-16 03:59:51',	'Guruvayur',	'Guruvayur',	'Guruvayur'),
(1270642,	103,	1270260,	'Гургаон',	'Gurgaon',	'Gurgaon',	1,	20214,	'2019-03-16 03:59:51',	'Gurgaon',	'Gurgaon',	'Gurgaon'),
(1270647,	103,	1259223,	'Gurdaspur',	'Gurdaspur',	'Gurdaspur',	1,	20213,	'2019-03-16 03:59:51',	'Gurdaspur',	'Gurdaspur',	'Gurdaspur'),
(1270668,	103,	1278629,	'Гунтура',	'Guntur',	'Guntur',	1,	20206,	'2019-03-16 03:59:51',	'Guntur',	'Guntur',	'Guntur'),
(1270711,	103,	1264542,	'Guna',	'Guna',	'Guna',	1,	20182,	'2019-03-16 03:59:51',	'Guna',	'Guna',	'Guna'),
(1270752,	103,	1267701,	'Гульбарга',	'Gulbarga',	'Gulbarga',	1,	20167,	'2019-03-16 03:59:51',	'Gulbarga',	'Gulbarga',	'Gulbarga'),
(1270801,	103,	1278629,	'Gudivada',	'Gudivada',	'Gudivada',	1,	20055,	'2019-03-16 03:59:51',	'Gudivada',	'Gudivada',	'Gudivada'),
(1270914,	103,	1264418,	'Goregaon',	'Goregaon',	'Goregaon',	1,	19124,	'2019-03-16 03:59:51',	'Goregaon',	'Goregaon',	'Goregaon'),
(1270927,	103,	1253626,	'Горакпура',	'Gorakhpur',	'Gorakhpur',	1,	19103,	'2019-03-16 03:59:51',	'Gorakhpur',	'Gorakhpur',	'Gorakhpur'),
(1270947,	103,	1255053,	'Gobichettipalayam',	'Gobichettipalayam',	'Gobichettipalayam',	1,	18929,	'2019-03-16 03:59:51',	'Gobichettipalayam',	'Gobichettipalayam',	'Gobichettipalayam'),
(1270990,	103,	1264418,	'Гондия',	'Gondia',	'Gondia',	1,	19045,	'2019-03-16 03:59:51',	'Gondia',	'Gondia',	'Gondia'),
(1270996,	103,	1253626,	'Гонда',	'Gonda',	'Gonda',	1,	19041,	'2019-03-16 03:59:51',	'Gonda',	'Gonda',	'Gonda'),
(1271050,	103,	1278253,	'Golaghat',	'Golaghat',	'Golaghat',	1,	18975,	'2019-03-16 03:59:51',	'Golaghat',	'Golaghat',	'Golaghat'),
(1271067,	103,	1267701,	'Гокак',	'Gokak',	'Gokak',	1,	18974,	'2019-03-16 03:59:51',	'Gokak',	'Gokak',	'Gokak'),
(1271079,	103,	1270260,	'Gohana',	'Gohana',	'Gohana',	1,	18967,	'2019-03-16 03:59:51',	'Gohana',	'Gohana',	'Gohana'),
(1271107,	103,	1270770,	'Годхре',	'Godhra',	'Godhra',	1,	18947,	'2019-03-16 03:59:51',	'Godhra',	'Godhra',	'Godhra'),
(1271306,	103,	1253626,	'Ghazipur',	'Ghazipur',	'Ghazipur',	1,	18554,	'2019-03-16 03:59:51',	'Ghazipur',	'Ghazipur',	'Ghazipur'),
(1271308,	103,	1253626,	'Газиабад',	'Ghaziabad',	'Ghaziabad',	1,	18553,	'2019-03-16 03:59:51',	'Ghaziabad',	'Ghaziabad',	'Ghaziabad'),
(1271330,	103,	1264418,	'Ghatkopar',	'Ghatkopar',	'Ghatkopar',	1,	18552,	'2019-03-16 03:59:51',	'Ghatkopar',	'Ghatkopar',	'Ghatkopar'),
(1271375,	103,	1264418,	'Ghansoli',	'Ghansoli',	'Ghansoli',	1,	18551,	'2019-03-16 03:59:51',	'Ghansoli',	'Ghansoli',	'Ghansoli'),
(1271439,	103,	1275715,	'Gaya',	'Gaya',	'Gaya',	1,	18234,	'2019-03-16 03:59:51',	'Gaya',	'Gaya',	'Gaya'),
(1271476,	103,	1278253,	'Гувахати',	'Guwahati',	'Guwahati',	1,	20251,	'2019-03-16 03:59:51',	'Guwahati',	'Guwahati',	'Guwahati'),
(1271631,	103,	1256312,	'Гангток',	'Gangtok',	'Gangtok',	1,	18033,	'2019-03-16 03:59:51',	'Gangtok',	'Gangtok',	'Gangtok'),
(1271685,	103,	1258899,	'Ganganagar',	'Ganganagar',	'Ganganagar',	1,	18028,	'2019-03-16 03:59:51',	'Ganganagar',	'Ganganagar',	'Ganganagar'),
(1271714,	103,	1255053,	'Gandhi Nagar',	'Gandhi Nagar',	'Gandhi Nagar',	1,	18023,	'2019-03-16 03:59:51',	'Gandhi Nagar',	'Gandhi Nagar',	'Gandhi Nagar'),
(1271715,	103,	1270770,	'Гандинагар',	'Ghandinagar',	'Ghandinagar',	1,	18550,	'2019-03-16 03:59:51',	'Ghandinagar',	'Ghandinagar',	'Ghandinagar'),
(1271717,	103,	1270770,	'Gandhidham',	'Gandhidham',	'Gandhidham',	1,	18024,	'2019-03-16 03:59:51',	'Gandhidham',	'Gandhidham',	'Gandhidham'),
(1271850,	103,	1267701,	'Gadag',	'Gadag',	'Gadag',	1,	17869,	'2019-03-16 03:59:51',	'Gadag',	'Gadag',	'Gadag'),
(1271883,	103,	1259223,	'Firozpur',	'Firozpur',	'Firozpur',	1,	16667,	'2019-03-16 03:59:51',	'Firozpur',	'Firozpur',	'Firozpur'),
(1271885,	103,	1253626,	'Firozabad',	'Firozabad',	'Firozabad',	1,	16666,	'2019-03-16 03:59:51',	'Firozabad',	'Firozabad',	'Firozabad'),
(1271891,	103,	1259223,	'Fazilka',	'Fazilka',	'Fazilka',	1,	16393,	'2019-03-16 03:59:51',	'Fazilka',	'Fazilka',	'Fazilka'),
(1271924,	103,	1259223,	'Fatehgarh',	'Fatehgarh',	'Fatehgarh',	1,	16329,	'2019-03-16 03:59:51',	'Fatehgarh',	'Fatehgarh',	'Fatehgarh'),
(1271934,	103,	1270260,	'Fatehabad',	'Fatehabad',	'Fatehabad',	1,	16328,	'2019-03-16 03:59:51',	'Fatehabad',	'Fatehabad',	'Fatehabad'),
(1271951,	103,	1270260,	'Фаридабад',	'Faridabad',	'Faridabad',	1,	16265,	'2019-03-16 03:59:51',	'Faridabad',	'Faridabad',	'Faridabad'),
(1271954,	103,	1252881,	'Farakka',	'Farakka',	'Farakka',	1,	16247,	'2019-03-16 03:59:51',	'Farakka',	'Farakka',	'Farakka'),
(1272013,	103,	1255053,	'Брод',	'Erode',	'Erode',	1,	15605,	'2019-03-16 03:59:51',	'Erode',	'Erode',	'Erode'),
(1272018,	103,	1267254,	'Ernakulam',	'Ernakulam',	'Ernakulam',	1,	15596,	'2019-03-16 03:59:51',	'Ernakulam',	'Ernakulam',	'Ernakulam'),
(1272051,	103,	1278629,	'Eluru',	'Eluru',	'Eluru',	1,	15244,	'2019-03-16 03:59:51',	'Eluru',	'Eluru',	'Eluru'),
(1272101,	103,	1252881,	'Egra',	'Egra',	'Egra',	1,	14803,	'2019-03-16 03:59:51',	'Egra',	'Egra',	'Egra'),
(1272175,	103,	1252881,	'Дургапур',	'Durgapur',	'Durgapur',	1,	14235,	'2019-03-16 03:59:51',	'Durgapur',	'Durgapur',	'Durgapur'),
(1272181,	103,	1444364,	'Durg',	'Durg',	'Durg',	1,	14234,	'2019-03-16 03:59:51',	'Durg',	'Durg',	'Durg'),
(1272543,	103,	1255053,	'Диндуккал',	'Dindigul',	'Dindigul',	1,	13508,	'2019-03-16 03:59:51',	'Dindigul',	'Dindigul',	'Dindigul'),
(1272552,	103,	1278253,	'Димапур',	'Dimapur',	'Dimapur',	1,	13496,	'2019-03-16 03:59:51',	'Dimapur',	'Dimapur',	'Dimapur'),
(1272629,	103,	1278253,	'Digboi',	'Digboi',	'Digboi',	1,	13464,	'2019-03-16 03:59:51',	'Digboi',	'Digboi',	'Digboi'),
(1272646,	103,	1271157,	'Dicholi',	'Dicholi',	'Dicholi',	1,	13398,	'2019-03-16 03:59:51',	'Dicholi',	'Dicholi',	'Dicholi'),
(1272648,	103,	1278253,	'Дибругарх',	'Dibrugarh',	'Dibrugarh',	1,	13397,	'2019-03-16 03:59:51',	'Dibrugarh',	'Dibrugarh',	'Dibrugarh'),
(1272657,	103,	1252881,	'Diamond Harbour',	'Diamond Harbour',	'Diamond Harbour',	1,	13385,	'2019-03-16 03:59:51',	'Diamond Harbour',	'Diamond Harbour',	'Diamond Harbour'),
(1272670,	103,	1259223,	'Dhuri',	'Dhuri',	'Dhuri',	1,	13378,	'2019-03-16 03:59:51',	'Dhuri',	'Dhuri',	'Dhuri'),
(1272691,	103,	1264418,	'Дхуле',	'Dhule',	'Dhule',	1,	13377,	'2019-03-16 03:59:51',	'Dhule',	'Dhule',	'Dhule'),
(1272694,	103,	1278253,	'Dhuburi',	'Dhuburi',	'Dhuburi',	1,	13376,	'2019-03-16 03:59:51',	'Dhuburi',	'Dhuburi',	'Dhuburi'),
(1272780,	103,	1261029,	'Dhenkanal',	'Dhenkanal',	'Dhenkanal',	1,	13375,	'2019-03-16 03:59:51',	'Dhenkanal',	'Dhenkanal',	'Dhenkanal'),
(1272818,	103,	1267701,	'Dharwad',	'Dharwad',	'Dharwad',	1,	13374,	'2019-03-16 03:59:51',	'Dharwad',	'Dharwad',	'Dharwad'),
(1272832,	103,	1270101,	'Дармсала',	'Dharmsala',	'Dharmsala',	1,	13373,	'2019-03-16 03:59:51',	'Dharmsala',	'Dharmsala',	'Dharmsala'),
(1272847,	103,	1255053,	'Dharmapuri',	'Dharmapuri',	'Dharmapuri',	1,	13372,	'2019-03-16 03:59:51',	'Dharmapuri',	'Dharmapuri',	'Dharmapuri'),
(1272866,	103,	1264418,	'Dharavi',	'Dharavi',	'Dharavi',	1,	13371,	'2019-03-16 03:59:51',	'Dharavi',	'Dharavi',	'Dharavi'),
(1272873,	103,	1255053,	'Dharapuram',	'Dharapuram',	'Dharapuram',	1,	13370,	'2019-03-16 03:59:51',	'Dharapuram',	'Dharapuram',	'Dharapuram'),
(1272962,	103,	1270770,	'Dhanera',	'Dhanera',	'Dhanera',	1,	13369,	'2019-03-16 03:59:51',	'Dhanera',	'Dhanera',	'Dhanera'),
(1272979,	103,	1444365,	'Дханбад',	'Dhanbad',	'Dhanbad',	1,	13368,	'2019-03-16 03:59:51',	'Dhanbad',	'Dhanbad',	'Dhanbad'),
(1272997,	103,	1444364,	'Dhamtari',	'Dhamtari',	'Dhamtari',	1,	13367,	'2019-03-16 03:59:51',	'Dhamtari',	'Dhamtari',	'Dhamtari'),
(1273002,	103,	1253626,	'Dhampur',	'Dhampur',	'Dhampur',	1,	13366,	'2019-03-16 03:59:51',	'Dhampur',	'Dhampur',	'Dhampur'),
(1273066,	103,	1264542,	'Dewas',	'Dewas',	'Dewas',	1,	13341,	'2019-03-16 03:59:51',	'Dewas',	'Dewas',	'Dewas'),
(1273265,	103,	1253626,	'Деобанде',	'Deoband',	'Deoband',	1,	13236,	'2019-03-16 03:59:51',	'Deoband',	'Deoband',	'Deoband'),
(1273294,	103,	1273293,	'Дели',	'Delhi',	'Delhi',	1,	13127,	'2019-03-16 03:59:51',	'Delhi',	'Delhi',	'Delhi'),
(1273368,	103,	1267701,	'Davangere',	'Davangere',	'Davangere',	1,	12908,	'2019-03-16 03:59:51',	'Davangere',	'Davangere',	'Davangere'),
(1273369,	103,	1258899,	'Дауса',	'Dausa',	'Dausa',	1,	12902,	'2019-03-16 03:59:51',	'Dausa',	'Dausa',	'Dausa'),
(1273467,	103,	1252881,	'Дарджилинг',	'Darjiling',	'Darjiling',	1,	12858,	'2019-03-16 03:59:51',	'Darjiling',	'Darjiling',	'Darjiling'),
(1273618,	103,	1271155,	'Даман',	'Daman',	'Daman',	1,	12740,	'2019-03-16 03:59:51',	'Daman',	'Daman',	'Daman'),
(1273708,	103,	1264418,	'Dahanu',	'Dahanu',	'Dahanu',	1,	12666,	'2019-03-16 03:59:51',	'Dahanu',	'Dahanu',	'Dahanu'),
(1273712,	103,	1270101,	'Dagshai',	'Dagshai',	'Dagshai',	1,	12665,	'2019-03-16 03:59:51',	'Dagshai',	'Dagshai',	'Dagshai'),
(1273751,	103,	1264542,	'Dabra',	'Dabra',	'Dabra',	1,	12645,	'2019-03-16 03:59:51',	'Dabra',	'Dabra',	'Dabra'),
(1273780,	103,	1261029,	'Каттаке',	'Cuttack',	'Cuttack',	1,	12614,	'2019-03-16 03:59:51',	'Cuttack',	'Cuttack',	'Cuttack'),
(1273800,	103,	1278629,	'Cuddapah',	'Cuddapah',	'Cuddapah',	1,	12464,	'2019-03-16 03:59:51',	'Cuddapah',	'Cuddapah',	'Cuddapah'),
(1273802,	103,	1255053,	'Куддалоре',	'Cuddalore',	'Cuddalore',	1,	12463,	'2019-03-16 03:59:51',	'Cuddalore',	'Cuddalore',	'Cuddalore'),
(1273817,	103,	1271157,	'Cortalim',	'Cortalim',	'Cortalim',	1,	11789,	'2019-03-16 03:59:51',	'Cortalim',	'Cortalim',	'Cortalim'),
(1273833,	103,	1255053,	'Coonoor',	'Coonoor',	'Coonoor',	1,	11573,	'2019-03-16 03:59:51',	'Coonoor',	'Coonoor',	'Coonoor'),
(1273858,	103,	1271157,	'Калангут',	'Calangute',	'Calangute',	1,	7793,	'2019-03-16 03:59:51',	'Calangute',	'Calangute',	'Calangute'),
(1273865,	103,	1255053,	'Коимбатур',	'Coimbatore',	'Coimbatore',	1,	11078,	'2019-03-16 03:59:51',	'Coimbatore',	'Coimbatore',	'Coimbatore'),
(1273874,	103,	1267254,	'Кочин',	'Cochin',	'Cochin',	1,	11013,	'2019-03-16 03:59:51',	'Cochin',	'Cochin',	'Cochin'),
(1273909,	103,	1263706,	'Churachandpur',	'Churachandpur',	'Churachandpur',	1,	10476,	'2019-03-16 03:59:51',	'Churachandpur',	'Churachandpur',	'Churachandpur'),
(1273955,	103,	1255053,	'Chromepet',	'Chromepet',	'Chromepet',	1,	10460,	'2019-03-16 03:59:51',	'Chromepet',	'Chromepet',	'Chromepet'),
(1274032,	103,	1267254,	'Chittur',	'Chittur',	'Chittur',	1,	10397,	'2019-03-16 03:59:51',	'Chittur',	'Chittur',	'Chittur'),
(1274033,	103,	1278629,	'Читтур',	'Chittoor',	'Chittoor',	1,	10396,	'2019-03-16 03:59:51',	'Chittoor',	'Chittoor',	'Chittoor'),
(1274106,	103,	1278629,	'Chirala',	'Chirala',	'Chirala',	1,	10377,	'2019-03-16 03:59:51',	'Chirala',	'Chirala',	'Chirala'),
(1274119,	103,	1264418,	'Chiplun',	'Chiplun',	'Chiplun',	1,	10368,	'2019-03-16 03:59:51',	'Chiplun',	'Chiplun',	'Chiplun'),
(1274129,	103,	1267701,	'Чинтамани',	'Chintamani',	'Chintamani',	1,	10364,	'2019-03-16 03:59:51',	'Chintamani',	'Chintamani',	'Chintamani'),
(1274165,	103,	1264418,	'Chinchvad',	'Chinchvad',	'Chinchvad',	1,	10352,	'2019-03-16 03:59:51',	'Chinchvad',	'Chinchvad',	'Chinchvad'),
(1274256,	103,	1255053,	'Чидамбайрам',	'Chidambaram',	'Chidambaram',	1,	10302,	'2019-03-16 03:59:51',	'Chidambaram',	'Chidambaram',	'Chidambaram'),
(1274270,	103,	1271157,	'Chicalim',	'Chicalim',	'Chicalim',	1,	10289,	'2019-03-16 03:59:51',	'Chicalim',	'Chicalim',	'Chicalim'),
(1274428,	103,	1267254,	'Chengannur',	'Chengannur',	'Chengannur',	1,	10108,	'2019-03-16 03:59:51',	'Chengannur',	'Chengannur',	'Chengannur'),
(1274430,	103,	1255053,	'Chengalpattu',	'Chengalpattu',	'Chengalpattu',	1,	10107,	'2019-03-16 03:59:51',	'Chengalpattu',	'Chengalpattu',	'Chengalpattu'),
(1274641,	103,	1267701,	'Channapatna',	'Channapatna',	'Channapatna',	1,	9698,	'2019-03-16 03:59:51',	'Channapatna',	'Channapatna',	'Channapatna'),
(1274664,	103,	1267254,	'Changanacheri',	'Changanacheri',	'Changanacheri',	1,	9692,	'2019-03-16 03:59:51',	'Changanacheri',	'Changanacheri',	'Changanacheri'),
(1274693,	103,	1264418,	'Чандрапур',	'Chandrapur',	'Chandrapur',	1,	9690,	'2019-03-16 03:59:51',	'Chandrapur',	'Chandrapur',	'Chandrapur'),
(1274714,	103,	1253626,	'Chandpur',	'Chandpur',	'Chandpur',	1,	9689,	'2019-03-16 03:59:51',	'Chandpur',	'Chandpur',	'Chandpur'),
(1274746,	103,	1274744,	'Чандигарх',	'Chandigarh',	'Chandigarh',	1,	9681,	'2019-03-16 03:59:51',	'Chandigarh',	'Chandigarh',	'Chandigarh'),
(1274767,	103,	1253626,	'Chandausi',	'Chandausi',	'Chandausi',	1,	9680,	'2019-03-16 03:59:51',	'Chandausi',	'Chandausi',	'Chandausi'),
(1274770,	103,	1253626,	'Chandauli',	'Chandauli',	'Chandauli',	1,	9679,	'2019-03-16 03:59:51',	'Chandauli',	'Chandauli',	'Chandauli'),
(1274987,	103,	1267254,	'Кананорском',	'Cannanore',	'Cannanore',	1,	8221,	'2019-03-16 03:59:51',	'Cannanore',	'Cannanore',	'Cannanore'),
(1275004,	103,	1252881,	'Колката',	'Kolkata',	'Kolkata',	1,	24736,	'2019-03-16 03:59:51',	'Kolkata',	'Kolkata',	'Kolkata'),
(1275046,	103,	1252881,	'Burnpur',	'Burnpur',	'Burnpur',	1,	7475,	'2019-03-16 03:59:51',	'Burnpur',	'Burnpur',	'Burnpur'),
(1275103,	103,	1258899,	'Бунди',	'Bundi',	'Bundi',	1,	7321,	'2019-03-16 03:59:51',	'Bundi',	'Bundi',	'Bundi'),
(1275117,	103,	1264418,	'Buldana',	'Buldana',	'Buldana',	1,	7280,	'2019-03-16 03:59:51',	'Buldana',	'Buldana',	'Buldana'),
(1275120,	103,	1253626,	'Буландшахре',	'Bulandshahr',	'Bulandshahr',	1,	7279,	'2019-03-16 03:59:51',	'Bulandshahr',	'Bulandshahr',	'Bulandshahr'),
(1275198,	103,	1261029,	'Brahmapur',	'Brahmapur',	'Brahmapur',	1,	6343,	'2019-03-16 03:59:51',	'Brahmapur',	'Brahmapur',	'Brahmapur'),
(1275230,	103,	1270770,	'Borsad',	'Borsad',	'Borsad',	1,	5967,	'2019-03-16 03:59:51',	'Borsad',	'Borsad',	'Borsad'),
(1275321,	103,	1278253,	'Bongaigaon',	'Bongaigaon',	'Bongaigaon',	1,	5779,	'2019-03-16 03:59:51',	'Bongaigaon',	'Bongaigaon',	'Bongaigaon'),
(1275339,	103,	1264418,	'Мумбаи',	'Mumbai',	'Mumbai',	1,	33282,	'2019-03-16 03:59:51',	'Mumbai',	'Mumbai',	'Mumbai'),
(1275346,	103,	1252881,	'Bolpur',	'Bolpur',	'Bolpur',	1,	5727,	'2019-03-16 03:59:51',	'Bolpur',	'Bolpur',	'Bolpur'),
(1275362,	103,	1444365,	'Бокаро',	'Bokaro',	'Bokaro',	1,	5684,	'2019-03-16 03:59:51',	'Bokaro',	'Bokaro',	'Bokaro'),
(1275368,	103,	1264418,	'Boisar',	'Boisar',	'Boisar',	1,	5651,	'2019-03-16 03:59:51',	'Boisar',	'Boisar',	'Boisar'),
(1275552,	103,	1252881,	'Binnaguri',	'Binnaguri',	'Binnaguri',	1,	5066,	'2019-03-16 03:59:51',	'Binnaguri',	'Binnaguri',	'Binnaguri'),
(1275610,	103,	1270770,	'Bilimora',	'Bilimora',	'Bilimora',	1,	5009,	'2019-03-16 03:59:51',	'Bilimora',	'Bilimora',	'Bilimora'),
(1275631,	103,	1270101,	'Bilaspur',	'Bilaspur',	'Bilaspur',	1,	5002,	'2019-03-16 03:59:51',	'Bilaspur',	'Bilaspur',	'Bilaspur'),
(1275637,	103,	1444364,	'Биласпура',	'Bilaspur',	'Bilaspur',	1,	5003,	'2019-03-16 03:59:51',	'Bilaspur',	'Bilaspur',	'Bilaspur'),
(1275665,	103,	1258899,	'Биканер',	'Bikaner',	'Bikaner',	1,	5000,	'2019-03-16 03:59:51',	'Bikaner',	'Bikaner',	'Bikaner'),
(1275701,	103,	1267701,	'Биджапур',	'Bijapur',	'Bijapur',	1,	4999,	'2019-03-16 03:59:51',	'Bijapur',	'Bijapur',	'Bijapur'),
(1275716,	103,	1275715,	'Bihar Sharif',	'Bihar Sharif',	'Bihar Sharif',	1,	4997,	'2019-03-16 03:59:51',	'Bihar Sharif',	'Bihar Sharif',	'Bihar Sharif'),
(1275738,	103,	1267701,	'Бидар',	'Bidar',	'Bidar',	1,	4905,	'2019-03-16 03:59:51',	'Bidar',	'Bidar',	'Bidar'),
(1275778,	103,	1264418,	'Bhusawal',	'Bhusawal',	'Bhusawal',	1,	4870,	'2019-03-16 03:59:51',	'Bhusawal',	'Bhusawal',	'Bhusawal'),
(1275812,	103,	1270770,	'Bhuj',	'Bhuj',	'Bhuj',	1,	4869,	'2019-03-16 03:59:51',	'Bhuj',	'Bhuj',	'Bhuj'),
(1275817,	103,	1261029,	'Бхубанешвар',	'Bhubaneshwar',	'Bhubaneshwar',	1,	4868,	'2019-03-16 03:59:51',	'Bhubaneshwar',	'Bhubaneshwar',	'Bhubaneshwar'),
(1275841,	103,	1264542,	'Бхопал',	'Bhopal',	'Bhopal',	1,	4867,	'2019-03-16 03:59:51',	'Bhopal',	'Bhopal',	'Bhopal'),
(1275848,	103,	1278629,	'Bhongir',	'Bhongir',	'Bhongir',	1,	4866,	'2019-03-16 03:59:51',	'Bhongir',	'Bhongir',	'Bhongir'),
(1275899,	103,	1270260,	'Bhiwani',	'Bhiwani',	'Bhiwani',	1,	4865,	'2019-03-16 03:59:51',	'Bhiwani',	'Bhiwani',	'Bhiwani'),
(1275901,	103,	1264418,	'Bhiwandi',	'Bhiwandi',	'Bhiwandi',	1,	4864,	'2019-03-16 03:59:51',	'Bhiwandi',	'Bhiwandi',	'Bhiwandi'),
(1275947,	103,	1278629,	'Bhimavaram',	'Bhimavaram',	'Bhimavaram',	1,	4863,	'2019-03-16 03:59:51',	'Bhimavaram',	'Bhimavaram',	'Bhimavaram'),
(1275960,	103,	1258899,	'Bhilwara',	'Bhilwara',	'Bhilwara',	1,	4862,	'2019-03-16 03:59:51',	'Bhilwara',	'Bhilwara',	'Bhilwara'),
(1275971,	103,	1444364,	'Бхилаи',	'Bhilai',	'Bhilai',	1,	4861,	'2019-03-16 03:59:51',	'Bhilai',	'Bhilai',	'Bhilai'),
(1276032,	103,	1270770,	'Бхавнагаром',	'Bhavnagar',	'Bhavnagar',	1,	4860,	'2019-03-16 03:59:51',	'Bhavnagar',	'Bhavnagar',	'Bhavnagar'),
(1276067,	103,	1267701,	'Bhatkal',	'Bhatkal',	'Bhatkal',	1,	4859,	'2019-03-16 03:59:51',	'Bhatkal',	'Bhatkal',	'Bhatkal'),
(1276070,	103,	1259223,	'Bhatinda',	'Bhatinda',	'Bhatinda',	1,	4858,	'2019-03-16 03:59:51',	'Bhatinda',	'Bhatinda',	'Bhatinda'),
(1276100,	103,	1270770,	'Bharuch',	'Bharuch',	'Bharuch',	1,	4857,	'2019-03-16 03:59:51',	'Bharuch',	'Bharuch',	'Bharuch'),
(1276174,	103,	1264418,	'Bhandup',	'Bhandup',	'Bhandup',	1,	4856,	'2019-03-16 03:59:51',	'Bhandup',	'Bhandup',	'Bhandup'),
(1276300,	103,	1275715,	'Bhagalpur',	'Bhagalpur',	'Bhagalpur',	1,	4855,	'2019-03-16 03:59:51',	'Bhagalpur',	'Bhagalpur',	'Bhagalpur'),
(1276320,	103,	1252881,	'Bhadreswar',	'Bhadreswar',	'Bhadreswar',	1,	4854,	'2019-03-16 03:59:51',	'Bhadreswar',	'Bhadreswar',	'Bhadreswar'),
(1276321,	103,	1267701,	'Bhadravati',	'Bhadravati',	'Bhadravati',	1,	4853,	'2019-03-16 03:59:51',	'Bhadravati',	'Bhadravati',	'Bhadravati'),
(1276328,	103,	1278629,	'Bhadrachalam',	'Bhadrachalam',	'Bhadrachalam',	1,	4852,	'2019-03-16 03:59:51',	'Bhadrachalam',	'Bhadrachalam',	'Bhadrachalam'),
(1276335,	103,	1253626,	'Bhadohi',	'Bhadohi',	'Bhadohi',	1,	4851,	'2019-03-16 03:59:51',	'Bhadohi',	'Bhadohi',	'Bhadohi'),
(1276403,	103,	1271157,	'Betim',	'Betim',	'Betim',	1,	4763,	'2019-03-16 03:59:51',	'Betim',	'Betim',	'Betim'),
(1276416,	103,	1278629,	'Betamcherla',	'Betamcherla',	'Betamcherla',	1,	4718,	'2019-03-16 03:59:51',	'Betamcherla',	'Betamcherla',	'Betamcherla'),
(1276472,	103,	1271157,	'Бенаулим',	'Benaulim',	'Benaulim',	1,	4344,	'2019-03-16 03:59:51',	'Benaulim',	'Benaulim',	'Benaulim'),
(1276509,	103,	1267701,	'Беллари',	'Bellary',	'Bellary',	1,	4158,	'2019-03-16 03:59:51',	'Bellary',	'Bellary',	'Bellary'),
(1276532,	103,	1252881,	'Belgharia',	'Belgharia',	'Belgharia',	1,	4121,	'2019-03-16 03:59:51',	'Belgharia',	'Belgharia',	'Belgharia'),
(1276533,	103,	1267701,	'Белгаум',	'Belgaum',	'Belgaum',	1,	4117,	'2019-03-16 03:59:51',	'Belgaum',	'Belgaum',	'Belgaum'),
(1276607,	103,	1252881,	'Behala',	'Behala',	'Behala',	1,	4063,	'2019-03-16 03:59:51',	'Behala',	'Behala',	'Behala'),
(1276609,	103,	1275715,	'Begusarai',	'Begusarai',	'Begusarai',	1,	4061,	'2019-03-16 03:59:51',	'Begusarai',	'Begusarai',	'Begusarai'),
(1276634,	103,	1258899,	'Beawar',	'Beawar',	'Beawar',	1,	3962,	'2019-03-16 03:59:51',	'Beawar',	'Beawar',	'Beawar'),
(1276720,	103,	1259223,	'Batala',	'Batala',	'Batala',	1,	3635,	'2019-03-16 03:59:51',	'Batala',	'Batala',	'Batala'),
(1276759,	103,	1252881,	'Basirhat',	'Basirhat',	'Basirhat',	1,	3595,	'2019-03-16 03:59:51',	'Basirhat',	'Basirhat',	'Basirhat'),
(1276765,	103,	1259223,	'Basi',	'Basi',	'Basi',	1,	3589,	'2019-03-16 03:59:51',	'Basi',	'Basi',	'Basi'),
(1276870,	103,	1261029,	'Barpali',	'Barpali',	'Barpali',	1,	3501,	'2019-03-16 03:59:51',	'Barpali',	'Barpali',	'Barpali'),
(1276885,	103,	1264542,	'Baroda',	'Baroda',	'Baroda',	1,	3496,	'2019-03-16 03:59:51',	'Baroda',	'Baroda',	'Baroda'),
(1276895,	103,	1259223,	'Барнала',	'Barnala',	'Barnala',	1,	3460,	'2019-03-16 03:59:51',	'Barnala',	'Barnala',	'Barnala'),
(1276901,	103,	1258899,	'Barmer',	'Barmer',	'Barmer',	1,	3457,	'2019-03-16 03:59:51',	'Barmer',	'Barmer',	'Barmer'),
(1277013,	103,	1253626,	'Барейли',	'Bareilly',	'Bareilly',	1,	3406,	'2019-03-16 03:59:51',	'Bareilly',	'Bareilly',	'Bareilly'),
(1277022,	103,	1270770,	'Бардоли',	'Bardoli',	'Bardoli',	1,	3397,	'2019-03-16 03:59:51',	'Bardoli',	'Bardoli',	'Bardoli'),
(1277029,	103,	1252881,	'Barddhaman',	'Barddhaman',	'Barddhaman',	1,	3394,	'2019-03-16 03:59:51',	'Barddhaman',	'Barddhaman',	'Barddhaman'),
(1277044,	103,	1253626,	'Baraut',	'Baraut',	'Baraut',	1,	3358,	'2019-03-16 03:59:51',	'Baraut',	'Baraut',	'Baraut'),
(1277091,	103,	1264418,	'Барамати',	'Baramati',	'Baramati',	1,	3348,	'2019-03-16 03:59:51',	'Baramati',	'Baramati',	'Baramati'),
(1277100,	103,	1252881,	'Barakpur',	'Barakpur',	'Barakpur',	1,	3346,	'2019-03-16 03:59:51',	'Barakpur',	'Barakpur',	'Barakpur'),
(1277264,	103,	1252881,	'Банкура',	'Bankura',	'Bankura',	1,	3306,	'2019-03-16 03:59:51',	'Bankura',	'Bankura',	'Bankura'),
(1277289,	103,	1275715,	'Banka',	'Banka',	'Banka',	1,	3302,	'2019-03-16 03:59:51',	'Banka',	'Banka',	'Banka'),
(1277324,	103,	1252881,	'Бангаон',	'Bangaon',	'Bangaon',	1,	3291,	'2019-03-16 03:59:51',	'Bangaon',	'Bangaon',	'Bangaon'),
(1277333,	103,	1267701,	'Бангалор',	'Bangalore',	'Bangalore',	1,	3290,	'2019-03-16 03:59:51',	'Bangalore',	'Bangalore',	'Bangalore'),
(1277338,	103,	1259223,	'Banga',	'Banga',	'Banga',	1,	3289,	'2019-03-16 03:59:51',	'Banga',	'Banga',	'Banga'),
(1277551,	103,	1275715,	'Ballia',	'Ballia',	'Ballia',	1,	3223,	'2019-03-16 03:59:51',	'Ballia',	'Ballia',	'Ballia'),
(1277599,	103,	1261029,	'Баласор',	'Balasore',	'Balasore',	1,	3170,	'2019-03-16 03:59:51',	'Balasore',	'Balasore',	'Balasore'),
(1277636,	103,	1264418,	'Balapur',	'Balapur',	'Balapur',	1,	3166,	'2019-03-16 03:59:51',	'Balapur',	'Balapur',	'Balapur'),
(1277769,	103,	1444364,	'Baikunthpur',	'Baikunthpur',	'Baikunthpur',	1,	3103,	'2019-03-16 03:59:51',	'Baikunthpur',	'Baikunthpur',	'Baikunthpur'),
(1277820,	103,	1252881,	'Baharampur',	'Baharampur',	'Baharampur',	1,	3088,	'2019-03-16 03:59:51',	'Baharampur',	'Baharampur',	'Baharampur'),
(1277835,	103,	1270260,	'Bahadurgarh',	'Bahadurgarh',	'Bahadurgarh',	1,	3086,	'2019-03-16 03:59:51',	'Bahadurgarh',	'Bahadurgarh',	'Bahadurgarh'),
(1277976,	103,	1264418,	'Badlapur',	'Badlapur',	'Badlapur',	1,	3028,	'2019-03-16 03:59:51',	'Badlapur',	'Badlapur',	'Badlapur'),
(1278122,	103,	1278629,	'Avanigadda',	'Avanigadda',	'Avanigadda',	1,	2679,	'2019-03-16 03:59:51',	'Avanigadda',	'Avanigadda',	'Avanigadda'),
(1278149,	103,	1264418,	'Аурангабад',	'Aurangabad',	'Aurangabad',	1,	2570,	'2019-03-16 03:59:51',	'Aurangabad',	'Aurangabad',	'Aurangabad'),
(1278176,	103,	1267254,	'Attingal',	'Attingal',	'Attingal',	1,	2389,	'2019-03-16 03:59:51',	'Attingal',	'Attingal',	'Attingal'),
(1278204,	103,	1255053,	'Adirampattinam',	'Adirampattinam',	'Adirampattinam',	1,	246,	'2019-03-16 03:59:51',	'Adirampattinam',	'Adirampattinam',	'Adirampattinam'),
(1278254,	103,	1271157,	'Assagao',	'Assagao',	'Assagao',	1,	2260,	'2019-03-16 03:59:51',	'Assagao',	'Assagao',	'Assagao'),
(1278314,	103,	1252881,	'Асансол',	'Asansol',	'Asansol',	1,	2121,	'2019-03-16 03:59:51',	'Asansol',	'Asansol',	'Asansol'),
(1278405,	103,	1255053,	'Ariyalur',	'Ariyalur',	'Ariyalur',	1,	1893,	'2019-03-16 03:59:51',	'Ariyalur',	'Ariyalur',	'Ariyalur'),
(1278454,	103,	1255053,	'Arani',	'Arani',	'Arani',	1,	1712,	'2019-03-16 03:59:51',	'Arani',	'Arani',	'Arani'),
(1278466,	103,	1252881,	'Arambagh',	'Arambagh',	'Arambagh',	1,	1706,	'2019-03-16 03:59:51',	'Arambagh',	'Arambagh',	'Arambagh'),
(1278551,	103,	1267701,	'Ankola',	'Ankola',	'Ankola',	1,	1496,	'2019-03-16 03:59:51',	'Ankola',	'Ankola',	'Ankola'),
(1278553,	103,	1270770,	'Ankleshwar',	'Ankleshwar',	'Ankleshwar',	1,	1495,	'2019-03-16 03:59:51',	'Ankleshwar',	'Ankleshwar',	'Ankleshwar'),
(1278573,	103,	1270770,	'Анджаром',	'Anjar',	'Anjar',	1,	1487,	'2019-03-16 03:59:51',	'Anjar',	'Anjar',	'Anjar'),
(1278593,	103,	1261029,	'Angul',	'Angul',	'Angul',	1,	1475,	'2019-03-16 03:59:51',	'Angul',	'Angul',	'Angul'),
(1278618,	103,	1278629,	'Andra',	'Andra',	'Andra',	1,	1407,	'2019-03-16 03:59:51',	'Andra',	'Andra',	'Andra'),
(1278633,	103,	1264418,	'Andheri',	'Andheri',	'Andheri',	1,	1383,	'2019-03-16 03:59:51',	'Andheri',	'Andheri',	'Andheri'),
(1278667,	103,	1269320,	'Anantnag',	'Anantnag',	'Anantnag',	1,	1336,	'2019-03-16 03:59:51',	'Anantnag',	'Anantnag',	'Anantnag'),
(1278672,	103,	1278629,	'Анантапуре',	'Anantapur',	'Anantapur',	1,	1335,	'2019-03-16 03:59:51',	'Anantapur',	'Anantapur',	'Anantapur'),
(1278676,	103,	1259223,	'Anandpur Sahib',	'Anandpur Sahib',	'Anandpur Sahib',	1,	1334,	'2019-03-16 03:59:51',	'Anandpur Sahib',	'Anandpur Sahib',	'Anandpur Sahib'),
(1278685,	103,	1270770,	'Ананд',	'Anand',	'Anand',	1,	1333,	'2019-03-16 03:59:51',	'Anand',	'Anand',	'Anand'),
(1278710,	103,	1259223,	'Амритсар',	'Amritsar',	'Amritsar',	1,	1311,	'2019-03-16 03:59:51',	'Amritsar',	'Amritsar',	'Amritsar'),
(1278715,	103,	1270770,	'Amreli',	'Amreli',	'Amreli',	1,	1310,	'2019-03-16 03:59:51',	'Amreli',	'Amreli',	'Amreli'),
(1278718,	103,	1264418,	'Amravati',	'Amravati',	'Amravati',	1,	1309,	'2019-03-16 03:59:51',	'Amravati',	'Amravati',	'Amravati'),
(1278758,	103,	1259223,	'Amloh',	'Amloh',	'Amloh',	1,	1282,	'2019-03-16 03:59:51',	'Amloh',	'Amloh',	'Amloh'),
(1278805,	103,	1253626,	'Amethi',	'Amethi',	'Amethi',	1,	1256,	'2019-03-16 03:59:51',	'Amethi',	'Amethi',	'Amethi'),
(1278815,	103,	1255053,	'Ambur',	'Ambur',	'Ambur',	1,	1226,	'2019-03-16 03:59:51',	'Ambur',	'Ambur',	'Ambur'),
(1278860,	103,	1270260,	'Ambala',	'Ambala',	'Ambala',	1,	1198,	'2019-03-16 03:59:51',	'Ambala',	'Ambala',	'Ambala'),
(1278862,	103,	1264418,	'Ambajogai',	'Ambajogai',	'Ambajogai',	1,	1197,	'2019-03-16 03:59:51',	'Ambajogai',	'Ambajogai',	'Ambajogai'),
(1278882,	103,	1270101,	'Amb',	'Amb',	'Amb',	1,	1195,	'2019-03-16 03:59:51',	'Amb',	'Amb',	'Amb'),
(1278924,	103,	1278629,	'Amangal',	'Amangal',	'Amangal',	1,	1183,	'2019-03-16 03:59:51',	'Amangal',	'Amangal',	'Amangal'),
(1278935,	103,	1278629,	'Amalapuram',	'Amalapuram',	'Amalapuram',	1,	1175,	'2019-03-16 03:59:51',	'Amalapuram',	'Amalapuram',	'Amalapuram'),
(1278941,	103,	1267254,	'Aluva',	'Aluva',	'Aluva',	1,	1143,	'2019-03-16 03:59:51',	'Aluva',	'Aluva',	'Aluva'),
(1278946,	103,	1258899,	'Алвар',	'Alwar',	'Alwar',	1,	1161,	'2019-03-16 03:59:51',	'Alwar',	'Alwar',	'Alwar'),
(1278974,	103,	1444366,	'Альмора',	'Almora',	'Almora',	1,	938,	'2019-03-16 03:59:51',	'Almora',	'Almora',	'Almora'),
(1278985,	103,	1267254,	'Алаппужа',	'Alleppey',	'Alleppey',	1,	854,	'2019-03-16 03:59:51',	'Alleppey',	'Alleppey',	'Alleppey'),
(1278994,	103,	1253626,	'Аллахабад',	'Allahabad',	'Allahabad',	1,	808,	'2019-03-16 03:59:51',	'Allahabad',	'Allahabad',	'Allahabad'),
(1279017,	103,	1253626,	'Алигарх',	'Aligarh',	'Aligarh',	1,	794,	'2019-03-16 03:59:51',	'Aligarh',	'Aligarh',	'Aligarh'),
(1279027,	103,	1264418,	'Alibag',	'Alibag',	'Alibag',	1,	786,	'2019-03-16 03:59:51',	'Alibag',	'Alibag',	'Alibag'),
(1279069,	103,	1267254,	'Alanallur',	'Alanallur',	'Alanallur',	1,	504,	'2019-03-16 03:59:51',	'Alanallur',	'Alanallur',	'Alanallur'),
(1279105,	103,	1264418,	'Акола',	'Akola',	'Akola',	1,	461,	'2019-03-16 03:59:51',	'Akola',	'Akola',	'Akola'),
(1279123,	103,	1278629,	'Akividu',	'Akividu',	'Akividu',	1,	460,	'2019-03-16 03:59:51',	'Akividu',	'Akividu',	'Akividu'),
(1279159,	103,	1258899,	'Аджмер',	'Ajmer',	'Ajmer',	1,	450,	'2019-03-16 03:59:51',	'Ajmer',	'Ajmer',	'Ajmer'),
(1279186,	103,	1262963,	'Аиджал',	'Aizawl',	'Aizawl',	1,	445,	'2019-03-16 03:59:51',	'Aizawl',	'Aizawl',	'Aizawl'),
(1279228,	103,	1264418,	'Ahmadnagar',	'Ahmadnagar',	'Ahmadnagar',	1,	346,	'2019-03-16 03:59:51',	'Ahmadnagar',	'Ahmadnagar',	'Ahmadnagar'),
(1279233,	103,	1270770,	'Ахмадабад',	'Ahmedabad',	'Ahmedabad',	1,	347,	'2019-03-16 03:59:51',	'Ahmedabad',	'Ahmedabad',	'Ahmedabad'),
(1279259,	103,	1253626,	'Агра',	'Agra',	'Agra',	1,	316,	'2019-03-16 03:59:51',	'Agra',	'Agra',	'Agra'),
(1279290,	103,	1254169,	'Агартала',	'Agartala',	'Agartala',	1,	288,	'2019-03-16 03:59:51',	'Agartala',	'Agartala',	'Agartala'),
(1279390,	103,	1264418,	'Achalpur',	'Achalpur',	'Achalpur',	1,	128,	'2019-03-16 03:59:51',	'Achalpur',	'Achalpur',	'Achalpur'),
(1344069,	103,	1252881,	'Contai',	'Contai',	'Contai',	1,	11522,	'2019-03-16 03:59:51',	'Contai',	'Contai',	'Contai'),
(1344377,	103,	1252881,	'Haldia',	'Haldia',	'Haldia',	1,	20395,	'2019-03-16 03:59:51',	'Haldia',	'Haldia',	'Haldia'),
(1348982,	103,	1252881,	'Chakdaha',	'Chakdaha',	'Chakdaha',	1,	9531,	'2019-03-16 03:59:51',	'Chakdaha',	'Chakdaha',	'Chakdaha'),
(1430095,	103,	1269320,	'Gold',	'Gold',	'Gold',	1,	18980,	'2019-03-16 03:59:51',	'Gold',	'Gold',	'Gold'),
(1432442,	103,	1269320,	'Kundan',	'Kundan',	'Kundan',	1,	25019,	'2019-03-16 03:59:51',	'Kundan',	'Kundan',	'Kundan'),
(1436716,	103,	1270260,	'Haryana',	'Haryana',	'Haryana',	1,	20870,	'2019-03-16 03:59:51',	'Haryana',	'Haryana',	'Haryana'),
(1440736,	103,	1444366,	'Mill',	'Mill',	'Mill',	1,	31387,	'2019-03-16 03:59:51',	'Mill',	'Mill',	'Mill'),
(1444497,	103,	1444366,	'Pat',	'Pat',	'Pat',	1,	37040,	'2019-03-16 03:59:51',	'Pat',	'Pat',	'Pat'),
(1445322,	103,	1278629,	'Madhapur',	'Madhapur',	'Madhapur',	1,	29069,	'2019-03-16 03:59:51',	'Madhapur',	'Madhapur',	'Madhapur'),
(1465594,	103,	1255053,	'Madhavaram',	'Madhavaram',	'Madhavaram',	1,	29070,	'2019-03-16 03:59:51',	'Madhavaram',	'Madhavaram',	'Madhavaram'),
(1465802,	103,	1255053,	'Anna Nagar',	'Anna Nagar',	'Anna Nagar',	1,	1507,	'2019-03-16 03:59:51',	'Anna Nagar',	'Anna Nagar',	'Anna Nagar'),
(1465828,	103,	1255053,	'Perungudi',	'Perungudi',	'Perungudi',	1,	37528,	'2019-03-16 03:59:51',	'Perungudi',	'Perungudi',	'Perungudi'),
(1465856,	103,	1255053,	'Siruseri',	'Siruseri',	'Siruseri',	1,	46431,	'2019-03-16 03:59:51',	'Siruseri',	'Siruseri',	'Siruseri'),
(1466023,	103,	1255053,	'Ambattur',	'Ambattur',	'Ambattur',	1,	1199,	'2019-03-16 03:59:51',	'Ambattur',	'Ambattur',	'Ambattur'),
(1485439,	185,	1511732,	'Заринск',	'Zarinsk',	'Zarinsk',	1,	55056,	'2019-03-16 03:59:51',	'Zarinsk',	'Zarinsk',	'Zarinsk'),
(1485634,	185,	1508290,	'Южноуральск',	'Yuzhnoural\'sk',	'Yuzhnoural\'sk',	1,	55005,	'2019-03-16 03:59:51',	'Yuzhnoural\'sk',	'Yuzhnoural\'sk',	'Yuzhnoural\'sk'),
(1485724,	185,	1503900,	'Юрга',	'Yurga',	'Yurga',	1,	54999,	'2019-03-16 03:59:51',	'Yurga',	'Yurga',	'Yurga'),
(1486039,	185,	1508290,	'Еманжелинск',	'Yemanzhelinsk',	'Yemanzhelinsk',	1,	54917,	'2019-03-16 03:59:51',	'Yemanzhelinsk',	'Yemanzhelinsk',	'Yemanzhelinsk'),
(1486209,	185,	1490542,	'Екатеринбург',	'Yekaterinburg',	'Yekaterinburg',	1,	54906,	'2019-03-16 03:59:51',	'Yekaterinburg',	'Yekaterinburg',	'Yekaterinburg'),
(1486910,	185,	545854,	'Воркута',	'Vorkuta',	'Vorkuta',	1,	52314,	'2019-03-16 03:59:51',	'Vorkuta',	'Vorkuta',	'Vorkuta'),
(1487219,	185,	1490542,	'Verkhotur\'ye',	'Verkhotur\'ye',	'Verkhotur\'ye',	1,	51258,	'2019-03-16 03:59:51',	'Verkhotur\'ye',	'Verkhotur\'ye',	'Verkhotur\'ye'),
(1487277,	185,	1490542,	'Верхняя Салда',	'Verkhnyaya Salda',	'Verkhnyaya Salda',	1,	51257,	'2019-03-16 03:59:51',	'Verkhnyaya Salda',	'Verkhnyaya Salda',	'Verkhnyaya Salda'),
(1487281,	185,	1490542,	'Верхняя Пышма',	'Verkhnyaya Pyshma',	'Verkhnyaya Pyshma',	1,	51256,	'2019-03-16 03:59:51',	'Verkhnyaya Pyshma',	'Verkhnyaya Pyshma',	'Verkhnyaya Pyshma'),
(1487394,	185,	1508290,	'Верхний Уфалей',	'Verkhniy Ufaley',	'Verkhniy Ufaley',	1,	51255,	'2019-03-16 03:59:51',	'Verkhniy Ufaley',	'Verkhniy Ufaley',	'Verkhniy Ufaley'),
(1487933,	185,	1508290,	'Увельский',	'Uvel\'skiy',	'Uvel\'skiy',	1,	50599,	'2019-03-16 03:59:51',	'Uvel\'skiy',	'Uvel\'skiy',	'Uvel\'skiy'),
(1488253,	185,	1502020,	'Зеленогорск',	'Zelenogorsk',	'Zelenogorsk',	1,	55087,	'2019-03-16 03:59:51',	'Zelenogorsk',	'Zelenogorsk',	'Zelenogorsk'),
(1488429,	185,	1503773,	'Урай',	'Uray',	'Uray',	1,	50496,	'2019-03-16 03:59:51',	'Uray',	'Uray',	'Uray'),
(1488754,	185,	1488747,	'Тюмень',	'Tyumen',	'Tyumen',	1,	50226,	'2019-03-16 03:59:51',	'Tyumen',	'Tyumen',	'Tyumen'),
(1489246,	185,	1508290,	'Троицк',	'Troitsk',	'Troitsk',	1,	49977,	'2019-03-16 03:59:51',	'Troitsk',	'Troitsk',	'Troitsk'),
(1489394,	185,	1503900,	'Топки',	'Topki',	'Topki',	1,	49424,	'2019-03-16 03:59:51',	'Topki',	'Topki',	'Topki'),
(1489425,	185,	1489421,	'Томск',	'Tomsk',	'Tomsk',	1,	49387,	'2019-03-16 03:59:51',	'Tomsk',	'Tomsk',	'Tomsk'),
(1489530,	185,	1488747,	'Тобольск',	'Tobol\'sk',	'Tobol\'sk',	1,	49321,	'2019-03-16 03:59:51',	'Tobol\'sk',	'Tobol\'sk',	'Tobol\'sk'),
(1489870,	185,	2023468,	'Тайшет',	'Tayshet',	'Tayshet',	1,	48684,	'2019-03-16 03:59:51',	'Tayshet',	'Tayshet',	'Tayshet'),
(1489907,	185,	1503900,	'Тайга',	'Tayga',	'Tayga',	1,	48665,	'2019-03-16 03:59:51',	'Tayga',	'Tayga',	'Tayga'),
(1490042,	185,	1503900,	'Таштагол',	'Tashtagol',	'Tashtagol',	1,	48602,	'2019-03-16 03:59:51',	'Tashtagol',	'Tashtagol',	'Tashtagol'),
(1490085,	185,	1486462,	'Тарко-сале',	'Tarko-Sale',	'Tarko-Sale',	1,	48575,	'2019-03-16 03:59:51',	'Tarko-Sale',	'Tarko-Sale',	'Tarko-Sale'),
(1490402,	185,	1490542,	'Сысерть',	'Sysert\'',	'Sysert\'',	1,	48383,	'2019-03-16 03:59:51',	'Sysert\'',	'Sysert\'',	'Sysert\''),
(1490624,	185,	1503773,	'Сургут',	'Surgut',	'Surgut',	1,	48226,	'2019-03-16 03:59:51',	'Surgut',	'Surgut',	'Surgut'),
(1490686,	185,	1490542,	'Сухой Лог',	'Sukhoy Log',	'Sukhoy Log',	1,	48059,	'2019-03-16 03:59:51',	'Sukhoy Log',	'Sukhoy Log',	'Sukhoy Log'),
(1490796,	185,	1489421,	'Стрежевой',	'Strezhevoy',	'Strezhevoy',	1,	47924,	'2019-03-16 03:59:51',	'Strezhevoy',	'Strezhevoy',	'Strezhevoy'),
(1491999,	185,	1501312,	'Шумиха',	'Shumikha',	'Shumikha',	1,	46192,	'2019-03-16 03:59:51',	'Shumikha',	'Shumikha',	'Shumikha'),
(1492252,	185,	1503900,	'Шерегеш',	'Sheregesh',	'Sheregesh',	1,	46082,	'2019-03-16 03:59:51',	'Sheregesh',	'Sheregesh',	'Sheregesh'),
(1492401,	185,	1502020,	'Шарыпово',	'Sharypovo',	'Sharypovo',	1,	45988,	'2019-03-16 03:59:51',	'Sharypovo',	'Sharypovo',	'Sharypovo'),
(1492517,	185,	1501312,	'Шадринск',	'Shadrinsk',	'Shadrinsk',	1,	45924,	'2019-03-16 03:59:51',	'Shadrinsk',	'Shadrinsk',	'Shadrinsk'),
(1492663,	185,	1490542,	'Серов',	'Serov',	'Serov',	1,	45784,	'2019-03-16 03:59:51',	'Serov',	'Serov',	'Serov'),
(1492893,	185,	1503834,	'Саяногорск',	'Sayanogorsk',	'Sayanogorsk',	1,	44937,	'2019-03-16 03:59:51',	'Sayanogorsk',	'Sayanogorsk',	'Sayanogorsk'),
(1493162,	185,	1503773,	'Салым',	'Salym',	'Salym',	1,	43892,	'2019-03-16 03:59:51',	'Salym',	'Salym',	'Salym'),
(1493197,	185,	1486462,	'Салехард',	'Salekhard',	'Salekhard',	1,	43745,	'2019-03-16 03:59:51',	'Salekhard',	'Salekhard',	'Salekhard'),
(1493467,	185,	1511732,	'Рубцовск',	'Rubtsovsk',	'Rubtsovsk',	1,	41934,	'2019-03-16 03:59:51',	'Rubtsovsk',	'Rubtsovsk',	'Rubtsovsk'),
(1494114,	185,	1503900,	'Прокопьевск',	'Prokop\'yevsk',	'Prokop\'yevsk',	1,	39408,	'2019-03-16 03:59:51',	'Prokop\'yevsk',	'Prokop\'yevsk',	'Prokop\'yevsk'),
(1494276,	185,	1503773,	'Пойковский',	'Poykovskiy',	'Poykovskiy',	1,	39141,	'2019-03-16 03:59:51',	'Poykovskiy',	'Poykovskiy',	'Poykovskiy'),
(1494573,	185,	1490542,	'Полевской',	'Polevskoy',	'Polevskoy',	1,	38531,	'2019-03-16 03:59:51',	'Polevskoy',	'Polevskoy',	'Polevskoy'),
(1496153,	185,	1496152,	'Омск',	'Omsk',	'Omsk',	1,	35910,	'2019-03-16 03:59:51',	'Omsk',	'Omsk',	'Omsk'),
(1496398,	185,	1496745,	'Приобский',	'Priobskiy',	'Priobskiy',	1,	39380,	'2019-03-16 03:59:51',	'Priobskiy',	'Priobskiy',	'Priobskiy'),
(1496476,	185,	1503773,	'Нягань',	'Nyagan',	'Nyagan',	1,	35273,	'2019-03-16 03:59:51',	'Nyagan',	'Nyagan',	'Nyagan'),
(1496503,	185,	1486462,	'Ноябрьск',	'Noyabrsk',	'Noyabrsk',	1,	35201,	'2019-03-16 03:59:51',	'Noyabrsk',	'Noyabrsk',	'Noyabrsk'),
(1496511,	185,	1486462,	'Новый Уренгой',	'Novyy Urengoy',	'Novyy Urengoy',	1,	35196,	'2019-03-16 03:59:51',	'Novyy Urengoy',	'Novyy Urengoy',	'Novyy Urengoy'),
(1496747,	185,	1496745,	'Новосибирск',	'Novosibirsk',	'Novosibirsk',	1,	35186,	'2019-03-16 03:59:51',	'Novosibirsk',	'Novosibirsk',	'Novosibirsk'),
(1496990,	185,	1503900,	'Новокузнецк',	'Novokuznetsk',	'Novokuznetsk',	1,	35176,	'2019-03-16 03:59:51',	'Novokuznetsk',	'Novokuznetsk',	'Novokuznetsk'),
(1497337,	185,	1502020,	'Норильск',	'Noril\'sk',	'Noril\'sk',	1,	34827,	'2019-03-16 03:59:51',	'Noril\'sk',	'Noril\'sk',	'Noril\'sk'),
(1497393,	185,	1490542,	'Нижняя Салда',	'Nizhnyaya Salda',	'Nizhnyaya Salda',	1,	34680,	'2019-03-16 03:59:51',	'Nizhnyaya Salda',	'Nizhnyaya Salda',	'Nizhnyaya Salda'),
(1497543,	185,	1503773,	'Нижневартовск',	'Nizhnevartovsk',	'Nizhnevartovsk',	1,	34676,	'2019-03-16 03:59:51',	'Nizhnevartovsk',	'Nizhnevartovsk',	'Nizhnevartovsk'),
(1497549,	185,	2023468,	'Нижнеудинск',	'Nizhneudinsk',	'Nizhneudinsk',	1,	34675,	'2019-03-16 03:59:51',	'Nizhneudinsk',	'Nizhneudinsk',	'Nizhneudinsk'),
(1497795,	185,	1490542,	'Невьянск',	'Nev\'yansk',	'Nev\'yansk',	1,	34079,	'2019-03-16 03:59:51',	'Nev\'yansk',	'Nev\'yansk',	'Nev\'yansk'),
(1497917,	185,	1503773,	'Нефтеюганск',	'Nefteyugansk',	'Nefteyugansk',	1,	33753,	'2019-03-16 03:59:51',	'Nefteyugansk',	'Nefteyugansk',	'Nefteyugansk'),
(1498087,	185,	1486462,	'Надым',	'Nadym',	'Nadym',	1,	33469,	'2019-03-16 03:59:51',	'Nadym',	'Nadym',	'Nadym'),
(1498693,	185,	1502020,	'Минусинск',	'Minusinsk',	'Minusinsk',	1,	31606,	'2019-03-16 03:59:51',	'Minusinsk',	'Minusinsk',	'Minusinsk'),
(1498894,	185,	1508290,	'Миасс',	'Miass',	'Miass',	1,	31185,	'2019-03-16 03:59:51',	'Miass',	'Miass',	'Miass'),
(1498920,	185,	1503900,	'Междуреченск',	'Mezhdurechensk',	'Mezhdurechensk',	1,	31154,	'2019-03-16 03:59:51',	'Mezhdurechensk',	'Mezhdurechensk',	'Mezhdurechensk'),
(1499350,	185,	1503900,	'Мариинск',	'Mariinsk',	'Mariinsk',	1,	29809,	'2019-03-16 03:59:51',	'Mariinsk',	'Mariinsk',	'Mariinsk'),
(1500532,	185,	1496745,	'Линево',	'Linevo',	'Linevo',	1,	27862,	'2019-03-16 03:59:51',	'Linevo',	'Linevo',	'Linevo'),
(1500665,	185,	1503900,	'Ленинск-Кузнецкий',	'Leninsk-Kuznetskiy',	'Leninsk-Kuznetskiy',	1,	27210,	'2019-03-16 03:59:51',	'Leninsk-Kuznetskiy',	'Leninsk-Kuznetskiy',	'Leninsk-Kuznetskiy'),
(1500933,	185,	1486462,	'Лабытнанги',	'Labytnangi',	'Labytnangi',	1,	25740,	'2019-03-16 03:59:51',	'Labytnangi',	'Labytnangi',	'Labytnangi'),
(1500973,	185,	1488873,	'Кызыл',	'Kyzyl',	'Kyzyl',	1,	25072,	'2019-03-16 03:59:51',	'Kyzyl',	'Kyzyl',	'Kyzyl'),
(1500997,	185,	1508290,	'Кыштым',	'Kyshtym',	'Kyshtym',	1,	25071,	'2019-03-16 03:59:51',	'Kyshtym',	'Kyshtym',	'Kyshtym'),
(1501141,	185,	1496745,	'Куйбышев',	'Kuybyshev',	'Kuybyshev',	1,	25061,	'2019-03-16 03:59:51',	'Kuybyshev',	'Kuybyshev',	'Kuybyshev'),
(1501321,	185,	1501312,	'Курган',	'Kurgan',	'Kurgan',	1,	25035,	'2019-03-16 03:59:51',	'Kurgan',	'Kurgan',	'Kurgan'),
(1501356,	185,	1502020,	'Курагино',	'Kuragino',	'Kuragino',	1,	25031,	'2019-03-16 03:59:51',	'Kuragino',	'Kuragino',	'Kuragino'),
(1502026,	185,	1502020,	'Красноярск',	'Krasnoyarsk',	'Krasnoyarsk',	1,	24898,	'2019-03-16 03:59:51',	'Krasnoyarsk',	'Krasnoyarsk',	'Krasnoyarsk'),
(1502060,	185,	1490542,	'Красноуральск',	'Krasnoural\'sk',	'Krasnoural\'sk',	1,	24896,	'2019-03-16 03:59:51',	'Krasnoural\'sk',	'Krasnoural\'sk',	'Krasnoural\'sk'),
(1502061,	185,	1490542,	'Краснотурьинск',	'Krasnotur\'insk',	'Krasnotur\'insk',	1,	24894,	'2019-03-16 03:59:51',	'Krasnotur\'insk',	'Krasnotur\'insk',	'Krasnotur\'insk'),
(1502536,	185,	1508290,	'Коркино',	'Korkino',	'Korkino',	1,	24805,	'2019-03-16 03:59:51',	'Korkino',	'Korkino',	'Korkino'),
(1502603,	185,	1508290,	'Копейск',	'Kopeysk',	'Kopeysk',	1,	24794,	'2019-03-16 03:59:51',	'Kopeysk',	'Kopeysk',	'Kopeysk'),
(1502725,	185,	1503773,	'Югорск',	'Yugorsk',	'Yugorsk',	1,	54988,	'2019-03-16 03:59:51',	'Yugorsk',	'Yugorsk',	'Yugorsk'),
(1503037,	185,	1502020,	'Кодинск',	'Kodinsk',	'Kodinsk',	1,	24709,	'2019-03-16 03:59:51',	'Kodinsk',	'Kodinsk',	'Kodinsk'),
(1503277,	185,	1503900,	'Киселевск',	'Kiselevsk',	'Kiselevsk',	1,	24548,	'2019-03-16 03:59:51',	'Kiselevsk',	'Kiselevsk',	'Kiselevsk'),
(1503335,	185,	1490542,	'Кировград',	'Kirovgrad',	'Kirovgrad',	1,	24529,	'2019-03-16 03:59:51',	'Kirovgrad',	'Kirovgrad',	'Kirovgrad'),
(1503772,	185,	1503773,	'Ханты-Мансийск',	'Khanty-Mansiysk',	'Khanty-Mansiysk',	1,	24230,	'2019-03-16 03:59:51',	'Khanty-Mansiysk',	'Khanty-Mansiysk',	'Khanty-Mansiysk'),
(1503901,	185,	1503900,	'Кемерово',	'Kemerovo',	'Kemerovo',	1,	24050,	'2019-03-16 03:59:51',	'Kemerovo',	'Kemerovo',	'Kemerovo'),
(1504636,	185,	1508290,	'Карабаш',	'Karabash',	'Karabash',	1,	23866,	'2019-03-16 03:59:51',	'Karabash',	'Karabash',	'Karabash'),
(1504682,	185,	1502020,	'Канск',	'Kansk',	'Kansk',	1,	23849,	'2019-03-16 03:59:51',	'Kansk',	'Kansk',	'Kansk'),
(1504826,	185,	1490542,	'Каменск-Уральский',	'Kamensk-Ural\'skiy',	'Kamensk-Ural\'skiy',	1,	23802,	'2019-03-16 03:59:51',	'Kamensk-Ural\'skiy',	'Kamensk-Ural\'skiy',	'Kamensk-Ural\'skiy'),
(1504871,	185,	1511732,	'Камень-на-Оби',	'Kamen\'-na-Obi',	'Kamen\'-na-Obi',	1,	23798,	'2019-03-16 03:59:51',	'Kamen\'-na-Obi',	'Kamen\'-na-Obi',	'Kamen\'-na-Obi'),
(1504972,	185,	1503900,	'Калтан',	'Kaltan',	'Kaltan',	1,	23780,	'2019-03-16 03:59:51',	'Kaltan',	'Kaltan',	'Kaltan'),
(1505429,	185,	1496745,	'Искитим',	'Iskitim',	'Iskitim',	1,	23083,	'2019-03-16 03:59:51',	'Iskitim',	'Iskitim',	'Iskitim'),
(1505579,	185,	545854,	'Инта',	'Inta',	'Inta',	1,	22942,	'2019-03-16 03:59:51',	'Inta',	'Inta',	'Inta'),
(1505933,	185,	1502020,	'Иланский',	'Ilanskiy',	'Ilanskiy',	1,	22760,	'2019-03-16 03:59:51',	'Ilanskiy',	'Ilanskiy',	'Ilanskiy'),
(1506271,	185,	1506272,	'Горно-Алтайск',	'Gorno-Altaysk',	'Gorno-Altaysk',	1,	19145,	'2019-03-16 03:59:51',	'Gorno-Altaysk',	'Gorno-Altaysk',	'Gorno-Altaysk'),
(1507116,	185,	1502020,	'Дудинка',	'Dudinka',	'Dudinka',	1,	14090,	'2019-03-16 03:59:51',	'Dudinka',	'Dudinka',	'Dudinka'),
(1507379,	185,	1502020,	'Дивногорск',	'Divnogorsk',	'Divnogorsk',	1,	13570,	'2019-03-16 03:59:51',	'Divnogorsk',	'Divnogorsk',	'Divnogorsk'),
(1507565,	185,	1501312,	'Далматово',	'Dalmatovo',	'Dalmatovo',	1,	12723,	'2019-03-16 03:59:51',	'Dalmatovo',	'Dalmatovo',	'Dalmatovo'),
(1508054,	185,	1503834,	'Черногорск',	'Chernogorsk',	'Chernogorsk',	1,	10140,	'2019-03-16 03:59:51',	'Chernogorsk',	'Chernogorsk',	'Chernogorsk'),
(1508291,	185,	1508290,	'Челябинск',	'Chelyabinsk',	'Chelyabinsk',	1,	10083,	'2019-03-16 03:59:51',	'Chelyabinsk',	'Chelyabinsk',	'Chelyabinsk'),
(1508350,	185,	1508290,	'Чебаркуль',	'Chebarkul\'',	'Chebarkul\'',	1,	10049,	'2019-03-16 03:59:51',	'Chebarkul\'',	'Chebarkul\'',	'Chebarkul\''),
(1509888,	185,	1490542,	'Богданович',	'Bogdanovich',	'Bogdanovich',	1,	5596,	'2019-03-16 03:59:51',	'Bogdanovich',	'Bogdanovich',	'Bogdanovich'),
(1510018,	185,	1511732,	'Бийск',	'Biysk',	'Biysk',	1,	5218,	'2019-03-16 03:59:51',	'Biysk',	'Biysk',	'Biysk'),
(1510131,	185,	1503834,	'Бея',	'Beya',	'Beya',	1,	4829,	'2019-03-16 03:59:51',	'Beya',	'Beya',	'Beya'),
(1510203,	185,	1490542,	'Березовский',	'Berezovskiy',	'Berezovskiy',	1,	4490,	'2019-03-16 03:59:51',	'Berezovskiy',	'Berezovskiy',	'Berezovskiy'),
(1510205,	185,	1503900,	'Березовский',	'Berezovskiy',	'Berezovskiy',	1,	4491,	'2019-03-16 03:59:51',	'Berezovskiy',	'Berezovskiy',	'Berezovskiy'),
(1510350,	185,	1496745,	'Бердск',	'Berdsk',	'Berdsk',	1,	4477,	'2019-03-16 03:59:51',	'Berdsk',	'Berdsk',	'Berdsk'),
(1510469,	185,	1503900,	'Белово',	'Belovo',	'Belovo',	1,	4289,	'2019-03-16 03:59:51',	'Belovo',	'Belovo',	'Belovo'),
(1510853,	185,	1511732,	'Барнаул',	'Barnaul',	'Barnaul',	1,	3464,	'2019-03-16 03:59:51',	'Barnaul',	'Barnaul',	'Barnaul'),
(1511330,	185,	1490542,	'Асбест',	'Asbest',	'Asbest',	1,	2126,	'2019-03-16 03:59:51',	'Asbest',	'Asbest',	'Asbest'),
(1511494,	185,	1503900,	'Анжеро-Судженск',	'Anzhero-Sudzhensk',	'Anzhero-Sudzhensk',	1,	1616,	'2019-03-16 03:59:51',	'Anzhero-Sudzhensk',	'Anzhero-Sudzhensk',	'Anzhero-Sudzhensk'),
(1512165,	185,	1502020,	'Ачинск',	'Achinsk',	'Achinsk',	1,	138,	'2019-03-16 03:59:51',	'Achinsk',	'Achinsk',	'Achinsk'),
(1512236,	185,	1503834,	'Абакан',	'Abakan',	'Abakan',	1,	19,	'2019-03-16 03:59:51',	'Abakan',	'Abakan',	'Abakan'),
(1516438,	122,	1517381,	'Зыряновск',	'Zyryanovsk',	'Zyryanovsk',	1,	55252,	'2019-03-16 03:59:51',	'Zyryanovsk',	'Zyryanovsk',	'Zyryanovsk'),
(1516519,	122,	1521406,	'Zhosaly',	'Zhosaly',	'Zhosaly',	1,	55148,	'2019-03-16 03:59:51',	'Zhosaly',	'Zhosaly',	'Zhosaly'),
(1516589,	122,	1523401,	'Жезказган',	'Zhezqazghan',	'Zhezqazghan',	1,	55143,	'2019-03-16 03:59:51',	'Zhezqazghan',	'Zhezqazghan',	'Zhezqazghan'),
(1516788,	122,	1524444,	'Zhangatas',	'Zhangatas',	'Zhangatas',	1,	55134,	'2019-03-16 03:59:51',	'Zhangatas',	'Zhangatas',	'Zhangatas'),
(1516905,	122,	1524444,	'Тараз',	'Taraz',	'Taraz',	1,	48560,	'2019-03-16 03:59:51',	'Taraz',	'Taraz',	'Taraz'),
(1516968,	122,	1524444,	'Zhalpaktobe',	'Zhalpaktobe',	'Zhalpaktobe',	1,	55131,	'2019-03-16 03:59:51',	'Zhalpaktobe',	'Zhalpaktobe',	'Zhalpaktobe'),
(1517013,	122,	1518003,	'Belaghash',	'Belaghash',	'Belaghash',	1,	4094,	'2019-03-16 03:59:51',	'Belaghash',	'Belaghash',	'Belaghash'),
(1517020,	122,	1518003,	'Zhaqsy',	'Zhaqsy',	'Zhaqsy',	1,	55135,	'2019-03-16 03:59:51',	'Zhaqsy',	'Zhaqsy',	'Zhaqsy'),
(1517060,	122,	1517381,	'Зайсан',	'Zaysan',	'Zaysan',	1,	55066,	'2019-03-16 03:59:51',	'Zaysan',	'Zaysan',	'Zaysan'),
(1517323,	122,	1521406,	'Zhangaqorghan',	'Zhangaqorghan',	'Zhangaqorghan',	1,	55133,	'2019-03-16 03:59:51',	'Zhangaqorghan',	'Zhangaqorghan',	'Zhangaqorghan'),
(1517637,	122,	1537162,	'Ush-Tyube',	'Ush-Tyube',	'Ush-Tyube',	1,	50552,	'2019-03-16 03:59:51',	'Ush-Tyube',	'Ush-Tyube',	'Ush-Tyube'),
(1517733,	122,	1537162,	'Унгуртас',	'Ungurtas',	'Ungurtas',	1,	50351,	'2019-03-16 03:59:51',	'Ungurtas',	'Ungurtas',	'Ungurtas'),
(1517836,	122,	1537162,	'Usharal',	'Usharal',	'Usharal',	1,	50553,	'2019-03-16 03:59:51',	'Usharal',	'Usharal',	'Usharal'),
(1517945,	122,	1524787,	'Туркестан',	'Turkestan',	'Turkestan',	1,	50134,	'2019-03-16 03:59:51',	'Turkestan',	'Turkestan',	'Turkestan'),
(1518203,	122,	1521406,	'Terenozek',	'Terenozek',	'Terenozek',	1,	48805,	'2019-03-16 03:59:51',	'Terenozek',	'Terenozek',	'Terenozek'),
(1518262,	122,	1523401,	'Темиртау',	'Temirtau',	'Temirtau',	1,	48747,	'2019-03-16 03:59:51',	'Temirtau',	'Temirtau',	'Temirtau'),
(1518504,	122,	1524444,	'Tamdy',	'Tamdy',	'Tamdy',	1,	48510,	'2019-03-16 03:59:51',	'Tamdy',	'Tamdy',	'Tamdy'),
(1518518,	122,	1537162,	'Талгар',	'Talghar',	'Talghar',	1,	48469,	'2019-03-16 03:59:51',	'Talghar',	'Talghar',	'Talghar'),
(1518542,	122,	1537162,	'Талдыкорган',	'Taldykorgan',	'Taldykorgan',	1,	48462,	'2019-03-16 03:59:51',	'Taldykorgan',	'Taldykorgan',	'Taldykorgan'),
(1518980,	122,	1524787,	'Шымкент',	'Shymkent',	'Shymkent',	1,	46199,	'2019-03-16 03:59:51',	'Shymkent',	'Shymkent',	'Shymkent'),
(1519030,	122,	1524444,	'Shu',	'Shu',	'Shu',	1,	46187,	'2019-03-16 03:59:51',	'Shu',	'Shu',	'Shu'),
(1519244,	122,	1519367,	'Shchuchinsk',	'Shchuchinsk',	'Shchuchinsk',	1,	46007,	'2019-03-16 03:59:51',	'Shchuchinsk',	'Shchuchinsk',	'Shchuchinsk'),
(1519272,	122,	1520239,	'Sharbaqty',	'Sharbaqty',	'Sharbaqty',	1,	45963,	'2019-03-16 03:59:51',	'Sharbaqty',	'Sharbaqty',	'Sharbaqty'),
(1519275,	122,	1517381,	'Шар',	'Shar',	'Shar',	1,	45961,	'2019-03-16 03:59:51',	'Shar',	'Shar',	'Shar'),
(1519422,	122,	1517381,	'Семей',	'Semey',	'Semey',	1,	45659,	'2019-03-16 03:59:51',	'Semey',	'Semey',	'Semey'),
(1519439,	122,	1517381,	'Секисовка',	'Sekisovka',	'Sekisovka',	1,	45594,	'2019-03-16 03:59:51',	'Sekisovka',	'Sekisovka',	'Sekisovka'),
(1519580,	122,	1537162,	'Сарыозек',	'Saryozek',	'Saryozek',	1,	44742,	'2019-03-16 03:59:51',	'Saryozek',	'Saryozek',	'Saryozek'),
(1519673,	122,	1524787,	'Сарыагаш',	'Saryaghash',	'Saryaghash',	1,	44740,	'2019-03-16 03:59:51',	'Saryaghash',	'Saryaghash',	'Saryaghash'),
(1519691,	122,	1537162,	'Sarkand',	'Sarkand',	'Sarkand',	1,	44700,	'2019-03-16 03:59:51',	'Sarkand',	'Sarkand',	'Sarkand'),
(1519922,	122,	1521406,	'Кызылорда',	'Kyzylorda',	'Kyzylorda',	1,	25073,	'2019-03-16 03:59:51',	'Kyzylorda',	'Kyzylorda',	'Kyzylorda'),
(1519928,	122,	1521671,	'Костанай',	'Kostanay',	'Kostanay',	1,	24826,	'2019-03-16 03:59:51',	'Kostanay',	'Kostanay',	'Kostanay'),
(1519931,	122,	1537162,	'Каскелен',	'Qaskeleng',	'Qaskeleng',	1,	39641,	'2019-03-16 03:59:51',	'Qaskeleng',	'Qaskeleng',	'Qaskeleng'),
(1519938,	122,	1524444,	'Karatau',	'Karatau',	'Karatau',	1,	23879,	'2019-03-16 03:59:51',	'Karatau',	'Karatau',	'Karatau'),
(1519948,	122,	1537162,	'Капшагай',	'Kapshagay',	'Kapshagay',	1,	23864,	'2019-03-16 03:59:51',	'Kapshagay',	'Kapshagay',	'Kapshagay'),
(1520172,	122,	1519367,	'Петропавловск',	'Petropavlovsk',	'Petropavlovsk',	1,	37618,	'2019-03-16 03:59:51',	'Petropavlovsk',	'Petropavlovsk',	'Petropavlovsk'),
(1520240,	122,	1520239,	'Павлодар',	'Pavlodar',	'Pavlodar',	1,	37120,	'2019-03-16 03:59:51',	'Pavlodar',	'Pavlodar',	'Pavlodar'),
(1520253,	122,	1537162,	'Жаркент',	'Zharkent',	'Zharkent',	1,	55136,	'2019-03-16 03:59:51',	'Zharkent',	'Zharkent',	'Zharkent'),
(1520316,	122,	1517381,	'Усть-Каменогорск',	'Oskemen',	'Oskemen',	1,	36253,	'2019-03-16 03:59:51',	'Oskemen',	'Oskemen',	'Oskemen'),
(1520656,	122,	1517381,	'Новая Шульба',	'Novaya Shul\'ba',	'Novaya Shul\'ba',	1,	35150,	'2019-03-16 03:59:51',	'Novaya Shul\'ba',	'Novaya Shul\'ba',	'Novaya Shul\'ba'),
(1520897,	122,	1524444,	'Moinkum',	'Moinkum',	'Moinkum',	1,	31808,	'2019-03-16 03:59:51',	'Moinkum',	'Moinkum',	'Moinkum'),
(1520947,	122,	1524444,	'Sarykemer',	'Sarykemer',	'Sarykemer',	1,	44741,	'2019-03-16 03:59:51',	'Sarykemer',	'Sarykemer',	'Sarykemer'),
(1520969,	122,	1524444,	'Merke',	'Merke',	'Merke',	1,	30936,	'2019-03-16 03:59:51',	'Merke',	'Merke',	'Merke'),
(1521292,	122,	1524444,	'Kulan',	'Kulan',	'Kulan',	1,	24999,	'2019-03-16 03:59:51',	'Kulan',	'Kulan',	'Kulan'),
(1521306,	122,	1519367,	'Ломоносовское',	'Lomonosovka',	'Lomonosovka',	1,	28295,	'2019-03-16 03:59:51',	'Lomonosovka',	'Lomonosovka',	'Lomonosovka'),
(1521368,	122,	1538316,	'Байконур',	'Baykonyr',	'Baykonyr',	1,	3758,	'2019-03-16 03:59:51',	'Baykonyr',	'Baykonyr',	'Baykonyr'),
(1521370,	122,	1517381,	'Риддер',	'Ridder',	'Ridder',	1,	40753,	'2019-03-16 03:59:51',	'Ridder',	'Ridder',	'Ridder'),
(1522203,	122,	1518003,	'Кокшетау',	'Kokshetau',	'Kokshetau',	1,	24727,	'2019-03-16 03:59:51',	'Kokshetau',	'Kokshetau',	'Kokshetau'),
(1522470,	122,	1524444,	'Koktal',	'Koktal',	'Koktal',	1,	24728,	'2019-03-16 03:59:51',	'Koktal',	'Koktal',	'Koktal'),
(1522642,	122,	1537162,	'Балпык',	'Balpyk Bi',	'Balpyk Bi',	1,	3244,	'2019-03-16 03:59:51',	'Balpyk Bi',	'Balpyk Bi',	'Balpyk Bi'),
(1522751,	122,	1524787,	'Кентау',	'Kentau',	'Kentau',	1,	24124,	'2019-03-16 03:59:51',	'Kentau',	'Kentau',	'Kentau'),
(1522862,	122,	1521406,	'Qazaly',	'Qazaly',	'Qazaly',	1,	39642,	'2019-03-16 03:59:51',	'Qazaly',	'Qazaly',	'Qazaly'),
(1522955,	122,	1524444,	'Kaskabulak',	'Kaskabulak',	'Kaskabulak',	1,	23930,	'2019-03-16 03:59:51',	'Kaskabulak',	'Kaskabulak',	'Kaskabulak'),
(1523216,	122,	1523401,	'Karasaz',	'Karasaz',	'Karasaz',	1,	23878,	'2019-03-16 03:59:51',	'Karasaz',	'Karasaz',	'Karasaz'),
(1523400,	122,	1519367,	'Карагандинское',	'Qaraghandy',	'Qaraghandy',	1,	39640,	'2019-03-16 03:59:51',	'Qaraghandy',	'Qaraghandy',	'Qaraghandy'),
(1524174,	122,	1524444,	'Grodikov',	'Grodikov',	'Grodikov',	1,	19838,	'2019-03-16 03:59:51',	'Grodikov',	'Grodikov',	'Grodikov'),
(1524227,	122,	1517381,	'Глубокое',	'Glubokoye',	'Glubokoye',	1,	18917,	'2019-03-16 03:59:51',	'Glubokoye',	'Glubokoye',	'Glubokoye'),
(1524243,	122,	1524444,	'Кордай',	'Korday',	'Korday',	1,	24802,	'2019-03-16 03:59:51',	'Korday',	'Korday',	'Korday'),
(1524296,	122,	1518003,	'Есиль',	'Esil',	'Esil',	1,	15689,	'2019-03-16 03:59:51',	'Esil',	'Esil',	'Esil'),
(1524298,	122,	1520239,	'Аксу',	'Aksu',	'Aksu',	1,	471,	'2019-03-16 03:59:51',	'Aksu',	'Aksu',	'Aksu'),
(1524325,	122,	1520239,	'Экибастуз',	'Ekibastuz',	'Ekibastuz',	1,	14889,	'2019-03-16 03:59:51',	'Ekibastuz',	'Ekibastuz',	'Ekibastuz'),
(1524385,	122,	1524787,	'Жетысай',	'Zhetisay',	'Zhetisay',	1,	55142,	'2019-03-16 03:59:51',	'Zhetisay',	'Zhetisay',	'Zhetisay'),
(1524478,	122,	1521406,	'Dzhalagash',	'Dzhalagash',	'Dzhalagash',	1,	14290,	'2019-03-16 03:59:51',	'Dzhalagash',	'Dzhalagash',	'Dzhalagash'),
(1524606,	122,	1518003,	'Derzhavinsk',	'Derzhavinsk',	'Derzhavinsk',	1,	13275,	'2019-03-16 03:59:51',	'Derzhavinsk',	'Derzhavinsk',	'Derzhavinsk'),
(1524965,	122,	1524444,	'Bauyrzhan Momyshuly',	'Bauyrzhan Momyshuly',	'Bauyrzhan Momyshuly',	1,	3707,	'2019-03-16 03:59:51',	'Bauyrzhan Momyshuly',	'Bauyrzhan Momyshuly',	'Bauyrzhan Momyshuly'),
(1525098,	122,	1524444,	'Bostandyq',	'Bostandyq',	'Bostandyq',	1,	6015,	'2019-03-16 03:59:51',	'Bostandyq',	'Bostandyq',	'Bostandyq'),
(1525126,	122,	1519367,	'Burabay',	'Burabay',	'Burabay',	1,	7339,	'2019-03-16 03:59:51',	'Burabay',	'Burabay',	'Burabay'),
(1525160,	122,	1524787,	'Boralday',	'Boralday',	'Boralday',	1,	5872,	'2019-03-16 03:59:51',	'Boralday',	'Boralday',	'Boralday'),
(1525295,	122,	1519367,	'Bishkul\'',	'Bishkul\'',	'Bishkul\'',	1,	5156,	'2019-03-16 03:59:51',	'Bishkul\'',	'Bishkul\'',	'Bishkul\''),
(1525798,	122,	1523401,	'Балхаш',	'Balqash',	'Balqash',	1,	3245,	'2019-03-16 03:59:51',	'Balqash',	'Balqash',	'Balqash'),
(1525988,	122,	1517381,	'Аягуз',	'Ayagoz',	'Ayagoz',	1,	2785,	'2019-03-16 03:59:51',	'Ayagoz',	'Ayagoz',	'Ayagoz'),
(1526066,	122,	1524444,	'Assa',	'Assa',	'Assa',	1,	2259,	'2019-03-16 03:59:51',	'Assa',	'Assa',	'Assa'),
(1526067,	122,	1524444,	'Aspara',	'Aspara',	'Aspara',	1,	2245,	'2019-03-16 03:59:51',	'Aspara',	'Aspara',	'Aspara'),
(1526265,	122,	1521406,	'Aral',	'Aral',	'Aral',	1,	1704,	'2019-03-16 03:59:51',	'Aral',	'Aral',	'Aral'),
(1526273,	122,	1538317,	'Астана',	'Astana',	'Astana',	1,	2280,	'2019-03-16 03:59:51',	'Astana',	'Astana',	'Astana'),
(1526384,	122,	1526395,	'Алматы',	'Almaty',	'Almaty',	1,	915,	'2019-03-16 03:59:51',	'Almaty',	'Almaty',	'Almaty'),
(1526541,	122,	1524444,	'Akzhar',	'Akzhar',	'Akzhar',	1,	474,	'2019-03-16 03:59:51',	'Akzhar',	'Akzhar',	'Akzhar'),
(1526648,	122,	1517381,	'Аксуат',	'Aksuat',	'Aksuat',	1,	472,	'2019-03-16 03:59:51',	'Aksuat',	'Aksuat',	'Aksuat'),
(1535059,	122,	1521406,	'Belkol',	'Belkol',	'Belkol',	1,	4138,	'2019-03-16 03:59:51',	'Belkol',	'Belkol',	'Belkol'),
(1536289,	185,	1508290,	'Снежинск',	'Snezhinsk',	'Snezhinsk',	1,	46583,	'2019-03-16 03:59:51',	'Snezhinsk',	'Snezhinsk',	'Snezhinsk'),
(1536757,	185,	1503773,	'Приобье',	'Priob\'ye',	'Priob\'ye',	1,	39379,	'2019-03-16 03:59:51',	'Priob\'ye',	'Priob\'ye',	'Priob\'ye'),
(1537939,	122,	1518003,	'Степногорск',	'Stepnogorsk',	'Stepnogorsk',	1,	47636,	'2019-03-16 03:59:51',	'Stepnogorsk',	'Stepnogorsk',	'Stepnogorsk'),
(1538634,	185,	1508290,	'Озерск',	'Ozersk',	'Ozersk',	1,	36554,	'2019-03-16 03:59:51',	'Ozersk',	'Ozersk',	'Ozersk'),
(1538635,	185,	1502020,	'Железногорск',	'Zheleznogorsk',	'Zheleznogorsk',	1,	55138,	'2019-03-16 03:59:51',	'Zheleznogorsk',	'Zheleznogorsk',	'Zheleznogorsk'),
(1538636,	185,	1490542,	'Новоуральск',	'Novoural\'sk',	'Novoural\'sk',	1,	35190,	'2019-03-16 03:59:51',	'Novoural\'sk',	'Novoural\'sk',	'Novoural\'sk'),
(1538637,	185,	1489421,	'Северск',	'Seversk',	'Seversk',	1,	45873,	'2019-03-16 03:59:51',	'Seversk',	'Seversk',	'Seversk'),
(1538959,	122,	1521671,	'Yubileynoye',	'Yubileynoye',	'Yubileynoye',	1,	54984,	'2019-03-16 03:59:51',	'Yubileynoye',	'Yubileynoye',	'Yubileynoye'),
(1539930,	122,	1537162,	'Байсерке',	'Bayserke',	'Bayserke',	1,	3769,	'2019-03-16 03:59:51',	'Bayserke',	'Bayserke',	'Bayserke'),
(1539959,	122,	1537162,	'Intymak',	'Intymak',	'Intymak',	1,	22951,	'2019-03-16 03:59:51',	'Intymak',	'Intymak',	'Intymak'),
(1540356,	185,	1503773,	'Радужный',	'Raduzhny',	'Raduzhny',	1,	39863,	'2019-03-16 03:59:51',	'Raduzhny',	'Raduzhny',	'Raduzhny'),
(1540711,	185,	1486462,	'Муравленко',	'Muravlenko',	'Muravlenko',	1,	33341,	'2019-03-16 03:59:51',	'Muravlenko',	'Muravlenko',	'Muravlenko'),
(2012330,	185,	2023468,	'Усть-Илимск',	'Ust\'-Ilimsk',	'Ust\'-Ilimsk',	1,	50568,	'2019-03-16 03:59:51',	'Ust\'-Ilimsk',	'Ust\'-Ilimsk',	'Ust\'-Ilimsk'),
(2012484,	185,	2023468,	'Зима',	'Zima',	'Zima',	1,	55174,	'2019-03-16 03:59:51',	'Zima',	'Zima',	'Zima'),
(2012557,	185,	2023468,	'Железногорск-Илимский',	'Zheleznogorsk-Ilimskiy',	'Zheleznogorsk-Ilimskiy',	1,	55140,	'2019-03-16 03:59:51',	'Zheleznogorsk-Ilimskiy',	'Zheleznogorsk-Ilimskiy',	'Zheleznogorsk-Ilimskiy'),
(2012780,	185,	7779061,	'Забайкальск',	'Zabaykal\'sk',	'Zabaykal\'sk',	1,	55018,	'2019-03-16 03:59:51',	'Zabaykal\'sk',	'Zabaykal\'sk',	'Zabaykal\'sk'),
(2012938,	185,	2027748,	'Ерофей-Павлович',	'Yerofey Pavlovich',	'Yerofey Pavlovich',	1,	54927,	'2019-03-16 03:59:51',	'Yerofey Pavlovich',	'Yerofey Pavlovich',	'Yerofey Pavlovich'),
(2013159,	185,	2013162,	'Якутск',	'Yakutsk',	'Yakutsk',	1,	54862,	'2019-03-16 03:59:51',	'Yakutsk',	'Yakutsk',	'Yakutsk'),
(2013176,	185,	2017623,	'Яковлевка',	'Yakovlevka',	'Yakovlevka',	1,	54859,	'2019-03-16 03:59:51',	'Yakovlevka',	'Yakovlevka',	'Yakovlevka'),
(2013332,	185,	2017623,	'Вольно-Надеждинское',	'Vol\'no-Nadezhdinskoye',	'Vol\'no-Nadezhdinskoye',	1,	52250,	'2019-03-16 03:59:51',	'Vol\'no-Nadezhdinskoye',	'Vol\'no-Nadezhdinskoye',	'Vol\'no-Nadezhdinskoye'),
(2013348,	185,	2017623,	'Владивосток',	'Vladivostok',	'Vladivostok',	1,	52212,	'2019-03-16 03:59:51',	'Vladivostok',	'Vladivostok',	'Vladivostok'),
(2013399,	185,	2023468,	'Вихоревка',	'Vikhorevka',	'Vikhorevka',	1,	51601,	'2019-03-16 03:59:51',	'Vikhorevka',	'Vikhorevka',	'Vikhorevka'),
(2013923,	185,	2023468,	'Усть-Кут',	'Ust\'-Kut',	'Ust\'-Kut',	1,	50570,	'2019-03-16 03:59:51',	'Ust\'-Kut',	'Ust\'-Kut',	'Ust\'-Kut'),
(2014006,	185,	2017623,	'Уссурийск',	'Ussuriysk',	'Ussuriysk',	1,	50565,	'2019-03-16 03:59:51',	'Ussuriysk',	'Ussuriysk',	'Ussuriysk'),
(2014407,	185,	2050915,	'Улан-Удэ',	'Ulan-Ude',	'Ulan-Ude',	1,	50297,	'2019-03-16 03:59:51',	'Ulan-Ude',	'Ulan-Ude',	'Ulan-Ude'),
(2014718,	185,	2027748,	'Тында',	'Tynda',	'Tynda',	1,	50216,	'2019-03-16 03:59:51',	'Tynda',	'Tynda',	'Tynda'),
(2015051,	185,	2017623,	'Трудовое',	'Trudovoye',	'Trudovoye',	1,	50033,	'2019-03-16 03:59:51',	'Trudovoye',	'Trudovoye',	'Trudovoye'),
(2015310,	185,	2017623,	'Фокино',	'Fokino',	'Fokino',	1,	16899,	'2019-03-16 03:59:51',	'Fokino',	'Fokino',	'Fokino'),
(2015352,	185,	2017623,	'Терней',	'Terney',	'Terney',	1,	48820,	'2019-03-16 03:59:51',	'Terney',	'Terney',	'Terney'),
(2015701,	185,	2050915,	'Таксимо',	'Taksimo',	'Taksimo',	1,	48448,	'2019-03-16 03:59:51',	'Taksimo',	'Taksimo',	'Taksimo'),
(2015833,	185,	2027748,	'Свободный',	'Svobodnyy',	'Svobodnyy',	1,	48296,	'2019-03-16 03:59:51',	'Svobodnyy',	'Svobodnyy',	'Svobodnyy'),
(2016187,	185,	2017623,	'Спасск-Дальний',	'Spassk-Dal\'niy',	'Spassk-Dal\'niy',	1,	47143,	'2019-03-16 03:59:51',	'Spassk-Dal\'niy',	'Spassk-Dal\'niy',	'Spassk-Dal\'niy'),
(2016422,	185,	2023468,	'Слюдянка',	'Slyudyanka',	'Slyudyanka',	1,	46520,	'2019-03-16 03:59:51',	'Slyudyanka',	'Slyudyanka',	'Slyudyanka'),
(2016430,	185,	2017623,	'Славянка',	'Slavyanka',	'Slavyanka',	1,	46497,	'2019-03-16 03:59:51',	'Slavyanka',	'Slavyanka',	'Slavyanka'),
(2016443,	185,	2027748,	'Сковородино',	'Skovorodino',	'Skovorodino',	1,	46481,	'2019-03-16 03:59:51',	'Skovorodino',	'Skovorodino',	'Skovorodino'),
(2016701,	185,	2027748,	'Шимановск',	'Shimanovsk',	'Shimanovsk',	1,	46123,	'2019-03-16 03:59:51',	'Shimanovsk',	'Shimanovsk',	'Shimanovsk'),
(2016708,	185,	7779061,	'Шилка',	'Shilka',	'Shilka',	1,	46117,	'2019-03-16 03:59:51',	'Shilka',	'Shilka',	'Shilka'),
(2016764,	185,	2023468,	'Шелехов',	'Shelekhov',	'Shelekhov',	1,	46047,	'2019-03-16 03:59:51',	'Shelekhov',	'Shelekhov',	'Shelekhov'),
(2016910,	185,	2050915,	'Северобайкальск',	'Severobaykal\'sk',	'Severobaykal\'sk',	1,	45871,	'2019-03-16 03:59:51',	'Severobaykal\'sk',	'Severobaykal\'sk',	'Severobaykal\'sk'),
(2017059,	185,	2050915,	'Селенгинск',	'Selenginsk',	'Selenginsk',	1,	45607,	'2019-03-16 03:59:51',	'Selenginsk',	'Selenginsk',	'Selenginsk'),
(2017838,	185,	2017623,	'Покровка',	'Pokrovka',	'Pokrovka',	1,	38517,	'2019-03-16 03:59:51',	'Pokrovka',	'Pokrovka',	'Pokrovka'),
(2018553,	185,	2017623,	'Ольга',	'Ol\'ga',	'Ol\'ga',	1,	35742,	'2019-03-16 03:59:51',	'Ol\'ga',	'Ol\'ga',	'Ol\'ga'),
(2018864,	185,	2017623,	'Новошахтинский',	'Novoshakhtinskiy',	'Novoshakhtinskiy',	1,	35185,	'2019-03-16 03:59:51',	'Novoshakhtinskiy',	'Novoshakhtinskiy',	'Novoshakhtinskiy'),
(2019309,	185,	2013162,	'Нерюнгри',	'Neryungri',	'Neryungri',	1,	33834,	'2019-03-16 03:59:51',	'Neryungri',	'Neryungri',	'Neryungri'),
(2019528,	185,	2017623,	'Находка',	'Nakhodka',	'Nakhodka',	1,	33497,	'2019-03-16 03:59:51',	'Nakhodka',	'Nakhodka',	'Nakhodka'),
(2019912,	185,	7779061,	'Могоча',	'Mogocha',	'Mogocha',	1,	31783,	'2019-03-16 03:59:51',	'Mogocha',	'Mogocha',	'Mogocha'),
(2019951,	185,	2013162,	'Мирный',	'Mirny',	'Mirny',	1,	31663,	'2019-03-16 03:59:51',	'Mirny',	'Mirny',	'Mirny'),
(2020013,	185,	2017623,	'Михайловка',	'Mikhaylovka',	'Mikhaylovka',	1,	31322,	'2019-03-16 03:59:51',	'Mikhaylovka',	'Mikhaylovka',	'Mikhaylovka'),
(2020689,	185,	2017623,	'Лучегорск',	'Luchegorsk',	'Luchegorsk',	1,	28715,	'2019-03-16 03:59:51',	'Luchegorsk',	'Luchegorsk',	'Luchegorsk'),
(2020812,	185,	2017623,	'Лесозаводск',	'Lesozavodsk',	'Lesozavodsk',	1,	27460,	'2019-03-16 03:59:51',	'Lesozavodsk',	'Lesozavodsk',	'Lesozavodsk'),
(2020838,	185,	2013162,	'Ленск',	'Lensk',	'Lensk',	1,	27230,	'2019-03-16 03:59:51',	'Lensk',	'Lensk',	'Lensk'),
(2021618,	185,	7779061,	'Краснокаменск',	'Krasnokamensk',	'Krasnokamensk',	1,	24890,	'2019-03-16 03:59:51',	'Krasnokamensk',	'Krasnokamensk',	'Krasnokamensk'),
(2021851,	185,	2022888,	'Комсомольск-на-Амуре',	'Komsomolsk-on-Amur',	'Komsomolsk-on-Amur',	1,	24751,	'2019-03-16 03:59:51',	'Komsomolsk-on-Amur',	'Komsomolsk-on-Amur',	'Komsomolsk-on-Amur'),
(2022064,	185,	2017623,	'Кировский',	'Kirovskiy',	'Kirovskiy',	1,	24534,	'2019-03-16 03:59:51',	'Kirovskiy',	'Kirovskiy',	'Kirovskiy'),
(2022174,	185,	2022888,	'Хурба',	'Khurba',	'Khurba',	1,	24251,	'2019-03-16 03:59:51',	'Khurba',	'Khurba',	'Khurba'),
(2022289,	185,	2017623,	'Хороль',	'Khorol\'',	'Khorol\'',	1,	24250,	'2019-03-16 03:59:51',	'Khorol\'',	'Khorol\'',	'Khorol\''),
(2022463,	185,	7779061,	'Хилок',	'Khilok',	'Khilok',	1,	24241,	'2019-03-16 03:59:51',	'Khilok',	'Khilok',	'Khilok'),
(2022890,	185,	2022888,	'Хабаровск',	'Khabarovsk',	'Khabarovsk',	1,	24224,	'2019-03-16 03:59:51',	'Khabarovsk',	'Khabarovsk',	'Khabarovsk'),
(2023058,	185,	2017623,	'Кавалерово',	'Kavalerovo',	'Kavalerovo',	1,	23964,	'2019-03-16 03:59:51',	'Kavalerovo',	'Kavalerovo',	'Kavalerovo'),
(2023226,	185,	2017623,	'Камень-Рыболов',	'Kamen\'-Rybolov',	'Kamen\'-Rybolov',	1,	23799,	'2019-03-16 03:59:51',	'Kamen\'-Rybolov',	'Kamen\'-Rybolov',	'Kamen\'-Rybolov'),
(2023469,	185,	2023468,	'Иркутск',	'Irkutsk',	'Irkutsk',	1,	23006,	'2019-03-16 03:59:51',	'Irkutsk',	'Irkutsk',	'Irkutsk'),
(2023782,	185,	2050915,	'Гусиноозерск',	'Gusinoozersk',	'Gusinoozersk',	1,	20225,	'2019-03-16 03:59:51',	'Gusinoozersk',	'Gusinoozersk',	'Gusinoozersk'),
(2024203,	185,	2017623,	'Галенки',	'Galenki',	'Galenki',	1,	17943,	'2019-03-16 03:59:51',	'Galenki',	'Galenki',	'Galenki'),
(2024261,	185,	2027748,	'Февральск',	'Fevral\'sk',	'Fevral\'sk',	1,	16571,	'2019-03-16 03:59:51',	'Fevral\'sk',	'Fevral\'sk',	'Fevral\'sk'),
(2025159,	185,	2017623,	'Дальнереченск',	'Dal\'nerechensk',	'Dal\'nerechensk',	1,	12692,	'2019-03-16 03:59:51',	'Dal\'nerechensk',	'Dal\'nerechensk',	'Dal\'nerechensk'),
(2025339,	185,	7779061,	'Чита',	'Chita',	'Chita',	1,	10391,	'2019-03-16 03:59:51',	'Chita',	'Chita',	'Chita'),
(2025458,	185,	7779061,	'Чернышевск',	'Chernyshevsk',	'Chernyshevsk',	1,	10143,	'2019-03-16 03:59:51',	'Chernyshevsk',	'Chernyshevsk',	'Chernyshevsk'),
(2025489,	185,	2017623,	'Черниговка',	'Chernigovka',	'Chernigovka',	1,	10135,	'2019-03-16 03:59:51',	'Chernigovka',	'Chernigovka',	'Chernigovka'),
(2025579,	185,	2022888,	'Чегдомын',	'Chegdomyn',	'Chegdomyn',	1,	10060,	'2019-03-16 03:59:51',	'Chegdomyn',	'Chegdomyn',	'Chegdomyn'),
(2026094,	185,	2023468,	'Братск',	'Bratsk',	'Bratsk',	1,	6429,	'2019-03-16 03:59:51',	'Bratsk',	'Bratsk',	'Bratsk'),
(2026303,	185,	2017623,	'Большой Камень',	'Bol\'shoy Kamen\'',	'Bol\'shoy Kamen\'',	1,	5692,	'2019-03-16 03:59:51',	'Bol\'shoy Kamen\'',	'Bol\'shoy Kamen\'',	'Bol\'shoy Kamen\''),
(2026583,	185,	2023468,	'Бодайбо',	'Bodaybo',	'Bodaybo',	1,	5555,	'2019-03-16 03:59:51',	'Bodaybo',	'Bodaybo',	'Bodaybo'),
(2026609,	185,	2027748,	'Благовещенск',	'Blagoveshchensk',	'Blagoveshchensk',	1,	5272,	'2019-03-16 03:59:51',	'Blagoveshchensk',	'Blagoveshchensk',	'Blagoveshchensk'),
(2026643,	185,	2026639,	'Биробиджан',	'Birobidzhan',	'Birobidzhan',	1,	5125,	'2019-03-16 03:59:51',	'Birobidzhan',	'Birobidzhan',	'Birobidzhan'),
(2026895,	185,	2027748,	'Белогорск',	'Belogorsk',	'Belogorsk',	1,	4283,	'2019-03-16 03:59:51',	'Belogorsk',	'Belogorsk',	'Belogorsk'),
(2026979,	185,	2023468,	'Байкальск',	'Baykal\'sk',	'Baykal\'sk',	1,	3757,	'2019-03-16 03:59:51',	'Baykal\'sk',	'Baykal\'sk',	'Baykal\'sk'),
(2027456,	185,	2017623,	'Артем',	'Artem',	'Artem',	1,	2057,	'2019-03-16 03:59:51',	'Artem',	'Artem',	'Artem'),
(2027468,	185,	2017623,	'Арсеньев',	'Arsen\'yev',	'Arsen\'yev',	1,	2045,	'2019-03-16 03:59:51',	'Arsen\'yev',	'Arsen\'yev',	'Arsen\'yev'),
(2027667,	185,	2023468,	'Ангарск',	'Angarsk',	'Angarsk',	1,	1428,	'2019-03-16 03:59:51',	'Angarsk',	'Angarsk',	'Angarsk'),
(2027749,	185,	2022888,	'Амурск',	'Amursk',	'Amursk',	1,	1320,	'2019-03-16 03:59:51',	'Amursk',	'Amursk',	'Amursk'),
(2027968,	185,	2013162,	'Алдан',	'Aldan',	'Aldan',	1,	659,	'2019-03-16 03:59:51',	'Aldan',	'Aldan',	'Aldan'),
(2047258,	185,	2022888,	'Новый Ургал',	'Novyy Urgal',	'Novyy Urgal',	1,	35197,	'2019-03-16 03:59:51',	'Novyy Urgal',	'Novyy Urgal',	'Novyy Urgal'),
(2051471,	185,	2017623,	'Дальнегорск',	'Dal\'negorsk',	'Dal\'negorsk',	1,	12691,	'2019-03-16 03:59:51',	'Dal\'negorsk',	'Dal\'negorsk',	'Dal\'negorsk'),
(2055166,	185,	2023468,	'Саянск',	'Sayansk',	'Sayansk',	1,	44938,	'2019-03-16 03:59:51',	'Sayansk',	'Sayansk',	'Sayansk'),
(2055815,	185,	7779061,	'Куанда',	'Kuanda',	'Kuanda',	1,	24978,	'2019-03-16 03:59:51',	'Kuanda',	'Kuanda',	'Kuanda'),
(2055822,	185,	7779061,	'Новая Чара',	'Novaya Chara',	'Novaya Chara',	1,	35149,	'2019-03-16 03:59:51',	'Novaya Chara',	'Novaya Chara',	'Novaya Chara'),
(2118647,	185,	2125072,	'Вилючинск',	'Vilyuchinsk',	'Vilyuchinsk',	1,	52051,	'2019-03-16 03:59:51',	'Vilyuchinsk',	'Vilyuchinsk',	'Vilyuchinsk'),
(2119441,	185,	2121529,	'Южно-Сахалинск',	'Yuzhno-Sakhalinsk',	'Yuzhno-Sakhalinsk',	1,	55003,	'2019-03-16 03:59:51',	'Yuzhno-Sakhalinsk',	'Yuzhno-Sakhalinsk',	'Yuzhno-Sakhalinsk'),
(2119538,	185,	2125072,	'Елизово',	'Yelizovo',	'Yelizovo',	1,	54912,	'2019-03-16 03:59:51',	'Yelizovo',	'Yelizovo',	'Yelizovo'),
(2119932,	185,	2022888,	'Ванино',	'Vanino',	'Vanino',	1,	50890,	'2019-03-16 03:59:51',	'Vanino',	'Vanino',	'Vanino'),
(2120059,	185,	2125072,	'Усть-Камчатск',	'Ust-Kamchatsk',	'Ust-Kamchatsk',	1,	50571,	'2019-03-16 03:59:51',	'Ust-Kamchatsk',	'Ust-Kamchatsk',	'Ust-Kamchatsk'),
(2120334,	185,	2121529,	'Тымовское',	'Tymovskoye',	'Tymovskoye',	1,	50215,	'2019-03-16 03:59:51',	'Tymovskoye',	'Tymovskoye',	'Tymovskoye'),
(2121052,	185,	2022888,	'Советская Гавань',	'Sovetskaya Gavan\'',	'Sovetskaya Gavan\'',	1,	47096,	'2019-03-16 03:59:51',	'Sovetskaya Gavan\'',	'Sovetskaya Gavan\'',	'Sovetskaya Gavan\''),
(2121909,	185,	2121529,	'Поронайск',	'Poronaysk',	'Poronaysk',	1,	38827,	'2019-03-16 03:59:51',	'Poronaysk',	'Poronaysk',	'Poronaysk'),
(2122104,	185,	2125072,	'Петропавловск-Камчатский',	'Petropavlovsk-Kamchatskiy',	'Petropavlovsk-Kamchatskiy',	1,	37619,	'2019-03-16 03:59:51',	'Petropavlovsk-Kamchatskiy',	'Petropavlovsk-Kamchatskiy',	'Petropavlovsk-Kamchatskiy'),
(2122850,	185,	2022888,	'Николаевск-на-Амуре',	'Nikolayevsk-na-Amure',	'Nikolayevsk-na-Amure',	1,	34629,	'2019-03-16 03:59:51',	'Nikolayevsk-na-Amure',	'Nikolayevsk-na-Amure',	'Nikolayevsk-na-Amure'),
(2123628,	185,	2123627,	'Магадан',	'Magadan',	'Magadan',	1,	29116,	'2019-03-16 03:59:51',	'Magadan',	'Magadan',	'Magadan'),
(2124286,	185,	2121529,	'Корсаков',	'Korsakov',	'Korsakov',	1,	24815,	'2019-03-16 03:59:51',	'Korsakov',	'Korsakov',	'Korsakov'),
(2124615,	185,	2121529,	'Холмск',	'Kholmsk',	'Kholmsk',	1,	24247,	'2019-03-16 03:59:51',	'Kholmsk',	'Kholmsk',	'Kholmsk'),
(2127154,	185,	2121529,	'Анива',	'Aniva',	'Aniva',	1,	1485,	'2019-03-16 03:59:51',	'Aniva',	'Aniva',	'Aniva'),
(2127202,	185,	2126099,	'Анадырь',	'Anadyr\'',	'Anadyr\'',	1,	1327,	'2019-03-16 03:59:51',	'Anadyr\'',	'Anadyr\'',	'Anadyr\''),
(2127282,	185,	2121529,	'Александровск-Сахалинский',	'Aleksandrovsk-Sakhalinskiy',	'Aleksandrovsk-Sakhalinskiy',	1,	692,	'2019-03-16 03:59:51',	'Aleksandrovsk-Sakhalinskiy',	'Aleksandrovsk-Sakhalinskiy',	'Aleksandrovsk-Sakhalinskiy'),
(2509293,	67,	2593109,	'Zurgena',	'Zurgena',	'Zurgena',	1,	55231,	'2019-03-16 03:59:51',	'Zurgena',	'Zurgena',	'Zurgena'),
(2509305,	67,	2593109,	'Zubia',	'Zubia',	'Zubia',	1,	55221,	'2019-03-16 03:59:51',	'Zubia',	'Zubia',	'Zubia'),
(2509343,	67,	2513413,	'Zarandona',	'Zarandona',	'Zarandona',	1,	55050,	'2019-03-16 03:59:51',	'Zarandona',	'Zarandona',	'Zarandona'),
(2509364,	67,	2593109,	'Zalamea la Real',	'Zalamea la Real',	'Zalamea la Real',	1,	55035,	'2019-03-16 03:59:51',	'Zalamea la Real',	'Zalamea la Real',	'Zalamea la Real'),
(2509365,	67,	2593112,	'Zalamea de la Serena',	'Zalamea de la Serena',	'Zalamea de la Serena',	1,	55034,	'2019-03-16 03:59:51',	'Zalamea de la Serena',	'Zalamea de la Serena',	'Zalamea de la Serena'),
(2509368,	67,	2593112,	'Zahinos',	'Zahinos',	'Zahinos',	1,	55029,	'2019-03-16 03:59:51',	'Zahinos',	'Zahinos',	'Zahinos'),
(2509369,	67,	2593109,	'Саара-де-лос-Атунес',	'Zahara de los Atunes',	'Zahara de los Atunes',	1,	55028,	'2019-03-16 03:59:51',	'Zahara de los Atunes',	'Zahara de los Atunes',	'Zahara de los Atunes'),
(2509377,	67,	2593112,	'Сафра',	'Zafra',	'Zafra',	1,	55025,	'2019-03-16 03:59:51',	'Zafra',	'Zafra',	'Zafra'),
(2509382,	67,	2593109,	'Yunquera',	'Yunquera',	'Yunquera',	1,	54997,	'2019-03-16 03:59:51',	'Yunquera',	'Yunquera',	'Yunquera'),
(2509386,	67,	2593111,	'Yeste',	'Yeste',	'Yeste',	1,	54930,	'2019-03-16 03:59:51',	'Yeste',	'Yeste',	'Yeste'),
(2509389,	67,	2593111,	'Yepes',	'Yepes',	'Yepes',	1,	54924,	'2019-03-16 03:59:51',	'Yepes',	'Yepes',	'Yepes'),
(2509402,	67,	2513413,	'Екла',	'Yecla',	'Yecla',	1,	54900,	'2019-03-16 03:59:51',	'Yecla',	'Yecla',	'Yecla'),
(2509408,	67,	2593110,	'Yaiza',	'Yaiza',	'Yaiza',	1,	54855,	'2019-03-16 03:59:51',	'Yaiza',	'Yaiza',	'Yaiza'),
(2509420,	67,	2593113,	'Viver',	'Viver',	'Viver',	1,	52193,	'2019-03-16 03:59:51',	'Viver',	'Viver',	'Viver'),
(2509463,	67,	2593113,	'Вильена',	'Villena',	'Villena',	1,	51896,	'2019-03-16 03:59:51',	'Villena',	'Villena',	'Villena'),
(2509465,	67,	2593113,	'Villavieja',	'Villavieja',	'Villavieja',	1,	51819,	'2019-03-16 03:59:51',	'Villavieja',	'Villavieja',	'Villavieja'),
(2509468,	67,	2593109,	'Villaverde del Rio',	'Villaverde del Rio',	'Villaverde del Rio',	1,	51814,	'2019-03-16 03:59:51',	'Villaverde del Rio',	'Villaverde del Rio',	'Villaverde del Rio'),
(2509475,	67,	2593111,	'Villatobas',	'Villatobas',	'Villatobas',	1,	51810,	'2019-03-16 03:59:51',	'Villatobas',	'Villatobas',	'Villatobas'),
(2509479,	67,	2593111,	'Villaseca de la Sagra',	'Villaseca de la Sagra',	'Villaseca de la Sagra',	1,	51804,	'2019-03-16 03:59:51',	'Villaseca de la Sagra',	'Villaseca de la Sagra',	'Villaseca de la Sagra'),
(2509480,	67,	2593111,	'Villarta de San Juan',	'Villarta de San Juan',	'Villarta de San Juan',	1,	51801,	'2019-03-16 03:59:51',	'Villarta de San Juan',	'Villarta de San Juan',	'Villarta de San Juan'),
(2509486,	67,	2593111,	'Villarrubia de Santiago',	'Villarrubia de Santiago',	'Villarrubia de Santiago',	1,	51796,	'2019-03-16 03:59:51',	'Villarrubia de Santiago',	'Villarrubia de Santiago',	'Villarrubia de Santiago'),
(2509487,	67,	2593111,	'Villarrubia de los Ojos',	'Villarrubia de los Ojos',	'Villarrubia de los Ojos',	1,	51795,	'2019-03-16 03:59:51',	'Villarrubia de los Ojos',	'Villarrubia de los Ojos',	'Villarrubia de los Ojos'),
(2509488,	67,	2593109,	'Виллариба',	'Villarrubia',	'Villarrubia',	1,	51794,	'2019-03-16 03:59:51',	'Villarrubia',	'Villarrubia',	'Villarrubia'),
(2509491,	67,	2593111,	'Вильярробледо',	'Villarrobledo',	'Villarrobledo',	1,	51792,	'2019-03-16 03:59:51',	'Villarrobledo',	'Villarrobledo',	'Villarrobledo'),
(2509509,	67,	2593113,	'Вила-Реал',	'Vila-real',	'Vila-real',	1,	51606,	'2019-03-16 03:59:51',	'Vila-real',	'Vila-real',	'Vila-real'),
(2509513,	67,	2593112,	'Villar de Rena',	'Villar de Rena',	'Villar de Rena',	1,	51769,	'2019-03-16 03:59:51',	'Villar de Rena',	'Villar de Rena',	'Villar de Rena'),
(2509520,	67,	2593113,	'Villar del Arzobispo',	'Villar del Arzobispo',	'Villar del Arzobispo',	1,	51770,	'2019-03-16 03:59:51',	'Villar del Arzobispo',	'Villar del Arzobispo',	'Villar del Arzobispo'),
(2509544,	67,	2593109,	'Villanueva del Rosario',	'Villanueva del Rosario',	'Villanueva del Rosario',	1,	51760,	'2019-03-16 03:59:51',	'Villanueva del Rosario',	'Villanueva del Rosario',	'Villanueva del Rosario'),
(2509546,	67,	2593109,	'Villanueva del Rio',	'Villanueva del Rio',	'Villanueva del Rio',	1,	51759,	'2019-03-16 03:59:51',	'Villanueva del Rio',	'Villanueva del Rio',	'Villanueva del Rio'),
(2509550,	67,	2593112,	'Villanueva del Fresno',	'Villanueva del Fresno',	'Villanueva del Fresno',	1,	51757,	'2019-03-16 03:59:51',	'Villanueva del Fresno',	'Villanueva del Fresno',	'Villanueva del Fresno'),
(2509553,	67,	2593112,	'Вильянуэва-де-ла-Серена',	'Villanueva de la Serena',	'Villanueva de la Serena',	1,	51752,	'2019-03-16 03:59:51',	'Villanueva de la Serena',	'Villanueva de la Serena',	'Villanueva de la Serena'),
(2509555,	67,	2593109,	'Villanueva del Arzobispo',	'Villanueva del Arzobispo',	'Villanueva del Arzobispo',	1,	51756,	'2019-03-16 03:59:51',	'Villanueva del Arzobispo',	'Villanueva del Arzobispo',	'Villanueva del Arzobispo'),
(2509556,	67,	2593109,	'Villanueva del Ariscal',	'Villanueva del Ariscal',	'Villanueva del Ariscal',	1,	51755,	'2019-03-16 03:59:51',	'Villanueva del Ariscal',	'Villanueva del Ariscal',	'Villanueva del Ariscal'),
(2509558,	67,	2593111,	'Villanueva de la Jara',	'Villanueva de la Jara',	'Villanueva de la Jara',	1,	51751,	'2019-03-16 03:59:51',	'Villanueva de la Jara',	'Villanueva de la Jara',	'Villanueva de la Jara'),
(2509560,	67,	2593111,	'Villanueva de la Fuente',	'Villanueva de la Fuente',	'Villanueva de la Fuente',	1,	51750,	'2019-03-16 03:59:51',	'Villanueva de la Fuente',	'Villanueva de la Fuente',	'Villanueva de la Fuente'),
(2509562,	67,	2593109,	'Villanueva de Cordoba',	'Villanueva de Cordoba',	'Villanueva de Cordoba',	1,	51746,	'2019-03-16 03:59:51',	'Villanueva de Cordoba',	'Villanueva de Cordoba',	'Villanueva de Cordoba'),
(2509564,	67,	2593113,	'Villanueva de Castellon',	'Villanueva de Castellon',	'Villanueva de Castellon',	1,	51745,	'2019-03-16 03:59:51',	'Villanueva de Castellon',	'Villanueva de Castellon',	'Villanueva de Castellon'),
(2509566,	67,	2593109,	'Villanueva de Algaidas',	'Villanueva de Algaidas',	'Villanueva de Algaidas',	1,	51744,	'2019-03-16 03:59:51',	'Villanueva de Algaidas',	'Villanueva de Algaidas',	'Villanueva de Algaidas'),
(2509567,	67,	2593111,	'Villanueva de Alcardete',	'Villanueva de Alcardete',	'Villanueva de Alcardete',	1,	51743,	'2019-03-16 03:59:51',	'Villanueva de Alcardete',	'Villanueva de Alcardete',	'Villanueva de Alcardete'),
(2509568,	67,	2593113,	'Villanueva',	'Villanueva',	'Villanueva',	1,	51741,	'2019-03-16 03:59:51',	'Villanueva',	'Villanueva',	'Villanueva'),
(2509569,	67,	2593111,	'Villamuelas',	'Villamuelas',	'Villamuelas',	1,	51728,	'2019-03-16 03:59:51',	'Villamuelas',	'Villamuelas',	'Villamuelas'),
(2509573,	67,	2593111,	'Villamayor de Santiago',	'Villamayor de Santiago',	'Villamayor de Santiago',	1,	51724,	'2019-03-16 03:59:51',	'Villamayor de Santiago',	'Villamayor de Santiago',	'Villamayor de Santiago'),
(2509575,	67,	2593109,	'Villamartin',	'Villamartin',	'Villamartin',	1,	51721,	'2019-03-16 03:59:51',	'Villamartin',	'Villamartin',	'Villamartin'),
(2509576,	67,	2593113,	'Vilamarxant',	'Vilamarxant',	'Vilamarxant',	1,	51623,	'2019-03-16 03:59:51',	'Vilamarxant',	'Vilamarxant',	'Vilamarxant'),
(2509577,	67,	2593109,	'Villamanrique de la Condesa',	'Villamanrique de la Condesa',	'Villamanrique de la Condesa',	1,	51717,	'2019-03-16 03:59:51',	'Villamanrique de la Condesa',	'Villamanrique de la Condesa',	'Villamanrique de la Condesa'),
(2509580,	67,	2593111,	'Villamalea',	'Villamalea',	'Villamalea',	1,	51716,	'2019-03-16 03:59:51',	'Villamalea',	'Villamalea',	'Villamalea'),
(2509583,	67,	2593113,	'Villalonga',	'Villalonga',	'Villalonga',	1,	51712,	'2019-03-16 03:59:51',	'Villalonga',	'Villalonga',	'Villalonga'),
(2509588,	67,	2593113,	'Villajoyosa',	'Villajoyosa',	'Villajoyosa',	1,	51706,	'2019-03-16 03:59:51',	'Villajoyosa',	'Villajoyosa',	'Villajoyosa'),
(2509589,	67,	2593111,	'Villahermosa',	'Villahermosa',	'Villahermosa',	1,	51702,	'2019-03-16 03:59:51',	'Villahermosa',	'Villahermosa',	'Villahermosa'),
(2509597,	67,	2593111,	'Villafranca de los Caballeros',	'Villafranca de los Caballeros',	'Villafranca de los Caballeros',	1,	51689,	'2019-03-16 03:59:51',	'Villafranca de los Caballeros',	'Villafranca de los Caballeros',	'Villafranca de los Caballeros'),
(2509598,	67,	2593112,	'Villafranca de los Barros',	'Villafranca de los Barros',	'Villafranca de los Barros',	1,	51688,	'2019-03-16 03:59:51',	'Villafranca de los Barros',	'Villafranca de los Barros',	'Villafranca de los Barros'),
(2509599,	67,	2593109,	'Villafranca de Cordoba',	'Villafranca de Cordoba',	'Villafranca de Cordoba',	1,	51687,	'2019-03-16 03:59:51',	'Villafranca de Cordoba',	'Villafranca de Cordoba',	'Villafranca de Cordoba'),
(2509600,	67,	2521383,	'Vilafranca de Bonany',	'Vilafranca de Bonany',	'Vilafranca de Bonany',	1,	51617,	'2019-03-16 03:59:51',	'Vilafranca de Bonany',	'Vilafranca de Bonany',	'Vilafranca de Bonany'),
(2509603,	67,	2593109,	'Villa del Rio',	'Villa del Rio',	'Villa del Rio',	1,	51650,	'2019-03-16 03:59:51',	'Villa del Rio',	'Villa del Rio',	'Villa del Rio'),
(2509605,	67,	2593111,	'Villa de Don Fadrique',	'Villa de Don Fadrique',	'Villa de Don Fadrique',	1,	51646,	'2019-03-16 03:59:51',	'Villa de Don Fadrique',	'Villa de Don Fadrique',	'Villa de Don Fadrique'),
(2509606,	67,	2593109,	'Villacarrillo',	'Villacarrillo',	'Villacarrillo',	1,	51676,	'2019-03-16 03:59:51',	'Villacarrillo',	'Villacarrillo',	'Villacarrillo'),
(2509608,	67,	2593111,	'Villacanas',	'Villacanas',	'Villacanas',	1,	51674,	'2019-03-16 03:59:51',	'Villacanas',	'Villacanas',	'Villacanas'),
(2509650,	67,	2593109,	'Викар',	'Vicar',	'Vicar',	1,	51461,	'2019-03-16 03:59:51',	'Vicar',	'Vicar',	'Vicar'),
(2509660,	67,	2593109,	'Viator',	'Viator',	'Viator',	1,	51449,	'2019-03-16 03:59:51',	'Viator',	'Viator',	'Viator'),
(2509669,	67,	2593113,	'Vergel',	'Vergel',	'Vergel',	1,	51237,	'2019-03-16 03:59:51',	'Vergel',	'Vergel',	'Vergel'),
(2509693,	67,	2593109,	'Vera',	'Vera',	'Vera',	1,	51200,	'2019-03-16 03:59:51',	'Vera',	'Vera',	'Vera'),
(2509710,	67,	2593109,	'Ventas de Huelma',	'Ventas de Huelma',	'Ventas de Huelma',	1,	51180,	'2019-03-16 03:59:51',	'Ventas de Huelma',	'Ventas de Huelma',	'Ventas de Huelma'),
(2509769,	67,	2593109,	'Велес-Малага',	'Velez-Malaga',	'Velez-Malaga',	1,	51094,	'2019-03-16 03:59:51',	'Velez-Malaga',	'Velez-Malaga',	'Velez-Malaga'),
(2509771,	67,	2593109,	'Velez de Benaudalla',	'Velez de Benaudalla',	'Velez de Benaudalla',	1,	51093,	'2019-03-16 03:59:51',	'Velez de Benaudalla',	'Velez de Benaudalla',	'Velez de Benaudalla'),
(2509783,	67,	2593109,	'Vejer de la Frontera',	'Vejer de la Frontera',	'Vejer de la Frontera',	1,	51080,	'2019-03-16 03:59:51',	'Vejer de la Frontera',	'Vejer de la Frontera',	'Vejer de la Frontera'),
(2509799,	67,	2593110,	'Vega de San Mateo',	'Vega de San Mateo',	'Vega de San Mateo',	1,	51065,	'2019-03-16 03:59:51',	'Vega de San Mateo',	'Vega de San Mateo',	'Vega de San Mateo'),
(2509801,	67,	2593109,	'Vega de los Hatos',	'Vega de los Hatos',	'Vega de los Hatos',	1,	51064,	'2019-03-16 03:59:51',	'Vega de los Hatos',	'Vega de los Hatos',	'Vega de los Hatos'),
(2509819,	67,	2593111,	'Vara de Rey',	'Vara de Rey',	'Vara de Rey',	1,	50907,	'2019-03-16 03:59:51',	'Vara de Rey',	'Vara de Rey',	'Vara de Rey'),
(2509835,	67,	2593109,	'Valverde del Camino',	'Valverde del Camino',	'Valverde del Camino',	1,	50858,	'2019-03-16 03:59:51',	'Valverde del Camino',	'Valverde del Camino',	'Valverde del Camino'),
(2509846,	67,	2593110,	'Valsequillo de Gran Canaria',	'Valsequillo de Gran Canaria',	'Valsequillo de Gran Canaria',	1,	50852,	'2019-03-16 03:59:51',	'Valsequillo de Gran Canaria',	'Valsequillo de Gran Canaria',	'Valsequillo de Gran Canaria'),
(2509864,	67,	2593110,	'Valleseco',	'Valleseco',	'Valleseco',	1,	50781,	'2019-03-16 03:59:51',	'Valleseco',	'Valleseco',	'Valleseco'),
(2509869,	67,	2593113,	'Valles',	'Valles',	'Valles',	1,	50779,	'2019-03-16 03:59:51',	'Valles',	'Valles',	'Valles'),
(2509934,	67,	2593113,	'Vallada',	'Vallada',	'Vallada',	1,	50750,	'2019-03-16 03:59:51',	'Vallada',	'Vallada',	'Vallada'),
(2509939,	67,	2593111,	'Valeria',	'Valeria',	'Valeria',	1,	50731,	'2019-03-16 03:59:51',	'Valeria',	'Valeria',	'Valeria'),
(2509944,	67,	2593109,	'Valenzuela',	'Valenzuela',	'Valenzuela',	1,	50729,	'2019-03-16 03:59:51',	'Valenzuela',	'Valenzuela',	'Valenzuela'),
(2509946,	67,	2593109,	'Valencina de la Concepcion',	'Valencina de la Concepcion',	'Valencina de la Concepcion',	1,	50721,	'2019-03-16 03:59:51',	'Valencina de la Concepcion',	'Valencina de la Concepcion',	'Valencina de la Concepcion'),
(2509948,	67,	2593112,	'Valencia del Mombuey',	'Valencia del Mombuey',	'Valencia del Mombuey',	1,	50718,	'2019-03-16 03:59:51',	'Valencia del Mombuey',	'Valencia del Mombuey',	'Valencia del Mombuey'),
(2509950,	67,	2593112,	'Валенсия-де-Алькантара',	'Valencia de Alcantara',	'Valencia de Alcantara',	1,	50716,	'2019-03-16 03:59:51',	'Valencia de Alcantara',	'Valencia de Alcantara',	'Valencia de Alcantara'),
(2509954,	67,	2593113,	'Валенсия',	'Valencia',	'Valencia',	1,	50713,	'2019-03-16 03:59:51',	'Valencia',	'Valencia',	'Valencia'),
(2509982,	67,	2593111,	'Вальдепеньясе',	'Valdepenas',	'Valdepenas',	1,	50687,	'2019-03-16 03:59:51',	'Valdepenas',	'Valdepenas',	'Valdepenas'),
(2510073,	67,	2593109,	'Утрера',	'Utrera',	'Utrera',	1,	50589,	'2019-03-16 03:59:51',	'Utrera',	'Utrera',	'Utrera'),
(2510075,	67,	2593113,	'Utiel',	'Utiel',	'Utiel',	1,	50587,	'2019-03-16 03:59:51',	'Utiel',	'Utiel',	'Utiel'),
(2510083,	67,	2593111,	'Urda',	'Urda',	'Urda',	1,	50516,	'2019-03-16 03:59:51',	'Urda',	'Urda',	'Urda'),
(2510098,	67,	2593109,	'Umbrete',	'Umbrete',	'Umbrete',	1,	50329,	'2019-03-16 03:59:51',	'Umbrete',	'Umbrete',	'Umbrete'),
(2510102,	67,	2513413,	'Ulea',	'Ulea',	'Ulea',	1,	50300,	'2019-03-16 03:59:51',	'Ulea',	'Ulea',	'Ulea'),
(2510112,	67,	2593109,	'Ubrique',	'Ubrique',	'Ubrique',	1,	50235,	'2019-03-16 03:59:51',	'Ubrique',	'Ubrique',	'Ubrique'),
(2510116,	67,	2593109,	'Убеда',	'Ubeda',	'Ubeda',	1,	50228,	'2019-03-16 03:59:51',	'Ubeda',	'Ubeda',	'Ubeda'),
(2510124,	67,	2593109,	'Turre',	'Turre',	'Turre',	1,	50146,	'2019-03-16 03:59:51',	'Turre',	'Turre',	'Turre'),
(2510128,	67,	2593113,	'Turis',	'Turis',	'Turis',	1,	50133,	'2019-03-16 03:59:51',	'Turis',	'Turis',	'Turis'),
(2510145,	67,	2593112,	'Trujillo',	'Trujillo',	'Trujillo',	1,	50036,	'2019-03-16 03:59:51',	'Trujillo',	'Trujillo',	'Trujillo'),
(2510165,	67,	2593109,	'Trigueros',	'Trigueros',	'Trigueros',	1,	49925,	'2019-03-16 03:59:51',	'Trigueros',	'Trigueros',	'Trigueros'),
(2510171,	67,	2593110,	'Triana',	'Triana',	'Triana',	1,	49899,	'2019-03-16 03:59:51',	'Triana',	'Triana',	'Triana'),
(2510175,	67,	2593109,	'Trevelez',	'Trevelez',	'Trevelez',	1,	49871,	'2019-03-16 03:59:51',	'Trevelez',	'Trevelez',	'Trevelez'),
(2510186,	67,	2593109,	'Trebujena',	'Trebujena',	'Trebujena',	1,	49761,	'2019-03-16 03:59:51',	'Trebujena',	'Trebujena',	'Trebujena'),
(2510224,	67,	2513413,	'Тотана',	'Totana',	'Totana',	1,	49579,	'2019-03-16 03:59:51',	'Totana',	'Totana',	'Totana'),
(2510225,	67,	2593110,	'Toston',	'Toston',	'Toston',	1,	49578,	'2019-03-16 03:59:51',	'Toston',	'Toston',	'Toston'),
(2510237,	67,	2593111,	'Tortola',	'Tortola',	'Tortola',	1,	49561,	'2019-03-16 03:59:51',	'Tortola',	'Tortola',	'Tortola'),
(2510245,	67,	2593109,	'Torrox',	'Torrox',	'Torrox',	1,	49555,	'2019-03-16 03:59:51',	'Torrox',	'Torrox',	'Torrox'),
(2510249,	67,	2593111,	'Torrijos',	'Torrijos',	'Torrijos',	1,	49547,	'2019-03-16 03:59:51',	'Torrijos',	'Torrijos',	'Torrijos'),
(2510253,	67,	2593113,	'Торревьеха',	'Torrevieja',	'Torrevieja',	1,	49538,	'2019-03-16 03:59:51',	'Torrevieja',	'Torrevieja',	'Torrevieja'),
(2510258,	67,	2593113,	'Torres-Torres',	'Torres-Torres',	'Torres-Torres',	1,	49536,	'2019-03-16 03:59:51',	'Torres-Torres',	'Torres-Torres',	'Torres-Torres'),
(2510268,	67,	2593112,	'Torrequemada',	'Torrequemada',	'Torrequemada',	1,	49531,	'2019-03-16 03:59:51',	'Torrequemada',	'Torrequemada',	'Torrequemada'),
(2510270,	67,	2593109,	'Torreperogil',	'Torreperogil',	'Torreperogil',	1,	49530,	'2019-03-16 03:59:51',	'Torreperogil',	'Torreperogil',	'Torreperogil'),
(2510271,	67,	2513413,	'Торре-Пачеко',	'Torre-Pacheco',	'Torre-Pacheco',	1,	49499,	'2019-03-16 03:59:51',	'Torre-Pacheco',	'Torre-Pacheco',	'Torre-Pacheco'),
(2510274,	67,	2593111,	'Torrenueva',	'Torrenueva',	'Torrenueva',	1,	49527,	'2019-03-16 03:59:51',	'Torrenueva',	'Torrenueva',	'Torrenueva'),
(2510275,	67,	2593109,	'Torrenueva',	'Torrenueva',	'Torrenueva',	1,	49528,	'2019-03-16 03:59:51',	'Torrenueva',	'Torrenueva',	'Torrenueva'),
(2510279,	67,	2593113,	'Torrent',	'Torrent',	'Torrent',	1,	49526,	'2019-03-16 03:59:51',	'Torrent',	'Torrent',	'Torrent'),
(2510281,	67,	2593109,	'Торремолинос',	'Torremolinos',	'Torremolinos',	1,	49524,	'2019-03-16 03:59:51',	'Torremolinos',	'Torremolinos',	'Torremolinos'),
(2510287,	67,	2593112,	'Torremayor',	'Torremayor',	'Torremayor',	1,	49522,	'2019-03-16 03:59:51',	'Torremayor',	'Torremayor',	'Torremayor'),
(2510288,	67,	2593113,	'Torremanzanas',	'Torremanzanas',	'Torremanzanas',	1,	49521,	'2019-03-16 03:59:51',	'Torremanzanas',	'Torremanzanas',	'Torremanzanas'),
(2510301,	67,	2593109,	'Torredonjimeno',	'Torredonjimeno',	'Torredonjimeno',	1,	49507,	'2019-03-16 03:59:51',	'Torredonjimeno',	'Torredonjimeno',	'Torredonjimeno'),
(2510309,	67,	2593109,	'Torre del Mar',	'Torre del Mar',	'Torre del Mar',	1,	49493,	'2019-03-16 03:59:51',	'Torre del Mar',	'Torre del Mar',	'Torre del Mar'),
(2510310,	67,	2593109,	'Torre del Campo',	'Torre del Campo',	'Torre del Campo',	1,	49490,	'2019-03-16 03:59:51',	'Torre del Campo',	'Torre del Campo',	'Torre del Campo'),
(2510338,	67,	2513413,	'Torreaguera',	'Torreaguera',	'Torreaguera',	1,	49500,	'2019-03-16 03:59:51',	'Torreaguera',	'Torreaguera',	'Torreaguera'),
(2510349,	67,	2593111,	'Torralba de Calatrava',	'Torralba de Calatrava',	'Torralba de Calatrava',	1,	49476,	'2019-03-16 03:59:51',	'Torralba de Calatrava',	'Torralba de Calatrava',	'Torralba de Calatrava'),
(2510364,	67,	2593113,	'Tormos',	'Tormos',	'Tormos',	1,	49460,	'2019-03-16 03:59:51',	'Tormos',	'Tormos',	'Tormos'),
(2510392,	67,	2593111,	'Томельосо',	'Tomelloso',	'Tomelloso',	1,	49381,	'2019-03-16 03:59:51',	'Tomelloso',	'Tomelloso',	'Tomelloso'),
(2510394,	67,	2593109,	'Tomares',	'Tomares',	'Tomares',	1,	49375,	'2019-03-16 03:59:51',	'Tomares',	'Tomares',	'Tomares'),
(2510398,	67,	2593109,	'Tolox',	'Tolox',	'Tolox',	1,	49370,	'2019-03-16 03:59:51',	'Tolox',	'Tolox',	'Tolox'),
(2510409,	67,	2593111,	'Толедо',	'Toledo',	'Toledo',	1,	49349,	'2019-03-16 03:59:51',	'Toledo',	'Toledo',	'Toledo'),
(2510418,	67,	2593109,	'Tocon',	'Tocon',	'Tocon',	1,	49326,	'2019-03-16 03:59:51',	'Tocon',	'Tocon',	'Tocon'),
(2510419,	67,	2593109,	'Tocina',	'Tocina',	'Tocina',	1,	49325,	'2019-03-16 03:59:51',	'Tocina',	'Tocina',	'Tocina'),
(2510426,	67,	2593111,	'Tobarra',	'Tobarra',	'Tobarra',	1,	49320,	'2019-03-16 03:59:51',	'Tobarra',	'Tobarra',	'Tobarra'),
(2510430,	67,	2593113,	'Titaguas',	'Titaguas',	'Titaguas',	1,	49297,	'2019-03-16 03:59:51',	'Titaguas',	'Titaguas',	'Titaguas'),
(2510468,	67,	2593110,	'Tijarafe',	'Tijarafe',	'Tijarafe',	1,	49203,	'2019-03-16 03:59:51',	'Tijarafe',	'Tijarafe',	'Tijarafe'),
(2510473,	67,	2593110,	'Tigaiga',	'Tigaiga',	'Tigaiga',	1,	49192,	'2019-03-16 03:59:51',	'Tigaiga',	'Tigaiga',	'Tigaiga'),
(2510484,	67,	2593113,	'Tibi',	'Tibi',	'Tibi',	1,	49164,	'2019-03-16 03:59:51',	'Tibi',	'Tibi',	'Tibi'),
(2510485,	67,	2593110,	'Tias',	'Tias',	'Tias',	1,	49163,	'2019-03-16 03:59:51',	'Tias',	'Tias',	'Tias'),
(2510488,	67,	2593113,	'Teulada',	'Teulada',	'Teulada',	1,	48880,	'2019-03-16 03:59:51',	'Teulada',	'Teulada',	'Teulada'),
(2510508,	67,	2593110,	'Teror',	'Teror',	'Teror',	1,	48825,	'2019-03-16 03:59:51',	'Teror',	'Teror',	'Teror'),
(2510520,	67,	2593113,	'Teresa de Cofrentes',	'Teresa de Cofrentes',	'Teresa de Cofrentes',	1,	48807,	'2019-03-16 03:59:51',	'Teresa de Cofrentes',	'Teresa de Cofrentes',	'Teresa de Cofrentes'),
(2510524,	67,	2593110,	'Tenteniguada',	'Tenteniguada',	'Tenteniguada',	1,	48796,	'2019-03-16 03:59:51',	'Tenteniguada',	'Tenteniguada',	'Tenteniguada'),
(2510542,	67,	2593110,	'Тельде',	'Telde',	'Telde',	1,	48732,	'2019-03-16 03:59:51',	'Telde',	'Telde',	'Telde'),
(2510550,	67,	2593110,	'Tejina',	'Tejina',	'Tejina',	1,	48727,	'2019-03-16 03:59:51',	'Tejina',	'Tejina',	'Tejina'),
(2510573,	67,	2593110,	'Teguise',	'Teguise',	'Teguise',	1,	48711,	'2019-03-16 03:59:51',	'Teguise',	'Teguise',	'Teguise'),
(2510574,	67,	2593110,	'Tegueste',	'Tegueste',	'Tegueste',	1,	48710,	'2019-03-16 03:59:51',	'Tegueste',	'Tegueste',	'Tegueste'),
(2510580,	67,	2593109,	'Teba',	'Teba',	'Teba',	1,	48695,	'2019-03-16 03:59:51',	'Teba',	'Teba',	'Teba'),
(2510582,	67,	2593110,	'Tazacorte',	'Tazacorte',	'Tazacorte',	1,	48685,	'2019-03-16 03:59:51',	'Tazacorte',	'Tazacorte',	'Tazacorte'),
(2510599,	67,	2593109,	'Тарифа',	'Tarifa',	'Tarifa',	1,	48572,	'2019-03-16 03:59:51',	'Tarifa',	'Tarifa',	'Tarifa'),
(2510667,	67,	2593110,	'Tamaraceite',	'Tamaraceite',	'Tamaraceite',	1,	48504,	'2019-03-16 03:59:51',	'Tamaraceite',	'Tamaraceite',	'Tamaraceite'),
(2510686,	67,	2593113,	'Tales',	'Tales',	'Tales',	1,	48467,	'2019-03-16 03:59:51',	'Tales',	'Tales',	'Tales'),
(2510689,	67,	2593112,	'Talayuela',	'Talayuela',	'Talayuela',	1,	48457,	'2019-03-16 03:59:51',	'Talayuela',	'Talayuela',	'Talayuela'),
(2510693,	67,	2593111,	'Талавера де ла Рейна',	'Talavera de la Reina',	'Talavera de la Reina',	1,	48456,	'2019-03-16 03:59:51',	'Talavera de la Reina',	'Talavera de la Reina',	'Talavera de la Reina'),
(2510715,	67,	2593110,	'Tahiche',	'Tahiche',	'Tahiche',	1,	48428,	'2019-03-16 03:59:51',	'Tahiche',	'Tahiche',	'Tahiche'),
(2510725,	67,	2593110,	'Tacoronte',	'Tacoronte',	'Tacoronte',	1,	48404,	'2019-03-16 03:59:51',	'Tacoronte',	'Tacoronte',	'Tacoronte'),
(2510746,	67,	2593109,	'Tabernas',	'Tabernas',	'Tabernas',	1,	48390,	'2019-03-16 03:59:51',	'Tabernas',	'Tabernas',	'Tabernas'),
(2510764,	67,	2593113,	'Sueca',	'Sueca',	'Sueca',	1,	48035,	'2019-03-16 03:59:51',	'Sueca',	'Sueca',	'Sueca'),
(2510787,	67,	2593109,	'Sorihuela del Guadalimar',	'Sorihuela del Guadalimar',	'Sorihuela del Guadalimar',	1,	46835,	'2019-03-16 03:59:51',	'Sorihuela del Guadalimar',	'Sorihuela del Guadalimar',	'Sorihuela del Guadalimar'),
(2510799,	67,	2521383,	'Son Servera',	'Son Servera',	'Son Servera',	1,	46777,	'2019-03-16 03:59:51',	'Son Servera',	'Son Servera',	'Son Servera'),
(2510801,	67,	2593111,	'Sonseca',	'Sonseca',	'Sonseca',	1,	46800,	'2019-03-16 03:59:51',	'Sonseca',	'Sonseca',	'Sonseca'),
(2510809,	67,	2593113,	'Soneja',	'Soneja',	'Soneja',	1,	46784,	'2019-03-16 03:59:51',	'Soneja',	'Soneja',	'Soneja'),
(2510810,	67,	2521383,	'Son Curt',	'Son Curt',	'Son Curt',	1,	46776,	'2019-03-16 03:59:51',	'Son Curt',	'Son Curt',	'Son Curt'),
(2510821,	67,	2521383,	'Сольер',	'Soller',	'Soller',	1,	46688,	'2019-03-16 03:59:51',	'Soller',	'Soller',	'Soller'),
(2510822,	67,	2593113,	'Sollana',	'Sollana',	'Sollana',	1,	46686,	'2019-03-16 03:59:51',	'Sollana',	'Sollana',	'Sollana'),
(2510852,	67,	2593111,	'Socuellamos',	'Socuellamos',	'Socuellamos',	1,	46614,	'2019-03-16 03:59:51',	'Socuellamos',	'Socuellamos',	'Socuellamos'),
(2510858,	67,	2593110,	'Sobradillo',	'Sobradillo',	'Sobradillo',	1,	46607,	'2019-03-16 03:59:51',	'Sobradillo',	'Sobradillo',	'Sobradillo'),
(2510860,	67,	2513413,	'Siscar',	'Siscar',	'Siscar',	1,	46432,	'2019-03-16 03:59:51',	'Siscar',	'Siscar',	'Siscar'),
(2510869,	67,	2593113,	'Sinarcas',	'Sinarcas',	'Sinarcas',	1,	46389,	'2019-03-16 03:59:51',	'Sinarcas',	'Sinarcas',	'Sinarcas'),
(2510880,	67,	2593113,	'Silla',	'Silla',	'Silla',	1,	46300,	'2019-03-16 03:59:51',	'Silla',	'Silla',	'Silla'),
(2510889,	67,	2593113,	'Siete Aguas',	'Siete Aguas',	'Siete Aguas',	1,	46256,	'2019-03-16 03:59:51',	'Siete Aguas',	'Siete Aguas',	'Siete Aguas'),
(2510896,	67,	2593112,	'Sierra de Fuentes',	'Sierra de Fuentes',	'Sierra de Fuentes',	1,	46248,	'2019-03-16 03:59:51',	'Sierra de Fuentes',	'Sierra de Fuentes',	'Sierra de Fuentes'),
(2510911,	67,	2593109,	'Севилья',	'Sevilla',	'Sevilla',	1,	45879,	'2019-03-16 03:59:51',	'Sevilla',	'Sevilla',	'Sevilla'),
(2510919,	67,	2521383,	'Ses Salines',	'Ses Salines',	'Ses Salines',	1,	45830,	'2019-03-16 03:59:51',	'Ses Salines',	'Ses Salines',	'Ses Salines'),
(2510936,	67,	2593112,	'Serradilla',	'Serradilla',	'Serradilla',	1,	45795,	'2019-03-16 03:59:51',	'Serradilla',	'Serradilla',	'Serradilla'),
(2510940,	67,	2593113,	'Serra',	'Serra',	'Serra',	1,	45789,	'2019-03-16 03:59:51',	'Serra',	'Serra',	'Serra'),
(2510947,	67,	2593109,	'Serena',	'Serena',	'Serena',	1,	45753,	'2019-03-16 03:59:51',	'Serena',	'Serena',	'Serena'),
(2510961,	67,	2521383,	'Selva',	'Selva',	'Selva',	1,	45646,	'2019-03-16 03:59:51',	'Selva',	'Selva',	'Selva'),
(2510967,	67,	2593112,	'Segura de Leon',	'Segura de Leon',	'Segura de Leon',	1,	45567,	'2019-03-16 03:59:51',	'Segura de Leon',	'Segura de Leon',	'Segura de Leon'),
(2510972,	67,	2593113,	'Segorbe',	'Segorbe',	'Segorbe',	1,	45560,	'2019-03-16 03:59:51',	'Segorbe',	'Segorbe',	'Segorbe'),
(2510975,	67,	2593113,	'Sedavi',	'Sedavi',	'Sedavi',	1,	45497,	'2019-03-16 03:59:51',	'Sedavi',	'Sedavi',	'Sedavi'),
(2511010,	67,	2593113,	'Sax',	'Sax',	'Sax',	1,	44927,	'2019-03-16 03:59:51',	'Sax',	'Sax',	'Sax'),
(2511012,	67,	2593110,	'Sauzal',	'Sauzal',	'Sauzal',	1,	44858,	'2019-03-16 03:59:51',	'Sauzal',	'Sauzal',	'Sauzal'),
(2511026,	67,	2593110,	'Sardina',	'Sardina',	'Sardina',	1,	44682,	'2019-03-16 03:59:51',	'Sardina',	'Sardina',	'Sardina'),
(2511032,	67,	2593113,	'San Vicent del Raspeig',	'San Vicent del Raspeig',	'San Vicent del Raspeig',	1,	44270,	'2019-03-16 03:59:51',	'San Vicent del Raspeig',	'San Vicent del Raspeig',	'San Vicent del Raspeig'),
(2511033,	67,	2593112,	'San Vicente de Alcantara',	'San Vicente de Alcantara',	'San Vicente de Alcantara',	1,	44272,	'2019-03-16 03:59:51',	'San Vicente de Alcantara',	'San Vicente de Alcantara',	'San Vicente de Alcantara'),
(2511050,	67,	2513413,	'Santomera',	'Santomera',	'Santomera',	1,	44636,	'2019-03-16 03:59:51',	'Santomera',	'Santomera',	'Santomera'),
(2511062,	67,	2521383,	'Sant Jordi',	'Sant Jordi',	'Sant Jordi',	1,	44440,	'2019-03-16 03:59:51',	'Sant Jordi',	'Sant Jordi',	'Sant Jordi'),
(2511063,	67,	2593109,	'Santisteban del Puerto',	'Santisteban del Puerto',	'Santisteban del Puerto',	1,	44622,	'2019-03-16 03:59:51',	'Santisteban del Puerto',	'Santisteban del Puerto',	'Santisteban del Puerto'),
(2511064,	67,	2593109,	'Santiponce',	'Santiponce',	'Santiponce',	1,	44621,	'2019-03-16 03:59:51',	'Santiponce',	'Santiponce',	'Santiponce'),
(2511072,	67,	2513413,	'Santiago de la Ribera',	'Santiago de la Ribera',	'Santiago de la Ribera',	1,	44619,	'2019-03-16 03:59:51',	'Santiago de la Ribera',	'Santiago de la Ribera',	'Santiago de la Ribera'),
(2511091,	67,	2593110,	'Santa Ursula',	'Santa Ursula',	'Santa Ursula',	1,	44587,	'2019-03-16 03:59:51',	'Santa Ursula',	'Santa Ursula',	'Santa Ursula'),
(2511102,	67,	2593113,	'Санта-Пола',	'Santa Pola',	'Santa Pola',	1,	44577,	'2019-03-16 03:59:51',	'Santa Pola',	'Santa Pola',	'Santa Pola'),
(2511106,	67,	2521383,	'Santanyi',	'Santanyi',	'Santanyi',	1,	44602,	'2019-03-16 03:59:51',	'Santanyi',	'Santanyi',	'Santanyi'),
(2511112,	67,	2593112,	'Santa Marta',	'Santa Marta',	'Santa Marta',	1,	44567,	'2019-03-16 03:59:51',	'Santa Marta',	'Santa Marta',	'Santa Marta'),
(2511140,	67,	2593112,	'Santa Maria',	'Santa Maria',	'Santa Maria',	1,	44546,	'2019-03-16 03:59:51',	'Santa Maria',	'Santa Maria',	'Santa Maria'),
(2511150,	67,	2593110,	'Santa Lucia',	'Santa Lucia',	'Santa Lucia',	1,	44540,	'2019-03-16 03:59:51',	'Santa Lucia',	'Santa Lucia',	'Santa Lucia'),
(2511158,	67,	2593109,	'Santa Fe de Mondujar',	'Santa Fe de Mondujar',	'Santa Fe de Mondujar',	1,	44529,	'2019-03-16 03:59:51',	'Santa Fe de Mondujar',	'Santa Fe de Mondujar',	'Santa Fe de Mondujar'),
(2511160,	67,	2593109,	'Santafe',	'Santafe',	'Santafe',	1,	44599,	'2019-03-16 03:59:51',	'Santafe',	'Santafe',	'Santafe'),
(2511162,	67,	2521383,	'Santa Eularia des Riu',	'Santa Eularia des Riu',	'Santa Eularia des Riu',	1,	44526,	'2019-03-16 03:59:51',	'Santa Eularia des Riu',	'Santa Eularia des Riu',	'Santa Eularia des Riu'),
(2511170,	67,	2593109,	'Santaella',	'Santaella',	'Santaella',	1,	44598,	'2019-03-16 03:59:51',	'Santaella',	'Santaella',	'Santaella'),
(2511174,	67,	2593110,	'Санта-Крус-де-Тенерифе',	'Santa Cruz de Tenerife',	'Santa Cruz de Tenerife',	1,	44523,	'2019-03-16 03:59:51',	'Santa Cruz de Tenerife',	'Santa Cruz de Tenerife',	'Santa Cruz de Tenerife'),
(2511175,	67,	2593111,	'Santa Cruz de Mudela',	'Santa Cruz de Mudela',	'Santa Cruz de Mudela',	1,	44522,	'2019-03-16 03:59:51',	'Santa Cruz de Mudela',	'Santa Cruz de Mudela',	'Santa Cruz de Mudela'),
(2511178,	67,	2593111,	'Santa Cruz de la Zarza',	'Santa Cruz de la Zarza',	'Santa Cruz de la Zarza',	1,	44521,	'2019-03-16 03:59:51',	'Santa Cruz de la Zarza',	'Santa Cruz de la Zarza',	'Santa Cruz de la Zarza'),
(2511180,	67,	2593110,	'Santa Cruz de la Palma',	'Santa Cruz de la Palma',	'Santa Cruz de la Palma',	1,	44520,	'2019-03-16 03:59:51',	'Santa Cruz de la Palma',	'Santa Cruz de la Palma',	'Santa Cruz de la Palma'),
(2511202,	67,	2593110,	'Santa Brigida',	'Santa Brigida',	'Santa Brigida',	1,	44497,	'2019-03-16 03:59:51',	'Santa Brigida',	'Santa Brigida',	'Santa Brigida'),
(2511220,	67,	2513413,	'Santa Ana',	'Santa Ana',	'Santa Ana',	1,	44492,	'2019-03-16 03:59:51',	'Santa Ana',	'Santa Ana',	'Santa Ana'),
(2511230,	67,	2593110,	'Сан Себастьян де Гомера',	'San Sebastian de la Gomera',	'San Sebastian de la Gomera',	1,	44249,	'2019-03-16 03:59:51',	'San Sebastian de la Gomera',	'San Sebastian de la Gomera',	'San Sebastian de la Gomera'),
(2511239,	67,	2593109,	'San Roque',	'San Roque',	'San Roque',	1,	44242,	'2019-03-16 03:59:51',	'San Roque',	'San Roque',	'San Roque'),
(2511247,	67,	2513413,	'San Pedro del Pinatar',	'San Pedro del Pinatar',	'San Pedro del Pinatar',	1,	44202,	'2019-03-16 03:59:51',	'San Pedro del Pinatar',	'San Pedro del Pinatar',	'San Pedro del Pinatar'),
(2511250,	67,	2593109,	'San Pedro de Alcantara',	'San Pedro de Alcantara',	'San Pedro de Alcantara',	1,	44201,	'2019-03-16 03:59:51',	'San Pedro de Alcantara',	'San Pedro de Alcantara',	'San Pedro de Alcantara'),
(2511267,	67,	2593109,	'San Pedro',	'San Pedro',	'San Pedro',	1,	44199,	'2019-03-16 03:59:51',	'San Pedro',	'San Pedro',	'San Pedro'),
(2511273,	67,	2593109,	'San Pablo',	'San Pablo',	'San Pablo',	1,	44192,	'2019-03-16 03:59:51',	'San Pablo',	'San Pablo',	'San Pablo'),
(2511277,	67,	2593113,	'Сан Мигуэль',	'San Miguel de Salinas',	'San Miguel de Salinas',	1,	44180,	'2019-03-16 03:59:51',	'San Miguel de Salinas',	'San Miguel de Salinas',	'San Miguel de Salinas'),
(2511284,	67,	2521383,	'Sant Miquel de Balansat',	'Sant Miquel de Balansat',	'Sant Miquel de Balansat',	1,	44444,	'2019-03-16 03:59:51',	'Sant Miquel de Balansat',	'Sant Miquel de Balansat',	'Sant Miquel de Balansat'),
(2511287,	67,	2593110,	'San Miguel',	'San Miguel',	'San Miguel',	1,	44178,	'2019-03-16 03:59:51',	'San Miguel',	'San Miguel',	'San Miguel'),
(2511297,	67,	2593109,	'San Martin',	'San Martin',	'San Martin',	1,	44144,	'2019-03-16 03:59:51',	'San Martin',	'San Martin',	'San Martin'),
(2511301,	67,	2593109,	'San Luis de Sabinillas',	'San Luis de Sabinillas',	'San Luis de Sabinillas',	1,	44128,	'2019-03-16 03:59:51',	'San Luis de Sabinillas',	'San Luis de Sabinillas',	'San Luis de Sabinillas'),
(2511304,	67,	2593109,	'Sanlucar la Mayor',	'Sanlucar la Mayor',	'Sanlucar la Mayor',	1,	44414,	'2019-03-16 03:59:51',	'Sanlucar la Mayor',	'Sanlucar la Mayor',	'Sanlucar la Mayor'),
(2511326,	67,	2593109,	'San Juan del Puerto',	'San Juan del Puerto',	'San Juan del Puerto',	1,	44108,	'2019-03-16 03:59:51',	'San Juan del Puerto',	'San Juan del Puerto',	'San Juan del Puerto'),
(2511329,	67,	2593109,	'San Juan de Aznalfarache',	'San Juan de Aznalfarache',	'San Juan de Aznalfarache',	1,	44105,	'2019-03-16 03:59:51',	'San Juan de Aznalfarache',	'San Juan de Aznalfarache',	'San Juan de Aznalfarache'),
(2511330,	67,	2593113,	'San Juan de Alicante',	'San Juan de Alicante',	'San Juan de Alicante',	1,	44104,	'2019-03-16 03:59:51',	'San Juan de Alicante',	'San Juan de Alicante',	'San Juan de Alicante'),
(2511349,	67,	2593113,	'San Juan',	'San Juan',	'San Juan',	1,	44101,	'2019-03-16 03:59:51',	'San Juan',	'San Juan',	'San Juan'),
(2511352,	67,	2521383,	'Sant Josep de sa Talaia',	'Sant Josep de sa Talaia',	'Sant Josep de sa Talaia',	1,	44441,	'2019-03-16 03:59:51',	'Sant Josep de sa Talaia',	'Sant Josep de sa Talaia',	'Sant Josep de sa Talaia'),
(2511357,	67,	2593109,	'San Jose',	'San Jose',	'San Jose',	1,	44096,	'2019-03-16 03:59:51',	'San Jose',	'San Jose',	'San Jose'),
(2511361,	67,	2593113,	'San Jorge',	'San Jorge',	'San Jorge',	1,	44095,	'2019-03-16 03:59:51',	'San Jorge',	'San Jorge',	'San Jorge'),
(2511366,	67,	2513413,	'San Javier',	'San Javier',	'San Javier',	1,	44092,	'2019-03-16 03:59:51',	'San Javier',	'San Javier',	'San Javier'),
(2511371,	67,	2593110,	'Сан Исидро',	'San Isidro',	'San Isidro',	1,	44090,	'2019-03-16 03:59:51',	'San Isidro',	'San Isidro',	'San Isidro'),
(2511376,	67,	2513413,	'Sangonera la Verde',	'Sangonera la Verde',	'Sangonera la Verde',	1,	44389,	'2019-03-16 03:59:51',	'Sangonera la Verde',	'Sangonera la Verde',	'Sangonera la Verde'),
(2511381,	67,	2521383,	'Sant Francesc de Formentera',	'Sant Francesc de Formentera',	'Sant Francesc de Formentera',	1,	44434,	'2019-03-16 03:59:51',	'Sant Francesc de Formentera',	'Sant Francesc de Formentera',	'Sant Francesc de Formentera'),
(2511388,	67,	2593109,	'Сан-Фернандо',	'San Fernando',	'San Fernando',	1,	44019,	'2019-03-16 03:59:51',	'San Fernando',	'San Fernando',	'San Fernando'),
(2511389,	67,	2593110,	'San Fernando',	'San Fernando',	'San Fernando',	1,	44020,	'2019-03-16 03:59:51',	'San Fernando',	'San Fernando',	'San Fernando'),
(2511401,	67,	2593110,	'Ла-Лагуна',	'La Laguna',	'La Laguna',	1,	25402,	'2019-03-16 03:59:51',	'La Laguna',	'La Laguna',	'La Laguna'),
(2511411,	67,	2593111,	'San Clemente',	'San Clemente',	'San Clemente',	1,	43988,	'2019-03-16 03:59:51',	'San Clemente',	'San Clemente',	'San Clemente'),
(2511440,	67,	2593110,	'San Bartolome',	'San Bartolome',	'San Bartolome',	1,	43953,	'2019-03-16 03:59:51',	'San Bartolome',	'San Bartolome',	'San Bartolome'),
(2511441,	67,	2593109,	'San Bartolome de la Torre',	'San Bartolome de la Torre',	'San Bartolome de la Torre',	1,	43954,	'2019-03-16 03:59:51',	'San Bartolome de la Torre',	'San Bartolome de la Torre',	'San Bartolome de la Torre'),
(2511456,	67,	2593113,	'San Antonio',	'San Antonio',	'San Antonio',	1,	43949,	'2019-03-16 03:59:51',	'San Antonio',	'San Antonio',	'San Antonio'),
(2511477,	67,	2593112,	'Salvaleon',	'Salvaleon',	'Salvaleon',	1,	43886,	'2019-03-16 03:59:51',	'Salvaleon',	'Salvaleon',	'Salvaleon'),
(2511495,	67,	2593109,	'Salteras',	'Salteras',	'Salteras',	1,	43867,	'2019-03-16 03:59:51',	'Salteras',	'Salteras',	'Salteras'),
(2511503,	67,	2593109,	'Salobrena',	'Salobrena',	'Salobrena',	1,	43845,	'2019-03-16 03:59:51',	'Salobrena',	'Salobrena',	'Salobrena'),
(2511512,	67,	2593111,	'Salobral',	'Salobral',	'Salobral',	1,	43844,	'2019-03-16 03:59:51',	'Salobral',	'Salobral',	'Salobral'),
(2511551,	67,	2593109,	'Salar',	'Salar',	'Salar',	1,	43729,	'2019-03-16 03:59:51',	'Salar',	'Salar',	'Salar'),
(2511619,	67,	2593113,	'Сагунто',	'Sagunto',	'Sagunto',	1,	42239,	'2019-03-16 03:59:51',	'Sagunto',	'Sagunto',	'Sagunto'),
(2511633,	67,	2593109,	'Sabiote',	'Sabiote',	'Sabiote',	1,	42174,	'2019-03-16 03:59:51',	'Sabiote',	'Sabiote',	'Sabiote'),
(2511649,	67,	2593109,	'Rute',	'Rute',	'Rute',	1,	42100,	'2019-03-16 03:59:51',	'Rute',	'Rute',	'Rute'),
(2511695,	67,	2593113,	'Rotova',	'Rotova',	'Rotova',	1,	41739,	'2019-03-16 03:59:51',	'Rotova',	'Rotova',	'Rotova'),
(2511700,	67,	2593109,	'Рота',	'Rota',	'Rota',	1,	41706,	'2019-03-16 03:59:51',	'Rota',	'Rota',	'Rota'),
(2511716,	67,	2593109,	'Рокетас-де-Мар',	'Roquetas de Mar',	'Roquetas de Mar',	1,	41554,	'2019-03-16 03:59:51',	'Roquetas de Mar',	'Roquetas de Mar',	'Roquetas de Mar'),
(2511730,	67,	2593109,	'Ронда',	'Ronda',	'Ronda',	1,	41509,	'2019-03-16 03:59:51',	'Ronda',	'Ronda',	'Ronda'),
(2511749,	67,	2513413,	'Roldan',	'Roldan',	'Roldan',	1,	41416,	'2019-03-16 03:59:51',	'Roldan',	'Roldan',	'Roldan'),
(2511752,	67,	2593113,	'Rojales',	'Rojales',	'Rojales',	1,	41410,	'2019-03-16 03:59:51',	'Rojales',	'Rojales',	'Rojales'),
(2511771,	67,	2593113,	'Rocafort',	'Rocafort',	'Rocafort',	1,	41151,	'2019-03-16 03:59:51',	'Rocafort',	'Rocafort',	'Rocafort'),
(2511775,	67,	2593111,	'Robledo del Mazo',	'Robledo del Mazo',	'Robledo del Mazo',	1,	41147,	'2019-03-16 03:59:51',	'Robledo del Mazo',	'Robledo del Mazo',	'Robledo del Mazo'),
(2511823,	67,	2593113,	'Riola',	'Riola',	'Riola',	1,	40927,	'2019-03-16 03:59:51',	'Riola',	'Riola',	'Riola'),
(2511824,	67,	2593109,	'Rioja',	'Rioja',	'Rioja',	1,	40925,	'2019-03-16 03:59:51',	'Rioja',	'Rioja',	'Rioja'),
(2511825,	67,	2593109,	'Riogordo',	'Riogordo',	'Riogordo',	1,	40924,	'2019-03-16 03:59:51',	'Riogordo',	'Riogordo',	'Riogordo'),
(2511852,	67,	2593109,	'Ринкон-де-ла-Виктория',	'Rincon de la Victoria',	'Rincon de la Victoria',	1,	40877,	'2019-03-16 03:59:51',	'Rincon de la Victoria',	'Rincon de la Victoria',	'Rincon de la Victoria'),
(2511862,	67,	2593109,	'Rincon',	'Rincon',	'Rincon',	1,	40876,	'2019-03-16 03:59:51',	'Rincon',	'Rincon',	'Rincon'),
(2511880,	67,	2593113,	'Ribarroja',	'Ribarroja',	'Ribarroja',	1,	40648,	'2019-03-16 03:59:51',	'Ribarroja',	'Ribarroja',	'Ribarroja'),
(2511919,	67,	2593109,	'Retamales',	'Retamales',	'Retamales',	1,	40512,	'2019-03-16 03:59:51',	'Retamales',	'Retamales',	'Retamales'),
(2511930,	67,	2593113,	'Рекена',	'Requena',	'Requena',	1,	40501,	'2019-03-16 03:59:51',	'Requena',	'Requena',	'Requena'),
(2511940,	67,	2593113,	'Relleu',	'Relleu',	'Relleu',	1,	40413,	'2019-03-16 03:59:51',	'Relleu',	'Relleu',	'Relleu'),
(2511969,	67,	2593113,	'Redovan',	'Redovan',	'Redovan',	1,	40276,	'2019-03-16 03:59:51',	'Redovan',	'Redovan',	'Redovan'),
(2511996,	67,	2593113,	'Real de Montroi',	'Real de Montroi',	'Real de Montroi',	1,	40180,	'2019-03-16 03:59:51',	'Real de Montroi',	'Real de Montroi',	'Real de Montroi'),
(2512006,	67,	2593113,	'Real',	'Real',	'Real',	1,	40178,	'2019-03-16 03:59:51',	'Real',	'Real',	'Real'),
(2512071,	67,	2593113,	'Rafelguaraf',	'Rafelguaraf',	'Rafelguaraf',	1,	39870,	'2019-03-16 03:59:51',	'Rafelguaraf',	'Rafelguaraf',	'Rafelguaraf'),
(2512073,	67,	2593113,	'Rafelbunyol',	'Rafelbunyol',	'Rafelbunyol',	1,	39869,	'2019-03-16 03:59:51',	'Rafelbunyol',	'Rafelbunyol',	'Rafelbunyol'),
(2512075,	67,	2593113,	'Rafal',	'Rafal',	'Rafal',	1,	39868,	'2019-03-16 03:59:51',	'Rafal',	'Rafal',	'Rafal'),
(2512095,	67,	2593111,	'Quintanar del Rey',	'Quintanar del Rey',	'Quintanar del Rey',	1,	39785,	'2019-03-16 03:59:51',	'Quintanar del Rey',	'Quintanar del Rey',	'Quintanar del Rey'),
(2512096,	67,	2593111,	'Quintanar de la Orden',	'Quintanar de la Orden',	'Quintanar de la Orden',	1,	39784,	'2019-03-16 03:59:51',	'Quintanar de la Orden',	'Quintanar de la Orden',	'Quintanar de la Orden'),
(2512107,	67,	2593109,	'Quesada',	'Quesada',	'Quesada',	1,	39708,	'2019-03-16 03:59:51',	'Quesada',	'Quesada',	'Quesada'),
(2512127,	67,	2593113,	'Pucol',	'Pucol',	'Pucol',	1,	39478,	'2019-03-16 03:59:51',	'Pucol',	'Pucol',	'Pucol'),
(2512132,	67,	2593109,	'Purchil',	'Purchil',	'Purchil',	1,	39572,	'2019-03-16 03:59:51',	'Purchil',	'Purchil',	'Purchil'),
(2512152,	67,	2593109,	'Pulpi',	'Pulpi',	'Pulpi',	1,	39552,	'2019-03-16 03:59:51',	'Pulpi',	'Pulpi',	'Pulpi'),
(2512155,	67,	2593109,	'Pulianas',	'Pulianas',	'Pulianas',	1,	39546,	'2019-03-16 03:59:51',	'Pulianas',	'Pulianas',	'Pulianas'),
(2512162,	67,	2593113,	'Puig',	'Puig',	'Puig',	1,	39519,	'2019-03-16 03:59:51',	'Puig',	'Puig',	'Puig'),
(2512169,	67,	2593109,	'Пуэрто-Реаль',	'Puerto Real',	'Puerto Real',	1,	39506,	'2019-03-16 03:59:51',	'Puerto Real',	'Puerto Real',	'Puerto Real'),
(2512177,	67,	2593111,	'Пуэртольяно',	'Puertollano',	'Puertollano',	1,	39508,	'2019-03-16 03:59:51',	'Puertollano',	'Puertollano',	'Puertollano'),
(2512183,	67,	2593110,	'Пуэрто де Сантьяго',	'Puerto de Santiago',	'Puerto de Santiago',	1,	39503,	'2019-03-16 03:59:51',	'Puerto de Santiago',	'Puerto de Santiago',	'Puerto de Santiago'),
(2512186,	67,	2593110,	'Пуэрто-дель-Росарио',	'Puerto del Rosario',	'Puerto del Rosario',	1,	39504,	'2019-03-16 03:59:51',	'Puerto del Rosario',	'Puerto del Rosario',	'Puerto del Rosario'),
(2512196,	67,	2593110,	'Пуэрто-де-ла-Крус',	'Puerto de la Cruz',	'Puerto de la Cruz',	1,	39502,	'2019-03-16 03:59:51',	'Puerto de la Cruz',	'Puerto de la Cruz',	'Puerto de la Cruz'),
(2512199,	67,	2593113,	'Puerto de Gandia',	'Puerto de Gandia',	'Puerto de Gandia',	1,	39501,	'2019-03-16 03:59:51',	'Puerto de Gandia',	'Puerto de Gandia',	'Puerto de Gandia'),
(2512216,	67,	2593110,	'Puerto',	'Puerto',	'Puerto',	1,	39499,	'2019-03-16 03:59:51',	'Puerto',	'Puerto',	'Puerto'),
(2512232,	67,	2593109,	'Puente-Genil',	'Puente-Genil',	'Puente-Genil',	1,	39497,	'2019-03-16 03:59:51',	'Puente-Genil',	'Puente-Genil',	'Puente-Genil'),
(2512238,	67,	2593109,	'Puente de Genave',	'Puente de Genave',	'Puente de Genave',	1,	39493,	'2019-03-16 03:59:51',	'Puente de Genave',	'Puente de Genave',	'Puente de Genave'),
(2512252,	67,	2513413,	'Puebla de Soto',	'Puebla de Soto',	'Puebla de Soto',	1,	39490,	'2019-03-16 03:59:51',	'Puebla de Soto',	'Puebla de Soto',	'Puebla de Soto'),
(2512253,	67,	2593112,	'Puebla de Sancho Perez',	'Puebla de Sancho Perez',	'Puebla de Sancho Perez',	1,	39489,	'2019-03-16 03:59:51',	'Puebla de Sancho Perez',	'Puebla de Sancho Perez',	'Puebla de Sancho Perez'),
(2512260,	67,	2593112,	'Puebla del Maestre',	'Puebla del Maestre',	'Puebla del Maestre',	1,	39491,	'2019-03-16 03:59:51',	'Puebla del Maestre',	'Puebla del Maestre',	'Puebla del Maestre'),
(2512263,	67,	2593112,	'Puebla de la Calzada',	'Puebla de la Calzada',	'Puebla de la Calzada',	1,	39486,	'2019-03-16 03:59:51',	'Puebla de la Calzada',	'Puebla de la Calzada',	'Puebla de la Calzada'),
(2512282,	67,	2593109,	'Priego de Cordoba',	'Priego de Cordoba',	'Priego de Cordoba',	1,	39330,	'2019-03-16 03:59:51',	'Priego de Cordoba',	'Priego de Cordoba',	'Priego de Cordoba'),
(2512294,	67,	2593109,	'Prado del Rey',	'Prado del Rey',	'Prado del Rey',	1,	39173,	'2019-03-16 03:59:51',	'Prado del Rey',	'Prado del Rey',	'Prado del Rey'),
(2512319,	67,	2593111,	'Pozohondo',	'Pozohondo',	'Pozohondo',	1,	39150,	'2019-03-16 03:59:51',	'Pozohondo',	'Pozohondo',	'Pozohondo'),
(2512321,	67,	2513413,	'Pozo-Estrecho',	'Pozo-Estrecho',	'Pozo-Estrecho',	1,	39147,	'2019-03-16 03:59:51',	'Pozo-Estrecho',	'Pozo-Estrecho',	'Pozo-Estrecho'),
(2512340,	67,	2593109,	'Pozoblanco',	'Pozoblanco',	'Pozoblanco',	1,	39149,	'2019-03-16 03:59:51',	'Pozoblanco',	'Pozoblanco',	'Pozoblanco'),
(2512341,	67,	2593111,	'Pozoamargo',	'Pozoamargo',	'Pozoamargo',	1,	39148,	'2019-03-16 03:59:51',	'Pozoamargo',	'Pozoamargo',	'Pozoamargo'),
(2512343,	67,	2593109,	'Pozo Alcon',	'Pozo Alcon',	'Pozo Alcon',	1,	39146,	'2019-03-16 03:59:51',	'Pozo Alcon',	'Pozo Alcon',	'Pozo Alcon'),
(2512367,	67,	2593109,	'Posadas',	'Posadas',	'Posadas',	1,	39011,	'2019-03-16 03:59:51',	'Posadas',	'Posadas',	'Posadas'),
(2512378,	67,	2521383,	'Porto Cristo',	'Porto Cristo',	'Porto Cristo',	1,	38972,	'2019-03-16 03:59:51',	'Porto Cristo',	'Porto Cristo',	'Porto Cristo'),
(2512379,	67,	2521383,	'Portocolom',	'Portocolom',	'Portocolom',	1,	38985,	'2019-03-16 03:59:51',	'Portocolom',	'Portocolom',	'Portocolom'),
(2512406,	67,	2593110,	'Poris de Abona',	'Poris de Abona',	'Poris de Abona',	1,	38820,	'2019-03-16 03:59:51',	'Poris de Abona',	'Poris de Abona',	'Poris de Abona'),
(2512423,	67,	2593109,	'Polopos',	'Polopos',	'Polopos',	1,	38575,	'2019-03-16 03:59:51',	'Polopos',	'Polopos',	'Polopos'),
(2512427,	67,	2593113,	'Polop',	'Polop',	'Polop',	1,	38574,	'2019-03-16 03:59:51',	'Polop',	'Polop',	'Polop'),
(2512432,	67,	2521383,	'Pollenca',	'Pollenca',	'Pollenca',	1,	38554,	'2019-03-16 03:59:51',	'Pollenca',	'Pollenca',	'Pollenca'),
(2512437,	67,	2593111,	'Polan',	'Polan',	'Polan',	1,	38521,	'2019-03-16 03:59:51',	'Polan',	'Polan',	'Polan'),
(2512451,	67,	2593111,	'Poblete',	'Poblete',	'Poblete',	1,	38427,	'2019-03-16 03:59:51',	'Poblete',	'Poblete',	'Poblete'),
(2512465,	67,	2593110,	'Плайя Бланка',	'Playa Blanca',	'Playa Blanca',	1,	38229,	'2019-03-16 03:59:51',	'Playa Blanca',	'Playa Blanca',	'Playa Blanca'),
(2512466,	67,	2593113,	'Playa',	'Playa',	'Playa',	1,	38228,	'2019-03-16 03:59:51',	'Playa',	'Playa',	'Playa'),
(2512470,	67,	2593112,	'Plasenzuela',	'Plasenzuela',	'Plasenzuela',	1,	38195,	'2019-03-16 03:59:51',	'Plasenzuela',	'Plasenzuela',	'Plasenzuela'),
(2512475,	67,	2593113,	'Planes',	'Planes',	'Planes',	1,	38179,	'2019-03-16 03:59:51',	'Planes',	'Planes',	'Planes'),
(2512490,	67,	2593109,	'Pizarra',	'Pizarra',	'Pizarra',	1,	38123,	'2019-03-16 03:59:51',	'Pizarra',	'Pizarra',	'Pizarra'),
(2512509,	67,	2593109,	'Pinos Puente',	'Pinos Puente',	'Pinos Puente',	1,	38011,	'2019-03-16 03:59:51',	'Pinos Puente',	'Pinos Puente',	'Pinos Puente'),
(2512510,	67,	2593113,	'Pinoso',	'Pinoso',	'Pinoso',	1,	38012,	'2019-03-16 03:59:51',	'Pinoso',	'Pinoso',	'Pinoso'),
(2512511,	67,	2593109,	'Pinos Genil',	'Pinos Genil',	'Pinos Genil',	1,	38010,	'2019-03-16 03:59:51',	'Pinos Genil',	'Pinos Genil',	'Pinos Genil'),
(2512558,	67,	2593109,	'Pinar',	'Pinar',	'Pinar',	1,	37925,	'2019-03-16 03:59:51',	'Pinar',	'Pinar',	'Pinar'),
(2512571,	67,	2593113,	'Piles',	'Piles',	'Piles',	1,	37899,	'2019-03-16 03:59:51',	'Piles',	'Piles',	'Piles'),
(2512578,	67,	2593109,	'Pilas',	'Pilas',	'Pilas',	1,	37898,	'2019-03-16 03:59:51',	'Pilas',	'Pilas',	'Pilas'),
(2512581,	67,	2593113,	'Pilar de la Horadada',	'Pilar de la Horadada',	'Pilar de la Horadada',	1,	37897,	'2019-03-16 03:59:51',	'Pilar de la Horadada',	'Pilar de la Horadada',	'Pilar de la Horadada'),
(2512609,	67,	2593111,	'Piedrabuena',	'Piedrabuena',	'Piedrabuena',	1,	37802,	'2019-03-16 03:59:51',	'Piedrabuena',	'Piedrabuena',	'Piedrabuena'),
(2512637,	67,	2593113,	'Petrel',	'Petrel',	'Petrel',	1,	37611,	'2019-03-16 03:59:51',	'Petrel',	'Petrel',	'Petrel'),
(2512638,	67,	2521383,	'Petra',	'Petra',	'Petra',	1,	37609,	'2019-03-16 03:59:51',	'Petra',	'Petra',	'Petra'),
(2512660,	67,	2593109,	'Periana',	'Periana',	'Periana',	1,	37425,	'2019-03-16 03:59:51',	'Periana',	'Periana',	'Periana'),
(2512691,	67,	2593112,	'Peraleda de la Mata',	'Peraleda de la Mata',	'Peraleda de la Mata',	1,	37397,	'2019-03-16 03:59:51',	'Peraleda de la Mata',	'Peraleda de la Mata',	'Peraleda de la Mata'),
(2512730,	67,	2593109,	'Penarroya-Pueblonuevo',	'Penarroya-Pueblonuevo',	'Penarroya-Pueblonuevo',	1,	37308,	'2019-03-16 03:59:51',	'Penarroya-Pueblonuevo',	'Penarroya-Pueblonuevo',	'Penarroya-Pueblonuevo'),
(2512746,	67,	2593109,	'Penaflor',	'Penaflor',	'Penaflor',	1,	37306,	'2019-03-16 03:59:51',	'Penaflor',	'Penaflor',	'Penaflor'),
(2512767,	67,	2593109,	'Peligros',	'Peligros',	'Peligros',	1,	37266,	'2019-03-16 03:59:51',	'Peligros',	'Peligros',	'Peligros'),
(2512783,	67,	2593113,	'Pego',	'Pego',	'Pego',	1,	37238,	'2019-03-16 03:59:51',	'Pego',	'Pego',	'Pego'),
(2512794,	67,	2593111,	'Pedro Munoz',	'Pedro Munoz',	'Pedro Munoz',	1,	37225,	'2019-03-16 03:59:51',	'Pedro Munoz',	'Pedro Munoz',	'Pedro Munoz'),
(2512812,	67,	2593109,	'Pedro Abad',	'Pedro Abad',	'Pedro Abad',	1,	37223,	'2019-03-16 03:59:51',	'Pedro Abad',	'Pedro Abad',	'Pedro Abad'),
(2512825,	67,	2593113,	'Pedreguer',	'Pedreguer',	'Pedreguer',	1,	37218,	'2019-03-16 03:59:51',	'Pedreguer',	'Pedreguer',	'Pedreguer'),
(2512837,	67,	2593113,	'Pedralba',	'Pedralba',	'Pedralba',	1,	37216,	'2019-03-16 03:59:51',	'Pedralba',	'Pedralba',	'Pedralba'),
(2512844,	67,	2593109,	'Peal de Becerro',	'Peal de Becerro',	'Peal de Becerro',	1,	37166,	'2019-03-16 03:59:51',	'Peal de Becerro',	'Peal de Becerro',	'Peal de Becerro'),
(2512860,	67,	2593109,	'Paterna del Campo',	'Paterna del Campo',	'Paterna del Campo',	1,	37048,	'2019-03-16 03:59:51',	'Paterna del Campo',	'Paterna del Campo',	'Paterna del Campo'),
(2512862,	67,	2593113,	'Патерна',	'Paterna',	'Paterna',	1,	37047,	'2019-03-16 03:59:51',	'Paterna',	'Paterna',	'Paterna'),
(2512933,	67,	2593109,	'Paradas',	'Paradas',	'Paradas',	1,	36864,	'2019-03-16 03:59:51',	'Paradas',	'Paradas',	'Paradas'),
(2512935,	67,	2593111,	'Paracuellos',	'Paracuellos',	'Paracuellos',	1,	36862,	'2019-03-16 03:59:51',	'Paracuellos',	'Paracuellos',	'Paracuellos'),
(2512950,	67,	2593109,	'Палос-де-ла-Фронтера',	'Palos de la Frontera',	'Palos de la Frontera',	1,	36780,	'2019-03-16 03:59:51',	'Palos de la Frontera',	'Palos de la Frontera',	'Palos de la Frontera'),
(2512964,	67,	2593109,	'Palomares del Rio',	'Palomares del Rio',	'Palomares del Rio',	1,	36777,	'2019-03-16 03:59:51',	'Palomares del Rio',	'Palomares del Rio',	'Palomares del Rio'),
(2512985,	67,	2593113,	'Palmera',	'Palmera',	'Palmera',	1,	36752,	'2019-03-16 03:59:51',	'Palmera',	'Palmera',	'Palmera'),
(2512989,	67,	2521383,	'Пальма',	'Palma',	'Palma',	1,	36737,	'2019-03-16 03:59:51',	'Palma',	'Palma',	'Palma'),
(2512990,	67,	2593109,	'Пальма-дель-Рио',	'Palma del Rio',	'Palma del Rio',	1,	36739,	'2019-03-16 03:59:51',	'Palma del Rio',	'Palma del Rio',	'Palma del Rio'),
(2513027,	67,	2593110,	'Pajara',	'Pajara',	'Pajara',	1,	36659,	'2019-03-16 03:59:51',	'Pajara',	'Pajara',	'Pajara'),
(2513029,	67,	2593113,	'Пайпорта',	'Paiporta',	'Paiporta',	1,	36653,	'2019-03-16 03:59:51',	'Paiporta',	'Paiporta',	'Paiporta'),
(2513035,	67,	2593109,	'Padul',	'Padul',	'Padul',	1,	36608,	'2019-03-16 03:59:51',	'Padul',	'Padul',	'Padul'),
(2513045,	67,	2593109,	'Otura',	'Otura',	'Otura',	1,	36425,	'2019-03-16 03:59:51',	'Otura',	'Otura',	'Otura'),
(2513046,	67,	2593113,	'Otos',	'Otos',	'Otos',	1,	36373,	'2019-03-16 03:59:51',	'Otos',	'Otos',	'Otos'),
(2513052,	67,	2593109,	'Osuna',	'Osuna',	'Osuna',	1,	36348,	'2019-03-16 03:59:51',	'Osuna',	'Osuna',	'Osuna'),
(2513057,	67,	2593111,	'Osa de la Vega',	'Osa de la Vega',	'Osa de la Vega',	1,	36220,	'2019-03-16 03:59:51',	'Osa de la Vega',	'Osa de la Vega',	'Osa de la Vega'),
(2513073,	67,	2593109,	'Orjiva',	'Orjiva',	'Orjiva',	1,	36118,	'2019-03-16 03:59:51',	'Orjiva',	'Orjiva',	'Orjiva'),
(2513076,	67,	2593113,	'Ориуэла',	'Orihuela',	'Orihuela',	1,	36105,	'2019-03-16 03:59:51',	'Orihuela',	'Orihuela',	'Orihuela'),
(2513081,	67,	2593111,	'Orgaz',	'Orgaz',	'Orgaz',	1,	36083,	'2019-03-16 03:59:51',	'Orgaz',	'Orgaz',	'Orgaz'),
(2513084,	67,	2593112,	'Orellana la Vieja',	'Orellana la Vieja',	'Orellana la Vieja',	1,	36074,	'2019-03-16 03:59:51',	'Orellana la Vieja',	'Orellana la Vieja',	'Orellana la Vieja'),
(2513097,	67,	2593109,	'Orce',	'Orce',	'Orce',	1,	36037,	'2019-03-16 03:59:51',	'Orce',	'Orce',	'Orce'),
(2513104,	67,	2593111,	'Ontigola',	'Ontigola',	'Ontigola',	1,	35959,	'2019-03-16 03:59:51',	'Ontigola',	'Ontigola',	'Ontigola'),
(2513106,	67,	2593113,	'Онтеньенте',	'Ontinyent',	'Ontinyent',	1,	35961,	'2019-03-16 03:59:51',	'Ontinyent',	'Ontinyent',	'Ontinyent'),
(2513113,	67,	2593113,	'Onil',	'Onil',	'Onil',	1,	35945,	'2019-03-16 03:59:51',	'Onil',	'Onil',	'Onil'),
(2513114,	67,	2593113,	'Ondara',	'Ondara',	'Ondara',	1,	35924,	'2019-03-16 03:59:51',	'Ondara',	'Ondara',	'Ondara'),
(2513115,	67,	2593113,	'Онда',	'Onda',	'Onda',	1,	35923,	'2019-03-16 03:59:51',	'Onda',	'Onda',	'Onda'),
(2513120,	67,	2593109,	'Olvera',	'Olvera',	'Olvera',	1,	35891,	'2019-03-16 03:59:51',	'Olvera',	'Olvera',	'Olvera'),
(2513121,	67,	2593109,	'Olula del Rio',	'Olula del Rio',	'Olula del Rio',	1,	35889,	'2019-03-16 03:59:51',	'Olula del Rio',	'Olula del Rio',	'Olula del Rio'),
(2513124,	67,	2593113,	'Olocau',	'Olocau',	'Olocau',	1,	35874,	'2019-03-16 03:59:51',	'Olocau',	'Olocau',	'Olocau'),
(2513130,	67,	2593113,	'L\'Olleria',	'L\'Olleria',	'L\'Olleria',	1,	25119,	'2019-03-16 03:59:51',	'L\'Olleria',	'L\'Olleria',	'L\'Olleria'),
(2513140,	67,	2593109,	'Olivares',	'Olivares',	'Olivares',	1,	35840,	'2019-03-16 03:59:51',	'Olivares',	'Olivares',	'Olivares'),
(2513142,	67,	2593112,	'Oliva de Merida',	'Oliva de Merida',	'Oliva de Merida',	1,	35837,	'2019-03-16 03:59:51',	'Oliva de Merida',	'Oliva de Merida',	'Oliva de Merida'),
(2513145,	67,	2593113,	'Олива',	'Oliva',	'Oliva',	1,	35836,	'2019-03-16 03:59:51',	'Oliva',	'Oliva',	'Oliva'),
(2513146,	67,	2593111,	'Olias del Rey',	'Olias del Rey',	'Olias del Rey',	1,	35830,	'2019-03-16 03:59:51',	'Olias del Rey',	'Olias del Rey',	'Olias del Rey'),
(2513149,	67,	2593109,	'Olias',	'Olias',	'Olias',	1,	35829,	'2019-03-16 03:59:51',	'Olias',	'Olias',	'Olias'),
(2513163,	67,	2593109,	'Ojen',	'Ojen',	'Ojen',	1,	35717,	'2019-03-16 03:59:51',	'Ojen',	'Ojen',	'Ojen'),
(2513167,	67,	2593109,	'Ogijares',	'Ogijares',	'Ogijares',	1,	35670,	'2019-03-16 03:59:51',	'Ogijares',	'Ogijares',	'Ogijares'),
(2513175,	67,	2593111,	'Ocana',	'Ocana',	'Ocana',	1,	35529,	'2019-03-16 03:59:51',	'Ocana',	'Ocana',	'Ocana'),
(2513180,	67,	2593113,	'Nules',	'Nules',	'Nules',	1,	35242,	'2019-03-16 03:59:51',	'Nules',	'Nules',	'Nules'),
(2513195,	67,	2593113,	'Новельда',	'Novelda',	'Novelda',	1,	35153,	'2019-03-16 03:59:51',	'Novelda',	'Novelda',	'Novelda'),
(2513216,	67,	2593111,	'Noblejas',	'Noblejas',	'Noblejas',	1,	34695,	'2019-03-16 03:59:51',	'Noblejas',	'Noblejas',	'Noblejas'),
(2513218,	67,	2593109,	'Nivar',	'Nivar',	'Nivar',	1,	34665,	'2019-03-16 03:59:51',	'Nivar',	'Nivar',	'Nivar'),
(2513219,	67,	2593113,	'Nino Perdido',	'Nino Perdido',	'Nino Perdido',	1,	34648,	'2019-03-16 03:59:51',	'Nino Perdido',	'Nino Perdido',	'Nino Perdido'),
(2513222,	67,	2593109,	'Нихар',	'Nijar',	'Nijar',	1,	34625,	'2019-03-16 03:59:51',	'Nijar',	'Nijar',	'Nijar'),
(2513230,	67,	2593109,	'Niebla',	'Niebla',	'Niebla',	1,	34516,	'2019-03-16 03:59:51',	'Niebla',	'Niebla',	'Niebla'),
(2513237,	67,	2593109,	'Nerva',	'Nerva',	'Nerva',	1,	33829,	'2019-03-16 03:59:51',	'Nerva',	'Nerva',	'Nerva'),
(2513240,	67,	2593109,	'Nerja',	'Nerja',	'Nerja',	1,	33821,	'2019-03-16 03:59:51',	'Nerja',	'Nerja',	'Nerja'),
(2513288,	67,	2593112,	'Navezuelas',	'Navezuelas',	'Navezuelas',	1,	33682,	'2019-03-16 03:59:51',	'Navezuelas',	'Navezuelas',	'Navezuelas'),
(2513306,	67,	2593113,	'Navarres',	'Navarres',	'Navarres',	1,	33672,	'2019-03-16 03:59:51',	'Navarres',	'Navarres',	'Navarres'),
(2513324,	67,	2593112,	'Навальмораль-де-ла-Мата',	'Navalmoral de la Mata',	'Navalmoral de la Mata',	1,	33664,	'2019-03-16 03:59:51',	'Navalmoral de la Mata',	'Navalmoral de la Mata',	'Navalmoral de la Mata'),
(2513343,	67,	2593113,	'Navajas',	'Navajas',	'Navajas',	1,	33656,	'2019-03-16 03:59:51',	'Navajas',	'Navajas',	'Navajas'),
(2513346,	67,	2593111,	'Navahermosa',	'Navahermosa',	'Navahermosa',	1,	33654,	'2019-03-16 03:59:51',	'Navahermosa',	'Navahermosa',	'Navahermosa'),
(2513375,	67,	2593113,	'Naquera',	'Naquera',	'Naquera',	1,	33563,	'2019-03-16 03:59:51',	'Naquera',	'Naquera',	'Naquera'),
(2513384,	67,	2593111,	'Nambroca',	'Nambroca',	'Nambroca',	1,	33509,	'2019-03-16 03:59:51',	'Nambroca',	'Nambroca',	'Nambroca'),
(2513395,	67,	2593113,	'Museros',	'Museros',	'Museros',	1,	33402,	'2019-03-16 03:59:51',	'Museros',	'Museros',	'Museros'),
(2513403,	67,	2593113,	'Muro del Alcoy',	'Muro del Alcoy',	'Muro del Alcoy',	1,	33367,	'2019-03-16 03:59:51',	'Muro del Alcoy',	'Muro del Alcoy',	'Muro del Alcoy'),
(2513406,	67,	2521383,	'Muro',	'Muro',	'Muro',	1,	33366,	'2019-03-16 03:59:51',	'Muro',	'Muro',	'Muro'),
(2513416,	67,	2513413,	'Мурсия',	'Murcia',	'Murcia',	1,	33343,	'2019-03-16 03:59:51',	'Murcia',	'Murcia',	'Murcia'),
(2513436,	67,	2513413,	'Mula',	'Mula',	'Mula',	1,	33248,	'2019-03-16 03:59:51',	'Mula',	'Mula',	'Mula'),
(2513465,	67,	2593113,	'Muchamiel',	'Muchamiel',	'Muchamiel',	1,	33204,	'2019-03-16 03:59:51',	'Muchamiel',	'Muchamiel',	'Muchamiel'),
(2513476,	67,	2593110,	'Moya',	'Moya',	'Moya',	1,	33182,	'2019-03-16 03:59:51',	'Moya',	'Moya',	'Moya'),
(2513477,	67,	2593109,	'Мотриль',	'Motril',	'Motril',	1,	32947,	'2019-03-16 03:59:51',	'Motril',	'Motril',	'Motril'),
(2513480,	67,	2593111,	'Motilla del Palancar',	'Motilla del Palancar',	'Motilla del Palancar',	1,	32944,	'2019-03-16 03:59:51',	'Motilla del Palancar',	'Motilla del Palancar',	'Motilla del Palancar'),
(2513481,	67,	2593111,	'Mota del Cuervo',	'Mota del Cuervo',	'Mota del Cuervo',	1,	32942,	'2019-03-16 03:59:51',	'Mota del Cuervo',	'Mota del Cuervo',	'Mota del Cuervo'),
(2513497,	67,	2593110,	'Morro del Jable',	'Morro del Jable',	'Morro del Jable',	1,	32854,	'2019-03-16 03:59:51',	'Morro del Jable',	'Morro del Jable',	'Morro del Jable'),
(2513509,	67,	2593109,	'Морон-де-ла-Фронтера',	'Moron de la Frontera',	'Moron de la Frontera',	1,	32814,	'2019-03-16 03:59:51',	'Moron de la Frontera',	'Moron de la Frontera',	'Moron de la Frontera'),
(2513562,	67,	2513413,	'Moratalla',	'Moratalla',	'Moratalla',	1,	32709,	'2019-03-16 03:59:51',	'Moratalla',	'Moratalla',	'Moratalla'),
(2513579,	67,	2593109,	'Moraleda de Zafayona',	'Moraleda de Zafayona',	'Moraleda de Zafayona',	1,	32697,	'2019-03-16 03:59:51',	'Moraleda de Zafayona',	'Moraleda de Zafayona',	'Moraleda de Zafayona'),
(2513588,	67,	2593111,	'Mora',	'Mora',	'Mora',	1,	32687,	'2019-03-16 03:59:51',	'Mora',	'Mora',	'Mora'),
(2513592,	67,	2593113,	'Montroy',	'Montroy',	'Montroy',	1,	32611,	'2019-03-16 03:59:51',	'Montroy',	'Montroy',	'Montroy'),
(2513599,	67,	2593109,	'Montillana',	'Montillana',	'Montillana',	1,	32481,	'2019-03-16 03:59:51',	'Montillana',	'Montillana',	'Montillana'),
(2513601,	67,	2593109,	'Монтилья',	'Montilla',	'Montilla',	1,	32480,	'2019-03-16 03:59:51',	'Montilla',	'Montilla',	'Montilla'),
(2513604,	67,	2593112,	'Montijo',	'Montijo',	'Montijo',	1,	32479,	'2019-03-16 03:59:51',	'Montijo',	'Montijo',	'Montijo'),
(2513612,	67,	2593109,	'Montes de San Benito',	'Montes de San Benito',	'Montes de San Benito',	1,	32353,	'2019-03-16 03:59:51',	'Montes de San Benito',	'Montes de San Benito',	'Montes de San Benito'),
(2513618,	67,	2593112,	'Monterrubio de la Serena',	'Monterrubio de la Serena',	'Monterrubio de la Serena',	1,	32350,	'2019-03-16 03:59:51',	'Monterrubio de la Serena',	'Monterrubio de la Serena',	'Monterrubio de la Serena'),
(2513632,	67,	2593109,	'Montemayor',	'Montemayor',	'Montemayor',	1,	32310,	'2019-03-16 03:59:51',	'Montemayor',	'Montemayor',	'Montemayor'),
(2513638,	67,	2593109,	'Montejicar',	'Montejicar',	'Montejicar',	1,	32295,	'2019-03-16 03:59:51',	'Montejicar',	'Montejicar',	'Montejicar'),
(2513640,	67,	2593109,	'Montefrio',	'Montefrio',	'Montefrio',	1,	32281,	'2019-03-16 03:59:51',	'Montefrio',	'Montefrio',	'Montefrio'),
(2513652,	67,	2513413,	'Monteagudo',	'Monteagudo',	'Monteagudo',	1,	32240,	'2019-03-16 03:59:51',	'Monteagudo',	'Monteagudo',	'Monteagudo'),
(2513671,	67,	2593109,	'Montalban de Cordoba',	'Montalban de Cordoba',	'Montalban de Cordoba',	1,	32126,	'2019-03-16 03:59:51',	'Montalban de Cordoba',	'Montalban de Cordoba',	'Montalban de Cordoba'),
(2513674,	67,	2593113,	'Monserrat',	'Monserrat',	'Monserrat',	1,	32067,	'2019-03-16 03:59:51',	'Monserrat',	'Monserrat',	'Monserrat'),
(2513680,	67,	2593113,	'Моновар',	'Monovar',	'Monovar',	1,	32015,	'2019-03-16 03:59:51',	'Monovar',	'Monovar',	'Monovar'),
(2513691,	67,	2593113,	'Monforte del Cid',	'Monforte del Cid',	'Monforte del Cid',	1,	31981,	'2019-03-16 03:59:51',	'Monforte del Cid',	'Monforte del Cid',	'Monforte del Cid'),
(2513699,	67,	2593109,	'Monda',	'Monda',	'Monda',	1,	31943,	'2019-03-16 03:59:51',	'Monda',	'Monda',	'Monda'),
(2513700,	67,	2593113,	'Moncofar',	'Moncofar',	'Moncofar',	1,	31937,	'2019-03-16 03:59:51',	'Moncofar',	'Moncofar',	'Moncofar'),
(2513703,	67,	2593113,	'Монкада',	'Moncada',	'Moncada',	1,	31910,	'2019-03-16 03:59:51',	'Moncada',	'Moncada',	'Moncada'),
(2513709,	67,	2593109,	'Monachil',	'Monachil',	'Monachil',	1,	31899,	'2019-03-16 03:59:51',	'Monachil',	'Monachil',	'Monachil'),
(2513717,	67,	2593109,	'Mollina',	'Mollina',	'Mollina',	1,	31873,	'2019-03-16 03:59:51',	'Mollina',	'Mollina',	'Mollina'),
(2513759,	67,	2513413,	'Молина-де-Сегура',	'Molina de Segura',	'Molina de Segura',	1,	31853,	'2019-03-16 03:59:51',	'Molina de Segura',	'Molina de Segura',	'Molina de Segura'),
(2513786,	67,	2593109,	'Mojacar',	'Mojacar',	'Mojacar',	1,	31830,	'2019-03-16 03:59:51',	'Mojacar',	'Mojacar',	'Mojacar'),
(2513791,	67,	2593109,	'Могер',	'Moguer',	'Moguer',	1,	31787,	'2019-03-16 03:59:51',	'Moguer',	'Moguer',	'Moguer'),
(2513792,	67,	2593109,	'Mogon',	'Mogon',	'Mogon',	1,	31784,	'2019-03-16 03:59:51',	'Mogon',	'Mogon',	'Mogon'),
(2513798,	67,	2593110,	'Mogan',	'Mogan',	'Mogan',	1,	31775,	'2019-03-16 03:59:51',	'Mogan',	'Mogan',	'Mogan'),
(2513801,	67,	2593109,	'Moclin',	'Moclin',	'Moclin',	1,	31755,	'2019-03-16 03:59:51',	'Moclin',	'Moclin',	'Moclin'),
(2513803,	67,	2593111,	'Mocejon',	'Mocejon',	'Mocejon',	1,	31747,	'2019-03-16 03:59:51',	'Mocejon',	'Mocejon',	'Mocejon'),
(2513811,	67,	2593113,	'Мислата',	'Mislata',	'Mislata',	1,	31680,	'2019-03-16 03:59:51',	'Mislata',	'Mislata',	'Mislata'),
(2513827,	67,	2593113,	'Miramar',	'Miramar',	'Miramar',	1,	31629,	'2019-03-16 03:59:51',	'Miramar',	'Miramar',	'Miramar'),
(2513835,	67,	2513413,	'Mirador',	'Mirador',	'Mirador',	1,	31624,	'2019-03-16 03:59:51',	'Mirador',	'Mirador',	'Mirador'),
(2513855,	67,	2593111,	'Minaya',	'Minaya',	'Minaya',	1,	31527,	'2019-03-16 03:59:51',	'Minaya',	'Minaya',	'Minaya'),
(2513874,	67,	2593113,	'Millares',	'Millares',	'Millares',	1,	31399,	'2019-03-16 03:59:51',	'Millares',	'Millares',	'Millares'),
(2513882,	67,	2593109,	'Михас',	'Mijas',	'Mijas',	1,	31319,	'2019-03-16 03:59:51',	'Mijas',	'Mijas',	'Mijas'),
(2513885,	67,	2593111,	'Miguelturra',	'Miguelturra',	'Miguelturra',	1,	31317,	'2019-03-16 03:59:51',	'Miguelturra',	'Miguelturra',	'Miguelturra'),
(2513893,	67,	2593112,	'Мьяхадас',	'Miajadas',	'Miajadas',	1,	31174,	'2019-03-16 03:59:51',	'Miajadas',	'Miajadas',	'Miajadas'),
(2513917,	67,	2593112,	'Мерида',	'Merida',	'Merida',	1,	30917,	'2019-03-16 03:59:51',	'Merida',	'Merida',	'Merida'),
(2513922,	67,	2521383,	'Mercadal',	'Mercadal',	'Mercadal',	1,	30876,	'2019-03-16 03:59:51',	'Mercadal',	'Mercadal',	'Mercadal'),
(2513931,	67,	2593109,	'Mengibar',	'Mengibar',	'Mengibar',	1,	30823,	'2019-03-16 03:59:51',	'Mengibar',	'Mengibar',	'Mengibar'),
(2513944,	67,	2593111,	'Membrilla',	'Membrilla',	'Membrilla',	1,	30772,	'2019-03-16 03:59:51',	'Membrilla',	'Membrilla',	'Membrilla'),
(2513947,	67,	6362988,	'Мелилья',	'Melilla',	'Melilla',	1,	30722,	'2019-03-16 03:59:51',	'Melilla',	'Melilla',	'Melilla'),
(2513949,	67,	2593113,	'Meliana',	'Meliana',	'Meliana',	1,	30717,	'2019-03-16 03:59:51',	'Meliana',	'Meliana',	'Meliana'),
(2513961,	67,	2593109,	'Medina Sidonia',	'Medina Sidonia',	'Medina Sidonia',	1,	30613,	'2019-03-16 03:59:51',	'Medina Sidonia',	'Medina Sidonia',	'Medina Sidonia'),
(2513983,	67,	2513413,	'Масаррон',	'Mazarron',	'Mazarron',	1,	30430,	'2019-03-16 03:59:51',	'Mazarron',	'Mazarron',	'Mazarron'),
(2513985,	67,	2593111,	'Mazarambroz',	'Mazarambroz',	'Mazarambroz',	1,	30428,	'2019-03-16 03:59:51',	'Mazarambroz',	'Mazarambroz',	'Mazarambroz'),
(2513986,	67,	2593109,	'Mazagon',	'Mazagon',	'Mazagon',	1,	30424,	'2019-03-16 03:59:51',	'Mazagon',	'Mazagon',	'Mazagon'),
(2514042,	67,	2593110,	'Маспаломас',	'Maspalomas',	'Maspalomas',	1,	30196,	'2019-03-16 03:59:51',	'Maspalomas',	'Maspalomas',	'Maspalomas'),
(2514061,	67,	2593111,	'Mascaraque',	'Mascaraque',	'Mascaraque',	1,	30162,	'2019-03-16 03:59:51',	'Mascaraque',	'Mascaraque',	'Mascaraque'),
(2514070,	67,	2593110,	'Marzagan',	'Marzagan',	'Marzagan',	1,	30148,	'2019-03-16 03:59:51',	'Marzagan',	'Marzagan',	'Marzagan'),
(2514073,	67,	2593109,	'Мартос',	'Martos',	'Martos',	1,	30117,	'2019-03-16 03:59:51',	'Martos',	'Martos',	'Martos'),
(2514097,	67,	2521383,	'Маррачи',	'Marratxi',	'Marratxi',	1,	30001,	'2019-03-16 03:59:51',	'Marratxi',	'Marratxi',	'Marratxi'),
(2514105,	67,	2593109,	'Maro',	'Maro',	'Maro',	1,	29968,	'2019-03-16 03:59:51',	'Maro',	'Maro',	'Maro'),
(2514107,	67,	2593109,	'Marmolejo',	'Marmolejo',	'Marmolejo',	1,	29957,	'2019-03-16 03:59:51',	'Marmolejo',	'Marmolejo',	'Marmolejo'),
(2514116,	67,	2593113,	'Mariola',	'Mariola',	'Mariola',	1,	29835,	'2019-03-16 03:59:51',	'Mariola',	'Mariola',	'Mariola'),
(2514139,	67,	2593109,	'Maria',	'Maria',	'Maria',	1,	29761,	'2019-03-16 03:59:51',	'Maria',	'Maria',	'Maria'),
(2514142,	67,	2593113,	'Margarida',	'Margarida',	'Margarida',	1,	29740,	'2019-03-16 03:59:51',	'Margarida',	'Margarida',	'Margarida'),
(2514158,	67,	2593109,	'Marchena',	'Marchena',	'Marchena',	1,	29659,	'2019-03-16 03:59:51',	'Marchena',	'Marchena',	'Marchena'),
(2514169,	67,	2593109,	'Марбелья',	'Marbella',	'Marbella',	1,	29628,	'2019-03-16 03:59:51',	'Marbella',	'Marbella',	'Marbella'),
(2514176,	67,	2593109,	'Maracena',	'Maracena',	'Maracena',	1,	29606,	'2019-03-16 03:59:51',	'Maracena',	'Maracena',	'Maracena'),
(2514190,	67,	2593111,	'Manzanares',	'Manzanares',	'Manzanares',	1,	29569,	'2019-03-16 03:59:51',	'Manzanares',	'Manzanares',	'Manzanares'),
(2514197,	67,	2593113,	'Манисес',	'Manises',	'Manises',	1,	29478,	'2019-03-16 03:59:51',	'Manises',	'Manises',	'Manises'),
(2514199,	67,	2593109,	'Manilva',	'Manilva',	'Manilva',	1,	29473,	'2019-03-16 03:59:51',	'Manilva',	'Manilva',	'Manilva'),
(2514211,	67,	2593109,	'Mancha Real',	'Mancha Real',	'Mancha Real',	1,	29412,	'2019-03-16 03:59:51',	'Mancha Real',	'Mancha Real',	'Mancha Real'),
(2514216,	67,	2521383,	'Манакор',	'Manacor',	'Manacor',	1,	29401,	'2019-03-16 03:59:51',	'Manacor',	'Manacor',	'Manacor'),
(2514219,	67,	2593111,	'Malpica',	'Malpica',	'Malpica',	1,	29361,	'2019-03-16 03:59:51',	'Malpica',	'Malpica',	'Malpica'),
(2514225,	67,	2593112,	'Malpartida de Plasencia',	'Malpartida de Plasencia',	'Malpartida de Plasencia',	1,	29359,	'2019-03-16 03:59:51',	'Malpartida de Plasencia',	'Malpartida de Plasencia',	'Malpartida de Plasencia'),
(2514227,	67,	2593112,	'Malpartida de Caceres',	'Malpartida de Caceres',	'Malpartida de Caceres',	1,	29358,	'2019-03-16 03:59:51',	'Malpartida de Caceres',	'Malpartida de Caceres',	'Malpartida de Caceres'),
(2514252,	67,	2593111,	'Malagon',	'Malagon',	'Malagon',	1,	29280,	'2019-03-16 03:59:51',	'Malagon',	'Malagon',	'Malagon'),
(2514256,	67,	2593109,	'Малага',	'Malaga',	'Malaga',	1,	29278,	'2019-03-16 03:59:51',	'Malaga',	'Malaga',	'Malaga'),
(2514287,	67,	2593109,	'Mairena del Aljarafe',	'Mairena del Aljarafe',	'Mairena del Aljarafe',	1,	29239,	'2019-03-16 03:59:51',	'Mairena del Aljarafe',	'Mairena del Aljarafe',	'Mairena del Aljarafe'),
(2514288,	67,	2593109,	'Mairena del Alcor',	'Mairena del Alcor',	'Mairena del Alcor',	1,	29238,	'2019-03-16 03:59:51',	'Mairena del Alcor',	'Mairena del Alcor',	'Mairena del Alcor'),
(2514297,	67,	2593111,	'Mahora',	'Mahora',	'Mahora',	1,	29184,	'2019-03-16 03:59:51',	'Mahora',	'Mahora',	'Mahora'),
(2514301,	67,	2521383,	'Мао',	'Mao',	'Mao',	1,	29580,	'2019-03-16 03:59:51',	'Mao',	'Mao',	'Mao'),
(2514314,	67,	2593111,	'Magan',	'Magan',	'Magan',	1,	29121,	'2019-03-16 03:59:51',	'Magan',	'Magan',	'Magan'),
(2514332,	67,	2593111,	'Madrigueras',	'Madrigueras',	'Madrigueras',	1,	29106,	'2019-03-16 03:59:51',	'Madrigueras',	'Madrigueras',	'Madrigueras'),
(2514334,	67,	2593111,	'Madridejos',	'Madridejos',	'Madridejos',	1,	29104,	'2019-03-16 03:59:51',	'Madridejos',	'Madridejos',	'Madridejos'),
(2514359,	67,	2593113,	'Macastre',	'Macastre',	'Macastre',	1,	29011,	'2019-03-16 03:59:51',	'Macastre',	'Macastre',	'Macastre'),
(2514360,	67,	2593109,	'Macael',	'Macael',	'Macael',	1,	29009,	'2019-03-16 03:59:51',	'Macael',	'Macael',	'Macael'),
(2514370,	67,	2513413,	'Puerto Lumbreras',	'Puerto Lumbreras',	'Puerto Lumbreras',	1,	39505,	'2019-03-16 03:59:51',	'Puerto Lumbreras',	'Puerto Lumbreras',	'Puerto Lumbreras'),
(2514389,	67,	2593109,	'Lucena del Puerto',	'Lucena del Puerto',	'Lucena del Puerto',	1,	28708,	'2019-03-16 03:59:51',	'Lucena del Puerto',	'Lucena del Puerto',	'Lucena del Puerto'),
(2514392,	67,	2593109,	'Lucena',	'Lucena',	'Lucena',	1,	28706,	'2019-03-16 03:59:51',	'Lucena',	'Lucena',	'Lucena'),
(2514406,	67,	2593111,	'Los Yebenes',	'Los Yebenes',	'Los Yebenes',	1,	28514,	'2019-03-16 03:59:51',	'Los Yebenes',	'Los Yebenes',	'Los Yebenes'),
(2514411,	67,	2593109,	'Los Villares',	'Los Villares',	'Los Villares',	1,	28513,	'2019-03-16 03:59:51',	'Los Villares',	'Los Villares',	'Los Villares'),
(2514452,	67,	2593110,	'Los Silos',	'Los Silos',	'Los Silos',	1,	28512,	'2019-03-16 03:59:51',	'Los Silos',	'Los Silos',	'Los Silos'),
(2514460,	67,	2593112,	'Los Santos de Maimona',	'Los Santos de Maimona',	'Los Santos de Maimona',	1,	28511,	'2019-03-16 03:59:51',	'Los Santos de Maimona',	'Los Santos de Maimona',	'Los Santos de Maimona'),
(2514492,	67,	2593109,	'Los Rios',	'Los Rios',	'Los Rios',	1,	28510,	'2019-03-16 03:59:51',	'Los Rios',	'Los Rios',	'Los Rios'),
(2514553,	67,	2593109,	'Los Palacios y Villafranca',	'Los Palacios y Villafranca',	'Los Palacios y Villafranca',	1,	28509,	'2019-03-16 03:59:51',	'Los Palacios y Villafranca',	'Los Palacios y Villafranca',	'Los Palacios y Villafranca'),
(2514554,	67,	2513413,	'Los Palacios',	'Los Palacios',	'Los Palacios',	1,	28508,	'2019-03-16 03:59:51',	'Los Palacios',	'Los Palacios',	'Los Palacios'),
(2514575,	67,	2513413,	'Los Narejos',	'Los Narejos',	'Los Narejos',	1,	28505,	'2019-03-16 03:59:51',	'Los Narejos',	'Los Narejos',	'Los Narejos'),
(2514594,	67,	2593112,	'Los Montes',	'Los Montes',	'Los Montes',	1,	28504,	'2019-03-16 03:59:51',	'Los Montes',	'Los Montes',	'Los Montes'),
(2514601,	67,	2593109,	'Los Molares',	'Los Molares',	'Los Molares',	1,	28500,	'2019-03-16 03:59:51',	'Los Molares',	'Los Molares',	'Los Molares'),
(2514623,	67,	2593109,	'Los Marines',	'Los Marines',	'Los Marines',	1,	28499,	'2019-03-16 03:59:51',	'Los Marines',	'Los Marines',	'Los Marines'),
(2514651,	67,	2593110,	'Los Llanos de Aridane',	'Los Llanos de Aridane',	'Los Llanos de Aridane',	1,	28497,	'2019-03-16 03:59:51',	'Los Llanos de Aridane',	'Los Llanos de Aridane',	'Los Llanos de Aridane'),
(2514717,	67,	2593109,	'Los Gallardos',	'Los Gallardos',	'Los Gallardos',	1,	28496,	'2019-03-16 03:59:51',	'Los Gallardos',	'Los Gallardos',	'Los Gallardos'),
(2514741,	67,	2593110,	'Los Cristianos',	'Los Cristianos',	'Los Cristianos',	1,	28494,	'2019-03-16 03:59:51',	'Los Cristianos',	'Los Cristianos',	'Los Cristianos'),
(2514824,	67,	2593109,	'Лос-Барриос',	'Los Barrios',	'Los Barrios',	1,	28492,	'2019-03-16 03:59:51',	'Los Barrios',	'Los Barrios',	'Los Barrios'),
(2514841,	67,	2593110,	'Los Baldios',	'Los Baldios',	'Los Baldios',	1,	28490,	'2019-03-16 03:59:51',	'Los Baldios',	'Los Baldios',	'Los Baldios'),
(2514855,	67,	2521383,	'Los Angeles',	'Los Angeles',	'Los Angeles',	1,	28487,	'2019-03-16 03:59:51',	'Los Angeles',	'Los Angeles',	'Los Angeles'),
(2514856,	67,	2593110,	'Los Angeles',	'Los Angeles',	'Los Angeles',	1,	28489,	'2019-03-16 03:59:51',	'Los Angeles',	'Los Angeles',	'Los Angeles'),
(2514868,	67,	2513413,	'Los Alcazares',	'Los Alcazares',	'Los Alcazares',	1,	28484,	'2019-03-16 03:59:51',	'Los Alcazares',	'Los Alcazares',	'Los Alcazares'),
(2514883,	67,	2513413,	'Lorqui',	'Lorqui',	'Lorqui',	1,	28472,	'2019-03-16 03:59:51',	'Lorqui',	'Lorqui',	'Lorqui'),
(2514887,	67,	2593113,	'Loriguilla',	'Loriguilla',	'Loriguilla',	1,	28460,	'2019-03-16 03:59:51',	'Loriguilla',	'Loriguilla',	'Loriguilla'),
(2514891,	67,	2513413,	'Лорка',	'Lorca',	'Lorca',	1,	28435,	'2019-03-16 03:59:51',	'Lorca',	'Lorca',	'Lorca'),
(2514893,	67,	2593109,	'Lora del Rio',	'Lora del Rio',	'Lora del Rio',	1,	28428,	'2019-03-16 03:59:51',	'Lora del Rio',	'Lora del Rio',	'Lora del Rio'),
(2514896,	67,	2593109,	'Lopera',	'Lopera',	'Lopera',	1,	28424,	'2019-03-16 03:59:51',	'Lopera',	'Lopera',	'Lopera'),
(2514912,	67,	2593110,	'Lomo de Arico',	'Lomo de Arico',	'Lomo de Arico',	1,	28294,	'2019-03-16 03:59:51',	'Lomo de Arico',	'Lomo de Arico',	'Lomo de Arico'),
(2514946,	67,	2593109,	'Лоха',	'Loja',	'Loja',	1,	28269,	'2019-03-16 03:59:51',	'Loja',	'Loja',	'Loja'),
(2514987,	67,	2521383,	'Llubi',	'Llubi',	'Llubi',	1,	28126,	'2019-03-16 03:59:51',	'Llubi',	'Llubi',	'Llubi'),
(2514988,	67,	2521383,	'Lloseta',	'Lloseta',	'Lloseta',	1,	28124,	'2019-03-16 03:59:51',	'Lloseta',	'Lloseta',	'Lloseta'),
(2514989,	67,	2593113,	'Llosa de Ranes',	'Llosa de Ranes',	'Llosa de Ranes',	1,	28123,	'2019-03-16 03:59:51',	'Llosa de Ranes',	'Llosa de Ranes',	'Llosa de Ranes'),
(2515002,	67,	2593112,	'Льерена',	'Llerena',	'Llerena',	1,	28116,	'2019-03-16 03:59:51',	'Llerena',	'Llerena',	'Llerena'),
(2515005,	67,	2593113,	'Llauri',	'Llauri',	'Llauri',	1,	28113,	'2019-03-16 03:59:51',	'Llauri',	'Llauri',	'Llauri'),
(2515036,	67,	2593113,	'Lliria',	'Lliria',	'Lliria',	1,	28119,	'2019-03-16 03:59:51',	'Lliria',	'Lliria',	'Lliria'),
(2515045,	67,	2593109,	'Линарес',	'Linares',	'Linares',	1,	27791,	'2019-03-16 03:59:51',	'Linares',	'Linares',	'Linares'),
(2515050,	67,	2593109,	'Limones',	'Limones',	'Limones',	1,	27783,	'2019-03-16 03:59:51',	'Limones',	'Limones',	'Limones'),
(2515060,	67,	2513413,	'Librilla',	'Librilla',	'Librilla',	1,	27647,	'2019-03-16 03:59:51',	'Librilla',	'Librilla',	'Librilla'),
(2515072,	67,	2593109,	'Лепе',	'Lepe',	'Lepe',	1,	27277,	'2019-03-16 03:59:51',	'Lepe',	'Lepe',	'Lepe'),
(2515093,	67,	2593111,	'Ledana',	'Ledana',	'Ledana',	1,	27027,	'2019-03-16 03:59:51',	'Ledana',	'Ledana',	'Ledana'),
(2515096,	67,	2593109,	'Лебриха',	'Lebrija',	'Lebrija',	1,	27007,	'2019-03-16 03:59:51',	'Lebrija',	'Lebrija',	'Lebrija'),
(2515114,	67,	2593109,	'La Yedra',	'La Yedra',	'La Yedra',	1,	25689,	'2019-03-16 03:59:51',	'La Yedra',	'La Yedra',	'La Yedra'),
(2515117,	67,	2593111,	'La Vinuela',	'La Vinuela',	'La Vinuela',	1,	25682,	'2019-03-16 03:59:51',	'La Vinuela',	'La Vinuela',	'La Vinuela'),
(2515118,	67,	2593110,	'La Victoria de Acentejo',	'La Victoria de Acentejo',	'La Victoria de Acentejo',	1,	25675,	'2019-03-16 03:59:51',	'La Victoria de Acentejo',	'La Victoria de Acentejo',	'La Victoria de Acentejo'),
(2515119,	67,	2593109,	'La Victoria',	'La Victoria',	'La Victoria',	1,	25674,	'2019-03-16 03:59:51',	'La Victoria',	'La Victoria',	'La Victoria'),
(2515151,	67,	2513413,	'La Union',	'La Union',	'La Union',	1,	25655,	'2019-03-16 03:59:51',	'La Union',	'La Union',	'La Union'),
(2515210,	67,	2593110,	'Las Vegas',	'Las Vegas',	'Las Vegas',	1,	26408,	'2019-03-16 03:59:51',	'Las Vegas',	'Las Vegas',	'Las Vegas'),
(2515219,	67,	2513413,	'Las Torres de Cotillas',	'Las Torres de Cotillas',	'Las Torres de Cotillas',	1,	26405,	'2019-03-16 03:59:51',	'Las Torres de Cotillas',	'Las Torres de Cotillas',	'Las Torres de Cotillas'),
(2515261,	67,	2593111,	'Las Pedroneras',	'Las Pedroneras',	'Las Pedroneras',	1,	26403,	'2019-03-16 03:59:51',	'Las Pedroneras',	'Las Pedroneras',	'Las Pedroneras'),
(2515270,	67,	2593110,	'Лас-Пальмас-де-Гран-Канария',	'Las Palmas de Gran Canaria',	'Las Palmas de Gran Canaria',	1,	26402,	'2019-03-16 03:59:51',	'Las Palmas de Gran Canaria',	'Las Palmas de Gran Canaria',	'Las Palmas de Gran Canaria'),
(2515284,	67,	2593111,	'La Solana',	'La Solana',	'La Solana',	1,	25621,	'2019-03-16 03:59:51',	'La Solana',	'La Solana',	'La Solana'),
(2515301,	67,	2593112,	'Las Nieves',	'Las Nieves',	'Las Nieves',	1,	26401,	'2019-03-16 03:59:51',	'Las Nieves',	'Las Nieves',	'Las Nieves'),
(2515350,	67,	2593111,	'Las Islas',	'Las Islas',	'Las Islas',	1,	26398,	'2019-03-16 03:59:51',	'Las Islas',	'Las Islas',	'Las Islas'),
(2515356,	67,	2593109,	'La Sierra',	'La Sierra',	'La Sierra',	1,	25620,	'2019-03-16 03:59:51',	'La Sierra',	'La Sierra',	'La Sierra'),
(2515381,	67,	2593110,	'Лас Галлетас',	'Las Galletas',	'Las Galletas',	1,	26397,	'2019-03-16 03:59:51',	'Las Galletas',	'Las Galletas',	'Las Galletas'),
(2515493,	67,	2593109,	'Las Cabezas de San Juan',	'Las Cabezas de San Juan',	'Las Cabezas de San Juan',	1,	26395,	'2019-03-16 03:59:51',	'Las Cabezas de San Juan',	'Las Cabezas de San Juan',	'Las Cabezas de San Juan'),
(2515554,	67,	2593109,	'La Roda de Andalucia',	'La Roda de Andalucia',	'La Roda de Andalucia',	1,	25584,	'2019-03-16 03:59:51',	'La Roda de Andalucia',	'La Roda de Andalucia',	'La Roda de Andalucia'),
(2515555,	67,	2593111,	'La Roda',	'La Roda',	'La Roda',	1,	25583,	'2019-03-16 03:59:51',	'La Roda',	'La Roda',	'La Roda'),
(2515562,	67,	2593109,	'Ла-Ринконада',	'La Rinconada',	'La Rinconada',	1,	25562,	'2019-03-16 03:59:51',	'La Rinconada',	'La Rinconada',	'La Rinconada'),
(2515598,	67,	2593109,	'La Rambla',	'La Rambla',	'La Rambla',	1,	25548,	'2019-03-16 03:59:51',	'La Rambla',	'La Rambla',	'La Rambla'),
(2515604,	67,	2593109,	'La Rabita',	'La Rabita',	'La Rabita',	1,	25547,	'2019-03-16 03:59:51',	'La Rabita',	'La Rabita',	'La Rabita'),
(2515618,	67,	2593111,	'La Pueblanueva',	'La Pueblanueva',	'La Pueblanueva',	1,	25540,	'2019-03-16 03:59:51',	'La Pueblanueva',	'La Pueblanueva',	'La Pueblanueva'),
(2515619,	67,	2593111,	'La Puebla de Montalban',	'La Puebla de Montalban',	'La Puebla de Montalban',	1,	25538,	'2019-03-16 03:59:51',	'La Puebla de Montalban',	'La Puebla de Montalban',	'La Puebla de Montalban'),
(2515620,	67,	2593109,	'La Puebla del Rio',	'La Puebla del Rio',	'La Puebla del Rio',	1,	25539,	'2019-03-16 03:59:51',	'La Puebla del Rio',	'La Puebla del Rio',	'La Puebla del Rio'),
(2515621,	67,	2593109,	'La Puebla de los Infantes',	'La Puebla de los Infantes',	'La Puebla de los Infantes',	1,	25537,	'2019-03-16 03:59:51',	'La Puebla de los Infantes',	'La Puebla de los Infantes',	'La Puebla de los Infantes'),
(2515622,	67,	2593109,	'La Puebla de Cazalla',	'La Puebla de Cazalla',	'La Puebla de Cazalla',	1,	25536,	'2019-03-16 03:59:51',	'La Puebla de Cazalla',	'La Puebla de Cazalla',	'La Puebla de Cazalla'),
(2515623,	67,	2593111,	'La Puebla de Almoradiel',	'La Puebla de Almoradiel',	'La Puebla de Almoradiel',	1,	25534,	'2019-03-16 03:59:51',	'La Puebla de Almoradiel',	'La Puebla de Almoradiel',	'La Puebla de Almoradiel'),
(2515624,	67,	2521383,	'sa Pobla',	'sa Pobla',	'sa Pobla',	1,	42145,	'2019-03-16 03:59:51',	'sa Pobla',	'sa Pobla',	'sa Pobla'),
(2515638,	67,	2593110,	'La Playa de Arguineguin',	'La Playa de Arguineguin',	'La Playa de Arguineguin',	1,	25517,	'2019-03-16 03:59:51',	'La Playa de Arguineguin',	'La Playa de Arguineguin',	'La Playa de Arguineguin'),
(2515660,	67,	2593109,	'La Paz',	'La Paz',	'La Paz',	1,	25498,	'2019-03-16 03:59:51',	'La Paz',	'La Paz',	'La Paz'),
(2515679,	67,	2593109,	'La Palma del Condado',	'La Palma del Condado',	'La Palma del Condado',	1,	25494,	'2019-03-16 03:59:51',	'La Palma del Condado',	'La Palma del Condado',	'La Palma del Condado'),
(2515681,	67,	2513413,	'La Palma',	'La Palma',	'La Palma',	1,	25493,	'2019-03-16 03:59:51',	'La Palma',	'La Palma',	'La Palma'),
(2515692,	67,	2593110,	'Ла-Оротава',	'La Orotava',	'La Orotava',	1,	25491,	'2019-03-16 03:59:51',	'La Orotava',	'La Orotava',	'La Orotava'),
(2515698,	67,	2593110,	'La Oliva',	'La Oliva',	'La Oliva',	1,	25490,	'2019-03-16 03:59:51',	'La Oliva',	'La Oliva',	'La Oliva'),
(2515701,	67,	2593113,	'Ла-Нусиа',	'la Nucia',	'la Nucia',	1,	25489,	'2019-03-16 03:59:51',	'la Nucia',	'la Nucia',	'la Nucia'),
(2515705,	67,	2513413,	'La Nora',	'La Nora',	'La Nora',	1,	25486,	'2019-03-16 03:59:51',	'La Nora',	'La Nora',	'La Nora'),
(2515708,	67,	2593109,	'Lanjaron',	'Lanjaron',	'Lanjaron',	1,	26271,	'2019-03-16 03:59:51',	'Lanjaron',	'Lanjaron',	'Lanjaron'),
(2515755,	67,	2593109,	'La Mojonera',	'La Mojonera',	'La Mojonera',	1,	25457,	'2019-03-16 03:59:51',	'La Mojonera',	'La Mojonera',	'La Mojonera'),
(2515772,	67,	2593110,	'La Matanza de Acentejo',	'La Matanza de Acentejo',	'La Matanza de Acentejo',	1,	25439,	'2019-03-16 03:59:51',	'La Matanza de Acentejo',	'La Matanza de Acentejo',	'La Matanza de Acentejo'),
(2515774,	67,	2593111,	'La Matanza',	'La Matanza',	'La Matanza',	1,	25438,	'2019-03-16 03:59:51',	'La Matanza',	'La Matanza',	'La Matanza'),
(2515783,	67,	2593113,	'La Marina',	'La Marina',	'La Marina',	1,	25433,	'2019-03-16 03:59:51',	'La Marina',	'La Marina',	'La Marina'),
(2515791,	67,	2593110,	'La Mancha Blanca',	'La Mancha Blanca',	'La Mancha Blanca',	1,	25432,	'2019-03-16 03:59:51',	'La Mancha Blanca',	'La Mancha Blanca',	'La Mancha Blanca'),
(2515801,	67,	2593109,	'La Luisiana',	'La Luisiana',	'La Luisiana',	1,	25421,	'2019-03-16 03:59:51',	'La Luisiana',	'La Luisiana',	'La Luisiana'),
(2515812,	67,	2593109,	'Ла-Линеа-де-ла-Консепсьон',	'La Linea de la Concepcion',	'La Linea de la Concepcion',	1,	25408,	'2019-03-16 03:59:51',	'La Linea de la Concepcion',	'La Linea de la Concepcion',	'La Linea de la Concepcion'),
(2515896,	67,	2593109,	'La Herradura',	'La Herradura',	'La Herradura',	1,	25384,	'2019-03-16 03:59:51',	'La Herradura',	'La Herradura',	'La Herradura'),
(2515908,	67,	2593109,	'La Guardia de Jaen',	'La Guardia de Jaen',	'La Guardia de Jaen',	1,	25372,	'2019-03-16 03:59:51',	'La Guardia de Jaen',	'La Guardia de Jaen',	'La Guardia de Jaen'),
(2515911,	67,	2593110,	'La Guancha',	'La Guancha',	'La Guancha',	1,	25371,	'2019-03-16 03:59:51',	'La Guancha',	'La Guancha',	'La Guancha'),
(2515922,	67,	2593111,	'La Gineta',	'La Gineta',	'La Gineta',	1,	25348,	'2019-03-16 03:59:51',	'La Gineta',	'La Gineta',	'La Gineta'),
(2515929,	67,	2593112,	'La Garrovilla',	'La Garrovilla',	'La Garrovilla',	1,	25343,	'2019-03-16 03:59:51',	'La Garrovilla',	'La Garrovilla',	'La Garrovilla'),
(2515975,	67,	2593112,	'La Estacion',	'La Estacion',	'La Estacion',	1,	25284,	'2019-03-16 03:59:51',	'La Estacion',	'La Estacion',	'La Estacion'),
(2516004,	67,	2593113,	'L\'Eliana',	'L\'Eliana',	'L\'Eliana',	1,	25089,	'2019-03-16 03:59:51',	'L\'Eliana',	'L\'Eliana',	'L\'Eliana'),
(2516071,	67,	2593109,	'Lachar',	'Lachar',	'Lachar',	1,	25759,	'2019-03-16 03:59:51',	'Lachar',	'Lachar',	'Lachar'),
(2516080,	67,	2593109,	'La Cartuja',	'La Cartuja',	'La Cartuja',	1,	25198,	'2019-03-16 03:59:51',	'La Cartuja',	'La Cartuja',	'La Cartuja'),
(2516088,	67,	2593109,	'La Carolina',	'La Carolina',	'La Carolina',	1,	25197,	'2019-03-16 03:59:51',	'La Carolina',	'La Carolina',	'La Carolina'),
(2516089,	67,	2593109,	'La Carlota',	'La Carlota',	'La Carlota',	1,	25196,	'2019-03-16 03:59:51',	'La Carlota',	'La Carlota',	'La Carlota'),
(2516105,	67,	2593109,	'La Canada de San Urbano',	'La Canada de San Urbano',	'La Canada de San Urbano',	1,	25190,	'2019-03-16 03:59:51',	'La Canada de San Urbano',	'La Canada de San Urbano',	'La Canada de San Urbano'),
(2516112,	67,	2593113,	'La Canada',	'La Canada',	'La Canada',	1,	25189,	'2019-03-16 03:59:51',	'La Canada',	'La Canada',	'La Canada'),
(2516118,	67,	2593109,	'La Campana',	'La Campana',	'La Campana',	1,	25188,	'2019-03-16 03:59:51',	'La Campana',	'La Campana',	'La Campana'),
(2516122,	67,	2593111,	'La Calzada de Calatrava',	'La Calzada de Calatrava',	'La Calzada de Calatrava',	1,	25187,	'2019-03-16 03:59:51',	'La Calzada de Calatrava',	'La Calzada de Calatrava',	'La Calzada de Calatrava'),
(2516192,	67,	2513413,	'La Asomada',	'La Asomada',	'La Asomada',	1,	25130,	'2019-03-16 03:59:51',	'La Asomada',	'La Asomada',	'La Asomada'),
(2516212,	67,	2513413,	'La Aljorra',	'La Aljorra',	'La Aljorra',	1,	25127,	'2019-03-16 03:59:51',	'La Aljorra',	'La Aljorra',	'La Aljorra'),
(2516217,	67,	2593109,	'La Algaba',	'La Algaba',	'La Algaba',	1,	25126,	'2019-03-16 03:59:51',	'La Algaba',	'La Algaba',	'La Algaba'),
(2516228,	67,	2593112,	'La Albuera',	'La Albuera',	'La Albuera',	1,	25125,	'2019-03-16 03:59:51',	'La Albuera',	'La Albuera',	'La Albuera'),
(2516231,	67,	2513413,	'La Alberca',	'La Alberca',	'La Alberca',	1,	25124,	'2019-03-16 03:59:51',	'La Alberca',	'La Alberca',	'La Alberca'),
(2516254,	67,	2593109,	'Jun',	'Jun',	'Jun',	1,	23677,	'2019-03-16 03:59:51',	'Jun',	'Jun',	'Jun'),
(2516255,	67,	2513413,	'Хумилье',	'Jumilla',	'Jumilla',	1,	23675,	'2019-03-16 03:59:51',	'Jumilla',	'Jumilla',	'Jumilla'),
(2516304,	67,	2593109,	'Jodar',	'Jodar',	'Jodar',	1,	23533,	'2019-03-16 03:59:51',	'Jodar',	'Jodar',	'Jodar'),
(2516311,	67,	2593110,	'Jinamar',	'Jinamar',	'Jinamar',	1,	23525,	'2019-03-16 03:59:51',	'Jinamar',	'Jinamar',	'Jinamar'),
(2516315,	67,	2593109,	'Химена-де-ла-Фронтера',	'Jimena de la Frontera',	'Jimena de la Frontera',	1,	23524,	'2019-03-16 03:59:51',	'Jimena de la Frontera',	'Jimena de la Frontera',	'Jimena de la Frontera'),
(2516318,	67,	2593113,	'Jijona',	'Jijona',	'Jijona',	1,	23521,	'2019-03-16 03:59:51',	'Jijona',	'Jijona',	'Jijona'),
(2516322,	67,	2593112,	'Jesus',	'Jesus',	'Jesus',	1,	23496,	'2019-03-16 03:59:51',	'Jesus',	'Jesus',	'Jesus'),
(2516324,	67,	2593113,	'Jerica',	'Jerica',	'Jerica',	1,	23465,	'2019-03-16 03:59:51',	'Jerica',	'Jerica',	'Jerica'),
(2516325,	67,	2593112,	'Херес-де-лос-Кабальерос',	'Jerez de los Caballeros',	'Jerez de los Caballeros',	1,	23464,	'2019-03-16 03:59:51',	'Jerez de los Caballeros',	'Jerez de los Caballeros',	'Jerez de los Caballeros'),
(2516326,	67,	2593109,	'Херес-де-ла-Фронтера',	'Jerez de la Frontera',	'Jerez de la Frontera',	1,	23463,	'2019-03-16 03:59:51',	'Jerez de la Frontera',	'Jerez de la Frontera',	'Jerez de la Frontera'),
(2516327,	67,	2593109,	'Jeres del Marquesado',	'Jeres del Marquesado',	'Jeres del Marquesado',	1,	23462,	'2019-03-16 03:59:51',	'Jeres del Marquesado',	'Jeres del Marquesado',	'Jeres del Marquesado'),
(2516336,	67,	2593113,	'Javea',	'Javea',	'Javea',	1,	23395,	'2019-03-16 03:59:51',	'Javea',	'Javea',	'Javea'),
(2516346,	67,	2593109,	'Jatar',	'Jatar',	'Jatar',	1,	23387,	'2019-03-16 03:59:51',	'Jatar',	'Jatar',	'Jatar'),
(2516369,	67,	2593113,	'Jarafuel',	'Jarafuel',	'Jarafuel',	1,	23350,	'2019-03-16 03:59:51',	'Jarafuel',	'Jarafuel',	'Jarafuel'),
(2516386,	67,	2593109,	'Jamilena',	'Jamilena',	'Jamilena',	1,	23330,	'2019-03-16 03:59:51',	'Jamilena',	'Jamilena',	'Jamilena'),
(2516389,	67,	2593113,	'Jalon',	'Jalon',	'Jalon',	1,	23305,	'2019-03-16 03:59:51',	'Jalon',	'Jalon',	'Jalon'),
(2516395,	67,	2593109,	'Хаэн',	'Jaen',	'Jaen',	1,	23282,	'2019-03-16 03:59:51',	'Jaen',	'Jaen',	'Jaen'),
(2516399,	67,	2593113,	'Jacarilla',	'Jacarilla',	'Jacarilla',	1,	23235,	'2019-03-16 03:59:51',	'Jacarilla',	'Jacarilla',	'Jacarilla'),
(2516401,	67,	2593109,	'Jabugo',	'Jabugo',	'Jabugo',	1,	23233,	'2019-03-16 03:59:51',	'Jabugo',	'Jabugo',	'Jabugo'),
(2516406,	67,	2513413,	'Jabali Nuevo',	'Jabali Nuevo',	'Jabali Nuevo',	1,	23231,	'2019-03-16 03:59:51',	'Jabali Nuevo',	'Jabali Nuevo',	'Jabali Nuevo'),
(2516413,	67,	2593109,	'Iznate',	'Iznate',	'Iznate',	1,	23226,	'2019-03-16 03:59:51',	'Iznate',	'Iznate',	'Iznate'),
(2516414,	67,	2593109,	'Iznalloz',	'Iznalloz',	'Iznalloz',	1,	23225,	'2019-03-16 03:59:51',	'Iznalloz',	'Iznalloz',	'Iznalloz'),
(2516422,	67,	2593111,	'Isso',	'Isso',	'Isso',	1,	23147,	'2019-03-16 03:59:51',	'Isso',	'Isso',	'Isso'),
(2516427,	67,	2513413,	'Isla Plana',	'Isla Plana',	'Isla Plana',	1,	23086,	'2019-03-16 03:59:51',	'Isla Plana',	'Isla Plana',	'Isla Plana'),
(2516431,	67,	2593109,	'Исла-Кристина',	'Isla Cristina',	'Isla Cristina',	1,	23085,	'2019-03-16 03:59:51',	'Isla Cristina',	'Isla Cristina',	'Isla Cristina'),
(2516440,	67,	2593111,	'Iniesta',	'Iniesta',	'Iniesta',	1,	22920,	'2019-03-16 03:59:51',	'Iniesta',	'Iniesta',	'Iniesta'),
(2516443,	67,	2593110,	'Ingenio',	'Ingenio',	'Ingenio',	1,	22899,	'2019-03-16 03:59:51',	'Ingenio',	'Ingenio',	'Ingenio'),
(2516449,	67,	2593111,	'Infantes',	'Infantes',	'Infantes',	1,	22891,	'2019-03-16 03:59:51',	'Infantes',	'Infantes',	'Infantes'),
(2516452,	67,	2521383,	'Инка',	'Inca',	'Inca',	1,	22839,	'2019-03-16 03:59:51',	'Inca',	'Inca',	'Inca'),
(2516455,	67,	2593109,	'Illora',	'Illora',	'Illora',	1,	22792,	'2019-03-16 03:59:51',	'Illora',	'Illora',	'Illora'),
(2516460,	67,	2593110,	'Igueste',	'Igueste',	'Igueste',	1,	22751,	'2019-03-16 03:59:51',	'Igueste',	'Igueste',	'Igueste'),
(2516474,	67,	2593110,	'Icod de los Vinos',	'Icod de los Vinos',	'Icod de los Vinos',	1,	22713,	'2019-03-16 03:59:51',	'Icod de los Vinos',	'Icod de los Vinos',	'Icod de los Vinos'),
(2516475,	67,	2593109,	'Ibros',	'Ibros',	'Ibros',	1,	22700,	'2019-03-16 03:59:51',	'Ibros',	'Ibros',	'Ibros'),
(2516479,	67,	2521383,	'Ибица',	'Ibiza',	'Ibiza',	1,	22698,	'2019-03-16 03:59:51',	'Ibiza',	'Ibiza',	'Ibiza'),
(2516480,	67,	2593113,	'Иби',	'Ibi',	'Ibi',	1,	22695,	'2019-03-16 03:59:51',	'Ibi',	'Ibi',	'Ibi'),
(2516483,	67,	2593112,	'Ibahernando',	'Ibahernando',	'Ibahernando',	1,	22690,	'2019-03-16 03:59:51',	'Ibahernando',	'Ibahernando',	'Ibahernando'),
(2516497,	67,	2593109,	'Huevar',	'Huevar',	'Huevar',	1,	22487,	'2019-03-16 03:59:51',	'Huevar',	'Huevar',	'Huevar'),
(2516499,	67,	2593109,	'Уэтор-Тахар',	'Huetor-Tajar',	'Huetor-Tajar',	1,	22486,	'2019-03-16 03:59:51',	'Huetor-Tajar',	'Huetor-Tajar',	'Huetor-Tajar'),
(2516507,	67,	2593109,	'Уэскар',	'Huescar',	'Huescar',	1,	22483,	'2019-03-16 03:59:51',	'Huescar',	'Huescar',	'Huescar'),
(2516527,	67,	2593113,	'Huertas',	'Huertas',	'Huertas',	1,	22481,	'2019-03-16 03:59:51',	'Huertas',	'Huertas',	'Huertas'),
(2516542,	67,	2593109,	'Huercal-Overa',	'Huercal-Overa',	'Huercal-Overa',	1,	22479,	'2019-03-16 03:59:51',	'Huercal-Overa',	'Huercal-Overa',	'Huercal-Overa'),
(2516543,	67,	2593109,	'Huercal de Almeria',	'Huercal de Almeria',	'Huercal de Almeria',	1,	22478,	'2019-03-16 03:59:51',	'Huercal de Almeria',	'Huercal de Almeria',	'Huercal de Almeria'),
(2516548,	67,	2593109,	'Уэльва',	'Huelva',	'Huelva',	1,	22476,	'2019-03-16 03:59:51',	'Huelva',	'Huelva',	'Huelva'),
(2516549,	67,	2593109,	'Huelma',	'Huelma',	'Huelma',	1,	22475,	'2019-03-16 03:59:51',	'Huelma',	'Huelma',	'Huelma'),
(2516583,	67,	2593111,	'Hoya-Gonzalo',	'Hoya-Gonzalo',	'Hoya-Gonzalo',	1,	22415,	'2019-03-16 03:59:51',	'Hoya-Gonzalo',	'Hoya-Gonzalo',	'Hoya-Gonzalo'),
(2516608,	67,	2513413,	'Hortichuela',	'Hortichuela',	'Hortichuela',	1,	22307,	'2019-03-16 03:59:51',	'Hortichuela',	'Hortichuela',	'Hortichuela'),
(2516630,	67,	2593109,	'Hornachuelos',	'Hornachuelos',	'Hornachuelos',	1,	22261,	'2019-03-16 03:59:51',	'Hornachuelos',	'Hornachuelos',	'Hornachuelos'),
(2516656,	67,	2593113,	'Hondon de las Nieves',	'Hondon de las Nieves',	'Hondon de las Nieves',	1,	22157,	'2019-03-16 03:59:51',	'Hondon de las Nieves',	'Hondon de las Nieves',	'Hondon de las Nieves'),
(2516695,	67,	2593109,	'Hinojosa del Duque',	'Hinojosa del Duque',	'Hinojosa del Duque',	1,	21808,	'2019-03-16 03:59:51',	'Hinojosa del Duque',	'Hinojosa del Duque',	'Hinojosa del Duque'),
(2516697,	67,	2593109,	'Hinojos',	'Hinojos',	'Hinojos',	1,	21807,	'2019-03-16 03:59:51',	'Hinojos',	'Hinojos',	'Hinojos'),
(2516708,	67,	2593109,	'Hijar',	'Hijar',	'Hijar',	1,	21698,	'2019-03-16 03:59:51',	'Hijar',	'Hijar',	'Hijar'),
(2516773,	67,	2593109,	'Herrera',	'Herrera',	'Herrera',	1,	21496,	'2019-03-16 03:59:51',	'Herrera',	'Herrera',	'Herrera'),
(2516779,	67,	2593109,	'Hernan-Valle',	'Hernan-Valle',	'Hernan-Valle',	1,	21472,	'2019-03-16 03:59:51',	'Hernan-Valle',	'Hernan-Valle',	'Hernan-Valle'),
(2516790,	67,	2593111,	'Herencia',	'Herencia',	'Herencia',	1,	21421,	'2019-03-16 03:59:51',	'Herencia',	'Herencia',	'Herencia'),
(2516793,	67,	2593109,	'Henares',	'Henares',	'Henares',	1,	21325,	'2019-03-16 03:59:51',	'Henares',	'Henares',	'Henares'),
(2516797,	67,	2593111,	'Эльине',	'Hellin',	'Hellin',	1,	21269,	'2019-03-16 03:59:51',	'Hellin',	'Hellin',	'Hellin'),
(2516852,	67,	2593110,	'Guimar',	'Guimar',	'Guimar',	1,	20142,	'2019-03-16 03:59:51',	'Guimar',	'Guimar',	'Guimar'),
(2516855,	67,	2593109,	'Guillena',	'Guillena',	'Guillena',	1,	20135,	'2019-03-16 03:59:51',	'Guillena',	'Guillena',	'Guillena'),
(2516860,	67,	2593110,	'Guia de Isora',	'Guia de Isora',	'Guia de Isora',	1,	20103,	'2019-03-16 03:59:51',	'Guia de Isora',	'Guia de Isora',	'Guia de Isora'),
(2516865,	67,	2593109,	'Guevejar',	'Guevejar',	'Guevejar',	1,	20096,	'2019-03-16 03:59:51',	'Guevejar',	'Guevejar',	'Guevejar'),
(2516873,	67,	2593109,	'Guejar-Sierra',	'Guejar-Sierra',	'Guejar-Sierra',	1,	20061,	'2019-03-16 03:59:51',	'Guejar-Sierra',	'Guejar-Sierra',	'Guejar-Sierra'),
(2516887,	67,	2593109,	'Guarroman',	'Guarroman',	'Guarroman',	1,	20041,	'2019-03-16 03:59:51',	'Guarroman',	'Guarroman',	'Guarroman'),
(2516892,	67,	2593109,	'Guaro',	'Guaro',	'Guaro',	1,	20040,	'2019-03-16 03:59:51',	'Guaro',	'Guaro',	'Guaro'),
(2516896,	67,	2593112,	'Guarena',	'Guarena',	'Guarena',	1,	20039,	'2019-03-16 03:59:51',	'Guarena',	'Guarena',	'Guarena'),
(2516902,	67,	2593113,	'Guardamar del Segura',	'Guardamar del Segura',	'Guardamar del Segura',	1,	20033,	'2019-03-16 03:59:51',	'Guardamar del Segura',	'Guardamar del Segura',	'Guardamar del Segura'),
(2516912,	67,	2593110,	'Guamasa',	'Guamasa',	'Guamasa',	1,	20029,	'2019-03-16 03:59:51',	'Guamasa',	'Guamasa',	'Guamasa'),
(2516925,	67,	2593109,	'Гвадикс',	'Guadix',	'Guadix',	1,	20022,	'2019-03-16 03:59:51',	'Guadix',	'Guadix',	'Guadix'),
(2516970,	67,	2593112,	'Гвадалупе',	'Guadalupe',	'Guadalupe',	1,	20019,	'2019-03-16 03:59:51',	'Guadalupe',	'Guadalupe',	'Guadalupe'),
(2516972,	67,	2513413,	'Guadalupe',	'Guadalupe',	'Guadalupe',	1,	20018,	'2019-03-16 03:59:51',	'Guadalupe',	'Guadalupe',	'Guadalupe'),
(2516995,	67,	2593113,	'Guadalest',	'Guadalest',	'Guadalest',	1,	20016,	'2019-03-16 03:59:51',	'Guadalest',	'Guadalest',	'Guadalest'),
(2517004,	67,	2593109,	'Guadalcazar',	'Guadalcazar',	'Guadalcazar',	1,	20015,	'2019-03-16 03:59:51',	'Guadalcazar',	'Guadalcazar',	'Guadalcazar'),
(2517049,	67,	2593109,	'Grazalema',	'Grazalema',	'Grazalema',	1,	19535,	'2019-03-16 03:59:51',	'Grazalema',	'Grazalema',	'Grazalema'),
(2517056,	67,	2593110,	'Gran Tarajal',	'Gran Tarajal',	'Gran Tarajal',	1,	19327,	'2019-03-16 03:59:51',	'Gran Tarajal',	'Gran Tarajal',	'Gran Tarajal'),
(2517059,	67,	2593112,	'Granja de Torrehermosa',	'Granja de Torrehermosa',	'Granja de Torrehermosa',	1,	19432,	'2019-03-16 03:59:51',	'Granja de Torrehermosa',	'Granja de Torrehermosa',	'Granja de Torrehermosa'),
(2517060,	67,	2593113,	'Granja de Rocamora',	'Granja de Rocamora',	'Granja de Rocamora',	1,	19431,	'2019-03-16 03:59:51',	'Granja de Rocamora',	'Granja de Rocamora',	'Granja de Rocamora'),
(2517111,	67,	2593110,	'Granadilla de Abona',	'Granadilla de Abona',	'Granadilla de Abona',	1,	19331,	'2019-03-16 03:59:51',	'Granadilla de Abona',	'Granadilla de Abona',	'Granadilla de Abona'),
(2517117,	67,	2593109,	'Гранада',	'Granada',	'Granada',	1,	19329,	'2019-03-16 03:59:51',	'Granada',	'Granada',	'Granada'),
(2517197,	67,	2593109,	'Gojar',	'Gojar',	'Gojar',	1,	18973,	'2019-03-16 03:59:51',	'Gojar',	'Gojar',	'Gojar'),
(2517199,	67,	2593113,	'Godelleta',	'Godelleta',	'Godelleta',	1,	18941,	'2019-03-16 03:59:51',	'Godelleta',	'Godelleta',	'Godelleta'),
(2517200,	67,	2593113,	'Godella',	'Godella',	'Godella',	1,	18940,	'2019-03-16 03:59:51',	'Godella',	'Godella',	'Godella'),
(2517217,	67,	2593109,	'Gines',	'Gines',	'Gines',	1,	18684,	'2019-03-16 03:59:51',	'Gines',	'Gines',	'Gines'),
(2517223,	67,	2593113,	'Gilet',	'Gilet',	'Gilet',	1,	18641,	'2019-03-16 03:59:51',	'Gilet',	'Gilet',	'Gilet'),
(2517236,	67,	2593109,	'Gibraleon',	'Gibraleon',	'Gibraleon',	1,	18582,	'2019-03-16 03:59:51',	'Gibraleon',	'Gibraleon',	'Gibraleon'),
(2517247,	67,	2593109,	'Gergal',	'Gergal',	'Gergal',	1,	18451,	'2019-03-16 03:59:51',	'Gergal',	'Gergal',	'Gergal'),
(2517249,	67,	2593109,	'Gerena',	'Gerena',	'Gerena',	1,	18448,	'2019-03-16 03:59:51',	'Gerena',	'Gerena',	'Gerena'),
(2517252,	67,	2593113,	'Genoves',	'Genoves',	'Genoves',	1,	18385,	'2019-03-16 03:59:51',	'Genoves',	'Genoves',	'Genoves'),
(2517262,	67,	2593109,	'Gelves',	'Gelves',	'Gelves',	1,	18322,	'2019-03-16 03:59:51',	'Gelves',	'Gelves',	'Gelves'),
(2517264,	67,	2593113,	'Geldo',	'Geldo',	'Geldo',	1,	18308,	'2019-03-16 03:59:51',	'Geldo',	'Geldo',	'Geldo'),
(2517298,	67,	2593113,	'Gata de Gorgos',	'Gata de Gorgos',	'Gata de Gorgos',	1,	18185,	'2019-03-16 03:59:51',	'Gata de Gorgos',	'Gata de Gorgos',	'Gata de Gorgos'),
(2517310,	67,	2593109,	'Garrucha',	'Garrucha',	'Garrucha',	1,	18146,	'2019-03-16 03:59:51',	'Garrucha',	'Garrucha',	'Garrucha'),
(2517367,	67,	2593113,	'Гандия',	'Gandia',	'Gandia',	1,	18025,	'2019-03-16 03:59:51',	'Gandia',	'Gandia',	'Gandia'),
(2517383,	67,	2593111,	'Galvez',	'Galvez',	'Galvez',	1,	17994,	'2019-03-16 03:59:51',	'Galvez',	'Galvez',	'Galvez'),
(2517409,	67,	2593112,	'Galisteo',	'Galisteo',	'Galisteo',	1,	17956,	'2019-03-16 03:59:51',	'Galisteo',	'Galisteo',	'Galisteo'),
(2517436,	67,	2593110,	'Гальдар',	'Galdar',	'Galdar',	1,	17936,	'2019-03-16 03:59:51',	'Galdar',	'Galdar',	'Galdar'),
(2517440,	67,	2593109,	'Galaroza',	'Galaroza',	'Galaroza',	1,	17925,	'2019-03-16 03:59:51',	'Galaroza',	'Galaroza',	'Galaroza'),
(2517482,	67,	2593109,	'Fuerte del Rey',	'Fuerte del Rey',	'Fuerte del Rey',	1,	17786,	'2019-03-16 03:59:51',	'Fuerte del Rey',	'Fuerte del Rey',	'Fuerte del Rey'),
(2517493,	67,	2593109,	'Fuente Vaqueros',	'Fuente Vaqueros',	'Fuente Vaqueros',	1,	17777,	'2019-03-16 03:59:51',	'Fuente Vaqueros',	'Fuente Vaqueros',	'Fuente Vaqueros'),
(2517500,	67,	2593109,	'Fuentes de Andalucia',	'Fuentes de Andalucia',	'Fuentes de Andalucia',	1,	17783,	'2019-03-16 03:59:51',	'Fuentes de Andalucia',	'Fuentes de Andalucia',	'Fuentes de Andalucia'),
(2517512,	67,	2593109,	'Fuente Palmera',	'Fuente Palmera',	'Fuente Palmera',	1,	17776,	'2019-03-16 03:59:51',	'Fuente Palmera',	'Fuente Palmera',	'Fuente Palmera'),
(2517515,	67,	2593109,	'Fuente Obejuna',	'Fuente Obejuna',	'Fuente Obejuna',	1,	17775,	'2019-03-16 03:59:51',	'Fuente Obejuna',	'Fuente Obejuna',	'Fuente Obejuna'),
(2517527,	67,	2593109,	'Fuenteheridos',	'Fuenteheridos',	'Fuenteheridos',	1,	17780,	'2019-03-16 03:59:51',	'Fuenteheridos',	'Fuenteheridos',	'Fuenteheridos'),
(2517530,	67,	2593111,	'Fuente el Fresno',	'Fuente el Fresno',	'Fuente el Fresno',	1,	17772,	'2019-03-16 03:59:51',	'Fuente el Fresno',	'Fuente el Fresno',	'Fuente el Fresno'),
(2517534,	67,	2593109,	'Fuente de Piedra',	'Fuente de Piedra',	'Fuente de Piedra',	1,	17770,	'2019-03-16 03:59:51',	'Fuente de Piedra',	'Fuente de Piedra',	'Fuente de Piedra'),
(2517535,	67,	2593111,	'Fuente de Pedro Naharro',	'Fuente de Pedro Naharro',	'Fuente de Pedro Naharro',	1,	17769,	'2019-03-16 03:59:51',	'Fuente de Pedro Naharro',	'Fuente de Pedro Naharro',	'Fuente de Pedro Naharro'),
(2517547,	67,	2593112,	'Fuente del Maestre',	'Fuente del Maestre',	'Fuente del Maestre',	1,	17771,	'2019-03-16 03:59:51',	'Fuente del Maestre',	'Fuente del Maestre',	'Fuente del Maestre'),
(2517560,	67,	2593112,	'Fuente de Cantos',	'Fuente de Cantos',	'Fuente de Cantos',	1,	17768,	'2019-03-16 03:59:51',	'Fuente de Cantos',	'Fuente de Cantos',	'Fuente de Cantos'),
(2517573,	67,	2593111,	'Fuentealbilla',	'Fuentealbilla',	'Fuentealbilla',	1,	17779,	'2019-03-16 03:59:51',	'Fuentealbilla',	'Fuentealbilla',	'Fuentealbilla'),
(2517576,	67,	2593111,	'Fuente-Alamo',	'Fuente-Alamo',	'Fuente-Alamo',	1,	17778,	'2019-03-16 03:59:51',	'Fuente-Alamo',	'Fuente-Alamo',	'Fuente-Alamo'),
(2517581,	67,	2593109,	'Fuensanta de Martos',	'Fuensanta de Martos',	'Fuensanta de Martos',	1,	17767,	'2019-03-16 03:59:51',	'Fuensanta de Martos',	'Fuensanta de Martos',	'Fuensanta de Martos'),
(2517591,	67,	2593112,	'Fuenlabrada de los Montes',	'Fuenlabrada de los Montes',	'Fuenlabrada de los Montes',	1,	17765,	'2019-03-16 03:59:51',	'Fuenlabrada de los Montes',	'Fuenlabrada de los Montes',	'Fuenlabrada de los Montes'),
(2517595,	67,	2593109,	'Фуэнхирола',	'Fuengirola',	'Fuengirola',	1,	17763,	'2019-03-16 03:59:51',	'Fuengirola',	'Fuengirola',	'Fuengirola'),
(2517643,	67,	2593112,	'Фрехеналь-де-ла-Сьерра',	'Fregenal de la Sierra',	'Fregenal de la Sierra',	1,	17522,	'2019-03-16 03:59:51',	'Fregenal de la Sierra',	'Fregenal de la Sierra',	'Fregenal de la Sierra'),
(2517679,	67,	2513413,	'Fortuna',	'Fortuna',	'Fortuna',	1,	17225,	'2019-03-16 03:59:51',	'Fortuna',	'Fortuna',	'Fortuna'),
(2517689,	67,	2593113,	'Formentera de Segura',	'Formentera de Segura',	'Formentera de Segura',	1,	17097,	'2019-03-16 03:59:51',	'Formentera de Segura',	'Formentera de Segura',	'Formentera de Segura'),
(2517717,	67,	2593110,	'Firgas',	'Firgas',	'Firgas',	1,	16662,	'2019-03-16 03:59:51',	'Firgas',	'Firgas',	'Firgas'),
(2517719,	67,	2593113,	'Finestrat',	'Finestrat',	'Finestrat',	1,	16640,	'2019-03-16 03:59:51',	'Finestrat',	'Finestrat',	'Finestrat'),
(2517733,	67,	2521383,	'Ferreries',	'Ferreries',	'Ferreries',	1,	16527,	'2019-03-16 03:59:51',	'Ferreries',	'Ferreries',	'Ferreries'),
(2517740,	67,	2593109,	'Fernan-Nunez',	'Fernan-Nunez',	'Fernan-Nunez',	1,	16499,	'2019-03-16 03:59:51',	'Fernan-Nunez',	'Fernan-Nunez',	'Fernan-Nunez'),
(2517750,	67,	2521383,	'Felanitx',	'Felanitx',	'Felanitx',	1,	16422,	'2019-03-16 03:59:51',	'Felanitx',	'Felanitx',	'Felanitx'),
(2517755,	67,	2593113,	'Faura',	'Faura',	'Faura',	1,	16346,	'2019-03-16 03:59:51',	'Faura',	'Faura',	'Faura'),
(2517763,	67,	2593110,	'Fasnia',	'Fasnia',	'Fasnia',	1,	16324,	'2019-03-16 03:59:51',	'Fasnia',	'Fasnia',	'Fasnia'),
(2517816,	67,	2593109,	'Эстепона',	'Estepona',	'Estepona',	1,	15791,	'2019-03-16 03:59:51',	'Estepona',	'Estepona',	'Estepona'),
(2517820,	67,	2593109,	'Estepa',	'Estepa',	'Estepa',	1,	15790,	'2019-03-16 03:59:51',	'Estepa',	'Estepa',	'Estepa'),
(2517827,	67,	2521383,	'Estellencs',	'Estellencs',	'Estellencs',	1,	15787,	'2019-03-16 03:59:51',	'Estellencs',	'Estellencs',	'Estellencs'),
(2517891,	67,	2513413,	'Espinardo',	'Espinardo',	'Espinardo',	1,	15728,	'2019-03-16 03:59:51',	'Espinardo',	'Espinardo',	'Espinardo'),
(2517900,	67,	2593109,	'Espejo',	'Espejo',	'Espejo',	1,	15715,	'2019-03-16 03:59:51',	'Espejo',	'Espejo',	'Espejo'),
(2517903,	67,	2593109,	'Espartinas',	'Espartinas',	'Espartinas',	1,	15712,	'2019-03-16 03:59:51',	'Espartinas',	'Espartinas',	'Espartinas'),
(2517925,	67,	2593109,	'Escuzar',	'Escuzar',	'Escuzar',	1,	15681,	'2019-03-16 03:59:51',	'Escuzar',	'Escuzar',	'Escuzar'),
(2517955,	67,	2593111,	'Escalonilla',	'Escalonilla',	'Escalonilla',	1,	15639,	'2019-03-16 03:59:51',	'Escalonilla',	'Escalonilla',	'Escalonilla'),
(2517989,	67,	2593113,	'L\'Enova',	'L\'Enova',	'L\'Enova',	1,	25090,	'2019-03-16 03:59:51',	'L\'Enova',	'L\'Enova',	'L\'Enova'),
(2518011,	67,	2593113,	'Enguera',	'Enguera',	'Enguera',	1,	15378,	'2019-03-16 03:59:51',	'Enguera',	'Enguera',	'Enguera'),
(2518020,	67,	2593109,	'Encinasola',	'Encinasola',	'Encinasola',	1,	15336,	'2019-03-16 03:59:51',	'Encinasola',	'Encinasola',	'Encinasola'),
(2518040,	67,	2593109,	'El Viso del Alcor',	'El Viso del Alcor',	'El Viso del Alcor',	1,	14966,	'2019-03-16 03:59:51',	'El Viso del Alcor',	'El Viso del Alcor',	'El Viso del Alcor'),
(2518070,	67,	2593111,	'El Torno',	'El Torno',	'El Torno',	1,	14961,	'2019-03-16 03:59:51',	'El Torno',	'El Torno',	'El Torno'),
(2518093,	67,	2593110,	'El Tablero',	'El Tablero',	'El Tablero',	1,	14959,	'2019-03-16 03:59:51',	'El Tablero',	'El Tablero',	'El Tablero'),
(2518113,	67,	2593109,	'El Saucejo',	'El Saucejo',	'El Saucejo',	1,	14955,	'2019-03-16 03:59:51',	'El Saucejo',	'El Saucejo',	'El Saucejo'),
(2518120,	67,	2593113,	'El Saler',	'El Saler',	'El Saler',	1,	14954,	'2019-03-16 03:59:51',	'El Saler',	'El Saler',	'El Saler'),
(2518129,	67,	2593109,	'El Rubio',	'El Rubio',	'El Rubio',	1,	14953,	'2019-03-16 03:59:51',	'El Rubio',	'El Rubio',	'El Rubio'),
(2518147,	67,	2593109,	'El Rompido',	'El Rompido',	'El Rompido',	1,	14952,	'2019-03-16 03:59:51',	'El Rompido',	'El Rompido',	'El Rompido'),
(2518157,	67,	2593109,	'El Rocio',	'El Rocio',	'El Rocio',	1,	14951,	'2019-03-16 03:59:51',	'El Rocio',	'El Rocio',	'El Rocio'),
(2518187,	67,	2593109,	'El Real de la Jara',	'El Real de la Jara',	'El Real de la Jara',	1,	14948,	'2019-03-16 03:59:51',	'El Real de la Jara',	'El Real de la Jara',	'El Real de la Jara'),
(2518193,	67,	2513413,	'El Raal',	'El Raal',	'El Raal',	1,	14947,	'2019-03-16 03:59:51',	'El Raal',	'El Raal',	'El Raal'),
(2518203,	67,	2513413,	'El Puntal',	'El Puntal',	'El Puntal',	1,	14946,	'2019-03-16 03:59:51',	'El Puntal',	'El Puntal',	'El Puntal'),
(2518207,	67,	2593109,	'Эль-Пуэрто-де-Санта-Мария',	'El Puerto de Santa Maria',	'El Puerto de Santa Maria',	1,	14945,	'2019-03-16 03:59:51',	'El Puerto de Santa Maria',	'El Puerto de Santa Maria',	'El Puerto de Santa Maria'),
(2518210,	67,	2593113,	'El Port de Sagunt',	'El Port de Sagunt',	'El Port de Sagunt',	1,	14941,	'2019-03-16 03:59:51',	'El Port de Sagunt',	'El Port de Sagunt',	'El Port de Sagunt'),
(2518224,	67,	2593111,	'El Provencio',	'El Provencio',	'El Provencio',	1,	14944,	'2019-03-16 03:59:51',	'El Provencio',	'El Provencio',	'El Provencio'),
(2518244,	67,	2521383,	'Port de Soller',	'Port de Soller',	'Port de Soller',	1,	38851,	'2019-03-16 03:59:51',	'Port de Soller',	'Port de Soller',	'Port de Soller'),
(2518292,	67,	2593109,	'El Palmar de Troya',	'El Palmar de Troya',	'El Palmar de Troya',	1,	14934,	'2019-03-16 03:59:51',	'El Palmar de Troya',	'El Palmar de Troya',	'El Palmar de Troya'),
(2518293,	67,	2593113,	'El Palmar',	'El Palmar',	'El Palmar',	1,	14933,	'2019-03-16 03:59:51',	'El Palmar',	'El Palmar',	'El Palmar'),
(2518294,	67,	2513413,	'El Palmar',	'El Palmar',	'El Palmar',	1,	14932,	'2019-03-16 03:59:51',	'El Palmar',	'El Palmar',	'El Palmar'),
(2518346,	67,	2593110,	'Эль Медано',	'El Medano',	'El Medano',	1,	14927,	'2019-03-16 03:59:51',	'El Medano',	'El Medano',	'El Medano'),
(2518440,	67,	2593109,	'El Guijo',	'El Guijo',	'El Guijo',	1,	14923,	'2019-03-16 03:59:51',	'El Guijo',	'El Guijo',	'El Guijo'),
(2518494,	67,	2593109,	'Эль-Эхидо',	'El Ejido',	'El Ejido',	1,	14919,	'2019-03-16 03:59:51',	'El Ejido',	'El Ejido',	'El Ejido'),
(2518505,	67,	2593113,	'Эльда',	'Elda',	'Elda',	1,	14987,	'2019-03-16 03:59:51',	'Elda',	'Elda',	'Elda'),
(2518521,	67,	2593109,	'El Coronil',	'El Coronil',	'El Coronil',	1,	14912,	'2019-03-16 03:59:51',	'El Coronil',	'El Coronil',	'El Coronil'),
(2518559,	67,	2593113,	'Эльч',	'Elche',	'Elche',	1,	14984,	'2019-03-16 03:59:51',	'Elche',	'Elche',	'Elche'),
(2518597,	67,	2593112,	'El Casar',	'El Casar',	'El Casar',	1,	14906,	'2019-03-16 03:59:51',	'El Casar',	'El Casar',	'El Casar'),
(2518636,	67,	2593109,	'El Campillo de Rodalquilar',	'El Campillo de Rodalquilar',	'El Campillo de Rodalquilar',	1,	14903,	'2019-03-16 03:59:51',	'El Campillo de Rodalquilar',	'El Campillo de Rodalquilar',	'El Campillo de Rodalquilar'),
(2518682,	67,	2593109,	'El Bosque',	'El Bosque',	'El Bosque',	1,	14898,	'2019-03-16 03:59:51',	'El Bosque',	'El Bosque',	'El Bosque'),
(2518723,	67,	2521383,	'Ареналь',	's\'Arenal',	's\'Arenal',	1,	42144,	'2019-03-16 03:59:51',	's\'Arenal',	's\'Arenal',	's\'Arenal'),
(2518729,	67,	2593109,	'El Arahal',	'El Arahal',	'El Arahal',	1,	14895,	'2019-03-16 03:59:51',	'El Arahal',	'El Arahal',	'El Arahal'),
(2518740,	67,	2593109,	'El Almendro',	'El Almendro',	'El Almendro',	1,	14894,	'2019-03-16 03:59:51',	'El Almendro',	'El Almendro',	'El Almendro'),
(2518755,	67,	2593109,	'El Alamo',	'El Alamo',	'El Alamo',	1,	14893,	'2019-03-16 03:59:51',	'El Alamo',	'El Alamo',	'El Alamo'),
(2518766,	67,	2593110,	'El Abrigo',	'El Abrigo',	'El Abrigo',	1,	14891,	'2019-03-16 03:59:51',	'El Abrigo',	'El Abrigo',	'El Abrigo'),
(2518770,	67,	2593109,	'Эсиха',	'Ecija',	'Ecija',	1,	14608,	'2019-03-16 03:59:51',	'Ecija',	'Ecija',	'Ecija'),
(2518774,	67,	2593109,	'Durcal',	'Durcal',	'Durcal',	1,	14230,	'2019-03-16 03:59:51',	'Durcal',	'Durcal',	'Durcal'),
(2518794,	67,	2593109,	'Dos Hermanas',	'Dos Hermanas',	'Dos Hermanas',	1,	13836,	'2019-03-16 03:59:51',	'Dos Hermanas',	'Dos Hermanas',	'Dos Hermanas'),
(2518796,	67,	2593111,	'Dosbarrios',	'Dosbarrios',	'Dosbarrios',	1,	13838,	'2019-03-16 03:59:51',	'Dosbarrios',	'Dosbarrios',	'Dosbarrios'),
(2518820,	67,	2593112,	'Дон-Бенито',	'Don Benito',	'Don Benito',	1,	13720,	'2019-03-16 03:59:51',	'Don Benito',	'Don Benito',	'Don Benito'),
(2518840,	67,	2593113,	'Domeno',	'Domeno',	'Domeno',	1,	13685,	'2019-03-16 03:59:51',	'Domeno',	'Domeno',	'Domeno'),
(2518842,	67,	2593113,	'Dolores',	'Dolores',	'Dolores',	1,	13668,	'2019-03-16 03:59:51',	'Dolores',	'Dolores',	'Dolores'),
(2518849,	67,	2593109,	'Dilar',	'Dilar',	'Dilar',	1,	13475,	'2019-03-16 03:59:51',	'Dilar',	'Dilar',	'Dilar'),
(2518850,	67,	2593109,	'Diezma',	'Diezma',	'Diezma',	1,	13463,	'2019-03-16 03:59:51',	'Diezma',	'Diezma',	'Diezma'),
(2518878,	67,	2593113,	'Дения',	'Denia',	'Denia',	1,	13188,	'2019-03-16 03:59:51',	'Denia',	'Denia',	'Denia'),
(2518892,	67,	2593109,	'Dehesas Viejas',	'Dehesas Viejas',	'Dehesas Viejas',	1,	13084,	'2019-03-16 03:59:51',	'Dehesas Viejas',	'Dehesas Viejas',	'Dehesas Viejas'),
(2518921,	67,	2593109,	'Dalias',	'Dalias',	'Dalias',	1,	12705,	'2019-03-16 03:59:51',	'Dalias',	'Dalias',	'Dalias'),
(2518924,	67,	2593111,	'Daimiel',	'Daimiel',	'Daimiel',	1,	12679,	'2019-03-16 03:59:51',	'Daimiel',	'Daimiel',	'Daimiel'),
(2518949,	67,	2593113,	'Кульера',	'Cullera',	'Cullera',	1,	12507,	'2019-03-16 03:59:51',	'Cullera',	'Cullera',	'Cullera'),
(2518950,	67,	2593109,	'Cullar-Vega',	'Cullar-Vega',	'Cullar-Vega',	1,	12503,	'2019-03-16 03:59:51',	'Cullar-Vega',	'Cullar-Vega',	'Cullar-Vega'),
(2518969,	67,	2593109,	'Cuevas de San Marcos',	'Cuevas de San Marcos',	'Cuevas de San Marcos',	1,	12474,	'2019-03-16 03:59:51',	'Cuevas de San Marcos',	'Cuevas de San Marcos',	'Cuevas de San Marcos'),
(2518972,	67,	2513413,	'Cuevas de Reyllo',	'Cuevas de Reyllo',	'Cuevas de Reyllo',	1,	12473,	'2019-03-16 03:59:51',	'Cuevas de Reyllo',	'Cuevas de Reyllo',	'Cuevas de Reyllo'),
(2518988,	67,	2593109,	'Куэвас-дель-Альмансора',	'Cuevas del Almanzora',	'Cuevas del Almanzora',	1,	12475,	'2019-03-16 03:59:51',	'Cuevas del Almanzora',	'Cuevas del Almanzora',	'Cuevas del Almanzora'),
(2519072,	67,	2593110,	'Cruz Santa',	'Cruz Santa',	'Cruz Santa',	1,	12433,	'2019-03-16 03:59:51',	'Cruz Santa',	'Cruz Santa',	'Cruz Santa'),
(2519110,	67,	2593113,	'Кревильенте',	'Crevillente',	'Crevillente',	1,	12262,	'2019-03-16 03:59:51',	'Crevillente',	'Crevillente',	'Crevillente'),
(2519120,	67,	2593113,	'Cox',	'Cox',	'Cox',	1,	12080,	'2019-03-16 03:59:51',	'Cox',	'Cox',	'Cox'),
(2519139,	67,	2521383,	'Costitx',	'Costitx',	'Costitx',	1,	11854,	'2019-03-16 03:59:51',	'Costitx',	'Costitx',	'Costitx'),
(2519149,	67,	2513413,	'Corvera',	'Corvera',	'Corvera',	1,	11814,	'2019-03-16 03:59:51',	'Corvera',	'Corvera',	'Corvera'),
(2519201,	67,	2593109,	'Cortes',	'Cortes',	'Cortes',	1,	11798,	'2019-03-16 03:59:51',	'Cortes',	'Cortes',	'Cortes'),
(2519206,	67,	2593109,	'Cortegana',	'Cortegana',	'Cortegana',	1,	11795,	'2019-03-16 03:59:51',	'Cortegana',	'Cortegana',	'Cortegana'),
(2519215,	67,	2593109,	'Corrales',	'Corrales',	'Corrales',	1,	11767,	'2019-03-16 03:59:51',	'Corrales',	'Corrales',	'Corrales'),
(2519217,	67,	2593110,	'Коральехо',	'Corralejo',	'Corralejo',	1,	11765,	'2019-03-16 03:59:51',	'Corralejo',	'Corralejo',	'Corralejo'),
(2519233,	67,	2593109,	'Кориа-дель-Рио',	'Coria del Rio',	'Coria del Rio',	1,	11676,	'2019-03-16 03:59:51',	'Coria del Rio',	'Coria del Rio',	'Coria del Rio'),
(2519234,	67,	2593112,	'Coria',	'Coria',	'Coria',	1,	11675,	'2019-03-16 03:59:51',	'Coria',	'Coria',	'Coria'),
(2519240,	67,	2593109,	'Кордова',	'Cordoba',	'Cordoba',	1,	11656,	'2019-03-16 03:59:51',	'Cordoba',	'Cordoba',	'Cordoba'),
(2519252,	67,	2593112,	'Corchuela',	'Corchuela',	'Corchuela',	1,	11644,	'2019-03-16 03:59:51',	'Corchuela',	'Corchuela',	'Corchuela'),
(2519277,	67,	2593111,	'Consuegra',	'Consuegra',	'Consuegra',	1,	11520,	'2019-03-16 03:59:51',	'Consuegra',	'Consuegra',	'Consuegra'),
(2519278,	67,	2593109,	'Constantina',	'Constantina',	'Constantina',	1,	11518,	'2019-03-16 03:59:51',	'Constantina',	'Constantina',	'Constantina'),
(2519283,	67,	2521383,	'Consell',	'Consell',	'Consell',	1,	11509,	'2019-03-16 03:59:51',	'Consell',	'Consell',	'Consell'),
(2519289,	67,	2593109,	'Conil de la Frontera',	'Conil de la Frontera',	'Conil de la Frontera',	1,	11482,	'2019-03-16 03:59:51',	'Conil de la Frontera',	'Conil de la Frontera',	'Conil de la Frontera'),
(2519319,	67,	2593109,	'Competa',	'Competa',	'Competa',	1,	11393,	'2019-03-16 03:59:51',	'Competa',	'Competa',	'Competa'),
(2519325,	67,	2593109,	'Comares',	'Comares',	'Comares',	1,	11342,	'2019-03-16 03:59:51',	'Comares',	'Comares',	'Comares'),
(2519352,	67,	2593109,	'Colmenar',	'Colmenar',	'Colmenar',	1,	11221,	'2019-03-16 03:59:51',	'Colmenar',	'Colmenar',	'Colmenar'),
(2519367,	67,	2593109,	'Coin',	'Coin',	'Coin',	1,	11080,	'2019-03-16 03:59:51',	'Coin',	'Coin',	'Coin'),
(2519373,	67,	2593113,	'Cofrentes',	'Cofrentes',	'Cofrentes',	1,	11055,	'2019-03-16 03:59:51',	'Cofrentes',	'Cofrentes',	'Cofrentes'),
(2519382,	67,	2593113,	'Косентайна',	'Cocentaina',	'Cocentaina',	1,	11008,	'2019-03-16 03:59:51',	'Cocentaina',	'Cocentaina',	'Cocentaina'),
(2519385,	67,	2593111,	'Cobisa',	'Cobisa',	'Cobisa',	1,	11002,	'2019-03-16 03:59:51',	'Cobisa',	'Cobisa',	'Cobisa'),
(2519402,	67,	2593111,	'Сьюдад-Реаль',	'Ciudad Real',	'Ciudad Real',	1,	10590,	'2019-03-16 03:59:51',	'Ciudad Real',	'Ciudad Real',	'Ciudad Real'),
(2519409,	67,	2593111,	'Ciruelos',	'Ciruelos',	'Ciruelos',	1,	10558,	'2019-03-16 03:59:51',	'Ciruelos',	'Ciruelos',	'Ciruelos'),
(2519421,	67,	2593109,	'Cijuela',	'Cijuela',	'Cijuela',	1,	10516,	'2019-03-16 03:59:51',	'Cijuela',	'Cijuela',	'Cijuela'),
(2519425,	67,	2513413,	'Сьеса',	'Cieza',	'Cieza',	1,	10511,	'2019-03-16 03:59:51',	'Cieza',	'Cieza',	'Cieza'),
(2519436,	67,	2593109,	'Churriana de la Vega',	'Churriana de la Vega',	'Churriana de la Vega',	1,	10491,	'2019-03-16 03:59:51',	'Churriana de la Vega',	'Churriana de la Vega',	'Churriana de la Vega'),
(2519437,	67,	2593109,	'Churriana',	'Churriana',	'Churriana',	1,	10490,	'2019-03-16 03:59:51',	'Churriana',	'Churriana',	'Churriana'),
(2519438,	67,	2513413,	'Churra',	'Churra',	'Churra',	1,	10489,	'2019-03-16 03:59:51',	'Churra',	'Churra',	'Churra'),
(2519444,	67,	2593113,	'Chulilla',	'Chulilla',	'Chulilla',	1,	10473,	'2019-03-16 03:59:51',	'Chulilla',	'Chulilla',	'Chulilla'),
(2519447,	67,	2593109,	'Chucena',	'Chucena',	'Chucena',	1,	10462,	'2019-03-16 03:59:51',	'Chucena',	'Chucena',	'Chucena'),
(2519449,	67,	2593109,	'Chozas',	'Chozas',	'Chozas',	1,	10444,	'2019-03-16 03:59:51',	'Chozas',	'Chozas',	'Chozas'),
(2519464,	67,	2593113,	'Chiva',	'Chiva',	'Chiva',	1,	10405,	'2019-03-16 03:59:51',	'Chiva',	'Chiva',	'Chiva'),
(2519466,	67,	2593113,	'Чиривелья',	'Xirivella',	'Xirivella',	1,	54841,	'2019-03-16 03:59:51',	'Xirivella',	'Xirivella',	'Xirivella'),
(2519468,	67,	2593109,	'Chirivel',	'Chirivel',	'Chirivel',	1,	10381,	'2019-03-16 03:59:51',	'Chirivel',	'Chirivel',	'Chirivel'),
(2519477,	67,	2593109,	'Chipiona',	'Chipiona',	'Chipiona',	1,	10366,	'2019-03-16 03:59:51',	'Chipiona',	'Chipiona',	'Chipiona'),
(2519483,	67,	2593111,	'Chinchilla de Monte Aragon',	'Chinchilla de Monte Aragon',	'Chinchilla de Monte Aragon',	1,	10350,	'2019-03-16 03:59:51',	'Chinchilla de Monte Aragon',	'Chinchilla de Monte Aragon',	'Chinchilla de Monte Aragon'),
(2519503,	67,	2593113,	'Chilches',	'Chilches',	'Chilches',	1,	10318,	'2019-03-16 03:59:51',	'Chilches',	'Chilches',	'Chilches'),
(2519513,	67,	2593109,	'Чиклана-де-ла-Фронтера',	'Chiclana de la Frontera',	'Chiclana de la Frontera',	1,	10297,	'2019-03-16 03:59:51',	'Chiclana de la Frontera',	'Chiclana de la Frontera',	'Chiclana de la Frontera'),
(2519522,	67,	2593113,	'Cheste',	'Cheste',	'Cheste',	1,	10190,	'2019-03-16 03:59:51',	'Cheste',	'Cheste',	'Cheste'),
(2519528,	67,	2593113,	'Chelva',	'Chelva',	'Chelva',	1,	10082,	'2019-03-16 03:59:51',	'Chelva',	'Chelva',	'Chelva'),
(2519530,	67,	2593112,	'Cheles',	'Cheles',	'Cheles',	1,	10064,	'2019-03-16 03:59:51',	'Cheles',	'Cheles',	'Cheles'),
(2519534,	67,	2593109,	'Chauchina',	'Chauchina',	'Chauchina',	1,	9988,	'2019-03-16 03:59:51',	'Chauchina',	'Chauchina',	'Chauchina'),
(2519579,	67,	2513413,	'Ceuti',	'Ceuti',	'Ceuti',	1,	9485,	'2019-03-16 03:59:51',	'Ceuti',	'Ceuti',	'Ceuti'),
(2519588,	67,	2593109,	'Cerro Muriano',	'Cerro Muriano',	'Cerro Muriano',	1,	9443,	'2019-03-16 03:59:51',	'Cerro Muriano',	'Cerro Muriano',	'Cerro Muriano'),
(2519632,	67,	2593111,	'Cenizate',	'Cenizate',	'Cenizate',	1,	9294,	'2019-03-16 03:59:51',	'Cenizate',	'Cenizate',	'Cenizate'),
(2519634,	67,	2593109,	'Cenes de la Vega',	'Cenes de la Vega',	'Cenes de la Vega',	1,	9292,	'2019-03-16 03:59:51',	'Cenes de la Vega',	'Cenes de la Vega',	'Cenes de la Vega'),
(2519651,	67,	2513413,	'Cehegin',	'Cehegin',	'Cehegin',	1,	9252,	'2019-03-16 03:59:51',	'Cehegin',	'Cehegin',	'Cehegin'),
(2519664,	67,	2593111,	'Cebolla',	'Cebolla',	'Cebolla',	1,	9191,	'2019-03-16 03:59:51',	'Cebolla',	'Cebolla',	'Cebolla'),
(2519672,	67,	2593109,	'Cazorla',	'Cazorla',	'Cazorla',	1,	9181,	'2019-03-16 03:59:51',	'Cazorla',	'Cazorla',	'Cazorla'),
(2519683,	67,	2593113,	'Caudete de las Fuentes',	'Caudete de las Fuentes',	'Caudete de las Fuentes',	1,	9100,	'2019-03-16 03:59:51',	'Caudete de las Fuentes',	'Caudete de las Fuentes',	'Caudete de las Fuentes'),
(2519685,	67,	2593111,	'Caudete',	'Caudete',	'Caudete',	1,	9099,	'2019-03-16 03:59:51',	'Caudete',	'Caudete',	'Caudete'),
(2519688,	67,	2593113,	'Catral',	'Catral',	'Catral',	1,	9085,	'2019-03-16 03:59:51',	'Catral',	'Catral',	'Catral'),
(2519690,	67,	2593113,	'Катаррох',	'Catarroja',	'Catarroja',	1,	9059,	'2019-03-16 03:59:51',	'Catarroja',	'Catarroja',	'Catarroja'),
(2519694,	67,	2593113,	'Catadau',	'Catadau',	'Catadau',	1,	9055,	'2019-03-16 03:59:51',	'Catadau',	'Catadau',	'Catadau'),
(2519696,	67,	2593112,	'Castuera',	'Castuera',	'Castuera',	1,	9053,	'2019-03-16 03:59:51',	'Castuera',	'Castuera',	'Castuera'),
(2519697,	67,	2593109,	'Castro del Rio',	'Castro del Rio',	'Castro del Rio',	1,	9041,	'2019-03-16 03:59:51',	'Castro del Rio',	'Castro del Rio',	'Castro del Rio'),
(2519711,	67,	2593109,	'Castillo de Locubin',	'Castillo de Locubin',	'Castillo de Locubin',	1,	8994,	'2019-03-16 03:59:51',	'Castillo de Locubin',	'Castillo de Locubin',	'Castillo de Locubin'),
(2519738,	67,	2593109,	'Castilleja de la Cuesta',	'Castilleja de la Cuesta',	'Castilleja de la Cuesta',	1,	8993,	'2019-03-16 03:59:51',	'Castilleja de la Cuesta',	'Castilleja de la Cuesta',	'Castilleja de la Cuesta'),
(2519739,	67,	2593109,	'Castilleja de Guzman',	'Castilleja de Guzman',	'Castilleja de Guzman',	1,	8992,	'2019-03-16 03:59:51',	'Castilleja de Guzman',	'Castilleja de Guzman',	'Castilleja de Guzman'),
(2519746,	67,	2593109,	'Castilblanco de los Arroyos',	'Castilblanco de los Arroyos',	'Castilblanco de los Arroyos',	1,	8990,	'2019-03-16 03:59:51',	'Castilblanco de los Arroyos',	'Castilblanco de los Arroyos',	'Castilblanco de los Arroyos'),
(2519752,	67,	2593113,	'Кастельон-де-ла-Плана',	'Castello de la Plana',	'Castello de la Plana',	1,	8914,	'2019-03-16 03:59:51',	'Castello de la Plana',	'Castello de la Plana',	'Castello de la Plana'),
(2519763,	67,	2593109,	'Castellar de la Frontera',	'Castellar de la Frontera',	'Castellar de la Frontera',	1,	8887,	'2019-03-16 03:59:51',	'Castellar de la Frontera',	'Castellar de la Frontera',	'Castellar de la Frontera'),
(2519783,	67,	2593113,	'Касталья',	'Castalla',	'Castalla',	1,	8811,	'2019-03-16 03:59:51',	'Castalla',	'Castalla',	'Castalla'),
(2519786,	67,	2593113,	'Casinos',	'Casinos',	'Casinos',	1,	8752,	'2019-03-16 03:59:51',	'Casinos',	'Casinos',	'Casinos'),
(2519837,	67,	2593113,	'Caserio El Campello',	'Caserio El Campello',	'Caserio El Campello',	1,	8735,	'2019-03-16 03:59:51',	'Caserio El Campello',	'Caserio El Campello',	'Caserio El Campello'),
(2519861,	67,	2593112,	'Casatejada',	'Casatejada',	'Casatejada',	1,	8710,	'2019-03-16 03:59:51',	'Casatejada',	'Casatejada',	'Casatejada'),
(2519915,	67,	2593113,	'Casas del Notari',	'Casas del Notari',	'Casas del Notari',	1,	8709,	'2019-03-16 03:59:51',	'Casas del Notari',	'Casas del Notari',	'Casas del Notari'),
(2519980,	67,	2593109,	'Casares',	'Casares',	'Casares',	1,	8704,	'2019-03-16 03:59:51',	'Casares',	'Casares',	'Casares'),
(2520045,	67,	2593109,	'Casabermeja',	'Casabermeja',	'Casabermeja',	1,	8661,	'2019-03-16 03:59:51',	'Casabermeja',	'Casabermeja',	'Casabermeja'),
(2520052,	67,	2593109,	'Cartaya',	'Cartaya',	'Cartaya',	1,	8615,	'2019-03-16 03:59:51',	'Cartaya',	'Cartaya',	'Cartaya'),
(2520055,	67,	2593109,	'Cartama',	'Cartama',	'Cartama',	1,	8614,	'2019-03-16 03:59:51',	'Cartama',	'Cartama',	'Cartama'),
(2520058,	67,	2513413,	'Картахена',	'Cartagena',	'Cartagena',	1,	8613,	'2019-03-16 03:59:51',	'Cartagena',	'Cartagena',	'Cartagena'),
(2520069,	67,	2593110,	'Carrizal',	'Carrizal',	'Carrizal',	1,	8578,	'2019-03-16 03:59:51',	'Carrizal',	'Carrizal',	'Carrizal'),
(2520071,	67,	2593109,	'Carrion de los Cespedes',	'Carrion de los Cespedes',	'Carrion de los Cespedes',	1,	8576,	'2019-03-16 03:59:51',	'Carrion de los Cespedes',	'Carrion de los Cespedes',	'Carrion de los Cespedes'),
(2520072,	67,	2593111,	'Carrion de Calatrava',	'Carrion de Calatrava',	'Carrion de Calatrava',	1,	8575,	'2019-03-16 03:59:51',	'Carrion de Calatrava',	'Carrion de Calatrava',	'Carrion de Calatrava'),
(2520077,	67,	2593113,	'Carricola',	'Carricola',	'Carricola',	1,	8569,	'2019-03-16 03:59:51',	'Carricola',	'Carricola',	'Carricola'),
(2520108,	67,	2593113,	'Carpesa',	'Carpesa',	'Carpesa',	1,	8548,	'2019-03-16 03:59:51',	'Carpesa',	'Carpesa',	'Carpesa'),
(2520117,	67,	2513413,	'Carmona',	'Carmona',	'Carmona',	1,	8504,	'2019-03-16 03:59:51',	'Carmona',	'Carmona',	'Carmona'),
(2520118,	67,	2593109,	'Кармона',	'Carmona',	'Carmona',	1,	8505,	'2019-03-16 03:59:51',	'Carmona',	'Carmona',	'Carmona'),
(2520121,	67,	2593113,	'Carlet',	'Carlet',	'Carlet',	1,	8456,	'2019-03-16 03:59:51',	'Carlet',	'Carlet',	'Carlet'),
(2520145,	67,	2593111,	'Carcelen',	'Carcelen',	'Carcelen',	1,	8411,	'2019-03-16 03:59:51',	'Carcelen',	'Carcelen',	'Carcelen'),
(2520163,	67,	2593109,	'Carboneras',	'Carboneras',	'Carboneras',	1,	8402,	'2019-03-16 03:59:51',	'Carboneras',	'Carboneras',	'Carboneras'),
(2520171,	67,	2513413,	'Caravaca',	'Caravaca',	'Caravaca',	1,	8385,	'2019-03-16 03:59:51',	'Caravaca',	'Caravaca',	'Caravaca'),
(2520200,	67,	2521383,	'Capdepera',	'Capdepera',	'Capdepera',	1,	8313,	'2019-03-16 03:59:51',	'Capdepera',	'Capdepera',	'Capdepera'),
(2520209,	67,	2593109,	'Cantoria',	'Cantoria',	'Cantoria',	1,	8284,	'2019-03-16 03:59:51',	'Cantoria',	'Cantoria',	'Cantoria'),
(2520215,	67,	2593109,	'Cantillana',	'Cantillana',	'Cantillana',	1,	8261,	'2019-03-16 03:59:51',	'Cantillana',	'Cantillana',	'Cantillana'),
(2520219,	67,	2513413,	'Canteras',	'Canteras',	'Canteras',	1,	8256,	'2019-03-16 03:59:51',	'Canteras',	'Canteras',	'Canteras'),
(2520248,	67,	2593109,	'Canjayar',	'Canjayar',	'Canjayar',	1,	8219,	'2019-03-16 03:59:51',	'Canjayar',	'Canjayar',	'Canjayar'),
(2520253,	67,	2593109,	'Canillas de Albaida',	'Canillas de Albaida',	'Canillas de Albaida',	1,	8214,	'2019-03-16 03:59:51',	'Canillas de Albaida',	'Canillas de Albaida',	'Canillas de Albaida'),
(2520271,	67,	2593113,	'Canet d\'En Berenguer',	'Canet d\'En Berenguer',	'Canet d\'En Berenguer',	1,	8198,	'2019-03-16 03:59:51',	'Canet d\'En Berenguer',	'Canet d\'En Berenguer',	'Canet d\'En Berenguer'),
(2520272,	67,	2593109,	'Canena',	'Canena',	'Canena',	1,	8196,	'2019-03-16 03:59:51',	'Canena',	'Canena',	'Canena'),
(2520283,	67,	2593110,	'Канделарии',	'Candelaria',	'Candelaria',	1,	8178,	'2019-03-16 03:59:51',	'Candelaria',	'Candelaria',	'Candelaria'),
(2520312,	67,	2593109,	'Canar',	'Canar',	'Canar',	1,	8163,	'2019-03-16 03:59:51',	'Canar',	'Canar',	'Canar'),
(2520314,	67,	2593112,	'Каньямеро',	'Canamero',	'Canamero',	1,	8160,	'2019-03-16 03:59:51',	'Canamero',	'Canamero',	'Canamero'),
(2520320,	67,	2593113,	'Canals',	'Canals',	'Canals',	1,	8159,	'2019-03-16 03:59:51',	'Canals',	'Canals',	'Canals'),
(2520402,	67,	2513413,	'Campos del Rio',	'Campos del Rio',	'Campos del Rio',	1,	8128,	'2019-03-16 03:59:51',	'Campos del Rio',	'Campos del Rio',	'Campos del Rio'),
(2520403,	67,	2521383,	'Campos',	'Campos',	'Campos',	1,	8127,	'2019-03-16 03:59:51',	'Campos',	'Campos',	'Campos'),
(2520405,	67,	2593113,	'Camporrobles',	'Camporrobles',	'Camporrobles',	1,	8126,	'2019-03-16 03:59:51',	'Camporrobles',	'Camporrobles',	'Camporrobles'),
(2520413,	67,	2593111,	'Campo de Criptana',	'Campo de Criptana',	'Campo de Criptana',	1,	8095,	'2019-03-16 03:59:51',	'Campo de Criptana',	'Campo de Criptana',	'Campo de Criptana'),
(2520425,	67,	2593109,	'Campina',	'Campina',	'Campina',	1,	8086,	'2019-03-16 03:59:51',	'Campina',	'Campina',	'Campina'),
(2520428,	67,	2593109,	'Campillos',	'Campillos',	'Campillos',	1,	8085,	'2019-03-16 03:59:51',	'Campillos',	'Campillos',	'Campillos'),
(2520436,	67,	2593111,	'Campillo de Altobuey',	'Campillo de Altobuey',	'Campillo de Altobuey',	1,	8084,	'2019-03-16 03:59:51',	'Campillo de Altobuey',	'Campillo de Altobuey',	'Campillo de Altobuey'),
(2520443,	67,	2593111,	'Campillo',	'Campillo',	'Campillo',	1,	8083,	'2019-03-16 03:59:51',	'Campillo',	'Campillo',	'Campillo'),
(2520447,	67,	2593113,	'el Campello',	'el Campello',	'el Campello',	1,	14902,	'2019-03-16 03:59:51',	'el Campello',	'el Campello',	'el Campello'),
(2520453,	67,	2521383,	'Campanet',	'Campanet',	'Campanet',	1,	8055,	'2019-03-16 03:59:51',	'Campanet',	'Campanet',	'Campanet'),
(2520477,	67,	2593109,	'Камас',	'Camas',	'Camas',	1,	7941,	'2019-03-16 03:59:51',	'Camas',	'Camas',	'Camas'),
(2520493,	67,	2521383,	'Кальвиа',	'Calvia',	'Calvia',	1,	7920,	'2019-03-16 03:59:51',	'Calvia',	'Calvia',	'Calvia'),
(2520496,	67,	2593113,	'Calp',	'Calp',	'Calp',	1,	7897,	'2019-03-16 03:59:51',	'Calp',	'Calp',	'Calp'),
(2520502,	67,	2593113,	'Callosa de Segura',	'Callosa de Segura',	'Callosa de Segura',	1,	7885,	'2019-03-16 03:59:51',	'Callosa de Segura',	'Callosa de Segura',	'Callosa de Segura'),
(2520558,	67,	2513413,	'Calasparra',	'Calasparra',	'Calasparra',	1,	7796,	'2019-03-16 03:59:51',	'Calasparra',	'Calasparra',	'Calasparra'),
(2520566,	67,	2593109,	'Calanas',	'Calanas',	'Calanas',	1,	7790,	'2019-03-16 03:59:51',	'Calanas',	'Calanas',	'Calanas'),
(2520568,	67,	2593112,	'Calamonte',	'Calamonte',	'Calamonte',	1,	7788,	'2019-03-16 03:59:51',	'Calamonte',	'Calamonte',	'Calamonte'),
(2520570,	67,	2521383,	'Cala Millor',	'Cala Millor',	'Cala Millor',	1,	7777,	'2019-03-16 03:59:51',	'Cala Millor',	'Cala Millor',	'Cala Millor'),
(2520573,	67,	2593109,	'Calahonda',	'Calahonda',	'Calahonda',	1,	7783,	'2019-03-16 03:59:51',	'Calahonda',	'Calahonda',	'Calahonda'),
(2520577,	67,	2593109,	'Cala del Moral',	'Cala del Moral',	'Cala del Moral',	1,	7776,	'2019-03-16 03:59:51',	'Cala del Moral',	'Cala del Moral',	'Cala del Moral'),
(2520590,	67,	2593109,	'Cala',	'Cala',	'Cala',	1,	7775,	'2019-03-16 03:59:51',	'Cala',	'Cala',	'Cala'),
(2520592,	67,	2593109,	'Cajar',	'Cajar',	'Cajar',	1,	7773,	'2019-03-16 03:59:51',	'Cajar',	'Cajar',	'Cajar'),
(2520600,	67,	2593109,	'Кадис',	'Cadiz',	'Cadiz',	1,	7723,	'2019-03-16 03:59:51',	'Cadiz',	'Cadiz',	'Cadiz'),
(2520611,	67,	2593112,	'Касерес',	'Caceres',	'Caceres',	1,	7698,	'2019-03-16 03:59:51',	'Caceres',	'Caceres',	'Caceres'),
(2520645,	67,	2593109,	'Кабра',	'Cabra',	'Cabra',	1,	7687,	'2019-03-16 03:59:51',	'Cabra',	'Cabra',	'Cabra'),
(2520648,	67,	2513413,	'Cabo de Palos',	'Cabo de Palos',	'Cabo de Palos',	1,	7681,	'2019-03-16 03:59:51',	'Cabo de Palos',	'Cabo de Palos',	'Cabo de Palos'),
(2520651,	67,	2513413,	'Cabezo de Torres',	'Cabezo de Torres',	'Cabezo de Torres',	1,	7673,	'2019-03-16 03:59:51',	'Cabezo de Torres',	'Cabezo de Torres',	'Cabezo de Torres'),
(2520659,	67,	2593111,	'Cabezarrubias del Puerto',	'Cabezarrubias del Puerto',	'Cabezarrubias del Puerto',	1,	7672,	'2019-03-16 03:59:51',	'Cabezarrubias del Puerto',	'Cabezarrubias del Puerto',	'Cabezarrubias del Puerto'),
(2520672,	67,	2593112,	'Кабеса-дель-Буэй',	'Cabeza del Buey',	'Cabeza del Buey',	1,	7671,	'2019-03-16 03:59:51',	'Cabeza del Buey',	'Cabeza del Buey',	'Cabeza del Buey'),
(2520696,	67,	2593110,	'Buzanada',	'Buzanada',	'Buzanada',	1,	7630,	'2019-03-16 03:59:51',	'Buzanada',	'Buzanada',	'Buzanada'),
(2520698,	67,	2593113,	'Busot',	'Busot',	'Busot',	1,	7554,	'2019-03-16 03:59:51',	'Busot',	'Busot',	'Busot'),
(2520700,	67,	2593111,	'Burujon',	'Burujon',	'Burujon',	1,	7524,	'2019-03-16 03:59:51',	'Burujon',	'Burujon',	'Burujon'),
(2520709,	67,	2593113,	'Бурриана',	'Burriana',	'Burriana',	1,	7494,	'2019-03-16 03:59:51',	'Burriana',	'Burriana',	'Burriana'),
(2520712,	67,	2593113,	'Бурхасот',	'Burjassot',	'Burjassot',	1,	7419,	'2019-03-16 03:59:51',	'Burjassot',	'Burjassot',	'Burjassot'),
(2520713,	67,	2593111,	'Burguillos de Toledo',	'Burguillos de Toledo',	'Burguillos de Toledo',	1,	7410,	'2019-03-16 03:59:51',	'Burguillos de Toledo',	'Burguillos de Toledo',	'Burguillos de Toledo'),
(2520714,	67,	2593112,	'Burguillos del Cerro',	'Burguillos del Cerro',	'Burguillos del Cerro',	1,	7411,	'2019-03-16 03:59:51',	'Burguillos del Cerro',	'Burguillos del Cerro',	'Burguillos del Cerro'),
(2520715,	67,	2593109,	'Burguillos',	'Burguillos',	'Burguillos',	1,	7409,	'2019-03-16 03:59:51',	'Burguillos',	'Burguillos',	'Burguillos'),
(2520726,	67,	2593113,	'Буньоль',	'Bunol',	'Bunol',	1,	7330,	'2019-03-16 03:59:51',	'Bunol',	'Bunol',	'Bunol'),
(2520727,	67,	2513413,	'Bullas',	'Bullas',	'Bullas',	1,	7288,	'2019-03-16 03:59:51',	'Bullas',	'Bullas',	'Bullas'),
(2520735,	67,	2593109,	'Bujalance',	'Bujalance',	'Bujalance',	1,	7277,	'2019-03-16 03:59:51',	'Bujalance',	'Bujalance',	'Bujalance'),
(2520748,	67,	2593113,	'Bugarra',	'Bugarra',	'Bugarra',	1,	7252,	'2019-03-16 03:59:51',	'Bugarra',	'Bugarra',	'Bugarra'),
(2520798,	67,	2593109,	'Brenes',	'Brenes',	'Brenes',	1,	6552,	'2019-03-16 03:59:51',	'Brenes',	'Brenes',	'Brenes'),
(2520799,	67,	2593110,	'Brena Baja',	'Brena Baja',	'Brena Baja',	1,	6549,	'2019-03-16 03:59:51',	'Brena Baja',	'Brena Baja',	'Brena Baja'),
(2520800,	67,	2593110,	'Brena Alta',	'Brena Alta',	'Brena Alta',	1,	6548,	'2019-03-16 03:59:51',	'Brena Alta',	'Brena Alta',	'Brena Alta'),
(2520832,	67,	2593109,	'Bornos',	'Bornos',	'Bornos',	1,	5954,	'2019-03-16 03:59:51',	'Bornos',	'Bornos',	'Bornos'),
(2520833,	67,	2593109,	'Bormujos',	'Bormujos',	'Bormujos',	1,	5945,	'2019-03-16 03:59:51',	'Bormujos',	'Bormujos',	'Bormujos'),
(2520835,	67,	2593109,	'Borge',	'Borge',	'Borge',	1,	5898,	'2019-03-16 03:59:51',	'Borge',	'Borge',	'Borge'),
(2520844,	67,	2593113,	'Bonrepos i Mirambell',	'Bonrepos i Mirambell',	'Bonrepos i Mirambell',	1,	5835,	'2019-03-16 03:59:51',	'Bonrepos i Mirambell',	'Bonrepos i Mirambell',	'Bonrepos i Mirambell'),
(2520850,	67,	2593109,	'Bonares',	'Bonares',	'Bonares',	1,	5754,	'2019-03-16 03:59:51',	'Bonares',	'Bonares',	'Bonares'),
(2520869,	67,	2593109,	'Bollullos par del Condado',	'Bollullos par del Condado',	'Bollullos par del Condado',	1,	5722,	'2019-03-16 03:59:51',	'Bollullos par del Condado',	'Bollullos par del Condado',	'Bollullos par del Condado'),
(2520870,	67,	2593109,	'Bollullos de la Mitacion',	'Bollullos de la Mitacion',	'Bollullos de la Mitacion',	1,	5721,	'2019-03-16 03:59:51',	'Bollullos de la Mitacion',	'Bollullos de la Mitacion',	'Bollullos de la Mitacion'),
(2520874,	67,	2593113,	'Bolbaite',	'Bolbaite',	'Bolbaite',	1,	5697,	'2019-03-16 03:59:51',	'Bolbaite',	'Bolbaite',	'Bolbaite'),
(2520875,	67,	2593111,	'Bolanos de Calatrava',	'Bolanos de Calatrava',	'Bolanos de Calatrava',	1,	5696,	'2019-03-16 03:59:51',	'Bolanos de Calatrava',	'Bolanos de Calatrava',	'Bolanos de Calatrava'),
(2520898,	67,	2593113,	'Bocairent',	'Bocairent',	'Bocairent',	1,	5540,	'2019-03-16 03:59:51',	'Bocairent',	'Bocairent',	'Bocairent'),
(2520905,	67,	2593109,	'Bobadilla',	'Bobadilla',	'Bobadilla',	1,	5528,	'2019-03-16 03:59:51',	'Bobadilla',	'Bobadilla',	'Bobadilla'),
(2520940,	67,	2513413,	'Blanca',	'Blanca',	'Blanca',	1,	5305,	'2019-03-16 03:59:51',	'Blanca',	'Blanca',	'Blanca'),
(2520943,	67,	2521383,	'Binissalem',	'Binissalem',	'Binissalem',	1,	5065,	'2019-03-16 03:59:51',	'Binissalem',	'Binissalem',	'Binissalem'),
(2520955,	67,	2593113,	'Bigastro',	'Bigastro',	'Bigastro',	1,	4980,	'2019-03-16 03:59:51',	'Bigastro',	'Bigastro',	'Bigastro'),
(2520957,	67,	2593112,	'Bienvenida',	'Bienvenida',	'Bienvenida',	1,	4928,	'2019-03-16 03:59:51',	'Bienvenida',	'Bienvenida',	'Bienvenida'),
(2520964,	67,	2593113,	'Biar',	'Biar',	'Biar',	1,	4876,	'2019-03-16 03:59:51',	'Biar',	'Biar',	'Biar'),
(2520965,	67,	2593109,	'Beznar',	'Beznar',	'Beznar',	1,	4846,	'2019-03-16 03:59:51',	'Beznar',	'Beznar',	'Beznar'),
(2520968,	67,	2593113,	'Betera',	'Betera',	'Betera',	1,	4722,	'2019-03-16 03:59:51',	'Betera',	'Betera',	'Betera'),
(2521022,	67,	2593113,	'Berdica',	'Berdica',	'Berdica',	1,	4476,	'2019-03-16 03:59:51',	'Berdica',	'Berdica',	'Berdica'),
(2521044,	67,	2593113,	'Benitachell',	'Benitachell',	'Benitachell',	1,	4390,	'2019-03-16 03:59:51',	'Benitachell',	'Benitachell',	'Benitachell'),
(2521045,	67,	2593113,	'Benisuera',	'Benisuera',	'Benisuera',	1,	4389,	'2019-03-16 03:59:51',	'Benisuera',	'Benisuera',	'Benisuera'),
(2521049,	67,	2593113,	'Benisano',	'Benisano',	'Benisano',	1,	4387,	'2019-03-16 03:59:51',	'Benisano',	'Benisano',	'Benisano'),
(2521050,	67,	2593113,	'Benissa',	'Benissa',	'Benissa',	1,	4388,	'2019-03-16 03:59:51',	'Benissa',	'Benissa',	'Benissa'),
(2521052,	67,	2593113,	'Benirredra',	'Benirredra',	'Benirredra',	1,	4386,	'2019-03-16 03:59:51',	'Benirredra',	'Benirredra',	'Benirredra'),
(2521055,	67,	2593113,	'Beniparrell',	'Beniparrell',	'Beniparrell',	1,	4385,	'2019-03-16 03:59:51',	'Beniparrell',	'Beniparrell',	'Beniparrell'),
(2521064,	67,	2593113,	'Benimarfull',	'Benimarfull',	'Benimarfull',	1,	4384,	'2019-03-16 03:59:51',	'Benimarfull',	'Benimarfull',	'Benimarfull'),
(2521065,	67,	2593113,	'Benimantell',	'Benimantell',	'Benimantell',	1,	4383,	'2019-03-16 03:59:51',	'Benimantell',	'Benimantell',	'Benimantell'),
(2521066,	67,	2593113,	'Benimamet',	'Benimamet',	'Benimamet',	1,	4382,	'2019-03-16 03:59:51',	'Benimamet',	'Benimamet',	'Benimamet'),
(2521072,	67,	2593113,	'Benijofar',	'Benijofar',	'Benijofar',	1,	4381,	'2019-03-16 03:59:51',	'Benijofar',	'Benijofar',	'Benijofar'),
(2521075,	67,	2593113,	'Beniganim',	'Beniganim',	'Beniganim',	1,	4380,	'2019-03-16 03:59:51',	'Beniganim',	'Beniganim',	'Beniganim'),
(2521085,	67,	2593113,	'Benifairo de les Valls',	'Benifairo de les Valls',	'Benifairo de les Valls',	1,	4378,	'2019-03-16 03:59:51',	'Benifairo de les Valls',	'Benifairo de les Valls',	'Benifairo de les Valls'),
(2521086,	67,	2513413,	'Beniel',	'Beniel',	'Beniel',	1,	4377,	'2019-03-16 03:59:51',	'Beniel',	'Beniel',	'Beniel'),
(2521088,	67,	2593113,	'Бенидорм',	'Benidorm',	'Benidorm',	1,	4376,	'2019-03-16 03:59:51',	'Benidorm',	'Benidorm',	'Benidorm'),
(2521100,	67,	2593113,	'Beniarbeig',	'Beniarbeig',	'Beniarbeig',	1,	4372,	'2019-03-16 03:59:51',	'Beniarbeig',	'Beniarbeig',	'Beniarbeig'),
(2521106,	67,	2593113,	'Benejuzar',	'Benejuzar',	'Benejuzar',	1,	4361,	'2019-03-16 03:59:51',	'Benejuzar',	'Benejuzar',	'Benejuzar'),
(2521119,	67,	2593109,	'Benatae',	'Benatae',	'Benatae',	1,	4343,	'2019-03-16 03:59:51',	'Benatae',	'Benatae',	'Benatae'),
(2521130,	67,	2593109,	'Benameji',	'Benameji',	'Benameji',	1,	4341,	'2019-03-16 03:59:51',	'Benameji',	'Benameji',	'Benameji'),
(2521131,	67,	2593109,	'Benamaurel',	'Benamaurel',	'Benamaurel',	1,	4340,	'2019-03-16 03:59:51',	'Benamaurel',	'Benamaurel',	'Benamaurel'),
(2521132,	67,	2593109,	'Benamargosa',	'Benamargosa',	'Benamargosa',	1,	4339,	'2019-03-16 03:59:51',	'Benamargosa',	'Benamargosa',	'Benamargosa'),
(2521139,	67,	2593109,	'Бенальмадена',	'Benalmadena',	'Benalmadena',	1,	4338,	'2019-03-16 03:59:51',	'Benalmadena',	'Benalmadena',	'Benalmadena'),
(2521142,	67,	2593109,	'Benalauria',	'Benalauria',	'Benalauria',	1,	4337,	'2019-03-16 03:59:51',	'Benalauria',	'Benalauria',	'Benalauria'),
(2521146,	67,	2593109,	'Benahavis',	'Benahavis',	'Benahavis',	1,	4335,	'2019-03-16 03:59:51',	'Benahavis',	'Benahavis',	'Benahavis'),
(2521148,	67,	2593113,	'Benaguasil',	'Benaguasil',	'Benaguasil',	1,	4334,	'2019-03-16 03:59:51',	'Benaguasil',	'Benaguasil',	'Benaguasil'),
(2521151,	67,	2593109,	'Benagalbon',	'Benagalbon',	'Benagalbon',	1,	4333,	'2019-03-16 03:59:51',	'Benagalbon',	'Benagalbon',	'Benagalbon'),
(2521154,	67,	2593109,	'Benacazon',	'Benacazon',	'Benacazon',	1,	4332,	'2019-03-16 03:59:51',	'Benacazon',	'Benacazon',	'Benacazon'),
(2521168,	67,	2593109,	'Belmez',	'Belmez',	'Belmez',	1,	4262,	'2019-03-16 03:59:51',	'Belmez',	'Belmez',	'Belmez'),
(2521174,	67,	2593109,	'Belicena',	'Belicena',	'Belicena',	1,	4133,	'2019-03-16 03:59:51',	'Belicena',	'Belicena',	'Belicena'),
(2521175,	67,	2593113,	'Belgida',	'Belgida',	'Belgida',	1,	4122,	'2019-03-16 03:59:51',	'Belgida',	'Belgida',	'Belgida'),
(2521209,	67,	2593109,	'Beas de Granada',	'Beas de Granada',	'Beas de Granada',	1,	3826,	'2019-03-16 03:59:51',	'Beas de Granada',	'Beas de Granada',	'Beas de Granada'),
(2521212,	67,	2593109,	'Beas',	'Beas',	'Beas',	1,	3825,	'2019-03-16 03:59:51',	'Beas',	'Beas',	'Beas'),
(2521215,	67,	2593109,	'База',	'Baza',	'Baza',	1,	3775,	'2019-03-16 03:59:51',	'Baza',	'Baza',	'Baza'),
(2521262,	67,	2593113,	'Barrio Benalua',	'Barrio Benalua',	'Barrio Benalua',	1,	3520,	'2019-03-16 03:59:51',	'Barrio Benalua',	'Barrio Benalua',	'Barrio Benalua'),
(2521316,	67,	2593111,	'Bargas',	'Bargas',	'Bargas',	1,	3416,	'2019-03-16 03:59:51',	'Bargas',	'Bargas',	'Bargas'),
(2521321,	67,	2593111,	'Barcience',	'Barcience',	'Barcience',	1,	3392,	'2019-03-16 03:59:51',	'Barcience',	'Barcience',	'Barcience'),
(2521329,	67,	2593112,	'Barcarrota',	'Barcarrota',	'Barcarrota',	1,	3386,	'2019-03-16 03:59:51',	'Barcarrota',	'Barcarrota',	'Barcarrota'),
(2521335,	67,	2593109,	'Barbate de Franco',	'Barbate de Franco',	'Barbate de Franco',	1,	3364,	'2019-03-16 03:59:51',	'Barbate de Franco',	'Barbate de Franco',	'Barbate de Franco'),
(2521365,	67,	2513413,	'Balsicas',	'Balsicas',	'Balsicas',	1,	3250,	'2019-03-16 03:59:51',	'Balsicas',	'Balsicas',	'Balsicas'),
(2521366,	67,	2593113,	'Balsares',	'Balsares',	'Balsares',	1,	3248,	'2019-03-16 03:59:51',	'Balsares',	'Balsares',	'Balsares'),
(2521410,	67,	2593109,	'Bailen',	'Bailen',	'Bailen',	1,	3105,	'2019-03-16 03:59:51',	'Bailen',	'Bailen',	'Bailen'),
(2521413,	67,	2593109,	'Baeza',	'Baeza',	'Baeza',	1,	3041,	'2019-03-16 03:59:51',	'Baeza',	'Baeza',	'Baeza'),
(2521415,	67,	2593109,	'Баэна',	'Baena',	'Baena',	1,	3037,	'2019-03-16 03:59:51',	'Baena',	'Baena',	'Baena'),
(2521417,	67,	2593109,	'Badolatosa',	'Badolatosa',	'Badolatosa',	1,	3033,	'2019-03-16 03:59:51',	'Badolatosa',	'Badolatosa',	'Badolatosa'),
(2521420,	67,	2593112,	'Бадахос',	'Badajoz',	'Badajoz',	1,	3008,	'2019-03-16 03:59:51',	'Badajoz',	'Badajoz',	'Badajoz'),
(2521436,	67,	2593112,	'Azuaga',	'Azuaga',	'Azuaga',	1,	2834,	'2019-03-16 03:59:51',	'Azuaga',	'Azuaga',	'Azuaga'),
(2521439,	67,	2593109,	'Aznalcollar',	'Aznalcollar',	'Aznalcollar',	1,	2830,	'2019-03-16 03:59:51',	'Aznalcollar',	'Aznalcollar',	'Aznalcollar'),
(2521440,	67,	2593109,	'Aznalcazar',	'Aznalcazar',	'Aznalcazar',	1,	2829,	'2019-03-16 03:59:51',	'Aznalcazar',	'Aznalcazar',	'Aznalcazar'),
(2521451,	67,	2593113,	'Ayora',	'Ayora',	'Ayora',	1,	2805,	'2019-03-16 03:59:51',	'Ayora',	'Ayora',	'Ayora'),
(2521456,	67,	2593109,	'Айямонте',	'Ayamonte',	'Ayamonte',	1,	2786,	'2019-03-16 03:59:51',	'Ayamonte',	'Ayamonte',	'Ayamonte'),
(2521485,	67,	2593109,	'Atarfe',	'Atarfe',	'Atarfe',	1,	2304,	'2019-03-16 03:59:51',	'Atarfe',	'Atarfe',	'Atarfe'),
(2521500,	67,	2593112,	'Atalaya',	'Atalaya',	'Atalaya',	1,	2302,	'2019-03-16 03:59:51',	'Atalaya',	'Atalaya',	'Atalaya'),
(2521510,	67,	2593113,	'Аспе',	'Aspe',	'Aspe',	1,	2247,	'2019-03-16 03:59:51',	'Aspe',	'Aspe',	'Aspe'),
(2521519,	67,	2593110,	'Арукас',	'Arucas',	'Arucas',	1,	2090,	'2019-03-16 03:59:51',	'Arucas',	'Arucas',	'Arucas'),
(2521528,	67,	2593113,	'Artana',	'Artana',	'Artana',	1,	2054,	'2019-03-16 03:59:51',	'Artana',	'Artana',	'Artana'),
(2521534,	67,	2521383,	'Арта',	'Arta',	'Arta',	1,	2051,	'2019-03-16 03:59:51',	'Arta',	'Arta',	'Arta'),
(2521550,	67,	2593109,	'Arroyo del Ojanco',	'Arroyo del Ojanco',	'Arroyo del Ojanco',	1,	2030,	'2019-03-16 03:59:51',	'Arroyo del Ojanco',	'Arroyo del Ojanco',	'Arroyo del Ojanco'),
(2521554,	67,	2593109,	'Arroyo de la Miel',	'Arroyo de la Miel',	'Arroyo de la Miel',	1,	2029,	'2019-03-16 03:59:51',	'Arroyo de la Miel',	'Arroyo de la Miel',	'Arroyo de la Miel'),
(2521555,	67,	2593112,	'Arroyo de la Luz',	'Arroyo de la Luz',	'Arroyo de la Luz',	1,	2028,	'2019-03-16 03:59:51',	'Arroyo de la Luz',	'Arroyo de la Luz',	'Arroyo de la Luz'),
(2521566,	67,	2593109,	'Arriate',	'Arriate',	'Arriate',	1,	2018,	'2019-03-16 03:59:51',	'Arriate',	'Arriate',	'Arriate'),
(2521570,	67,	2593110,	'Аресифе',	'Arrecife',	'Arrecife',	1,	2016,	'2019-03-16 03:59:51',	'Arrecife',	'Arrecife',	'Arrecife'),
(2521577,	67,	2593109,	'Arquillos',	'Arquillos',	'Arquillos',	1,	2009,	'2019-03-16 03:59:51',	'Arquillos',	'Arquillos',	'Arquillos'),
(2521582,	67,	2593110,	'Арон',	'Arona',	'Arona',	1,	1995,	'2019-03-16 03:59:51',	'Arona',	'Arona',	'Arona'),
(2521585,	67,	2593109,	'Aroche',	'Aroche',	'Aroche',	1,	1991,	'2019-03-16 03:59:51',	'Aroche',	'Aroche',	'Aroche'),
(2521590,	67,	2593109,	'Armilla',	'Armilla',	'Armilla',	1,	1946,	'2019-03-16 03:59:51',	'Armilla',	'Armilla',	'Armilla'),
(2521602,	67,	2593110,	'Cruce de Arinaga',	'Cruce de Arinaga',	'Cruce de Arinaga',	1,	12418,	'2019-03-16 03:59:51',	'Cruce de Arinaga',	'Cruce de Arinaga',	'Cruce de Arinaga'),
(2521615,	67,	2593111,	'Arges',	'Arges',	'Arges',	1,	1868,	'2019-03-16 03:59:51',	'Arges',	'Arges',	'Arges'),
(2521619,	67,	2593111,	'Argamasilla de Calatrava',	'Argamasilla de Calatrava',	'Argamasilla de Calatrava',	1,	1842,	'2019-03-16 03:59:51',	'Argamasilla de Calatrava',	'Argamasilla de Calatrava',	'Argamasilla de Calatrava'),
(2521642,	67,	2593109,	'Arenas',	'Arenas',	'Arenas',	1,	1825,	'2019-03-16 03:59:51',	'Arenas',	'Arenas',	'Arenas'),
(2521665,	67,	2593109,	'Аркос-де-ла-Фронтера',	'Arcos de la Frontera',	'Arcos de la Frontera',	1,	1796,	'2019-03-16 03:59:51',	'Arcos de la Frontera',	'Arcos de la Frontera',	'Arcos de la Frontera'),
(2521673,	67,	2593109,	'Арчидона',	'Archidona',	'Archidona',	1,	1781,	'2019-03-16 03:59:51',	'Archidona',	'Archidona',	'Archidona'),
(2521674,	67,	2593109,	'Archez',	'Archez',	'Archez',	1,	1779,	'2019-03-16 03:59:51',	'Archez',	'Archez',	'Archez'),
(2521676,	67,	2513413,	'Archena',	'Archena',	'Archena',	1,	1773,	'2019-03-16 03:59:51',	'Archena',	'Archena',	'Archena'),
(2521683,	67,	2593109,	'Arboleas',	'Arboleas',	'Arboleas',	1,	1728,	'2019-03-16 03:59:51',	'Arboleas',	'Arboleas',	'Arboleas'),
(2521692,	67,	2593110,	'Arafo',	'Arafo',	'Arafo',	1,	1698,	'2019-03-16 03:59:51',	'Arafo',	'Arafo',	'Arafo'),
(2521694,	67,	2593109,	'Арасена',	'Aracena',	'Aracena',	1,	1695,	'2019-03-16 03:59:51',	'Aracena',	'Aracena',	'Aracena'),
(2521706,	67,	2593110,	'Antigua',	'Antigua',	'Antigua',	1,	1590,	'2019-03-16 03:59:51',	'Antigua',	'Antigua',	'Antigua'),
(2521710,	67,	2593109,	'Антекера',	'Antequera',	'Antequera',	1,	1576,	'2019-03-16 03:59:51',	'Antequera',	'Antequera',	'Antequera'),
(2521718,	67,	2593111,	'Anover de Tajo',	'Anover de Tajo',	'Anover de Tajo',	1,	1549,	'2019-03-16 03:59:51',	'Anover de Tajo',	'Anover de Tajo',	'Anover de Tajo'),
(2521722,	67,	2593113,	'Anna',	'Anna',	'Anna',	1,	1500,	'2019-03-16 03:59:51',	'Anna',	'Anna',	'Anna'),
(2521738,	67,	2593109,	'Андухар',	'Andujar',	'Andujar',	1,	1423,	'2019-03-16 03:59:51',	'Andujar',	'Andujar',	'Andujar'),
(2521790,	67,	2513413,	'Alumbres',	'Alumbres',	'Alumbres',	1,	1140,	'2019-03-16 03:59:51',	'Alumbres',	'Alumbres',	'Alumbres'),
(2521793,	67,	2593113,	'Altura',	'Altura',	'Altura',	1,	1130,	'2019-03-16 03:59:51',	'Altura',	'Altura',	'Altura'),
(2521804,	67,	2593113,	'Altea',	'Altea',	'Altea',	1,	1031,	'2019-03-16 03:59:51',	'Altea',	'Altea',	'Altea'),
(2521823,	67,	2513413,	'Alquerias',	'Alquerias',	'Alquerias',	1,	974,	'2019-03-16 03:59:51',	'Alquerias',	'Alquerias',	'Alquerias'),
(2521838,	67,	2593109,	'Alozaina',	'Alozaina',	'Alozaina',	1,	950,	'2019-03-16 03:59:51',	'Alozaina',	'Alozaina',	'Alozaina'),
(2521839,	67,	2593109,	'Alosno',	'Alosno',	'Alosno',	1,	948,	'2019-03-16 03:59:51',	'Alosno',	'Alosno',	'Alosno'),
(2521840,	67,	2593109,	'Alora',	'Alora',	'Alora',	1,	947,	'2019-03-16 03:59:51',	'Alora',	'Alora',	'Alora'),
(2521845,	67,	2593113,	'Альмусафес',	'Almussafes',	'Almussafes',	1,	943,	'2019-03-16 03:59:51',	'Almussafes',	'Almussafes',	'Almussafes'),
(2521846,	67,	2593111,	'Almuradiel',	'Almuradiel',	'Almuradiel',	1,	942,	'2019-03-16 03:59:51',	'Almuradiel',	'Almuradiel',	'Almuradiel'),
(2521847,	67,	2593109,	'Almunecar',	'Almunecar',	'Almunecar',	1,	941,	'2019-03-16 03:59:51',	'Almunecar',	'Almunecar',	'Almunecar'),
(2521855,	67,	2593113,	'Almoradi',	'Almoradi',	'Almoradi',	1,	939,	'2019-03-16 03:59:51',	'Almoradi',	'Almoradi',	'Almoradi'),
(2521857,	67,	2593109,	'Almonte',	'Almonte',	'Almonte',	1,	937,	'2019-03-16 03:59:51',	'Almonte',	'Almonte',	'Almonte'),
(2521864,	67,	2593112,	'Almoharin',	'Almoharin',	'Almoharin',	1,	933,	'2019-03-16 03:59:51',	'Almoharin',	'Almoharin',	'Almoharin'),
(2521867,	67,	2593109,	'Almodovar del Rio',	'Almodovar del Rio',	'Almodovar del Rio',	1,	932,	'2019-03-16 03:59:51',	'Almodovar del Rio',	'Almodovar del Rio',	'Almodovar del Rio'),
(2521869,	67,	2593111,	'Almodovar del Campo',	'Almodovar del Campo',	'Almodovar del Campo',	1,	931,	'2019-03-16 03:59:51',	'Almodovar del Campo',	'Almodovar del Campo',	'Almodovar del Campo'),
(2521886,	67,	2593109,	'Альмерия',	'Almeria',	'Almeria',	1,	928,	'2019-03-16 03:59:51',	'Almeria',	'Almeria',	'Almeria'),
(2521887,	67,	2593109,	'Almensilla',	'Almensilla',	'Almensilla',	1,	927,	'2019-03-16 03:59:51',	'Almensilla',	'Almensilla',	'Almensilla'),
(2521893,	67,	2593112,	'Альмендралехо',	'Almendralejo',	'Almendralejo',	1,	925,	'2019-03-16 03:59:51',	'Almendralejo',	'Almendralejo',	'Almendralejo'),
(2521899,	67,	2593113,	'Almenara',	'Almenara',	'Almenara',	1,	924,	'2019-03-16 03:59:51',	'Almenara',	'Almenara',	'Almenara'),
(2521909,	67,	2593113,	'Almassora',	'Almassora',	'Almassora',	1,	914,	'2019-03-16 03:59:51',	'Almassora',	'Almassora',	'Almassora'),
(2521913,	67,	2593109,	'Almargen',	'Almargen',	'Almargen',	1,	912,	'2019-03-16 03:59:51',	'Almargen',	'Almargen',	'Almargen'),
(2521917,	67,	2593112,	'Almaraz',	'Almaraz',	'Almaraz',	1,	911,	'2019-03-16 03:59:51',	'Almaraz',	'Almaraz',	'Almaraz'),
(2521923,	67,	2593111,	'Альманса',	'Almansa',	'Almansa',	1,	910,	'2019-03-16 03:59:51',	'Almansa',	'Almansa',	'Almansa'),
(2521928,	67,	2593111,	'Almagro',	'Almagro',	'Almagro',	1,	909,	'2019-03-16 03:59:51',	'Almagro',	'Almagro',	'Almagro'),
(2521938,	67,	2593111,	'Альмаден',	'Almaden',	'Almaden',	1,	908,	'2019-03-16 03:59:51',	'Almaden',	'Almaden',	'Almaden'),
(2521946,	67,	2593113,	'Almassera',	'Almassera',	'Almassera',	1,	913,	'2019-03-16 03:59:51',	'Almassera',	'Almassera',	'Almassera'),
(2521964,	67,	2593109,	'Aljaraque',	'Aljaraque',	'Aljaraque',	1,	804,	'2019-03-16 03:59:51',	'Aljaraque',	'Aljaraque',	'Aljaraque'),
(2521978,	67,	2593113,	'Аликанте',	'Alicante',	'Alicante',	1,	787,	'2019-03-16 03:59:51',	'Alicante',	'Alicante',	'Alicante'),
(2521984,	67,	2593109,	'Alhendin',	'Alhendin',	'Alhendin',	1,	785,	'2019-03-16 03:59:51',	'Alhendin',	'Alhendin',	'Alhendin'),
(2521985,	67,	2593109,	'Alhaurin el Grande',	'Alhaurin el Grande',	'Alhaurin el Grande',	1,	783,	'2019-03-16 03:59:51',	'Alhaurin el Grande',	'Alhaurin el Grande',	'Alhaurin el Grande'),
(2521986,	67,	2593109,	'Alhaurin de la Torre',	'Alhaurin de la Torre',	'Alhaurin de la Torre',	1,	782,	'2019-03-16 03:59:51',	'Alhaurin de la Torre',	'Alhaurin de la Torre',	'Alhaurin de la Torre'),
(2521991,	67,	2593111,	'Alhambra',	'Alhambra',	'Alhambra',	1,	780,	'2019-03-16 03:59:51',	'Alhambra',	'Alhambra',	'Alhambra'),
(2521992,	67,	2513413,	'Alhama de Murcia',	'Alhama de Murcia',	'Alhama de Murcia',	1,	778,	'2019-03-16 03:59:51',	'Alhama de Murcia',	'Alhama de Murcia',	'Alhama de Murcia'),
(2521994,	67,	2593109,	'Alhama de Almeria',	'Alhama de Almeria',	'Alhama de Almeria',	1,	776,	'2019-03-16 03:59:51',	'Alhama de Almeria',	'Alhama de Almeria',	'Alhama de Almeria'),
(2521999,	67,	2593113,	'Alguena',	'Alguena',	'Alguena',	1,	775,	'2019-03-16 03:59:51',	'Alguena',	'Alguena',	'Alguena'),
(2522000,	67,	2513413,	'Alguazas',	'Alguazas',	'Alguazas',	1,	774,	'2019-03-16 03:59:51',	'Alguazas',	'Alguazas',	'Alguazas'),
(2522001,	67,	2593113,	'Algorfa',	'Algorfa',	'Algorfa',	1,	770,	'2019-03-16 03:59:51',	'Algorfa',	'Algorfa',	'Algorfa'),
(2522007,	67,	2593113,	'Alginet',	'Alginet',	'Alginet',	1,	763,	'2019-03-16 03:59:51',	'Alginet',	'Alginet',	'Alginet'),
(2522012,	67,	2593113,	'Algemesi',	'Algemesi',	'Algemesi',	1,	758,	'2019-03-16 03:59:51',	'Algemesi',	'Algemesi',	'Algemesi'),
(2522013,	67,	2593109,	'Альхесирас',	'Algeciras',	'Algeciras',	1,	757,	'2019-03-16 03:59:51',	'Algeciras',	'Algeciras',	'Algeciras'),
(2522030,	67,	2513413,	'Algar',	'Algar',	'Algar',	1,	755,	'2019-03-16 03:59:51',	'Algar',	'Algar',	'Algar'),
(2522031,	67,	2593109,	'Algar',	'Algar',	'Algar',	1,	756,	'2019-03-16 03:59:51',	'Algar',	'Algar',	'Algar'),
(2522036,	67,	2521383,	'Algaida',	'Algaida',	'Algaida',	1,	754,	'2019-03-16 03:59:51',	'Algaida',	'Algaida',	'Algaida'),
(2522044,	67,	2593113,	'Alfondeguilla',	'Alfondeguilla',	'Alfondeguilla',	1,	743,	'2019-03-16 03:59:51',	'Alfondeguilla',	'Alfondeguilla',	'Alfondeguilla'),
(2522052,	67,	2593113,	'Alfara del Patriarca',	'Alfara del Patriarca',	'Alfara del Patriarca',	1,	734,	'2019-03-16 03:59:51',	'Alfara del Patriarca',	'Alfara del Patriarca',	'Alfara del Patriarca'),
(2522057,	67,	2593113,	'Alfafar',	'Alfafar',	'Alfafar',	1,	731,	'2019-03-16 03:59:51',	'Alfafar',	'Alfafar',	'Alfafar'),
(2522058,	67,	2593109,	'Alfacar',	'Alfacar',	'Alfacar',	1,	730,	'2019-03-16 03:59:51',	'Alfacar',	'Alfacar',	'Alfacar'),
(2522065,	67,	2593109,	'Aldeaquemada',	'Aldeaquemada',	'Aldeaquemada',	1,	665,	'2019-03-16 03:59:51',	'Aldeaquemada',	'Aldeaquemada',	'Aldeaquemada'),
(2522077,	67,	2593113,	'Альдайя',	'Aldaia',	'Aldaia',	1,	658,	'2019-03-16 03:59:51',	'Aldaia',	'Aldaia',	'Aldaia'),
(2522084,	67,	2593113,	'L\'Alcudia de Crespins',	'L\'Alcudia de Crespins',	'L\'Alcudia de Crespins',	1,	25081,	'2019-03-16 03:59:51',	'L\'Alcudia de Crespins',	'L\'Alcudia de Crespins',	'L\'Alcudia de Crespins'),
(2522091,	67,	2521383,	'Alcudia',	'Alcudia',	'Alcudia',	1,	655,	'2019-03-16 03:59:51',	'Alcudia',	'Alcudia',	'Alcudia'),
(2522092,	67,	2593113,	'Alcudia',	'Alcudia',	'Alcudia',	1,	654,	'2019-03-16 03:59:51',	'Alcudia',	'Alcudia',	'Alcudia'),
(2522094,	67,	2593113,	'Алькублас',	'Alcublas',	'Alcublas',	1,	653,	'2019-03-16 03:59:51',	'Alcublas',	'Alcublas',	'Alcublas'),
(2522098,	67,	2593113,	'Алька',	'Alcoy',	'Alcoy',	1,	652,	'2019-03-16 03:59:51',	'Alcoy',	'Alcoy',	'Alcoy'),
(2522121,	67,	2593109,	'Alcolea',	'Alcolea',	'Alcolea',	1,	645,	'2019-03-16 03:59:51',	'Alcolea',	'Alcolea',	'Alcolea'),
(2522129,	67,	2593113,	'Альсира',	'Alzira',	'Alzira',	1,	1166,	'2019-03-16 03:59:51',	'Alzira',	'Alzira',	'Alzira'),
(2522131,	67,	2593111,	'Алькасар-де-Сан-Хуан',	'Alcazar de San Juan',	'Alcazar de San Juan',	1,	638,	'2019-03-16 03:59:51',	'Alcazar de San Juan',	'Alcazar de San Juan',	'Alcazar de San Juan'),
(2522137,	67,	2593109,	'Alcaudete',	'Alcaudete',	'Alcaudete',	1,	637,	'2019-03-16 03:59:51',	'Alcaudete',	'Alcaudete',	'Alcaudete'),
(2522152,	67,	2513413,	'Алькантарилья',	'Alcantarilla',	'Alcantarilla',	1,	635,	'2019-03-16 03:59:51',	'Alcantarilla',	'Alcantarilla',	'Alcantarilla'),
(2522159,	67,	2593113,	'Alcalali',	'Alcalali',	'Alcalali',	1,	630,	'2019-03-16 03:59:51',	'Alcalali',	'Alcalali',	'Alcalali'),
(2522160,	67,	2593109,	'Алькала-ла-Реаль',	'Alcala la Real',	'Alcala la Real',	1,	629,	'2019-03-16 03:59:51',	'Alcala la Real',	'Alcala la Real',	'Alcala la Real'),
(2522161,	67,	2593109,	'Alcala del Valle',	'Alcala del Valle',	'Alcala del Valle',	1,	628,	'2019-03-16 03:59:51',	'Alcala del Valle',	'Alcala del Valle',	'Alcala del Valle'),
(2522162,	67,	2593109,	'Alcala de los Gazules',	'Alcala de los Gazules',	'Alcala de los Gazules',	1,	626,	'2019-03-16 03:59:51',	'Alcala de los Gazules',	'Alcala de los Gazules',	'Alcala de los Gazules'),
(2522165,	67,	2593109,	'Алькала-де-Гвадаира',	'Alcala de Guadaira',	'Alcala de Guadaira',	1,	624,	'2019-03-16 03:59:51',	'Alcala de Guadaira',	'Alcala de Guadaira',	'Alcala de Guadaira'),
(2522179,	67,	2593113,	'Alcasser',	'Alcasser',	'Alcasser',	1,	636,	'2019-03-16 03:59:51',	'Alcasser',	'Alcasser',	'Alcasser'),
(2522183,	67,	2593112,	'Alburquerque',	'Alburquerque',	'Alburquerque',	1,	619,	'2019-03-16 03:59:51',	'Alburquerque',	'Alburquerque',	'Alburquerque'),
(2522191,	67,	2593113,	'Albuixech',	'Albuixech',	'Albuixech',	1,	615,	'2019-03-16 03:59:51',	'Albuixech',	'Albuixech',	'Albuixech'),
(2522200,	67,	2593109,	'Albox',	'Albox',	'Albox',	1,	609,	'2019-03-16 03:59:51',	'Albox',	'Albox',	'Albox'),
(2522203,	67,	2593113,	'Альборайя',	'Alboraya',	'Alboraya',	1,	607,	'2019-03-16 03:59:51',	'Alboraya',	'Alboraya',	'Alboraya'),
(2522208,	67,	2593109,	'Albolote',	'Albolote',	'Albolote',	1,	604,	'2019-03-16 03:59:51',	'Albolote',	'Albolote',	'Albolote'),
(2522222,	67,	2593113,	'Alberic',	'Alberic',	'Alberic',	1,	556,	'2019-03-16 03:59:51',	'Alberic',	'Alberic',	'Alberic'),
(2522228,	67,	2593113,	'Albatera',	'Albatera',	'Albatera',	1,	547,	'2019-03-16 03:59:51',	'Albatera',	'Albatera',	'Albatera'),
(2522243,	67,	2593113,	'Albalat dels Tarongers',	'Albalat dels Tarongers',	'Albalat dels Tarongers',	1,	524,	'2019-03-16 03:59:51',	'Albalat dels Tarongers',	'Albalat dels Tarongers',	'Albalat dels Tarongers'),
(2522244,	67,	2593113,	'Albalat dels Sorells',	'Albalat dels Sorells',	'Albalat dels Sorells',	1,	523,	'2019-03-16 03:59:51',	'Albalat dels Sorells',	'Albalat dels Sorells',	'Albalat dels Sorells'),
(2522250,	67,	2593113,	'Albal',	'Albal',	'Albal',	1,	522,	'2019-03-16 03:59:51',	'Albal',	'Albal',	'Albal'),
(2522251,	67,	2593109,	'Albaida del Aljarafe',	'Albaida del Aljarafe',	'Albaida del Aljarafe',	1,	521,	'2019-03-16 03:59:51',	'Albaida del Aljarafe',	'Albaida del Aljarafe',	'Albaida del Aljarafe'),
(2522253,	67,	2593113,	'Albaida',	'Albaida',	'Albaida',	1,	520,	'2019-03-16 03:59:51',	'Albaida',	'Albaida',	'Albaida'),
(2522258,	67,	2593111,	'Альбасете',	'Albacete',	'Albacete',	1,	519,	'2019-03-16 03:59:51',	'Albacete',	'Albacete',	'Albacete'),
(2522261,	67,	2521383,	'Alaro',	'Alaro',	'Alaro',	1,	511,	'2019-03-16 03:59:51',	'Alaro',	'Alaro',	'Alaro'),
(2522268,	67,	2593112,	'Alange',	'Alange',	'Alange',	1,	505,	'2019-03-16 03:59:51',	'Alange',	'Alange',	'Alange'),
(2522286,	67,	2593109,	'Alamedilla',	'Alamedilla',	'Alamedilla',	1,	495,	'2019-03-16 03:59:51',	'Alamedilla',	'Alamedilla',	'Alamedilla'),
(2522291,	67,	2593109,	'Alameda',	'Alameda',	'Alameda',	1,	493,	'2019-03-16 03:59:51',	'Alameda',	'Alameda',	'Alameda'),
(2522297,	67,	2593113,	'Алакуас',	'Alaquas',	'Alaquas',	1,	509,	'2019-03-16 03:59:51',	'Alaquas',	'Alaquas',	'Alaquas'),
(2522299,	67,	2593111,	'Ajofrin',	'Ajofrin',	'Ajofrin',	1,	452,	'2019-03-16 03:59:51',	'Ajofrin',	'Ajofrin',	'Ajofrin'),
(2522312,	67,	2593112,	'Ahillones',	'Ahillones',	'Ahillones',	1,	340,	'2019-03-16 03:59:51',	'Ahillones',	'Ahillones',	'Ahillones'),
(2522319,	67,	2593113,	'Agullent',	'Agullent',	'Agullent',	1,	335,	'2019-03-16 03:59:51',	'Agullent',	'Agullent',	'Agullent'),
(2522325,	67,	2593110,	'Агуимес',	'Aguimes',	'Aguimes',	1,	333,	'2019-03-16 03:59:51',	'Aguimes',	'Aguimes',	'Aguimes'),
(2522333,	67,	2513413,	'Агилас',	'Aguilas',	'Aguilas',	1,	332,	'2019-03-16 03:59:51',	'Aguilas',	'Aguilas',	'Aguilas'),
(2522335,	67,	2593109,	'Aguilar',	'Aguilar',	'Aguilar',	1,	330,	'2019-03-16 03:59:51',	'Aguilar',	'Aguilar',	'Aguilar'),
(2522388,	67,	2593109,	'Aguadulce',	'Aguadulce',	'Aguadulce',	1,	323,	'2019-03-16 03:59:51',	'Aguadulce',	'Aguadulce',	'Aguadulce'),
(2522423,	67,	2593110,	'Agaete',	'Agaete',	'Agaete',	1,	287,	'2019-03-16 03:59:51',	'Agaete',	'Agaete',	'Agaete'),
(2522428,	67,	2593113,	'Adsubia',	'Adsubia',	'Adsubia',	1,	266,	'2019-03-16 03:59:51',	'Adsubia',	'Adsubia',	'Adsubia'),
(2522430,	67,	2593109,	'Адра',	'Adra',	'Adra',	1,	256,	'2019-03-16 03:59:51',	'Adra',	'Adra',	'Adra'),
(2522437,	67,	2593110,	'Адехе',	'Adeje',	'Adeje',	1,	220,	'2019-03-16 03:59:51',	'Adeje',	'Adeje',	'Adeje'),
(2522438,	67,	2593109,	'Adamuz',	'Adamuz',	'Adamuz',	1,	202,	'2019-03-16 03:59:51',	'Adamuz',	'Adamuz',	'Adamuz'),
(2522474,	67,	2593109,	'Acala del Rio',	'Acala del Rio',	'Acala del Rio',	1,	116,	'2019-03-16 03:59:51',	'Acala del Rio',	'Acala del Rio',	'Acala del Rio'),
(2522483,	67,	2593109,	'Abla',	'Abla',	'Abla',	1,	91,	'2019-03-16 03:59:51',	'Abla',	'Abla',	'Abla'),
(2522499,	67,	2513413,	'Abaran',	'Abaran',	'Abaran',	1,	23,	'2019-03-16 03:59:51',	'Abaran',	'Abaran',	'Abaran'),
(2522505,	67,	2513413,	'Abanilla',	'Abanilla',	'Abanilla',	1,	21,	'2019-03-16 03:59:51',	'Abanilla',	'Abanilla',	'Abanilla'),
(2522683,	108,	2523228,	'Zerfaliu',	'Zerfaliu',	'Zerfaliu',	1,	55116,	'2019-03-16 03:59:51',	'Zerfaliu',	'Zerfaliu',	'Zerfaliu'),
(2522685,	108,	2523228,	'Zeddiani',	'Zeddiani',	'Zeddiani',	1,	55075,	'2019-03-16 03:59:51',	'Zeddiani',	'Zeddiani',	'Zeddiani'),
(2522696,	108,	2523119,	'Zafferana Etnea',	'Zafferana Etnea',	'Zafferana Etnea',	1,	55024,	'2019-03-16 03:59:51',	'Zafferana Etnea',	'Zafferana Etnea',	'Zafferana Etnea'),
(2522699,	108,	2525468,	'Zaccanopoli',	'Zaccanopoli',	'Zaccanopoli',	1,	55020,	'2019-03-16 03:59:51',	'Zaccanopoli',	'Zaccanopoli',	'Zaccanopoli'),
(2522709,	108,	2523119,	'Vizzini',	'Vizzini',	'Vizzini',	1,	52208,	'2019-03-16 03:59:51',	'Vizzini',	'Vizzini',	'Vizzini'),
(2522713,	108,	2523119,	'Vittoria',	'Vittoria',	'Vittoria',	1,	52182,	'2019-03-16 03:59:51',	'Vittoria',	'Vittoria',	'Vittoria'),
(2522717,	108,	2525468,	'Vito',	'Vito',	'Vito',	1,	52164,	'2019-03-16 03:59:51',	'Vito',	'Vito',	'Vito'),
(2522718,	108,	2523119,	'Vita',	'Vita',	'Vita',	1,	52156,	'2019-03-16 03:59:51',	'Vita',	'Vita',	'Vita'),
(2522720,	108,	2523228,	'Villaurbana',	'Villaurbana',	'Villaurbana',	1,	51813,	'2019-03-16 03:59:51',	'Villaurbana',	'Villaurbana',	'Villaurbana'),
(2522724,	108,	2523228,	'Villaspeciosa',	'Villaspeciosa',	'Villaspeciosa',	1,	51807,	'2019-03-16 03:59:51',	'Villaspeciosa',	'Villaspeciosa',	'Villaspeciosa'),
(2522725,	108,	2523228,	'Villasor',	'Villasor',	'Villasor',	1,	51806,	'2019-03-16 03:59:51',	'Villasor',	'Villasor',	'Villasor'),
(2522726,	108,	2523119,	'Villasmundo',	'Villasmundo',	'Villasmundo',	1,	51805,	'2019-03-16 03:59:51',	'Villasmundo',	'Villasmundo',	'Villasmundo'),
(2522730,	108,	2525468,	'Villa San Giovanni',	'Villa San Giovanni',	'Villa San Giovanni',	1,	51667,	'2019-03-16 03:59:51',	'Villa San Giovanni',	'Villa San Giovanni',	'Villa San Giovanni'),
(2522732,	108,	2523119,	'Villarosa',	'Villarosa',	'Villarosa',	1,	51789,	'2019-03-16 03:59:51',	'Villarosa',	'Villarosa',	'Villarosa'),
(2522734,	108,	2523228,	'Villaputzu',	'Villaputzu',	'Villaputzu',	1,	51764,	'2019-03-16 03:59:51',	'Villaputzu',	'Villaputzu',	'Villaputzu'),
(2522736,	108,	2525468,	'Villapiana',	'Villapiana',	'Villapiana',	1,	51762,	'2019-03-16 03:59:51',	'Villapiana',	'Villapiana',	'Villapiana'),
(2522742,	108,	2523228,	'Villanovafranca',	'Villanovafranca',	'Villanovafranca',	1,	51737,	'2019-03-16 03:59:51',	'Villanovafranca',	'Villanovafranca',	'Villanovafranca'),
(2522745,	108,	2525468,	'Villa Morelli',	'Villa Morelli',	'Villa Morelli',	1,	51662,	'2019-03-16 03:59:51',	'Villa Morelli',	'Villa Morelli',	'Villa Morelli'),
(2522748,	108,	2523228,	'Villamassargia',	'Villamassargia',	'Villamassargia',	1,	51722,	'2019-03-16 03:59:51',	'Villamassargia',	'Villamassargia',	'Villamassargia'),
(2522749,	108,	2523228,	'Villamar',	'Villamar',	'Villamar',	1,	51720,	'2019-03-16 03:59:51',	'Villamar',	'Villamar',	'Villamar'),
(2522750,	108,	2523119,	'Villalba',	'Villalba',	'Villalba',	1,	51709,	'2019-03-16 03:59:51',	'Villalba',	'Villalba',	'Villalba'),
(2522755,	108,	2523119,	'Villagrazia',	'Villagrazia',	'Villagrazia',	1,	51701,	'2019-03-16 03:59:51',	'Villagrazia',	'Villagrazia',	'Villagrazia'),
(2522760,	108,	2523119,	'Villafrati',	'Villafrati',	'Villafrati',	1,	51696,	'2019-03-16 03:59:51',	'Villafrati',	'Villafrati',	'Villafrati'),
(2522761,	108,	2523119,	'Villafranca Tirrena',	'Villafranca Tirrena',	'Villafranca Tirrena',	1,	51695,	'2019-03-16 03:59:51',	'Villafranca Tirrena',	'Villafranca Tirrena',	'Villafranca Tirrena'),
(2522762,	108,	2523119,	'Villafranca Sicula',	'Villafranca Sicula',	'Villafranca Sicula',	1,	51694,	'2019-03-16 03:59:51',	'Villafranca Sicula',	'Villafranca Sicula',	'Villafranca Sicula'),
(2522763,	108,	2523119,	'Villadoro',	'Villadoro',	'Villadoro',	1,	51679,	'2019-03-16 03:59:51',	'Villadoro',	'Villadoro',	'Villadoro'),
(2522766,	108,	2523228,	'Villacidro',	'Villacidro',	'Villacidro',	1,	51678,	'2019-03-16 03:59:51',	'Villacidro',	'Villacidro',	'Villacidro'),
(2522767,	108,	2523119,	'Villabate',	'Villabate',	'Villabate',	1,	51671,	'2019-03-16 03:59:51',	'Villabate',	'Villabate',	'Villabate'),
(2522774,	108,	2523119,	'Vicari',	'Vicari',	'Vicari',	1,	51463,	'2019-03-16 03:59:51',	'Vicari',	'Vicari',	'Vicari'),
(2522776,	108,	2525468,	'Вибо-Валентия',	'Vibo Valentia',	'Vibo Valentia',	1,	51450,	'2019-03-16 03:59:51',	'Vibo Valentia',	'Vibo Valentia',	'Vibo Valentia'),
(2522777,	108,	2523119,	'Viagrande',	'Viagrande',	'Viagrande',	1,	51440,	'2019-03-16 03:59:51',	'Viagrande',	'Viagrande',	'Viagrande'),
(2522785,	108,	2525468,	'Verbicaro',	'Verbicaro',	'Verbicaro',	1,	51208,	'2019-03-16 03:59:51',	'Verbicaro',	'Verbicaro',	'Verbicaro'),
(2522787,	108,	2523119,	'Ventimiglia di Sicilia',	'Ventimiglia di Sicilia',	'Ventimiglia di Sicilia',	1,	51186,	'2019-03-16 03:59:51',	'Ventimiglia di Sicilia',	'Ventimiglia di Sicilia',	'Ventimiglia di Sicilia'),
(2522788,	108,	2523119,	'Venetico',	'Venetico',	'Venetico',	1,	51157,	'2019-03-16 03:59:51',	'Venetico',	'Venetico',	'Venetico'),
(2522789,	108,	2525468,	'Vena Superiore',	'Vena Superiore',	'Vena Superiore',	1,	51122,	'2019-03-16 03:59:51',	'Vena Superiore',	'Vena Superiore',	'Vena Superiore'),
(2522798,	108,	2523228,	'Vallermosa',	'Vallermosa',	'Vallermosa',	1,	50777,	'2019-03-16 03:59:51',	'Vallermosa',	'Vallermosa',	'Vallermosa'),
(2522803,	108,	2525468,	'Vallefiorita',	'Vallefiorita',	'Vallefiorita',	1,	50769,	'2019-03-16 03:59:51',	'Vallefiorita',	'Vallefiorita',	'Vallefiorita'),
(2522805,	108,	2523119,	'Valguarnera Caropepe',	'Valguarnera Caropepe',	'Valguarnera Caropepe',	1,	50741,	'2019-03-16 03:59:51',	'Valguarnera Caropepe',	'Valguarnera Caropepe',	'Valguarnera Caropepe'),
(2522816,	108,	2523228,	'Uta',	'Uta',	'Uta',	1,	50575,	'2019-03-16 03:59:51',	'Uta',	'Uta',	'Uta'),
(2522821,	108,	2523228,	'Ussana',	'Ussana',	'Ussana',	1,	50562,	'2019-03-16 03:59:51',	'Ussana',	'Ussana',	'Ussana'),
(2522833,	108,	3169778,	'Ugento',	'Ugento',	'Ugento',	1,	50279,	'2019-03-16 03:59:51',	'Ugento',	'Ugento',	'Ugento'),
(2522847,	108,	2525468,	'Tropea',	'Tropea',	'Tropea',	1,	49985,	'2019-03-16 03:59:51',	'Tropea',	'Tropea',	'Tropea'),
(2522849,	108,	2523119,	'Troina',	'Troina',	'Troina',	1,	49969,	'2019-03-16 03:59:51',	'Troina',	'Troina',	'Troina'),
(2522857,	108,	3169778,	'Tricase',	'Tricase',	'Tricase',	1,	49906,	'2019-03-16 03:59:51',	'Tricase',	'Tricase',	'Tricase'),
(2522865,	108,	2523119,	'Trecastagni',	'Trecastagni',	'Trecastagni',	1,	49764,	'2019-03-16 03:59:51',	'Trecastagni',	'Trecastagni',	'Trecastagni'),
(2522867,	108,	2525468,	'Trebisacce',	'Trebisacce',	'Trebisacce',	1,	49756,	'2019-03-16 03:59:51',	'Trebisacce',	'Trebisacce',	'Trebisacce'),
(2522870,	108,	2523228,	'Tratalias',	'Tratalias',	'Tratalias',	1,	49732,	'2019-03-16 03:59:51',	'Tratalias',	'Tratalias',	'Tratalias'),
(2522876,	108,	2523119,	'Трапани',	'Trapani',	'Trapani',	1,	49727,	'2019-03-16 03:59:51',	'Trapani',	'Trapani',	'Trapani'),
(2522879,	108,	2523228,	'Tramatza',	'Tramatza',	'Tramatza',	1,	49707,	'2019-03-16 03:59:51',	'Tramatza',	'Tramatza',	'Tramatza'),
(2522883,	108,	2523119,	'Trabia',	'Trabia',	'Trabia',	1,	49683,	'2019-03-16 03:59:51',	'Trabia',	'Trabia',	'Trabia'),
(2522885,	108,	2523119,	'Tortorici',	'Tortorici',	'Tortorici',	1,	49567,	'2019-03-16 03:59:51',	'Tortorici',	'Tortorici',	'Tortorici'),
(2522886,	108,	2525468,	'Tortora',	'Tortora',	'Tortora',	1,	49565,	'2019-03-16 03:59:51',	'Tortora',	'Tortora',	'Tortora'),
(2522890,	108,	2523228,	'Тортоли',	'Tortoli',	'Tortoli',	1,	49563,	'2019-03-16 03:59:51',	'Tortoli',	'Tortoli',	'Tortoli'),
(2522908,	108,	2523119,	'Torregrotta',	'Torregrotta',	'Torregrotta',	1,	49510,	'2019-03-16 03:59:51',	'Torregrotta',	'Torregrotta',	'Torregrotta'),
(2522911,	108,	2525468,	'Torre di Ruggiero',	'Torre di Ruggiero',	'Torre di Ruggiero',	1,	49494,	'2019-03-16 03:59:51',	'Torre di Ruggiero',	'Torre di Ruggiero',	'Torre di Ruggiero'),
(2522924,	108,	2525468,	'Torano Castello',	'Torano Castello',	'Torano Castello',	1,	49435,	'2019-03-16 03:59:51',	'Torano Castello',	'Torano Castello',	'Torano Castello'),
(2522930,	108,	2525468,	'Tiriolo',	'Tiriolo',	'Tiriolo',	1,	49278,	'2019-03-16 03:59:51',	'Tiriolo',	'Tiriolo',	'Tiriolo'),
(2522934,	108,	3169778,	'Tiggiano',	'Tiggiano',	'Tiggiano',	1,	49197,	'2019-03-16 03:59:51',	'Tiggiano',	'Tiggiano',	'Tiggiano'),
(2522941,	108,	2523228,	'Teulada',	'Teulada',	'Teulada',	1,	48879,	'2019-03-16 03:59:51',	'Teulada',	'Teulada',	'Teulada'),
(2522944,	108,	2523228,	'Tertenia',	'Tertenia',	'Tertenia',	1,	48851,	'2019-03-16 03:59:51',	'Tertenia',	'Tertenia',	'Tertenia'),
(2522952,	108,	2523119,	'Terrasini',	'Terrasini',	'Terrasini',	1,	48835,	'2019-03-16 03:59:51',	'Terrasini',	'Terrasini',	'Terrasini'),
(2522955,	108,	2525468,	'Terranova Sappo Minulio',	'Terranova Sappo Minulio',	'Terranova Sappo Minulio',	1,	48833,	'2019-03-16 03:59:51',	'Terranova Sappo Minulio',	'Terranova Sappo Minulio',	'Terranova Sappo Minulio'),
(2522956,	108,	2525468,	'Terranova da Sibari',	'Terranova da Sibari',	'Terranova da Sibari',	1,	48832,	'2019-03-16 03:59:51',	'Terranova da Sibari',	'Terranova da Sibari',	'Terranova da Sibari'),
(2522958,	108,	2523228,	'Terralba',	'Terralba',	'Terralba',	1,	48830,	'2019-03-16 03:59:51',	'Terralba',	'Terralba',	'Terralba'),
(2522960,	108,	2523119,	'Termini Imerese',	'Termini Imerese',	'Termini Imerese',	1,	48814,	'2019-03-16 03:59:51',	'Termini Imerese',	'Termini Imerese',	'Termini Imerese'),
(2522968,	108,	3169778,	'Taviano',	'Taviano',	'Taviano',	1,	48658,	'2019-03-16 03:59:51',	'Taviano',	'Taviano',	'Taviano'),
(2522970,	108,	3169778,	'Taurisano',	'Taurisano',	'Taurisano',	1,	48634,	'2019-03-16 03:59:51',	'Taurisano',	'Taurisano',	'Taurisano'),
(2522971,	108,	2525468,	'Taurianova',	'Taurianova',	'Taurianova',	1,	48632,	'2019-03-16 03:59:51',	'Taurianova',	'Taurianova',	'Taurianova'),
(2522975,	108,	2523119,	'Таормина',	'Taormina',	'Taormina',	1,	48542,	'2019-03-16 03:59:51',	'Taormina',	'Taormina',	'Taormina'),
(2522985,	108,	2523228,	'Suelli',	'Suelli',	'Suelli',	1,	48036,	'2019-03-16 03:59:51',	'Suelli',	'Suelli',	'Suelli'),
(2522990,	108,	2525468,	'Strongoli',	'Strongoli',	'Strongoli',	1,	47939,	'2019-03-16 03:59:51',	'Strongoli',	'Strongoli',	'Strongoli'),
(2522997,	108,	2525468,	'Стило',	'Stilo',	'Stilo',	1,	47710,	'2019-03-16 03:59:51',	'Stilo',	'Stilo',	'Stilo'),
(2523004,	108,	2525468,	'Staletti',	'Staletti',	'Staletti',	1,	47403,	'2019-03-16 03:59:51',	'Staletti',	'Staletti',	'Staletti'),
(2523010,	108,	2525468,	'Squillace',	'Squillace',	'Squillace',	1,	47346,	'2019-03-16 03:59:51',	'Squillace',	'Squillace',	'Squillace'),
(2523023,	108,	2525468,	'Spezzano della Sila',	'Spezzano della Sila',	'Spezzano della Sila',	1,	47194,	'2019-03-16 03:59:51',	'Spezzano della Sila',	'Spezzano della Sila',	'Spezzano della Sila'),
(2523025,	108,	2525468,	'Spezzano Albanese',	'Spezzano Albanese',	'Spezzano Albanese',	1,	47193,	'2019-03-16 03:59:51',	'Spezzano Albanese',	'Spezzano Albanese',	'Spezzano Albanese'),
(2523027,	108,	2523119,	'Sperone',	'Sperone',	'Sperone',	1,	47185,	'2019-03-16 03:59:51',	'Sperone',	'Sperone',	'Sperone'),
(2523030,	108,	3169778,	'Specchia',	'Specchia',	'Specchia',	1,	47150,	'2019-03-16 03:59:51',	'Specchia',	'Specchia',	'Specchia'),
(2523041,	108,	2523119,	'Spadafora',	'Spadafora',	'Spadafora',	1,	47105,	'2019-03-16 03:59:51',	'Spadafora',	'Spadafora',	'Spadafora'),
(2523043,	108,	2525468,	'Soveria Mannelli',	'Soveria Mannelli',	'Soveria Mannelli',	1,	47095,	'2019-03-16 03:59:51',	'Soveria Mannelli',	'Soveria Mannelli',	'Soveria Mannelli'),
(2523049,	108,	2523119,	'Sortino',	'Sortino',	'Sortino',	1,	46847,	'2019-03-16 03:59:51',	'Sortino',	'Sortino',	'Sortino'),
(2523056,	108,	2523119,	'Sommatino',	'Sommatino',	'Sommatino',	1,	46756,	'2019-03-16 03:59:51',	'Sommatino',	'Sommatino',	'Sommatino'),
(2523062,	108,	2523228,	'Soleminis',	'Soleminis',	'Soleminis',	1,	46665,	'2019-03-16 03:59:51',	'Soleminis',	'Soleminis',	'Soleminis'),
(2523064,	108,	2523228,	'Solarussa',	'Solarussa',	'Solarussa',	1,	46656,	'2019-03-16 03:59:51',	'Solarussa',	'Solarussa',	'Solarussa'),
(2523066,	108,	2523119,	'Solarino',	'Solarino',	'Solarino',	1,	46653,	'2019-03-16 03:59:51',	'Solarino',	'Solarino',	'Solarino'),
(2523083,	108,	2523119,	'Сиракуза',	'Siracusa',	'Siracusa',	1,	46421,	'2019-03-16 03:59:51',	'Siracusa',	'Siracusa',	'Siracusa'),
(2523087,	108,	2523228,	'Sinnai',	'Sinnai',	'Sinnai',	1,	46405,	'2019-03-16 03:59:51',	'Sinnai',	'Sinnai',	'Sinnai'),
(2523091,	108,	2525468,	'Simone',	'Simone',	'Simone',	1,	46374,	'2019-03-16 03:59:51',	'Simone',	'Simone',	'Simone'),
(2523097,	108,	2525468,	'Simeri',	'Simeri',	'Simeri',	1,	46359,	'2019-03-16 03:59:51',	'Simeri',	'Simeri',	'Simeri'),
(2523099,	108,	2523228,	'Simaxis',	'Simaxis',	'Simaxis',	1,	46355,	'2019-03-16 03:59:51',	'Simaxis',	'Simaxis',	'Simaxis'),
(2523104,	108,	2523228,	'Siliqua',	'Siliqua',	'Siliqua',	1,	46298,	'2019-03-16 03:59:51',	'Siliqua',	'Siliqua',	'Siliqua'),
(2523113,	108,	2525468,	'Siderno',	'Siderno',	'Siderno',	1,	46221,	'2019-03-16 03:59:51',	'Siderno',	'Siderno',	'Siderno'),
(2523116,	108,	2523119,	'Siculiana',	'Siculiana',	'Siculiana',	1,	46216,	'2019-03-16 03:59:51',	'Siculiana',	'Siculiana',	'Siculiana'),
(2523124,	108,	2523228,	'Siapiccia',	'Siapiccia',	'Siapiccia',	1,	46203,	'2019-03-16 03:59:51',	'Siapiccia',	'Siapiccia',	'Siapiccia'),
(2523126,	108,	2523228,	'Siamanna',	'Siamanna',	'Siamanna',	1,	46201,	'2019-03-16 03:59:51',	'Siamanna',	'Siamanna',	'Siamanna'),
(2523127,	108,	2523228,	'Siamaggiore',	'Siamaggiore',	'Siamaggiore',	1,	46200,	'2019-03-16 03:59:51',	'Siamaggiore',	'Siamaggiore',	'Siamaggiore'),
(2523135,	108,	2523228,	'Settimo San Pietro',	'Settimo San Pietro',	'Settimo San Pietro',	1,	45851,	'2019-03-16 03:59:51',	'Settimo San Pietro',	'Settimo San Pietro',	'Settimo San Pietro'),
(2523136,	108,	2523228,	'Sestu',	'Sestu',	'Sestu',	1,	45846,	'2019-03-16 03:59:51',	'Sestu',	'Sestu',	'Sestu'),
(2523142,	108,	2523228,	'Serrenti',	'Serrenti',	'Serrenti',	1,	45806,	'2019-03-16 03:59:51',	'Serrenti',	'Serrenti',	'Serrenti'),
(2523144,	108,	2525468,	'Serrata',	'Serrata',	'Serrata',	1,	45799,	'2019-03-16 03:59:51',	'Serrata',	'Serrata',	'Serrata'),
(2523147,	108,	2525468,	'Serra Pedace',	'Serra Pedace',	'Serra Pedace',	1,	45792,	'2019-03-16 03:59:51',	'Serra Pedace',	'Serra Pedace',	'Serra Pedace'),
(2523148,	108,	2523228,	'Serramanna',	'Serramanna',	'Serramanna',	1,	45796,	'2019-03-16 03:59:51',	'Serramanna',	'Serramanna',	'Serramanna'),
(2523152,	108,	2525468,	'Serra d\'Aiello',	'Serra d\'Aiello',	'Serra d\'Aiello',	1,	45790,	'2019-03-16 03:59:51',	'Serra d\'Aiello',	'Serra d\'Aiello',	'Serra d\'Aiello'),
(2523156,	108,	2523228,	'Serdiana',	'Serdiana',	'Serdiana',	1,	45743,	'2019-03-16 03:59:51',	'Serdiana',	'Serdiana',	'Serdiana'),
(2523159,	108,	2523228,	'Senorbi',	'Senorbi',	'Senorbi',	1,	45709,	'2019-03-16 03:59:51',	'Senorbi',	'Senorbi',	'Senorbi'),
(2523163,	108,	2525468,	'Sellia',	'Sellia',	'Sellia',	1,	45627,	'2019-03-16 03:59:51',	'Sellia',	'Sellia',	'Sellia'),
(2523165,	108,	2523228,	'Selegas',	'Selegas',	'Selegas',	1,	45606,	'2019-03-16 03:59:51',	'Selegas',	'Selegas',	'Selegas'),
(2523166,	108,	2523228,	'Selargius',	'Selargius',	'Selargius',	1,	45596,	'2019-03-16 03:59:51',	'Selargius',	'Selargius',	'Selargius'),
(2523172,	108,	2523228,	'Segariu',	'Segariu',	'Segariu',	1,	45553,	'2019-03-16 03:59:51',	'Segariu',	'Segariu',	'Segariu'),
(2523176,	108,	2523119,	'Scuola',	'Scuola',	'Scuola',	1,	45409,	'2019-03-16 03:59:51',	'Scuola',	'Scuola',	'Scuola'),
(2523180,	108,	2523119,	'Scordia',	'Scordia',	'Scordia',	1,	45368,	'2019-03-16 03:59:51',	'Scordia',	'Scordia',	'Scordia'),
(2523187,	108,	2525468,	'Scilla',	'Scilla',	'Scilla',	1,	45354,	'2019-03-16 03:59:51',	'Scilla',	'Scilla',	'Scilla'),
(2523192,	108,	2523119,	'Шикли',	'Scicli',	'Scicli',	1,	45349,	'2019-03-16 03:59:51',	'Scicli',	'Scicli',	'Scicli'),
(2523194,	108,	2523119,	'Sciacca',	'Sciacca',	'Sciacca',	1,	45348,	'2019-03-16 03:59:51',	'Sciacca',	'Sciacca',	'Sciacca'),
(2523204,	108,	2523119,	'Scaletta Zanclea',	'Scaletta Zanclea',	'Scaletta Zanclea',	1,	44954,	'2019-03-16 03:59:51',	'Scaletta Zanclea',	'Scaletta Zanclea',	'Scaletta Zanclea'),
(2523222,	108,	2523228,	'Sarroch',	'Sarroch',	'Sarroch',	1,	44732,	'2019-03-16 03:59:51',	'Sarroch',	'Sarroch',	'Sarroch'),
(2523229,	108,	2523228,	'Sardara',	'Sardara',	'Sardara',	1,	44680,	'2019-03-16 03:59:51',	'Sardara',	'Sardara',	'Sardara'),
(2523234,	108,	2523119,	'Saponara',	'Saponara',	'Saponara',	1,	44649,	'2019-03-16 03:59:51',	'Saponara',	'Saponara',	'Saponara'),
(2523237,	108,	2525468,	'San Vito sullo Ionio',	'San Vito sullo Ionio',	'San Vito sullo Ionio',	1,	44285,	'2019-03-16 03:59:51',	'San Vito sullo Ionio',	'San Vito sullo Ionio',	'San Vito sullo Ionio'),
(2523238,	108,	2523119,	'San Vito Lo Capo',	'San Vito Lo Capo',	'San Vito Lo Capo',	1,	44283,	'2019-03-16 03:59:51',	'San Vito Lo Capo',	'San Vito Lo Capo',	'San Vito Lo Capo'),
(2523241,	108,	2523228,	'San Vito',	'San Vito',	'San Vito',	1,	44276,	'2019-03-16 03:59:51',	'San Vito',	'San Vito',	'San Vito'),
(2523247,	108,	2523119,	'Santo Stefano Quisquina',	'Santo Stefano Quisquina',	'Santo Stefano Quisquina',	1,	44633,	'2019-03-16 03:59:51',	'Santo Stefano Quisquina',	'Santo Stefano Quisquina',	'Santo Stefano Quisquina'),
(2523251,	108,	2523119,	'Santo Stefano di Briga',	'Santo Stefano di Briga',	'Santo Stefano di Briga',	1,	44631,	'2019-03-16 03:59:51',	'Santo Stefano di Briga',	'Santo Stefano di Briga',	'Santo Stefano di Briga'),
(2523255,	108,	2523228,	'San Sperate',	'San Sperate',	'San Sperate',	1,	44261,	'2019-03-16 03:59:51',	'San Sperate',	'San Sperate',	'San Sperate'),
(2523271,	108,	2523119,	'San Teodoro',	'San Teodoro',	'San Teodoro',	1,	44264,	'2019-03-16 03:59:51',	'San Teodoro',	'San Teodoro',	'San Teodoro'),
(2523280,	108,	2523119,	'Santa Venerina',	'Santa Venerina',	'Santa Venerina',	1,	44589,	'2019-03-16 03:59:51',	'Santa Venerina',	'Santa Venerina',	'Santa Venerina'),
(2523282,	108,	2523119,	'Santa Teresa di Riva',	'Santa Teresa di Riva',	'Santa Teresa di Riva',	1,	44585,	'2019-03-16 03:59:51',	'Santa Teresa di Riva',	'Santa Teresa di Riva',	'Santa Teresa di Riva'),
(2523297,	108,	2523228,	'Sant\'Antioco',	'Sant\'Antioco',	'Sant\'Antioco',	1,	44474,	'2019-03-16 03:59:51',	'Sant\'Antioco',	'Sant\'Antioco',	'Sant\'Antioco'),
(2523306,	108,	2523119,	'Sant\'Angelo Muxaro',	'Sant\'Angelo Muxaro',	'Sant\'Angelo Muxaro',	1,	44471,	'2019-03-16 03:59:51',	'Sant\'Angelo Muxaro',	'Sant\'Angelo Muxaro',	'Sant\'Angelo Muxaro'),
(2523320,	108,	2523119,	'Santa Maria di Licodia',	'Santa Maria di Licodia',	'Santa Maria di Licodia',	1,	44562,	'2019-03-16 03:59:51',	'Santa Maria di Licodia',	'Santa Maria di Licodia',	'Santa Maria di Licodia'),
(2523333,	108,	2523119,	'Santa Lucia del Mela',	'Santa Lucia del Mela',	'Santa Lucia del Mela',	1,	44541,	'2019-03-16 03:59:51',	'Santa Lucia del Mela',	'Santa Lucia del Mela',	'Santa Lucia del Mela'),
(2523344,	108,	2523228,	'Santa Giusta',	'Santa Giusta',	'Santa Giusta',	1,	44534,	'2019-03-16 03:59:51',	'Santa Giusta',	'Santa Giusta',	'Santa Giusta'),
(2523347,	108,	2523119,	'Sant\'Agata di Militello',	'Sant\'Agata di Militello',	'Sant\'Agata di Militello',	1,	44456,	'2019-03-16 03:59:51',	'Sant\'Agata di Militello',	'Sant\'Agata di Militello',	'Sant\'Agata di Militello'),
(2523352,	108,	2523119,	'Santa Flavia',	'Santa Flavia',	'Santa Flavia',	1,	44532,	'2019-03-16 03:59:51',	'Santa Flavia',	'Santa Flavia',	'Santa Flavia'),
(2523361,	108,	2523228,	'Santadi',	'Santadi',	'Santadi',	1,	44597,	'2019-03-16 03:59:51',	'Santadi',	'Santadi',	'Santadi'),
(2523362,	108,	2523119,	'Santa Croce Camerina',	'Santa Croce Camerina',	'Santa Croce Camerina',	1,	44515,	'2019-03-16 03:59:51',	'Santa Croce Camerina',	'Santa Croce Camerina',	'Santa Croce Camerina'),
(2523365,	108,	2525468,	'Santa Cristina d\'Aspromonte',	'Santa Cristina d\'Aspromonte',	'Santa Cristina d\'Aspromonte',	1,	44512,	'2019-03-16 03:59:51',	'Santa Cristina d\'Aspromonte',	'Santa Cristina d\'Aspromonte',	'Santa Cristina d\'Aspromonte'),
(2523367,	108,	2525468,	'Santa Caterina dello Ionio',	'Santa Caterina dello Ionio',	'Santa Caterina dello Ionio',	1,	44499,	'2019-03-16 03:59:51',	'Santa Caterina dello Ionio',	'Santa Caterina dello Ionio',	'Santa Caterina dello Ionio'),
(2523368,	108,	2525468,	'Santa Caterina Albanese',	'Santa Caterina Albanese',	'Santa Caterina Albanese',	1,	44498,	'2019-03-16 03:59:51',	'Santa Caterina Albanese',	'Santa Caterina Albanese',	'Santa Caterina Albanese'),
(2523371,	108,	2525468,	'San Sosti',	'San Sosti',	'San Sosti',	1,	44260,	'2019-03-16 03:59:51',	'San Sosti',	'San Sosti',	'San Sosti'),
(2523373,	108,	2525468,	'San Sostene',	'San Sostene',	'San Sostene',	1,	44259,	'2019-03-16 03:59:51',	'San Sostene',	'San Sostene',	'San Sostene'),
(2523396,	108,	2523119,	'San Pietro',	'San Pietro',	'San Pietro',	1,	44210,	'2019-03-16 03:59:51',	'San Pietro',	'San Pietro',	'San Pietro'),
(2523406,	108,	2523228,	'San Nicolo d\'Arcidano',	'San Nicolo d\'Arcidano',	'San Nicolo d\'Arcidano',	1,	44190,	'2019-03-16 03:59:51',	'San Nicolo d\'Arcidano',	'San Nicolo d\'Arcidano',	'San Nicolo d\'Arcidano'),
(2523418,	108,	2525468,	'San Mauro Marchesato',	'San Mauro Marchesato',	'San Mauro Marchesato',	1,	44171,	'2019-03-16 03:59:51',	'San Mauro Marchesato',	'San Mauro Marchesato',	'San Mauro Marchesato'),
(2523423,	108,	2523119,	'San Martino',	'San Martino',	'San Martino',	1,	44149,	'2019-03-16 03:59:51',	'San Martino',	'San Martino',	'San Martino'),
(2523426,	108,	2525468,	'San Marco Argentano',	'San Marco Argentano',	'San Marco Argentano',	1,	44139,	'2019-03-16 03:59:51',	'San Marco Argentano',	'San Marco Argentano',	'San Marco Argentano'),
(2523434,	108,	2523228,	'Санлури',	'Sanluri',	'Sanluri',	1,	44415,	'2019-03-16 03:59:51',	'Sanluri',	'Sanluri',	'Sanluri'),
(2523435,	108,	2525468,	'San Lucido',	'San Lucido',	'San Lucido',	1,	44126,	'2019-03-16 03:59:51',	'San Lucido',	'San Lucido',	'San Lucido'),
(2523436,	108,	2525468,	'San Luca',	'San Luca',	'San Luca',	1,	44125,	'2019-03-16 03:59:51',	'San Luca',	'San Luca',	'San Luca'),
(2523438,	108,	2525468,	'San Lorenzo del Vallo',	'San Lorenzo del Vallo',	'San Lorenzo del Vallo',	1,	44123,	'2019-03-16 03:59:51',	'San Lorenzo del Vallo',	'San Lorenzo del Vallo',	'San Lorenzo del Vallo'),
(2523446,	108,	2525468,	'San Lauro',	'San Lauro',	'San Lauro',	1,	44111,	'2019-03-16 03:59:51',	'San Lauro',	'San Lauro',	'San Lauro'),
(2523447,	108,	2525468,	'San Gregorio d\'Ippona',	'San Gregorio d\'Ippona',	'San Gregorio d\'Ippona',	1,	44084,	'2019-03-16 03:59:51',	'San Gregorio d\'Ippona',	'San Gregorio d\'Ippona',	'San Gregorio d\'Ippona'),
(2523448,	108,	2523119,	'San Gregorio di Catania',	'San Gregorio di Catania',	'San Gregorio di Catania',	1,	44086,	'2019-03-16 03:59:51',	'San Gregorio di Catania',	'San Gregorio di Catania',	'San Gregorio di Catania'),
(2523450,	108,	2525468,	'San Gregorio',	'San Gregorio',	'San Gregorio',	1,	44082,	'2019-03-16 03:59:51',	'San Gregorio',	'San Gregorio',	'San Gregorio'),
(2523451,	108,	2523119,	'San Giuseppe Jato',	'San Giuseppe Jato',	'San Giuseppe Jato',	1,	44077,	'2019-03-16 03:59:51',	'San Giuseppe Jato',	'San Giuseppe Jato',	'San Giuseppe Jato'),
(2523456,	108,	2523228,	'San Giovanni Suergiu',	'San Giovanni Suergiu',	'San Giovanni Suergiu',	1,	44071,	'2019-03-16 03:59:51',	'San Giovanni Suergiu',	'San Giovanni Suergiu',	'San Giovanni Suergiu'),
(2523460,	108,	2523119,	'San Giovanni la Punta',	'San Giovanni la Punta',	'San Giovanni la Punta',	1,	44068,	'2019-03-16 03:59:51',	'San Giovanni la Punta',	'San Giovanni la Punta',	'San Giovanni la Punta'),
(2523461,	108,	2525468,	'San Giovanni in Fiore',	'San Giovanni in Fiore',	'San Giovanni in Fiore',	1,	44064,	'2019-03-16 03:59:51',	'San Giovanni in Fiore',	'San Giovanni in Fiore',	'San Giovanni in Fiore'),
(2523464,	108,	2523119,	'San Giovanni di Galermo',	'San Giovanni di Galermo',	'San Giovanni di Galermo',	1,	44062,	'2019-03-16 03:59:51',	'San Giovanni di Galermo',	'San Giovanni di Galermo',	'San Giovanni di Galermo'),
(2523472,	108,	2525468,	'San Giorgio Morgeto',	'San Giorgio Morgeto',	'San Giorgio Morgeto',	1,	44055,	'2019-03-16 03:59:51',	'San Giorgio Morgeto',	'San Giorgio Morgeto',	'San Giorgio Morgeto'),
(2523482,	108,	2523228,	'San Gavino Monreale',	'San Gavino Monreale',	'San Gavino Monreale',	1,	44031,	'2019-03-16 03:59:51',	'San Gavino Monreale',	'San Gavino Monreale',	'San Gavino Monreale'),
(2523489,	108,	2525468,	'San Francesco',	'San Francesco',	'San Francesco',	1,	44025,	'2019-03-16 03:59:51',	'San Francesco',	'San Francesco',	'San Francesco'),
(2523496,	108,	2525468,	'San Filippo',	'San Filippo',	'San Filippo',	1,	44022,	'2019-03-16 03:59:51',	'San Filippo',	'San Filippo',	'San Filippo'),
(2523498,	108,	2525468,	'San Ferdinando',	'San Ferdinando',	'San Ferdinando',	1,	44016,	'2019-03-16 03:59:51',	'San Ferdinando',	'San Ferdinando',	'San Ferdinando'),
(2523504,	108,	2525468,	'San Costantino Calabro',	'San Costantino Calabro',	'San Costantino Calabro',	1,	43991,	'2019-03-16 03:59:51',	'San Costantino Calabro',	'San Costantino Calabro',	'San Costantino Calabro'),
(2523511,	108,	2523119,	'San Cipirello',	'San Cipirello',	'San Cipirello',	1,	43984,	'2019-03-16 03:59:51',	'San Cipirello',	'San Cipirello',	'San Cipirello'),
(2523513,	108,	2523119,	'San Cataldo',	'San Cataldo',	'San Cataldo',	1,	43979,	'2019-03-16 03:59:51',	'San Cataldo',	'San Cataldo',	'San Cataldo'),
(2523516,	108,	2525468,	'San Calogero',	'San Calogero',	'San Calogero',	1,	43973,	'2019-03-16 03:59:51',	'San Calogero',	'San Calogero',	'San Calogero'),
(2523523,	108,	2525468,	'San Benedetto Ullano',	'San Benedetto Ullano',	'San Benedetto Ullano',	1,	43961,	'2019-03-16 03:59:51',	'San Benedetto Ullano',	'San Benedetto Ullano',	'San Benedetto Ullano'),
(2523528,	108,	2525468,	'San Basile',	'San Basile',	'San Basile',	1,	43957,	'2019-03-16 03:59:51',	'San Basile',	'San Basile',	'San Basile'),
(2523530,	108,	2523228,	'Samugheo',	'Samugheo',	'Samugheo',	1,	43938,	'2019-03-16 03:59:51',	'Samugheo',	'Samugheo',	'Samugheo'),
(2523533,	108,	2523119,	'Sambuca di Sicilia',	'Sambuca di Sicilia',	'Sambuca di Sicilia',	1,	43918,	'2019-03-16 03:59:51',	'Sambuca di Sicilia',	'Sambuca di Sicilia',	'Sambuca di Sicilia'),
(2523537,	108,	2523228,	'Samassi',	'Samassi',	'Samassi',	1,	43909,	'2019-03-16 03:59:51',	'Samassi',	'Samassi',	'Samassi'),
(2523539,	108,	3169778,	'Salve',	'Salve',	'Salve',	1,	43888,	'2019-03-16 03:59:51',	'Salve',	'Salve',	'Salve'),
(2523547,	108,	2525468,	'Saline',	'Saline',	'Saline',	1,	43803,	'2019-03-16 03:59:51',	'Saline',	'Saline',	'Saline'),
(2523557,	108,	2523119,	'Salemi',	'Salemi',	'Salemi',	1,	43770,	'2019-03-16 03:59:51',	'Salemi',	'Salemi',	'Salemi'),
(2523565,	108,	2525468,	'Sabatino',	'Sabatino',	'Sabatino',	1,	42163,	'2019-03-16 03:59:51',	'Sabatino',	'Sabatino',	'Sabatino'),
(2523569,	108,	3169778,	'Ruffano',	'Ruffano',	'Ruffano',	1,	41965,	'2019-03-16 03:59:51',	'Ruffano',	'Ruffano',	'Ruffano'),
(2523571,	108,	2525468,	'Rovito',	'Rovito',	'Rovito',	1,	41849,	'2019-03-16 03:59:51',	'Rovito',	'Rovito',	'Rovito'),
(2523578,	108,	2525468,	'Россано',	'Rossano',	'Rossano',	1,	41673,	'2019-03-16 03:59:51',	'Rossano',	'Rossano',	'Rossano'),
(2523581,	108,	2523119,	'Rosolini',	'Rosolini',	'Rosolini',	1,	41665,	'2019-03-16 03:59:51',	'Rosolini',	'Rosolini',	'Rosolini'),
(2523583,	108,	2525468,	'Roseto Capo Spulico',	'Roseto Capo Spulico',	'Roseto Capo Spulico',	1,	41633,	'2019-03-16 03:59:51',	'Roseto Capo Spulico',	'Roseto Capo Spulico',	'Roseto Capo Spulico'),
(2523584,	108,	2525468,	'Rose',	'Rose',	'Rose',	1,	41585,	'2019-03-16 03:59:51',	'Rose',	'Rose',	'Rose'),
(2523585,	108,	2525468,	'Rosarno',	'Rosarno',	'Rosarno',	1,	41568,	'2019-03-16 03:59:51',	'Rosarno',	'Rosarno',	'Rosarno'),
(2523589,	108,	2525468,	'Rogliano',	'Rogliano',	'Rogliano',	1,	41372,	'2019-03-16 03:59:51',	'Rogliano',	'Rogliano',	'Rogliano'),
(2523591,	108,	2525468,	'Roggiano Gravina',	'Roggiano Gravina',	'Roggiano Gravina',	1,	41370,	'2019-03-16 03:59:51',	'Roggiano Gravina',	'Roggiano Gravina',	'Roggiano Gravina'),
(2523593,	108,	2525468,	'Rocco',	'Rocco',	'Rocco',	1,	41176,	'2019-03-16 03:59:51',	'Rocco',	'Rocco',	'Rocco'),
(2523595,	108,	2525468,	'Roccella Ionica',	'Roccella Ionica',	'Roccella Ionica',	1,	41174,	'2019-03-16 03:59:51',	'Roccella Ionica',	'Roccella Ionica',	'Roccella Ionica'),
(2523596,	108,	2525468,	'Roccella',	'Roccella',	'Roccella',	1,	41173,	'2019-03-16 03:59:51',	'Roccella',	'Roccella',	'Roccella'),
(2523601,	108,	2523119,	'Roccalumera',	'Roccalumera',	'Roccalumera',	1,	41167,	'2019-03-16 03:59:51',	'Roccalumera',	'Roccalumera',	'Roccalumera'),
(2523603,	108,	2525468,	'Rocca di Neto',	'Rocca di Neto',	'Rocca di Neto',	1,	41157,	'2019-03-16 03:59:51',	'Rocca di Neto',	'Rocca di Neto',	'Rocca di Neto'),
(2523604,	108,	2525468,	'Roccabernarda',	'Roccabernarda',	'Roccabernarda',	1,	41163,	'2019-03-16 03:59:51',	'Roccabernarda',	'Roccabernarda',	'Roccabernarda'),
(2523608,	108,	2525468,	'Rizziconi',	'Rizziconi',	'Rizziconi',	1,	41085,	'2019-03-16 03:59:51',	'Rizziconi',	'Rizziconi',	'Rizziconi'),
(2523609,	108,	2525468,	'Rizzi',	'Rizzi',	'Rizzi',	1,	41084,	'2019-03-16 03:59:51',	'Rizzi',	'Rizzi',	'Rizzi'),
(2523612,	108,	2523119,	'Riposto',	'Riposto',	'Riposto',	1,	40965,	'2019-03-16 03:59:51',	'Riposto',	'Riposto',	'Riposto'),
(2523613,	108,	2523228,	'Riola Sardo',	'Riola Sardo',	'Riola Sardo',	1,	40929,	'2019-03-16 03:59:51',	'Riola Sardo',	'Riola Sardo',	'Riola Sardo'),
(2523616,	108,	2523119,	'Riesi',	'Riesi',	'Riesi',	1,	40822,	'2019-03-16 03:59:51',	'Riesi',	'Riesi',	'Riesi'),
(2523618,	108,	2525468,	'Ricadi',	'Ricadi',	'Ricadi',	1,	40664,	'2019-03-16 03:59:51',	'Ricadi',	'Ricadi',	'Ricadi'),
(2523619,	108,	2523119,	'Рибера',	'Ribera',	'Ribera',	1,	40657,	'2019-03-16 03:59:51',	'Ribera',	'Ribera',	'Ribera'),
(2523623,	108,	2525468,	'Ренде',	'Rende',	'Rende',	1,	40456,	'2019-03-16 03:59:51',	'Rende',	'Rende',	'Rende'),
(2523628,	108,	2525468,	'Regina',	'Regina',	'Regina',	1,	40321,	'2019-03-16 03:59:51',	'Regina',	'Regina',	'Regina'),
(2523630,	108,	2525468,	'Реджо-ди-Калабрия',	'Reggio Calabria',	'Reggio Calabria',	1,	40318,	'2019-03-16 03:59:51',	'Reggio Calabria',	'Reggio Calabria',	'Reggio Calabria'),
(2523632,	108,	2523119,	'Regalbuto',	'Regalbuto',	'Regalbuto',	1,	40312,	'2019-03-16 03:59:51',	'Regalbuto',	'Regalbuto',	'Regalbuto'),
(2523636,	108,	2523119,	'Realmonte',	'Realmonte',	'Realmonte',	1,	40182,	'2019-03-16 03:59:51',	'Realmonte',	'Realmonte',	'Realmonte'),
(2523640,	108,	2525468,	'Ranieri',	'Ranieri',	'Ranieri',	1,	40016,	'2019-03-16 03:59:51',	'Ranieri',	'Ranieri',	'Ranieri'),
(2523641,	108,	2523119,	'Randazzo',	'Randazzo',	'Randazzo',	1,	39985,	'2019-03-16 03:59:51',	'Randazzo',	'Randazzo',	'Randazzo'),
(2523644,	108,	2523119,	'Ramacca',	'Ramacca',	'Ramacca',	1,	39922,	'2019-03-16 03:59:51',	'Ramacca',	'Ramacca',	'Ramacca'),
(2523650,	108,	2523119,	'Рагуза',	'Ragusa',	'Ragusa',	1,	39876,	'2019-03-16 03:59:51',	'Ragusa',	'Ragusa',	'Ragusa'),
(2523654,	108,	2523119,	'Raffadali',	'Raffadali',	'Raffadali',	1,	39871,	'2019-03-16 03:59:51',	'Raffadali',	'Raffadali',	'Raffadali'),
(2523656,	108,	2523119,	'Raddusa',	'Raddusa',	'Raddusa',	1,	39843,	'2019-03-16 03:59:51',	'Raddusa',	'Raddusa',	'Raddusa'),
(2523659,	108,	2523119,	'Racalmuto',	'Racalmuto',	'Racalmuto',	1,	39821,	'2019-03-16 03:59:51',	'Racalmuto',	'Racalmuto',	'Racalmuto'),
(2523660,	108,	3169778,	'Racale',	'Racale',	'Racale',	1,	39820,	'2019-03-16 03:59:51',	'Racale',	'Racale',	'Racale'),
(2523665,	108,	2523228,	'Quartu Sant\'Elena',	'Quartu Sant\'Elena',	'Quartu Sant\'Elena',	1,	39667,	'2019-03-16 03:59:51',	'Quartu Sant\'Elena',	'Quartu Sant\'Elena',	'Quartu Sant\'Elena'),
(2523666,	108,	2523228,	'Quartucciu',	'Quartucciu',	'Quartucciu',	1,	39668,	'2019-03-16 03:59:51',	'Quartucciu',	'Quartucciu',	'Quartucciu'),
(2523675,	108,	2523228,	'Pula',	'Pula',	'Pula',	1,	39537,	'2019-03-16 03:59:51',	'Pula',	'Pula',	'Pula'),
(2523678,	108,	2523119,	'Prizzi',	'Prizzi',	'Prizzi',	1,	39393,	'2019-03-16 03:59:51',	'Prizzi',	'Prizzi',	'Prizzi'),
(2523679,	108,	2523119,	'Priolo Gargallo',	'Priolo Gargallo',	'Priolo Gargallo',	1,	39382,	'2019-03-16 03:59:51',	'Priolo Gargallo',	'Priolo Gargallo',	'Priolo Gargallo'),
(2523687,	108,	2525468,	'Прая-а-Маре',	'Praia a Mare',	'Praia a Mare',	1,	39179,	'2019-03-16 03:59:51',	'Praia a Mare',	'Praia a Mare',	'Praia a Mare'),
(2523688,	108,	2523119,	'Pozzo di Gotto',	'Pozzo di Gotto',	'Pozzo di Gotto',	1,	39156,	'2019-03-16 03:59:51',	'Pozzo di Gotto',	'Pozzo di Gotto',	'Pozzo di Gotto'),
(2523693,	108,	2523119,	'Pozzallo',	'Pozzallo',	'Pozzallo',	1,	39154,	'2019-03-16 03:59:51',	'Pozzallo',	'Pozzallo',	'Pozzallo'),
(2523699,	108,	2523228,	'Portoscuso',	'Portoscuso',	'Portoscuso',	1,	38993,	'2019-03-16 03:59:51',	'Portoscuso',	'Portoscuso',	'Portoscuso'),
(2523705,	108,	2523119,	'Porto Empedocle',	'Porto Empedocle',	'Porto Empedocle',	1,	38974,	'2019-03-16 03:59:51',	'Porto Empedocle',	'Porto Empedocle',	'Porto Empedocle'),
(2523728,	108,	2523228,	'Pompu',	'Pompu',	'Pompu',	1,	38634,	'2019-03-16 03:59:51',	'Pompu',	'Pompu',	'Pompu'),
(2523734,	108,	2523119,	'Pollina',	'Pollina',	'Pollina',	1,	38560,	'2019-03-16 03:59:51',	'Pollina',	'Pollina',	'Pollina'),
(2523736,	108,	2523119,	'Polizzi Generosa',	'Polizzi Generosa',	'Polizzi Generosa',	1,	38544,	'2019-03-16 03:59:51',	'Polizzi Generosa',	'Polizzi Generosa',	'Polizzi Generosa'),
(2523738,	108,	2525468,	'Polistena',	'Polistena',	'Polistena',	1,	38542,	'2019-03-16 03:59:51',	'Polistena',	'Polistena',	'Polistena'),
(2523747,	108,	2523119,	'Poggioreale',	'Poggioreale',	'Poggioreale',	1,	38471,	'2019-03-16 03:59:51',	'Poggioreale',	'Poggioreale',	'Poggioreale'),
(2523750,	108,	2525468,	'Platania',	'Platania',	'Platania',	1,	38202,	'2019-03-16 03:59:51',	'Platania',	'Platania',	'Platania'),
(2523762,	108,	2525468,	'Pizzo',	'Pizzo',	'Pizzo',	1,	38125,	'2019-03-16 03:59:51',	'Pizzo',	'Pizzo',	'Pizzo'),
(2523771,	108,	2523228,	'Pirri',	'Pirri',	'Pirri',	1,	38060,	'2019-03-16 03:59:51',	'Pirri',	'Pirri',	'Pirri'),
(2523773,	108,	2523119,	'Piraino',	'Piraino',	'Piraino',	1,	38049,	'2019-03-16 03:59:51',	'Piraino',	'Piraino',	'Piraino'),
(2523778,	108,	2523228,	'Pimentel',	'Pimentel',	'Pimentel',	1,	37919,	'2019-03-16 03:59:51',	'Pimentel',	'Pimentel',	'Pimentel'),
(2523784,	108,	2523119,	'Pietraperzia',	'Pietraperzia',	'Pietraperzia',	1,	37857,	'2019-03-16 03:59:51',	'Pietraperzia',	'Pietraperzia',	'Pietraperzia'),
(2523793,	108,	2523119,	'Piedimonte Etneo',	'Piedimonte Etneo',	'Piedimonte Etneo',	1,	37792,	'2019-03-16 03:59:51',	'Piedimonte Etneo',	'Piedimonte Etneo',	'Piedimonte Etneo'),
(2523796,	108,	2523119,	'Piazza Armerina',	'Piazza Armerina',	'Piazza Armerina',	1,	37770,	'2019-03-16 03:59:51',	'Piazza Armerina',	'Piazza Armerina',	'Piazza Armerina'),
(2523799,	108,	2525468,	'Pianopoli',	'Pianopoli',	'Pianopoli',	1,	37760,	'2019-03-16 03:59:51',	'Pianopoli',	'Pianopoli',	'Pianopoli'),
(2523806,	108,	2525468,	'Piane Crati',	'Piane Crati',	'Piane Crati',	1,	37751,	'2019-03-16 03:59:51',	'Piane Crati',	'Piane Crati',	'Piane Crati'),
(2523808,	108,	2523119,	'Piana degli Albanesi',	'Piana degli Albanesi',	'Piana degli Albanesi',	1,	37748,	'2019-03-16 03:59:51',	'Piana degli Albanesi',	'Piana degli Albanesi',	'Piana degli Albanesi'),
(2523816,	108,	2523119,	'Petrosino',	'Petrosino',	'Petrosino',	1,	37620,	'2019-03-16 03:59:51',	'Petrosino',	'Petrosino',	'Petrosino'),
(2523817,	108,	2525468,	'Petrona',	'Petrona',	'Petrona',	1,	37617,	'2019-03-16 03:59:51',	'Petrona',	'Petrona',	'Petrona'),
(2523821,	108,	2523119,	'Petralia Sottana',	'Petralia Sottana',	'Petralia Sottana',	1,	37610,	'2019-03-16 03:59:51',	'Petralia Sottana',	'Petralia Sottana',	'Petralia Sottana'),
(2523825,	108,	2525468,	'Petilia Policastro',	'Petilia Policastro',	'Petilia Policastro',	1,	37594,	'2019-03-16 03:59:51',	'Petilia Policastro',	'Petilia Policastro',	'Petilia Policastro'),
(2523838,	108,	2525468,	'Pentone',	'Pentone',	'Pentone',	1,	37374,	'2019-03-16 03:59:51',	'Pentone',	'Pentone',	'Pentone'),
(2523850,	108,	2523119,	'Pedara',	'Pedara',	'Pedara',	1,	37211,	'2019-03-16 03:59:51',	'Pedara',	'Pedara',	'Pedara'),
(2523853,	108,	2525468,	'Pedace',	'Pedace',	'Pedace',	1,	37209,	'2019-03-16 03:59:51',	'Pedace',	'Pedace',	'Pedace'),
(2523861,	108,	2523228,	'Pau',	'Pau',	'Pau',	1,	37083,	'2019-03-16 03:59:51',	'Pau',	'Pau',	'Pau'),
(2523864,	108,	2523119,	'Patti',	'Patti',	'Patti',	1,	37077,	'2019-03-16 03:59:51',	'Patti',	'Patti',	'Patti'),
(2523866,	108,	2523119,	'Патерно',	'Paterno',	'Paterno',	1,	37050,	'2019-03-16 03:59:51',	'Paterno',	'Paterno',	'Paterno'),
(2523871,	108,	2523119,	'Partinico',	'Partinico',	'Partinico',	1,	36998,	'2019-03-16 03:59:51',	'Partinico',	'Partinico',	'Partinico'),
(2523872,	108,	2523119,	'Partanna',	'Partanna',	'Partanna',	1,	36992,	'2019-03-16 03:59:51',	'Partanna',	'Partanna',	'Partanna'),
(2523876,	108,	2525468,	'Parghelia',	'Parghelia',	'Parghelia',	1,	36903,	'2019-03-16 03:59:51',	'Parghelia',	'Parghelia',	'Parghelia'),
(2523888,	108,	2525468,	'Paola',	'Paola',	'Paola',	1,	36845,	'2019-03-16 03:59:51',	'Paola',	'Paola',	'Paola'),
(2523890,	108,	2523119,	'Pantelleria',	'Pantelleria',	'Pantelleria',	1,	36840,	'2019-03-16 03:59:51',	'Pantelleria',	'Pantelleria',	'Pantelleria'),
(2523896,	108,	2525468,	'Panettieri',	'Panettieri',	'Panettieri',	1,	36819,	'2019-03-16 03:59:51',	'Panettieri',	'Panettieri',	'Panettieri'),
(2523902,	108,	2525468,	'Palmi',	'Palmi',	'Palmi',	1,	36759,	'2019-03-16 03:59:51',	'Palmi',	'Palmi',	'Palmi'),
(2523908,	108,	2523119,	'Palma di Montechiaro',	'Palma di Montechiaro',	'Palma di Montechiaro',	1,	36740,	'2019-03-16 03:59:51',	'Palma di Montechiaro',	'Palma di Montechiaro',	'Palma di Montechiaro'),
(2523911,	108,	2525468,	'Palizzi Marina',	'Palizzi Marina',	'Palizzi Marina',	1,	36715,	'2019-03-16 03:59:51',	'Palizzi Marina',	'Palizzi Marina',	'Palizzi Marina'),
(2523920,	108,	2523119,	'Палермо',	'Palermo',	'Palermo',	1,	36702,	'2019-03-16 03:59:51',	'Palermo',	'Palermo',	'Palermo'),
(2523921,	108,	2525468,	'Palermiti',	'Palermiti',	'Palermiti',	1,	36700,	'2019-03-16 03:59:51',	'Palermiti',	'Palermiti',	'Palermiti'),
(2523922,	108,	2523119,	'Palazzolo Acreide',	'Palazzolo Acreide',	'Palazzolo Acreide',	1,	36694,	'2019-03-16 03:59:51',	'Palazzolo Acreide',	'Palazzolo Acreide',	'Palazzolo Acreide'),
(2523927,	108,	2523119,	'Palagonia',	'Palagonia',	'Palagonia',	1,	36668,	'2019-03-16 03:59:51',	'Palagonia',	'Palagonia',	'Palagonia'),
(2523932,	108,	2523119,	'Pagliara',	'Pagliara',	'Pagliara',	1,	36619,	'2019-03-16 03:59:51',	'Pagliara',	'Pagliara',	'Pagliara'),
(2523938,	108,	2523119,	'Пакино',	'Pachino',	'Pachino',	1,	36573,	'2019-03-16 03:59:51',	'Pachino',	'Pachino',	'Pachino'),
(2523942,	108,	2523119,	'Paceco',	'Paceco',	'Paceco',	1,	36572,	'2019-03-16 03:59:51',	'Paceco',	'Paceco',	'Paceco'),
(2523943,	108,	2523228,	'Pabillonis',	'Pabillonis',	'Pabillonis',	1,	36566,	'2019-03-16 03:59:51',	'Pabillonis',	'Pabillonis',	'Pabillonis'),
(2523964,	108,	2523228,	'Ористано',	'Oristano',	'Oristano',	1,	36117,	'2019-03-16 03:59:51',	'Oristano',	'Oristano',	'Oristano'),
(2523974,	108,	2523119,	'Olivarella',	'Olivarella',	'Olivarella',	1,	35839,	'2019-03-16 03:59:51',	'Olivarella',	'Olivarella',	'Olivarella'),
(2523977,	108,	2525468,	'Oliva',	'Oliva',	'Oliva',	1,	35835,	'2019-03-16 03:59:51',	'Oliva',	'Oliva',	'Oliva'),
(2523983,	108,	2523228,	'Nuxis',	'Nuxis',	'Nuxis',	1,	35271,	'2019-03-16 03:59:51',	'Nuxis',	'Nuxis',	'Nuxis'),
(2523987,	108,	2523228,	'Nuraminis',	'Nuraminis',	'Nuraminis',	1,	35256,	'2019-03-16 03:59:51',	'Nuraminis',	'Nuraminis',	'Nuraminis'),
(2523988,	108,	2523228,	'Nurallao',	'Nurallao',	'Nurallao',	1,	35255,	'2019-03-16 03:59:51',	'Nurallao',	'Nurallao',	'Nurallao'),
(2523990,	108,	2523228,	'Nurachi',	'Nurachi',	'Nurachi',	1,	35254,	'2019-03-16 03:59:51',	'Nurachi',	'Nurachi',	'Nurachi'),
(2523998,	108,	2523119,	'Ното',	'Noto',	'Noto',	1,	35100,	'2019-03-16 03:59:51',	'Noto',	'Noto',	'Noto'),
(2524000,	108,	2525468,	'Nocera Terinese',	'Nocera Terinese',	'Nocera Terinese',	1,	34699,	'2019-03-16 03:59:51',	'Nocera Terinese',	'Nocera Terinese',	'Nocera Terinese'),
(2524004,	108,	2523119,	'Nissoria',	'Nissoria',	'Nissoria',	1,	34656,	'2019-03-16 03:59:51',	'Nissoria',	'Nissoria',	'Nissoria'),
(2524006,	108,	2523119,	'Нишеми',	'Niscemi',	'Niscemi',	1,	34654,	'2019-03-16 03:59:51',	'Niscemi',	'Niscemi',	'Niscemi'),
(2524008,	108,	2525468,	'Nicotera',	'Nicotera',	'Nicotera',	1,	34509,	'2019-03-16 03:59:51',	'Nicotera',	'Nicotera',	'Nicotera'),
(2524009,	108,	2523119,	'Nicosia',	'Nicosia',	'Nicosia',	1,	34508,	'2019-03-16 03:59:51',	'Nicosia',	'Nicosia',	'Nicosia'),
(2524010,	108,	2523119,	'Николози',	'Nicolosi',	'Nicolosi',	1,	34507,	'2019-03-16 03:59:51',	'Nicolosi',	'Nicolosi',	'Nicolosi'),
(2524013,	108,	2525468,	'Никастро',	'Nicastro',	'Nicastro',	1,	34488,	'2019-03-16 03:59:51',	'Nicastro',	'Nicastro',	'Nicastro'),
(2524022,	108,	2523119,	'Naro',	'Naro',	'Naro',	1,	33576,	'2019-03-16 03:59:51',	'Naro',	'Naro',	'Naro'),
(2524024,	108,	2523228,	'Narcao',	'Narcao',	'Narcao',	1,	33570,	'2019-03-16 03:59:51',	'Narcao',	'Narcao',	'Narcao'),
(2524028,	108,	2523119,	'Mussomeli',	'Mussomeli',	'Mussomeli',	1,	33411,	'2019-03-16 03:59:51',	'Mussomeli',	'Mussomeli',	'Mussomeli'),
(2524029,	108,	2523228,	'Musei',	'Musei',	'Musei',	1,	33400,	'2019-03-16 03:59:51',	'Musei',	'Musei',	'Musei'),
(2524033,	108,	2523228,	'Muravera',	'Muravera',	'Muravera',	1,	33340,	'2019-03-16 03:59:51',	'Muravera',	'Muravera',	'Muravera'),
(2524041,	108,	2523119,	'Motta Sant\'Anastasia',	'Motta Sant\'Anastasia',	'Motta Sant\'Anastasia',	1,	32952,	'2019-03-16 03:59:51',	'Motta Sant\'Anastasia',	'Motta Sant\'Anastasia',	'Motta Sant\'Anastasia'),
(2524043,	108,	2525468,	'Motta San Giovanni',	'Motta San Giovanni',	'Motta San Giovanni',	1,	32951,	'2019-03-16 03:59:51',	'Motta San Giovanni',	'Motta San Giovanni',	'Motta San Giovanni'),
(2524044,	108,	2525468,	'Mottafollone',	'Mottafollone',	'Mottafollone',	1,	32954,	'2019-03-16 03:59:51',	'Mottafollone',	'Mottafollone',	'Mottafollone'),
(2524055,	108,	3169778,	'Morciano di Leuca',	'Morciano di Leuca',	'Morciano di Leuca',	1,	32720,	'2019-03-16 03:59:51',	'Morciano di Leuca',	'Morciano di Leuca',	'Morciano di Leuca'),
(2524061,	108,	2523119,	'Montevago',	'Montevago',	'Montevago',	1,	32370,	'2019-03-16 03:59:51',	'Montevago',	'Montevago',	'Montevago'),
(2524067,	108,	2525468,	'Montepaone',	'Montepaone',	'Montepaone',	1,	32321,	'2019-03-16 03:59:51',	'Montepaone',	'Montepaone',	'Montepaone'),
(2524070,	108,	2523119,	'Montelepre',	'Montelepre',	'Montelepre',	1,	32301,	'2019-03-16 03:59:51',	'Montelepre',	'Montelepre',	'Montelepre'),
(2524071,	108,	2523119,	'Montedoro',	'Montedoro',	'Montedoro',	1,	32269,	'2019-03-16 03:59:51',	'Montedoro',	'Montedoro',	'Montedoro'),
(2524074,	108,	2525468,	'Montauro',	'Montauro',	'Montauro',	1,	32167,	'2019-03-16 03:59:51',	'Montauro',	'Montauro',	'Montauro'),
(2524076,	108,	2525468,	'Montalto Uffugo',	'Montalto Uffugo',	'Montalto Uffugo',	1,	32136,	'2019-03-16 03:59:51',	'Montalto Uffugo',	'Montalto Uffugo',	'Montalto Uffugo'),
(2524080,	108,	2523119,	'Montagnareale',	'Montagnareale',	'Montagnareale',	1,	32104,	'2019-03-16 03:59:51',	'Montagnareale',	'Montagnareale',	'Montagnareale'),
(2524084,	108,	2523228,	'Monserrato',	'Monserrato',	'Monserrato',	1,	32068,	'2019-03-16 03:59:51',	'Monserrato',	'Monserrato',	'Monserrato'),
(2524085,	108,	2523119,	'Монреаль',	'Monreale',	'Monreale',	1,	32021,	'2019-03-16 03:59:51',	'Monreale',	'Monreale',	'Monreale'),
(2524093,	108,	2523119,	'Monforte San Giorgio',	'Monforte San Giorgio',	'Monforte San Giorgio',	1,	31982,	'2019-03-16 03:59:51',	'Monforte San Giorgio',	'Monforte San Giorgio',	'Monforte San Giorgio'),
(2524096,	108,	2523228,	'Monastir',	'Monastir',	'Monastir',	1,	31905,	'2019-03-16 03:59:51',	'Monastir',	'Monastir',	'Monastir'),
(2524097,	108,	2525468,	'Monasterace',	'Monasterace',	'Monasterace',	1,	31902,	'2019-03-16 03:59:51',	'Monasterace',	'Monasterace',	'Monasterace'),
(2524100,	108,	2525468,	'Molochio',	'Molochio',	'Molochio',	1,	31876,	'2019-03-16 03:59:51',	'Molochio',	'Molochio',	'Molochio'),
(2524108,	108,	2525468,	'Molinari',	'Molinari',	'Molinari',	1,	31855,	'2019-03-16 03:59:51',	'Molinari',	'Molinari',	'Molinari'),
(2524114,	108,	2523119,	'Moio Alcantara',	'Moio Alcantara',	'Moio Alcantara',	1,	31809,	'2019-03-16 03:59:51',	'Moio Alcantara',	'Moio Alcantara',	'Moio Alcantara'),
(2524116,	108,	2523228,	'Mogoro',	'Mogoro',	'Mogoro',	1,	31785,	'2019-03-16 03:59:51',	'Mogoro',	'Mogoro',	'Mogoro'),
(2524119,	108,	2523119,	'Модика',	'Modica',	'Modica',	1,	31761,	'2019-03-16 03:59:51',	'Modica',	'Modica',	'Modica'),
(2524122,	108,	2523119,	'Mistretta',	'Mistretta',	'Mistretta',	1,	31702,	'2019-03-16 03:59:51',	'Mistretta',	'Mistretta',	'Mistretta'),
(2524123,	108,	2523119,	'Misterbianco',	'Misterbianco',	'Misterbianco',	1,	31701,	'2019-03-16 03:59:51',	'Misterbianco',	'Misterbianco',	'Misterbianco'),
(2524126,	108,	2523119,	'Misilmeri',	'Misilmeri',	'Misilmeri',	1,	31678,	'2019-03-16 03:59:51',	'Misilmeri',	'Misilmeri',	'Misilmeri'),
(2524135,	108,	2523119,	'Mirabella Imbaccari',	'Mirabella Imbaccari',	'Mirabella Imbaccari',	1,	31620,	'2019-03-16 03:59:51',	'Mirabella Imbaccari',	'Mirabella Imbaccari',	'Mirabella Imbaccari'),
(2524142,	108,	2523119,	'Mineo',	'Mineo',	'Mineo',	1,	31542,	'2019-03-16 03:59:51',	'Mineo',	'Mineo',	'Mineo'),
(2524144,	108,	2523119,	'Militello Rosmarino',	'Militello Rosmarino',	'Militello Rosmarino',	1,	31385,	'2019-03-16 03:59:51',	'Militello Rosmarino',	'Militello Rosmarino',	'Militello Rosmarino'),
(2524145,	108,	2523119,	'Militello in Val di Catania',	'Militello in Val di Catania',	'Militello in Val di Catania',	1,	31384,	'2019-03-16 03:59:51',	'Militello in Val di Catania',	'Militello in Val di Catania',	'Militello in Val di Catania'),
(2524150,	108,	2523119,	'Milici',	'Milici',	'Milici',	1,	31381,	'2019-03-16 03:59:51',	'Milici',	'Milici',	'Milici'),
(2524151,	108,	2525468,	'Mileto',	'Mileto',	'Mileto',	1,	31356,	'2019-03-16 03:59:51',	'Mileto',	'Mileto',	'Mileto'),
(2524152,	108,	2523119,	'Milena',	'Milena',	'Milena',	1,	31353,	'2019-03-16 03:59:51',	'Milena',	'Milena',	'Milena'),
(2524155,	108,	2523119,	'Милаццо',	'Milazzo',	'Milazzo',	1,	31345,	'2019-03-16 03:59:51',	'Milazzo',	'Milazzo',	'Milazzo'),
(2524156,	108,	2525468,	'Milanesi',	'Milanesi',	'Milanesi',	1,	31338,	'2019-03-16 03:59:51',	'Milanesi',	'Milanesi',	'Milanesi'),
(2524160,	108,	3169778,	'Miggiano',	'Miggiano',	'Miggiano',	1,	31307,	'2019-03-16 03:59:51',	'Miggiano',	'Miggiano',	'Miggiano'),
(2524170,	108,	2523119,	'Мессина',	'Messina',	'Messina',	1,	31059,	'2019-03-16 03:59:51',	'Messina',	'Messina',	'Messina'),
(2524179,	108,	2523119,	'Menfi',	'Menfi',	'Menfi',	1,	30818,	'2019-03-16 03:59:51',	'Menfi',	'Menfi',	'Menfi'),
(2524180,	108,	2525468,	'Mendicino',	'Mendicino',	'Mendicino',	1,	30796,	'2019-03-16 03:59:51',	'Mendicino',	'Mendicino',	'Mendicino'),
(2524181,	108,	2525468,	'Melito di Porto Salvo',	'Melito di Porto Salvo',	'Melito di Porto Salvo',	1,	30727,	'2019-03-16 03:59:51',	'Melito di Porto Salvo',	'Melito di Porto Salvo',	'Melito di Porto Salvo'),
(2524184,	108,	3169778,	'Melissano',	'Melissano',	'Melissano',	1,	30726,	'2019-03-16 03:59:51',	'Melissano',	'Melissano',	'Melissano'),
(2524186,	108,	2523119,	'Melilli',	'Melilli',	'Melilli',	1,	30723,	'2019-03-16 03:59:51',	'Melilli',	'Melilli',	'Melilli'),
(2524188,	108,	2525468,	'Melicucco',	'Melicucco',	'Melicucco',	1,	30718,	'2019-03-16 03:59:51',	'Melicucco',	'Melicucco',	'Melicucco'),
(2524197,	108,	2523228,	'Meana Sardo',	'Meana Sardo',	'Meana Sardo',	1,	30539,	'2019-03-16 03:59:51',	'Meana Sardo',	'Meana Sardo',	'Meana Sardo'),
(2524200,	108,	2523119,	'Mazzarino',	'Mazzarino',	'Mazzarino',	1,	30450,	'2019-03-16 03:59:51',	'Mazzarino',	'Mazzarino',	'Mazzarino'),
(2524205,	108,	2523119,	'Mazara del Vallo',	'Mazara del Vallo',	'Mazara del Vallo',	1,	30427,	'2019-03-16 03:59:51',	'Mazara del Vallo',	'Mazara del Vallo',	'Mazara del Vallo'),
(2524207,	108,	2525468,	'Mauro',	'Mauro',	'Mauro',	1,	30337,	'2019-03-16 03:59:51',	'Mauro',	'Mauro',	'Mauro'),
(2524208,	108,	2523228,	'Maracalagonis',	'Maracalagonis',	'Maracalagonis',	1,	29605,	'2019-03-16 03:59:51',	'Maracalagonis',	'Maracalagonis',	'Maracalagonis'),
(2524209,	108,	2523228,	'Masullas',	'Masullas',	'Masullas',	1,	30238,	'2019-03-16 03:59:51',	'Masullas',	'Masullas',	'Masullas'),
(2524234,	108,	3182306,	'Massa',	'Massa',	'Massa',	1,	30201,	'2019-03-16 03:59:51',	'Massa',	'Massa',	'Massa'),
(2524236,	108,	2523119,	'Маскалуча',	'Mascalucia',	'Mascalucia',	1,	30161,	'2019-03-16 03:59:51',	'Mascalucia',	'Mascalucia',	'Mascalucia'),
(2524237,	108,	2523119,	'Mascali',	'Mascali',	'Mascali',	1,	30160,	'2019-03-16 03:59:51',	'Mascali',	'Mascali',	'Mascali'),
(2524238,	108,	2523228,	'Masainas',	'Masainas',	'Masainas',	1,	30158,	'2019-03-16 03:59:51',	'Masainas',	'Masainas',	'Masainas'),
(2524242,	108,	2525468,	'Martirano Lombardo',	'Martirano Lombardo',	'Martirano Lombardo',	1,	30113,	'2019-03-16 03:59:51',	'Martirano Lombardo',	'Martirano Lombardo',	'Martirano Lombardo'),
(2524245,	108,	2523119,	'Марсала',	'Marsala',	'Marsala',	1,	30018,	'2019-03-16 03:59:51',	'Marsala',	'Marsala',	'Marsala'),
(2524246,	108,	2523228,	'Marrubiu',	'Marrubiu',	'Marrubiu',	1,	30006,	'2019-03-16 03:59:51',	'Marrubiu',	'Marrubiu',	'Marrubiu'),
(2524255,	108,	2523119,	'Marineo',	'Marineo',	'Marineo',	1,	29826,	'2019-03-16 03:59:51',	'Marineo',	'Marineo',	'Marineo'),
(2524266,	108,	2525468,	'Marina di Gioiosa Ionica',	'Marina di Gioiosa Ionica',	'Marina di Gioiosa Ionica',	1,	29820,	'2019-03-16 03:59:51',	'Marina di Gioiosa Ionica',	'Marina di Gioiosa Ionica',	'Marina di Gioiosa Ionica'),
(2524272,	108,	2525468,	'Marina',	'Marina',	'Marina',	1,	29813,	'2019-03-16 03:59:51',	'Marina',	'Marina',	'Marina'),
(2524287,	108,	3182306,	'Maratea',	'Maratea',	'Maratea',	1,	29618,	'2019-03-16 03:59:51',	'Maratea',	'Maratea',	'Maratea'),
(2524306,	108,	2523228,	'Mandas',	'Mandas',	'Mandas',	1,	29439,	'2019-03-16 03:59:51',	'Mandas',	'Mandas',	'Mandas'),
(2524311,	108,	2525468,	'Mammola',	'Mammola',	'Mammola',	1,	29395,	'2019-03-16 03:59:51',	'Mammola',	'Mammola',	'Mammola'),
(2524321,	108,	2523119,	'Malfa',	'Malfa',	'Malfa',	1,	29326,	'2019-03-16 03:59:51',	'Malfa',	'Malfa',	'Malfa'),
(2524322,	108,	2523119,	'Maletto',	'Maletto',	'Maletto',	1,	29324,	'2019-03-16 03:59:51',	'Maletto',	'Maletto',	'Maletto'),
(2524328,	108,	2525468,	'Maierato',	'Maierato',	'Maierato',	1,	29199,	'2019-03-16 03:59:51',	'Maierato',	'Maierato',	'Maierato'),
(2524331,	108,	2525468,	'Maida',	'Maida',	'Maida',	1,	29189,	'2019-03-16 03:59:51',	'Maida',	'Maida',	'Maida'),
(2524352,	108,	2525468,	'Luzzi',	'Luzzi',	'Luzzi',	1,	28916,	'2019-03-16 03:59:51',	'Luzzi',	'Luzzi',	'Luzzi'),
(2524356,	108,	2525468,	'Lungro',	'Lungro',	'Lungro',	1,	28826,	'2019-03-16 03:59:51',	'Lungro',	'Lungro',	'Lungro'),
(2524357,	108,	2523228,	'Lunamatrona',	'Lunamatrona',	'Lunamatrona',	1,	28812,	'2019-03-16 03:59:51',	'Lunamatrona',	'Lunamatrona',	'Lunamatrona'),
(2524361,	108,	2523119,	'Lucca Sicula',	'Lucca Sicula',	'Lucca Sicula',	1,	28700,	'2019-03-16 03:59:51',	'Lucca Sicula',	'Lucca Sicula',	'Lucca Sicula'),
(2524372,	108,	2523228,	'Loceri',	'Loceri',	'Loceri',	1,	28145,	'2019-03-16 03:59:51',	'Loceri',	'Loceri',	'Loceri'),
(2524379,	108,	2523119,	'Lipari',	'Lipari',	'Lipari',	1,	27914,	'2019-03-16 03:59:51',	'Lipari',	'Lipari',	'Lipari'),
(2524388,	108,	2525468,	'Limbadi',	'Limbadi',	'Limbadi',	1,	27756,	'2019-03-16 03:59:51',	'Limbadi',	'Limbadi',	'Limbadi'),
(2524391,	108,	2523119,	'Lido di Mondello',	'Lido di Mondello',	'Lido di Mondello',	1,	27674,	'2019-03-16 03:59:51',	'Lido di Mondello',	'Lido di Mondello',	'Lido di Mondello'),
(2524393,	108,	2523119,	'Licata',	'Licata',	'Licata',	1,	27649,	'2019-03-16 03:59:51',	'Licata',	'Licata',	'Licata'),
(2524394,	108,	2523119,	'Librizzi',	'Librizzi',	'Librizzi',	1,	27648,	'2019-03-16 03:59:51',	'Librizzi',	'Librizzi',	'Librizzi'),
(2524402,	108,	2523119,	'Lercara Friddi',	'Lercara Friddi',	'Lercara Friddi',	1,	27284,	'2019-03-16 03:59:51',	'Lercara Friddi',	'Lercara Friddi',	'Lercara Friddi'),
(2524404,	108,	2523119,	'Leonforte',	'Leonforte',	'Leonforte',	1,	27268,	'2019-03-16 03:59:51',	'Leonforte',	'Leonforte',	'Leonforte'),
(2524410,	108,	2523119,	'Лентини',	'Lentini',	'Lentini',	1,	27238,	'2019-03-16 03:59:51',	'Lentini',	'Lentini',	'Lentini'),
(2524417,	108,	2525468,	'Le Castella',	'Le Castella',	'Le Castella',	1,	26691,	'2019-03-16 03:59:51',	'Le Castella',	'Le Castella',	'Le Castella'),
(2524421,	108,	2525468,	'Lazzaro',	'Lazzaro',	'Lazzaro',	1,	26645,	'2019-03-16 03:59:51',	'Lazzaro',	'Lazzaro',	'Lazzaro'),
(2524431,	108,	2525468,	'Lattarico',	'Lattarico',	'Lattarico',	1,	26463,	'2019-03-16 03:59:51',	'Lattarico',	'Lattarico',	'Lattarico'),
(2524438,	108,	2523119,	'Lascari',	'Lascari',	'Lascari',	1,	26415,	'2019-03-16 03:59:51',	'Lascari',	'Lascari',	'Lascari'),
(2524459,	108,	2523119,	'Lampedusa',	'Lampedusa',	'Lampedusa',	1,	26088,	'2019-03-16 03:59:51',	'Lampedusa',	'Lampedusa',	'Lampedusa'),
(2524470,	108,	2525468,	'Laganadi',	'Laganadi',	'Laganadi',	1,	25818,	'2019-03-16 03:59:51',	'Laganadi',	'Laganadi',	'Laganadi'),
(2524481,	108,	2525468,	'La Certosa',	'La Certosa',	'La Certosa',	1,	25211,	'2019-03-16 03:59:51',	'La Certosa',	'La Certosa',	'La Certosa'),
(2524492,	108,	2523119,	'Itala',	'Itala',	'Itala',	1,	23160,	'2019-03-16 03:59:51',	'Itala',	'Itala',	'Itala'),
(2524493,	108,	2523119,	'Ispica',	'Ispica',	'Ispica',	1,	23137,	'2019-03-16 03:59:51',	'Ispica',	'Ispica',	'Ispica'),
(2524494,	108,	2523119,	'Isola delle Femmine',	'Isola delle Femmine',	'Isola delle Femmine',	1,	23127,	'2019-03-16 03:59:51',	'Isola delle Femmine',	'Isola delle Femmine',	'Isola delle Femmine'),
(2524495,	108,	2525468,	'Isola di Capo Rizzuto',	'Isola di Capo Rizzuto',	'Isola di Capo Rizzuto',	1,	23128,	'2019-03-16 03:59:51',	'Isola di Capo Rizzuto',	'Isola di Capo Rizzuto',	'Isola di Capo Rizzuto'),
(2524498,	108,	2523228,	'Isili',	'Isili',	'Isili',	1,	23080,	'2019-03-16 03:59:51',	'Isili',	'Isili',	'Isili'),
(2524506,	108,	2523119,	'Joppolo Giancaxio',	'Joppolo Giancaxio',	'Joppolo Giancaxio',	1,	23606,	'2019-03-16 03:59:51',	'Joppolo Giancaxio',	'Joppolo Giancaxio',	'Joppolo Giancaxio'),
(2524533,	108,	2523228,	'Иглезиас',	'Iglesias',	'Iglesias',	1,	22744,	'2019-03-16 03:59:51',	'Iglesias',	'Iglesias',	'Iglesias'),
(2524534,	108,	2523228,	'Jerzu',	'Jerzu',	'Jerzu',	1,	23481,	'2019-03-16 03:59:51',	'Jerzu',	'Jerzu',	'Jerzu'),
(2524546,	108,	2523228,	'Guspini',	'Guspini',	'Guspini',	1,	20226,	'2019-03-16 03:59:51',	'Guspini',	'Guspini',	'Guspini'),
(2524549,	108,	2525468,	'Guido',	'Guido',	'Guido',	1,	20112,	'2019-03-16 03:59:51',	'Guido',	'Guido',	'Guido'),
(2524551,	108,	2523228,	'Guasila',	'Guasila',	'Guasila',	1,	20042,	'2019-03-16 03:59:51',	'Guasila',	'Guasila',	'Guasila'),
(2524553,	108,	2525468,	'Aprigliano',	'Aprigliano',	'Aprigliano',	1,	1682,	'2019-03-16 03:59:51',	'Aprigliano',	'Aprigliano',	'Aprigliano'),
(2524557,	108,	2525468,	'Guardavalle',	'Guardavalle',	'Guardavalle',	1,	20035,	'2019-03-16 03:59:51',	'Guardavalle',	'Guardavalle',	'Guardavalle'),
(2524566,	108,	2525468,	'Grimaldi',	'Grimaldi',	'Grimaldi',	1,	19808,	'2019-03-16 03:59:51',	'Grimaldi',	'Grimaldi',	'Grimaldi'),
(2524583,	108,	2523119,	'Grammichele',	'Grammichele',	'Grammichele',	1,	19322,	'2019-03-16 03:59:51',	'Grammichele',	'Grammichele',	'Grammichele'),
(2524586,	108,	2523228,	'Gonnosno',	'Gonnosno',	'Gonnosno',	1,	19061,	'2019-03-16 03:59:51',	'Gonnosno',	'Gonnosno',	'Gonnosno'),
(2524587,	108,	2523228,	'Gonnosfanadiga',	'Gonnosfanadiga',	'Gonnosfanadiga',	1,	19060,	'2019-03-16 03:59:51',	'Gonnosfanadiga',	'Gonnosfanadiga',	'Gonnosfanadiga'),
(2524589,	108,	2523228,	'Gonnesa',	'Gonnesa',	'Gonnesa',	1,	19056,	'2019-03-16 03:59:51',	'Gonnesa',	'Gonnesa',	'Gonnesa'),
(2524597,	108,	3169778,	'Giuliano',	'Giuliano',	'Giuliano',	1,	18736,	'2019-03-16 03:59:51',	'Giuliano',	'Giuliano',	'Giuliano'),
(2524598,	108,	2523119,	'Giuliana',	'Giuliana',	'Giuliana',	1,	18735,	'2019-03-16 03:59:51',	'Giuliana',	'Giuliana',	'Giuliana'),
(2524600,	108,	2525468,	'Girifalco',	'Girifalco',	'Girifalco',	1,	18716,	'2019-03-16 03:59:51',	'Girifalco',	'Girifalco',	'Girifalco'),
(2524602,	108,	2523228,	'Girasole',	'Girasole',	'Girasole',	1,	18710,	'2019-03-16 03:59:51',	'Girasole',	'Girasole',	'Girasole'),
(2524604,	108,	2523119,	'Gioiosa Marea',	'Gioiosa Marea',	'Gioiosa Marea',	1,	18700,	'2019-03-16 03:59:51',	'Gioiosa Marea',	'Gioiosa Marea',	'Gioiosa Marea'),
(2524605,	108,	2525468,	'Gioiosa Ionica',	'Gioiosa Ionica',	'Gioiosa Ionica',	1,	18699,	'2019-03-16 03:59:51',	'Gioiosa Ionica',	'Gioiosa Ionica',	'Gioiosa Ionica'),
(2524606,	108,	2525468,	'Gioia Tauro',	'Gioia Tauro',	'Gioia Tauro',	1,	18698,	'2019-03-16 03:59:51',	'Gioia Tauro',	'Gioia Tauro',	'Gioia Tauro'),
(2524608,	108,	2525468,	'Gioia',	'Gioia',	'Gioia',	1,	18694,	'2019-03-16 03:59:51',	'Gioia',	'Gioia',	'Gioia'),
(2524610,	108,	2525468,	'Gimigliano',	'Gimigliano',	'Gimigliano',	1,	18678,	'2019-03-16 03:59:51',	'Gimigliano',	'Gimigliano',	'Gimigliano'),
(2524614,	108,	2523119,	'Gibellina',	'Gibellina',	'Gibellina',	1,	18580,	'2019-03-16 03:59:51',	'Gibellina',	'Gibellina',	'Gibellina'),
(2524618,	108,	2523119,	'Джарре',	'Giarre',	'Giarre',	1,	18570,	'2019-03-16 03:59:51',	'Giarre',	'Giarre',	'Giarre'),
(2524622,	108,	2523119,	'Giardini-Naxos',	'Giardini-Naxos',	'Giardini-Naxos',	1,	18569,	'2019-03-16 03:59:51',	'Giardini-Naxos',	'Giardini-Naxos',	'Giardini-Naxos'),
(2524624,	108,	2523119,	'Giardinello',	'Giardinello',	'Giardinello',	1,	18567,	'2019-03-16 03:59:51',	'Giardinello',	'Giardinello',	'Giardinello'),
(2524636,	108,	2523228,	'Gergei',	'Gergei',	'Gergei',	1,	18452,	'2019-03-16 03:59:51',	'Gergei',	'Gergei',	'Gergei'),
(2524643,	108,	2525468,	'Gerace',	'Gerace',	'Gerace',	1,	18429,	'2019-03-16 03:59:51',	'Gerace',	'Gerace',	'Gerace'),
(2524650,	108,	3169778,	'Gemini',	'Gemini',	'Gemini',	1,	18325,	'2019-03-16 03:59:51',	'Gemini',	'Gemini',	'Gemini'),
(2524653,	108,	2523119,	'Gela',	'Gela',	'Gela',	1,	18303,	'2019-03-16 03:59:51',	'Gela',	'Gela',	'Gela'),
(2524661,	108,	2523119,	'Gangi',	'Gangi',	'Gangi',	1,	18031,	'2019-03-16 03:59:51',	'Gangi',	'Gangi',	'Gangi'),
(2524679,	108,	2523119,	'Galati Mamertino',	'Galati Mamertino',	'Galati Mamertino',	1,	17928,	'2019-03-16 03:59:51',	'Galati Mamertino',	'Galati Mamertino',	'Galati Mamertino'),
(2524685,	108,	3169778,	'Gagliano del Capo',	'Gagliano del Capo',	'Gagliano del Capo',	1,	17889,	'2019-03-16 03:59:51',	'Gagliano del Capo',	'Gagliano del Capo',	'Gagliano del Capo'),
(2524687,	108,	2525468,	'Gagliano',	'Gagliano',	'Gagliano',	1,	17888,	'2019-03-16 03:59:51',	'Gagliano',	'Gagliano',	'Gagliano'),
(2524688,	108,	2523119,	'Gaggi',	'Gaggi',	'Gaggi',	1,	17884,	'2019-03-16 03:59:51',	'Gaggi',	'Gaggi',	'Gaggi'),
(2524690,	108,	2523228,	'Gadoni',	'Gadoni',	'Gadoni',	1,	17874,	'2019-03-16 03:59:51',	'Gadoni',	'Gadoni',	'Gadoni'),
(2524691,	108,	2525468,	'Fuscaldo',	'Fuscaldo',	'Fuscaldo',	1,	17845,	'2019-03-16 03:59:51',	'Fuscaldo',	'Fuscaldo',	'Fuscaldo'),
(2524694,	108,	2523119,	'Furci Siculo',	'Furci Siculo',	'Furci Siculo',	1,	17826,	'2019-03-16 03:59:51',	'Furci Siculo',	'Furci Siculo',	'Furci Siculo'),
(2524702,	108,	2525468,	'Frascineto',	'Frascineto',	'Frascineto',	1,	17435,	'2019-03-16 03:59:51',	'Frascineto',	'Frascineto',	'Frascineto'),
(2524704,	108,	2523119,	'Francofonte',	'Francofonte',	'Francofonte',	1,	17359,	'2019-03-16 03:59:51',	'Francofonte',	'Francofonte',	'Francofonte'),
(2524707,	108,	2523119,	'Francavilla di Sicilia',	'Francavilla di Sicilia',	'Francavilla di Sicilia',	1,	17345,	'2019-03-16 03:59:51',	'Francavilla di Sicilia',	'Francavilla di Sicilia',	'Francavilla di Sicilia'),
(2524708,	108,	2525468,	'Francavilla Angitola',	'Francavilla Angitola',	'Francavilla Angitola',	1,	17344,	'2019-03-16 03:59:51',	'Francavilla Angitola',	'Francavilla Angitola',	'Francavilla Angitola'),
(2524718,	108,	2525468,	'Fornaci',	'Fornaci',	'Fornaci',	1,	17104,	'2019-03-16 03:59:51',	'Fornaci',	'Fornaci',	'Fornaci'),
(2524731,	108,	2523228,	'Fluminimaggiore',	'Fluminimaggiore',	'Fluminimaggiore',	1,	16883,	'2019-03-16 03:59:51',	'Fluminimaggiore',	'Fluminimaggiore',	'Fluminimaggiore'),
(2524734,	108,	2523119,	'Флоридии',	'Floridia',	'Floridia',	1,	16863,	'2019-03-16 03:59:51',	'Floridia',	'Floridia',	'Floridia'),
(2524742,	108,	2523119,	'Fiumefreddo di Sicilia',	'Fiumefreddo di Sicilia',	'Fiumefreddo di Sicilia',	1,	16711,	'2019-03-16 03:59:51',	'Fiumefreddo di Sicilia',	'Fiumefreddo di Sicilia',	'Fiumefreddo di Sicilia'),
(2524743,	108,	2525468,	'Fiumefreddo Bruzio',	'Fiumefreddo Bruzio',	'Fiumefreddo Bruzio',	1,	16710,	'2019-03-16 03:59:51',	'Fiumefreddo Bruzio',	'Fiumefreddo Bruzio',	'Fiumefreddo Bruzio'),
(2524745,	108,	2523119,	'Fiumedinisi',	'Fiumedinisi',	'Fiumedinisi',	1,	16709,	'2019-03-16 03:59:51',	'Fiumedinisi',	'Fiumedinisi',	'Fiumedinisi'),
(2524749,	108,	2525468,	'Firmo',	'Firmo',	'Firmo',	1,	16665,	'2019-03-16 03:59:51',	'Firmo',	'Firmo',	'Firmo'),
(2524758,	108,	2525468,	'Filadelfia',	'Filadelfia',	'Filadelfia',	1,	16607,	'2019-03-16 03:59:51',	'Filadelfia',	'Filadelfia',	'Filadelfia'),
(2524761,	108,	2525468,	'Fiera',	'Fiera',	'Fiera',	1,	16591,	'2019-03-16 03:59:51',	'Fiera',	'Fiera',	'Fiera'),
(2524764,	108,	2523119,	'Ficarra',	'Ficarra',	'Ficarra',	1,	16581,	'2019-03-16 03:59:51',	'Ficarra',	'Ficarra',	'Ficarra'),
(2524765,	108,	2523119,	'Ficarazzi',	'Ficarazzi',	'Ficarazzi',	1,	16580,	'2019-03-16 03:59:51',	'Ficarazzi',	'Ficarazzi',	'Ficarazzi'),
(2524774,	108,	2525468,	'Feroleto della Chiesa',	'Feroleto della Chiesa',	'Feroleto della Chiesa',	1,	16512,	'2019-03-16 03:59:51',	'Feroleto della Chiesa',	'Feroleto della Chiesa',	'Feroleto della Chiesa'),
(2524780,	108,	2523119,	'Favignana',	'Favignana',	'Favignana',	1,	16359,	'2019-03-16 03:59:51',	'Favignana',	'Favignana',	'Favignana'),
(2524786,	108,	2523119,	'Favara',	'Favara',	'Favara',	1,	16351,	'2019-03-16 03:59:51',	'Favara',	'Favara',	'Favara'),
(2524798,	108,	2523119,	'Fantina',	'Fantina',	'Fantina',	1,	16240,	'2019-03-16 03:59:51',	'Fantina',	'Fantina',	'Fantina'),
(2524800,	108,	2525468,	'Falerna',	'Falerna',	'Falerna',	1,	16184,	'2019-03-16 03:59:51',	'Falerna',	'Falerna',	'Falerna'),
(2524801,	108,	2523119,	'Falcone',	'Falcone',	'Falcone',	1,	16181,	'2019-03-16 03:59:51',	'Falcone',	'Falcone',	'Falcone'),
(2524805,	108,	2525468,	'Fagnano Castello',	'Fagnano Castello',	'Fagnano Castello',	1,	16073,	'2019-03-16 03:59:51',	'Fagnano Castello',	'Fagnano Castello',	'Fagnano Castello'),
(2524812,	108,	2523228,	'Escovedu',	'Escovedu',	'Escovedu',	1,	15678,	'2019-03-16 03:59:51',	'Escovedu',	'Escovedu',	'Escovedu'),
(2524813,	108,	2523228,	'Escolca',	'Escolca',	'Escolca',	1,	15670,	'2019-03-16 03:59:51',	'Escolca',	'Escolca',	'Escolca'),
(2524814,	108,	2523228,	'Escalaplano',	'Escalaplano',	'Escalaplano',	1,	15636,	'2019-03-16 03:59:51',	'Escalaplano',	'Escalaplano',	'Escalaplano'),
(2524815,	108,	2523119,	'Эриче',	'Erice',	'Erice',	1,	15556,	'2019-03-16 03:59:51',	'Erice',	'Erice',	'Erice'),
(2524819,	108,	2523119,	'Энна',	'Enna',	'Enna',	1,	15384,	'2019-03-16 03:59:51',	'Enna',	'Enna',	'Enna'),
(2524820,	108,	2523228,	'Elmas',	'Elmas',	'Elmas',	1,	15169,	'2019-03-16 03:59:51',	'Elmas',	'Elmas',	'Elmas'),
(2524831,	108,	2523228,	'Donori',	'Donori',	'Donori',	1,	13762,	'2019-03-16 03:59:51',	'Donori',	'Donori',	'Donori'),
(2524841,	108,	2523228,	'Domusnovas',	'Domusnovas',	'Domusnovas',	1,	13718,	'2019-03-16 03:59:51',	'Domusnovas',	'Domusnovas',	'Domusnovas'),
(2524843,	108,	2525468,	'Domanico',	'Domanico',	'Domanico',	1,	13677,	'2019-03-16 03:59:51',	'Domanico',	'Domanico',	'Domanico'),
(2524844,	108,	2523228,	'Dolianova',	'Dolianova',	'Dolianova',	1,	13656,	'2019-03-16 03:59:51',	'Dolianova',	'Dolianova',	'Dolianova'),
(2524849,	108,	3169778,	'Diso',	'Diso',	'Diso',	1,	13544,	'2019-03-16 03:59:51',	'Diso',	'Diso',	'Diso'),
(2524856,	108,	2525468,	'Diamante',	'Diamante',	'Diamante',	1,	13381,	'2019-03-16 03:59:51',	'Diamante',	'Diamante',	'Diamante'),
(2524861,	108,	2525468,	'Delianuova',	'Delianuova',	'Delianuova',	1,	13131,	'2019-03-16 03:59:51',	'Delianuova',	'Delianuova',	'Delianuova'),
(2524862,	108,	2523119,	'Delia',	'Delia',	'Delia',	1,	13130,	'2019-03-16 03:59:51',	'Delia',	'Delia',	'Delia'),
(2524863,	108,	2525468,	'Casenove',	'Casenove',	'Casenove',	1,	8734,	'2019-03-16 03:59:51',	'Casenove',	'Casenove',	'Casenove'),
(2524864,	108,	2523228,	'Decimoputzu',	'Decimoputzu',	'Decimoputzu',	1,	13025,	'2019-03-16 03:59:51',	'Decimoputzu',	'Decimoputzu',	'Decimoputzu'),
(2524865,	108,	2523228,	'Decimomannu',	'Decimomannu',	'Decimomannu',	1,	13024,	'2019-03-16 03:59:51',	'Decimomannu',	'Decimomannu',	'Decimomannu'),
(2524866,	108,	2525468,	'Davoli',	'Davoli',	'Davoli',	1,	12931,	'2019-03-16 03:59:51',	'Davoli',	'Davoli',	'Davoli'),
(2524869,	108,	2525468,	'Cutro',	'Cutro',	'Cutro',	1,	12612,	'2019-03-16 03:59:51',	'Cutro',	'Cutro',	'Cutro'),
(2524870,	108,	2523119,	'Custonaci',	'Custonaci',	'Custonaci',	1,	12601,	'2019-03-16 03:59:51',	'Custonaci',	'Custonaci',	'Custonaci'),
(2524871,	108,	2525468,	'Cusino',	'Cusino',	'Cusino',	1,	12585,	'2019-03-16 03:59:51',	'Cusino',	'Cusino',	'Cusino'),
(2524872,	108,	2525468,	'Curinga',	'Curinga',	'Curinga',	1,	12559,	'2019-03-16 03:59:51',	'Curinga',	'Curinga',	'Curinga'),
(2524873,	108,	2523228,	'Curcuris',	'Curcuris',	'Curcuris',	1,	12556,	'2019-03-16 03:59:51',	'Curcuris',	'Curcuris',	'Curcuris'),
(2524881,	108,	2525468,	'Кротоне',	'Crotone',	'Crotone',	1,	12382,	'2019-03-16 03:59:51',	'Crotone',	'Crotone',	'Crotone'),
(2524882,	108,	2525468,	'Crosia',	'Crosia',	'Crosia',	1,	12352,	'2019-03-16 03:59:51',	'Crosia',	'Crosia',	'Crosia'),
(2524883,	108,	2525468,	'Cropani',	'Cropani',	'Cropani',	1,	12342,	'2019-03-16 03:59:51',	'Cropani',	'Cropani',	'Cropani'),
(2524901,	108,	2525468,	'Cotronei',	'Cotronei',	'Cotronei',	1,	11864,	'2019-03-16 03:59:51',	'Cotronei',	'Cotronei',	'Cotronei'),
(2524907,	108,	2525468,	'Козенца',	'Cosenza',	'Cosenza',	1,	11824,	'2019-03-16 03:59:51',	'Cosenza',	'Cosenza',	'Cosenza'),
(2524915,	108,	2525468,	'Cortale',	'Cortale',	'Cortale',	1,	11788,	'2019-03-16 03:59:51',	'Cortale',	'Cortale',	'Cortale'),
(2524918,	108,	3169778,	'Corsano',	'Corsano',	'Corsano',	1,	11779,	'2019-03-16 03:59:51',	'Corsano',	'Corsano',	'Corsano'),
(2524928,	108,	2523119,	'Corleone',	'Corleone',	'Corleone',	1,	11688,	'2019-03-16 03:59:51',	'Corleone',	'Corleone',	'Corleone'),
(2524929,	108,	2525468,	'Corigliano Calabro',	'Corigliano Calabro',	'Corigliano Calabro',	1,	11678,	'2019-03-16 03:59:51',	'Corigliano Calabro',	'Corigliano Calabro',	'Corigliano Calabro'),
(2524955,	108,	2523119,	'Комизо',	'Comiso',	'Comiso',	1,	11372,	'2019-03-16 03:59:51',	'Comiso',	'Comiso',	'Comiso'),
(2524963,	108,	2523228,	'Collinas',	'Collinas',	'Collinas',	1,	11185,	'2019-03-16 03:59:51',	'Collinas',	'Collinas',	'Collinas'),
(2524964,	108,	2523119,	'Collesano',	'Collesano',	'Collesano',	1,	11176,	'2019-03-16 03:59:51',	'Collesano',	'Collesano',	'Collesano'),
(2524976,	108,	2525468,	'Cittanova',	'Cittanova',	'Cittanova',	1,	10587,	'2019-03-16 03:59:51',	'Cittanova',	'Cittanova',	'Cittanova'),
(2524979,	108,	2525468,	'Ciro Marina',	'Ciro Marina',	'Ciro Marina',	1,	10556,	'2019-03-16 03:59:51',	'Ciro Marina',	'Ciro Marina',	'Ciro Marina'),
(2524987,	108,	2523119,	'Cinisi',	'Cinisi',	'Cinisi',	1,	10534,	'2019-03-16 03:59:51',	'Cinisi',	'Cinisi',	'Cinisi'),
(2524989,	108,	2523119,	'Ciminna',	'Ciminna',	'Ciminna',	1,	10523,	'2019-03-16 03:59:51',	'Ciminna',	'Ciminna',	'Ciminna'),
(2525009,	108,	2525468,	'Chiaravalle Centrale',	'Chiaravalle Centrale',	'Chiaravalle Centrale',	1,	10281,	'2019-03-16 03:59:51',	'Chiaravalle Centrale',	'Chiaravalle Centrale',	'Chiaravalle Centrale'),
(2525010,	108,	2523119,	'Chiaramonte Gulfi',	'Chiaramonte Gulfi',	'Chiaramonte Gulfi',	1,	10279,	'2019-03-16 03:59:51',	'Chiaramonte Gulfi',	'Chiaramonte Gulfi',	'Chiaramonte Gulfi'),
(2525012,	108,	2525468,	'Cetraro',	'Cetraro',	'Cetraro',	1,	9483,	'2019-03-16 03:59:51',	'Cetraro',	'Cetraro',	'Cetraro'),
(2525016,	108,	2525468,	'Cerzeto',	'Cerzeto',	'Cerzeto',	1,	9461,	'2019-03-16 03:59:51',	'Cerzeto',	'Cerzeto',	'Cerzeto'),
(2525023,	108,	2525468,	'Cerisano',	'Cerisano',	'Cerisano',	1,	9415,	'2019-03-16 03:59:51',	'Cerisano',	'Cerisano',	'Cerisano'),
(2525031,	108,	2523119,	'Cerami',	'Cerami',	'Cerami',	1,	9378,	'2019-03-16 03:59:51',	'Cerami',	'Cerami',	'Cerami'),
(2525032,	108,	2523119,	'Centuripe',	'Centuripe',	'Centuripe',	1,	9367,	'2019-03-16 03:59:51',	'Centuripe',	'Centuripe',	'Centuripe'),
(2525038,	108,	2525468,	'Celico',	'Celico',	'Celico',	1,	9261,	'2019-03-16 03:59:51',	'Celico',	'Celico',	'Celico'),
(2525041,	108,	2523119,	'Cefalu',	'Cefalu',	'Cefalu',	1,	9248,	'2019-03-16 03:59:51',	'Cefalu',	'Cefalu',	'Cefalu'),
(2525053,	108,	2525468,	'Caulonia',	'Caulonia',	'Caulonia',	1,	9110,	'2019-03-16 03:59:51',	'Caulonia',	'Caulonia',	'Caulonia'),
(2525054,	108,	2523119,	'Cattolica Eraclea',	'Cattolica Eraclea',	'Cattolica Eraclea',	1,	9093,	'2019-03-16 03:59:51',	'Cattolica Eraclea',	'Cattolica Eraclea',	'Cattolica Eraclea'),
(2525057,	108,	2523119,	'Catenanuova',	'Catenanuova',	'Catenanuova',	1,	9068,	'2019-03-16 03:59:51',	'Catenanuova',	'Catenanuova',	'Catenanuova'),
(2525059,	108,	2525468,	'Катандзаро',	'Catanzaro',	'Catanzaro',	1,	9058,	'2019-03-16 03:59:51',	'Catanzaro',	'Catanzaro',	'Catanzaro'),
(2525068,	108,	2523119,	'Катания',	'Catania',	'Catania',	1,	9057,	'2019-03-16 03:59:51',	'Catania',	'Catania',	'Catania'),
(2525070,	108,	2525468,	'Кастровиллари',	'Castrovillari',	'Castrovillari',	1,	9050,	'2019-03-16 03:59:51',	'Castrovillari',	'Castrovillari',	'Castrovillari'),
(2525075,	108,	2525468,	'Castrolibero',	'Castrolibero',	'Castrolibero',	1,	9046,	'2019-03-16 03:59:51',	'Castrolibero',	'Castrolibero',	'Castrolibero'),
(2525077,	108,	3169778,	'Castrignano del Capo',	'Castrignano del Capo',	'Castrignano del Capo',	1,	9035,	'2019-03-16 03:59:51',	'Castrignano del Capo',	'Castrignano del Capo',	'Castrignano del Capo'),
(2525079,	108,	2523119,	'Castiglione di Sicilia',	'Castiglione di Sicilia',	'Castiglione di Sicilia',	1,	8985,	'2019-03-16 03:59:51',	'Castiglione di Sicilia',	'Castiglione di Sicilia',	'Castiglione di Sicilia'),
(2525083,	108,	2523119,	'Кастельветрано',	'Castelvetrano',	'Castelvetrano',	1,	8964,	'2019-03-16 03:59:51',	'Castelvetrano',	'Castelvetrano',	'Castelvetrano'),
(2525084,	108,	2523119,	'Casteltermini',	'Casteltermini',	'Casteltermini',	1,	8960,	'2019-03-16 03:59:51',	'Casteltermini',	'Casteltermini',	'Casteltermini'),
(2525089,	108,	3182306,	'Castelluccio Inferiore',	'Castelluccio Inferiore',	'Castelluccio Inferiore',	1,	8922,	'2019-03-16 03:59:51',	'Castelluccio Inferiore',	'Castelluccio Inferiore',	'Castelluccio Inferiore'),
(2525093,	108,	2523119,	'Castellana Sicula',	'Castellana Sicula',	'Castellana Sicula',	1,	8881,	'2019-03-16 03:59:51',	'Castellana Sicula',	'Castellana Sicula',	'Castellana Sicula'),
(2525095,	108,	2523119,	'Castellammare del Golfo',	'Castellammare del Golfo',	'Castellammare del Golfo',	1,	8877,	'2019-03-16 03:59:51',	'Castellammare del Golfo',	'Castellammare del Golfo',	'Castellammare del Golfo'),
(2525102,	108,	2523119,	'Casteldaccia',	'Casteldaccia',	'Casteldaccia',	1,	8856,	'2019-03-16 03:59:51',	'Casteldaccia',	'Casteldaccia',	'Casteldaccia'),
(2525103,	108,	2523119,	'Castelbuono',	'Castelbuono',	'Castelbuono',	1,	8852,	'2019-03-16 03:59:51',	'Castelbuono',	'Castelbuono',	'Castelbuono'),
(2525108,	108,	2523119,	'Cassibile',	'Cassibile',	'Cassibile',	1,	8788,	'2019-03-16 03:59:51',	'Cassibile',	'Cassibile',	'Cassibile'),
(2525113,	108,	2525468,	'Casole Bruzio',	'Casole Bruzio',	'Casole Bruzio',	1,	8758,	'2019-03-16 03:59:51',	'Casole Bruzio',	'Casole Bruzio',	'Casole Bruzio'),
(2525120,	108,	2525468,	'Casignana',	'Casignana',	'Casignana',	1,	8750,	'2019-03-16 03:59:51',	'Casignana',	'Casignana',	'Casignana'),
(2525199,	108,	2525468,	'Casa San Filo',	'Casa San Filo',	'Casa San Filo',	1,	8658,	'2019-03-16 03:59:51',	'Casa San Filo',	'Casa San Filo',	'Casa San Filo'),
(2525207,	108,	3169778,	'Casarano',	'Casarano',	'Casarano',	1,	8703,	'2019-03-16 03:59:51',	'Casarano',	'Casarano',	'Casarano'),
(2525220,	108,	2525468,	'Casa Pasquale',	'Casa Pasquale',	'Casa Pasquale',	1,	8657,	'2019-03-16 03:59:51',	'Casa Pasquale',	'Casa Pasquale',	'Casa Pasquale'),
(2525223,	108,	2525468,	'Casa Paradiso',	'Casa Paradiso',	'Casa Paradiso',	1,	8656,	'2019-03-16 03:59:51',	'Casa Paradiso',	'Casa Paradiso',	'Casa Paradiso'),
(2525229,	108,	2525468,	'Casa Pace',	'Casa Pace',	'Casa Pace',	1,	8655,	'2019-03-16 03:59:51',	'Casa Pace',	'Casa Pace',	'Casa Pace'),
(2525251,	108,	2523119,	'Casalvecchio Siculo',	'Casalvecchio Siculo',	'Casalvecchio Siculo',	1,	8692,	'2019-03-16 03:59:51',	'Casalvecchio Siculo',	'Casalvecchio Siculo',	'Casalvecchio Siculo'),
(2525328,	108,	2525468,	'Casabona',	'Casabona',	'Casabona',	1,	8662,	'2019-03-16 03:59:51',	'Casabona',	'Casabona',	'Casabona'),
(2525342,	108,	2523119,	'Caronia Marina',	'Caronia Marina',	'Caronia Marina',	1,	8537,	'2019-03-16 03:59:51',	'Caronia Marina',	'Caronia Marina',	'Caronia Marina'),
(2525344,	108,	2523119,	'Caronia',	'Caronia',	'Caronia',	1,	8536,	'2019-03-16 03:59:51',	'Caronia',	'Caronia',	'Caronia'),
(2525346,	108,	2525468,	'Carolei',	'Carolei',	'Carolei',	1,	8528,	'2019-03-16 03:59:51',	'Carolei',	'Carolei',	'Carolei'),
(2525348,	108,	2523228,	'Carloforte',	'Carloforte',	'Carloforte',	1,	8470,	'2019-03-16 03:59:51',	'Carloforte',	'Carloforte',	'Carloforte'),
(2525349,	108,	2523119,	'Carlentini',	'Carlentini',	'Carlentini',	1,	8454,	'2019-03-16 03:59:51',	'Carlentini',	'Carlentini',	'Carlentini'),
(2525350,	108,	2523119,	'Карина',	'Carini',	'Carini',	1,	8447,	'2019-03-16 03:59:51',	'Carini',	'Carini',	'Carini'),
(2525357,	108,	2525468,	'Careri',	'Careri',	'Careri',	1,	8435,	'2019-03-16 03:59:51',	'Careri',	'Careri',	'Careri'),
(2525362,	108,	2523228,	'Карбония',	'Carbonia',	'Carbonia',	1,	8403,	'2019-03-16 03:59:51',	'Carbonia',	'Carbonia',	'Carbonia'),
(2525370,	108,	2525468,	'Caraffa del Bianco',	'Caraffa del Bianco',	'Caraffa del Bianco',	1,	8375,	'2019-03-16 03:59:51',	'Caraffa del Bianco',	'Caraffa del Bianco',	'Caraffa del Bianco'),
(2525379,	108,	2523228,	'Капотерра',	'Capoterra',	'Capoterra',	1,	8348,	'2019-03-16 03:59:51',	'Capoterra',	'Capoterra',	'Capoterra'),
(2525380,	108,	2525468,	'Capo Rizzuto',	'Capo Rizzuto',	'Capo Rizzuto',	1,	8342,	'2019-03-16 03:59:51',	'Capo Rizzuto',	'Capo Rizzuto',	'Capo Rizzuto'),
(2525384,	108,	2523119,	'Capo d\'Orlando',	'Capo d\'Orlando',	'Capo d\'Orlando',	1,	8340,	'2019-03-16 03:59:51',	'Capo d\'Orlando',	'Capo d\'Orlando',	'Capo d\'Orlando'),
(2525385,	108,	2525468,	'Dipignano',	'Dipignano',	'Dipignano',	1,	13531,	'2019-03-16 03:59:51',	'Dipignano',	'Dipignano',	'Dipignano'),
(2525388,	108,	2525468,	'Capistrano',	'Capistrano',	'Capistrano',	1,	8333,	'2019-03-16 03:59:51',	'Capistrano',	'Capistrano',	'Capistrano'),
(2525392,	108,	2523119,	'Capaci',	'Capaci',	'Capaci',	1,	8304,	'2019-03-16 03:59:51',	'Capaci',	'Capaci',	'Capaci'),
(2525404,	108,	2523119,	'Canicattini Bagni',	'Canicattini Bagni',	'Canicattini Bagni',	1,	8213,	'2019-03-16 03:59:51',	'Canicattini Bagni',	'Canicattini Bagni',	'Canicattini Bagni'),
(2525405,	108,	2523119,	'Canicatti',	'Canicatti',	'Canicatti',	1,	8212,	'2019-03-16 03:59:51',	'Canicatti',	'Canicatti',	'Canicatti'),
(2525415,	108,	2523119,	'Camporeale',	'Camporeale',	'Camporeale',	1,	8124,	'2019-03-16 03:59:51',	'Camporeale',	'Camporeale',	'Camporeale'),
(2525421,	108,	2523119,	'Campofranco',	'Campofranco',	'Campofranco',	1,	8112,	'2019-03-16 03:59:51',	'Campofranco',	'Campofranco',	'Campofranco'),
(2525423,	108,	2523119,	'Campofelice di Roccella',	'Campofelice di Roccella',	'Campofelice di Roccella',	1,	8109,	'2019-03-16 03:59:51',	'Campofelice di Roccella',	'Campofelice di Roccella',	'Campofelice di Roccella'),
(2525425,	108,	2523119,	'Campobello di Mazara',	'Campobello di Mazara',	'Campobello di Mazara',	1,	8104,	'2019-03-16 03:59:51',	'Campobello di Mazara',	'Campobello di Mazara',	'Campobello di Mazara'),
(2525426,	108,	2523119,	'Campobello di Licata',	'Campobello di Licata',	'Campobello di Licata',	1,	8103,	'2019-03-16 03:59:51',	'Campobello di Licata',	'Campobello di Licata',	'Campobello di Licata'),
(2525427,	108,	2525468,	'Campo',	'Campo',	'Campo',	1,	8093,	'2019-03-16 03:59:51',	'Campo',	'Campo',	'Campo'),
(2525441,	108,	2523119,	'Camastra',	'Camastra',	'Camastra',	1,	7943,	'2019-03-16 03:59:51',	'Camastra',	'Camastra',	'Camastra'),
(2525448,	108,	2523119,	'Кальтаниссетта',	'Caltanissetta',	'Caltanissetta',	1,	7901,	'2019-03-16 03:59:51',	'Caltanissetta',	'Caltanissetta',	'Caltanissetta'),
(2525450,	108,	2523119,	'Кальтаджироне',	'Caltagirone',	'Caltagirone',	1,	7900,	'2019-03-16 03:59:51',	'Caltagirone',	'Caltagirone',	'Caltagirone'),
(2525458,	108,	2523119,	'Calatafimi',	'Calatafimi',	'Calatafimi',	1,	7798,	'2019-03-16 03:59:51',	'Calatafimi',	'Calatafimi',	'Calatafimi'),
(2525459,	108,	2523119,	'Calatabiano',	'Calatabiano',	'Calatabiano',	1,	7797,	'2019-03-16 03:59:51',	'Calatabiano',	'Calatabiano',	'Calatabiano'),
(2525460,	108,	2523228,	'Calasetta',	'Calasetta',	'Calasetta',	1,	7795,	'2019-03-16 03:59:51',	'Calasetta',	'Calasetta',	'Calasetta'),
(2525461,	108,	2523119,	'Calascibetta',	'Calascibetta',	'Calascibetta',	1,	7794,	'2019-03-16 03:59:51',	'Calascibetta',	'Calascibetta',	'Calascibetta'),
(2525473,	108,	2523228,	'Кальяри',	'Cagliari',	'Cagliari',	1,	7742,	'2019-03-16 03:59:51',	'Cagliari',	'Cagliari',	'Cagliari'),
(2525475,	108,	2525468,	'Caccuri',	'Caccuri',	'Caccuri',	1,	7697,	'2019-03-16 03:59:51',	'Caccuri',	'Caccuri',	'Caccuri'),
(2525476,	108,	2523119,	'Caccamo',	'Caccamo',	'Caccamo',	1,	7696,	'2019-03-16 03:59:51',	'Caccamo',	'Caccamo',	'Caccamo'),
(2525478,	108,	2523228,	'Cabras',	'Cabras',	'Cabras',	1,	7688,	'2019-03-16 03:59:51',	'Cabras',	'Cabras',	'Cabras'),
(2525480,	108,	2523119,	'Butera',	'Butera',	'Butera',	1,	7579,	'2019-03-16 03:59:51',	'Butera',	'Butera',	'Butera'),
(2525498,	108,	2523119,	'Bronte',	'Bronte',	'Bronte',	1,	6884,	'2019-03-16 03:59:51',	'Bronte',	'Bronte',	'Bronte'),
(2525499,	108,	2523119,	'Brolo',	'Brolo',	'Brolo',	1,	6866,	'2019-03-16 03:59:51',	'Brolo',	'Brolo',	'Brolo'),
(2525501,	108,	2525468,	'Briatico',	'Briatico',	'Briatico',	1,	6646,	'2019-03-16 03:59:51',	'Briatico',	'Briatico',	'Briatico'),
(2525511,	108,	2525468,	'Bova Marina',	'Bova Marina',	'Bova Marina',	1,	6200,	'2019-03-16 03:59:51',	'Bova Marina',	'Bova Marina',	'Bova Marina'),
(2525513,	108,	2525468,	'Bovalino',	'Bovalino',	'Bovalino',	1,	6201,	'2019-03-16 03:59:51',	'Bovalino',	'Bovalino',	'Bovalino'),
(2525517,	108,	2525468,	'Botricello',	'Botricello',	'Botricello',	1,	6038,	'2019-03-16 03:59:51',	'Botricello',	'Botricello',	'Botricello'),
(2525525,	108,	2525468,	'Borgia',	'Borgia',	'Borgia',	1,	5909,	'2019-03-16 03:59:51',	'Borgia',	'Borgia',	'Borgia'),
(2525532,	108,	2525468,	'Bonifati',	'Bonifati',	'Bonifati',	1,	5784,	'2019-03-16 03:59:51',	'Bonifati',	'Bonifati',	'Bonifati'),
(2525543,	108,	2525468,	'Bivongi',	'Bivongi',	'Bivongi',	1,	5215,	'2019-03-16 03:59:51',	'Bivongi',	'Bivongi',	'Bivongi'),
(2525550,	108,	2525468,	'Bisignano',	'Bisignano',	'Bisignano',	1,	5176,	'2019-03-16 03:59:51',	'Bisignano',	'Bisignano',	'Bisignano'),
(2525558,	108,	2525468,	'Bianco',	'Bianco',	'Bianco',	1,	4874,	'2019-03-16 03:59:51',	'Bianco',	'Bianco',	'Bianco'),
(2525560,	108,	2523119,	'Biancavilla',	'Biancavilla',	'Biancavilla',	1,	4873,	'2019-03-16 03:59:51',	'Biancavilla',	'Biancavilla',	'Biancavilla'),
(2525567,	108,	2525468,	'Belvedere Marittimo',	'Belvedere Marittimo',	'Belvedere Marittimo',	1,	4306,	'2019-03-16 03:59:51',	'Belvedere Marittimo',	'Belvedere Marittimo',	'Belvedere Marittimo'),
(2525568,	108,	2525468,	'Belvedere di Spinello',	'Belvedere di Spinello',	'Belvedere di Spinello',	1,	4305,	'2019-03-16 03:59:51',	'Belvedere di Spinello',	'Belvedere di Spinello',	'Belvedere di Spinello'),
(2525571,	108,	2523119,	'Belpasso',	'Belpasso',	'Belpasso',	1,	4290,	'2019-03-16 03:59:51',	'Belpasso',	'Belpasso',	'Belpasso'),
(2525573,	108,	2523119,	'Belmonte Mezzagno',	'Belmonte Mezzagno',	'Belmonte Mezzagno',	1,	4282,	'2019-03-16 03:59:51',	'Belmonte Mezzagno',	'Belmonte Mezzagno',	'Belmonte Mezzagno'),
(2525583,	108,	2523119,	'Baucina',	'Baucina',	'Baucina',	1,	3683,	'2019-03-16 03:59:51',	'Baucina',	'Baucina',	'Baucina'),
(2525592,	108,	2523228,	'Barrali',	'Barrali',	'Barrali',	1,	3506,	'2019-03-16 03:59:51',	'Barrali',	'Barrali',	'Barrali'),
(2525593,	108,	2523119,	'Barrafranca',	'Barrafranca',	'Barrafranca',	1,	3505,	'2019-03-16 03:59:51',	'Barrafranca',	'Barrafranca',	'Barrafranca'),
(2525595,	108,	2523228,	'Bari Sardo',	'Bari Sardo',	'Bari Sardo',	1,	3429,	'2019-03-16 03:59:51',	'Bari Sardo',	'Bari Sardo',	'Bari Sardo'),
(2525596,	108,	2523228,	'Baressa',	'Baressa',	'Baressa',	1,	3411,	'2019-03-16 03:59:51',	'Baressa',	'Baressa',	'Baressa'),
(2525601,	108,	2523228,	'Baratili San Pietro',	'Baratili San Pietro',	'Baratili San Pietro',	1,	3357,	'2019-03-16 03:59:51',	'Baratili San Pietro',	'Baratili San Pietro',	'Baratili San Pietro'),
(2525609,	108,	2523119,	'Balestrate',	'Balestrate',	'Balestrate',	1,	3199,	'2019-03-16 03:59:51',	'Balestrate',	'Balestrate',	'Balestrate'),
(2525616,	108,	2525468,	'Bagnara Calabra',	'Bagnara Calabra',	'Bagnara Calabra',	1,	3056,	'2019-03-16 03:59:51',	'Bagnara Calabra',	'Bagnara Calabra',	'Bagnara Calabra'),
(2525618,	108,	2523119,	'Baglio Rizzo',	'Baglio Rizzo',	'Baglio Rizzo',	1,	3053,	'2019-03-16 03:59:51',	'Baglio Rizzo',	'Baglio Rizzo',	'Baglio Rizzo'),
(2525628,	108,	2523119,	'Багерия',	'Bagheria',	'Bagheria',	1,	3050,	'2019-03-16 03:59:51',	'Bagheria',	'Bagheria',	'Bagheria'),
(2525634,	108,	2525468,	'Badolato',	'Badolato',	'Badolato',	1,	3032,	'2019-03-16 03:59:51',	'Badolato',	'Badolato',	'Badolato'),
(2525641,	108,	2523228,	'Bacu Abis',	'Bacu Abis',	'Bacu Abis',	1,	2876,	'2019-03-16 03:59:51',	'Bacu Abis',	'Bacu Abis',	'Bacu Abis'),
(2525643,	108,	2523119,	'Avola',	'Avola',	'Avola',	1,	2741,	'2019-03-16 03:59:51',	'Avola',	'Avola',	'Avola'),
(2525646,	108,	2523119,	'Augusta',	'Augusta',	'Augusta',	1,	2530,	'2019-03-16 03:59:51',	'Augusta',	'Augusta',	'Augusta'),
(2525655,	108,	2523228,	'Ассемини',	'Assemini',	'Assemini',	1,	2268,	'2019-03-16 03:59:51',	'Assemini',	'Assemini',	'Assemini'),
(2525664,	108,	2523228,	'Arzana',	'Arzana',	'Arzana',	1,	2108,	'2019-03-16 03:59:51',	'Arzana',	'Arzana',	'Arzana'),
(2525673,	108,	2523228,	'Aritzo',	'Aritzo',	'Aritzo',	1,	1891,	'2019-03-16 03:59:51',	'Aritzo',	'Aritzo',	'Aritzo'),
(2525688,	108,	2523228,	'Arbus',	'Arbus',	'Arbus',	1,	1737,	'2019-03-16 03:59:51',	'Arbus',	'Arbus',	'Arbus'),
(2525689,	108,	2523228,	'Arborea',	'Arborea',	'Arborea',	1,	1731,	'2019-03-16 03:59:51',	'Arborea',	'Arborea',	'Arborea'),
(2525693,	108,	2523119,	'Aragona',	'Aragona',	'Aragona',	1,	1703,	'2019-03-16 03:59:51',	'Aragona',	'Aragona',	'Aragona'),
(2525700,	108,	2525468,	'Antonimina',	'Antonimina',	'Antonimina',	1,	1599,	'2019-03-16 03:59:51',	'Antonimina',	'Antonimina',	'Antonimina'),
(2525710,	108,	2525468,	'Anna',	'Anna',	'Anna',	1,	1505,	'2019-03-16 03:59:51',	'Anna',	'Anna',	'Anna'),
(2525714,	108,	3169778,	'Andrano',	'Andrano',	'Andrano',	1,	1408,	'2019-03-16 03:59:51',	'Andrano',	'Andrano',	'Andrano'),
(2525723,	108,	2525468,	'Amendolara',	'Amendolara',	'Amendolara',	1,	1236,	'2019-03-16 03:59:51',	'Amendolara',	'Amendolara',	'Amendolara'),
(2525725,	108,	2525468,	'Amato',	'Amato',	'Amato',	1,	1191,	'2019-03-16 03:59:51',	'Amato',	'Amato',	'Amato'),
(2525727,	108,	2525468,	'Amantea',	'Amantea',	'Amantea',	1,	1184,	'2019-03-16 03:59:51',	'Amantea',	'Amantea',	'Amantea'),
(2525728,	108,	2525468,	'Altomonte',	'Altomonte',	'Altomonte',	1,	1103,	'2019-03-16 03:59:51',	'Altomonte',	'Altomonte',	'Altomonte'),
(2525729,	108,	2523119,	'Altofonte',	'Altofonte',	'Altofonte',	1,	1101,	'2019-03-16 03:59:51',	'Altofonte',	'Altofonte',	'Altofonte'),
(2525734,	108,	2523119,	'Altavilla Milicia',	'Altavilla Milicia',	'Altavilla Milicia',	1,	1020,	'2019-03-16 03:59:51',	'Altavilla Milicia',	'Altavilla Milicia',	'Altavilla Milicia'),
(2525741,	108,	2523119,	'Alimena',	'Alimena',	'Alimena',	1,	796,	'2019-03-16 03:59:51',	'Alimena',	'Alimena',	'Alimena'),
(2525748,	108,	3169778,	'Alessano',	'Alessano',	'Alessano',	1,	707,	'2019-03-16 03:59:51',	'Alessano',	'Alessano',	'Alessano'),
(2525749,	108,	2523119,	'Alessandria della Rocca',	'Alessandria della Rocca',	'Alessandria della Rocca',	1,	706,	'2019-03-16 03:59:51',	'Alessandria della Rocca',	'Alessandria della Rocca',	'Alessandria della Rocca'),
(2525751,	108,	2523228,	'Ales',	'Ales',	'Ales',	1,	702,	'2019-03-16 03:59:51',	'Ales',	'Ales',	'Ales'),
(2525755,	108,	2523119,	'Алькамо',	'Alcamo',	'Alcamo',	1,	632,	'2019-03-16 03:59:51',	'Alcamo',	'Alcamo',	'Alcamo'),
(2525758,	108,	2525468,	'Albergo',	'Albergo',	'Albergo',	1,	555,	'2019-03-16 03:59:51',	'Albergo',	'Albergo',	'Albergo'),
(2525761,	108,	2523119,	'Aidone',	'Aidone',	'Aidone',	1,	371,	'2019-03-16 03:59:51',	'Aidone',	'Aidone',	'Aidone'),
(2525764,	108,	2523119,	'Агридженто',	'Agrigento',	'Agrigento',	1,	320,	'2019-03-16 03:59:51',	'Agrigento',	'Agrigento',	'Agrigento'),
(2525767,	108,	2523119,	'Agira',	'Agira',	'Agira',	1,	299,	'2019-03-16 03:59:51',	'Agira',	'Agira',	'Agira'),
(2525769,	108,	2523119,	'Адрано',	'Adrano',	'Adrano',	1,	258,	'2019-03-16 03:59:51',	'Adrano',	'Adrano',	'Adrano'),
(2525772,	108,	2525468,	'Акри',	'Acri',	'Acri',	1,	168,	'2019-03-16 03:59:51',	'Acri',	'Acri',	'Acri'),
(2525778,	108,	3169778,	'Acquarica del Capo',	'Acquarica del Capo',	'Acquarica del Capo',	1,	160,	'2019-03-16 03:59:51',	'Acquarica del Capo',	'Acquarica del Capo',	'Acquarica del Capo'),
(2525789,	108,	2523119,	'Aci Sant\'Antonio',	'Aci Sant\'Antonio',	'Aci Sant\'Antonio',	1,	145,	'2019-03-16 03:59:51',	'Aci Sant\'Antonio',	'Aci Sant\'Antonio',	'Aci Sant\'Antonio'),
(2525790,	108,	2523119,	'Acireale',	'Acireale',	'Acireale',	1,	148,	'2019-03-16 03:59:51',	'Acireale',	'Acireale',	'Acireale'),
(2525791,	108,	2523119,	'Aci Catena',	'Aci Catena',	'Aci Catena',	1,	144,	'2019-03-16 03:59:51',	'Aci Catena',	'Aci Catena',	'Aci Catena'),
(2525792,	108,	2523119,	'Aci Castello',	'Aci Castello',	'Aci Castello',	1,	143,	'2019-03-16 03:59:51',	'Aci Castello',	'Aci Castello',	'Aci Castello'),
(2525793,	108,	2523119,	'Aci Bonaccorsi',	'Aci Bonaccorsi',	'Aci Bonaccorsi',	1,	142,	'2019-03-16 03:59:51',	'Aci Bonaccorsi',	'Aci Bonaccorsi',	'Aci Bonaccorsi'),
(2525796,	108,	2523119,	'Acate',	'Acate',	'Acate',	1,	118,	'2019-03-16 03:59:51',	'Acate',	'Acate',	'Acate'),
(2565056,	67,	2593109,	'Punta Umbria',	'Punta Umbria',	'Punta Umbria',	1,	39564,	'2019-03-16 03:59:51',	'Punta Umbria',	'Punta Umbria',	'Punta Umbria'),
(2565103,	67,	2593109,	'Pescador',	'Pescador',	'Pescador',	1,	37538,	'2019-03-16 03:59:51',	'Pescador',	'Pescador',	'Pescador'),
(2565122,	67,	2593109,	'Torre de la Higuera',	'Torre de la Higuera',	'Torre de la Higuera',	1,	49486,	'2019-03-16 03:59:51',	'Torre de la Higuera',	'Torre de la Higuera',	'Torre de la Higuera'),
(2592661,	108,	2523228,	'Camisa',	'Camisa',	'Camisa',	1,	8027,	'2019-03-16 03:59:51',	'Camisa',	'Camisa',	'Camisa'),
(2633352,	77,	2633351,	'Йорк',	'York',	'York',	1,	54944,	'2019-03-16 03:59:51',	'York',	'York',	'York'),
(2633373,	77,	2637532,	'Йеовиль',	'Yeovil',	'Yeovil',	1,	54923,	'2019-03-16 03:59:51',	'Yeovil',	'Yeovil',	'Yeovil'),
(2633415,	77,	3333203,	'Ярм',	'Yarm',	'Yarm',	1,	54880,	'2019-03-16 03:59:51',	'Yarm',	'Yarm',	'Yarm'),
(2633446,	77,	2641455,	'Уаймондхэм',	'Wymondham',	'Wymondham',	1,	54815,	'2019-03-16 03:59:51',	'Wymondham',	'Wymondham',	'Wymondham'),
(2633481,	77,	2649889,	'Ритл',	'Writtle',	'Writtle',	1,	54765,	'2019-03-16 03:59:51',	'Writtle',	'Writtle',	'Writtle'),
(2633485,	77,	2633484,	'Рексем',	'Wrexham',	'Wrexham',	1,	54753,	'2019-03-16 03:59:51',	'Wrexham',	'Wrexham',	'Wrexham'),
(2633521,	77,	2634258,	'Плезант Хилл',	'Worthing',	'Worthing',	1,	54734,	'2019-03-16 03:59:51',	'Worthing',	'Worthing',	'Worthing'),
(2633526,	77,	2634258,	'Worth',	'Worth',	'Worth',	1,	54728,	'2019-03-16 03:59:51',	'Worth',	'Worth',	'Worth'),
(2633529,	77,	3333190,	'Worsley',	'Worsley',	'Worsley',	1,	54725,	'2019-03-16 03:59:51',	'Worsley',	'Worsley',	'Worsley'),
(2633532,	77,	2636512,	'Worplesdon',	'Worplesdon',	'Worplesdon',	1,	54722,	'2019-03-16 03:59:51',	'Worplesdon',	'Worplesdon',	'Worplesdon'),
(2633535,	77,	2647043,	'Wormley',	'Wormley',	'Wormley',	1,	54718,	'2019-03-16 03:59:51',	'Wormley',	'Wormley',	'Wormley'),
(2633538,	77,	2649469,	'Wormit',	'Wormit',	'Wormit',	1,	54717,	'2019-03-16 03:59:51',	'Wormit',	'Wormit',	'Wormit'),
(2633540,	77,	2654408,	'Worminghall',	'Worminghall',	'Worminghall',	1,	54716,	'2019-03-16 03:59:51',	'Worminghall',	'Worminghall',	'Worminghall'),
(2633546,	77,	2636561,	'Worlingham',	'Worlingham',	'Worlingham',	1,	54714,	'2019-03-16 03:59:51',	'Worlingham',	'Worlingham',	'Worlingham'),
(2633548,	77,	3333177,	'Worle',	'Worle',	'Worle',	1,	54712,	'2019-03-16 03:59:51',	'Worle',	'Worle',	'Worle'),
(2633551,	77,	2641169,	'Уорксоп',	'Worksop',	'Worksop',	1,	54710,	'2019-03-16 03:59:51',	'Worksop',	'Worksop',	'Worksop'),
(2633553,	77,	2651712,	'Workington',	'Workington',	'Workington',	1,	54709,	'2019-03-16 03:59:51',	'Workington',	'Workington',	'Workington'),
(2633563,	77,	2633560,	'Вустер',	'Worcester',	'Worcester',	1,	54704,	'2019-03-16 03:59:51',	'Worcester',	'Worcester',	'Worcester'),
(2633566,	77,	2633868,	'Wootton Rivers',	'Wootton Rivers',	'Wootton Rivers',	1,	54699,	'2019-03-16 03:59:51',	'Wootton Rivers',	'Wootton Rivers',	'Wootton Rivers'),
(2633571,	77,	2633868,	'Royal Wootton Bassett',	'Royal Wootton Bassett',	'Royal Wootton Bassett',	1,	41891,	'2019-03-16 03:59:51',	'Royal Wootton Bassett',	'Royal Wootton Bassett',	'Royal Wootton Bassett'),
(2633573,	77,	2637141,	'Wootton',	'Wootton',	'Wootton',	1,	54697,	'2019-03-16 03:59:51',	'Wootton',	'Wootton',	'Wootton'),
(2633576,	77,	2640726,	'Wootton',	'Wootton',	'Wootton',	1,	54698,	'2019-03-16 03:59:51',	'Wootton',	'Wootton',	'Wootton'),
(2633580,	77,	2638655,	'Woore',	'Woore',	'Woore',	1,	54694,	'2019-03-16 03:59:51',	'Woore',	'Woore',	'Woore'),
(2633609,	77,	2651079,	'Wool',	'Wool',	'Wool',	1,	54687,	'2019-03-16 03:59:51',	'Wool',	'Wool',	'Wool'),
(2633615,	77,	2651346,	'Woodville',	'Woodville',	'Woodville',	1,	54675,	'2019-03-16 03:59:51',	'Woodville',	'Woodville',	'Woodville'),
(2633618,	77,	2640726,	'Вудсток',	'Woodstock',	'Woodstock',	1,	54671,	'2019-03-16 03:59:51',	'Woodstock',	'Woodstock',	'Woodstock'),
(2633622,	77,	3333144,	'Woodside',	'Woodside',	'Woodside',	1,	54659,	'2019-03-16 03:59:51',	'Woodside',	'Woodside',	'Woodside'),
(2633632,	77,	3333202,	'Woodley',	'Woodley',	'Woodley',	1,	54647,	'2019-03-16 03:59:51',	'Woodley',	'Woodley',	'Woodley'),
(2633640,	77,	3333193,	'Woodhouse',	'Woodhouse',	'Woodhouse',	1,	54628,	'2019-03-16 03:59:51',	'Woodhouse',	'Woodhouse',	'Woodhouse'),
(2633647,	77,	2649889,	'Woodham Mortimer',	'Woodham Mortimer',	'Woodham Mortimer',	1,	54626,	'2019-03-16 03:59:51',	'Woodham Mortimer',	'Woodham Mortimer',	'Woodham Mortimer'),
(2633649,	77,	2649889,	'Woodham Ferrers',	'Woodham Ferrers',	'Woodham Ferrers',	1,	54625,	'2019-03-16 03:59:51',	'Woodham Ferrers',	'Woodham Ferrers',	'Woodham Ferrers'),
(2633651,	77,	2644486,	'Woodhall Spa',	'Woodhall Spa',	'Woodhall Spa',	1,	54624,	'2019-03-16 03:59:51',	'Woodhall Spa',	'Woodhall Spa',	'Woodhall Spa'),
(2633655,	77,	2648110,	'Woodford Green',	'Woodford Green',	'Woodford Green',	1,	54622,	'2019-03-16 03:59:51',	'Woodford Green',	'Woodford Green',	'Woodford Green'),
(2633658,	77,	2648110,	'Woodford',	'Woodford',	'Woodford',	1,	54620,	'2019-03-16 03:59:51',	'Woodford',	'Woodford',	'Woodford'),
(2633665,	77,	3333220,	'Woodchurch',	'Woodchurch',	'Woodchurch',	1,	54618,	'2019-03-16 03:59:51',	'Woodchurch',	'Woodchurch',	'Woodchurch'),
(2633671,	77,	2636561,	'Woodbridge',	'Woodbridge',	'Woodbridge',	1,	54606,	'2019-03-16 03:59:51',	'Woodbridge',	'Woodbridge',	'Woodbridge'),
(2633675,	77,	2654408,	'Wooburn',	'Wooburn',	'Wooburn',	1,	54590,	'2019-03-16 03:59:51',	'Wooburn',	'Wooburn',	'Wooburn'),
(2633677,	77,	2636512,	'Wonersh',	'Wonersh',	'Wonersh',	1,	54587,	'2019-03-16 03:59:51',	'Wonersh',	'Wonersh',	'Wonersh'),
(2633691,	77,	3333222,	'Вулвергемптон',	'Wolverhampton',	'Wolverhampton',	1,	54580,	'2019-03-16 03:59:51',	'Wolverhampton',	'Wolverhampton',	'Wolverhampton'),
(2633693,	77,	2637141,	'Wolstanton',	'Wolstanton',	'Wolstanton',	1,	54576,	'2019-03-16 03:59:51',	'Wolstanton',	'Wolstanton',	'Wolstanton'),
(2633694,	77,	2650629,	'Wolsingham',	'Wolsingham',	'Wolsingham',	1,	54575,	'2019-03-16 03:59:51',	'Wolsingham',	'Wolsingham',	'Wolsingham'),
(2633699,	77,	2634723,	'Wolford',	'Wolford',	'Wolford',	1,	54551,	'2019-03-16 03:59:51',	'Wolford',	'Wolford',	'Wolford'),
(2633707,	77,	2636512,	'Woldingham',	'Woldingham',	'Woldingham',	1,	54528,	'2019-03-16 03:59:51',	'Woldingham',	'Woldingham',	'Woldingham'),
(2633708,	77,	3333221,	'Уокингхем',	'Wokingham',	'Wokingham',	1,	54519,	'2019-03-16 03:59:51',	'Wokingham',	'Wokingham',	'Wokingham'),
(2633709,	77,	2636512,	'Уокинге',	'Woking',	'Woking',	1,	54518,	'2019-03-16 03:59:51',	'Woking',	'Woking',	'Woking'),
(2633712,	77,	7290535,	'Woburn',	'Woburn',	'Woburn',	1,	54505,	'2019-03-16 03:59:51',	'Woburn',	'Woburn',	'Woburn'),
(2633717,	77,	2649889,	'Wivenhoe',	'Wivenhoe',	'Wivenhoe',	1,	54500,	'2019-03-16 03:59:51',	'Wivenhoe',	'Wivenhoe',	'Wivenhoe'),
(2633718,	77,	2650328,	'Wivelsfield Green',	'Wivelsfield Green',	'Wivelsfield Green',	1,	54499,	'2019-03-16 03:59:51',	'Wivelsfield Green',	'Wivelsfield Green',	'Wivelsfield Green'),
(2633729,	77,	2640726,	'Уитни',	'Witney',	'Witney',	1,	54455,	'2019-03-16 03:59:51',	'Witney',	'Witney',	'Witney'),
(2633731,	77,	2636512,	'Witley',	'Witley',	'Witley',	1,	54454,	'2019-03-16 03:59:51',	'Witley',	'Witley',	'Witley'),
(2633738,	77,	2638655,	'Withington',	'Withington',	'Withington',	1,	54453,	'2019-03-16 03:59:51',	'Withington',	'Withington',	'Withington'),
(2633743,	77,	2650345,	'Withernwick',	'Withernwick',	'Withernwick',	1,	54452,	'2019-03-16 03:59:51',	'Withernwick',	'Withernwick',	'Withernwick'),
(2633744,	77,	2650345,	'Уитернси',	'Withernsea',	'Withernsea',	1,	54451,	'2019-03-16 03:59:51',	'Withernsea',	'Withernsea',	'Withernsea'),
(2633749,	77,	2649889,	'Witham',	'Witham',	'Witham',	1,	54450,	'2019-03-16 03:59:51',	'Witham',	'Witham',	'Witham'),
(2633751,	77,	2653940,	'Witchford',	'Witchford',	'Witchford',	1,	54449,	'2019-03-16 03:59:51',	'Witchford',	'Witchford',	'Witchford'),
(2633765,	77,	3333233,	'Wishaw',	'Wishaw',	'Wishaw',	1,	54437,	'2019-03-16 03:59:51',	'Wishaw',	'Wishaw',	'Wishaw'),
(2633767,	77,	2634258,	'Wisborough Green',	'Wisborough Green',	'Wisborough Green',	1,	54427,	'2019-03-16 03:59:51',	'Wisborough Green',	'Wisborough Green',	'Wisborough Green'),
(2633771,	77,	2653940,	'Визбич',	'Wisbech',	'Wisbech',	1,	54426,	'2019-03-16 03:59:51',	'Wisbech',	'Wisbech',	'Wisbech'),
(2633774,	77,	2651346,	'Wirksworth',	'Wirksworth',	'Wirksworth',	1,	54421,	'2019-03-16 03:59:51',	'Wirksworth',	'Wirksworth',	'Wirksworth'),
(2633778,	77,	2651712,	'Winton',	'Winton',	'Winton',	1,	54406,	'2019-03-16 03:59:51',	'Winton',	'Winton',	'Winton'),
(2633786,	77,	3333176,	'Winterton',	'Winterton',	'Winterton',	1,	54395,	'2019-03-16 03:59:51',	'Winterton',	'Winterton',	'Winterton'),
(2633787,	77,	2641455,	'Winterton-on-Sea',	'Winterton-on-Sea',	'Winterton-on-Sea',	1,	54396,	'2019-03-16 03:59:51',	'Winterton-on-Sea',	'Winterton-on-Sea',	'Winterton-on-Sea'),
(2633795,	77,	2633868,	'Winterbourne Dauntsey',	'Winterbourne Dauntsey',	'Winterbourne Dauntsey',	1,	54383,	'2019-03-16 03:59:51',	'Winterbourne Dauntsey',	'Winterbourne Dauntsey',	'Winterbourne Dauntsey'),
(2633801,	77,	2651079,	'Winterborne Kingston',	'Winterborne Kingston',	'Winterborne Kingston',	1,	54382,	'2019-03-16 03:59:51',	'Winterborne Kingston',	'Winterborne Kingston',	'Winterborne Kingston'),
(2633808,	77,	2654408,	'Winslow',	'Winslow',	'Winslow',	1,	54363,	'2019-03-16 03:59:51',	'Winslow',	'Winslow',	'Winslow'),
(2633810,	77,	7290537,	'Winsford',	'Winsford',	'Winsford',	1,	54359,	'2019-03-16 03:59:51',	'Winsford',	'Winsford',	'Winsford'),
(2633814,	77,	3333221,	'Winnersh',	'Winnersh',	'Winnersh',	1,	54338,	'2019-03-16 03:59:51',	'Winnersh',	'Winnersh',	'Winnersh'),
(2633816,	77,	2648772,	'Winlaton',	'Winlaton',	'Winlaton',	1,	54324,	'2019-03-16 03:59:51',	'Winlaton',	'Winlaton',	'Winlaton'),
(2633818,	77,	2651292,	'Winkleigh',	'Winkleigh',	'Winkleigh',	1,	54322,	'2019-03-16 03:59:51',	'Winkleigh',	'Winkleigh',	'Winkleigh'),
(2633819,	77,	3333130,	'Winkfield',	'Winkfield',	'Winkfield',	1,	54321,	'2019-03-16 03:59:51',	'Winkfield',	'Winkfield',	'Winkfield'),
(2633820,	77,	2654408,	'Wingrave',	'Wingrave',	'Wingrave',	1,	54311,	'2019-03-16 03:59:51',	'Wingrave',	'Wingrave',	'Wingrave'),
(2633822,	77,	2636561,	'Wingfield',	'Wingfield',	'Wingfield',	1,	54307,	'2019-03-16 03:59:51',	'Wingfield',	'Wingfield',	'Wingfield'),
(2633833,	77,	2647071,	'Winforton',	'Winforton',	'Winforton',	1,	54299,	'2019-03-16 03:59:51',	'Winforton',	'Winforton',	'Winforton'),
(2633835,	77,	2641455,	'Winfarthing',	'Winfarthing',	'Winfarthing',	1,	54291,	'2019-03-16 03:59:51',	'Winfarthing',	'Winfarthing',	'Winfarthing'),
(2633842,	77,	2633840,	'Виндзор',	'Windsor',	'Windsor',	1,	54279,	'2019-03-16 03:59:51',	'Windsor',	'Windsor',	'Windsor'),
(2633849,	77,	2636512,	'Windlesham',	'Windlesham',	'Windlesham',	1,	54262,	'2019-03-16 03:59:51',	'Windlesham',	'Windlesham',	'Windlesham'),
(2633851,	77,	2651712,	'Windermere',	'Windermere',	'Windermere',	1,	54248,	'2019-03-16 03:59:51',	'Windermere',	'Windermere',	'Windermere'),
(2633856,	77,	2648110,	'Winchmore Hill',	'Winchmore Hill',	'Winchmore Hill',	1,	54237,	'2019-03-16 03:59:51',	'Winchmore Hill',	'Winchmore Hill',	'Winchmore Hill'),
(2633858,	77,	2647554,	'Винчестер',	'Winchester',	'Winchester',	1,	54233,	'2019-03-16 03:59:51',	'Winchester',	'Winchester',	'Winchester'),
(2633859,	77,	2650328,	'Winchelsea',	'Winchelsea',	'Winchelsea',	1,	54221,	'2019-03-16 03:59:51',	'Winchelsea',	'Winchelsea',	'Winchelsea'),
(2633860,	77,	2648402,	'Winchcombe',	'Winchcombe',	'Winchcombe',	1,	54220,	'2019-03-16 03:59:51',	'Winchcombe',	'Winchcombe',	'Winchcombe'),
(2633861,	77,	2637532,	'Wincanton',	'Wincanton',	'Wincanton',	1,	54219,	'2019-03-16 03:59:51',	'Wincanton',	'Wincanton',	'Wincanton'),
(2633863,	77,	2651079,	'Wimborne Minster',	'Wimborne Minster',	'Wimborne Minster',	1,	54211,	'2019-03-16 03:59:51',	'Wimborne Minster',	'Wimborne Minster',	'Wimborne Minster'),
(2633864,	77,	2653940,	'Wimblington',	'Wimblington',	'Wimblington',	1,	54210,	'2019-03-16 03:59:51',	'Wimblington',	'Wimblington',	'Wimblington'),
(2633866,	77,	2648110,	'Уимблдон',	'Wimbledon',	'Wimbledon',	1,	54208,	'2019-03-16 03:59:51',	'Wimbledon',	'Wimbledon',	'Wimbledon'),
(2633878,	77,	7290534,	'Wilshamstead',	'Wilshamstead',	'Wilshamstead',	1,	54178,	'2019-03-16 03:59:51',	'Wilshamstead',	'Wilshamstead',	'Wilshamstead'),
(2633882,	77,	2637141,	'Wilnecote',	'Wilnecote',	'Wilnecote',	1,	54172,	'2019-03-16 03:59:51',	'Wilnecote',	'Wilnecote',	'Wilnecote'),
(2633883,	77,	7290536,	'Wilmslow',	'Wilmslow',	'Wilmslow',	1,	54171,	'2019-03-16 03:59:51',	'Wilmslow',	'Wilmslow',	'Wilmslow'),
(2633885,	77,	3333158,	'Wilmington',	'Wilmington',	'Wilmington',	1,	54157,	'2019-03-16 03:59:51',	'Wilmington',	'Wilmington',	'Wilmington'),
(2633887,	77,	2634723,	'Wilmcote',	'Wilmcote',	'Wilmcote',	1,	54152,	'2019-03-16 03:59:51',	'Wilmcote',	'Wilmcote',	'Wilmcote'),
(2633903,	77,	3333178,	'Wilford',	'Wilford',	'Wilford',	1,	54041,	'2019-03-16 03:59:51',	'Wilford',	'Wilford',	'Wilford'),
(2633907,	77,	2648110,	'Willesden',	'Willesden',	'Willesden',	1,	54069,	'2019-03-16 03:59:51',	'Willesden',	'Willesden',	'Willesden'),
(2633912,	77,	3333213,	'Willenhall',	'Willenhall',	'Willenhall',	1,	54066,	'2019-03-16 03:59:51',	'Willenhall',	'Willenhall',	'Willenhall'),
(2633917,	77,	7290534,	'Wilden',	'Wilden',	'Wilden',	1,	54016,	'2019-03-16 03:59:51',	'Wilden',	'Wilden',	'Wilden'),
(2633923,	77,	2636561,	'Wilby',	'Wilby',	'Wilby',	1,	54009,	'2019-03-16 03:59:51',	'Wilby',	'Wilby',	'Wilby'),
(2633924,	77,	2641429,	'Wilby',	'Wilby',	'Wilby',	1,	54008,	'2019-03-16 03:59:51',	'Wilby',	'Wilby',	'Wilby'),
(2633925,	77,	2653940,	'Wilburton',	'Wilburton',	'Wilburton',	1,	54006,	'2019-03-16 03:59:51',	'Wilburton',	'Wilburton',	'Wilburton'),
(2633933,	77,	2651712,	'Wigton',	'Wigton',	'Wigton',	1,	53998,	'2019-03-16 03:59:51',	'Wigton',	'Wigton',	'Wigton'),
(2633936,	77,	2644667,	'Wigston Magna',	'Wigston Magna',	'Wigston Magna',	1,	53997,	'2019-03-16 03:59:51',	'Wigston Magna',	'Wigston Magna',	'Wigston Magna'),
(2633948,	77,	3333219,	'Уиган',	'Wigan',	'Wigan',	1,	53993,	'2019-03-16 03:59:51',	'Wigan',	'Wigan',	'Wigan'),
(2633954,	77,	2647601,	'Widnes',	'Widnes',	'Widnes',	1,	53950,	'2019-03-16 03:59:51',	'Widnes',	'Widnes',	'Widnes'),
(2633956,	77,	2647043,	'Widford',	'Widford',	'Widford',	1,	53949,	'2019-03-16 03:59:51',	'Widford',	'Widford',	'Widford'),
(2633972,	77,	2636561,	'Wickhambrook',	'Wickhambrook',	'Wickhambrook',	1,	53941,	'2019-03-16 03:59:51',	'Wickhambrook',	'Wickhambrook',	'Wickhambrook'),
(2633975,	77,	2647554,	'Wickham',	'Wickham',	'Wickham',	1,	53940,	'2019-03-16 03:59:51',	'Wickham',	'Wickham',	'Wickham'),
(2633976,	77,	2649889,	'Wickford',	'Wickford',	'Wickford',	1,	53939,	'2019-03-16 03:59:51',	'Wickford',	'Wickford',	'Wickford'),
(2633977,	77,	3333189,	'Wickersley',	'Wickersley',	'Wickersley',	1,	53935,	'2019-03-16 03:59:51',	'Wickersley',	'Wickersley',	'Wickersley'),
(2633979,	77,	2649889,	'Wicken Bonhunt',	'Wicken Bonhunt',	'Wicken Bonhunt',	1,	53931,	'2019-03-16 03:59:51',	'Wicken Bonhunt',	'Wicken Bonhunt',	'Wicken Bonhunt'),
(2633980,	77,	2653940,	'Wicken',	'Wicken',	'Wicken',	1,	53930,	'2019-03-16 03:59:51',	'Wicken',	'Wicken',	'Wicken'),
(2633982,	77,	2646944,	'Уик',	'Wick',	'Wick',	1,	53928,	'2019-03-16 03:59:51',	'Wick',	'Wick',	'Wick'),
(2633986,	77,	2634258,	'Wick',	'Wick',	'Wick',	1,	53927,	'2019-03-16 03:59:51',	'Wick',	'Wick',	'Wick'),
(2633993,	77,	2648110,	'Whyteleafe',	'Whyteleafe',	'Whyteleafe',	1,	53922,	'2019-03-16 03:59:51',	'Whyteleafe',	'Whyteleafe',	'Whyteleafe'),
(2633996,	77,	2638655,	'Whixall',	'Whixall',	'Whixall',	1,	53921,	'2019-03-16 03:59:51',	'Whixall',	'Whixall',	'Whixall'),
(2633997,	77,	2644974,	'Whitworth',	'Whitworth',	'Whitworth',	1,	53920,	'2019-03-16 03:59:51',	'Whitworth',	'Whitworth',	'Whitworth'),
(2633998,	77,	2644667,	'Whitwick',	'Whitwick',	'Whitwick',	1,	53919,	'2019-03-16 03:59:51',	'Whitwick',	'Whitwick',	'Whitwick'),
(2634004,	77,	2648110,	'Whitton',	'Whitton',	'Whitton',	1,	53917,	'2019-03-16 03:59:51',	'Whitton',	'Whitton',	'Whitton'),
(2634010,	77,	2653940,	'Whittlesey',	'Whittlesey',	'Whittlesey',	1,	53916,	'2019-03-16 03:59:51',	'Whittlesey',	'Whittlesey',	'Whittlesey'),
(2634011,	77,	2641429,	'Whittlebury',	'Whittlebury',	'Whittlebury',	1,	53915,	'2019-03-16 03:59:51',	'Whittlebury',	'Whittlebury',	'Whittlebury'),
(2634021,	77,	3333158,	'Уитстабл',	'Whitstable',	'Whitstable',	1,	53908,	'2019-03-16 03:59:51',	'Whitstable',	'Whitstable',	'Whitstable'),
(2634032,	77,	2641238,	'Whitley Bay',	'Whitley Bay',	'Whitley Bay',	1,	53895,	'2019-03-16 03:59:51',	'Whitley Bay',	'Whitley Bay',	'Whitley Bay'),
(2634035,	77,	2653753,	'Whitland',	'Whitland',	'Whitland',	1,	53894,	'2019-03-16 03:59:51',	'Whitland',	'Whitland',	'Whitland'),
(2634087,	77,	2657830,	'Whitehouse',	'Whitehouse',	'Whitehouse',	1,	53863,	'2019-03-16 03:59:51',	'Whitehouse',	'Whitehouse',	'Whitehouse'),
(2634096,	77,	2651712,	'Whitehaven',	'Whitehaven',	'Whitehaven',	1,	53859,	'2019-03-16 03:59:51',	'Whitehaven',	'Whitehaven',	'Whitehaven'),
(2634103,	77,	3333136,	'Whitefield',	'Whitefield',	'Whitefield',	1,	53848,	'2019-03-16 03:59:51',	'Whitefield',	'Whitefield',	'Whitefield'),
(2634124,	77,	2638655,	'Whitchurch',	'Whitchurch',	'Whitchurch',	1,	53800,	'2019-03-16 03:59:51',	'Whitchurch',	'Whitchurch',	'Whitchurch'),
(2634130,	77,	2647554,	'Whitchurch',	'Whitchurch',	'Whitchurch',	1,	53801,	'2019-03-16 03:59:51',	'Whitchurch',	'Whitchurch',	'Whitchurch'),
(2634135,	77,	2641209,	'Уитби',	'Whitby',	'Whitby',	1,	53799,	'2019-03-16 03:59:51',	'Whitby',	'Whitby',	'Whitby'),
(2634138,	77,	3333199,	'Whitburn',	'Whitburn',	'Whitburn',	1,	53798,	'2019-03-16 03:59:51',	'Whitburn',	'Whitburn',	'Whitburn'),
(2634147,	77,	2644486,	'Whisby',	'Whisby',	'Whisby',	1,	53796,	'2019-03-16 03:59:51',	'Whisby',	'Whisby',	'Whisby'),
(2634155,	77,	2648772,	'Whickham',	'Whickham',	'Whickham',	1,	53793,	'2019-03-16 03:59:51',	'Whickham',	'Whickham',	'Whickham'),
(2634170,	77,	2637141,	'Wheaton Aston',	'Wheaton Aston',	'Wheaton Aston',	1,	53785,	'2019-03-16 03:59:51',	'Wheaton Aston',	'Wheaton Aston',	'Wheaton Aston'),
(2634171,	77,	2640726,	'Wheatley',	'Wheatley',	'Wheatley',	1,	53782,	'2019-03-16 03:59:51',	'Wheatley',	'Wheatley',	'Wheatley'),
(2634172,	77,	2647043,	'Wheathampstead',	'Wheathampstead',	'Wheathampstead',	1,	53777,	'2019-03-16 03:59:51',	'Wheathampstead',	'Wheathampstead',	'Wheathampstead'),
(2634192,	77,	2644974,	'Whalley',	'Whalley',	'Whalley',	1,	53768,	'2019-03-16 03:59:51',	'Whalley',	'Whalley',	'Whalley'),
(2634194,	77,	2651346,	'Whaley Bridge',	'Whaley Bridge',	'Whaley Bridge',	1,	53767,	'2019-03-16 03:59:51',	'Whaley Bridge',	'Whaley Bridge',	'Whaley Bridge'),
(2634202,	77,	2651079,	'Уэймут',	'Weymouth',	'Weymouth',	1,	53766,	'2019-03-16 03:59:51',	'Weymouth',	'Weymouth',	'Weymouth'),
(2634204,	77,	2636512,	'Вейбридж',	'Weybridge',	'Weybridge',	1,	53757,	'2019-03-16 03:59:51',	'Weybridge',	'Weybridge',	'Weybridge'),
(2634212,	77,	2649889,	'Wethersfield',	'Wethersfield',	'Wethersfield',	1,	53737,	'2019-03-16 03:59:51',	'Wethersfield',	'Wethersfield',	'Wethersfield'),
(2634213,	77,	2636561,	'Wetheringsett',	'Wetheringsett',	'Wetheringsett',	1,	53735,	'2019-03-16 03:59:51',	'Wetheringsett',	'Wetheringsett',	'Wetheringsett'),
(2634217,	77,	3333164,	'Уэзерби',	'Wetherby',	'Wetherby',	1,	53734,	'2019-03-16 03:59:51',	'Wetherby',	'Wetherby',	'Wetherby'),
(2634234,	77,	2648110,	'Вест-Уикхэм',	'West Wickham',	'West Wickham',	1,	53605,	'2019-03-16 03:59:51',	'West Wickham',	'West Wickham',	'West Wickham'),
(2634251,	77,	3333158,	'West Thurrock',	'West Thurrock',	'West Thurrock',	1,	53589,	'2019-03-16 03:59:51',	'West Thurrock',	'West Thurrock',	'West Thurrock'),
(2634279,	77,	2636561,	'West Row',	'West Row',	'West Row',	1,	53571,	'2019-03-16 03:59:51',	'West Row',	'West Row',	'West Row'),
(2634283,	77,	2641455,	'West Raynham',	'West Raynham',	'West Raynham',	1,	53567,	'2019-03-16 03:59:51',	'West Raynham',	'West Raynham',	'West Raynham'),
(2634296,	77,	2651079,	'West Parley',	'West Parley',	'West Parley',	1,	53555,	'2019-03-16 03:59:51',	'West Parley',	'West Parley',	'West Parley'),
(2634300,	77,	2637532,	'Westonzoyland',	'Westonzoyland',	'Westonzoyland',	1,	53711,	'2019-03-16 03:59:51',	'Westonzoyland',	'Westonzoyland',	'Westonzoyland'),
(2634306,	77,	2637141,	'Weston under Lizard',	'Weston under Lizard',	'Weston under Lizard',	1,	53708,	'2019-03-16 03:59:51',	'Weston under Lizard',	'Weston under Lizard',	'Weston under Lizard'),
(2634308,	77,	3333177,	'Уэстон-сьюпер-Мэр',	'Weston-super-Mare',	'Weston-super-Mare',	1,	53709,	'2019-03-16 03:59:51',	'Weston-super-Mare',	'Weston-super-Mare',	'Weston-super-Mare'),
(2634316,	77,	3333177,	'Weston in Gordano',	'Weston in Gordano',	'Weston in Gordano',	1,	53707,	'2019-03-16 03:59:51',	'Weston in Gordano',	'Weston in Gordano',	'Weston in Gordano'),
(2634317,	77,	7290535,	'Westoning',	'Westoning',	'Westoning',	1,	53710,	'2019-03-16 03:59:51',	'Westoning',	'Westoning',	'Westoning'),
(2634322,	77,	7290536,	'Weston',	'Weston',	'Weston',	1,	53701,	'2019-03-16 03:59:51',	'Weston',	'Weston',	'Weston'),
(2634340,	77,	2636512,	'West Molesey',	'West Molesey',	'West Molesey',	1,	53538,	'2019-03-16 03:59:51',	'West Molesey',	'West Molesey',	'West Molesey'),
(2634341,	77,	2648110,	'City of Westminster',	'City of Westminster',	'City of Westminster',	1,	10589,	'2019-03-16 03:59:51',	'City of Westminster',	'City of Westminster',	'City of Westminster'),
(2634342,	77,	2647043,	'Westmill',	'Westmill',	'Westmill',	1,	53686,	'2019-03-16 03:59:51',	'Westmill',	'Westmill',	'Westmill'),
(2634345,	77,	2649889,	'West Mersea',	'West Mersea',	'West Mersea',	1,	53529,	'2019-03-16 03:59:51',	'West Mersea',	'West Mersea',	'West Mersea'),
(2634349,	77,	3333158,	'West Malling',	'West Malling',	'West Malling',	1,	53525,	'2019-03-16 03:59:51',	'West Malling',	'West Malling',	'West Malling'),
(2634351,	77,	2637532,	'West Lydford',	'West Lydford',	'West Lydford',	1,	53524,	'2019-03-16 03:59:51',	'West Lydford',	'West Lydford',	'West Lydford'),
(2634360,	77,	2655192,	'West Linton',	'West Linton',	'West Linton',	1,	53521,	'2019-03-16 03:59:51',	'West Linton',	'West Linton',	'West Linton'),
(2634366,	77,	2651292,	'Westleigh',	'Westleigh',	'Westleigh',	1,	53684,	'2019-03-16 03:59:51',	'Westleigh',	'Westleigh',	'Westleigh'),
(2634371,	77,	3333158,	'West Langdon',	'West Langdon',	'West Langdon',	1,	53512,	'2019-03-16 03:59:51',	'West Langdon',	'West Langdon',	'West Langdon'),
(2634373,	77,	2650629,	'West Kyo',	'West Kyo',	'West Kyo',	1,	53509,	'2019-03-16 03:59:51',	'West Kyo',	'West Kyo',	'West Kyo'),
(2634375,	77,	3333220,	'West Kirby',	'West Kirby',	'West Kirby',	1,	53508,	'2019-03-16 03:59:51',	'West Kirby',	'West Kirby',	'West Kirby'),
(2634378,	77,	3333232,	'West Kilbride',	'West Kilbride',	'West Kilbride',	1,	53506,	'2019-03-16 03:59:51',	'West Kilbride',	'West Kilbride',	'West Kilbride'),
(2634387,	77,	3333128,	'Westhoughton',	'Westhoughton',	'Westhoughton',	1,	53677,	'2019-03-16 03:59:51',	'Westhoughton',	'Westhoughton',	'Westhoughton'),
(2634388,	77,	2636512,	'West Horsley',	'West Horsley',	'West Horsley',	1,	53500,	'2019-03-16 03:59:51',	'West Horsley',	'West Horsley',	'West Horsley'),
(2634398,	77,	3333123,	'West Harptree',	'West Harptree',	'West Harptree',	1,	53489,	'2019-03-16 03:59:51',	'West Harptree',	'West Harptree',	'West Harptree'),
(2634414,	77,	2650629,	'Westgate',	'Westgate',	'Westgate',	1,	53668,	'2019-03-16 03:59:51',	'Westgate',	'Westgate',	'Westgate'),
(2634419,	77,	2650328,	'Westfield',	'Westfield',	'Westfield',	1,	53663,	'2019-03-16 03:59:51',	'Westfield',	'Westfield',	'Westfield'),
(2634434,	77,	3333158,	'Westerham',	'Westerham',	'Westerham',	1,	53635,	'2019-03-16 03:59:51',	'Westerham',	'Westerham',	'Westerham'),
(2634442,	77,	2641209,	'Westerdale',	'Westerdale',	'Westerdale',	1,	53632,	'2019-03-16 03:59:51',	'Westerdale',	'Westerdale',	'Westerdale'),
(2634447,	77,	2647554,	'West End',	'West End',	'West End',	1,	53473,	'2019-03-16 03:59:51',	'West End',	'West End',	'West End'),
(2634449,	77,	2648110,	'West Dulwich',	'West Dulwich',	'West Dulwich',	1,	53468,	'2019-03-16 03:59:51',	'West Dulwich',	'West Dulwich',	'West Dulwich'),
(2634450,	77,	2641169,	'West Drayton',	'West Drayton',	'West Drayton',	1,	53466,	'2019-03-16 03:59:51',	'West Drayton',	'West Drayton',	'West Drayton'),
(2634451,	77,	2648110,	'West Drayton',	'West Drayton',	'West Drayton',	1,	53467,	'2019-03-16 03:59:51',	'West Drayton',	'West Drayton',	'West Drayton'),
(2634455,	77,	3333167,	'West Derby',	'West Derby',	'West Derby',	1,	53463,	'2019-03-16 03:59:51',	'West Derby',	'West Derby',	'West Derby'),
(2634471,	77,	2637532,	'West Chinnock',	'West Chinnock',	'West Chinnock',	1,	53449,	'2019-03-16 03:59:51',	'West Chinnock',	'West Chinnock',	'West Chinnock'),
(2634472,	77,	2634258,	'West Chiltington',	'West Chiltington',	'West Chiltington',	1,	53448,	'2019-03-16 03:59:51',	'West Chiltington',	'West Chiltington',	'West Chiltington'),
(2634477,	77,	2634354,	'West Calder',	'West Calder',	'West Calder',	1,	53440,	'2019-03-16 03:59:51',	'West Calder',	'West Calder',	'West Calder'),
(2634478,	77,	2636512,	'West Byfleet',	'West Byfleet',	'West Byfleet',	1,	53439,	'2019-03-16 03:59:51',	'West Byfleet',	'West Byfleet',	'West Byfleet'),
(2634480,	77,	2648402,	'Westbury on Severn',	'Westbury on Severn',	'Westbury on Severn',	1,	53619,	'2019-03-16 03:59:51',	'Westbury on Severn',	'Westbury on Severn',	'Westbury on Severn'),
(2634483,	77,	2633868,	'Westbury',	'Westbury',	'Westbury',	1,	53618,	'2019-03-16 03:59:51',	'Westbury',	'Westbury',	'Westbury'),
(2634484,	77,	2637532,	'Westbury-sub-Mendip',	'Westbury-sub-Mendip',	'Westbury-sub-Mendip',	1,	53620,	'2019-03-16 03:59:51',	'Westbury-sub-Mendip',	'Westbury-sub-Mendip',	'Westbury-sub-Mendip'),
(2634491,	77,	3333191,	'Уэст-Бромидж',	'West Bromwich',	'West Bromwich',	1,	53434,	'2019-03-16 03:59:51',	'West Bromwich',	'West Bromwich',	'West Bromwich'),
(2634493,	77,	2641169,	'West Bridgford',	'West Bridgford',	'West Bridgford',	1,	53433,	'2019-03-16 03:59:51',	'West Bridgford',	'West Bridgford',	'West Bridgford'),
(2634497,	77,	2634258,	'Westbourne',	'Westbourne',	'Westbourne',	1,	53612,	'2019-03-16 03:59:51',	'Westbourne',	'Westbourne',	'Westbourne'),
(2634498,	77,	3333199,	'West Boldon',	'West Boldon',	'West Boldon',	1,	53426,	'2019-03-16 03:59:51',	'West Boldon',	'West Boldon',	'West Boldon'),
(2634522,	77,	2641455,	'Wereham',	'Wereham',	'Wereham',	1,	53375,	'2019-03-16 03:59:51',	'Wereham',	'Wereham',	'Wereham'),
(2634524,	77,	2647071,	'Weobley',	'Weobley',	'Weobley',	1,	53366,	'2019-03-16 03:59:51',	'Weobley',	'Weobley',	'Weobley'),
(2634527,	77,	3333189,	'Wentworth',	'Wentworth',	'Wentworth',	1,	53360,	'2019-03-16 03:59:51',	'Wentworth',	'Wentworth',	'Wentworth'),
(2634538,	77,	2654408,	'Wendover',	'Wendover',	'Wendover',	1,	53347,	'2019-03-16 03:59:51',	'Wendover',	'Wendover',	'Wendover'),
(2634540,	77,	2640726,	'Wendlebury',	'Wendlebury',	'Wendlebury',	1,	53344,	'2019-03-16 03:59:51',	'Wendlebury',	'Wendlebury',	'Wendlebury'),
(2634545,	77,	2646127,	'Wemyss Bay',	'Wemyss Bay',	'Wemyss Bay',	1,	53326,	'2019-03-16 03:59:51',	'Wemyss Bay',	'Wemyss Bay',	'Wemyss Bay'),
(2634549,	77,	2648110,	'Уэмбли',	'Wembley',	'Wembley',	1,	53324,	'2019-03-16 03:59:51',	'Wembley',	'Wembley',	'Wembley'),
(2634550,	77,	2638655,	'Wem',	'Wem',	'Wem',	1,	53323,	'2019-03-16 03:59:51',	'Wem',	'Wem',	'Wem'),
(2634552,	77,	2647043,	'Уэлин-Гарден-Сити',	'Welwyn Garden City',	'Welwyn Garden City',	1,	53320,	'2019-03-16 03:59:51',	'Welwyn Garden City',	'Welwyn Garden City',	'Welwyn Garden City'),
(2634553,	77,	2647043,	'Welwyn',	'Welwyn',	'Welwyn',	1,	53319,	'2019-03-16 03:59:51',	'Welwyn',	'Welwyn',	'Welwyn'),
(2634558,	77,	2644486,	'Welton',	'Welton',	'Welton',	1,	53317,	'2019-03-16 03:59:51',	'Welton',	'Welton',	'Welton'),
(2634560,	77,	2639944,	'Welshpool',	'Welshpool',	'Welshpool',	1,	53315,	'2019-03-16 03:59:51',	'Welshpool',	'Welshpool',	'Welshpool'),
(2634567,	77,	2641455,	'Wells-next-the-Sea',	'Wells-next-the-Sea',	'Wells-next-the-Sea',	1,	53297,	'2019-03-16 03:59:51',	'Wells-next-the-Sea',	'Wells-next-the-Sea',	'Wells-next-the-Sea'),
(2634569,	77,	2637532,	'Уэлс',	'Wells',	'Wells',	1,	53291,	'2019-03-16 03:59:51',	'Wells',	'Wells',	'Wells'),
(2634573,	77,	3333209,	'Веллингтон',	'Wellington',	'Wellington',	1,	53274,	'2019-03-16 03:59:51',	'Wellington',	'Wellington',	'Wellington'),
(2634574,	77,	2647071,	'Wellington',	'Wellington',	'Wellington',	1,	53281,	'2019-03-16 03:59:51',	'Wellington',	'Wellington',	'Wellington'),
(2634575,	77,	2637532,	'Wellington',	'Wellington',	'Wellington',	1,	53276,	'2019-03-16 03:59:51',	'Wellington',	'Wellington',	'Wellington'),
(2634576,	77,	2644486,	'Wellingore',	'Wellingore',	'Wellingore',	1,	53273,	'2019-03-16 03:59:51',	'Wellingore',	'Wellingore',	'Wellingore'),
(2634578,	77,	2641429,	'Веллингборо',	'Wellingborough',	'Wellingborough',	1,	53272,	'2019-03-16 03:59:51',	'Wellingborough',	'Wellingborough',	'Wellingborough'),
(2634579,	77,	2648110,	'Welling',	'Welling',	'Welling',	1,	53270,	'2019-03-16 03:59:51',	'Welling',	'Welling',	'Welling'),
(2634582,	77,	2634723,	'Wellesbourne Hastings',	'Wellesbourne Hastings',	'Wellesbourne Hastings',	1,	53264,	'2019-03-16 03:59:51',	'Wellesbourne Hastings',	'Wellesbourne Hastings',	'Wellesbourne Hastings'),
(2634589,	77,	2641429,	'Welford',	'Welford',	'Welford',	1,	53260,	'2019-03-16 03:59:51',	'Welford',	'Welford',	'Welford'),
(2634591,	77,	2641429,	'Weldon',	'Weldon',	'Weldon',	1,	53255,	'2019-03-16 03:59:51',	'Weldon',	'Weldon',	'Weldon'),
(2634602,	77,	2644974,	'Weeton',	'Weeton',	'Weeton',	1,	53136,	'2019-03-16 03:59:51',	'Weeton',	'Weeton',	'Weeton'),
(2634613,	77,	2641429,	'Weedon Beck',	'Weedon Beck',	'Weedon Beck',	1,	53125,	'2019-03-16 03:59:51',	'Weedon Beck',	'Weedon Beck',	'Weedon Beck'),
(2634616,	77,	3333222,	'Wednesfield',	'Wednesfield',	'Wednesfield',	1,	53123,	'2019-03-16 03:59:51',	'Wednesfield',	'Wednesfield',	'Wednesfield'),
(2634617,	77,	3333191,	'Wednesbury',	'Wednesbury',	'Wednesbury',	1,	53122,	'2019-03-16 03:59:51',	'Wednesbury',	'Wednesbury',	'Wednesbury'),
(2634618,	77,	2637532,	'Wedmore',	'Wedmore',	'Wedmore',	1,	53121,	'2019-03-16 03:59:51',	'Wedmore',	'Wedmore',	'Wedmore'),
(2634639,	77,	3333158,	'Weald',	'Weald',	'Weald',	1,	53087,	'2019-03-16 03:59:51',	'Weald',	'Weald',	'Weald'),
(2634662,	77,	2641455,	'Watton',	'Watton',	'Watton',	1,	52999,	'2019-03-16 03:59:51',	'Watton',	'Watton',	'Watton'),
(2634670,	77,	2641455,	'Watlington',	'Watlington',	'Watlington',	1,	52986,	'2019-03-16 03:59:51',	'Watlington',	'Watlington',	'Watlington'),
(2634671,	77,	2640726,	'Watlington',	'Watlington',	'Watlington',	1,	52985,	'2019-03-16 03:59:51',	'Watlington',	'Watlington',	'Watlington'),
(2634672,	77,	3333189,	'Wath upon Dearne',	'Wath upon Dearne',	'Wath upon Dearne',	1,	52978,	'2019-03-16 03:59:51',	'Wath upon Dearne',	'Wath upon Dearne',	'Wath upon Dearne'),
(2634677,	77,	2647043,	'Уотфорд',	'Watford',	'Watford',	1,	52976,	'2019-03-16 03:59:51',	'Watford',	'Watford',	'Watford'),
(2634682,	77,	2634723,	'Water Orton',	'Water Orton',	'Water Orton',	1,	52928,	'2019-03-16 03:59:51',	'Water Orton',	'Water Orton',	'Water Orton'),
(2634686,	77,	2647554,	'Уотерлувиль',	'Waterlooville',	'Waterlooville',	1,	52956,	'2019-03-16 03:59:51',	'Waterlooville',	'Waterlooville',	'Waterlooville'),
(2634701,	77,	2653940,	'Waterbeach',	'Waterbeach',	'Waterbeach',	1,	52932,	'2019-03-16 03:59:51',	'Waterbeach',	'Waterbeach',	'Waterbeach'),
(2634703,	77,	2640726,	'Watchfield',	'Watchfield',	'Watchfield',	1,	52925,	'2019-03-16 03:59:51',	'Watchfield',	'Watchfield',	'Watchfield'),
(2634704,	77,	2637532,	'Watchet',	'Watchet',	'Watchet',	1,	52924,	'2019-03-16 03:59:51',	'Watchet',	'Watchet',	'Watchet'),
(2634715,	77,	3333205,	'Вашингтон',	'Washington',	'Washington',	1,	52871,	'2019-03-16 03:59:51',	'Washington',	'Washington',	'Washington'),
(2634716,	77,	2634258,	'Washington',	'Washington',	'Washington',	1,	52888,	'2019-03-16 03:59:51',	'Washington',	'Washington',	'Washington'),
(2634725,	77,	2634723,	'Уорик',	'Warwick',	'Warwick',	1,	52858,	'2019-03-16 03:59:51',	'Warwick',	'Warwick',	'Warwick'),
(2634738,	77,	2647554,	'Warsash',	'Warsash',	'Warsash',	1,	52835,	'2019-03-16 03:59:51',	'Warsash',	'Warsash',	'Warsash'),
(2634739,	77,	3333216,	'Уоррингтон',	'Warrington',	'Warrington',	1,	52829,	'2019-03-16 03:59:51',	'Warrington',	'Warrington',	'Warrington'),
(2634755,	77,	2633868,	'Warminster',	'Warminster',	'Warminster',	1,	52785,	'2019-03-16 03:59:51',	'Warminster',	'Warminster',	'Warminster'),
(2634756,	77,	2641429,	'Warmington',	'Warmington',	'Warmington',	1,	52784,	'2019-03-16 03:59:51',	'Warmington',	'Warmington',	'Warmington'),
(2634759,	77,	2636512,	'Warlingham',	'Warlingham',	'Warlingham',	1,	52777,	'2019-03-16 03:59:51',	'Warlingham',	'Warlingham',	'Warlingham'),
(2634772,	77,	3333221,	'Wargrave',	'Wargrave',	'Wargrave',	1,	52774,	'2019-03-16 03:59:51',	'Wargrave',	'Wargrave',	'Wargrave'),
(2634773,	77,	3333130,	'Warfield',	'Warfield',	'Warfield',	1,	52771,	'2019-03-16 03:59:51',	'Warfield',	'Warfield',	'Warfield'),
(2634777,	77,	2647043,	'Вэр',	'Ware',	'Ware',	1,	52762,	'2019-03-16 03:59:51',	'Ware',	'Ware',	'Ware'),
(2634799,	77,	2641429,	'Wappenham',	'Wappenham',	'Wappenham',	1,	52743,	'2019-03-16 03:59:51',	'Wappenham',	'Wappenham',	'Wappenham'),
(2634801,	77,	2640726,	'Wantage',	'Wantage',	'Wantage',	1,	52735,	'2019-03-16 03:59:51',	'Wantage',	'Wantage',	'Wantage'),
(2634803,	77,	2648110,	'Wanstead',	'Wanstead',	'Wanstead',	1,	52734,	'2019-03-16 03:59:51',	'Wanstead',	'Wanstead',	'Wanstead'),
(2634812,	77,	2648110,	'Уондсуэрт',	'Wandsworth',	'Wandsworth',	1,	52717,	'2019-03-16 03:59:51',	'Wandsworth',	'Wandsworth',	'Wandsworth'),
(2634825,	77,	2636512,	'Walton-on-Thames',	'Walton-on-Thames',	'Walton-on-Thames',	1,	52698,	'2019-03-16 03:59:51',	'Walton-on-Thames',	'Walton-on-Thames',	'Walton-on-Thames'),
(2634826,	77,	2649889,	'Walton-on-the-Naze',	'Walton-on-the-Naze',	'Walton-on-the-Naze',	1,	52699,	'2019-03-16 03:59:51',	'Walton-on-the-Naze',	'Walton-on-the-Naze',	'Walton-on-the-Naze'),
(2634827,	77,	3333167,	'Walton on the Hill',	'Walton on the Hill',	'Walton on the Hill',	1,	52696,	'2019-03-16 03:59:51',	'Walton on the Hill',	'Walton on the Hill',	'Walton on the Hill'),
(2634828,	77,	2636512,	'Walton on the Hill',	'Walton on the Hill',	'Walton on the Hill',	1,	52697,	'2019-03-16 03:59:51',	'Walton on the Hill',	'Walton on the Hill',	'Walton on the Hill'),
(2634836,	77,	2636561,	'Walton',	'Walton',	'Walton',	1,	52689,	'2019-03-16 03:59:51',	'Walton',	'Walton',	'Walton'),
(2634837,	77,	2637532,	'Walton',	'Walton',	'Walton',	1,	52691,	'2019-03-16 03:59:51',	'Walton',	'Walton',	'Walton'),
(2634838,	77,	2648110,	'Уолтемстоу',	'Walthamstow',	'Walthamstow',	1,	52685,	'2019-03-16 03:59:51',	'Walthamstow',	'Walthamstow',	'Walthamstow'),
(2634842,	77,	2647043,	'Waltham Cross',	'Waltham Cross',	'Waltham Cross',	1,	52684,	'2019-03-16 03:59:51',	'Waltham Cross',	'Waltham Cross',	'Waltham Cross'),
(2634843,	77,	2649889,	'Waltham Abbey',	'Waltham Abbey',	'Waltham Abbey',	1,	52683,	'2019-03-16 03:59:51',	'Waltham Abbey',	'Waltham Abbey',	'Waltham Abbey'),
(2634846,	77,	2634258,	'Waltham',	'Waltham',	'Waltham',	1,	52681,	'2019-03-16 03:59:51',	'Waltham',	'Waltham',	'Waltham'),
(2634848,	77,	2641455,	'Walsoken',	'Walsoken',	'Walsoken',	1,	52668,	'2019-03-16 03:59:51',	'Walsoken',	'Walsoken',	'Walsoken'),
(2634853,	77,	3333213,	'Уолсолл',	'Walsall',	'Walsall',	1,	52657,	'2019-03-16 03:59:51',	'Walsall',	'Walsall',	'Walsall'),
(2634857,	77,	2641455,	'Walpole',	'Walpole',	'Walpole',	1,	52654,	'2019-03-16 03:59:51',	'Walpole',	'Walpole',	'Walpole'),
(2634863,	77,	3333158,	'Walmer',	'Walmer',	'Walmer',	1,	52637,	'2019-03-16 03:59:51',	'Walmer',	'Walmer',	'Walmer'),
(2634864,	77,	2641238,	'Уолсенд',	'Wallsend',	'Wallsend',	1,	52634,	'2019-03-16 03:59:51',	'Wallsend',	'Wallsend',	'Wallsend'),
(2634867,	77,	2648110,	'Уоллингтон',	'Wallington',	'Wallington',	1,	52622,	'2019-03-16 03:59:51',	'Wallington',	'Wallington',	'Wallington'),
(2634869,	77,	2640726,	'Wallingford',	'Wallingford',	'Wallingford',	1,	52618,	'2019-03-16 03:59:51',	'Wallingford',	'Wallingford',	'Wallingford'),
(2634873,	77,	3333220,	'Уолласи',	'Wallasey',	'Wallasey',	1,	52592,	'2019-03-16 03:59:51',	'Wallasey',	'Wallasey',	'Wallasey'),
(2634879,	77,	2650345,	'Walkington',	'Walkington',	'Walkington',	1,	52577,	'2019-03-16 03:59:51',	'Walkington',	'Walkington',	'Walkington'),
(2634881,	77,	2647043,	'Walkern',	'Walkern',	'Walkern',	1,	52569,	'2019-03-16 03:59:51',	'Walkern',	'Walkern',	'Walkern'),
(2634887,	77,	3333190,	'Walkden',	'Walkden',	'Walkden',	1,	52564,	'2019-03-16 03:59:51',	'Walkden',	'Walkden',	'Walkden'),
(2634889,	77,	2638655,	'Walford',	'Walford',	'Walford',	1,	52557,	'2019-03-16 03:59:51',	'Walford',	'Walford',	'Walford'),
(2634894,	77,	3333189,	'Уэльс',	'Wales',	'Wales',	1,	52554,	'2019-03-16 03:59:51',	'Wales',	'Wales',	'Wales'),
(2634906,	77,	2634258,	'Walberton',	'Walberton',	'Walberton',	1,	52485,	'2019-03-16 03:59:51',	'Walberton',	'Walberton',	'Walberton'),
(2634910,	77,	3333212,	'Уэйкфилд',	'Wakefield',	'Wakefield',	1,	52476,	'2019-03-16 03:59:51',	'Wakefield',	'Wakefield',	'Wakefield'),
(2634914,	77,	2644486,	'Wainfleet All Saints',	'Wainfleet All Saints',	'Wainfleet All Saints',	1,	52460,	'2019-03-16 03:59:51',	'Wainfleet All Saints',	'Wainfleet All Saints',	'Wainfleet All Saints'),
(2634918,	77,	2650328,	'Wadhurst',	'Wadhurst',	'Wadhurst',	1,	52416,	'2019-03-16 03:59:51',	'Wadhurst',	'Wadhurst',	'Wadhurst'),
(2634920,	77,	2652355,	'Wadebridge',	'Wadebridge',	'Wadebridge',	1,	52409,	'2019-03-16 03:59:51',	'Wadebridge',	'Wadebridge',	'Wadebridge'),
(2634925,	77,	2654408,	'Waddesdon',	'Waddesdon',	'Waddesdon',	1,	52406,	'2019-03-16 03:59:51',	'Waddesdon',	'Waddesdon',	'Waddesdon'),
(2634966,	77,	3333238,	'Victoria',	'Victoria',	'Victoria',	1,	51493,	'2019-03-16 03:59:51',	'Victoria',	'Victoria',	'Victoria'),
(2634975,	77,	2651079,	'Verwood',	'Verwood',	'Verwood',	1,	51380,	'2019-03-16 03:59:51',	'Verwood',	'Verwood',	'Verwood'),
(2634985,	77,	2646007,	'Вентнор',	'Ventnor',	'Ventnor',	1,	51188,	'2019-03-16 03:59:51',	'Ventnor',	'Ventnor',	'Ventnor'),
(2635022,	77,	2657311,	'Valley',	'Valley',	'Valley',	1,	50787,	'2019-03-16 03:59:51',	'Valley',	'Valley',	'Valley'),
(2635042,	77,	2648110,	'Аксбридж',	'Uxbridge',	'Uxbridge',	1,	50602,	'2019-03-16 03:59:51',	'Uxbridge',	'Uxbridge',	'Uxbridge'),
(2635043,	77,	2637141,	'Uttoxeter',	'Uttoxeter',	'Uttoxeter',	1,	50596,	'2019-03-16 03:59:51',	'Uttoxeter',	'Uttoxeter',	'Uttoxeter'),
(2635052,	77,	3333244,	'Аск',	'Usk',	'Usk',	1,	50558,	'2019-03-16 03:59:51',	'Usk',	'Usk',	'Usk'),
(2635062,	77,	3333211,	'Urmston',	'Urmston',	'Urmston',	1,	50531,	'2019-03-16 03:59:51',	'Urmston',	'Urmston',	'Urmston'),
(2635072,	77,	2633868,	'Urchfont',	'Urchfont',	'Urchfont',	1,	50514,	'2019-03-16 03:59:51',	'Urchfont',	'Urchfont',	'Urchfont'),
(2635080,	77,	2633560,	'Upton upon Severn',	'Upton upon Severn',	'Upton upon Severn',	1,	50494,	'2019-03-16 03:59:51',	'Upton upon Severn',	'Upton upon Severn',	'Upton upon Severn'),
(2635091,	77,	3333220,	'Upton',	'Upton',	'Upton',	1,	50491,	'2019-03-16 03:59:51',	'Upton',	'Upton',	'Upton'),
(2635097,	77,	2640726,	'Upton',	'Upton',	'Upton',	1,	50492,	'2019-03-16 03:59:51',	'Upton',	'Upton',	'Upton'),
(2635101,	77,	2638918,	'Uppingham',	'Uppingham',	'Uppingham',	1,	50486,	'2019-03-16 03:59:51',	'Uppingham',	'Uppingham',	'Uppingham'),
(2635108,	77,	2648402,	'Upper Slaughter',	'Upper Slaughter',	'Upper Slaughter',	1,	50483,	'2019-03-16 03:59:51',	'Upper Slaughter',	'Upper Slaughter',	'Upper Slaughter'),
(2635124,	77,	2640726,	'Upper Heyford',	'Upper Heyford',	'Upper Heyford',	1,	50478,	'2019-03-16 03:59:51',	'Upper Heyford',	'Upper Heyford',	'Upper Heyford'),
(2635146,	77,	2634258,	'Upper Beeding',	'Upper Beeding',	'Upper Beeding',	1,	50474,	'2019-03-16 03:59:51',	'Upper Beeding',	'Upper Beeding',	'Upper Beeding'),
(2635150,	77,	2648110,	'Upminster',	'Upminster',	'Upminster',	1,	50473,	'2019-03-16 03:59:51',	'Upminster',	'Upminster',	'Upminster'),
(2635151,	77,	2651292,	'Uplyme',	'Uplyme',	'Uplyme',	1,	50472,	'2019-03-16 03:59:51',	'Uplyme',	'Uplyme',	'Uplyme'),
(2635159,	77,	2634354,	'Uphall',	'Uphall',	'Uphall',	1,	50466,	'2019-03-16 03:59:51',	'Uphall',	'Uphall',	'Uphall'),
(2635183,	77,	2651712,	'Ulverston',	'Ulverston',	'Ulverston',	1,	50321,	'2019-03-16 03:59:51',	'Ulverston',	'Ulverston',	'Ulverston'),
(2635195,	77,	2644667,	'Ullesthorpe',	'Ullesthorpe',	'Ullesthorpe',	1,	50306,	'2019-03-16 03:59:51',	'Ullesthorpe',	'Ullesthorpe',	'Ullesthorpe'),
(2635204,	77,	3333158,	'Ulcombe',	'Ulcombe',	'Ulcombe',	1,	50299,	'2019-03-16 03:59:51',	'Ulcombe',	'Ulcombe',	'Ulcombe'),
(2635205,	77,	3333176,	'Ulceby',	'Ulceby',	'Ulceby',	1,	50298,	'2019-03-16 03:59:51',	'Ulceby',	'Ulceby',	'Ulceby'),
(2635239,	77,	3333236,	'Uddingston',	'Uddingston',	'Uddingston',	1,	50251,	'2019-03-16 03:59:51',	'Uddingston',	'Uddingston',	'Uddingston'),
(2635243,	77,	2650328,	'Uckfield',	'Uckfield',	'Uckfield',	1,	50248,	'2019-03-16 03:59:51',	'Uckfield',	'Uckfield',	'Uckfield'),
(2635269,	77,	2641238,	'Tynemouth',	'Tynemouth',	'Tynemouth',	1,	50218,	'2019-03-16 03:59:51',	'Tynemouth',	'Tynemouth',	'Tynemouth'),
(2635281,	77,	3333219,	'Tyldesley',	'Tyldesley',	'Tyldesley',	1,	50210,	'2019-03-16 03:59:51',	'Tyldesley',	'Tyldesley',	'Tyldesley'),
(2635294,	77,	3333221,	'Twyford',	'Twyford',	'Twyford',	1,	50202,	'2019-03-16 03:59:51',	'Twyford',	'Twyford',	'Twyford'),
(2635308,	77,	2648110,	'Туикенем',	'Twickenham',	'Twickenham',	1,	50183,	'2019-03-16 03:59:51',	'Twickenham',	'Twickenham',	'Twickenham'),
(2635327,	77,	7290534,	'Turvey',	'Turvey',	'Turvey',	1,	50157,	'2019-03-16 03:59:51',	'Turvey',	'Turvey',	'Turvey'),
(2635329,	77,	2657830,	'Turriff',	'Turriff',	'Turriff',	1,	50150,	'2019-03-16 03:59:51',	'Turriff',	'Turriff',	'Turriff'),
(2635342,	77,	3333235,	'Turnberry',	'Turnberry',	'Turnberry',	1,	50138,	'2019-03-16 03:59:51',	'Turnberry',	'Turnberry',	'Turnberry'),
(2635351,	77,	2647554,	'Tunworth',	'Tunworth',	'Tunworth',	1,	50115,	'2019-03-16 03:59:51',	'Tunworth',	'Tunworth',	'Tunworth'),
(2635412,	77,	2652355,	'Труро',	'Truro',	'Truro',	1,	50045,	'2019-03-16 03:59:51',	'Truro',	'Truro',	'Truro'),
(2635427,	77,	2633868,	'Троубридже',	'Trowbridge',	'Trowbridge',	1,	50007,	'2019-03-16 03:59:51',	'Trowbridge',	'Trowbridge',	'Trowbridge'),
(2635442,	77,	3333235,	'Трун',	'Troon',	'Troon',	1,	49984,	'2019-03-16 03:59:51',	'Troon',	'Troon',	'Troon'),
(2635459,	77,	2647043,	'Tring',	'Tring',	'Tring',	1,	49936,	'2019-03-16 03:59:51',	'Tring',	'Tring',	'Tring'),
(2635461,	77,	2636561,	'Trimley Heath',	'Trimley Heath',	'Trimley Heath',	1,	49934,	'2019-03-16 03:59:51',	'Trimley Heath',	'Trimley Heath',	'Trimley Heath'),
(2635465,	77,	2650629,	'Trimdon',	'Trimdon',	'Trimdon',	1,	49933,	'2019-03-16 03:59:51',	'Trimdon',	'Trimdon',	'Trimdon'),
(2635496,	77,	3333247,	'Treorchy',	'Treorchy',	'Treorchy',	1,	49843,	'2019-03-16 03:59:51',	'Treorchy',	'Treorchy',	'Treorchy'),
(2635504,	77,	2651079,	'Trent',	'Trent',	'Trent',	1,	49825,	'2019-03-16 03:59:51',	'Trent',	'Trent',	'Trent'),
(2635523,	77,	3333247,	'Treherbert',	'Treherbert',	'Treherbert',	1,	49789,	'2019-03-16 03:59:51',	'Treherbert',	'Treherbert',	'Treherbert'),
(2635524,	77,	3333243,	'Treharris',	'Treharris',	'Treharris',	1,	49788,	'2019-03-16 03:59:51',	'Treharris',	'Treharris',	'Treharris'),
(2635526,	77,	2639944,	'Tregynon',	'Tregynon',	'Tregynon',	1,	49787,	'2019-03-16 03:59:51',	'Tregynon',	'Tregynon',	'Tregynon'),
(2635531,	77,	2653814,	'Tregaron',	'Tregaron',	'Tregaron',	1,	49777,	'2019-03-16 03:59:51',	'Tregaron',	'Tregaron',	'Tregaron'),
(2635547,	77,	3333238,	'Tredegar',	'Tredegar',	'Tredegar',	1,	49769,	'2019-03-16 03:59:51',	'Tredegar',	'Tredegar',	'Tredegar'),
(2635557,	77,	2647716,	'Trawsfynydd',	'Trawsfynydd',	'Trawsfynydd',	1,	49748,	'2019-03-16 03:59:51',	'Trawsfynydd',	'Trawsfynydd',	'Trawsfynydd'),
(2635563,	77,	2650386,	'Tranent',	'Tranent',	'Tranent',	1,	49716,	'2019-03-16 03:59:51',	'Tranent',	'Tranent',	'Tranent'),
(2635571,	77,	3333211,	'Trafford Park',	'Trafford Park',	'Trafford Park',	1,	49700,	'2019-03-16 03:59:51',	'Trafford Park',	'Trafford Park',	'Trafford Park'),
(2635576,	77,	2644486,	'Toynton All Saints',	'Toynton All Saints',	'Toynton All Saints',	1,	49680,	'2019-03-16 03:59:51',	'Toynton All Saints',	'Toynton All Saints',	'Toynton All Saints'),
(2635597,	77,	2641429,	'Towcester',	'Towcester',	'Towcester',	1,	49660,	'2019-03-16 03:59:51',	'Towcester',	'Towcester',	'Towcester'),
(2635603,	77,	2647554,	'Totton',	'Totton',	'Totton',	1,	49585,	'2019-03-16 03:59:51',	'Totton',	'Totton',	'Totton'),
(2635608,	77,	2648110,	'Тоттенем',	'Tottenham',	'Tottenham',	1,	49584,	'2019-03-16 03:59:51',	'Tottenham',	'Tottenham',	'Tottenham'),
(2635609,	77,	2641169,	'Toton',	'Toton',	'Toton',	1,	49582,	'2019-03-16 03:59:51',	'Toton',	'Toton',	'Toton'),
(2635610,	77,	2651292,	'Тотнес',	'Totnes',	'Totnes',	1,	49581,	'2019-03-16 03:59:51',	'Totnes',	'Totnes',	'Totnes'),
(2635620,	77,	2641169,	'Torworth',	'Torworth',	'Torworth',	1,	49570,	'2019-03-16 03:59:51',	'Torworth',	'Torworth',	'Torworth'),
(2635629,	77,	2649469,	'Torryburn',	'Torryburn',	'Torryburn',	1,	49556,	'2019-03-16 03:59:51',	'Torryburn',	'Torryburn',	'Torryburn'),
(2635650,	77,	3333210,	'Торки',	'Torquay',	'Torquay',	1,	49474,	'2019-03-16 03:59:51',	'Torquay',	'Torquay',	'Torquay'),
(2635651,	77,	2652355,	'Torpoint',	'Torpoint',	'Torpoint',	1,	49473,	'2019-03-16 03:59:51',	'Torpoint',	'Torpoint',	'Torpoint'),
(2635653,	77,	2634354,	'Torphichen',	'Torphichen',	'Torphichen',	1,	49472,	'2019-03-16 03:59:51',	'Torphichen',	'Torphichen',	'Torphichen'),
(2635683,	77,	2641209,	'Topcliffe',	'Topcliffe',	'Topcliffe',	1,	49419,	'2019-03-16 03:59:51',	'Topcliffe',	'Topcliffe',	'Topcliffe'),
(2635689,	77,	3333247,	'Tonyrefail',	'Tonyrefail',	'Tonyrefail',	1,	49414,	'2019-03-16 03:59:51',	'Tonyrefail',	'Tonyrefail',	'Tonyrefail'),
(2635703,	77,	3333158,	'Тонбридж',	'Tonbridge',	'Tonbridge',	1,	49394,	'2019-03-16 03:59:51',	'Tonbridge',	'Tonbridge',	'Tonbridge'),
(2635722,	77,	2641169,	'Tollerton',	'Tollerton',	'Tollerton',	1,	49359,	'2019-03-16 03:59:51',	'Tollerton',	'Tollerton',	'Tollerton'),
(2635726,	77,	2633868,	'Tollard Royal',	'Tollard Royal',	'Tollard Royal',	1,	49357,	'2019-03-16 03:59:51',	'Tollard Royal',	'Tollard Royal',	'Tollard Royal'),
(2635744,	77,	3333137,	'Todmorden',	'Todmorden',	'Todmorden',	1,	49334,	'2019-03-16 03:59:51',	'Todmorden',	'Todmorden',	'Todmorden'),
(2635748,	77,	7290535,	'Toddington',	'Toddington',	'Toddington',	1,	49329,	'2019-03-16 03:59:51',	'Toddington',	'Toddington',	'Toddington'),
(2635762,	77,	2651292,	'Tiverton',	'Tiverton',	'Tiverton',	1,	49311,	'2019-03-16 03:59:51',	'Tiverton',	'Tiverton',	'Tiverton'),
(2635774,	77,	2633868,	'Tisbury',	'Tisbury',	'Tisbury',	1,	49291,	'2019-03-16 03:59:51',	'Tisbury',	'Tisbury',	'Tisbury'),
(2635783,	77,	2649889,	'Tiptree',	'Tiptree',	'Tiptree',	1,	49273,	'2019-03-16 03:59:51',	'Tiptree',	'Tiptree',	'Tiptree'),
(2635785,	77,	3333191,	'Tipton',	'Tipton',	'Tipton',	1,	49268,	'2019-03-16 03:59:51',	'Tipton',	'Tipton',	'Tipton'),
(2635803,	77,	3333211,	'Timperley',	'Timperley',	'Timperley',	1,	49244,	'2019-03-16 03:59:51',	'Timperley',	'Timperley',	'Timperley'),
(2635825,	77,	2634258,	'Tillington',	'Tillington',	'Tillington',	1,	49221,	'2019-03-16 03:59:51',	'Tillington',	'Tillington',	'Tillington'),
(2635826,	77,	2649889,	'Tillingham',	'Tillingham',	'Tillingham',	1,	49220,	'2019-03-16 03:59:51',	'Tillingham',	'Tillingham',	'Tillingham'),
(2635829,	77,	2652975,	'Tillicoultry',	'Tillicoultry',	'Tillicoultry',	1,	49218,	'2019-03-16 03:59:51',	'Tillicoultry',	'Tillicoultry',	'Tillicoultry'),
(2635835,	77,	2649889,	'Tilbury Juxta Clare',	'Tilbury Juxta Clare',	'Tilbury Juxta Clare',	1,	49209,	'2019-03-16 03:59:51',	'Tilbury Juxta Clare',	'Tilbury Juxta Clare',	'Tilbury Juxta Clare'),
(2635836,	77,	2635885,	'Tilbury',	'Tilbury',	'Tilbury',	1,	49208,	'2019-03-16 03:59:51',	'Tilbury',	'Tilbury',	'Tilbury'),
(2635851,	77,	2651346,	'Tideswell',	'Tideswell',	'Tideswell',	1,	49174,	'2019-03-16 03:59:51',	'Tideswell',	'Tideswell',	'Tideswell'),
(2635857,	77,	2651346,	'Ticknall',	'Ticknall',	'Ticknall',	1,	49171,	'2019-03-16 03:59:51',	'Ticknall',	'Ticknall',	'Ticknall'),
(2635862,	77,	2650328,	'Ticehurst',	'Ticehurst',	'Ticehurst',	1,	49167,	'2019-03-16 03:59:51',	'Ticehurst',	'Ticehurst',	'Ticehurst'),
(2635864,	77,	2651346,	'Tibshelf',	'Tibshelf',	'Tibshelf',	1,	49165,	'2019-03-16 03:59:51',	'Tibshelf',	'Tibshelf',	'Tibshelf'),
(2635877,	77,	2636561,	'Thurston',	'Thurston',	'Thurston',	1,	49156,	'2019-03-16 03:59:51',	'Thurston',	'Thurston',	'Thurston'),
(2635881,	77,	2646944,	'Терсо',	'Thurso',	'Thurso',	1,	49154,	'2019-03-16 03:59:51',	'Thurso',	'Thurso',	'Thurso'),
(2635895,	77,	7290534,	'Thurleigh',	'Thurleigh',	'Thurleigh',	1,	49150,	'2019-03-16 03:59:51',	'Thurleigh',	'Thurleigh',	'Thurleigh'),
(2635899,	77,	2641455,	'Thurgarton',	'Thurgarton',	'Thurgarton',	1,	49147,	'2019-03-16 03:59:51',	'Thurgarton',	'Thurgarton',	'Thurgarton'),
(2635901,	77,	2647043,	'Thundridge',	'Thundridge',	'Thundridge',	1,	49141,	'2019-03-16 03:59:51',	'Thundridge',	'Thundridge',	'Thundridge'),
(2635902,	77,	2649889,	'Thundersley',	'Thundersley',	'Thundersley',	1,	49140,	'2019-03-16 03:59:51',	'Thundersley',	'Thundersley',	'Thundersley'),
(2635906,	77,	3333189,	'Thrybergh',	'Thrybergh',	'Thrybergh',	1,	49132,	'2019-03-16 03:59:51',	'Thrybergh',	'Thrybergh',	'Thrybergh'),
(2635908,	77,	2647554,	'Thruxton',	'Thruxton',	'Thruxton',	1,	49131,	'2019-03-16 03:59:51',	'Thruxton',	'Thruxton',	'Thruxton'),
(2635921,	77,	2641209,	'Threshfield',	'Threshfield',	'Threshfield',	1,	49129,	'2019-03-16 03:59:51',	'Threshfield',	'Threshfield',	'Threshfield'),
(2635927,	77,	2651079,	'Three Legged Cross',	'Three Legged Cross',	'Three Legged Cross',	1,	49121,	'2019-03-16 03:59:51',	'Three Legged Cross',	'Three Legged Cross',	'Three Legged Cross'),
(2635937,	77,	2641429,	'Thrapston',	'Thrapston',	'Thrapston',	1,	49117,	'2019-03-16 03:59:51',	'Thrapston',	'Thrapston',	'Thrapston'),
(2635939,	77,	2651292,	'Thorverton',	'Thorverton',	'Thorverton',	1,	49108,	'2019-03-16 03:59:51',	'Thorverton',	'Thorverton',	'Thorverton'),
(2635946,	77,	2641455,	'Thorpe Saint Andrew',	'Thorpe Saint Andrew',	'Thorpe Saint Andrew',	1,	49107,	'2019-03-16 03:59:51',	'Thorpe Saint Andrew',	'Thorpe Saint Andrew',	'Thorpe Saint Andrew'),
(2635951,	77,	2644667,	'Thorpe Langton',	'Thorpe Langton',	'Thorpe Langton',	1,	49106,	'2019-03-16 03:59:51',	'Thorpe Langton',	'Thorpe Langton',	'Thorpe Langton'),
(2635963,	77,	2648110,	'Торнтон Хит',	'Thornton Heath',	'Thornton Heath',	1,	49099,	'2019-03-16 03:59:51',	'Thornton Heath',	'Thornton Heath',	'Thornton Heath'),
(2635969,	77,	2649469,	'Thornton',	'Thornton',	'Thornton',	1,	49094,	'2019-03-16 03:59:51',	'Thornton',	'Thornton',	'Thornton'),
(2635972,	77,	2644974,	'Thornton',	'Thornton',	'Thornton',	1,	49096,	'2019-03-16 03:59:51',	'Thornton',	'Thornton',	'Thornton'),
(2635973,	77,	3333131,	'Thornton',	'Thornton',	'Thornton',	1,	49098,	'2019-03-16 03:59:51',	'Thornton',	'Thornton',	'Thornton'),
(2635978,	77,	2650629,	'Thornley',	'Thornley',	'Thornley',	1,	49088,	'2019-03-16 03:59:51',	'Thornley',	'Thornley',	'Thornley'),
(2635997,	77,	3333143,	'Thorne',	'Thorne',	'Thorne',	1,	49086,	'2019-03-16 03:59:51',	'Thorne',	'Thorne',	'Thorne'),
(2636002,	77,	3333198,	'Thornbury',	'Thornbury',	'Thornbury',	1,	49081,	'2019-03-16 03:59:51',	'Thornbury',	'Thornbury',	'Thornbury'),
(2636005,	77,	3333186,	'Thornaby-on-Tees',	'Thornaby-on-Tees',	'Thornaby-on-Tees',	1,	49079,	'2019-03-16 03:59:51',	'Thornaby-on-Tees',	'Thornaby-on-Tees',	'Thornaby-on-Tees'),
(2636021,	77,	2641209,	'Thirsk',	'Thirsk',	'Thirsk',	1,	49020,	'2019-03-16 03:59:51',	'Thirsk',	'Thirsk',	'Thirsk'),
(2636031,	77,	2649889,	'Theydon Bois',	'Theydon Bois',	'Theydon Bois',	1,	48981,	'2019-03-16 03:59:51',	'Theydon Bois',	'Theydon Bois',	'Theydon Bois'),
(2636032,	77,	2641455,	'Тетфорд',	'Thetford',	'Thetford',	1,	48975,	'2019-03-16 03:59:51',	'Thetford',	'Thetford',	'Thetford'),
(2636034,	77,	2647043,	'Therfield',	'Therfield',	'Therfield',	1,	48969,	'2019-03-16 03:59:51',	'Therfield',	'Therfield',	'Therfield'),
(2636044,	77,	2636561,	'Theberton',	'Theberton',	'Theberton',	1,	48940,	'2019-03-16 03:59:51',	'Theberton',	'Theberton',	'Theberton'),
(2636045,	77,	3333217,	'Theale',	'Theale',	'Theale',	1,	48939,	'2019-03-16 03:59:51',	'Theale',	'Theale',	'Theale'),
(2636046,	77,	2637532,	'Theale',	'Theale',	'Theale',	1,	48938,	'2019-03-16 03:59:51',	'Theale',	'Theale',	'Theale'),
(2636047,	77,	2649889,	'Thaxted',	'Thaxted',	'Thaxted',	1,	48927,	'2019-03-16 03:59:51',	'Thaxted',	'Thaxted',	'Thaxted'),
(2636049,	77,	3333217,	'Thatcham',	'Thatcham',	'Thatcham',	1,	48924,	'2019-03-16 03:59:51',	'Thatcham',	'Thatcham',	'Thatcham'),
(2636062,	77,	2636512,	'Thames Ditton',	'Thames Ditton',	'Thames Ditton',	1,	48912,	'2019-03-16 03:59:51',	'Thames Ditton',	'Thames Ditton',	'Thames Ditton'),
(2636066,	77,	2640726,	'Thame',	'Thame',	'Thame',	1,	48911,	'2019-03-16 03:59:51',	'Thame',	'Thame',	'Thame'),
(2636071,	77,	2648402,	'Тьюксбери',	'Tewkesbury',	'Tewkesbury',	1,	48887,	'2019-03-16 03:59:51',	'Tewkesbury',	'Tewkesbury',	'Tewkesbury'),
(2636079,	77,	2640726,	'Tetsworth',	'Tetsworth',	'Tetsworth',	1,	48873,	'2019-03-16 03:59:51',	'Tetsworth',	'Tetsworth',	'Tetsworth'),
(2636083,	77,	2648402,	'Tetbury',	'Tetbury',	'Tetbury',	1,	48865,	'2019-03-16 03:59:51',	'Tetbury',	'Tetbury',	'Tetbury'),
(2636092,	77,	2641455,	'Terrington Saint Clement',	'Terrington Saint Clement',	'Terrington Saint Clement',	1,	48847,	'2019-03-16 03:59:51',	'Terrington Saint Clement',	'Terrington Saint Clement',	'Terrington Saint Clement'),
(2636101,	77,	3333158,	'Tenterden',	'Tenterden',	'Tenterden',	1,	48797,	'2019-03-16 03:59:51',	'Tenterden',	'Tenterden',	'Tenterden'),
(2636103,	77,	2640726,	'Tendring',	'Tendring',	'Tendring',	1,	48781,	'2019-03-16 03:59:51',	'Tendring',	'Tendring',	'Tendring'),
(2636104,	77,	2640500,	'Тенби',	'Tenby',	'Tenby',	1,	48777,	'2019-03-16 03:59:51',	'Tenby',	'Tenby',	'Tenby'),
(2636105,	77,	2633560,	'Tenbury Wells',	'Tenbury Wells',	'Tenbury Wells',	1,	48776,	'2019-03-16 03:59:51',	'Tenbury Wells',	'Tenbury Wells',	'Tenbury Wells'),
(2636120,	77,	2637532,	'Templecombe',	'Templecombe',	'Templecombe',	1,	48760,	'2019-03-16 03:59:51',	'Templecombe',	'Templecombe',	'Templecombe'),
(2636125,	77,	2652355,	'Temple',	'Temple',	'Temple',	1,	48755,	'2019-03-16 03:59:51',	'Temple',	'Temple',	'Temple'),
(2636132,	77,	2651292,	'Тинмут',	'Teignmouth',	'Teignmouth',	1,	48718,	'2019-03-16 03:59:51',	'Teignmouth',	'Teignmouth',	'Teignmouth'),
(2636146,	77,	2648402,	'Teddington',	'Teddington',	'Teddington',	1,	48704,	'2019-03-16 03:59:51',	'Teddington',	'Teddington',	'Teddington'),
(2636147,	77,	2648110,	'Teddington',	'Teddington',	'Teddington',	1,	48703,	'2019-03-16 03:59:51',	'Teddington',	'Teddington',	'Teddington'),
(2636158,	77,	2649469,	'Tayport',	'Tayport',	'Tayport',	1,	48683,	'2019-03-16 03:59:51',	'Tayport',	'Tayport',	'Tayport'),
(2636159,	77,	6457407,	'Taynuilt',	'Taynuilt',	'Taynuilt',	1,	48682,	'2019-03-16 03:59:51',	'Taynuilt',	'Taynuilt',	'Taynuilt'),
(2636174,	77,	2651292,	'Тависток',	'Tavistock',	'Tavistock',	1,	48659,	'2019-03-16 03:59:51',	'Tavistock',	'Tavistock',	'Tavistock'),
(2636177,	77,	2637532,	'Тонтон',	'Taunton',	'Taunton',	1,	48626,	'2019-03-16 03:59:51',	'Taunton',	'Taunton',	'Taunton'),
(2636180,	77,	2644486,	'Tattershall',	'Tattershall',	'Tattershall',	1,	48610,	'2019-03-16 03:59:51',	'Tattershall',	'Tattershall',	'Tattershall'),
(2636183,	77,	7290537,	'Tattenhall',	'Tattenhall',	'Tattenhall',	1,	48609,	'2019-03-16 03:59:51',	'Tattenhall',	'Tattenhall',	'Tattenhall'),
(2636209,	77,	7290537,	'Tarporley',	'Tarporley',	'Tarporley',	1,	48585,	'2019-03-16 03:59:51',	'Tarporley',	'Tarporley',	'Tarporley'),
(2636241,	77,	6457407,	'Tarbert',	'Tarbert',	'Tarbert',	1,	48563,	'2019-03-16 03:59:51',	'Tarbert',	'Tarbert',	'Tarbert'),
(2636253,	77,	2634723,	'Tanworth',	'Tanworth',	'Tanworth',	1,	48541,	'2019-03-16 03:59:51',	'Tanworth',	'Tanworth',	'Tanworth'),
(2636276,	77,	2637141,	'Тамуорт',	'Tamworth',	'Tamworth',	1,	48516,	'2019-03-16 03:59:51',	'Tamworth',	'Tamworth',	'Tamworth'),
(2636290,	77,	2647716,	'Talsarnau',	'Talsarnau',	'Talsarnau',	1,	48497,	'2019-03-16 03:59:51',	'Talsarnau',	'Talsarnau',	'Talsarnau'),
(2636296,	77,	2644486,	'Tallington',	'Tallington',	'Tallington',	1,	48487,	'2019-03-16 03:59:51',	'Tallington',	'Tallington',	'Tallington'),
(2636299,	77,	2651712,	'Tallentire',	'Tallentire',	'Tallentire',	1,	48484,	'2019-03-16 03:59:51',	'Tallentire',	'Tallentire',	'Tallentire'),
(2636307,	77,	2639944,	'Talgarth',	'Talgarth',	'Talgarth',	1,	48468,	'2019-03-16 03:59:51',	'Talgarth',	'Talgarth',	'Talgarth'),
(2636315,	77,	2649889,	'Takeley',	'Takeley',	'Takeley',	1,	48446,	'2019-03-16 03:59:51',	'Takeley',	'Takeley',	'Takeley'),
(2636321,	77,	2646944,	'Tain',	'Tain',	'Tain',	1,	48439,	'2019-03-16 03:59:51',	'Tain',	'Tain',	'Tain'),
(2636331,	77,	2636512,	'Tadworth',	'Tadworth',	'Tadworth',	1,	48411,	'2019-03-16 03:59:51',	'Tadworth',	'Tadworth',	'Tadworth'),
(2636333,	77,	2647554,	'Tadley',	'Tadley',	'Tadley',	1,	48410,	'2019-03-16 03:59:51',	'Tadley',	'Tadley',	'Tadley'),
(2636334,	77,	2651346,	'Taddington',	'Taddington',	'Taddington',	1,	48407,	'2019-03-16 03:59:51',	'Taddington',	'Taddington',	'Taddington'),
(2636335,	77,	2641209,	'Тадкастер',	'Tadcaster',	'Tadcaster',	1,	48406,	'2019-03-16 03:59:51',	'Tadcaster',	'Tadcaster',	'Tadcaster'),
(2636337,	77,	7290536,	'Tabley',	'Tabley',	'Tabley',	1,	48393,	'2019-03-16 03:59:51',	'Tabley',	'Tabley',	'Tabley'),
(2636341,	77,	2644667,	'Syston',	'Syston',	'Syston',	1,	48384,	'2019-03-16 03:59:51',	'Syston',	'Syston',	'Syston'),
(2636342,	77,	2641429,	'Syresham',	'Syresham',	'Syresham',	1,	48382,	'2019-03-16 03:59:51',	'Syresham',	'Syresham',	'Syresham'),
(2636350,	77,	3333235,	'Symington',	'Symington',	'Symington',	1,	48373,	'2019-03-16 03:59:51',	'Symington',	'Symington',	'Symington'),
(2636373,	77,	3333169,	'Swinton',	'Swinton',	'Swinton',	1,	48342,	'2019-03-16 03:59:51',	'Swinton',	'Swinton',	'Swinton'),
(2636388,	77,	2648402,	'Swindon',	'Swindon',	'Swindon',	1,	48339,	'2019-03-16 03:59:51',	'Swindon',	'Swindon',	'Swindon'),
(2636389,	77,	3333207,	'Свиндон',	'Swindon',	'Swindon',	1,	48340,	'2019-03-16 03:59:51',	'Swindon',	'Swindon',	'Swindon'),
(2636394,	77,	3333164,	'Swillington',	'Swillington',	'Swillington',	1,	48338,	'2019-03-16 03:59:51',	'Swillington',	'Swillington',	'Swillington'),
(2636409,	77,	2653940,	'Swavesey',	'Swavesey',	'Swavesey',	1,	48322,	'2019-03-16 03:59:51',	'Swavesey',	'Swavesey',	'Swavesey'),
(2636432,	77,	3333248,	'Суонси',	'Swansea',	'Swansea',	1,	48312,	'2019-03-16 03:59:51',	'Swansea',	'Swansea',	'Swansea'),
(2636433,	77,	3333158,	'Swanscombe',	'Swanscombe',	'Swanscombe',	1,	48311,	'2019-03-16 03:59:51',	'Swanscombe',	'Swanscombe',	'Swanscombe'),
(2636438,	77,	2647554,	'Swanmore',	'Swanmore',	'Swanmore',	1,	48307,	'2019-03-16 03:59:51',	'Swanmore',	'Swanmore',	'Swanmore'),
(2636445,	77,	2651079,	'Swanage',	'Swanage',	'Swanage',	1,	48306,	'2019-03-16 03:59:51',	'Swanage',	'Swanage',	'Swanage'),
(2636446,	77,	2648772,	'Swalwell',	'Swalwell',	'Swalwell',	1,	48302,	'2019-03-16 03:59:51',	'Swalwell',	'Swalwell',	'Swalwell'),
(2636448,	77,	3333221,	'Swallowfield',	'Swallowfield',	'Swallowfield',	1,	48301,	'2019-03-16 03:59:51',	'Swallowfield',	'Swallowfield',	'Swallowfield'),
(2636451,	77,	2644486,	'Swallow',	'Swallow',	'Swallow',	1,	48300,	'2019-03-16 03:59:51',	'Swallow',	'Swallow',	'Swallow'),
(2636464,	77,	2641455,	'Swaffham',	'Swaffham',	'Swaffham',	1,	48298,	'2019-03-16 03:59:51',	'Swaffham',	'Swaffham',	'Swaffham'),
(2636465,	77,	2651346,	'Swadlincote',	'Swadlincote',	'Swadlincote',	1,	48297,	'2019-03-16 03:59:51',	'Swadlincote',	'Swadlincote',	'Swadlincote'),
(2636474,	77,	2641169,	'Sutton on Trent',	'Sutton on Trent',	'Sutton on Trent',	1,	48276,	'2019-03-16 03:59:51',	'Sutton on Trent',	'Sutton on Trent',	'Sutton on Trent'),
(2636475,	77,	2651346,	'Sutton on the Hill',	'Sutton on the Hill',	'Sutton on the Hill',	1,	48275,	'2019-03-16 03:59:51',	'Sutton on the Hill',	'Sutton on the Hill',	'Sutton on the Hill'),
(2636483,	77,	2641209,	'Sutton-in-Craven',	'Sutton-in-Craven',	'Sutton-in-Craven',	1,	48278,	'2019-03-16 03:59:51',	'Sutton-in-Craven',	'Sutton-in-Craven',	'Sutton-in-Craven'),
(2636484,	77,	2641169,	'Sutton in Ashfield',	'Sutton in Ashfield',	'Sutton in Ashfield',	1,	48274,	'2019-03-16 03:59:51',	'Sutton in Ashfield',	'Sutton in Ashfield',	'Sutton in Ashfield'),
(2636486,	77,	3333125,	'Саттон Колдфилд',	'Sutton Coldfield',	'Sutton Coldfield',	1,	48273,	'2019-03-16 03:59:51',	'Sutton Coldfield',	'Sutton Coldfield',	'Sutton Coldfield'),
(2636495,	77,	7290537,	'Sutton',	'Sutton',	'Sutton',	1,	48272,	'2019-03-16 03:59:51',	'Sutton',	'Sutton',	'Sutton'),
(2636503,	77,	2648110,	'Саттон',	'Sutton',	'Sutton',	1,	48268,	'2019-03-16 03:59:51',	'Sutton',	'Sutton',	'Sutton'),
(2636504,	77,	2644486,	'Sutterton',	'Sutterton',	'Sutterton',	1,	48266,	'2019-03-16 03:59:51',	'Sutterton',	'Sutterton',	'Sutterton'),
(2636518,	77,	2636512,	'Sunninghill',	'Sunninghill',	'Sunninghill',	1,	48190,	'2019-03-16 03:59:51',	'Sunninghill',	'Sunninghill',	'Sunninghill'),
(2636520,	77,	2633840,	'Sunningdale',	'Sunningdale',	'Sunningdale',	1,	48189,	'2019-03-16 03:59:51',	'Sunningdale',	'Sunningdale',	'Sunningdale'),
(2636527,	77,	3333168,	'Sundon Park',	'Sundon Park',	'Sundon Park',	1,	48180,	'2019-03-16 03:59:51',	'Sundon Park',	'Sundon Park',	'Sundon Park'),
(2636531,	77,	3333205,	'Сандерленд',	'Sunderland',	'Sunderland',	1,	48177,	'2019-03-16 03:59:51',	'Sunderland',	'Sunderland',	'Sunderland'),
(2636534,	77,	2636512,	'Sunbury-on-Thames',	'Sunbury-on-Thames',	'Sunbury-on-Thames',	1,	48170,	'2019-03-16 03:59:51',	'Sunbury-on-Thames',	'Sunbury-on-Thames',	'Sunbury-on-Thames'),
(2636564,	77,	2636561,	'Sudbury',	'Sudbury',	'Sudbury',	1,	48023,	'2019-03-16 03:59:51',	'Sudbury',	'Sudbury',	'Sudbury'),
(2636566,	77,	2644486,	'Sudbrooke',	'Sudbrooke',	'Sudbrooke',	1,	48022,	'2019-03-16 03:59:51',	'Sudbrooke',	'Sudbrooke',	'Sudbrooke'),
(2636583,	77,	2651079,	'Sturminster Newton',	'Sturminster Newton',	'Sturminster Newton',	1,	47990,	'2019-03-16 03:59:51',	'Sturminster Newton',	'Sturminster Newton',	'Sturminster Newton'),
(2636584,	77,	2651079,	'Sturminster Marshall',	'Sturminster Marshall',	'Sturminster Marshall',	1,	47989,	'2019-03-16 03:59:51',	'Sturminster Marshall',	'Sturminster Marshall',	'Sturminster Marshall'),
(2636585,	77,	2649889,	'Sturmer',	'Sturmer',	'Sturmer',	1,	47988,	'2019-03-16 03:59:51',	'Sturmer',	'Sturmer',	'Sturmer'),
(2636594,	77,	2634723,	'Studley',	'Studley',	'Studley',	1,	47973,	'2019-03-16 03:59:51',	'Studley',	'Studley',	'Studley'),
(2636595,	77,	2640726,	'Studley',	'Studley',	'Studley',	1,	47971,	'2019-03-16 03:59:51',	'Studley',	'Studley',	'Studley'),
(2636597,	77,	2651079,	'Studland',	'Studland',	'Studland',	1,	47970,	'2019-03-16 03:59:51',	'Studland',	'Studland',	'Studland'),
(2636598,	77,	7290535,	'Studham',	'Studham',	'Studham',	1,	47968,	'2019-03-16 03:59:51',	'Studham',	'Studham',	'Studham'),
(2636616,	77,	2648402,	'Страуд',	'Stroud',	'Stroud',	1,	47945,	'2019-03-16 03:59:51',	'Stroud',	'Stroud',	'Stroud'),
(2636619,	77,	3333158,	'Strood',	'Strood',	'Strood',	1,	47942,	'2019-03-16 03:59:51',	'Strood',	'Strood',	'Strood'),
(2636661,	77,	2653940,	'Stretham',	'Stretham',	'Stretham',	1,	47922,	'2019-03-16 03:59:51',	'Stretham',	'Stretham',	'Stretham'),
(2636663,	77,	3333211,	'Стретфорд',	'Stretford',	'Stretford',	1,	47921,	'2019-03-16 03:59:51',	'Stretford',	'Stretford',	'Stretford'),
(2636670,	77,	3333213,	'Streetly',	'Streetly',	'Streetly',	1,	47914,	'2019-03-16 03:59:51',	'Streetly',	'Streetly',	'Streetly'),
(2636675,	77,	2648110,	'Streatham',	'Streatham',	'Streatham',	1,	47910,	'2019-03-16 03:59:51',	'Streatham',	'Streatham',	'Streatham'),
(2636677,	77,	2648110,	'Strawberry Hill',	'Strawberry Hill',	'Strawberry Hill',	1,	47905,	'2019-03-16 03:59:51',	'Strawberry Hill',	'Strawberry Hill',	'Strawberry Hill'),
(2636680,	77,	2640726,	'Stratton Audley',	'Stratton Audley',	'Stratton Audley',	1,	47898,	'2019-03-16 03:59:51',	'Stratton Audley',	'Stratton Audley',	'Stratton Audley'),
(2636697,	77,	2649469,	'Strathkinness',	'Strathkinness',	'Strathkinness',	1,	47893,	'2019-03-16 03:59:51',	'Strathkinness',	'Strathkinness',	'Strathkinness'),
(2636704,	77,	2646944,	'Strathcarron',	'Strathcarron',	'Strathcarron',	1,	47892,	'2019-03-16 03:59:51',	'Strathcarron',	'Strathcarron',	'Strathcarron'),
(2636707,	77,	2636909,	'Strathblane',	'Strathblane',	'Strathblane',	1,	47891,	'2019-03-16 03:59:51',	'Strathblane',	'Strathblane',	'Strathblane'),
(2636710,	77,	3333236,	'Strathaven',	'Strathaven',	'Strathaven',	1,	47890,	'2019-03-16 03:59:51',	'Strathaven',	'Strathaven',	'Strathaven'),
(2636713,	77,	2634723,	'Стратфорд-на-Эйвоне',	'Stratford-upon-Avon',	'Stratford-upon-Avon',	1,	47888,	'2019-03-16 03:59:51',	'Stratford-upon-Avon',	'Stratford-upon-Avon',	'Stratford-upon-Avon'),
(2636714,	77,	2648110,	'Стратфорд',	'Stratford',	'Stratford',	1,	47883,	'2019-03-16 03:59:51',	'Stratford',	'Stratford',	'Stratford'),
(2636716,	77,	3333217,	'Stratfield Mortimer',	'Stratfield Mortimer',	'Stratfield Mortimer',	1,	47877,	'2019-03-16 03:59:51',	'Stratfield Mortimer',	'Stratfield Mortimer',	'Stratfield Mortimer'),
(2636719,	77,	2650797,	'Странрар',	'Stranraer',	'Stranraer',	1,	47866,	'2019-03-16 03:59:51',	'Stranraer',	'Stranraer',	'Stranraer'),
(2636744,	77,	2636745,	'Страбэйн',	'Strabane',	'Strabane',	1,	47851,	'2019-03-16 03:59:51',	'Strabane',	'Strabane',	'Strabane'),
(2636749,	77,	2636561,	'Stowmarket',	'Stowmarket',	'Stowmarket',	1,	47846,	'2019-03-16 03:59:51',	'Stowmarket',	'Stowmarket',	'Stowmarket'),
(2636755,	77,	2637141,	'Stowe',	'Stowe',	'Stowe',	1,	47845,	'2019-03-16 03:59:51',	'Stowe',	'Stowe',	'Stowe'),
(2636757,	77,	2641455,	'Stowbridge',	'Stowbridge',	'Stowbridge',	1,	47843,	'2019-03-16 03:59:51',	'Stowbridge',	'Stowbridge',	'Stowbridge'),
(2636760,	77,	2655192,	'Stow',	'Stow',	'Stow',	1,	47839,	'2019-03-16 03:59:51',	'Stow',	'Stow',	'Stow'),
(2636767,	77,	2633560,	'Stourport-on-Severn',	'Stourport-on-Severn',	'Stourport-on-Severn',	1,	47834,	'2019-03-16 03:59:51',	'Stourport-on-Severn',	'Stourport-on-Severn',	'Stourport-on-Severn'),
(2636769,	77,	3333144,	'Стоурбридж',	'Stourbridge',	'Stourbridge',	1,	47833,	'2019-03-16 03:59:51',	'Stourbridge',	'Stourbridge',	'Stourbridge'),
(2636782,	77,	7290535,	'Stotfold',	'Stotfold',	'Stotfold',	1,	47826,	'2019-03-16 03:59:51',	'Stotfold',	'Stotfold',	'Stotfold'),
(2636786,	77,	2634258,	'Storrington',	'Storrington',	'Storrington',	1,	47820,	'2019-03-16 03:59:51',	'Storrington',	'Storrington',	'Storrington'),
(2636790,	77,	2634428,	'Сторновей',	'Stornoway',	'Stornoway',	1,	47817,	'2019-03-16 03:59:51',	'Stornoway',	'Stornoway',	'Stornoway'),
(2636802,	77,	2644667,	'Stoney Stanton',	'Stoney Stanton',	'Stoney Stanton',	1,	47799,	'2019-03-16 03:59:51',	'Stoney Stanton',	'Stoney Stanton',	'Stoney Stanton'),
(2636809,	77,	2634723,	'Stoneleigh',	'Stoneleigh',	'Stoneleigh',	1,	47794,	'2019-03-16 03:59:51',	'Stoneleigh',	'Stoneleigh',	'Stoneleigh'),
(2636810,	77,	3333236,	'Stonehouse',	'Stonehouse',	'Stonehouse',	1,	47792,	'2019-03-16 03:59:51',	'Stonehouse',	'Stonehouse',	'Stonehouse'),
(2636811,	77,	2648402,	'Stonehouse',	'Stonehouse',	'Stonehouse',	1,	47793,	'2019-03-16 03:59:51',	'Stonehouse',	'Stonehouse',	'Stonehouse'),
(2636822,	77,	2637141,	'Stone',	'Stone',	'Stone',	1,	47785,	'2019-03-16 03:59:51',	'Stone',	'Stone',	'Stone'),
(2636829,	77,	2638655,	'Stoke upon Tern',	'Stoke upon Tern',	'Stoke upon Tern',	1,	47769,	'2019-03-16 03:59:51',	'Stoke upon Tern',	'Stoke upon Tern',	'Stoke upon Tern'),
(2636830,	77,	2641209,	'Stokesley',	'Stokesley',	'Stokesley',	1,	47773,	'2019-03-16 03:59:51',	'Stokesley',	'Stokesley',	'Stokesley'),
(2636840,	77,	2654408,	'Stoke Poges',	'Stoke Poges',	'Stoke Poges',	1,	47768,	'2019-03-16 03:59:51',	'Stoke Poges',	'Stoke Poges',	'Stoke Poges'),
(2636841,	77,	3333204,	'Сток-он-Трент',	'Stoke-on-Trent',	'Stoke-on-Trent',	1,	47770,	'2019-03-16 03:59:51',	'Stoke-on-Trent',	'Stoke-on-Trent',	'Stoke-on-Trent'),
(2636843,	77,	2648110,	'Stoke Newington',	'Stoke Newington',	'Stoke Newington',	1,	47767,	'2019-03-16 03:59:51',	'Stoke Newington',	'Stoke Newington',	'Stoke Newington'),
(2636856,	77,	2651292,	'Stoke Fleming',	'Stoke Fleming',	'Stoke Fleming',	1,	47766,	'2019-03-16 03:59:51',	'Stoke Fleming',	'Stoke Fleming',	'Stoke Fleming'),
(2636863,	77,	2636561,	'Stoke by Nayland',	'Stoke by Nayland',	'Stoke by Nayland',	1,	47765,	'2019-03-16 03:59:51',	'Stoke by Nayland',	'Stoke by Nayland',	'Stoke by Nayland'),
(2636875,	77,	2633560,	'Stockton on Teme',	'Stockton on Teme',	'Stockton on Teme',	1,	47757,	'2019-03-16 03:59:51',	'Stockton on Teme',	'Stockton on Teme',	'Stockton on Teme'),
(2636876,	77,	3333203,	'Стоктон-он-Тис',	'Stockton-on-Tees',	'Stockton-on-Tees',	1,	47759,	'2019-03-16 03:59:51',	'Stockton-on-Tees',	'Stockton-on-Tees',	'Stockton-on-Tees'),
(2636878,	77,	2634723,	'Stockton',	'Stockton',	'Stockton',	1,	47748,	'2019-03-16 03:59:51',	'Stockton',	'Stockton',	'Stockton'),
(2636880,	77,	2641235,	'Stocksfield',	'Stocksfield',	'Stocksfield',	1,	47745,	'2019-03-16 03:59:51',	'Stocksfield',	'Stocksfield',	'Stocksfield'),
(2636881,	77,	3333193,	'Stocksbridge',	'Stocksbridge',	'Stocksbridge',	1,	47743,	'2019-03-16 03:59:51',	'Stocksbridge',	'Stocksbridge',	'Stocksbridge'),
(2636882,	77,	3333202,	'Стокпорт',	'Stockport',	'Stockport',	1,	47742,	'2019-03-16 03:59:51',	'Stockport',	'Stockport',	'Stockport'),
(2636895,	77,	2647554,	'Stockbridge',	'Stockbridge',	'Stockbridge',	1,	47726,	'2019-03-16 03:59:51',	'Stockbridge',	'Stockbridge',	'Stockbridge'),
(2636896,	77,	2649889,	'Stock',	'Stock',	'Stock',	1,	47724,	'2019-03-16 03:59:51',	'Stock',	'Stock',	'Stock'),
(2636904,	77,	2644486,	'Stixwould',	'Stixwould',	'Stixwould',	1,	47723,	'2019-03-16 03:59:51',	'Stixwould',	'Stixwould',	'Stixwould'),
(2636910,	77,	2636909,	'Стерлинг',	'Stirling',	'Stirling',	1,	47718,	'2019-03-16 03:59:51',	'Stirling',	'Stirling',	'Stirling'),
(2636918,	77,	2649889,	'Stifford',	'Stifford',	'Stifford',	1,	47697,	'2019-03-16 03:59:51',	'Stifford',	'Stifford',	'Stifford'),
(2636921,	77,	2641455,	'Stiffkey',	'Stiffkey',	'Stiffkey',	1,	47696,	'2019-03-16 03:59:51',	'Stiffkey',	'Stiffkey',	'Stiffkey'),
(2636928,	77,	2634258,	'Steyning',	'Steyning',	'Steyning',	1,	47692,	'2019-03-16 03:59:51',	'Steyning',	'Steyning',	'Steyning'),
(2636930,	77,	2654408,	'Stewkley',	'Stewkley',	'Stewkley',	1,	47690,	'2019-03-16 03:59:51',	'Stewkley',	'Stewkley',	'Stewkley'),
(2636932,	77,	3333226,	'Stewarton',	'Stewarton',	'Stewarton',	1,	47686,	'2019-03-16 03:59:51',	'Stewarton',	'Stewarton',	'Stewarton'),
(2636935,	77,	7290534,	'Stevington',	'Stevington',	'Stevington',	1,	47681,	'2019-03-16 03:59:51',	'Stevington',	'Stevington',	'Stevington'),
(2636938,	77,	3333232,	'Stevenston',	'Stevenston',	'Stevenston',	1,	47677,	'2019-03-16 03:59:51',	'Stevenston',	'Stevenston',	'Stevenston'),
(2636940,	77,	2647043,	'Стивенедж',	'Stevenage',	'Stevenage',	1,	47671,	'2019-03-16 03:59:51',	'Stevenage',	'Stevenage',	'Stevenage'),
(2636963,	77,	3333131,	'Steeton',	'Steeton',	'Steeton',	1,	47559,	'2019-03-16 03:59:51',	'Steeton',	'Steeton',	'Steeton'),
(2636967,	77,	2654408,	'Steeple Claydon',	'Steeple Claydon',	'Steeple Claydon',	1,	47558,	'2019-03-16 03:59:51',	'Steeple Claydon',	'Steeple Claydon',	'Steeple Claydon'),
(2636969,	77,	2640726,	'Steeple Aston',	'Steeple Aston',	'Steeple Aston',	1,	47557,	'2019-03-16 03:59:51',	'Steeple Aston',	'Steeple Aston',	'Steeple Aston'),
(2636970,	77,	2633868,	'Steeple Ashton',	'Steeple Ashton',	'Steeple Ashton',	1,	47556,	'2019-03-16 03:59:51',	'Steeple Ashton',	'Steeple Ashton',	'Steeple Ashton'),
(2636979,	77,	3333125,	'Stechford',	'Stechford',	'Stechford',	1,	47541,	'2019-03-16 03:59:51',	'Stechford',	'Stechford',	'Stechford'),
(2636984,	77,	2641169,	'Staythorpe',	'Staythorpe',	'Staythorpe',	1,	47533,	'2019-03-16 03:59:51',	'Staythorpe',	'Staythorpe',	'Staythorpe'),
(2636989,	77,	2641429,	'Staverton',	'Staverton',	'Staverton',	1,	47531,	'2019-03-16 03:59:51',	'Staverton',	'Staverton',	'Staverton'),
(2636995,	77,	2651346,	'Staveley',	'Staveley',	'Staveley',	1,	47530,	'2019-03-16 03:59:51',	'Staveley',	'Staveley',	'Staveley'),
(2637016,	77,	3333158,	'Staplehurst',	'Staplehurst',	'Staplehurst',	1,	47477,	'2019-03-16 03:59:51',	'Staplehurst',	'Staplehurst',	'Staplehurst'),
(2637022,	77,	2641169,	'Stapleford',	'Stapleford',	'Stapleford',	1,	47476,	'2019-03-16 03:59:51',	'Stapleford',	'Stapleford',	'Stapleford'),
(2637029,	77,	3333158,	'Staple',	'Staple',	'Staple',	1,	47475,	'2019-03-16 03:59:51',	'Staple',	'Staple',	'Staple'),
(2637034,	77,	2641429,	'Stanwick',	'Stanwick',	'Stanwick',	1,	47469,	'2019-03-16 03:59:51',	'Stanwick',	'Stanwick',	'Stanwick'),
(2637035,	77,	2636512,	'Stanwell',	'Stanwell',	'Stanwell',	1,	47468,	'2019-03-16 03:59:51',	'Stanwell',	'Stanwell',	'Stanwell'),
(2637038,	77,	2633868,	'Stanton Saint Quintin',	'Stanton Saint Quintin',	'Stanton Saint Quintin',	1,	47466,	'2019-03-16 03:59:51',	'Stanton Saint Quintin',	'Stanton Saint Quintin',	'Stanton Saint Quintin'),
(2637046,	77,	2651346,	'Stanton by Dale',	'Stanton by Dale',	'Stanton by Dale',	1,	47465,	'2019-03-16 03:59:51',	'Stanton by Dale',	'Stanton by Dale',	'Stanton by Dale'),
(2637048,	77,	2637141,	'Stanton',	'Stanton',	'Stanton',	1,	47457,	'2019-03-16 03:59:51',	'Stanton',	'Stanton',	'Stanton'),
(2637050,	77,	2648402,	'Stanton',	'Stanton',	'Stanton',	1,	47462,	'2019-03-16 03:59:51',	'Stanton',	'Stanton',	'Stanton'),
(2637052,	77,	2649889,	'Stansted',	'Stansted',	'Stansted',	1,	47454,	'2019-03-16 03:59:51',	'Stansted',	'Stansted',	'Stansted'),
(2637053,	77,	3333158,	'Stansted',	'Stansted',	'Stansted',	1,	47455,	'2019-03-16 03:59:51',	'Stansted',	'Stansted',	'Stansted'),
(2637055,	77,	2636561,	'Stanstead',	'Stanstead',	'Stanstead',	1,	47453,	'2019-03-16 03:59:51',	'Stanstead',	'Stanstead',	'Stanstead'),
(2637063,	77,	2648110,	'Stanmore',	'Stanmore',	'Stanmore',	1,	47452,	'2019-03-16 03:59:51',	'Stanmore',	'Stanmore',	'Stanmore'),
(2637072,	77,	3333212,	'Stanley',	'Stanley',	'Stanley',	1,	47444,	'2019-03-16 03:59:51',	'Stanley',	'Stanley',	'Stanley'),
(2637073,	77,	2651346,	'Stanley',	'Stanley',	'Stanley',	1,	47449,	'2019-03-16 03:59:51',	'Stanley',	'Stanley',	'Stanley'),
(2637074,	77,	2641429,	'Stanion',	'Stanion',	'Stanion',	1,	47441,	'2019-03-16 03:59:51',	'Stanion',	'Stanion',	'Stanion'),
(2637078,	77,	2650629,	'Stanhope',	'Stanhope',	'Stanhope',	1,	47440,	'2019-03-16 03:59:51',	'Stanhope',	'Stanhope',	'Stanhope'),
(2637080,	77,	3333180,	'Stanground',	'Stanground',	'Stanground',	1,	47437,	'2019-03-16 03:59:51',	'Stanground',	'Stanground',	'Stanground'),
(2637086,	77,	2641429,	'Stanford on Avon',	'Stanford on Avon',	'Stanford on Avon',	1,	47433,	'2019-03-16 03:59:51',	'Stanford on Avon',	'Stanford on Avon',	'Stanford on Avon'),
(2637087,	77,	2649889,	'Stanford-le-Hope',	'Stanford-le-Hope',	'Stanford-le-Hope',	1,	47434,	'2019-03-16 03:59:51',	'Stanford-le-Hope',	'Stanford-le-Hope',	'Stanford-le-Hope'),
(2637091,	77,	2641455,	'Stanford',	'Stanford',	'Stanford',	1,	47430,	'2019-03-16 03:59:51',	'Stanford',	'Stanford',	'Stanford'),
(2637092,	77,	3333158,	'Stanford',	'Stanford',	'Stanford',	1,	47431,	'2019-03-16 03:59:51',	'Stanford',	'Stanford',	'Stanford'),
(2637093,	77,	2637141,	'Standon',	'Standon',	'Standon',	1,	47424,	'2019-03-16 03:59:51',	'Standon',	'Standon',	'Standon'),
(2637096,	77,	3333219,	'Standish',	'Standish',	'Standish',	1,	47423,	'2019-03-16 03:59:51',	'Standish',	'Standish',	'Standish'),
(2637104,	77,	2644486,	'Стамфорд',	'Stamford',	'Stamford',	1,	47412,	'2019-03-16 03:59:51',	'Stamford',	'Stamford',	'Stamford'),
(2637106,	77,	3333208,	'Сталибридж',	'Stalybridge',	'Stalybridge',	1,	47407,	'2019-03-16 03:59:51',	'Stalybridge',	'Stalybridge',	'Stalybridge'),
(2637108,	77,	3333175,	'Stallingborough',	'Stallingborough',	'Stallingborough',	1,	47406,	'2019-03-16 03:59:51',	'Stallingborough',	'Stallingborough',	'Stallingborough'),
(2637110,	77,	2641455,	'Stalham',	'Stalham',	'Stalham',	1,	47405,	'2019-03-16 03:59:51',	'Stalham',	'Stalham',	'Stalham'),
(2637111,	77,	2651079,	'Stalbridge',	'Stalbridge',	'Stalbridge',	1,	47402,	'2019-03-16 03:59:51',	'Stalbridge',	'Stalbridge',	'Stalbridge'),
(2637124,	77,	3333143,	'Stainforth',	'Stainforth',	'Stainforth',	1,	47399,	'2019-03-16 03:59:51',	'Stainforth',	'Stainforth',	'Stainforth'),
(2637126,	77,	2636512,	'Staines',	'Staines',	'Staines',	1,	47398,	'2019-03-16 03:59:51',	'Staines',	'Staines',	'Staines'),
(2637142,	77,	2637141,	'Стаффорд',	'Stafford',	'Stafford',	1,	47386,	'2019-03-16 03:59:51',	'Stafford',	'Stafford',	'Stafford'),
(2637181,	77,	2644667,	'Sprowston',	'Sprowston',	'Sprowston',	1,	47339,	'2019-03-16 03:59:51',	'Sprowston',	'Sprowston',	'Sprowston'),
(2637217,	77,	2641235,	'Spittal',	'Spittal',	'Spittal',	1,	47224,	'2019-03-16 03:59:51',	'Spittal',	'Spittal',	'Spittal'),
(2637224,	77,	2644486,	'Spilsby',	'Spilsby',	'Spilsby',	1,	47209,	'2019-03-16 03:59:51',	'Spilsby',	'Spilsby',	'Spilsby'),
(2637235,	77,	2650629,	'Spennymoor',	'Spennymoor',	'Spennymoor',	1,	47181,	'2019-03-16 03:59:51',	'Spennymoor',	'Spennymoor',	'Spennymoor'),
(2637240,	77,	3333158,	'Speldhurst',	'Speldhurst',	'Speldhurst',	1,	47162,	'2019-03-16 03:59:51',	'Speldhurst',	'Speldhurst',	'Speldhurst'),
(2637241,	77,	3333167,	'Speke',	'Speke',	'Speke',	1,	47161,	'2019-03-16 03:59:51',	'Speke',	'Speke',	'Speke'),
(2637245,	77,	3333217,	'Speen',	'Speen',	'Speen',	1,	47156,	'2019-03-16 03:59:51',	'Speen',	'Speen',	'Speen'),
(2637254,	77,	2647554,	'Sparsholt',	'Sparsholt',	'Sparsholt',	1,	47132,	'2019-03-16 03:59:51',	'Sparsholt',	'Sparsholt',	'Sparsholt'),
(2637265,	77,	2644486,	'Spalding',	'Spalding',	'Spalding',	1,	47110,	'2019-03-16 03:59:51',	'Spalding',	'Spalding',	'Spalding'),
(2637268,	77,	3333137,	'Sowerby Bridge',	'Sowerby Bridge',	'Sowerby Bridge',	1,	47099,	'2019-03-16 03:59:51',	'Sowerby Bridge',	'Sowerby Bridge',	'Sowerby Bridge'),
(2637277,	77,	2636561,	'Southwold',	'Southwold',	'Southwold',	1,	47088,	'2019-03-16 03:59:51',	'Southwold',	'Southwold',	'Southwold'),
(2637289,	77,	2634258,	'Southwick',	'Southwick',	'Southwick',	1,	47087,	'2019-03-16 03:59:51',	'Southwick',	'Southwick',	'Southwick'),
(2637296,	77,	2641169,	'Southwell',	'Southwell',	'Southwell',	1,	47083,	'2019-03-16 03:59:51',	'Southwell',	'Southwell',	'Southwell'),
(2637299,	77,	2648110,	'Southwark',	'Southwark',	'Southwark',	1,	47082,	'2019-03-16 03:59:51',	'Southwark',	'Southwark',	'Southwark'),
(2637329,	77,	3333199,	'Саут-Шилдс',	'South Shields',	'South Shields',	1,	47029,	'2019-03-16 03:59:51',	'South Shields',	'South Shields',	'South Shields'),
(2637330,	77,	3333183,	'Southsea',	'Southsea',	'Southsea',	1,	47080,	'2019-03-16 03:59:51',	'Southsea',	'Southsea',	'Southsea'),
(2637335,	77,	2648402,	'Southrop',	'Southrop',	'Southrop',	1,	47079,	'2019-03-16 03:59:51',	'Southrop',	'Southrop',	'Southrop'),
(2637343,	77,	3333192,	'Саутпорт',	'Southport',	'Southport',	1,	47076,	'2019-03-16 03:59:51',	'Southport',	'Southport',	'Southport'),
(2637348,	77,	2651079,	'South Perrott',	'South Perrott',	'South Perrott',	1,	47013,	'2019-03-16 03:59:51',	'South Perrott',	'South Perrott',	'South Perrott'),
(2637355,	77,	2649889,	'South Ockendon',	'South Ockendon',	'South Ockendon',	1,	47003,	'2019-03-16 03:59:51',	'South Ockendon',	'South Ockendon',	'South Ockendon'),
(2637358,	77,	2651346,	'South Normanton',	'South Normanton',	'South Normanton',	1,	47002,	'2019-03-16 03:59:51',	'South Normanton',	'South Normanton',	'South Normanton'),
(2637373,	77,	2651292,	'South Molton',	'South Molton',	'South Molton',	1,	47000,	'2019-03-16 03:59:51',	'South Molton',	'South Molton',	'South Molton'),
(2637374,	77,	2649889,	'Southminster',	'Southminster',	'Southminster',	1,	47073,	'2019-03-16 03:59:51',	'Southminster',	'Southminster',	'Southminster'),
(2637377,	77,	2641209,	'South Milford',	'South Milford',	'South Milford',	1,	46997,	'2019-03-16 03:59:51',	'South Milford',	'South Milford',	'South Milford'),
(2637381,	77,	2641455,	'South Lopham',	'South Lopham',	'South Lopham',	1,	46994,	'2019-03-16 03:59:51',	'South Lopham',	'South Lopham',	'South Lopham'),
(2637383,	77,	2641169,	'South Leverton',	'South Leverton',	'South Leverton',	1,	46992,	'2019-03-16 03:59:51',	'South Leverton',	'South Leverton',	'South Leverton'),
(2637392,	77,	2644486,	'South Killingholme',	'South Killingholme',	'South Killingholme',	1,	46988,	'2019-03-16 03:59:51',	'South Killingholme',	'South Killingholme',	'South Killingholme'),
(2637405,	77,	2650629,	'South Hetton',	'South Hetton',	'South Hetton',	1,	46981,	'2019-03-16 03:59:51',	'South Hetton',	'South Hetton',	'South Hetton'),
(2637407,	77,	2647554,	'South Hayling',	'South Hayling',	'South Hayling',	1,	46978,	'2019-03-16 03:59:51',	'South Hayling',	'South Hayling',	'South Hayling'),
(2637410,	77,	2634258,	'South Harting',	'South Harting',	'South Harting',	1,	46973,	'2019-03-16 03:59:51',	'South Harting',	'South Harting',	'South Harting'),
(2637418,	77,	2648110,	'Southgate',	'Southgate',	'Southgate',	1,	47066,	'2019-03-16 03:59:51',	'Southgate',	'Southgate',	'Southgate'),
(2637421,	77,	3333158,	'Southfleet',	'Southfleet',	'Southfleet',	1,	47065,	'2019-03-16 03:59:51',	'Southfleet',	'Southfleet',	'Southfleet'),
(2637433,	77,	3333197,	'Саутенд-он-Си',	'Southend-on-Sea',	'Southend-on-Sea',	1,	47062,	'2019-03-16 03:59:51',	'Southend-on-Sea',	'Southend-on-Sea',	'Southend-on-Sea'),
(2637435,	77,	3333212,	'South Elmsall',	'South Elmsall',	'South Elmsall',	1,	46959,	'2019-03-16 03:59:51',	'South Elmsall',	'South Elmsall',	'South Elmsall'),
(2637461,	77,	2650345,	'South Cave',	'South Cave',	'South Cave',	1,	46946,	'2019-03-16 03:59:51',	'South Cave',	'South Cave',	'South Cave'),
(2637471,	77,	2651292,	'South Brent',	'South Brent',	'South Brent',	1,	46941,	'2019-03-16 03:59:51',	'South Brent',	'South Brent',	'South Brent'),
(2637473,	77,	3333129,	'Southbourne',	'Southbourne',	'Southbourne',	1,	47059,	'2019-03-16 03:59:51',	'Southbourne',	'Southbourne',	'Southbourne'),
(2637474,	77,	3333158,	'Southborough',	'Southborough',	'Southborough',	1,	47058,	'2019-03-16 03:59:51',	'Southborough',	'Southborough',	'Southborough'),
(2637476,	77,	2649889,	'South Benfleet',	'South Benfleet',	'South Benfleet',	1,	46935,	'2019-03-16 03:59:51',	'South Benfleet',	'South Benfleet',	'South Benfleet'),
(2637487,	77,	3333196,	'Саутгемптон',	'Southampton',	'Southampton',	1,	47052,	'2019-03-16 03:59:51',	'Southampton',	'Southampton',	'Southampton'),
(2637488,	77,	2634723,	'Southam',	'Southam',	'Southam',	1,	47051,	'2019-03-16 03:59:51',	'Southam',	'Southam',	'Southam'),
(2637490,	77,	2648110,	'Саутолл',	'Southall',	'Southall',	1,	47050,	'2019-03-16 03:59:51',	'Southall',	'Southall',	'Southall'),
(2637506,	77,	2654408,	'Soulbury',	'Soulbury',	'Soulbury',	1,	46893,	'2019-03-16 03:59:51',	'Soulbury',	'Soulbury',	'Soulbury'),
(2637524,	77,	2634258,	'Sompting',	'Sompting',	'Sompting',	1,	46774,	'2019-03-16 03:59:51',	'Sompting',	'Sompting',	'Sompting'),
(2637526,	77,	2640726,	'Somerton',	'Somerton',	'Somerton',	1,	46741,	'2019-03-16 03:59:51',	'Somerton',	'Somerton',	'Somerton'),
(2637527,	77,	2637532,	'Somerton',	'Somerton',	'Somerton',	1,	46740,	'2019-03-16 03:59:51',	'Somerton',	'Somerton',	'Somerton'),
(2637528,	77,	2653940,	'Somersham',	'Somersham',	'Somersham',	1,	46738,	'2019-03-16 03:59:51',	'Somersham',	'Somersham',	'Somersham'),
(2637543,	77,	2640500,	'Solva',	'Solva',	'Solva',	1,	46717,	'2019-03-16 03:59:51',	'Solva',	'Solva',	'Solva'),
(2637546,	77,	3333195,	'Солихалл',	'Solihull',	'Solihull',	1,	46681,	'2019-03-16 03:59:51',	'Solihull',	'Solihull',	'Solihull'),
(2637554,	77,	2653940,	'Soham',	'Soham',	'Soham',	1,	46628,	'2019-03-16 03:59:51',	'Soham',	'Soham',	'Soham'),
(2637556,	77,	2647554,	'Soberton',	'Soberton',	'Soberton',	1,	46604,	'2019-03-16 03:59:51',	'Soberton',	'Soberton',	'Soberton'),
(2637571,	77,	3333158,	'Snodland',	'Snodland',	'Snodland',	1,	46585,	'2019-03-16 03:59:51',	'Snodland',	'Snodland',	'Snodland'),
(2637582,	77,	2641455,	'Snetterton',	'Snetterton',	'Snetterton',	1,	46582,	'2019-03-16 03:59:51',	'Snetterton',	'Snetterton',	'Snetterton'),
(2637585,	77,	3333178,	'Sneinton',	'Sneinton',	'Sneinton',	1,	46580,	'2019-03-16 03:59:51',	'Sneinton',	'Sneinton',	'Sneinton'),
(2637595,	77,	2648110,	'Snaresbrook',	'Snaresbrook',	'Snaresbrook',	1,	46576,	'2019-03-16 03:59:51',	'Snaresbrook',	'Snaresbrook',	'Snaresbrook'),
(2637599,	77,	2650345,	'Snaith',	'Snaith',	'Snaith',	1,	46575,	'2019-03-16 03:59:51',	'Snaith',	'Snaith',	'Snaith'),
(2637607,	77,	3333191,	'Smethwick',	'Smethwick',	'Smethwick',	1,	46528,	'2019-03-16 03:59:51',	'Smethwick',	'Smethwick',	'Smethwick'),
(2637620,	77,	2651346,	'Smalley',	'Smalley',	'Smalley',	1,	46522,	'2019-03-16 03:59:51',	'Smalley',	'Smalley',	'Smalley'),
(2637627,	77,	3333194,	'Слау',	'Slough',	'Slough',	1,	46517,	'2019-03-16 03:59:51',	'Slough',	'Slough',	'Slough'),
(2637656,	77,	2650345,	'Sledmere',	'Sledmere',	'Sledmere',	1,	46502,	'2019-03-16 03:59:51',	'Sledmere',	'Sledmere',	'Sledmere'),
(2637659,	77,	2644486,	'Sleaford',	'Sleaford',	'Sleaford',	1,	46500,	'2019-03-16 03:59:51',	'Sleaford',	'Sleaford',	'Sleaford'),
(2637701,	77,	2641209,	'Skipwith',	'Skipwith',	'Skipwith',	1,	46479,	'2019-03-16 03:59:51',	'Skipwith',	'Skipwith',	'Skipwith'),
(2637702,	77,	2641209,	'Skipton',	'Skipton',	'Skipton',	1,	46478,	'2019-03-16 03:59:51',	'Skipton',	'Skipton',	'Skipton'),
(2637710,	77,	3333186,	'Skinningrove',	'Skinningrove',	'Skinningrove',	1,	46476,	'2019-03-16 03:59:51',	'Skinningrove',	'Skinningrove',	'Skinningrove'),
(2637716,	77,	2650345,	'Skidby',	'Skidby',	'Skidby',	1,	46473,	'2019-03-16 03:59:51',	'Skidby',	'Skidby',	'Skidby'),
(2637746,	77,	3333186,	'Skelton',	'Skelton',	'Skelton',	1,	46470,	'2019-03-16 03:59:51',	'Skelton',	'Skelton',	'Skelton'),
(2637751,	77,	3333232,	'Skelmorlie',	'Skelmorlie',	'Skelmorlie',	1,	46469,	'2019-03-16 03:59:51',	'Skelmorlie',	'Skelmorlie',	'Skelmorlie'),
(2637752,	77,	2644974,	'Skelmersdale',	'Skelmersdale',	'Skelmersdale',	1,	46468,	'2019-03-16 03:59:51',	'Skelmersdale',	'Skelmersdale',	'Skelmersdale'),
(2637762,	77,	2644486,	'Skegness',	'Skegness',	'Skegness',	1,	46466,	'2019-03-16 03:59:51',	'Skegness',	'Skegness',	'Skegness'),
(2637802,	77,	3333158,	'Ситтингборн',	'Sittingbourne',	'Sittingbourne',	1,	46446,	'2019-03-16 03:59:51',	'Sittingbourne',	'Sittingbourne',	'Sittingbourne'),
(2637827,	77,	2641429,	'Silverstone',	'Silverstone',	'Silverstone',	1,	46341,	'2019-03-16 03:59:51',	'Silverstone',	'Silverstone',	'Silverstone'),
(2637832,	77,	7290535,	'Silsoe',	'Silsoe',	'Silsoe',	1,	46317,	'2019-03-16 03:59:51',	'Silsoe',	'Silsoe',	'Silsoe'),
(2637833,	77,	3333131,	'Silsden',	'Silsden',	'Silsden',	1,	46316,	'2019-03-16 03:59:51',	'Silsden',	'Silsden',	'Silsden'),
(2637836,	77,	2651712,	'Silloth',	'Silloth',	'Silloth',	1,	46309,	'2019-03-16 03:59:51',	'Silloth',	'Silloth',	'Silloth'),
(2637853,	77,	2651292,	'Сидмут',	'Sidmouth',	'Sidmouth',	1,	46226,	'2019-03-16 03:59:51',	'Sidmouth',	'Sidmouth',	'Sidmouth'),
(2637861,	77,	2648110,	'Sidcup',	'Sidcup',	'Sidcup',	1,	46218,	'2019-03-16 03:59:51',	'Sidcup',	'Sidcup',	'Sidcup'),
(2637862,	77,	3333177,	'Sidcot',	'Sidcot',	'Sidcot',	1,	46217,	'2019-03-16 03:59:51',	'Sidcot',	'Sidcot',	'Sidcot'),
(2637871,	77,	2649889,	'Sible Hedingham',	'Sible Hedingham',	'Sible Hedingham',	1,	46206,	'2019-03-16 03:59:51',	'Sible Hedingham',	'Sible Hedingham',	'Sible Hedingham'),
(2637878,	77,	2648402,	'Shurdington',	'Shurdington',	'Shurdington',	1,	46195,	'2019-03-16 03:59:51',	'Shurdington',	'Shurdington',	'Shurdington'),
(2637890,	77,	2633868,	'Shrewton',	'Shrewton',	'Shrewton',	1,	46183,	'2019-03-16 03:59:51',	'Shrewton',	'Shrewton',	'Shrewton'),
(2637891,	77,	2638655,	'Шрусбери',	'Shrewsbury',	'Shrewsbury',	1,	46182,	'2019-03-16 03:59:51',	'Shrewsbury',	'Shrewsbury',	'Shrewsbury'),
(2637892,	77,	2634723,	'Shrewley',	'Shrewley',	'Shrewley',	1,	46178,	'2019-03-16 03:59:51',	'Shrewley',	'Shrewley',	'Shrewley'),
(2637901,	77,	2650629,	'Shotton',	'Shotton',	'Shotton',	1,	46173,	'2019-03-16 03:59:51',	'Shotton',	'Shotton',	'Shotton'),
(2637916,	77,	2634258,	'Shoreham-by-Sea',	'Shoreham-by-Sea',	'Shoreham-by-Sea',	1,	46166,	'2019-03-16 03:59:51',	'Shoreham-by-Sea',	'Shoreham-by-Sea',	'Shoreham-by-Sea'),
(2637918,	77,	2648110,	'Shoreditch',	'Shoreditch',	'Shoreditch',	1,	46163,	'2019-03-16 03:59:51',	'Shoreditch',	'Shoreditch',	'Shoreditch'),
(2637926,	77,	3333197,	'Shoeburyness',	'Shoeburyness',	'Shoeburyness',	1,	46157,	'2019-03-16 03:59:51',	'Shoeburyness',	'Shoeburyness',	'Shoeburyness'),
(2637934,	77,	2651346,	'Shirley',	'Shirley',	'Shirley',	1,	46147,	'2019-03-16 03:59:51',	'Shirley',	'Shirley',	'Shirley'),
(2637940,	77,	3333134,	'Shirehampton',	'Shirehampton',	'Shirehampton',	1,	46142,	'2019-03-16 03:59:51',	'Shirehampton',	'Shirehampton',	'Shirehampton'),
(2637941,	77,	2651346,	'Shirebrook',	'Shirebrook',	'Shirebrook',	1,	46141,	'2019-03-16 03:59:51',	'Shirebrook',	'Shirebrook',	'Shirebrook'),
(2637954,	77,	2634723,	'Shipston on Stour',	'Shipston on Stour',	'Shipston on Stour',	1,	46140,	'2019-03-16 03:59:51',	'Shipston on Stour',	'Shipston on Stour',	'Shipston on Stour'),
(2637958,	77,	3333131,	'Shipley',	'Shipley',	'Shipley',	1,	46133,	'2019-03-16 03:59:51',	'Shipley',	'Shipley',	'Shipley'),
(2637962,	77,	2641455,	'Shipdham',	'Shipdham',	'Shipdham',	1,	46132,	'2019-03-16 03:59:51',	'Shipdham',	'Shipdham',	'Shipdham'),
(2637977,	77,	7290535,	'Shillington',	'Shillington',	'Shillington',	1,	46118,	'2019-03-16 03:59:51',	'Shillington',	'Shillington',	'Shillington'),
(2637983,	77,	2650629,	'Shildon',	'Shildon',	'Shildon',	1,	46115,	'2019-03-16 03:59:51',	'Shildon',	'Shildon',	'Shildon'),
(2637985,	77,	2638655,	'Shifnal',	'Shifnal',	'Shifnal',	1,	46114,	'2019-03-16 03:59:51',	'Shifnal',	'Shifnal',	'Shifnal'),
(2638019,	77,	2641455,	'Шерингем',	'Sheringham',	'Sheringham',	1,	46093,	'2019-03-16 03:59:51',	'Sheringham',	'Sheringham',	'Sheringham'),
(2638026,	77,	2636512,	'Shere',	'Shere',	'Shere',	1,	46081,	'2019-03-16 03:59:51',	'Shere',	'Shere',	'Shere'),
(2638027,	77,	2641209,	'Sherburn in Elmet',	'Sherburn in Elmet',	'Sherburn in Elmet',	1,	46079,	'2019-03-16 03:59:51',	'Sherburn in Elmet',	'Sherburn in Elmet',	'Sherburn in Elmet'),
(2638033,	77,	2651079,	'Sherborne',	'Sherborne',	'Sherborne',	1,	46077,	'2019-03-16 03:59:51',	'Sherborne',	'Sherborne',	'Sherborne'),
(2638035,	77,	2637532,	'Shepton Mallet',	'Shepton Mallet',	'Shepton Mallet',	1,	46075,	'2019-03-16 03:59:51',	'Shepton Mallet',	'Shepton Mallet',	'Shepton Mallet'),
(2638036,	77,	2644667,	'Shepshed',	'Shepshed',	'Shepshed',	1,	46074,	'2019-03-16 03:59:51',	'Shepshed',	'Shepshed',	'Shepshed'),
(2638039,	77,	2636512,	'Шеппертон',	'Shepperton',	'Shepperton',	1,	46072,	'2019-03-16 03:59:51',	'Shepperton',	'Shepperton',	'Shepperton'),
(2638043,	77,	2648110,	'Shepherds Bush',	'Shepherds Bush',	'Shepherds Bush',	1,	46069,	'2019-03-16 03:59:51',	'Shepherds Bush',	'Shepherds Bush',	'Shepherds Bush'),
(2638049,	77,	3333173,	'Shenley Church End',	'Shenley Church End',	'Shenley Church End',	1,	46064,	'2019-03-16 03:59:51',	'Shenley Church End',	'Shenley Church End',	'Shenley Church End'),
(2638051,	77,	2647043,	'Shenley AV',	'Shenley AV',	'Shenley AV',	1,	46063,	'2019-03-16 03:59:51',	'Shenley AV',	'Shenley AV',	'Shenley AV'),
(2638053,	77,	2649889,	'Shenfield',	'Shenfield',	'Shenfield',	1,	46062,	'2019-03-16 03:59:51',	'Shenfield',	'Shenfield',	'Shenfield'),
(2638074,	77,	7290535,	'Shefford',	'Shefford',	'Shefford',	1,	46020,	'2019-03-16 03:59:51',	'Shefford',	'Shefford',	'Shefford'),
(2638077,	77,	3333193,	'Шеффилд',	'Sheffield',	'Sheffield',	1,	46018,	'2019-03-16 03:59:51',	'Sheffield',	'Sheffield',	'Sheffield'),
(2638081,	77,	3333158,	'Ширнесс',	'Sheerness',	'Sheerness',	1,	46011,	'2019-03-16 03:59:51',	'Sheerness',	'Sheerness',	'Sheerness'),
(2638111,	77,	2638655,	'Shawbury',	'Shawbury',	'Shawbury',	1,	45998,	'2019-03-16 03:59:51',	'Shawbury',	'Shawbury',	'Shawbury'),
(2638113,	77,	3333179,	'Shaw',	'Shaw',	'Shaw',	1,	45995,	'2019-03-16 03:59:51',	'Shaw',	'Shaw',	'Shaw'),
(2638122,	77,	7290534,	'Sharnbrook',	'Sharnbrook',	'Sharnbrook',	1,	45967,	'2019-03-16 03:59:51',	'Sharnbrook',	'Sharnbrook',	'Sharnbrook'),
(2638127,	77,	2651346,	'Shardlow',	'Shardlow',	'Shardlow',	1,	45964,	'2019-03-16 03:59:51',	'Shardlow',	'Shardlow',	'Shardlow'),
(2638138,	77,	2646007,	'Шанклин',	'Shanklin',	'Shanklin',	1,	45954,	'2019-03-16 03:59:51',	'Shanklin',	'Shanklin',	'Shanklin'),
(2638150,	77,	2636512,	'Shalford',	'Shalford',	'Shalford',	1,	45946,	'2019-03-16 03:59:51',	'Shalford',	'Shalford',	'Shalford'),
(2638157,	77,	2651079,	'Shaftesbury',	'Shaftesbury',	'Shaftesbury',	1,	45934,	'2019-03-16 03:59:51',	'Shaftesbury',	'Shaftesbury',	'Shaftesbury'),
(2638187,	77,	3333158,	'Севенокс',	'Sevenoaks',	'Sevenoaks',	1,	45865,	'2019-03-16 03:59:51',	'Sevenoaks',	'Sevenoaks',	'Sevenoaks'),
(2638188,	77,	2648110,	'Seven Kings',	'Seven Kings',	'Seven Kings',	1,	45861,	'2019-03-16 03:59:51',	'Seven Kings',	'Seven Kings',	'Seven Kings'),
(2638207,	77,	2636512,	'Send',	'Send',	'Send',	1,	45678,	'2019-03-16 03:59:51',	'Send',	'Send',	'Send'),
(2638215,	77,	2641169,	'Selston',	'Selston',	'Selston',	1,	45643,	'2019-03-16 03:59:51',	'Selston',	'Selston',	'Selston'),
(2638219,	77,	2634258,	'Selsey',	'Selsey',	'Selsey',	1,	45641,	'2019-03-16 03:59:51',	'Selsey',	'Selsey',	'Selsey'),
(2638229,	77,	2655192,	'Селкёрк',	'Selkirk',	'Selkirk',	1,	45617,	'2019-03-16 03:59:51',	'Selkirk',	'Selkirk',	'Selkirk'),
(2638235,	77,	2641209,	'Селби',	'Selby',	'Selby',	1,	45600,	'2019-03-16 03:59:51',	'Selby',	'Selby',	'Selby'),
(2638248,	77,	2641235,	'Seghill',	'Seghill',	'Seghill',	1,	45556,	'2019-03-16 03:59:51',	'Seghill',	'Seghill',	'Seghill'),
(2638255,	77,	3333144,	'Sedgley',	'Sedgley',	'Sedgley',	1,	45503,	'2019-03-16 03:59:51',	'Sedgley',	'Sedgley',	'Sedgley'),
(2638259,	77,	2650629,	'Sedgefield',	'Sedgefield',	'Sedgefield',	1,	45501,	'2019-03-16 03:59:51',	'Sedgefield',	'Sedgefield',	'Sedgefield'),
(2638262,	77,	2651712,	'Sedbergh',	'Sedbergh',	'Sedbergh',	1,	45498,	'2019-03-16 03:59:51',	'Sedbergh',	'Sedbergh',	'Sedbergh'),
(2638273,	77,	2641235,	'Seaton Delaval',	'Seaton Delaval',	'Seaton Delaval',	1,	45458,	'2019-03-16 03:59:51',	'Seaton Delaval',	'Seaton Delaval',	'Seaton Delaval'),
(2638274,	77,	3333152,	'Seaton Carew',	'Seaton Carew',	'Seaton Carew',	1,	45457,	'2019-03-16 03:59:51',	'Seaton Carew',	'Seaton Carew',	'Seaton Carew'),
(2638278,	77,	2651292,	'Seaton',	'Seaton',	'Seaton',	1,	45455,	'2019-03-16 03:59:51',	'Seaton',	'Seaton',	'Seaton'),
(2638282,	77,	2651712,	'Seascale',	'Seascale',	'Seascale',	1,	45450,	'2019-03-16 03:59:51',	'Seascale',	'Seascale',	'Seascale'),
(2638284,	77,	2644486,	'Searby',	'Searby',	'Searby',	1,	45443,	'2019-03-16 03:59:51',	'Searby',	'Searby',	'Searby'),
(2638297,	77,	2636512,	'Seale',	'Seale',	'Seale',	1,	45438,	'2019-03-16 03:59:51',	'Seale',	'Seale',	'Seale'),
(2638301,	77,	2641235,	'Seahouses',	'Seahouses',	'Seahouses',	1,	45431,	'2019-03-16 03:59:51',	'Seahouses',	'Seahouses',	'Seahouses'),
(2638302,	77,	2650629,	'Сихем',	'Seaham',	'Seaham',	1,	45430,	'2019-03-16 03:59:51',	'Seaham',	'Seaham',	'Seaham'),
(2638305,	77,	2644667,	'Seagrave',	'Seagrave',	'Seagrave',	1,	45427,	'2019-03-16 03:59:51',	'Seagrave',	'Seagrave',	'Seagrave'),
(2638311,	77,	2650328,	'Seaford',	'Seaford',	'Seaford',	1,	45425,	'2019-03-16 03:59:51',	'Seaford',	'Seaford',	'Seaford'),
(2638314,	77,	3333164,	'Seacroft',	'Seacroft',	'Seacroft',	1,	45420,	'2019-03-16 03:59:51',	'Seacroft',	'Seacroft',	'Seacroft'),
(2638324,	77,	3333176,	'Сканторпе',	'Scunthorpe',	'Scunthorpe',	1,	45408,	'2019-03-16 03:59:51',	'Scunthorpe',	'Scunthorpe',	'Scunthorpe'),
(2638386,	77,	3333164,	'Scholes',	'Scholes',	'Scholes',	1,	45162,	'2019-03-16 03:59:51',	'Scholes',	'Scholes',	'Scholes'),
(2638401,	77,	3333175,	'Scartho',	'Scartho',	'Scartho',	1,	44978,	'2019-03-16 03:59:51',	'Scartho',	'Scartho',	'Scartho'),
(2638419,	77,	2641209,	'Скарборо',	'Scarborough',	'Scarborough',	1,	44971,	'2019-03-16 03:59:51',	'Scarborough',	'Scarborough',	'Scarborough'),
(2638427,	77,	2640923,	'Scapa',	'Scapa',	'Scapa',	1,	44967,	'2019-03-16 03:59:51',	'Scapa',	'Scapa',	'Scapa'),
(2638460,	77,	2641209,	'Saxton',	'Saxton',	'Saxton',	1,	44934,	'2019-03-16 03:59:51',	'Saxton',	'Saxton',	'Saxton'),
(2638464,	77,	2636561,	'Saxmundham',	'Saxmundham',	'Saxmundham',	1,	44930,	'2019-03-16 03:59:51',	'Saxmundham',	'Saxmundham',	'Saxmundham'),
(2638474,	77,	2653940,	'Sawston',	'Sawston',	'Sawston',	1,	44921,	'2019-03-16 03:59:51',	'Sawston',	'Sawston',	'Sawston'),
(2638481,	77,	2647043,	'Sawbridgeworth',	'Sawbridgeworth',	'Sawbridgeworth',	1,	44920,	'2019-03-16 03:59:51',	'Sawbridgeworth',	'Sawbridgeworth',	'Sawbridgeworth'),
(2638490,	77,	2640500,	'Saundersfoot',	'Saundersfoot',	'Saundersfoot',	1,	44828,	'2019-03-16 03:59:51',	'Saundersfoot',	'Saundersfoot',	'Saundersfoot'),
(2638501,	77,	2647043,	'Sarratt',	'Sarratt',	'Sarratt',	1,	44720,	'2019-03-16 03:59:51',	'Sarratt',	'Sarratt',	'Sarratt'),
(2638515,	77,	2644667,	'Sapcote',	'Sapcote',	'Sapcote',	1,	44646,	'2019-03-16 03:59:51',	'Sapcote',	'Sapcote',	'Sapcote'),
(2638528,	77,	2649298,	'Sandycroft',	'Sandycroft',	'Sandycroft',	1,	44372,	'2019-03-16 03:59:51',	'Sandycroft',	'Sandycroft',	'Sandycroft'),
(2638530,	77,	7290535,	'Sandy',	'Sandy',	'Sandy',	1,	44360,	'2019-03-16 03:59:51',	'Sandy',	'Sandy',	'Sandy'),
(2638542,	77,	3333158,	'Sandwich',	'Sandwich',	'Sandwich',	1,	44356,	'2019-03-16 03:59:51',	'Sandwich',	'Sandwich',	'Sandwich'),
(2638543,	77,	3333191,	'Sandwell',	'Sandwell',	'Sandwell',	1,	44354,	'2019-03-16 03:59:51',	'Sandwell',	'Sandwell',	'Sandwell'),
(2638568,	77,	2646007,	'Сандаун',	'Sandown',	'Sandown',	1,	44345,	'2019-03-16 03:59:51',	'Sandown',	'Sandown',	'Sandown'),
(2638576,	77,	2651346,	'Sandiacre',	'Sandiacre',	'Sandiacre',	1,	44340,	'2019-03-16 03:59:51',	'Sandiacre',	'Sandiacre',	'Sandiacre'),
(2638580,	77,	3333130,	'Сандхерст',	'Sandhurst',	'Sandhurst',	1,	44336,	'2019-03-16 03:59:51',	'Sandhurst',	'Sandhurst',	'Sandhurst'),
(2638581,	77,	3333158,	'Sandhurst',	'Sandhurst',	'Sandhurst',	1,	44337,	'2019-03-16 03:59:51',	'Sandhurst',	'Sandhurst',	'Sandhurst'),
(2638588,	77,	3333158,	'Sandgate',	'Sandgate',	'Sandgate',	1,	44334,	'2019-03-16 03:59:51',	'Sandgate',	'Sandgate',	'Sandgate'),
(2638595,	77,	2648110,	'Sanderstead',	'Sanderstead',	'Sanderstead',	1,	44330,	'2019-03-16 03:59:51',	'Sanderstead',	'Sanderstead',	'Sanderstead'),
(2638600,	77,	7290536,	'Sandbach',	'Sandbach',	'Sandbach',	1,	44320,	'2019-03-16 03:59:51',	'Sandbach',	'Sandbach',	'Sandbach'),
(2638635,	77,	3333125,	'Saltley',	'Saltley',	'Saltley',	1,	43873,	'2019-03-16 03:59:51',	'Saltley',	'Saltley',	'Saltley'),
(2638638,	77,	2641455,	'Salthouse',	'Salthouse',	'Salthouse',	1,	43870,	'2019-03-16 03:59:51',	'Salthouse',	'Salthouse',	'Salthouse'),
(2638639,	77,	3333123,	'Saltford',	'Saltford',	'Saltford',	1,	43869,	'2019-03-16 03:59:51',	'Saltford',	'Saltford',	'Saltford'),
(2638648,	77,	3333232,	'Saltcoats',	'Saltcoats',	'Saltcoats',	1,	43866,	'2019-03-16 03:59:51',	'Saltcoats',	'Saltcoats',	'Saltcoats'),
(2638650,	77,	3333186,	'Saltburn-by-the-Sea',	'Saltburn-by-the-Sea',	'Saltburn-by-the-Sea',	1,	43865,	'2019-03-16 03:59:51',	'Saltburn-by-the-Sea',	'Saltburn-by-the-Sea',	'Saltburn-by-the-Sea'),
(2638651,	77,	2652355,	'Saltash',	'Saltash',	'Saltash',	1,	43864,	'2019-03-16 03:59:51',	'Saltash',	'Saltash',	'Saltash'),
(2638652,	77,	3333131,	'Saltaire',	'Saltaire',	'Saltaire',	1,	43862,	'2019-03-16 03:59:51',	'Saltaire',	'Saltaire',	'Saltaire'),
(2638664,	77,	2633868,	'Солсбери',	'Salisbury',	'Salisbury',	1,	43813,	'2019-03-16 03:59:51',	'Salisbury',	'Salisbury',	'Salisbury'),
(2638671,	77,	3333190,	'Солфорд',	'Salford',	'Salford',	1,	43779,	'2019-03-16 03:59:51',	'Salford',	'Salford',	'Salford'),
(2638678,	77,	3333211,	'Сейл',	'Sale',	'Sale',	1,	43740,	'2019-03-16 03:59:51',	'Sale',	'Sale',	'Sale'),
(2638708,	77,	2649889,	'Saint Osyth',	'Saint Osyth',	'Saint Osyth',	1,	42378,	'2019-03-16 03:59:51',	'Saint Osyth',	'Saint Osyth',	'Saint Osyth'),
(2638717,	77,	2653940,	'Saint Neots',	'Saint Neots',	'Saint Neots',	1,	42377,	'2019-03-16 03:59:51',	'Saint Neots',	'Saint Neots',	'Saint Neots'),
(2638756,	77,	2650328,	'Saint Leonards-on-Sea',	'Saint Leonards-on-Sea',	'Saint Leonards-on-Sea',	1,	42354,	'2019-03-16 03:59:51',	'Saint Leonards-on-Sea',	'Saint Leonards-on-Sea',	'Saint Leonards-on-Sea'),
(2638757,	77,	2651079,	'St Leonards',	'St Leonards',	'St Leonards',	1,	47355,	'2019-03-16 03:59:51',	'St Leonards',	'St Leonards',	'St Leonards'),
(2638776,	77,	2653940,	'Saint Ives',	'Saint Ives',	'Saint Ives',	1,	42329,	'2019-03-16 03:59:51',	'Saint Ives',	'Saint Ives',	'Saint Ives'),
(2638778,	77,	2652355,	'Сент-Айвс',	'St Ives',	'St Ives',	1,	47354,	'2019-03-16 03:59:51',	'St Ives',	'St Ives',	'St Ives'),
(2638785,	77,	3333201,	'Сент-Хеленс',	'Saint Helens',	'Saint Helens',	1,	42323,	'2019-03-16 03:59:51',	'Saint Helens',	'Saint Helens',	'Saint Helens'),
(2638800,	77,	2651038,	'Saintfield',	'Saintfield',	'Saintfield',	1,	43704,	'2019-03-16 03:59:51',	'Saintfield',	'Saintfield',	'Saintfield'),
(2638812,	77,	2652355,	'Saint Dominick',	'Saint Dominick',	'Saint Dominick',	1,	42303,	'2019-03-16 03:59:51',	'Saint Dominick',	'Saint Dominick',	'Saint Dominick'),
(2638814,	77,	2640500,	'Saint Dogmaels',	'Saint Dogmaels',	'Saint Dogmaels',	1,	42302,	'2019-03-16 03:59:51',	'Saint Dogmaels',	'Saint Dogmaels',	'Saint Dogmaels'),
(2638828,	77,	2652355,	'Saint Columb Major',	'Saint Columb Major',	'Saint Columb Major',	1,	42299,	'2019-03-16 03:59:51',	'Saint Columb Major',	'Saint Columb Major',	'Saint Columb Major'),
(2638833,	77,	2653753,	'Saint Clears',	'Saint Clears',	'Saint Clears',	1,	42295,	'2019-03-16 03:59:51',	'Saint Clears',	'Saint Clears',	'Saint Clears'),
(2638853,	77,	2652355,	'St Austell',	'St Austell',	'St Austell',	1,	47353,	'2019-03-16 03:59:51',	'St Austell',	'St Austell',	'St Austell'),
(2638855,	77,	2651385,	'Saint Asaph',	'Saint Asaph',	'Saint Asaph',	1,	42277,	'2019-03-16 03:59:51',	'Saint Asaph',	'Saint Asaph',	'Saint Asaph'),
(2638864,	77,	2649469,	'Сент-Андрус',	'Saint Andrews',	'Saint Andrews',	1,	42270,	'2019-03-16 03:59:51',	'Saint Andrews',	'Saint Andrews',	'Saint Andrews'),
(2638867,	77,	2647043,	'Сент-Олбанс',	'Saint Albans',	'Saint Albans',	1,	42268,	'2019-03-16 03:59:51',	'Saint Albans',	'Saint Albans',	'Saint Albans'),
(2638870,	77,	2652355,	'Saint Agnes',	'Saint Agnes',	'Saint Agnes',	1,	42263,	'2019-03-16 03:59:51',	'Saint Agnes',	'Saint Agnes',	'Saint Agnes'),
(2638878,	77,	2649889,	'Saffron Walden',	'Saffron Walden',	'Saffron Walden',	1,	42222,	'2019-03-16 03:59:51',	'Saffron Walden',	'Saffron Walden',	'Saffron Walden'),
(2638879,	77,	3333179,	'Saddleworth',	'Saddleworth',	'Saddleworth',	1,	42211,	'2019-03-16 03:59:51',	'Saddleworth',	'Saddleworth',	'Saddleworth'),
(2638888,	77,	2650629,	'Sacriston',	'Sacriston',	'Sacriston',	1,	42202,	'2019-03-16 03:59:51',	'Sacriston',	'Sacriston',	'Sacriston'),
(2638894,	77,	2638655,	'Ryton',	'Ryton',	'Ryton',	1,	42143,	'2019-03-16 03:59:51',	'Ryton',	'Ryton',	'Ryton'),
(2638905,	77,	2650328,	'Rye Harbour',	'Rye Harbour',	'Rye Harbour',	1,	42141,	'2019-03-16 03:59:51',	'Rye Harbour',	'Rye Harbour',	'Rye Harbour'),
(2638909,	77,	2650328,	'Рай',	'Rye',	'Rye',	1,	42137,	'2019-03-16 03:59:51',	'Rye',	'Rye',	'Rye'),
(2638911,	77,	2646007,	'Райд',	'Ryde',	'Ryde',	1,	42136,	'2019-03-16 03:59:51',	'Ryde',	'Ryde',	'Ryde'),
(2638914,	77,	3333158,	'Ryarsh',	'Ryarsh',	'Ryarsh',	1,	42131,	'2019-03-16 03:59:51',	'Ryarsh',	'Ryarsh',	'Ryarsh'),
(2638925,	77,	2651385,	'Ратин',	'Ruthin',	'Ruthin',	1,	42113,	'2019-03-16 03:59:51',	'Ruthin',	'Ruthin',	'Ruthin'),
(2638926,	77,	3333236,	'Rutherglen',	'Rutherglen',	'Rutherglen',	1,	42112,	'2019-03-16 03:59:51',	'Rutherglen',	'Rutherglen',	'Rutherglen'),
(2638930,	77,	2634258,	'Rustington',	'Rustington',	'Rustington',	1,	42096,	'2019-03-16 03:59:51',	'Rustington',	'Rustington',	'Rustington'),
(2638934,	77,	2634258,	'Rusper',	'Rusper',	'Rusper',	1,	42066,	'2019-03-16 03:59:51',	'Rusper',	'Rusper',	'Rusper'),
(2638938,	77,	2644486,	'Ruskington',	'Ruskington',	'Ruskington',	1,	42064,	'2019-03-16 03:59:51',	'Ruskington',	'Ruskington',	'Ruskington'),
(2638941,	77,	2641429,	'Rushton',	'Rushton',	'Rushton',	1,	42055,	'2019-03-16 03:59:51',	'Rushton',	'Rushton',	'Rushton'),
(2638944,	77,	2636561,	'Rushmere',	'Rushmere',	'Rushmere',	1,	42052,	'2019-03-16 03:59:51',	'Rushmere',	'Rushmere',	'Rushmere'),
(2638946,	77,	2641429,	'Rushden',	'Rushden',	'Rushden',	1,	42049,	'2019-03-16 03:59:51',	'Rushden',	'Rushden',	'Rushden'),
(2638950,	77,	3333213,	'Rushall',	'Rushall',	'Rushall',	1,	42048,	'2019-03-16 03:59:51',	'Rushall',	'Rushall',	'Rushall'),
(2638960,	77,	2647601,	'Ранкорн',	'Runcorn',	'Runcorn',	1,	42017,	'2019-03-16 03:59:51',	'Runcorn',	'Runcorn',	'Runcorn'),
(2638965,	77,	3333241,	'Rumney',	'Rumney',	'Rumney',	1,	42011,	'2019-03-16 03:59:51',	'Rumney',	'Rumney',	'Rumney'),
(2638976,	77,	2648110,	'Райслип',	'Ruislip',	'Ruislip',	1,	41994,	'2019-03-16 03:59:51',	'Ruislip',	'Ruislip',	'Ruislip'),
(2638977,	77,	2637141,	'Rugeley',	'Rugeley',	'Rugeley',	1,	41978,	'2019-03-16 03:59:51',	'Rugeley',	'Rugeley',	'Rugeley'),
(2638978,	77,	2634723,	'Рагби',	'Rugby',	'Rugby',	1,	41977,	'2019-03-16 03:59:51',	'Rugby',	'Rugby',	'Rugby'),
(2638992,	77,	2634258,	'Rudgwick',	'Rudgwick',	'Rudgwick',	1,	41951,	'2019-03-16 03:59:51',	'Rudgwick',	'Rudgwick',	'Rudgwick'),
(2639001,	77,	3333125,	'Rubery',	'Rubery',	'Rubery',	1,	41927,	'2019-03-16 03:59:51',	'Rubery',	'Rubery',	'Rubery'),
(2639014,	77,	2633484,	'Ruabon',	'Ruabon',	'Ruabon',	1,	41919,	'2019-03-16 03:59:51',	'Ruabon',	'Ruabon',	'Ruabon'),
(2639015,	77,	3333179,	'Royton',	'Royton',	'Royton',	1,	41905,	'2019-03-16 03:59:51',	'Royton',	'Royton',	'Royton'),
(2639018,	77,	2647043,	'Royston',	'Royston',	'Royston',	1,	41903,	'2019-03-16 03:59:51',	'Royston',	'Royston',	'Royston'),
(2639020,	77,	2649889,	'Roydon',	'Roydon',	'Roydon',	1,	41899,	'2019-03-16 03:59:51',	'Roydon',	'Roydon',	'Roydon'),
(2639022,	77,	3333158,	'Ройал Танбридж Уэлс',	'Royal Tunbridge Wells',	'Royal Tunbridge Wells',	1,	41890,	'2019-03-16 03:59:51',	'Royal Tunbridge Wells',	'Royal Tunbridge Wells',	'Royal Tunbridge Wells'),
(2639028,	77,	2649889,	'Roxwell',	'Roxwell',	'Roxwell',	1,	41876,	'2019-03-16 03:59:51',	'Roxwell',	'Roxwell',	'Roxwell'),
(2639040,	77,	3333191,	'Rowley Regis',	'Rowley Regis',	'Rowley Regis',	1,	41867,	'2019-03-16 03:59:51',	'Rowley Regis',	'Rowley Regis',	'Rowley Regis'),
(2639042,	77,	2648772,	'Rowlands Gill',	'Rowlands Gill',	'Rowlands Gill',	1,	41862,	'2019-03-16 03:59:51',	'Rowlands Gill',	'Rowlands Gill',	'Rowlands Gill'),
(2639043,	77,	2647554,	'Rowlands Castle',	'Rowlands Castle',	'Rowlands Castle',	1,	41861,	'2019-03-16 03:59:51',	'Rowlands Castle',	'Rowlands Castle',	'Rowlands Castle'),
(2639045,	77,	2649889,	'Rowhedge',	'Rowhedge',	'Rowhedge',	1,	41857,	'2019-03-16 03:59:51',	'Rowhedge',	'Rowhedge',	'Rowhedge'),
(2639048,	77,	2633868,	'Rowde',	'Rowde',	'Rowde',	1,	41852,	'2019-03-16 03:59:51',	'Rowde',	'Rowde',	'Rowde'),
(2639052,	77,	2650345,	'Routh',	'Routh',	'Routh',	1,	41816,	'2019-03-16 03:59:51',	'Routh',	'Routh',	'Routh'),
(2639074,	77,	2641429,	'Rothwell',	'Rothwell',	'Rothwell',	1,	41735,	'2019-03-16 03:59:51',	'Rothwell',	'Rothwell',	'Rothwell'),
(2639091,	77,	2648110,	'Rotherhithe',	'Rotherhithe',	'Rotherhithe',	1,	41730,	'2019-03-16 03:59:51',	'Rotherhithe',	'Rotherhithe',	'Rotherhithe'),
(2639093,	77,	3333189,	'Ротерем',	'Rotherham',	'Rotherham',	1,	41729,	'2019-03-16 03:59:51',	'Rotherham',	'Rotherham',	'Rotherham'),
(2639104,	77,	2649469,	'Rosyth',	'Rosyth',	'Rosyth',	1,	41703,	'2019-03-16 03:59:51',	'Rosyth',	'Rosyth',	'Rosyth'),
(2639110,	77,	2647071,	'Ross on Wye',	'Ross on Wye',	'Ross on Wye',	1,	41672,	'2019-03-16 03:59:51',	'Ross on Wye',	'Ross on Wye',	'Ross on Wye'),
(2639123,	77,	2633484,	'Rossett',	'Rossett',	'Rossett',	1,	41680,	'2019-03-16 03:59:51',	'Rossett',	'Rossett',	'Rossett'),
(2639161,	77,	2647554,	'Ropley',	'Ropley',	'Ropley',	1,	41535,	'2019-03-16 03:59:51',	'Ropley',	'Ropley',	'Ropley'),
(2639166,	77,	2650345,	'Roos',	'Roos',	'Roos',	1,	41524,	'2019-03-16 03:59:51',	'Roos',	'Roos',	'Roos'),
(2639189,	77,	2647554,	'Romsey',	'Romsey',	'Romsey',	1,	41479,	'2019-03-16 03:59:51',	'Romsey',	'Romsey',	'Romsey'),
(2639191,	77,	3333202,	'Romiley',	'Romiley',	'Romiley',	1,	41467,	'2019-03-16 03:59:51',	'Romiley',	'Romiley',	'Romiley'),
(2639192,	77,	2648110,	'Ромфорд',	'Romford',	'Romford',	1,	41466,	'2019-03-16 03:59:51',	'Romford',	'Romford',	'Romford'),
(2639205,	77,	2637141,	'Rolleston',	'Rolleston',	'Rolleston',	1,	41424,	'2019-03-16 03:59:51',	'Rolleston',	'Rolleston',	'Rolleston'),
(2639223,	77,	2648110,	'Roehampton',	'Roehampton',	'Roehampton',	1,	41349,	'2019-03-16 03:59:51',	'Roehampton',	'Roehampton',	'Roehampton'),
(2639224,	77,	2641209,	'Roecliffe',	'Roecliffe',	'Roecliffe',	1,	41348,	'2019-03-16 03:59:51',	'Roecliffe',	'Roecliffe',	'Roecliffe'),
(2639234,	77,	3333209,	'Rodington',	'Rodington',	'Rodington',	1,	41338,	'2019-03-16 03:59:51',	'Rodington',	'Rodington',	'Rodington'),
(2639265,	77,	2649889,	'Rochford',	'Rochford',	'Rochford',	1,	41220,	'2019-03-16 03:59:51',	'Rochford',	'Rochford',	'Rochford'),
(2639268,	77,	3333170,	'Рочестер',	'Rochester',	'Rochester',	1,	41205,	'2019-03-16 03:59:51',	'Rochester',	'Rochester',	'Rochester'),
(2639272,	77,	3333188,	'Рочдейл',	'Rochdale',	'Rochdale',	1,	41178,	'2019-03-16 03:59:51',	'Rochdale',	'Rochdale',	'Rochdale'),
(2639282,	77,	2650328,	'Robertsbridge',	'Robertsbridge',	'Robertsbridge',	1,	41132,	'2019-03-16 03:59:51',	'Robertsbridge',	'Robertsbridge',	'Robertsbridge'),
(2639296,	77,	2641429,	'Roade',	'Roade',	'Roade',	1,	41089,	'2019-03-16 03:59:51',	'Roade',	'Roade',	'Roade'),
(2639298,	77,	2644974,	'Rivington',	'Rivington',	'Rivington',	1,	41074,	'2019-03-16 03:59:51',	'Rivington',	'Rivington',	'Rivington'),
(2639302,	77,	2649889,	'Rivenhall',	'Rivenhall',	'Rivenhall',	1,	41021,	'2019-03-16 03:59:51',	'Rivenhall',	'Rivenhall',	'Rivenhall'),
(2639308,	77,	2651346,	'Risley',	'Risley',	'Risley',	1,	40986,	'2019-03-16 03:59:51',	'Risley',	'Risley',	'Risley'),
(2639310,	77,	2644974,	'Rishton',	'Rishton',	'Rishton',	1,	40979,	'2019-03-16 03:59:51',	'Rishton',	'Rishton',	'Rishton'),
(2639313,	77,	7290534,	'Riseley',	'Riseley',	'Riseley',	1,	40976,	'2019-03-16 03:59:51',	'Riseley',	'Riseley',	'Riseley'),
(2639317,	77,	3333240,	'Risca',	'Risca',	'Risca',	1,	40974,	'2019-03-16 03:59:51',	'Risca',	'Risca',	'Risca'),
(2639320,	77,	3333137,	'Ripponden',	'Ripponden',	'Ripponden',	1,	40968,	'2019-03-16 03:59:51',	'Ripponden',	'Ripponden',	'Ripponden'),
(2639323,	77,	2641209,	'Рипон',	'Ripon',	'Ripon',	1,	40964,	'2019-03-16 03:59:51',	'Ripon',	'Ripon',	'Ripon'),
(2639325,	77,	2651346,	'Рипли',	'Ripley',	'Ripley',	1,	40959,	'2019-03-16 03:59:51',	'Ripley',	'Ripley',	'Ripley'),
(2639326,	77,	2636512,	'Ripley',	'Ripley',	'Ripley',	1,	40957,	'2019-03-16 03:59:51',	'Ripley',	'Ripley',	'Ripley'),
(2639328,	77,	2650328,	'Ripe',	'Ripe',	'Ripe',	1,	40949,	'2019-03-16 03:59:51',	'Ripe',	'Ripe',	'Ripe'),
(2639334,	77,	2647554,	'Ringwood',	'Ringwood',	'Ringwood',	1,	40901,	'2019-03-16 03:59:51',	'Ringwood',	'Ringwood',	'Ringwood'),
(2639339,	77,	2636561,	'Ringshall',	'Ringshall',	'Ringshall',	1,	40894,	'2019-03-16 03:59:51',	'Ringshall',	'Ringshall',	'Ringshall'),
(2639343,	77,	2650328,	'Ringmer',	'Ringmer',	'Ringmer',	1,	40891,	'2019-03-16 03:59:51',	'Ringmer',	'Ringmer',	'Ringmer'),
(2639370,	77,	2641235,	'Ridingmill',	'Ridingmill',	'Ridingmill',	1,	40784,	'2019-03-16 03:59:51',	'Ridingmill',	'Ridingmill',	'Ridingmill'),
(2639381,	77,	2647043,	'Rickmansworth',	'Rickmansworth',	'Rickmansworth',	1,	40750,	'2019-03-16 03:59:51',	'Rickmansworth',	'Rickmansworth',	'Rickmansworth'),
(2639388,	77,	2641209,	'Richmond',	'Richmond',	'Richmond',	1,	40719,	'2019-03-16 03:59:51',	'Richmond',	'Richmond',	'Richmond'),
(2639389,	77,	2648110,	'Ричмонд',	'Richmond',	'Richmond',	1,	40728,	'2019-03-16 03:59:51',	'Richmond',	'Richmond',	'Richmond'),
(2639407,	77,	3333240,	'Rhymney',	'Rhymney',	'Rhymney',	1,	40629,	'2019-03-16 03:59:51',	'Rhymney',	'Rhymney',	'Rhymney'),
(2639409,	77,	2651385,	'Рил',	'Rhyl',	'Rhyl',	1,	40628,	'2019-03-16 03:59:51',	'Rhyl',	'Rhyl',	'Rhyl'),
(2639425,	77,	2651385,	'Rhuddlan',	'Rhuddlan',	'Rhuddlan',	1,	40626,	'2019-03-16 03:59:51',	'Rhuddlan',	'Rhuddlan',	'Rhuddlan'),
(2639434,	77,	3333242,	'Rhos-on-Sea',	'Rhos-on-Sea',	'Rhos-on-Sea',	1,	40624,	'2019-03-16 03:59:51',	'Rhos-on-Sea',	'Rhos-on-Sea',	'Rhos-on-Sea'),
(2639435,	77,	2657311,	'Rhosneigr',	'Rhosneigr',	'Rhosneigr',	1,	40625,	'2019-03-16 03:59:51',	'Rhosneigr',	'Rhosneigr',	'Rhosneigr'),
(2639444,	77,	2635028,	'Rhoose',	'Rhoose',	'Rhoose',	1,	40623,	'2019-03-16 03:59:51',	'Rhoose',	'Rhoose',	'Rhoose'),
(2639447,	77,	3333247,	'Rhondda',	'Rhondda',	'Rhondda',	1,	40622,	'2019-03-16 03:59:51',	'Rhondda',	'Rhondda',	'Rhondda'),
(2639470,	77,	2639944,	'Rhayader',	'Rhayader',	'Rhayader',	1,	40587,	'2019-03-16 03:59:51',	'Rhayader',	'Rhayader',	'Rhayader'),
(2639474,	77,	2636561,	'Reydon',	'Reydon',	'Reydon',	1,	40568,	'2019-03-16 03:59:51',	'Reydon',	'Reydon',	'Reydon'),
(2639489,	77,	2651346,	'Repton',	'Repton',	'Repton',	1,	40493,	'2019-03-16 03:59:51',	'Repton',	'Repton',	'Repton'),
(2639492,	77,	3333237,	'Renton',	'Renton',	'Renton',	1,	40483,	'2019-03-16 03:59:51',	'Renton',	'Renton',	'Renton'),
(2639495,	77,	2639494,	'Ренфру',	'Renfrew',	'Renfrew',	1,	40465,	'2019-03-16 03:59:51',	'Renfrew',	'Renfrew',	'Renfrew'),
(2639496,	77,	2636561,	'Rendlesham',	'Rendlesham',	'Rendlesham',	1,	40457,	'2019-03-16 03:59:51',	'Rendlesham',	'Rendlesham',	'Rendlesham'),
(2639506,	77,	2636512,	'Райгейт',	'Reigate',	'Reigate',	1,	40380,	'2019-03-16 03:59:51',	'Reigate',	'Reigate',	'Reigate'),
(2639512,	77,	2641455,	'Reepham',	'Reepham',	'Reepham',	1,	40303,	'2019-03-16 03:59:51',	'Reepham',	'Reepham',	'Reepham'),
(2639518,	77,	2650345,	'Reedness',	'Reedness',	'Reedness',	1,	40292,	'2019-03-16 03:59:51',	'Reedness',	'Reedness',	'Reedness'),
(2639520,	77,	2647043,	'Reed',	'Reed',	'Reed',	1,	40287,	'2019-03-16 03:59:51',	'Reed',	'Reed',	'Reed'),
(2639524,	77,	2652355,	'Redruth',	'Redruth',	'Redruth',	1,	40277,	'2019-03-16 03:59:51',	'Redruth',	'Redruth',	'Redruth'),
(2639533,	77,	2644667,	'Redmile',	'Redmile',	'Redmile',	1,	40268,	'2019-03-16 03:59:51',	'Redmile',	'Redmile',	'Redmile'),
(2639544,	77,	3333177,	'Redhill',	'Redhill',	'Redhill',	1,	40263,	'2019-03-16 03:59:51',	'Redhill',	'Redhill',	'Redhill'),
(2639545,	77,	2636512,	'Redhill',	'Redhill',	'Redhill',	1,	40262,	'2019-03-16 03:59:51',	'Redhill',	'Redhill',	'Redhill'),
(2639557,	77,	2633560,	'Реддитч',	'Redditch',	'Redditch',	1,	40250,	'2019-03-16 03:59:51',	'Redditch',	'Redditch',	'Redditch'),
(2639563,	77,	3333186,	'Redcar',	'Redcar',	'Redcar',	1,	40242,	'2019-03-16 03:59:51',	'Redcar',	'Redcar',	'Redcar'),
(2639567,	77,	2647043,	'Redbourn',	'Redbourn',	'Redbourn',	1,	40241,	'2019-03-16 03:59:51',	'Redbourn',	'Redbourn',	'Redbourn'),
(2639577,	77,	3333184,	'Рединг',	'Reading',	'Reading',	1,	40169,	'2019-03-16 03:59:51',	'Reading',	'Reading',	'Reading'),
(2639581,	77,	2648110,	'Raynes Park',	'Raynes Park',	'Raynes Park',	1,	40156,	'2019-03-16 03:59:51',	'Raynes Park',	'Raynes Park',	'Raynes Park'),
(2639583,	77,	2649889,	'Рейли',	'Rayleigh',	'Rayleigh',	1,	40141,	'2019-03-16 03:59:51',	'Rayleigh',	'Rayleigh',	'Rayleigh'),
(2639586,	77,	2644974,	'Rawtenstall',	'Rawtenstall',	'Rawtenstall',	1,	40133,	'2019-03-16 03:59:51',	'Rawtenstall',	'Rawtenstall',	'Rawtenstall'),
(2639587,	77,	2649889,	'Rawreth',	'Rawreth',	'Rawreth',	1,	40131,	'2019-03-16 03:59:51',	'Rawreth',	'Rawreth',	'Rawreth'),
(2639590,	77,	2650345,	'Rawcliffe',	'Rawcliffe',	'Rawcliffe',	1,	40128,	'2019-03-16 03:59:51',	'Rawcliffe',	'Rawcliffe',	'Rawcliffe'),
(2639596,	77,	2644667,	'Ravenstone',	'Ravenstone',	'Ravenstone',	1,	40123,	'2019-03-16 03:59:51',	'Ravenstone',	'Ravenstone',	'Ravenstone'),
(2639600,	77,	2641429,	'Raunds',	'Raunds',	'Raunds',	1,	40095,	'2019-03-16 03:59:51',	'Raunds',	'Raunds',	'Raunds'),
(2639609,	77,	2651292,	'Rattery',	'Rattery',	'Rattery',	1,	40086,	'2019-03-16 03:59:51',	'Rattery',	'Rattery',	'Rattery'),
(2639615,	77,	3333229,	'Ratho',	'Ratho',	'Ratho',	1,	40074,	'2019-03-16 03:59:51',	'Ratho',	'Ratho',	'Ratho'),
(2639626,	77,	2641169,	'Ratcliffe on Soar',	'Ratcliffe on Soar',	'Ratcliffe on Soar',	1,	40069,	'2019-03-16 03:59:51',	'Ratcliffe on Soar',	'Ratcliffe on Soar',	'Ratcliffe on Soar'),
(2639660,	77,	3333158,	'Рамсгейт',	'Ramsgate',	'Ramsgate',	1,	39958,	'2019-03-16 03:59:51',	'Ramsgate',	'Ramsgate',	'Ramsgate'),
(2639664,	77,	2653940,	'Ramsey',	'Ramsey',	'Ramsey',	1,	39954,	'2019-03-16 03:59:51',	'Ramsey',	'Ramsey',	'Ramsey'),
(2639667,	77,	2633868,	'Ramsbury',	'Ramsbury',	'Ramsbury',	1,	39951,	'2019-03-16 03:59:51',	'Ramsbury',	'Ramsbury',	'Ramsbury'),
(2639689,	77,	3333201,	'Rainhill',	'Rainhill',	'Rainhill',	1,	39897,	'2019-03-16 03:59:51',	'Rainhill',	'Rainhill',	'Rainhill'),
(2639690,	77,	2648110,	'Rainham',	'Rainham',	'Rainham',	1,	39895,	'2019-03-16 03:59:51',	'Rainham',	'Rainham',	'Rainham'),
(2639691,	77,	3333158,	'Rainham',	'Rainham',	'Rainham',	1,	39896,	'2019-03-16 03:59:51',	'Rainham',	'Rainham',	'Rainham'),
(2639693,	77,	3333201,	'Rainford',	'Rainford',	'Rainford',	1,	39894,	'2019-03-16 03:59:51',	'Rainford',	'Rainford',	'Rainford'),
(2639715,	77,	3333123,	'Радсток',	'Radstock',	'Radstock',	1,	39862,	'2019-03-16 03:59:51',	'Radstock',	'Radstock',	'Radstock'),
(2639718,	77,	2654408,	'Radnage',	'Radnage',	'Radnage',	1,	39859,	'2019-03-16 03:59:51',	'Radnage',	'Radnage',	'Radnage'),
(2639720,	77,	2647043,	'Radlett',	'Radlett',	'Radlett',	1,	39858,	'2019-03-16 03:59:51',	'Radlett',	'Radlett',	'Radlett'),
(2639735,	77,	2650797,	'Racks',	'Racks',	'Racks',	1,	39833,	'2019-03-16 03:59:51',	'Racks',	'Racks',	'Racks'),
(2639736,	77,	2641455,	'Rackheath',	'Rackheath',	'Rackheath',	1,	39832,	'2019-03-16 03:59:51',	'Rackheath',	'Rackheath',	'Rackheath'),
(2639788,	77,	3333229,	'Queensferry',	'Queensferry',	'Queensferry',	1,	39686,	'2019-03-16 03:59:51',	'Queensferry',	'Queensferry',	'Queensferry'),
(2639796,	77,	3333158,	'Queenborough',	'Queenborough',	'Queenborough',	1,	39683,	'2019-03-16 03:59:51',	'Queenborough',	'Queenborough',	'Queenborough'),
(2639797,	77,	2648402,	'Quedgeley',	'Quedgeley',	'Quedgeley',	1,	39677,	'2019-03-16 03:59:51',	'Quedgeley',	'Quedgeley',	'Quedgeley'),
(2639814,	77,	2654408,	'Quainton',	'Quainton',	'Quainton',	1,	39646,	'2019-03-16 03:59:51',	'Quainton',	'Quainton',	'Quainton'),
(2639823,	77,	3333239,	'Pyle',	'Pyle',	'Pyle',	1,	39634,	'2019-03-16 03:59:51',	'Pyle',	'Pyle',	'Pyle'),
(2639828,	77,	2647716,	'Пулхели',	'Pwllheli',	'Pwllheli',	1,	39632,	'2019-03-16 03:59:51',	'Pwllheli',	'Pwllheli',	'Pwllheli'),
(2639833,	77,	2636512,	'Puttenham',	'Puttenham',	'Puttenham',	1,	39609,	'2019-03-16 03:59:51',	'Puttenham',	'Puttenham',	'Puttenham'),
(2639840,	77,	2633868,	'Purton',	'Purton',	'Purton',	1,	39584,	'2019-03-16 03:59:51',	'Purton',	'Purton',	'Purton'),
(2639842,	77,	2648110,	'Purley',	'Purley',	'Purley',	1,	39582,	'2019-03-16 03:59:51',	'Purley',	'Purley',	'Purley'),
(2639843,	77,	2649889,	'Purleigh',	'Purleigh',	'Purleigh',	1,	39581,	'2019-03-16 03:59:51',	'Purleigh',	'Purleigh',	'Purleigh'),
(2639845,	77,	2649889,	'Purfleet',	'Purfleet',	'Purfleet',	1,	39577,	'2019-03-16 03:59:51',	'Purfleet',	'Purfleet',	'Purfleet'),
(2639849,	77,	2651079,	'Puncknowle',	'Puncknowle',	'Puncknowle',	1,	39559,	'2019-03-16 03:59:51',	'Puncknowle',	'Puncknowle',	'Puncknowle'),
(2639864,	77,	2634258,	'Pulborough',	'Pulborough',	'Pulborough',	1,	39543,	'2019-03-16 03:59:51',	'Pulborough',	'Pulborough',	'Pulborough'),
(2639866,	77,	3333164,	'Pudsey',	'Pudsey',	'Pudsey',	1,	39482,	'2019-03-16 03:59:51',	'Pudsey',	'Pudsey',	'Pudsey'),
(2639867,	77,	2651079,	'Puddletown',	'Puddletown',	'Puddletown',	1,	39480,	'2019-03-16 03:59:51',	'Puddletown',	'Puddletown',	'Puddletown'),
(2639874,	77,	2641235,	'Prudhoe',	'Prudhoe',	'Prudhoe',	1,	39451,	'2019-03-16 03:59:51',	'Prudhoe',	'Prudhoe',	'Prudhoe'),
(2639880,	77,	2652355,	'Probus',	'Probus',	'Probus',	1,	39396,	'2019-03-16 03:59:51',	'Probus',	'Probus',	'Probus'),
(2639886,	77,	2634723,	'Princethorpe',	'Princethorpe',	'Princethorpe',	1,	39351,	'2019-03-16 03:59:51',	'Princethorpe',	'Princethorpe',	'Princethorpe'),
(2639888,	77,	2654408,	'Princes Risborough',	'Princes Risborough',	'Princes Risborough',	1,	39349,	'2019-03-16 03:59:51',	'Princes Risborough',	'Princes Risborough',	'Princes Risborough'),
(2639894,	77,	2637532,	'Priddy',	'Priddy',	'Priddy',	1,	39327,	'2019-03-16 03:59:51',	'Priddy',	'Priddy',	'Priddy'),
(2639896,	77,	3333235,	'Прествик',	'Prestwick',	'Prestwick',	1,	39306,	'2019-03-16 03:59:51',	'Prestwick',	'Prestwick',	'Prestwick'),
(2639897,	77,	3333136,	'Prestwich',	'Prestwich',	'Prestwich',	1,	39305,	'2019-03-16 03:59:51',	'Prestwich',	'Prestwich',	'Prestwich'),
(2639902,	77,	2650386,	'Prestonpans',	'Prestonpans',	'Prestonpans',	1,	39303,	'2019-03-16 03:59:51',	'Prestonpans',	'Prestonpans',	'Prestonpans'),
(2639908,	77,	2647554,	'Preston Candover',	'Preston Candover',	'Preston Candover',	1,	39299,	'2019-03-16 03:59:51',	'Preston Candover',	'Preston Candover',	'Preston Candover'),
(2639912,	77,	2644974,	'Престон',	'Preston',	'Preston',	1,	39292,	'2019-03-16 03:59:51',	'Preston',	'Preston',	'Preston'),
(2639924,	77,	2639944,	'Presteigne',	'Presteigne',	'Presteigne',	1,	39289,	'2019-03-16 03:59:51',	'Presteigne',	'Presteigne',	'Presteigne'),
(2639925,	77,	7290536,	'Prestbury',	'Prestbury',	'Prestbury',	1,	39288,	'2019-03-16 03:59:51',	'Prestbury',	'Prestbury',	'Prestbury'),
(2639926,	77,	2651385,	'Prestatyn',	'Prestatyn',	'Prestatyn',	1,	39287,	'2019-03-16 03:59:51',	'Prestatyn',	'Prestatyn',	'Prestatyn'),
(2639928,	77,	3333162,	'Prescot',	'Prescot',	'Prescot',	1,	39265,	'2019-03-16 03:59:51',	'Prescot',	'Prescot',	'Prescot'),
(2639941,	77,	7290536,	'Poynton',	'Poynton',	'Poynton',	1,	39144,	'2019-03-16 03:59:51',	'Poynton',	'Poynton',	'Poynton'),
(2639947,	77,	2633560,	'Powick',	'Powick',	'Powick',	1,	39134,	'2019-03-16 03:59:51',	'Powick',	'Powick',	'Powick'),
(2639949,	77,	2650797,	'Powfoot',	'Powfoot',	'Powfoot',	1,	39131,	'2019-03-16 03:59:51',	'Powfoot',	'Powfoot',	'Powfoot'),
(2639958,	77,	2644974,	'Poulton le Fylde',	'Poulton le Fylde',	'Poulton le Fylde',	1,	39100,	'2019-03-16 03:59:51',	'Poulton le Fylde',	'Poulton le Fylde',	'Poulton le Fylde'),
(2639964,	77,	7290535,	'Potton',	'Potton',	'Potton',	1,	39063,	'2019-03-16 03:59:51',	'Potton',	'Potton',	'Potton'),
(2639969,	77,	2641429,	'Potterspury',	'Potterspury',	'Potterspury',	1,	39057,	'2019-03-16 03:59:51',	'Potterspury',	'Potterspury',	'Potterspury'),
(2639970,	77,	2647043,	'Potters Bar',	'Potters Bar',	'Potters Bar',	1,	39056,	'2019-03-16 03:59:51',	'Potters Bar',	'Potters Bar',	'Potters Bar'),
(2639989,	77,	3333245,	'Порт-Толбот',	'Port Talbot',	'Port Talbot',	1,	38892,	'2019-03-16 03:59:51',	'Port Talbot',	'Port Talbot',	'Port Talbot'),
(2639996,	77,	3333183,	'Портсмут',	'Portsmouth',	'Portsmouth',	1,	39002,	'2019-03-16 03:59:51',	'Portsmouth',	'Portsmouth',	'Portsmouth'),
(2639997,	77,	3333133,	'Portslade-by-Sea',	'Portslade-by-Sea',	'Portslade-by-Sea',	1,	38999,	'2019-03-16 03:59:51',	'Portslade-by-Sea',	'Portslade-by-Sea',	'Portslade-by-Sea'),
(2640004,	77,	2652587,	'Portrush',	'Portrush',	'Portrush',	1,	38998,	'2019-03-16 03:59:51',	'Portrush',	'Portrush',	'Portrush'),
(2640006,	77,	2646944,	'Portree',	'Portree',	'Portree',	1,	38996,	'2019-03-16 03:59:51',	'Portree',	'Portree',	'Portree'),
(2640030,	77,	2657830,	'Portlethen',	'Portlethen',	'Portlethen',	1,	38965,	'2019-03-16 03:59:51',	'Portlethen',	'Portlethen',	'Portlethen'),
(2640037,	77,	3333177,	'Portishead',	'Portishead',	'Portishead',	1,	38952,	'2019-03-16 03:59:51',	'Portishead',	'Portishead',	'Portishead'),
(2640045,	77,	2647716,	'Портмадог',	'Porthmadog',	'Porthmadog',	1,	38944,	'2019-03-16 03:59:51',	'Porthmadog',	'Porthmadog',	'Porthmadog'),
(2640054,	77,	3333239,	'Porthcawl',	'Porthcawl',	'Porthcawl',	1,	38943,	'2019-03-16 03:59:51',	'Porthcawl',	'Porthcawl',	'Porthcawl'),
(2640056,	77,	3333247,	'Porth',	'Porth',	'Porth',	1,	38942,	'2019-03-16 03:59:51',	'Porth',	'Porth',	'Porth'),
(2640060,	77,	2646127,	'Port Glasgow',	'Port Glasgow',	'Port Glasgow',	1,	38856,	'2019-03-16 03:59:51',	'Port Glasgow',	'Port Glasgow',	'Port Glasgow'),
(2640071,	77,	2647554,	'Portchester',	'Portchester',	'Portchester',	1,	38929,	'2019-03-16 03:59:51',	'Portchester',	'Portchester',	'Portchester'),
(2640084,	77,	2651038,	'Portaferry',	'Portaferry',	'Portaferry',	1,	38914,	'2019-03-16 03:59:51',	'Portaferry',	'Portaferry',	'Portaferry'),
(2640085,	77,	2657061,	'Портадаун',	'Portadown',	'Portadown',	1,	38913,	'2019-03-16 03:59:51',	'Portadown',	'Portadown',	'Portadown'),
(2640088,	77,	2637532,	'Porlock',	'Porlock',	'Porlock',	1,	38823,	'2019-03-16 03:59:51',	'Porlock',	'Porlock',	'Porlock'),
(2640101,	77,	3333182,	'Пул',	'Poole',	'Poole',	1,	38789,	'2019-03-16 03:59:51',	'Poole',	'Poole',	'Poole'),
(2640104,	77,	3333247,	'Понтиприте',	'Pontypridd',	'Pontypridd',	1,	38784,	'2019-03-16 03:59:51',	'Pontypridd',	'Pontypridd',	'Pontypridd'),
(2640106,	77,	3333249,	'Pontypool',	'Pontypool',	'Pontypool',	1,	38783,	'2019-03-16 03:59:51',	'Pontypool',	'Pontypool',	'Pontypool'),
(2640112,	77,	2653814,	'Pont-Tyweli',	'Pont-Tyweli',	'Pont-Tyweli',	1,	38703,	'2019-03-16 03:59:51',	'Pont-Tyweli',	'Pont-Tyweli',	'Pont-Tyweli'),
(2640118,	77,	3333245,	'Pontrhydyfen',	'Pontrhydyfen',	'Pontrhydyfen',	1,	38777,	'2019-03-16 03:59:51',	'Pontrhydyfen',	'Pontrhydyfen',	'Pontrhydyfen'),
(2640121,	77,	3333249,	'Pontnewynydd',	'Pontnewynydd',	'Pontnewynydd',	1,	38768,	'2019-03-16 03:59:51',	'Pontnewynydd',	'Pontnewynydd',	'Pontnewynydd'),
(2640129,	77,	2638655,	'Pontesbury',	'Pontesbury',	'Pontesbury',	1,	38752,	'2019-03-16 03:59:51',	'Pontesbury',	'Pontesbury',	'Pontesbury'),
(2640131,	77,	2641235,	'Ponteland',	'Ponteland',	'Ponteland',	1,	38749,	'2019-03-16 03:59:51',	'Ponteland',	'Ponteland',	'Ponteland'),
(2640132,	77,	3333212,	'Понтфракт',	'Pontefract',	'Pontefract',	1,	38747,	'2019-03-16 03:59:51',	'Pontefract',	'Pontefract',	'Pontefract'),
(2640135,	77,	3333245,	'Pontardawe',	'Pontardawe',	'Pontardawe',	1,	38706,	'2019-03-16 03:59:51',	'Pontardawe',	'Pontardawe',	'Pontardawe'),
(2640155,	77,	3333230,	'Полмонте',	'Polmont',	'Polmont',	1,	38570,	'2019-03-16 03:59:51',	'Polmont',	'Polmont',	'Polmont'),
(2640162,	77,	3333231,	'Pollok',	'Pollok',	'Pollok',	1,	38568,	'2019-03-16 03:59:51',	'Pollok',	'Pollok',	'Pollok'),
(2640175,	77,	2650328,	'Polegate',	'Polegate',	'Polegate',	1,	38528,	'2019-03-16 03:59:51',	'Polegate',	'Polegate',	'Polegate'),
(2640185,	77,	2650345,	'Pocklington',	'Pocklington',	'Pocklington',	1,	38439,	'2019-03-16 03:59:51',	'Pocklington',	'Pocklington',	'Pocklington'),
(2640190,	77,	3333181,	'Plymstock',	'Plymstock',	'Plymstock',	1,	38426,	'2019-03-16 03:59:51',	'Plymstock',	'Plymstock',	'Plymstock'),
(2640194,	77,	3333181,	'Плимут',	'Plymouth',	'Plymouth',	1,	38419,	'2019-03-16 03:59:51',	'Plymouth',	'Plymouth',	'Plymouth'),
(2640201,	77,	2648110,	'Plumstead',	'Plumstead',	'Plumstead',	1,	38400,	'2019-03-16 03:59:51',	'Plumstead',	'Plumstead',	'Plumstead'),
(2640216,	77,	2649889,	'Pleshey',	'Pleshey',	'Pleshey',	1,	38288,	'2019-03-16 03:59:51',	'Pleshey',	'Pleshey',	'Pleshey'),
(2640242,	77,	2649469,	'Pittenweem',	'Pittenweem',	'Pittenweem',	1,	38091,	'2019-03-16 03:59:51',	'Pittenweem',	'Pittenweem',	'Pittenweem'),
(2640244,	77,	2654408,	'Pitstone',	'Pitstone',	'Pitstone',	1,	38089,	'2019-03-16 03:59:51',	'Pitstone',	'Pitstone',	'Pitstone'),
(2640246,	77,	2649889,	'Pitsea',	'Pitsea',	'Pitsea',	1,	38088,	'2019-03-16 03:59:51',	'Pitsea',	'Pitsea',	'Pitsea'),
(2640255,	77,	3333234,	'Питлохри',	'Pitlochry',	'Pitlochry',	1,	38084,	'2019-03-16 03:59:51',	'Pitlochry',	'Pitlochry',	'Pitlochry'),
(2640269,	77,	2636512,	'Pirbright',	'Pirbright',	'Pirbright',	1,	38051,	'2019-03-16 03:59:51',	'Pirbright',	'Pirbright',	'Pirbright'),
(2640273,	77,	2651346,	'Pinxton',	'Pinxton',	'Pinxton',	1,	38020,	'2019-03-16 03:59:51',	'Pinxton',	'Pinxton',	'Pinxton'),
(2640275,	77,	2648110,	'Pinner',	'Pinner',	'Pinner',	1,	38000,	'2019-03-16 03:59:51',	'Pinner',	'Pinner',	'Pinner'),
(2640279,	77,	2644486,	'Pinchbeck',	'Pinchbeck',	'Pinchbeck',	1,	37928,	'2019-03-16 03:59:51',	'Pinchbeck',	'Pinchbeck',	'Pinchbeck'),
(2640282,	77,	2637532,	'Pilton',	'Pilton',	'Pilton',	1,	37917,	'2019-03-16 03:59:51',	'Pilton',	'Pilton',	'Pilton'),
(2640302,	77,	2651079,	'Piddlehinton',	'Piddlehinton',	'Piddlehinton',	1,	37787,	'2019-03-16 03:59:51',	'Piddlehinton',	'Piddlehinton',	'Piddlehinton'),
(2640312,	77,	2641209,	'Pickering',	'Pickering',	'Pickering',	1,	37780,	'2019-03-16 03:59:51',	'Pickering',	'Pickering',	'Pickering'),
(2640318,	77,	2634354,	'Philpstoun',	'Philpstoun',	'Philpstoun',	1,	37730,	'2019-03-16 03:59:51',	'Philpstoun',	'Philpstoun',	'Philpstoun'),
(2640327,	77,	2633868,	'Pewsey',	'Pewsey',	'Pewsey',	1,	37637,	'2019-03-16 03:59:51',	'Pewsey',	'Pewsey',	'Pewsey'),
(2640331,	77,	2650328,	'Pevensey',	'Pevensey',	'Pevensey',	1,	37631,	'2019-03-16 03:59:51',	'Pevensey',	'Pevensey',	'Pevensey'),
(2640332,	77,	2634258,	'Petworth',	'Petworth',	'Petworth',	1,	37627,	'2019-03-16 03:59:51',	'Petworth',	'Petworth',	'Petworth'),
(2640348,	77,	2647554,	'Petersfield',	'Petersfield',	'Petersfield',	1,	37585,	'2019-03-16 03:59:51',	'Petersfield',	'Petersfield',	'Petersfield'),
(2640349,	77,	2650629,	'Петерли',	'Peterlee',	'Peterlee',	1,	37567,	'2019-03-16 03:59:51',	'Peterlee',	'Peterlee',	'Peterlee'),
(2640351,	77,	2657830,	'Peterhead',	'Peterhead',	'Peterhead',	1,	37566,	'2019-03-16 03:59:51',	'Peterhead',	'Peterhead',	'Peterhead'),
(2640352,	77,	3333224,	'Peterculter',	'Peterculter',	'Peterculter',	1,	37565,	'2019-03-16 03:59:51',	'Peterculter',	'Peterculter',	'Peterculter'),
(2640354,	77,	3333180,	'Питерборо',	'Peterborough',	'Peterborough',	1,	37563,	'2019-03-16 03:59:51',	'Peterborough',	'Peterborough',	'Peterborough'),
(2640358,	77,	3333234,	'Перт',	'Perth',	'Perth',	1,	37515,	'2019-03-16 03:59:51',	'Perth',	'Perth',	'Perth'),
(2640360,	77,	2633560,	'Pershore',	'Pershore',	'Pershore',	1,	37513,	'2019-03-16 03:59:51',	'Pershore',	'Pershore',	'Pershore'),
(2640368,	77,	2648110,	'Perivale',	'Perivale',	'Perivale',	1,	37438,	'2019-03-16 03:59:51',	'Perivale',	'Perivale',	'Perivale'),
(2640377,	77,	2652355,	'Пензанс',	'Penzance',	'Penzance',	1,	37380,	'2019-03-16 03:59:51',	'Penzance',	'Penzance',	'Penzance'),
(2640391,	77,	2644974,	'Penwortham',	'Penwortham',	'Penwortham',	1,	37378,	'2019-03-16 03:59:51',	'Penwortham',	'Penwortham',	'Penwortham'),
(2640409,	77,	3333158,	'Penshurst',	'Penshurst',	'Penshurst',	1,	37369,	'2019-03-16 03:59:51',	'Penshurst',	'Penshurst',	'Penshurst'),
(2640413,	77,	2652355,	'Penryn',	'Penryn',	'Penryn',	1,	37366,	'2019-03-16 03:59:51',	'Penryn',	'Penryn',	'Penryn'),
(2640416,	77,	2651712,	'Пенрит',	'Penrith',	'Penrith',	1,	37363,	'2019-03-16 03:59:51',	'Penrith',	'Penrith',	'Penrith'),
(2640417,	77,	3333248,	'Penrice',	'Penrice',	'Penrice',	1,	37362,	'2019-03-16 03:59:51',	'Penrice',	'Penrice',	'Penrice'),
(2640437,	77,	2651712,	'Pennington',	'Pennington',	'Pennington',	1,	37351,	'2019-03-16 03:59:51',	'Pennington',	'Pennington',	'Pennington'),
(2640460,	77,	2637141,	'Penkridge',	'Penkridge',	'Penkridge',	1,	37334,	'2019-03-16 03:59:51',	'Penkridge',	'Penkridge',	'Penkridge'),
(2640465,	77,	2642559,	'Penicuik',	'Penicuik',	'Penicuik',	1,	37329,	'2019-03-16 03:59:51',	'Penicuik',	'Penicuik',	'Penicuik'),
(2640470,	77,	3333240,	'Pengam',	'Pengam',	'Pengam',	1,	37326,	'2019-03-16 03:59:51',	'Pengam',	'Pengam',	'Pengam'),
(2640484,	77,	3333239,	'Pencoed',	'Pencoed',	'Pencoed',	1,	37313,	'2019-03-16 03:59:51',	'Pencoed',	'Pencoed',	'Pencoed'),
(2640491,	77,	2653753,	'Pencader',	'Pencader',	'Pencader',	1,	37311,	'2019-03-16 03:59:51',	'Pencader',	'Pencader',	'Pencader'),
(2640496,	77,	2635028,	'Penarth',	'Penarth',	'Penarth',	1,	37309,	'2019-03-16 03:59:51',	'Penarth',	'Penarth',	'Penarth'),
(2640498,	77,	3333158,	'Pembury',	'Pembury',	'Pembury',	1,	37301,	'2019-03-16 03:59:51',	'Pembury',	'Pembury',	'Pembury'),
(2640502,	77,	2640500,	'Пемброк-док',	'Pembroke Dock',	'Pembroke Dock',	1,	37299,	'2019-03-16 03:59:51',	'Pembroke Dock',	'Pembroke Dock',	'Pembroke Dock'),
(2640503,	77,	2640500,	'Pembroke',	'Pembroke',	'Pembroke',	1,	37293,	'2019-03-16 03:59:51',	'Pembroke',	'Pembroke',	'Pembroke'),
(2640512,	77,	3333213,	'Pelsall',	'Pelsall',	'Pelsall',	1,	37284,	'2019-03-16 03:59:51',	'Pelsall',	'Pelsall',	'Pelsall'),
(2640517,	77,	2641235,	'Pegswood',	'Pegswood',	'Pegswood',	1,	37243,	'2019-03-16 03:59:51',	'Pegswood',	'Pegswood',	'Pegswood'),
(2640526,	77,	2655192,	'Peebles',	'Peebles',	'Peebles',	1,	37229,	'2019-03-16 03:59:51',	'Peebles',	'Peebles',	'Peebles'),
(2640532,	77,	2649889,	'Pebmarsh',	'Pebmarsh',	'Pebmarsh',	1,	37187,	'2019-03-16 03:59:51',	'Pebmarsh',	'Pebmarsh',	'Pebmarsh'),
(2640563,	77,	2652355,	'Paul',	'Paul',	'Paul',	1,	37090,	'2019-03-16 03:59:51',	'Paul',	'Paul',	'Paul'),
(2640574,	77,	3333226,	'Patna',	'Patna',	'Patna',	1,	37060,	'2019-03-16 03:59:51',	'Patna',	'Patna',	'Patna'),
(2640584,	77,	2653940,	'Paston',	'Paston',	'Paston',	1,	37036,	'2019-03-16 03:59:51',	'Paston',	'Paston',	'Paston'),
(2640589,	77,	2634258,	'Partridge Green',	'Partridge Green',	'Partridge Green',	1,	36999,	'2019-03-16 03:59:51',	'Partridge Green',	'Partridge Green',	'Partridge Green'),
(2640593,	77,	3333211,	'Partington',	'Partington',	'Partington',	1,	36997,	'2019-03-16 03:59:51',	'Partington',	'Partington',	'Partington'),
(2640601,	77,	2651079,	'Parkstone',	'Parkstone',	'Parkstone',	1,	36956,	'2019-03-16 03:59:51',	'Parkstone',	'Parkstone',	'Parkstone'),
(2640623,	77,	2652355,	'Par',	'Par',	'Par',	1,	36857,	'2019-03-16 03:59:51',	'Par',	'Par',	'Par'),
(2640624,	77,	2653940,	'Papworth Everard',	'Papworth Everard',	'Papworth Everard',	1,	36856,	'2019-03-16 03:59:51',	'Papworth Everard',	'Papworth Everard',	'Papworth Everard'),
(2640646,	77,	2638655,	'Pant',	'Pant',	'Pant',	1,	36837,	'2019-03-16 03:59:51',	'Pant',	'Pant',	'Pant'),
(2640654,	77,	3333217,	'Pangbourne',	'Pangbourne',	'Pangbourne',	1,	36820,	'2019-03-16 03:59:51',	'Pangbourne',	'Pangbourne',	'Pangbourne'),
(2640656,	77,	2647716,	'Pandy',	'Pandy',	'Pandy',	1,	36818,	'2019-03-16 03:59:51',	'Pandy',	'Pandy',	'Pandy'),
(2640667,	77,	2648110,	'Palmers Green',	'Palmers Green',	'Palmers Green',	1,	36753,	'2019-03-16 03:59:51',	'Palmers Green',	'Palmers Green',	'Palmers Green'),
(2640677,	77,	2639494,	'Пейсли',	'Paisley',	'Paisley',	1,	36656,	'2019-03-16 03:59:51',	'Paisley',	'Paisley',	'Paisley'),
(2640678,	77,	2648402,	'Painswick',	'Painswick',	'Painswick',	1,	36645,	'2019-03-16 03:59:51',	'Painswick',	'Painswick',	'Painswick'),
(2640681,	77,	3333210,	'Пэйнтон',	'Paignton',	'Paignton',	1,	36635,	'2019-03-16 03:59:51',	'Paignton',	'Paignton',	'Paignton'),
(2640687,	77,	2644974,	'Padiham',	'Padiham',	'Padiham',	1,	36602,	'2019-03-16 03:59:51',	'Padiham',	'Padiham',	'Padiham'),
(2640690,	77,	3333158,	'Paddock Wood',	'Paddock Wood',	'Paddock Wood',	1,	36590,	'2019-03-16 03:59:51',	'Paddock Wood',	'Paddock Wood',	'Paddock Wood'),
(2640692,	77,	2648110,	'Паддингтон',	'Paddington',	'Paddington',	1,	36589,	'2019-03-16 03:59:51',	'Paddington',	'Paddington',	'Paddington'),
(2640715,	77,	2641209,	'Oxton',	'Oxton',	'Oxton',	1,	36535,	'2019-03-16 03:59:51',	'Oxton',	'Oxton',	'Oxton'),
(2640717,	77,	2636512,	'Oxted',	'Oxted',	'Oxted',	1,	36534,	'2019-03-16 03:59:51',	'Oxted',	'Oxted',	'Oxted'),
(2640718,	77,	2636512,	'Oxshott',	'Oxshott',	'Oxshott',	1,	36533,	'2019-03-16 03:59:51',	'Oxshott',	'Oxshott',	'Oxshott'),
(2640729,	77,	2640726,	'Оксфорд',	'Oxford',	'Oxford',	1,	36518,	'2019-03-16 03:59:51',	'Oxford',	'Oxford',	'Oxford'),
(2640756,	77,	3333133,	'Ovingdean',	'Ovingdean',	'Ovingdean',	1,	36487,	'2019-03-16 03:59:51',	'Ovingdean',	'Ovingdean',	'Ovingdean'),
(2640761,	77,	2647554,	'Over Wallop',	'Over Wallop',	'Over Wallop',	1,	36470,	'2019-03-16 03:59:51',	'Over Wallop',	'Over Wallop',	'Over Wallop'),
(2640762,	77,	3333233,	'Overtown',	'Overtown',	'Overtown',	1,	36479,	'2019-03-16 03:59:51',	'Overtown',	'Overtown',	'Overtown'),
(2640765,	77,	2647554,	'Overton',	'Overton',	'Overton',	1,	36477,	'2019-03-16 03:59:51',	'Overton',	'Overton',	'Overton'),
(2640781,	77,	2641455,	'Outwell',	'Outwell',	'Outwell',	1,	36458,	'2019-03-16 03:59:51',	'Outwell',	'Outwell',	'Outwell'),
(2640825,	77,	2641429,	'Oundle',	'Oundle',	'Oundle',	1,	36440,	'2019-03-16 03:59:51',	'Oundle',	'Oundle',	'Oundle'),
(2640834,	77,	2651292,	'Ottery Saint Mary',	'Ottery Saint Mary',	'Ottery Saint Mary',	1,	36407,	'2019-03-16 03:59:51',	'Ottery Saint Mary',	'Ottery Saint Mary',	'Ottery Saint Mary'),
(2640840,	77,	2636512,	'Ottershaw',	'Ottershaw',	'Ottershaw',	1,	36400,	'2019-03-16 03:59:51',	'Ottershaw',	'Ottershaw',	'Ottershaw'),
(2640857,	77,	3333164,	'Otley',	'Otley',	'Otley',	1,	36370,	'2019-03-16 03:59:51',	'Otley',	'Otley',	'Otley'),
(2640858,	77,	2636561,	'Otley',	'Otley',	'Otley',	1,	36369,	'2019-03-16 03:59:51',	'Otley',	'Otley',	'Otley'),
(2640861,	77,	2638655,	'Освестри',	'Oswestry',	'Oswestry',	1,	36354,	'2019-03-16 03:59:51',	'Oswestry',	'Oswestry',	'Oswestry'),
(2640862,	77,	2644974,	'Oswaldtwistle',	'Oswaldtwistle',	'Oswaldtwistle',	1,	36349,	'2019-03-16 03:59:51',	'Oswaldtwistle',	'Oswaldtwistle',	'Oswaldtwistle'),
(2640869,	77,	3333212,	'Оссетт',	'Ossett',	'Ossett',	1,	36277,	'2019-03-16 03:59:51',	'Ossett',	'Ossett',	'Ossett'),
(2640873,	77,	2651079,	'Osmington',	'Osmington',	'Osmington',	1,	36259,	'2019-03-16 03:59:51',	'Osmington',	'Osmington',	'Osmington'),
(2640890,	77,	2649889,	'Orsett',	'Orsett',	'Orsett',	1,	36183,	'2019-03-16 03:59:51',	'Orsett',	'Orsett',	'Orsett'),
(2640894,	77,	2648110,	'Орпингтон',	'Orpington',	'Orpington',	1,	36168,	'2019-03-16 03:59:51',	'Orpington',	'Orpington',	'Orpington'),
(2640908,	77,	2644974,	'Ormskirk',	'Ormskirk',	'Ormskirk',	1,	36149,	'2019-03-16 03:59:51',	'Ormskirk',	'Ormskirk',	'Ormskirk'),
(2640966,	77,	2633560,	'Ombersley',	'Ombersley',	'Ombersley',	1,	35903,	'2019-03-16 03:59:51',	'Ombersley',	'Ombersley',	'Ombersley'),
(2640967,	77,	2640968,	'Ома',	'Omagh',	'Omagh',	1,	35897,	'2019-03-16 03:59:51',	'Omagh',	'Omagh',	'Omagh'),
(2640970,	77,	3333195,	'Olton',	'Olton',	'Olton',	1,	35888,	'2019-03-16 03:59:51',	'Olton',	'Olton',	'Olton'),
(2640972,	77,	3333173,	'Olney',	'Olney',	'Olney',	1,	35870,	'2019-03-16 03:59:51',	'Olney',	'Olney',	'Olney'),
(2640976,	77,	2641169,	'Ollerton',	'Ollerton',	'Ollerton',	1,	35857,	'2019-03-16 03:59:51',	'Ollerton',	'Ollerton',	'Ollerton'),
(2640981,	77,	2633840,	'Old Windsor',	'Old Windsor',	'Old Windsor',	1,	35783,	'2019-03-16 03:59:51',	'Old Windsor',	'Old Windsor',	'Old Windsor'),
(2641018,	77,	3333191,	'Old Hill',	'Old Hill',	'Old Hill',	1,	35772,	'2019-03-16 03:59:51',	'Old Hill',	'Old Hill',	'Old Hill'),
(2641022,	77,	3333179,	'Олдем',	'Oldham',	'Oldham',	1,	35800,	'2019-03-16 03:59:51',	'Oldham',	'Oldham',	'Oldham'),
(2641028,	77,	2644667,	'Old Dalby',	'Old Dalby',	'Old Dalby',	1,	35766,	'2019-03-16 03:59:51',	'Old Dalby',	'Old Dalby',	'Old Dalby'),
(2641036,	77,	3333191,	'Олдбери',	'Oldbury',	'Oldbury',	1,	35784,	'2019-03-16 03:59:51',	'Oldbury',	'Oldbury',	'Oldbury'),
(2641037,	77,	2641455,	'Old Buckenham',	'Old Buckenham',	'Old Buckenham',	1,	35764,	'2019-03-16 03:59:51',	'Old Buckenham',	'Old Buckenham',	'Old Buckenham'),
(2641041,	77,	2644486,	'Old Bolingbroke',	'Old Bolingbroke',	'Old Bolingbroke',	1,	35762,	'2019-03-16 03:59:51',	'Old Bolingbroke',	'Old Bolingbroke',	'Old Bolingbroke'),
(2641049,	77,	2651292,	'Okehampton',	'Okehampton',	'Okehampton',	1,	35727,	'2019-03-16 03:59:51',	'Okehampton',	'Okehampton',	'Okehampton'),
(2641079,	77,	2647554,	'Odiham',	'Odiham',	'Odiham',	1,	35600,	'2019-03-16 03:59:51',	'Odiham',	'Odiham',	'Odiham'),
(2641090,	77,	2636512,	'Ockley',	'Ockley',	'Ockley',	1,	35567,	'2019-03-16 03:59:51',	'Ockley',	'Ockley',	'Ockley'),
(2641098,	77,	3333226,	'Ochiltree',	'Ochiltree',	'Ochiltree',	1,	35557,	'2019-03-16 03:59:51',	'Ochiltree',	'Ochiltree',	'Ochiltree'),
(2641108,	77,	6457407,	'Обан',	'Oban',	'Oban',	1,	35379,	'2019-03-16 03:59:51',	'Oban',	'Oban',	'Oban'),
(2641121,	77,	7290534,	'Oakley',	'Oakley',	'Oakley',	1,	35356,	'2019-03-16 03:59:51',	'Oakley',	'Oakley',	'Oakley'),
(2641122,	77,	2654408,	'Oakley',	'Oakley',	'Oakley',	1,	35357,	'2019-03-16 03:59:51',	'Oakley',	'Oakley',	'Oakley'),
(2641126,	77,	2637532,	'Oakhill',	'Oakhill',	'Oakhill',	1,	35334,	'2019-03-16 03:59:51',	'Oakhill',	'Oakhill',	'Oakhill'),
(2641128,	77,	2638918,	'Окем',	'Oakham',	'Oakham',	1,	35332,	'2019-03-16 03:59:51',	'Oakham',	'Oakham',	'Oakham'),
(2641129,	77,	2651292,	'Oakford',	'Oakford',	'Oakford',	1,	35331,	'2019-03-16 03:59:51',	'Oakford',	'Oakford',	'Oakford'),
(2641142,	77,	2650328,	'Nutley',	'Nutley',	'Nutley',	1,	35266,	'2019-03-16 03:59:51',	'Nutley',	'Nutley',	'Nutley'),
(2641157,	77,	2634723,	'Нанитон',	'Nuneaton',	'Nuneaton',	1,	35249,	'2019-03-16 03:59:51',	'Nuneaton',	'Nuneaton',	'Nuneaton'),
(2641161,	77,	2640726,	'Nuffield',	'Nuffield',	'Nuffield',	1,	35236,	'2019-03-16 03:59:51',	'Nuffield',	'Nuffield',	'Nuffield'),
(2641167,	77,	3333212,	'Notton',	'Notton',	'Notton',	1,	35121,	'2019-03-16 03:59:51',	'Notton',	'Notton',	'Notton'),
(2641170,	77,	3333178,	'Ноттингем',	'Nottingham',	'Nottingham',	1,	35119,	'2019-03-16 03:59:51',	'Nottingham',	'Nottingham',	'Nottingham'),
(2641179,	77,	2648110,	'Norwood',	'Norwood',	'Norwood',	1,	35088,	'2019-03-16 03:59:51',	'Norwood',	'Norwood',	'Norwood'),
(2641181,	77,	2641455,	'Норидж',	'Norwich',	'Norwich',	1,	35083,	'2019-03-16 03:59:51',	'Norwich',	'Norwich',	'Norwich'),
(2641185,	77,	2634723,	'Norton Lindsey',	'Norton Lindsey',	'Norton Lindsey',	1,	35063,	'2019-03-16 03:59:51',	'Norton Lindsey',	'Norton Lindsey',	'Norton Lindsey'),
(2641193,	77,	2637141,	'Norton Canes',	'Norton Canes',	'Norton Canes',	1,	35062,	'2019-03-16 03:59:51',	'Norton Canes',	'Norton Canes',	'Norton Canes'),
(2641197,	77,	3333203,	'Norton',	'Norton',	'Norton',	1,	35057,	'2019-03-16 03:59:51',	'Norton',	'Norton',	'Norton'),
(2641198,	77,	2641209,	'Norton',	'Norton',	'Norton',	1,	35058,	'2019-03-16 03:59:51',	'Norton',	'Norton',	'Norton'),
(2641205,	77,	2647043,	'Norton',	'Norton',	'Norton',	1,	35059,	'2019-03-16 03:59:51',	'Norton',	'Norton',	'Norton'),
(2641217,	77,	2646007,	'Northwood',	'Northwood',	'Northwood',	1,	35052,	'2019-03-16 03:59:51',	'Northwood',	'Northwood',	'Northwood'),
(2641224,	77,	7290537,	'Нортвич',	'Northwich',	'Northwich',	1,	35048,	'2019-03-16 03:59:51',	'Northwich',	'Northwich',	'Northwich'),
(2641229,	77,	2649889,	'North Weald',	'North Weald',	'North Weald',	1,	35006,	'2019-03-16 03:59:51',	'North Weald',	'North Weald',	'North Weald'),
(2641232,	77,	2647554,	'North Waltham',	'North Waltham',	'North Waltham',	1,	35004,	'2019-03-16 03:59:51',	'North Waltham',	'North Waltham',	'North Waltham'),
(2641233,	77,	2641455,	'North Walsham',	'North Walsham',	'North Walsham',	1,	35003,	'2019-03-16 03:59:51',	'North Walsham',	'North Walsham',	'North Walsham'),
(2641245,	77,	2651292,	'North Tawton',	'North Tawton',	'North Tawton',	1,	34993,	'2019-03-16 03:59:51',	'North Tawton',	'North Tawton',	'North Tawton'),
(2641267,	77,	2641238,	'North Shields',	'North Shields',	'North Shields',	1,	34984,	'2019-03-16 03:59:51',	'North Shields',	'North Shields',	'North Shields'),
(2641278,	77,	2641455,	'Northrepps',	'Northrepps',	'Northrepps',	1,	35042,	'2019-03-16 03:59:51',	'Northrepps',	'Northrepps',	'Northrepps'),
(2641289,	77,	2649298,	'Northop',	'Northop',	'Northop',	1,	35038,	'2019-03-16 03:59:51',	'Northop',	'Northop',	'Northop'),
(2641290,	77,	2648110,	'Норхолт',	'Northolt',	'Northolt',	1,	35036,	'2019-03-16 03:59:51',	'Northolt',	'Northolt',	'Northolt'),
(2641293,	77,	2637532,	'North Newton',	'North Newton',	'North Newton',	1,	34954,	'2019-03-16 03:59:51',	'North Newton',	'North Newton',	'North Newton'),
(2641300,	77,	2640726,	'North Moreton',	'North Moreton',	'North Moreton',	1,	34952,	'2019-03-16 03:59:51',	'North Moreton',	'North Moreton',	'North Moreton'),
(2641302,	77,	2651292,	'North Molton',	'North Molton',	'North Molton',	1,	34950,	'2019-03-16 03:59:51',	'North Molton',	'North Molton',	'North Molton'),
(2641318,	77,	2648402,	'Northleach',	'Northleach',	'Northleach',	1,	35035,	'2019-03-16 03:59:51',	'Northleach',	'Northleach',	'Northleach'),
(2641319,	77,	2634258,	'Lancing',	'Lancing',	'Lancing',	1,	26123,	'2019-03-16 03:59:51',	'Lancing',	'Lancing',	'Lancing'),
(2641332,	77,	2644486,	'North Hykeham',	'North Hykeham',	'North Hykeham',	1,	34931,	'2019-03-16 03:59:51',	'North Hykeham',	'North Hykeham',	'North Hykeham'),
(2641354,	77,	3333158,	'Northfleet',	'Northfleet',	'Northfleet',	1,	35032,	'2019-03-16 03:59:51',	'Northfleet',	'Northfleet',	'Northfleet'),
(2641355,	77,	3333125,	'Northfield',	'Northfield',	'Northfield',	1,	35028,	'2019-03-16 03:59:51',	'Northfield',	'Northfield',	'Northfield'),
(2641356,	77,	2650345,	'North Ferriby',	'North Ferriby',	'North Ferriby',	1,	34913,	'2019-03-16 03:59:51',	'North Ferriby',	'North Ferriby',	'North Ferriby'),
(2641357,	77,	2649889,	'North Fambridge',	'North Fambridge',	'North Fambridge',	1,	34912,	'2019-03-16 03:59:51',	'North Fambridge',	'North Fambridge',	'North Fambridge'),
(2641367,	77,	3333169,	'Northenden',	'Northenden',	'Northenden',	1,	35022,	'2019-03-16 03:59:51',	'Northenden',	'Northenden',	'Northenden'),
(2641368,	77,	2640726,	'Northend',	'Northend',	'Northend',	1,	35021,	'2019-03-16 03:59:51',	'Northend',	'Northend',	'Northend'),
(2641389,	77,	2641169,	'North Collingham',	'North Collingham',	'North Collingham',	1,	34899,	'2019-03-16 03:59:51',	'North Collingham',	'North Collingham',	'North Collingham'),
(2641404,	77,	2650345,	'North Cave',	'North Cave',	'North Cave',	1,	34892,	'2019-03-16 03:59:51',	'North Cave',	'North Cave',	'North Cave'),
(2641419,	77,	2650386,	'Норт-Бервик',	'North Berwick',	'North Berwick',	1,	34879,	'2019-03-16 03:59:51',	'North Berwick',	'North Berwick',	'North Berwick'),
(2641430,	77,	2641429,	'Нортхемптон',	'Northampton',	'Northampton',	1,	35014,	'2019-03-16 03:59:51',	'Northampton',	'Northampton',	'Northampton'),
(2641435,	77,	2641209,	'Northallerton',	'Northallerton',	'Northallerton',	1,	35012,	'2019-03-16 03:59:51',	'Northallerton',	'Northallerton',	'Northallerton'),
(2641443,	77,	3333212,	'Normanton',	'Normanton',	'Normanton',	1,	34840,	'2019-03-16 03:59:51',	'Normanton',	'Normanton',	'Normanton'),
(2641447,	77,	2636512,	'Normandy',	'Normandy',	'Normandy',	1,	34838,	'2019-03-16 03:59:51',	'Normandy',	'Normandy',	'Normandy'),
(2641454,	77,	2641235,	'Norham',	'Norham',	'Norham',	1,	34825,	'2019-03-16 03:59:51',	'Norham',	'Norham',	'Norham'),
(2641462,	77,	2648110,	'Norbury',	'Norbury',	'Norbury',	1,	34790,	'2019-03-16 03:59:51',	'Norbury',	'Norbury',	'Norbury'),
(2641477,	77,	2644486,	'Nocton',	'Nocton',	'Nocton',	1,	34705,	'2019-03-16 03:59:51',	'Nocton',	'Nocton',	'Nocton'),
(2641508,	77,	2644486,	'New York',	'New York',	'New York',	1,	34311,	'2019-03-16 03:59:51',	'New York',	'New York',	'New York'),
(2641509,	77,	2657306,	'Newtyle',	'Newtyle',	'Newtyle',	1,	34471,	'2019-03-16 03:59:51',	'Newtyle',	'Newtyle',	'Newtyle'),
(2641510,	77,	3333240,	'New Tredegar',	'New Tredegar',	'New Tredegar',	1,	34291,	'2019-03-16 03:59:51',	'New Tredegar',	'New Tredegar',	'New Tredegar'),
(2641519,	77,	2657122,	'Ньютаунардс',	'Newtownards',	'Newtownards',	1,	34470,	'2019-03-16 03:59:51',	'Newtownards',	'Newtownards',	'Newtownards'),
(2641520,	77,	2641521,	'Ньютонэббей',	'Newtownabbey',	'Newtownabbey',	1,	34469,	'2019-03-16 03:59:51',	'Newtownabbey',	'Newtownabbey',	'Newtownabbey'),
(2641523,	77,	2639944,	'Newtown',	'Newtown',	'Newtown',	1,	34465,	'2019-03-16 03:59:51',	'Newtown',	'Newtown',	'Newtown'),
(2641528,	77,	2650797,	'Newton Stewart',	'Newton Stewart',	'Newton Stewart',	1,	34458,	'2019-03-16 03:59:51',	'Newton Stewart',	'Newton Stewart',	'Newton Stewart'),
(2641529,	77,	2651346,	'Newton Solney',	'Newton Solney',	'Newton Solney',	1,	34457,	'2019-03-16 03:59:51',	'Newton Solney',	'Newton Solney',	'Newton Solney'),
(2641539,	77,	2644486,	'Newton on Trent',	'Newton on Trent',	'Newton on Trent',	1,	34456,	'2019-03-16 03:59:51',	'Newton on Trent',	'Newton on Trent',	'Newton on Trent'),
(2641546,	77,	3333201,	'Newton-le-Willows',	'Newton-le-Willows',	'Newton-le-Willows',	1,	34460,	'2019-03-16 03:59:51',	'Newton-le-Willows',	'Newton-le-Willows',	'Newton-le-Willows'),
(2641549,	77,	2657830,	'Newtonhill',	'Newtonhill',	'Newtonhill',	1,	34461,	'2019-03-16 03:59:51',	'Newtonhill',	'Newtonhill',	'Newtonhill'),
(2641552,	77,	2651292,	'Newton Ferrers',	'Newton Ferrers',	'Newton Ferrers',	1,	34452,	'2019-03-16 03:59:51',	'Newton Ferrers',	'Newton Ferrers',	'Newton Ferrers'),
(2641555,	77,	2650629,	'Newton Aycliffe',	'Newton Aycliffe',	'Newton Aycliffe',	1,	34449,	'2019-03-16 03:59:51',	'Newton Aycliffe',	'Newton Aycliffe',	'Newton Aycliffe'),
(2641557,	77,	2651292,	'Ньютон-Эббот',	'Newton Abbot',	'Newton Abbot',	1,	34448,	'2019-03-16 03:59:51',	'Newton Abbot',	'Newton Abbot',	'Newton Abbot'),
(2641565,	77,	2641429,	'Newton',	'Newton',	'Newton',	1,	34444,	'2019-03-16 03:59:51',	'Newton',	'Newton',	'Newton'),
(2641569,	77,	2648110,	'New Southgate',	'New Southgate',	'New Southgate',	1,	34285,	'2019-03-16 03:59:51',	'New Southgate',	'New Southgate',	'New Southgate'),
(2641581,	77,	2641580,	'Ньюри',	'Newry',	'Newry',	1,	34428,	'2019-03-16 03:59:51',	'Newry',	'Newry',	'Newry'),
(2641582,	77,	3333158,	'New Romney',	'New Romney',	'New Romney',	1,	34277,	'2019-03-16 03:59:51',	'New Romney',	'New Romney',	'New Romney'),
(2641589,	77,	2652355,	'Newquay',	'Newquay',	'Newquay',	1,	34427,	'2019-03-16 03:59:51',	'Newquay',	'Newquay',	'Newquay'),
(2641591,	77,	3333173,	'Newport Pagnell',	'Newport Pagnell',	'Newport Pagnell',	1,	34425,	'2019-03-16 03:59:51',	'Newport Pagnell',	'Newport Pagnell',	'Newport Pagnell'),
(2641593,	77,	2649469,	'Newport-On-Tay',	'Newport-On-Tay',	'Newport-On-Tay',	1,	34426,	'2019-03-16 03:59:51',	'Newport-On-Tay',	'Newport-On-Tay',	'Newport-On-Tay'),
(2641595,	77,	3333209,	'Ньюпорт',	'Newport',	'Newport',	1,	34401,	'2019-03-16 03:59:51',	'Newport',	'Newport',	'Newport'),
(2641596,	77,	2640500,	'Newport',	'Newport',	'Newport',	1,	34417,	'2019-03-16 03:59:51',	'Newport',	'Newport',	'Newport'),
(2641597,	77,	2649889,	'Newport',	'Newport',	'Newport',	1,	34409,	'2019-03-16 03:59:51',	'Newport',	'Newport',	'Newport'),
(2641598,	77,	3333246,	'Ньюпорт',	'Newport',	'Newport',	1,	34416,	'2019-03-16 03:59:51',	'Newport',	'Newport',	'Newport'),
(2641599,	77,	2646007,	'Ньюпорт',	'Newport',	'Newport',	1,	34407,	'2019-03-16 03:59:51',	'Newport',	'Newport',	'Newport'),
(2641605,	77,	2648402,	'Newnham',	'Newnham',	'Newnham',	1,	34398,	'2019-03-16 03:59:51',	'Newnham',	'Newnham',	'Newnham'),
(2641609,	77,	2647554,	'New Milton',	'New Milton',	'New Milton',	1,	34246,	'2019-03-16 03:59:51',	'New Milton',	'New Milton',	'New Milton'),
(2641610,	77,	3333226,	'Newmilns',	'Newmilns',	'Newmilns',	1,	34396,	'2019-03-16 03:59:51',	'Newmilns',	'Newmilns',	'Newmilns'),
(2641612,	77,	2651346,	'New Mills',	'New Mills',	'New Mills',	1,	34245,	'2019-03-16 03:59:51',	'New Mills',	'New Mills',	'New Mills'),
(2641616,	77,	2636561,	'Ньюмаркет',	'Newmarket',	'Newmarket',	1,	34394,	'2019-03-16 03:59:51',	'Newmarket',	'Newmarket',	'Newmarket'),
(2641618,	77,	3333233,	'Newmains',	'Newmains',	'Newmains',	1,	34389,	'2019-03-16 03:59:51',	'Newmains',	'Newmains',	'Newmains'),
(2641626,	77,	2651712,	'Newlands',	'Newlands',	'Newlands',	1,	34388,	'2019-03-16 03:59:51',	'Newlands',	'Newlands',	'Newlands'),
(2641630,	77,	2650328,	'Newick',	'Newick',	'Newick',	1,	34382,	'2019-03-16 03:59:51',	'Newick',	'Newick',	'Newick'),
(2641637,	77,	2650328,	'Newhaven',	'Newhaven',	'Newhaven',	1,	34381,	'2019-03-16 03:59:51',	'Newhaven',	'Newhaven',	'Newhaven'),
(2641638,	77,	2641235,	'Newham',	'Newham',	'Newham',	1,	34380,	'2019-03-16 03:59:51',	'Newham',	'Newham',	'Newham'),
(2641642,	77,	2651346,	'Newhall',	'Newhall',	'Newhall',	1,	34377,	'2019-03-16 03:59:51',	'Newhall',	'Newhall',	'Newhall'),
(2641649,	77,	3333220,	'New Ferry',	'New Ferry',	'New Ferry',	1,	34168,	'2019-03-16 03:59:51',	'New Ferry',	'New Ferry',	'New Ferry'),
(2641651,	77,	2648402,	'Newent',	'Newent',	'Newent',	1,	34369,	'2019-03-16 03:59:51',	'Newent',	'Newent',	'Newent'),
(2641658,	77,	3333226,	'New Cumnock',	'New Cumnock',	'New Cumnock',	1,	34156,	'2019-03-16 03:59:51',	'New Cumnock',	'New Cumnock',	'New Cumnock'),
(2641661,	77,	2648110,	'New Cross',	'New Cross',	'New Cross',	1,	34153,	'2019-03-16 03:59:51',	'New Cross',	'New Cross',	'New Cross'),
(2641673,	77,	3333174,	'Ньюкасл',	'Newcastle upon Tyne',	'Newcastle upon Tyne',	1,	34362,	'2019-03-16 03:59:51',	'Newcastle upon Tyne',	'Newcastle upon Tyne',	'Newcastle upon Tyne'),
(2641674,	77,	2637141,	'Newcastle under Lyme',	'Newcastle under Lyme',	'Newcastle under Lyme',	1,	34361,	'2019-03-16 03:59:51',	'Newcastle under Lyme',	'Newcastle under Lyme',	'Newcastle under Lyme'),
(2641679,	77,	2638655,	'Newcastle',	'Newcastle',	'Newcastle',	1,	34354,	'2019-03-16 03:59:51',	'Newcastle',	'Newcastle',	'Newcastle'),
(2641689,	77,	3333217,	'Ньюбери',	'Newbury',	'Newbury',	1,	34346,	'2019-03-16 03:59:51',	'Newbury',	'Newbury',	'Newbury'),
(2641694,	77,	2641455,	'New Buckenham',	'New Buckenham',	'New Buckenham',	1,	34129,	'2019-03-16 03:59:51',	'New Buckenham',	'New Buckenham',	'New Buckenham'),
(2641700,	77,	3333240,	'Newbridge',	'Newbridge',	'Newbridge',	1,	34340,	'2019-03-16 03:59:51',	'Newbridge',	'Newbridge',	'Newbridge'),
(2641701,	77,	2646007,	'Newbridge',	'Newbridge',	'Newbridge',	1,	34341,	'2019-03-16 03:59:51',	'Newbridge',	'Newbridge',	'Newbridge'),
(2641704,	77,	3333205,	'Newbottle',	'Newbottle',	'Newbottle',	1,	34339,	'2019-03-16 03:59:51',	'Newbottle',	'Newbottle',	'Newbottle'),
(2641713,	77,	2651346,	'Newbold',	'Newbold',	'Newbold',	1,	34337,	'2019-03-16 03:59:51',	'Newbold',	'Newbold',	'Newbold'),
(2641726,	77,	2642559,	'Newbattle',	'Newbattle',	'Newbattle',	1,	34330,	'2019-03-16 03:59:51',	'Newbattle',	'Newbattle',	'Newbattle'),
(2641727,	77,	2648110,	'New Barnet',	'New Barnet',	'New Barnet',	1,	34106,	'2019-03-16 03:59:51',	'New Barnet',	'New Barnet',	'New Barnet'),
(2641731,	77,	2641169,	'Ньюарк-он-Трент',	'Newark on Trent',	'Newark on Trent',	1,	34327,	'2019-03-16 03:59:51',	'Newark on Trent',	'Newark on Trent',	'Newark on Trent'),
(2641758,	77,	2633868,	'Nettleton',	'Nettleton',	'Nettleton',	1,	33863,	'2019-03-16 03:59:51',	'Nettleton',	'Nettleton',	'Nettleton'),
(2641773,	77,	3333144,	'Netherton',	'Netherton',	'Netherton',	1,	33856,	'2019-03-16 03:59:51',	'Netherton',	'Netherton',	'Netherton'),
(2641792,	77,	2633868,	'Netheravon',	'Netheravon',	'Netheravon',	1,	33855,	'2019-03-16 03:59:51',	'Netheravon',	'Netheravon',	'Netheravon'),
(2641795,	77,	7290537,	'Neston',	'Neston',	'Neston',	1,	33852,	'2019-03-16 03:59:51',	'Neston',	'Neston',	'Neston'),
(2641810,	77,	2644974,	'Nelson',	'Nelson',	'Nelson',	1,	33789,	'2019-03-16 03:59:51',	'Nelson',	'Nelson',	'Nelson'),
(2641811,	77,	3333240,	'Nelson',	'Nelson',	'Nelson',	1,	33790,	'2019-03-16 03:59:51',	'Nelson',	'Nelson',	'Nelson'),
(2641827,	77,	2653940,	'Needingworth',	'Needingworth',	'Needingworth',	1,	33733,	'2019-03-16 03:59:51',	'Needingworth',	'Needingworth',	'Needingworth'),
(2641843,	77,	3333245,	'Нит',	'Neath',	'Neath',	1,	33699,	'2019-03-16 03:59:51',	'Neath',	'Neath',	'Neath'),
(2641844,	77,	2648110,	'Neasden',	'Neasden',	'Neasden',	1,	33698,	'2019-03-16 03:59:51',	'Neasden',	'Neasden',	'Neasden'),
(2641872,	77,	2654408,	'Nash',	'Nash',	'Nash',	1,	33588,	'2019-03-16 03:59:51',	'Nash',	'Nash',	'Nash'),
(2641874,	77,	2641429,	'Naseby',	'Naseby',	'Naseby',	1,	33586,	'2019-03-16 03:59:51',	'Naseby',	'Naseby',	'Naseby'),
(2641885,	77,	2640500,	'Narberth',	'Narberth',	'Narberth',	1,	33567,	'2019-03-16 03:59:51',	'Narberth',	'Narberth',	'Narberth'),
(2641890,	77,	3333238,	'Nantyglo',	'Nantyglo',	'Nantyglo',	1,	33546,	'2019-03-16 03:59:51',	'Nantyglo',	'Nantyglo',	'Nantyglo'),
(2641892,	77,	7290536,	'Nantwich',	'Nantwich',	'Nantwich',	1,	33544,	'2019-03-16 03:59:51',	'Nantwich',	'Nantwich',	'Nantwich'),
(2641912,	77,	2648402,	'Nailsworth',	'Nailsworth',	'Nailsworth',	1,	33489,	'2019-03-16 03:59:51',	'Nailsworth',	'Nailsworth',	'Nailsworth'),
(2641913,	77,	3333177,	'Nailsea',	'Nailsea',	'Nailsea',	1,	33488,	'2019-03-16 03:59:51',	'Nailsea',	'Nailsea',	'Nailsea'),
(2641915,	77,	2650345,	'Nafferton',	'Nafferton',	'Nafferton',	1,	33470,	'2019-03-16 03:59:51',	'Nafferton',	'Nafferton',	'Nafferton'),
(2641921,	77,	2641209,	'Myton on Swale',	'Myton on Swale',	'Myton on Swale',	1,	33451,	'2019-03-16 03:59:51',	'Myton on Swale',	'Myton on Swale',	'Myton on Swale'),
(2641924,	77,	2636512,	'Mytchett',	'Mytchett',	'Mytchett',	1,	33448,	'2019-03-16 03:59:51',	'Mytchett',	'Mytchett',	'Mytchett'),
(2641934,	77,	2638655,	'Myddle',	'Myddle',	'Myddle',	1,	33431,	'2019-03-16 03:59:51',	'Myddle',	'Myddle',	'Myddle'),
(2641942,	77,	2650386,	'Musselburgh',	'Musselburgh',	'Musselburgh',	1,	33408,	'2019-03-16 03:59:51',	'Musselburgh',	'Musselburgh',	'Musselburgh'),
(2641945,	77,	2650629,	'Murton',	'Murton',	'Murton',	1,	33391,	'2019-03-16 03:59:51',	'Murton',	'Murton',	'Murton'),
(2641966,	77,	2641455,	'Mundesley',	'Mundesley',	'Mundesley',	1,	33302,	'2019-03-16 03:59:51',	'Mundesley',	'Mundesley',	'Mundesley'),
(2641976,	77,	2652355,	'Mullion',	'Mullion',	'Mullion',	1,	33277,	'2019-03-16 03:59:51',	'Mullion',	'Mullion',	'Mullion'),
(2642054,	77,	2638655,	'Much Wenlock',	'Much Wenlock',	'Much Wenlock',	1,	33203,	'2019-03-16 03:59:51',	'Much Wenlock',	'Much Wenlock',	'Much Wenlock'),
(2642057,	77,	2647043,	'Much Hadham',	'Much Hadham',	'Much Hadham',	1,	33202,	'2019-03-16 03:59:51',	'Much Hadham',	'Much Hadham',	'Much Hadham'),
(2642096,	77,	2644667,	'Mountsorrel',	'Mountsorrel',	'Mountsorrel',	1,	33136,	'2019-03-16 03:59:51',	'Mountsorrel',	'Mountsorrel',	'Mountsorrel'),
(2642112,	77,	2649889,	'Mount Bures',	'Mount Bures',	'Mount Bures',	1,	33011,	'2019-03-16 03:59:51',	'Mount Bures',	'Mount Bures',	'Mount Bures'),
(2642116,	77,	3333247,	'Mountain Ash',	'Mountain Ash',	'Mountain Ash',	1,	33108,	'2019-03-16 03:59:51',	'Mountain Ash',	'Mountain Ash',	'Mountain Ash'),
(2642120,	77,	2641455,	'Moulton Saint Michael',	'Moulton Saint Michael',	'Moulton Saint Michael',	1,	32991,	'2019-03-16 03:59:51',	'Moulton Saint Michael',	'Moulton Saint Michael',	'Moulton Saint Michael'),
(2642126,	77,	3333173,	'Moulsoe',	'Moulsoe',	'Moulsoe',	1,	32987,	'2019-03-16 03:59:51',	'Moulsoe',	'Moulsoe',	'Moulsoe'),
(2642127,	77,	2640726,	'Moulsford',	'Moulsford',	'Moulsford',	1,	32986,	'2019-03-16 03:59:51',	'Moulsford',	'Moulsford',	'Moulsford'),
(2642135,	77,	3333233,	'Мазервелл',	'Motherwell',	'Motherwell',	1,	32943,	'2019-03-16 03:59:51',	'Motherwell',	'Motherwell',	'Motherwell'),
(2642137,	77,	2649298,	'Mostyn',	'Mostyn',	'Mostyn',	1,	32940,	'2019-03-16 03:59:51',	'Mostyn',	'Mostyn',	'Mostyn'),
(2642143,	77,	3333208,	'Mossley',	'Mossley',	'Mossley',	1,	32935,	'2019-03-16 03:59:51',	'Mossley',	'Mossley',	'Mossley'),
(2642148,	77,	3333143,	'Moss',	'Moss',	'Moss',	1,	32929,	'2019-03-16 03:59:51',	'Moss',	'Moss',	'Moss'),
(2642149,	77,	3333125,	'Moseley',	'Moseley',	'Moseley',	1,	32916,	'2019-03-16 03:59:51',	'Moseley',	'Moseley',	'Moseley'),
(2642165,	77,	2651346,	'Morton',	'Morton',	'Morton',	1,	32895,	'2019-03-16 03:59:51',	'Morton',	'Morton',	'Morton'),
(2642166,	77,	2644486,	'Morton',	'Morton',	'Morton',	1,	32894,	'2019-03-16 03:59:51',	'Morton',	'Morton',	'Morton'),
(2642172,	77,	2647554,	'Mortimer Common',	'Mortimer Common',	'Mortimer Common',	1,	32888,	'2019-03-16 03:59:51',	'Mortimer Common',	'Mortimer Common',	'Mortimer Common'),
(2642174,	77,	2651292,	'Mortehoe',	'Mortehoe',	'Mortehoe',	1,	32884,	'2019-03-16 03:59:51',	'Mortehoe',	'Mortehoe',	'Mortehoe'),
(2642180,	77,	3333248,	'Morriston',	'Morriston',	'Morriston',	1,	32840,	'2019-03-16 03:59:51',	'Morriston',	'Morriston',	'Morriston'),
(2642182,	77,	2641235,	'Морпет',	'Morpeth',	'Morpeth',	1,	32819,	'2019-03-16 03:59:51',	'Morpeth',	'Morpeth',	'Morpeth'),
(2642189,	77,	3333164,	'Morley',	'Morley',	'Morley',	1,	32795,	'2019-03-16 03:59:51',	'Morley',	'Morley',	'Morley'),
(2642200,	77,	2648402,	'Moreton in Marsh',	'Moreton in Marsh',	'Moreton in Marsh',	1,	32745,	'2019-03-16 03:59:51',	'Moreton in Marsh',	'Moreton in Marsh',	'Moreton in Marsh'),
(2642201,	77,	2651292,	'Moretonhampstead',	'Moretonhampstead',	'Moretonhampstead',	1,	32746,	'2019-03-16 03:59:51',	'Moretonhampstead',	'Moretonhampstead',	'Moretonhampstead'),
(2642204,	77,	3333220,	'Moreton',	'Moreton',	'Moreton',	1,	32744,	'2019-03-16 03:59:51',	'Moreton',	'Moreton',	'Moreton'),
(2642214,	77,	2644974,	'Моркам',	'Morecambe',	'Morecambe',	1,	32731,	'2019-03-16 03:59:51',	'Morecambe',	'Morecambe',	'Morecambe'),
(2642230,	77,	2638655,	'More',	'More',	'More',	1,	32728,	'2019-03-16 03:59:51',	'More',	'More',	'More'),
(2642233,	77,	2648110,	'Morden',	'Morden',	'Morden',	1,	32726,	'2019-03-16 03:59:51',	'Morden',	'Morden',	'Morden'),
(2642234,	77,	2651079,	'Morden',	'Morden',	'Morden',	1,	32727,	'2019-03-16 03:59:51',	'Morden',	'Morden',	'Morden'),
(2642298,	77,	2651346,	'Monyash',	'Monyash',	'Monyash',	1,	32638,	'2019-03-16 03:59:51',	'Monyash',	'Monyash',	'Monyash'),
(2642302,	77,	2657306,	'Монтроз',	'Montrose',	'Montrose',	1,	32605,	'2019-03-16 03:59:51',	'Montrose',	'Montrose',	'Montrose'),
(2642304,	77,	2639944,	'Montgomery',	'Montgomery',	'Montgomery',	1,	32418,	'2019-03-16 03:59:51',	'Montgomery',	'Montgomery',	'Montgomery'),
(2642313,	77,	3333244,	'Монмут',	'Monmouth',	'Monmouth',	1,	32000,	'2019-03-16 03:59:51',	'Monmouth',	'Monmouth',	'Monmouth'),
(2642318,	77,	3333235,	'Monkton',	'Monkton',	'Monkton',	1,	31996,	'2019-03-16 03:59:51',	'Monkton',	'Monkton',	'Monkton'),
(2642319,	77,	3333158,	'Monkton',	'Monkton',	'Monkton',	1,	31994,	'2019-03-16 03:59:51',	'Monkton',	'Monkton',	'Monkton'),
(2642342,	77,	2657306,	'Monifieth',	'Monifieth',	'Monifieth',	1,	31988,	'2019-03-16 03:59:51',	'Monifieth',	'Monifieth',	'Monifieth'),
(2642369,	77,	2636512,	'Molesey',	'Molesey',	'Molesey',	1,	31846,	'2019-03-16 03:59:51',	'Molesey',	'Molesey',	'Molesey'),
(2642372,	77,	2649298,	'Mold',	'Mold',	'Mold',	1,	31843,	'2019-03-16 03:59:51',	'Mold',	'Mold',	'Mold'),
(2642377,	77,	2644667,	'Moira',	'Moira',	'Moira',	1,	31810,	'2019-03-16 03:59:51',	'Moira',	'Moira',	'Moira'),
(2642384,	77,	2650797,	'Moffat',	'Moffat',	'Moffat',	1,	31771,	'2019-03-16 03:59:51',	'Moffat',	'Moffat',	'Moffat'),
(2642401,	77,	3333242,	'Mochdre',	'Mochdre',	'Mochdre',	1,	31749,	'2019-03-16 03:59:51',	'Mochdre',	'Mochdre',	'Mochdre'),
(2642404,	77,	7290536,	'Mobberley',	'Mobberley',	'Mobberley',	1,	31743,	'2019-03-16 03:59:51',	'Mobberley',	'Mobberley',	'Mobberley'),
(2642412,	77,	2648402,	'Mitcheldean',	'Mitcheldean',	'Mitcheldean',	1,	31705,	'2019-03-16 03:59:51',	'Mitcheldean',	'Mitcheldean',	'Mitcheldean'),
(2642414,	77,	2648110,	'Мичам',	'Mitcham',	'Mitcham',	1,	31704,	'2019-03-16 03:59:51',	'Mitcham',	'Mitcham',	'Mitcham'),
(2642423,	77,	3333161,	'Mirfield',	'Mirfield',	'Mirfield',	1,	31659,	'2019-03-16 03:59:51',	'Mirfield',	'Mirfield',	'Mirfield'),
(2642433,	77,	2638655,	'Minsterley',	'Minsterley',	'Minsterley',	1,	31600,	'2019-03-16 03:59:51',	'Minsterley',	'Minsterley',	'Minsterley'),
(2642435,	77,	3333158,	'Minster',	'Minster',	'Minster',	1,	31599,	'2019-03-16 03:59:51',	'Minster',	'Minster',	'Minster'),
(2642447,	77,	2647716,	'Minffordd',	'Minffordd',	'Minffordd',	1,	31566,	'2019-03-16 03:59:51',	'Minffordd',	'Minffordd',	'Minffordd'),
(2642450,	77,	2637532,	'Minehead',	'Minehead',	'Minehead',	1,	31541,	'2019-03-16 03:59:51',	'Minehead',	'Minehead',	'Minehead'),
(2642452,	77,	2648402,	'Minchinhampton',	'Minchinhampton',	'Minchinhampton',	1,	31529,	'2019-03-16 03:59:51',	'Minchinhampton',	'Minchinhampton',	'Minchinhampton'),
(2642457,	77,	2637532,	'Milverton',	'Milverton',	'Milverton',	1,	31517,	'2019-03-16 03:59:51',	'Milverton',	'Milverton',	'Milverton'),
(2642465,	77,	3333173,	'Милтон-Кинс',	'Milton Keynes',	'Milton Keynes',	1,	31513,	'2019-03-16 03:59:51',	'Milton Keynes',	'Milton Keynes',	'Milton Keynes'),
(2642476,	77,	2653940,	'Milton',	'Milton',	'Milton',	1,	31505,	'2019-03-16 03:59:51',	'Milton',	'Milton',	'Milton'),
(2642477,	77,	2641429,	'Milton',	'Milton',	'Milton',	1,	31501,	'2019-03-16 03:59:51',	'Milton',	'Milton',	'Milton'),
(2642482,	77,	2651712,	'Milnthorpe',	'Milnthorpe',	'Milnthorpe',	1,	31485,	'2019-03-16 03:59:51',	'Milnthorpe',	'Milnthorpe',	'Milnthorpe'),
(2642486,	77,	3333234,	'Milnathort',	'Milnathort',	'Milnathort',	1,	31481,	'2019-03-16 03:59:51',	'Milnathort',	'Milnathort',	'Milnathort'),
(2642497,	77,	3333224,	'Milltimber',	'Milltimber',	'Milltimber',	1,	31460,	'2019-03-16 03:59:51',	'Milltimber',	'Milltimber',	'Milltimber'),
(2642503,	77,	3333232,	'Millport',	'Millport',	'Millport',	1,	31451,	'2019-03-16 03:59:51',	'Millport',	'Millport',	'Millport'),
(2642505,	77,	2651712,	'Millom',	'Millom',	'Millom',	1,	31449,	'2019-03-16 03:59:51',	'Millom',	'Millom',	'Millom'),
(2642514,	77,	2648110,	'Mill Hill',	'Mill Hill',	'Mill Hill',	1,	31392,	'2019-03-16 03:59:51',	'Mill Hill',	'Mill Hill',	'Mill Hill'),
(2642534,	77,	2640500,	'Milford Haven',	'Milford Haven',	'Milford Haven',	1,	31377,	'2019-03-16 03:59:51',	'Milford Haven',	'Milford Haven',	'Milford Haven'),
(2642537,	77,	2636512,	'Milford',	'Milford',	'Milford',	1,	31371,	'2019-03-16 03:59:51',	'Milford',	'Milford',	'Milford'),
(2642543,	77,	2636561,	'Mildenhall',	'Mildenhall',	'Mildenhall',	1,	31351,	'2019-03-16 03:59:51',	'Mildenhall',	'Mildenhall',	'Mildenhall'),
(2642567,	77,	2634258,	'Midhurst',	'Midhurst',	'Midhurst',	1,	31263,	'2019-03-16 03:59:51',	'Midhurst',	'Midhurst',	'Midhurst'),
(2642573,	77,	7290536,	'Middlewich',	'Middlewich',	'Middlewich',	1,	31262,	'2019-03-16 03:59:51',	'Middlewich',	'Middlewich',	'Middlewich'),
(2642593,	77,	3333188,	'Middleton',	'Middleton',	'Middleton',	1,	31242,	'2019-03-16 03:59:51',	'Middleton',	'Middleton',	'Middleton'),
(2642607,	77,	3333172,	'Мидлсбро',	'Middlesbrough',	'Middlesbrough',	1,	31237,	'2019-03-16 03:59:51',	'Middlesbrough',	'Middlesbrough',	'Middlesbrough'),
(2642615,	77,	2641209,	'Middleham',	'Middleham',	'Middleham',	1,	31232,	'2019-03-16 03:59:51',	'Middleham',	'Middleham',	'Middleham'),
(2642621,	77,	2637532,	'Middle Chinnock',	'Middle Chinnock',	'Middle Chinnock',	1,	31213,	'2019-03-16 03:59:51',	'Middle Chinnock',	'Middle Chinnock',	'Middle Chinnock'),
(2642639,	77,	2648402,	'Mickleton',	'Mickleton',	'Mickleton',	1,	31210,	'2019-03-16 03:59:51',	'Mickleton',	'Mickleton',	'Mickleton'),
(2642640,	77,	3333142,	'Mickleover',	'Mickleover',	'Mickleover',	1,	31208,	'2019-03-16 03:59:51',	'Mickleover',	'Mickleover',	'Mickleover'),
(2642642,	77,	2636512,	'Mickleham',	'Mickleham',	'Mickleham',	1,	31207,	'2019-03-16 03:59:51',	'Mickleham',	'Mickleham',	'Mickleham'),
(2642646,	77,	2636561,	'Mickfield',	'Mickfield',	'Mickfield',	1,	31205,	'2019-03-16 03:59:51',	'Mickfield',	'Mickfield',	'Mickfield'),
(2642683,	77,	3333143,	'Mexborough',	'Mexborough',	'Mexborough',	1,	31121,	'2019-03-16 03:59:51',	'Mexborough',	'Mexborough',	'Mexborough'),
(2642694,	77,	2649469,	'Methil',	'Methil',	'Methil',	1,	31080,	'2019-03-16 03:59:51',	'Methil',	'Methil',	'Methil'),
(2642702,	77,	2641455,	'Merton',	'Merton',	'Merton',	1,	30989,	'2019-03-16 03:59:51',	'Merton',	'Merton',	'Merton'),
(2642703,	77,	2640726,	'Merton',	'Merton',	'Merton',	1,	30991,	'2019-03-16 03:59:51',	'Merton',	'Merton',	'Merton'),
(2642705,	77,	3333243,	'Мертир Тидвил',	'Merthyr Tydfil',	'Merthyr Tydfil',	1,	30986,	'2019-03-16 03:59:51',	'Merthyr Tydfil',	'Merthyr Tydfil