<?php
$this->pageTitle = Yii::app()->name . ' - ' . tt('History changes', 'historyChanges');
$this->menu = array(
    array()
);
$this->adminTitle = tt('History changes', 'historyChanges');

?>

    <div class="form">
        <?php
        $form = $this->beginWidget('CustomForm', array(
            'id' => $this->modelName . '-form',
            'enableClientValidation' => false,
            'htmlOptions' => array('class' => 'well form-disable-button-after-submit'),
        ));

        ?>

        <?php echo $form->errorSummary($model); ?>

        <div class="form-group">
            <?php echo $form->labelEx($model, 'deleteHistoryAfterDays'); ?>
            <div>
                <?php echo $form->textField($model, 'deleteHistoryAfterDays', array('size' => 3, 'class' => 'form-control width200 noblock')); ?>
                &nbsp;<?php echo tt('days', 'blockIp'); ?>
            </div>
            <?php echo $form->error($model, 'deleteHistoryAfterDays'); ?>
        </div>

        <div class="form-group buttons">
            <?php
            echo AdminLteHelper::getSubmitButton(tc('Save'));

            ?>
        </div>
        <?php $this->endWidget(); ?>
    </div><!-- form -->
    <br/>

<?php
$this->widget('CustomGridView', array(
        'allowNoMoreTables' => true,
        'id' => 'history-changes-grid',
        'dataProvider' => $model->search(),
        'template' => "{summary}\n{pager}\n<div class='clear'></div>{items}\n{pager}",
        'filter' => $model,
        'afterAjaxUpdate' => 'function(){$("a[rel=\'tooltip\']").tooltip(); $("div.tooltip-arrow").remove(); $("div.tooltip-inner").remove(); jQuery("#HistoryChanges_date_created").datepicker(jQuery.extend(jQuery.datepicker.regional["' . Yii::app()->controller->datePickerLang . '"],{"showAnim":"fold","dateFormat":"yy-mm-dd","changeMonth":"true","showButtonPanel":"true","changeYear":"true"})); attachStickyTableHeader();}',
        'columns' => array(
            array(
                'name' => 'id',
                'htmlOptions' => array(
                    'data-title' => 'ID',
                ),
            ),
            array(
                'name' => 'date_created',
                'value' => 'HSite::convertDateToDateWithTimeZone($data->date_created)',
                'filter' => $this->widget('zii.widgets.jui.CJuiDatePicker', array(
                    'htmlOptions' => array('class' => 'form-control'),
                    'model' => $model,
                    'attribute' => 'date_created',
                    'language' => Yii::app()->controller->datePickerLang,
                    'options' => array(
                        'showAnim' => 'fold',
                        'dateFormat' => 'yy-mm-dd',
                        'changeMonth' => 'true',
                        'changeYear' => 'true',
                        'showButtonPanel' => 'true',
                    ),
                ), true),
                'htmlOptions' => array(
                    'class' => 'width130',
                    'data-title' => tc('Date created'),
                ),
            ),
            array(
                'name' => 'description',
                'value' => '$data->getDescr()',
                'type' => 'html',
                'htmlOptions' => array(
                    'data-title' => tt('Description', 'historyChanges'),
                ),
            ),
            array(
                'name' => 'field',
                'htmlOptions' => array(
                    'data-title' => tt('Database field', 'historyChanges'),
                ),
            ),
            array(
                'name' => 'model_name',
                'htmlOptions' => array(
                    'data-title' => tt('Model name', 'historyChanges'),
                ),
            ),
            array(
                'name' => 'model_id',
                'htmlOptions' => array(
                    'data-title' => tt('Model ID', 'historyChanges'),
                ),
            ),
            array(
                'name' => 'old_value',
                //'value' => 'HSite::markdown($data->old_value)',
                //'type' => 'html',
                'value' => '$data->old_value',
                'htmlOptions' => array(
                    'data-title' => tt('Old value', 'historyChanges'),
                ),
            ),
            array(
                'name' => 'new_value',
                //'value' => 'HSite::markdown($data->new_value)',
                //'type' => 'html',
                'value' => '$data->new_value',
                'htmlOptions' => array(
                    'data-title' => tt('New value', 'historyChanges'),
                ),
            ),
        ),
    )
);
