<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

class MainController extends ModuleAdminController
{

    public $modelName = 'HistoryChanges';

    public function init()
    {
        parent::init();

        if (!issetModule('historyChanges')) {
            throw404();
        }
    }

    public function accessRules()
    {
        return array(
            array('allow',
                'expression' => "Yii::app()->user->checkAccess('historyChanges_admin')",
            ),
            array('deny',
                'users' => array('*'),
            ),
        );
    }

    public function actionAdmin()
    {
        $model = new HistoryChanges('search');
        $model->setRememberScenario('historyChanges_remember');
        $this->rememberPage();

        $model->deleteHistoryAfterDays = param('delete_history_changes_after_days');

        if (isset($_POST[$this->modelName]) && isset($_POST[$this->modelName]['deleteHistoryAfterDays'])) {
            $model->scenario = 'upd_settings_day';
            $model->attributes = $_POST[$this->modelName];
            $model->setAttribute('deleteHistoryAfterDays', $_POST[$this->modelName]['deleteHistoryAfterDays']);

            if (!$model->deleteHistoryAfterDays)
                $model->setAttribute('deleteHistoryAfterDays', 1);

            if ($model->validate()) {
                ConfigurationModel::updateValue('delete_history_changes_after_days', $model->deleteHistoryAfterDays);

                Yii::app()->user->setFlash('success', tc('Success'));
            }
        }

        $this->render('admin', array(
            'model' => $model,
        ));
    }
}
