<?php
namespace application\modules\formeditor\repositories;

class SearchFormFieldParamRepository
{
    public function getOrCreateByField(string $field)
    {
        $model = \SearchFormFieldParam::model()->find('field=:field', [':field' => $field]);

        if(!$model){
            $model = new \SearchFormFieldParam();
            $model->field = $field;
            $model->json_data = \CJSON::encode($this->getDefaultParam());
            $model->save(false);
        }

        return $model;
    }

    public function getDefaultParam()
    {
        return [
            'type_deals' => array_keys(\HApartment::getTypesArray()),
        ];
    }
}