<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

class SearchController extends ModuleAdminController
{

    public $modelName = 'SearchFormModel';

    public function accessRules()
    {
        return array(
            array('allow',
                'expression' => "Yii::app()->user->checkAccess('all_modules_admin')",
            ),
            array('deny',
                'users' => array('*'),
            ),
        );
    }

    public function actionEditSearchForm()
    {
        $this->render('editSearchForm');
    }

    public function actionLoadElement()
    {
        $elements = SearchForm::getSearchFields();
        $elementsString = '';
        $inForm = '';

        $objTypeId = Yii::app()->request->getParam('id');
        $page = Yii::app()->request->getParam('page');

        // , array('group' => 'field') убрал т.к. у некоторых ругается на ONLY_FULL_GROUP_BY
        $elementsForm = SearchFormModel::model()
            ->sort()
            ->findAllByAttributes(array('obj_type_id' => $objTypeId, 'page' => $page));

        foreach ($elementsForm as $el) {
            $disabled = $el->status == SearchFormModel::STATUS_NOT_REMOVE ? ' ui-state-disabled' : '';

            $editLink = CHtml::link('<i title="'.tc('Edit').'" class="fa fa-edit"></i>', ['/formeditor/backend/search/editField', 'field' => $el->field], ['class' => 'tempModal2']);

            $inForm .= '<li key="' . $el->field . '" class="ui-state-default' . $disabled . '">' . $el->getLabel() . ' ' . $editLink . '</li>';
            if (isset($elements[$el->field])) {
                unset($elements[$el->field]);
            }
        }

        foreach ($elements as $field => $fieldParams) {
            $editLink = CHtml::link('<i title="'.tc('Edit').'" class="fa fa-edit"></i>', ['/formeditor/backend/search/editField', 'field' => $field], ['class' => 'tempModal2']);

            $elementsString .= '<li key="' . $field . '" class="ui-state-default">' . SearchFormModel::getLabelByField($field)  . ' ' . $editLink . '</li>';
        }

        echo CJSON::encode(array(
            'inForm' => $inForm,
            'elements' => $elementsString
        ));
    }

    public function actionEditField($field)
    {
        $repo = new \application\modules\formeditor\repositories\SearchFormFieldParamRepository();

        $model = $repo->getOrCreateByField($field);

        if(!$model){
            throw404();
        }

        if (isset($_POST['SearchFormFieldParam'])) {

            $model->attributes = $_POST['SearchFormFieldParam'];

            if ($model->save(false)) {
                Yii::app()->user->setFlash('success', tc('Success'));

                $this->redirect(array('editSearchForm'));
            }
        }

        $this->render('edit_field', ['model' => $model]);
    }

    public function actionSaveSort()
    {
        $objTypeId = Yii::app()->request->getParam('id', NULL);
        $page = Yii::app()->request->getParam('page', SearchFormModel::PAGE_INDEX);
        $sort = Yii::app()->request->getParam('sort');

        if (count($sort) >= param('searchMaxField', 15)) {
            HAjax::jsonError(tt('Search max field ') . param('searchMaxField', 3));
        }

        if ($objTypeId !== NULL && $sort && is_array($sort)) {
            $elements = SearchForm::getSearchFields();

            $sql = "DELETE FROM {{search_form}} WHERE obj_type_id=:id AND page=:page AND status!=:status";
            Yii::app()->db->createCommand($sql)->execute(array(
                ':id' => $objTypeId,
                ':page' => $page,
                ':status' => SearchFormModel::STATUS_NOT_REMOVE,
            ));

            $i = 3;
            foreach ($sort as $field) {
                if (!isset($elements[$field])) {
                    continue;
                }

                $search = new SearchFormModel();
                $search->attributes = array(
                    'obj_type_id' => $objTypeId,
                    'page' => $page,
                    'field' => $field,
                    'status' => $elements[$field]['status'],
                    'sorter' => $i,
                    'formdesigner_id' => isset($elements[$field]['formdesigner_id']) ? $elements[$field]['formdesigner_id'] : 0,
                );
                $search->save();
                $i++;
            }

            // delete assets js cache
            ConfigurationModel::clearGenerateJSAssets();

            HAjax::jsonOk();
        }

        HAjax::jsonError();
    }

    public function actionCopyElement()
    {
        $elements = SearchForm::getSearchFields();
        $elementsString = '';
        $inForm = '';

        $objTypeId = Yii::app()->request->getParam('id');
        $pageTo = Yii::app()->request->getParam('page');

        $pageFrom = $pageTo == SearchFormModel::PAGE_INDEX ? SearchFormModel::PAGE_INNER : SearchFormModel::PAGE_INDEX;

        $elementsForm = SearchFormModel::model()->sort()->findAllByAttributes(array('obj_type_id' => $objTypeId, 'page' => $pageFrom), array('group' => 'field'));

//        foreach($elementsForm as $el){
//            $elementsFormNew
//        }

        foreach ($elements as $field => $fieldParams) {
            $elementsString .= '<li key="' . $field . '" class="ui-state-default">' . SearchFormModel::getLabelByField($field) . '</li>';
        }

        echo CJSON::encode(array(
            'inForm' => $inForm,
            'elements' => $elementsString
        ));
    }
}
