<?php
$this->breadcrumbs = array(
    tt('Manage currency'),
);

$this->adminTitle = tt('Manage currency');

$this->menu = array(
    //array('label'=>tt("Add currency"), 'url'=>array('create')),
    AdminLteHelper::getAddMenuLink(tt("Add currency"), array('create')),
    AdminLteHelper::getPrimaryMenuLink(tt('Update currency now'), array('updateCurrency'), array(), 'fa fa-refresh'),
);

$apiRequiredIds = Currency::getApiKeyRequiredList();
$apiRequiredIdsJs = CJSON::encode($apiRequiredIds);
$currentSource = param('currencySource', 1);

echo '<div class="currency_source">';
echo '<h4>' . tt('Curency source') . '</h4>';
echo CHtml::radioButtonList('currency_source', $currentSource, Currency::getCurrencySourceList(), array('onclick' => 'changeCurrencySource($(this))'));
echo '</div>';
?>

<div class="well currency-api-key-form" style="display: <?php echo in_array($currentSource, $apiRequiredIds) ? 'block' : 'none'?>;">
    <div class="form-group">
        <h2><?php echo tt('API Key'); ?></h2>
    </div>
    <div class="form-group">
        <?php echo tt('API Key'); ?>:&nbsp;
        <input type="text" value="<?php echo param('currencySourceApiKey', '');?>" id="api_key" name="api_key" class="span3"/>
    </div>
    <div class="form-group">
        <?php
        $this->widget('bootstrap.widgets.TbButton', array('buttonType' => 'button',
            'type' => 'primary',
            'icon' => 'ok white',
            'label' => tc('Save'),
            'htmlOptions' => array(
                'onclick' => "saveCurrencyApiKey(); return false;",
            )
        ));

        ?>
    </div>
</div>


<?php
$this->widget('CustomGridView', array(
    'allowNoMoreTables' => true,
    'id' => 'currency-grid',
    'dataProvider' => $model->search(),
    'filter' => $model,
    'afterAjaxUpdate' => 'function(){$("a[rel=\'tooltip\']").tooltip(); $("div.tooltip-arrow").remove(); $("div.tooltip-inner").remove(); attachStickyTableHeader();}',
    'columns' => array(
        array(
            'header' => tc('Status'),
            'type' => 'raw',
            'value' => 'Yii::app()->controller->returnStatusHtml($data, "currency-grid", 1, Currency::getUsedCurrenciesIds())',
            'htmlOptions' => array(
                'class' => 'width50',
                'data-title' => tc('Actions'),
            ),
        ),
        array(
            'name' => 'is_default',
            'type' => 'raw',
            'value' => '$data->getIsDefaultHtml()',
            'filter' => false,
            'sortable' => false,
            'htmlOptions' => array(
                'class' => 'width100 center',
                'data-title' => tc('Actions'),
            ),
        ),
        array(
            'name' => 'char_code',
            'htmlOptions' => array(
                'data-title' => tt('Short name'),
            ),
        ),
        array(
            'header' => tc('Translate'),
            'value' => 'tt($data->char_code."_translate")',
            'htmlOptions' => array(
                'data-title' => tc('Translate'),
            ),
        ),
        array(
            'name' => 'value',
            'htmlOptions' => array(
                'data-title' => tt('Exchange rate'),
            ),
        ),
        array(
            'class' => 'bootstrap.widgets.BsButtonColumn',
            'template' => '{update} {delete}',
            'htmlOptions' => array('class' => 'infopages_buttons_column button_column_actions'),
        ),
    ),
));

?>

<?php
$this->widget('bootstrap.widgets.BsModal', array(
    'id' => 'myModal',
    'header' => tt('Set the default currency') . ' - <span id="set_char_code"></span>',
    'content' => '
		<input type="hidden" name="currency_id" id="currency_id" value="">
		<div class="form-group">' .
        CHtml::checkBox('convert_data', true) . '&nbsp;' .
        CHtml::label(tt('Convert the data in this currency?'), 'convert_data', array('class' => 'noblock')) .
        '</div>',
    'footer' => '<a href="#" class="btn btn-primary" onclick="saveChanges(); return false;">' . tt('Set default') . '</a>' .
        '<a href="#" class="btn btn-default" onclick="return false;", data-dismiss = "modal">' . tc('Close') . '</a>'
));

?>


<?php
Yii::app()->clientScript->registerScript('setDefCur', "
    function saveChanges(){
        var id = $('#currency_id').val();

        var convert_data = $('#convert_data:checked').val();
        $.ajax({
            type: 'POST',
            url: '" . Yii::app()->request->baseUrl . "/currency/backend/main/setDefault',
            data: { 'id' : id, 'convert_data' : convert_data },
			success: function(msg){
				$('#currency-grid').yiiGridView.update('currency-grid');
				$('#myModal').modal('hide');
			}
        });
        return;
    }", CClientScript::POS_END);

Yii::app()->clientScript->registerScript('setCurSource', "
	function changeCurrencySource(item) {
		var id = item.val();
        
        if ($.inArray(parseInt(id), $apiRequiredIdsJs) === 0) {
            $('.currency-api-key-form').show();
        } else {
            $('.currency-api-key-form').hide();
        }
		
		$.ajax({
            type: 'POST',
            url: '" . Yii::app()->request->baseUrl . "/currency/backend/main/setCurrencySource',
            data: { 'id' : id },
			success: function(msg){
				$('#currency-grid').yiiGridView.update('currency-grid');
			}
        });
	}
	
	function saveCurrencyApiKey() {
        if ($(\"#api_key\").val().length) {
            $.ajax({
                url: '" . Yii::app()->request->baseUrl . "/currency/backend/main/setCurrencySourceApiKey',
                type: 'POST',
                data: {\"api_key\": $(\"#api_key\").val()},
                success: function(msg){
                    $('#currency-grid').yiiGridView.update('currency-grid');
                }
            });
        } else {
            error('".tc('Enter the required value')."');
        }
    }
", CClientScript::POS_END);
