<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

class MainController extends ModuleUserController
{

    public $modelName = 'Api';

    public function behaviors()
    {
        if (issetModule('api')) {
            return array(
                'restAPI' => array('class' => '\rest\controller\Behavior')
            );
        }
        return array();
    }


    public function actionCountryLocationOptions()
    {
        $result = array();
        $result['data'] = null;
        $result['count'] = 0;

        if (issetModule('location')) {
            $result['data'] = Country::getCountriesArray();
            $result['count'] = count($result['data']);
        }

        $this->render('render_index', $result);
    }

    public function actionRegionLocationOptions()
    {
        $result = array();
        $result['data'] = null;
        $result['count'] = 0;

        $countryId = (int)Yii::app()->request->getParam('country_id');

        if (!$countryId) {
            throw new CHttpException(401, \Yii::t('common', 'Please send country_id'));
        }

        if (issetModule('location')) {
            $result['data'] = Region::getRegionsArray($countryId);
            $result['count'] = count($result['data']);
        }

        $this->render('render_index', $result);
    }

    public function actionCityLocationOptions()
    {
        $result = array();
        $result['data'] = null;
        $result['count'] = 0;

        $countryId = (int)Yii::app()->request->getParam('country_id');
        $regionId = (int)Yii::app()->request->getParam('region_id');

        if (!$countryId) {
            throw new CHttpException(401, \Yii::t('common', 'Please send country_id'));
        }
        if (!$regionId) {
            throw new CHttpException(401, \Yii::t('common', 'Please send region_id'));
        }

        if (issetModule('location')) {
            $result['data'] = City::getCitiesArray($regionId);
            $result['count'] = count($result['data']);
        }

        $this->render('render_index', $result);
    }

    public function actionCityOptions()
    {
        $result = array();
        $result['data'] = null;
        $result['count'] = 0;

        if (!issetModule('location')) {
            $result['data'] = ApartmentCity::getAllCity();
            $result['count'] = count($result['data']);
        }

        $this->render('render_index', $result);
    }

    public function actionTypeOptions()
    {
        $result = array();

        $result['data'] = HApartment::getTypesArray();
        $result['count'] = count($result['data']);

        $this->render('render_index', $result);
    }

    public function actionObjTypeOptions()
    {
        $result = array();

        $result['data'] = ApartmentObjType::getList();
        $result['count'] = count($result['data']);

        $this->render('render_index', $result);
    }

    public function actionPriceTypeOptions()
    {
        $result = $data = array();

        $types = HApartment::getTypesArray();
        if ($types) {
            foreach ($types as $typeId => $typeName) {
                $prices = HApartment::getPriceArray($typeId);
                if ($prices) {
                    $data[$typeId]['typeId'] = $typeId;
                    $data[$typeId]['typeName'] = $typeName;
                    $data[$typeId]['priceTypes'] = $prices;
                }
            }
        }

        $result['data'] = $data;
        $result['count'] = count($result['data']);

        $this->render('render_index', $result);
    }


    public function actionLangOptions()
    {
        $result = array();

        if (!isFree()) {
            $result['data'] = Lang::getActiveLangsTranslated();
        } else {
            $lang = Yii::app()->language;
            $result['data'] = array("{$lang}", "{$lang}");
        }
        $result['count'] = count($result['data']);

        $this->render('render_index', $result);
    }

    public function actionCurrencyOptions()
    {
        $result = array();
        $result['data'] = null;
        $result['count'] = 0;

        if (issetModule('currency')) {
            $result['data'] = Currency::getActiveCurrencyArray(2);
            $result['count'] = count($result['data']);
        }

        $this->render('render_index', $result);
    }

    public function actionOwnerStatusOptions()
    {
        $result = array();

        $result['data'] = Apartment::getApartmentsStatusArray();
        $result['count'] = count($result['data']);

        $this->render('render_index', $result);
    }

    public function actionStatusOptions()
    {
        $result = array();

        $result['data'] = Apartment::getModerationStatusArray();
        $result['count'] = count($result['data']);

        $this->render('render_index', $result);
    }
}
