<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentityRestApi extends CUserIdentity
{

    private $_id;

    /**
     * @var string login
     */
    public $login;
    /**
     * @var string token
     */
    public $token;

    public function __construct($login, $token)
    {
        $this->login = $login;
        $this->token = $token;
    }

    /**
     * Authenticates a user.
     * @return boolean whether authentication succeeds.
     */
    public function authenticate()
    {
        $user = User::model()->findByAttributes(array('api_token' => $this->token));

        if ($user === null) {
            throw new \CHttpException(401, \Yii::t('common', 'USER NOT FOUND.'));

            //$this->errorCode = self::ERROR_USERNAME_INVALID;
            //return 0;
        } elseif ($user->email != $this->login) {
            throw new \CHttpException(401, \Yii::t('common', 'UNDEFINED AUTH USER.'));

            //$this->errorCode = self::ERROR_USERNAME_INVALID;
            //return 0;
        } elseif (!$user->active) {
            throw new \CHttpException(401, \Yii::t('common', 'YOUR ACCOUNT IS NOT ACTIVE.'));

            //$this->errorCode = self::ERROR_UNKNOWN_IDENTITY;
            //return $this->errorCode == self::ERROR_UNKNOWN_IDENTITY;
        } elseif ($user->is_use_api == User::USE_API_NO) {
            throw new \CHttpException(401, \Yii::t('common', 'REST API UNAVAILABLE.'));

            //$this->errorCode = self::ERROR_UNKNOWN_IDENTITY;
            //return $this->errorCode == self::ERROR_UNKNOWN_IDENTITY;
        } else {
            $this->_id = $user->id;
            $this->username = $user->username;

            $this->setState('email', $user->email);
            $this->setState('username', $user->username);
            $this->setState('phone', $user->phone);
            $this->setState('is_from_api', 1);

            if ($user->role == User::ROLE_ADMIN) {
                $this->setState('isAdmin', 1);
            }

            if ($user->role == User::ROLE_MODERATOR) {
                $this->setState('isModerator', 1);
            }

            if (issetModule('rbac')) {
                $auth = Yii::app()->authManager;
                if (!$auth->isAssigned($user->role, $this->_id)) {
                    if ($auth->assign($user->role, $this->_id)) {
                        //Yii::app()->authManager->save();
                    }
                }
            } else {
                if ($user->role == User::ROLE_MODERATOR) {
                    $this->errorCode = self::ERROR_PASSWORD_INVALID;
                    return 0;
                }
            }

            $this->errorCode = self::ERROR_NONE;
        }
        return $this->errorCode == self::ERROR_NONE;
    }

    /**
     * @return integer the ID of the user record
     */
    public function getId()
    {
        return $this->_id;
    }
}
